/*var mouth = [];
var startMouthTime = 0.0;
var mouthFrame = 11;
function mouthLoad() {
	for (var i = 1; i <= 13; i++) {
		mouth.push(imageLoadImage("m_"+i+".png"));
	}
}

var endTime = 60*5;
var time = 0;
var clockDigits = "";
function getWeirdClockDigits() {
    var currentTime = getSceneTimeFromStart();
  var now = endTime - currentTime;
  var hour = Math.floor(now/60.0);
  var minute = "00" + Math.floor(now-(hour*60.0));

  clockDigits = hour + ":" + minute.substr(minute.length-2);

    return clockDigits;
}


function mouthRun(animation) {
	var i = Math.floor(Sync.getSyncValue('face:mouth_i'));
	if (i == 0) {
		var delay = Sync.getSyncValue('face:mouth_delay');
		if (Math.abs(startMouthTime-getSceneTimeFromStart()) > delay) {
			mouthFrame = Math.floor(Math.random()*mouth.length);
			startMouthTime = getSceneTimeFromStart();
		}
		i = mouthFrame;
	} else {
		i = (i % mouth.length) + 1;
	}

	var img = mouth[i];
	if (img.ptr) {animation.ref.ptr = img.ptr;}
}

Demo.prototype.init = function()
{
  Sync.addSync(
  [
    { "name":"fadeEnd", "type":"rocket" },
    { "name":"darkness", "type":"rocket" },
    { "name":"digit_a", "type":"rocket" },
    { "name":"face:eyelid_left_x", "type":"rocket" },
    { "name":"face:eyelid_left_y", "type":"rocket" },
    { "name":"face:eyelid_left_r", "type":"rocket" },
    { "name":"face:eyelid_right_x", "type":"rocket" },
    { "name":"face:eyelid_right_y", "type":"rocket" },
    { "name":"face:eyelid_right_r", "type":"rocket" },
    { "name":"face:eyebrow_left_x", "type":"rocket" },
    { "name":"face:eyebrow_left_y", "type":"rocket" },
    { "name":"face:eyebrow_left_r", "type":"rocket" },
    { "name":"face:eyebrow_right_x", "type":"rocket" },
    { "name":"face:eyebrow_right_y", "type":"rocket" },
    { "name":"face:eyebrow_right_r", "type":"rocket" },
    { "name":"face:mouth_x", "type":"rocket" },
    { "name":"face:mouth_y", "type":"rocket" },
    { "name":"face:mouth_s", "type":"rocket" },
    { "name":"face:mouth_i", "type":"rocket" },
    { "name":"face:mouth_delay", "type":"rocket" },
  ]);

  var end = 300;

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "bg.png"
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "eyes.png"
    ,"position":[{"x":getScreenWidth()*0.509,"y":getScreenHeight()*0.82}]
    ,"scale":[{"uniform2d":1.1}]
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "eyelid_left.png"
    ,"position":[{"x":"{return Sync.getSyncValue('face:eyelid_left_x')+getScreenWidth()*0.475;}","y":"{return Sync.getSyncValue('face:eyelid_left_y')+getScreenHeight()*0.9;}"}]
    ,"angle":[{"degreesZ":"{return Sync.getSyncValue('face:eyelid_left_r');}"}]
    ,"scale":[{"uniform2d":0.8}]
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "eyelid_right.png"
    ,"position":[{"x":"{return Sync.getSyncValue('face:eyelid_right_x')+getScreenWidth()*0.54;}","y":"{return Sync.getSyncValue('face:eyelid_right_y')+getScreenHeight()*0.9;}"}]
    ,"angle":[{"degreesZ":"{return Sync.getSyncValue('face:eyelid_right_r');}"}]
    ,"scale":[{"uniform2d":0.8}]
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "ville.png"
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "eyebrow_left.png"
    ,"position":[{"x":"{return Sync.getSyncValue('face:eyebrow_left_x')+getScreenWidth()*0.475;}","y":"{return Sync.getSyncValue('face:eyebrow_left_y')+getScreenHeight()*0.885;}"}]
    ,"angle":[{"degreesZ":"{return Sync.getSyncValue('face:eyebrow_left_r');}"}]
  });


  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "eyebrow_right.png"
    ,"position":[{"x":"{return Sync.getSyncValue('face:eyebrow_right_x')+getScreenWidth()*0.54;}","y":"{return Sync.getSyncValue('face:eyebrow_right_y')+getScreenHeight()*0.885;}"}]
    ,"angle":[{"degreesZ":"{return Sync.getSyncValue('face:eyebrow_right_r');}"}]
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "mouth.png"
    ,"position":[{"x":"{return Sync.getSyncValue('face:mouth_x')+getScreenWidth()*0.511;}","y":"{return Sync.getSyncValue('face:mouth_s')*Math.sin(getSceneTimeFromStart()*8.0)+Sync.getSyncValue('face:mouth_y')+getScreenHeight()*0.697;}"}]
  });

  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "m_13.png"
    ,"scale": [{"uniform2d": 1.2}]
    ,"position": [{"y":getScreenHeight()*0.706,"x":getScreenWidth()*0.509}]
    ,"initFunction":"{mouthLoad();}"
    ,"runFunction":"{mouthRun(animation);}"
  });


  this.loader.addAnimation ({
     "start": 0, "duration": end
    ,"image": "microphone.png"
    ,"scale": [{"uniform2d": 1.5}]
    ,"position": [{"y":getScreenHeight()*0.27,"x":getScreenWidth()*0.49}]
  });


    this.loader.addAnimation({
         "start": 0, "duration": end
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });
    this.loader.addAnimation(
    {
         "start": 0, "duration": end
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"{return getWeirdClockDigits();}"
        }
        ,"color": [
              {"r":0xFF,"g":0xFF,"b":0xFF, "a":"{return Sync.getSyncValue('digit_a');}"}
        ]
        ,"angle":[{"degreesZ":0}]
        ,"scale": [{"uniform2d":6.0}]
        ,"position":[
            {"x":getScreenWidth()*0.8,"y":getScreenHeight()*0.8}
        ]
    });

    this.loader.addAnimation({
         "start": 0, "duration": end
        ,"image": ["_embedded/defaultWhite.png"]
        ,"color":[{"a":"{return Sync.getSyncValue('darkness');}","r":0,"g":0,"b":0}]
    });
}
*/



var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

var particleMesh = void null;
function initParticles(animation) {
    particleMesh = new Mesh();

    var particleImage = new Image();
    particleImage.load("particle.png");
    particleMesh.setMaterialTexture(particleImage, 0);

    particleMesh.setFaceDrawType(POINTS);
/*
    for (var z = 0; z < 100; z++) {
        particleMesh.addVertex(Math.random()*60-30.0,Math.random()*50-25.0,-z/10.0+Math.random()-60);
    }*/

    var max = {"y":10.0,"x":10.0};
    var step = 1.0;
    var uvStep = {"y":step/max.y,"x":step/max.x};
    for(var y = 0; y < max.y; y+=step) {
        for(var x = 0; x < max.x; x+=step) {
            var z = 0;

            //heightMapMesh.addTexCoord(u, v);
            particleMesh.addVertex(x, y, z);
        }
    }

    particleMesh.generate();
}

function deinitParticles(animation) {
    particleMesh.delete();
}

function drawParticles(animation) {
    glPushMatrix();
    perspective2dEnd();
        
            glTranslatef(0,0,-5);// * getSceneTimeFromStart()*0.5);

    gl.enable(gl.BLEND);
    gl.disable(gl.DEPTH_TEST);
    gl.blendFunc(gl.ONE, gl.ONE);
    glColor4f(1,1,1,1);

    particleMesh.draw();
    gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
    gl.enable(gl.DEPTH_TEST);

    glPopMatrix();
}


function randVal(animation, i){
    return Math.random()-0.5*animation.data.rand[i]*Math.random();
}

var heightMapMeshes = [];
var heightMapTexture = void null;
var runwayTexture = void null;
function initHeightMap(animation) {
    heightMapMesh = new Mesh();
    if (heightMapMesh.ptr === void null) {
        loggerFatal("Could not initialize Mesh");
    }

    var precision = 24;

    heightMapTexture = new Image();
    heightMapTexture.load("distortionFbo.color.fbo");

    heightMapMesh.setMaterialTexture(heightMapTexture, 0);
    //heightMapMesh.setMaterialTexture(runwayTexture, 1);

    heightMapMesh.setFaceDrawType(TRIANGLES); // TRIANGLES


    var aspectRatio = 16.0/9.0;
    var max = {"y":100.0,"x":100.0};
    var step = animation.data.step;
    var stepY = step;
    var stepX = step;
    var uvStep = {"y":step/max.y,"x":step/max.x};
    for(var y = 0; y < max.y; y+=stepY) {
        for(var x = 0; x < max.x; x+=stepX) {
            var z = 0;
            var u = x/max.x;
            var v = y/max.y;

            var x1 = x + randVal(animation, 0);
            var y1 = y + randVal(animation, 1);
            var z1 = z + randVal(animation, 2);
            var x2 = x + randVal(animation, 0);
            var y2 = y + randVal(animation, 1);
            var z2 = z + randVal(animation, 2);
            var x3 = x + randVal(animation, 0);
            var y3 = y + randVal(animation, 1);
            var z3 = z + randVal(animation, 2);
            var x4 = x + randVal(animation, 0);
            var y4 = y + randVal(animation, 1);
            var z4 = z + randVal(animation, 2);
            var x5 = x + randVal(animation, 0);
            var y5 = y + randVal(animation, 1);
            var z5 = z + randVal(animation, 2);
            var x6 = x + randVal(animation, 0);
            var y6 = y + randVal(animation, 1);
            var z6 = z + randVal(animation, 2);

            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x1, y1, z1);

            //heightMapMesh.addTexCoord(u + uvStep.x, v + uvStep.y);
            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x2 + step, y2 + step, z2);

            //heightMapMesh.addTexCoord(u, v + uvStep.y);
            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x3, y3 + step, z3);

            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x4, y4, z4);

            //heightMapMesh.addTexCoord(u + uvStep.x, v);
            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x5 + step, y5, z5);

            //heightMapMesh.addTexCoord(u + uvStep.x, v + uvStep.y);
            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x6 + step, y6 + step, z6);
        }
    }

    heightMapMesh.generate();

    heightMapMeshes.push(heightMapMesh);

}

function deinitHeightMap(animation) {
    heightMapMeshes[animation.data.i].delete();
    //TODO: ummh... did i fix this and was there still need for manual cleanup?
    //well... i don't really five a fuck; you shouldn't either
    //texturedQuadDeinit(heightMapTexture.ptr);
    //texturedQuadDeinit(runwayTexture.ptr);
}

function drawHeightMap(animation, objI) {
    if (objI != animation.data.i) {
        return;
    }
/*    glPushMatrix();
    perspective2dEnd();

    //glTranslatef(-26,-2.1,0);// * getSceneTimeFromStart()*0.5);
    //glRotatef(-90,1,0,0);

    glTranslatef(-20,-20,-50);// * getSceneTimeFromStart()*0.5);

    heightMapMesh.draw();

    glPopMatrix();
*/
    glPushMatrix();
    perspective2dEnd();

    //glTranslatef(-50,-50,-10);// * getSceneTimeFromStart()*0.5);
    glTranslatef(-40,-50,-300);// * getSceneTimeFromStart()*0.5);

    //gl.enable(gl.BLEND);
    //gl.disable(gl.DEPTH_TEST);
    //gl.blendFunc(gl.ONE, gl.ONE);
    glColor4f(1,1,1,1);

    heightMapMeshes[animation.data.i].draw();
    //gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
    //gl.enable(gl.DEPTH_TEST);

    glPopMatrix();

}

var video = true;

Demo.prototype.init = function()
{
    /*Sync.addSync(
    [
        { "name":"fadeEnd", "type":"rocket" },
        { "name":"darkness", "type":"rocket" },
        { "name":"digit_a", "type":"rocket" },
        { "name":"face:eyelid_left_x", "type":"rocket" },
        { "name":"face:eyelid_left_y", "type":"rocket" },
    ]);*/

    var start = 0;
    var end   = 300;
    var layer = 0;


    this.loader.addAnimation([
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"bgFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["noise.png"]
        ,"shader":{"name":"bgplasma.fs", "variable":[
              {"name":"color1","value":[0,0,0,0]}
        ]}
        ,"color":[{"a":255}]
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"bgFbo","action":"unbind"}
    });


    this.loader.addAnimation([
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"fftFbo","action":"begin","storeDepth":false}
    }]);

    Sync.addSync(
    [
        { "name":"fft:zoom", "type":"rocket" },
        { "name":"fft:threshold", "type":"rocket" },
    ]);

    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["bgFbo.color.fbo","fft0"]
        ,"shader":{"name":"fft.fs"
            ,"variable": [
                 {"name":"zoom","value":["{return Sync.getSyncValue('fft:zoom');}"]}
                ,{"name":"threshold","value":["{return Sync.getSyncValue('fft:threshold');}"]}
            ]
        }
    });

    this.loader.addAnimation({
         "start": start, "duration": end
        ,"image": ["bgFbo.color.fbo"]
        ,"color":[{"a":50}]
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"fftFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"animationFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation({
         "start": start, "duration": end
        ,"image": ["fftFbo.color.fbo"]
        ,"shader":{"name":"tunnel.fs"}
        ,"color":[{"a":255}]
    });

    var clips = [
        {"name": "eye_01", "length": 11},
        {"name": "eye_01_glitch", "length": 11},
        {"name": "eye_02", "length": 8.5},
        {"name": "eye_02_glitch", "length": 8.5},
        {"name": "eye_03", "length": 25},
        {"name": "faces", "length": 10},
        {"name": "faces_glitch", "length": 10},
        {"name": "head", "length": 2},
        {"name": "head_glitch", "length": 2}
    ];

    for (var i  = 0; i < clips.length; i++) {
        var clip = clips[i];

        var imageData = clip.name + ".png";
        if (video) {
            imageData = {"name":clip.name+".ogv", "video":{"speed":(clip.speed||1.0), "loop":1, "length": clip.length}};
        }

        Sync.addSync(
        [
            { "name":clip.name+":pos_x", "type":"rocket" },
            { "name":clip.name+":pos_y", "type":"rocket" },
            { "name":clip.name+":rot_z", "type":"rocket" },
            { "name":clip.name+":scale_x", "type":"rocket" },
            { "name":clip.name+":scale_y", "type":"rocket" },
            { "name":clip.name+":color_a", "type":"rocket" },
        ]);

        this.loader.addAnimation ({
             "start": start, "duration": end, "layer": layer
            ,"image": imageData
            ,"position":[{"x":"{return Sync.getSyncValue('"+clip.name+":pos_x')+getScreenWidth()*0.5;}","y":"{return Sync.getSyncValue('"+clip.name+":pos_y')+getScreenHeight()*0.5;}"}]
            ,"angle":[{"degreesZ":"{return Sync.getSyncValue('"+clip.name+":rot_z');}"}]
            ,"scale":[{"x":"{return Sync.getSyncValue('"+clip.name+":scale_x');}","y":"{return Sync.getSyncValue('"+clip.name+":scale_y');}"}]
            ,"color":[{"a":"{return Sync.getSyncValue('"+clip.name+":color_a')*255.0;}"}]
        });
    }


    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"animationFbo","action":"unbind"}
    });



    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"distortionFbo","action":"begin", "storeDepth": false}
    });

    this.loader.addAnimation({
         "start": start, "duration": end, "layer": layer
        ,"image": ["animationFbo.color.fbo","animationFbo.depth.fbo"]
        ,"shader":{
            "name":"distortion.fs", "variable":[
                  {"name":"distortionResolutionX","value":[0.1]}
                 ,{"name":"distortionResolutionY","value":[0.1]}
                 ,{"name":"distortionX","value":[0]}
                 ,{"name":"distortionY","value":[0]}
                 ,{"name":"distortionSpeed","value":[20.0]}
                 ,{"name":"shakeSizeY","value":[0.000]}
                 ,{"name":"glitchSize","value":[0.0]}
                 ,{"name":"noiseAlpha","value":[0.0]}
            ]
        }
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"distortionFbo","action":"unbind"}
    });


    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"threeDeeFbo","action":"begin", "storeDepth": false}
    });


    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"starfield.fs"}
        ,"color":[{"a":100}]
    });

    Sync.addSync(
    [
        { "name":"heightmap:zPosition", "type":"rocket" },
        { "name":"heightmap:xPosition", "type":"rocket" },
        { "name":"heightmap:yPosition", "type":"rocket" },
        { "name":"heightmap:heightMagnitude", "type":"rocket" },
        { "name":"heightmap:distanceMagnitude", "type":"rocket" },
        { "name":"heightmap:twistRotate", "type":"rocket" },
        { "name":"heightmap:zRotate", "type":"rocket" },
        { "name":"heightmap:i", "type":"rocket" },
    ]);

    for(var i = 0; i < 5; i++) {
        this.loader.addAnimation({
             "start": start, "duration": end
            ,"layer": layer
            ,"data": [
                 {"i": i, "step": 0.5, "rand": [1.0,1.0,1.0]}
                ,{"i": i, "step": 0.5, "rand": [10.0,5.0,7.0]}
                ,{"i": i, "step": 2.0, "rand": [1.0,1.0,1.0]}
                ,{"i": i, "step": 3.0, "rand": [1.0,1.0,1.0]}
                ,{"i": i, "step": 5.0, "rand": [1.0,1.0,1.0]}
            ][i]
            ,"initFunction": "{initHeightMap(animation);}"
            ,"deinitFunction": "{deinitHeightMap(animation);}"
            ,"runFunction": "{drawHeightMap(animation, Sync.getSyncValue('heightmap:i'));}"
            ,"shader":{
                 "name":["heightmap.vs","heightmap.fs"]
                ,"variable":[
                     {"name":"zPosition","value":["{return Sync.getSyncValue('heightmap:zPosition');}"]}
                     ,{"name":"xPosition","value":["{return Sync.getSyncValue('heightmap:xPosition');}"]}
                     ,{"name":"yPosition","value":["{return Sync.getSyncValue('heightmap:yPosition');}"]}
                     ,{"name":"heightMagnitude","value":["{return Sync.getSyncValue('heightmap:heightMagnitude');}"]}
                     ,{"name":"distanceMagnitude","value":["{return Sync.getSyncValue('heightmap:distanceMagnitude');}"]}
                     ,{"name":"twistRotate","value":["{return Sync.getSyncValue('heightmap:twistRotate');}"]}
                     ,{"name":"zRotate","value":["{return Sync.getSyncValue('heightmap:zRotate');}"]}
                ]
            }
        });
    }


    this.loader.addAnimation(
    { 
         "start": start, "duration": end
        ,"layer": layer
        ,"fbo":{"name":"threeDeeFbo","action":"end"}
    });


    Sync.addSync(
    [
        { "name":"distort:distortionResolutionX", "type":"rocket" },
        { "name":"distort:distortionResolutionY", "type":"rocket" },
        { "name":"distort:distortionX", "type":"rocket" },
        { "name":"distort:distortionY", "type":"rocket" },
        { "name":"distort:distortionSpeed", "type":"rocket" },
        { "name":"distort:shakeSizeY", "type":"rocket" },
        { "name":"distort:glitchSize", "type":"rocket" },
        { "name":"distort:noiseAlpha", "type":"rocket" },
    ]);

    this.loader.addAnimation({
         "start": start, "duration": end, "layer": layer
        ,"image": ["threeDeeFbo.color.fbo","threeDeeFbo.depth.fbo"]
        ,"shader":{
            "name":"distortion.fs", "variable":[
                  {"name":"distortionResolutionX","value":["{return 0.01*Sync.getSyncValue('distort:distortionResolutionX');}"]}
                 ,{"name":"distortionResolutionY","value":["{return 0.01*Sync.getSyncValue('distort:distortionResolutionY');}"]}
                 ,{"name":"distortionX","value":["{return 1*Sync.getSyncValue('distort:distortionX');}"]}
                 ,{"name":"distortionY","value":["{return 1*Sync.getSyncValue('distort:distortionY');}"]}
                 ,{"name":"distortionSpeed","value":["{return 1*Sync.getSyncValue('distort:distortionSpeed');}"]}
                 ,{"name":"shakeSizeY","value":["{return 0.01*Sync.getSyncValue('distort:shakeSizeY');}"]}
                 ,{"name":"glitchSize","value":["{return 1*Sync.getSyncValue('distort:glitchSize');}"]}
                 ,{"name":"noiseAlpha","value":["{return 1*Sync.getSyncValue('distort:noiseAlpha');}"]}
            ]
        }
        ,"color":[{"a":150}]
    });

    this.loader.addAnimation({
         "start": start, "duration": end, "layer": layer
        ,"image": ["threeDeeFbo.color.fbo","threeDeeFbo.depth.fbo"]
        ,"shader":{
            "name":"pixelate.fs"
        }
        ,"color":[{"a":70}]
    });


/*
    this.loader.addAnimation([{
         "start": start, "duration": end
        ,"layer": layer
        ,"initFunction": "{initParticles(animation);}"
        ,"deinitFunction": "{deinitParticles(animation);}"
        ,"runFunction": "{drawParticles(animation);}"
        ,"shader":{"name":["particles.vs","particles.gs","particles.fs"]}
    }]);
*/

    /*this.loader.addAnimation({
         "start": start, "duration": end
        ,"image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"bgplasma.fs", "variable":[
              {"name":"color1","value":[15,10,10,0]}
        ]}
        ,"color":[{"a":100}]
    });*/

    this.loader.addAnimation({
         "start": start, "duration": end
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });

}
