#version 330 core

#define M_PI 3.1415926535897932384626433832795
#define BG_CIRCLES 1
#define BG_SPOT 2
#define BG_SPIRAL 3

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);

uniform float time = 1.0;
uniform float fade = 0.1;
uniform vec2 position = vec2(-0.5, -0.5);
uniform vec4 backgroundColor = vec4(0,0,0,0);

uniform int background = BG_SPIRAL;

//BG_SPIRAL uniforms
uniform float curveThickness = 0.5;
uniform float curveBendDegrees = 70;
uniform float curvesDegrees = 90;


vec2 pixelate(vec2 coord)
{
    vec2 d = vec2(1.0,1.0)/(vec2(1920.0,1080.0)*0.03);
    coord.s = floor(coord.s/d.s)*d.s;
    coord.t = floor(coord.t/d.t)*d.t;
    return coord;    
}


void main()
{
    float time2 = time/60.0*120.0;
    if (mod(time2, 2.0) >= 1.0) {
        time2 = 0.0; 
    } else {
        time2 *= 0.24;
    }
    vec2 coord=pixelate(texCoord.xy);

    float x = coord.x;
    float y = coord.y;
    float d = sqrt(x*x + y*y);

    vec4 col = backgroundColor;
    if (background == BG_CIRCLES)
    {
        x = position.x+coord.x;
        y = position.y+coord.y;
        d = sqrt(x*x + y*y);
        d = sin(d*40-time2*25.5)*1.5;
        col = vec4(d);
        col.a = 0.9*distance(coord, vec2(0.5));
    }
    else if (background == BG_SPOT)
    {
        float cx = position.x+x;
        float cy = position.y+y;
        float circle = 1.0/sqrt(cx*cx + cy*cy);

        d = 0;
        //if (circle > 3.0)
        {
            float size = 2.5-sqrt(cx*cx + cy*cy)*(10*sin(time2*3));
            d = sin(sqrt(x*x)*100)*1.44*size+cos(sqrt(y*y)*100)*1.2*size*color.a;
        }
        col = vec4(d);
    }
    else if (background == BG_SPIRAL)
    {
        coord += position;
        float curveBendRad = radians(curveBendDegrees);
        float curvesRad = radians(curvesDegrees);
        float bend = curveBendRad*log(length(coord));
        float d = mod((time*1.5)+atan(coord.x,coord.y)+bend, curvesRad);
        if (d < curvesRad*curveThickness)
        {
            float cx = position.x+x;
            float cy = position.y+y;
            float circle = 1.0/sqrt(cx*cx + cy*cy);

            float d2 = 0;
            float size = 1.5-sqrt(cx*cx + cy*cy)*(10*sin(time*5.5));
            //d2 = sin(sqrt(x*x)*80)*1.5*size+cos(sqrt(y*y)*80)*1.2*size;
            //d += 0.15*d2;

            col = vec4(1);
            //color.a *= 0.75;

        }


    }

    fragColor = vec4(col.r,col.g,col.b,col.a) * color;
}
