// "Bebas Neue version 2.000 (2018)" font by Ryoichi Tsunekawa is licensed under SIL Open Font License v1.1 (see http://bebasfont.com/ and https://opensource.org/licenses/OFL-1.1)

// https://www.color-hex.com/color-palette/21989 - joker
// #ab5dee (171,93,238) [0.6705, 0.3647, 0.9333],
// #be80ff (190,128,255) [0.7450, 0.5019, 1.0],
// #1da11f (29,161,31) [0.1137,  0.6313, 0.1215],
// #1ddd33 (29,221,51) [0.1137, 0.8666, 0.2],
// #c5c5c5 (197,197,197) [0.7725, 0.7725, 0.7725],

// https://www.color-hex.com/color-palette/18062
// #fdff00 (253,255,0) [0.9921, 1.0, 0.0],
// #988829 (152,136,41)  [0.5960, 0.5333, 0.1607],
// #242424 (36,36,36) [0.1411, 0.1411, 0.1411],
// #282e3c (40,46,60) [0.1568, 0.1803, 0.2352],
// #505c7c (80,92,124) [0.3137, 0.3607, 0.4862],

// https://www.color-hex.com/color-palette/26950
// #c7c7c7 (199,199,199) [0.7803, 0.7803, 0.7803],
// #0fc3ff (15,195,255) [0.0588, 0.7647, 1.0],
// #ffff36 (255,255,54) [1.0, 1.0, 0.2117],
// #000000 (0,0,0) [0.0, 0.0, 0.0],
// #ffeac9 (255,234,201) [1.0, 0.9176, 0.7882],

var colorSchemes = [
    [
        [0.6705, 0.3647, 0.9333],
        [0.7450, 0.5019, 1.0],
        [0.1137,  0.6313, 0.1215],
        [0.1137, 0.8666, 0.2],
        [0.7725, 0.7725, 0.7725]
    ],
    [
        [0.9921, 1.0, 0.0],
        [0.5960, 0.5333, 0.1607],
        [0.1411, 0.1411, 0.1411],
        [0.1568, 0.1803, 0.2352],
        [0.3137, 0.3607, 0.4862]
    ],
    [
        [0.7803, 0.7803, 0.7803],
        [0.0588, 0.7647, 1.0],
        [1.0, 1.0, 0.2117],
        [0.0, 0.0, 0.0],
        [1.0, 0.9176, 0.7882]
    ]
];



/*
        _____                       _______         
   sAk  \    \     ______  _________\___   \     
  ______/    / ____\     \/       /   _|    \      
  \    /    /\ |                      \|     \     
  /________/  \|    /____\/     /\____________\    
    _     \_________|    /______\         _       
    //____________  ____  __  _______  __\\______  ___  _____  _______  __ _
    /               \   \ ____\___   \_____  ______\  \___ ____\___   \
                    /   / \     _|    \    \ |     /   __/ \     _|    \
                   /   /___\    \|     \    \|        /_____\    \|     \
                  /   /       ___________________/   /       ____________\
                  \__________/                   \__________/
                                                                            _
 _ _               __ __________________________________________________ _   \
 //  info      _ _/ ___________________________________________________ _/  _/
 /       _____/                                                         \___\

                               Jumalauta presents:
                                     NOUSEE
                                                                            _
 _ _               __ __________________________________________________ _   \
 //  credits   _ _/ ___________________________________________________ _/  _/
 /       _____/                                                         \___\

                     Code: Haluttu maksullinen nainen
                     Music: Ylvaes

                     "Bebas Neue version 2.000 (2018)" font
                        by Ryoichi Tsunekawa is licensed under
                        SIL Open Font License v1.1 (http://bebasfont.com/)

                     Fair use of DC Comics Batman stuff
                     Fair use of memes
                     Copyright for those whom the copyright belongs
                                                                            _
 _ _               __ __________________________________________________ _   \ 
 //  joining   _ _/ ___________________________________________________ _/  _/
 /       _____/                                                         \___\

                 We are always on the lookout for new talent.
                                                                            _
 _ _               __ __________________________________________________ _   \ 
 //  greetings _ _/ ___________________________________________________ _/  _/
 /       _____/                                                         \___\

             Jumalauta sends our love and respect to the following people:
                           Batman group
                           iSO
                           Nalleperhe
                           Aatekorjaamo
                           Wamma
                           Äärikeskusta


               Have we mentioned our love towards Batman Group yet?

     -- ---------------------------------------------------------------- --

                        .NFO (c) sAk/jML 2001-2023

     -- ---------------------------------------------------------------- --

            JL is so uptight but jML ever so cool!
*/

var start      = 0;
var end        = 300;
var duration   = 300;
var layer      = 0;

Demo.prototype.sceneIntro = function(start, duration)
{
    Sync.addSync(
    [
        { "name":"intro:tire_speed", "type":"rocket" },
        { "name":"intro:sky_x", "type":"rocket" },
        { "name":"intro:sky_y", "type":"rocket" },
        { "name":"intro:sky_bias", "type":"rocket" },
        { "name":"intro:skyline_x", "type":"rocket" },
        { "name":"intro:skyline_y", "type":"rocket" },
        { "name":"intro:skyline_bias", "type":"rocket" },
        { "name":"intro:jmlman_bias", "type":"rocket" },
        { "name":"intro:jmlman_shift", "type":"rocket" },
        { "name":"intro:front_bias", "type":"rocket" },
    ]);



    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["textFbo.color.fbo"]
    });

    var cityStart = start+8;
    this.loader.addAnimation({
         "start": cityStart, "duration": duration
        ,"layer": layer
        ,"image": ["clouds_01.png"]
        ,"scale": [{"uniform2d":4.0}]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":"{return [Sync.getSyncValue('intro:sky_bias')]; /*4.0*/}"}
        ]}
        ,"color":[{"a":0},{"duration":2,"a":255}]
        ,"position":[
             {"x":"{return getScreenWidth()*Sync.getSyncValue('intro:sky_x'); /*0.5-0.4*/}", "y":"{return getScreenHeight()*Sync.getSyncValue('intro:sky_y'); /*2.4-2.9*/}"}
        ]
    }); 
    

    var batMobileStart = cityStart + 3;
    this.loader.addAnimation({
         "start": batMobileStart+2, "duration": duration-(batMobileStart+2)
        ,"layer": layer
        ,"layer": layer, "image": ["jmlman.png","jml_fist.png"]
        ,"shader":{"name":"logoTransition.fs", "variable": [
             {"name":"shift", "value":"{return [Sync.getSyncValue('intro:jmlman_shift')*((Math.sin(getSceneTimeFromStart()*6.0)+1.0)/2.0)];}"}
            ,{"name":"textureBias","value":"{return [Sync.getSyncValue('intro:jmlman_bias')]; /*2.0*/}"}
        ]}
        ,"position":[
            {"x":getScreenWidth()*0.88,"y":getScreenHeight()*0.78}
        ]
        ,"scale":[{"uniform2d":0.5}]
        ,"color":[{"a":0,"r":180,"g":180,"b":180},{"duration":2,"a":255}]
    });

    this.loader.addAnimation({
         "start": cityStart, "duration": duration-cityStart
        ,"layer": layer
        ,"image": ["skyline.png"]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":"{return [Sync.getSyncValue('intro:sky_bias')]; /*3.0*/}"}
        ]}
        ,"color":[{"a":0,"r":80,"g":80,"b":80},{"duration":2,"a":255}]
        ,"position":[
            {"x":"{return getScreenWidth()*Sync.getSyncValue('intro:skyline_x'); /*0.7-0.5*/}", "y":"{return getScreenHeight()*Sync.getSyncValue('intro:skyline_y'); /*0.0-0.5*/}"}
        ]
    });

    this.loader.addAnimation({
         "start": batMobileStart+4.5, "duration": duration-(batMobileStart+4.5)
        ,"layer": layer
        ,"image": ["dude_1.png"]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":"{return [Sync.getSyncValue('intro:front_bias')]; /*0.0*/}"}
        ]}
        ,"position":[
            {"x":getScreenWidth()*0.29,"y":getScreenHeight()*0.17}
        ]
        ,"scale":[{"uniform2d":0.25}]
        ,"color":[{"a":0},{"duration":2,"a":255}]
    });

    this.loader.addAnimation({
         "start": batMobileStart, "duration": duration-batMobileStart
        ,"layer": layer
        ,"image": ["batmobile.png"]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":"{return [Sync.getSyncValue('intro:front_bias')]; /*0.0*/}"}
        ]}
        ,"position":[{"x":getScreenWidth()*-0.3,"y":getScreenHeight()*0.1}
            ,{"duration":2, "x":getScreenWidth()*0.3}
        ]
    });

    this.loader.addAnimation({
         "start": batMobileStart, "duration": duration-batMobileStart
        ,"layer": layer
        ,"image": ["batmobiletire.png"]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":"{return [Sync.getSyncValue('intro:front_bias')]; /*0.0*/}"}
        ]}
        ,"position":[
                {"x":getScreenWidth()*(0.17-0.6),"y":getScreenHeight()*0.06}
                ,{"duration":2, "x":getScreenWidth()*0.17}
        ]
        ,"color":[{"a":150}]
        ,"angle":[{"degreesZ":"{return Sync.getSyncValue('intro:tire_speed');}"}]
    });

    this.loader.addAnimation({
         "start": batMobileStart, "duration": duration-batMobileStart
        ,"layer": layer
        ,"image": ["batmobiletire.png"]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":"{return [Sync.getSyncValue('intro:front_bias')]; /*0.0*/}"}
        ]}
        ,"position":[
            {"x":getScreenWidth()*(0.45-0.6),"y":getScreenHeight()*0.052}
            ,{"duration":2, "x":getScreenWidth()*0.45}
        ]
        ,"scale":[{"uniform2d":0.94}]
        ,"color":[{"a":150}]
        ,"angle":[{"degreesZ":"{return 37+Sync.getSyncValue('intro:tire_speed');}"}]
    });


    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["_embedded/defaultWhite.png"]
        ,"color":[{"a":0,"r":0,"g":0,"b":0},{"duration":duration-2},{"a":255, "duration":2}]
    });
 
}


// ffmpeg -i batman-party-hard.gif -vsync 0 batman-party-hard-%d.png
function loadPngAnimation(animationObject) {
    animationObject.images = [];
    animationObject.i = void null;
    if (!animationObject.fps) {
        animationObject.fps = 30;
    }

    animationObject.frameDelay = 1.0 / animationObject.fps;

    for (var i = 1; i <= animationObject.frames; i++) {
        var image = new Image();
        image.load(animationObject.prefix + i + ".png");
        animationObject.images.push(image);
    }
}

function playPngAnimation(animation) {
    var timeNow = getSceneTimeFromStart();
    if (animation.animationObject.i === void null) {
        animation.animationObject.i = 0;
        animation.animationObject.startTime = timeNow;
        animation.animationObject.frameStartTime = animation.animationObject.startTime;
    }

    if (Math.abs(timeNow-animation.animationObject.frameStartTime) >= animation.animationObject.frameDelay) {
        animation.animationObject.i = (animation.animationObject.i+1)%animation.animationObject.frames;
        animation.animationObject.frameStartTime = timeNow;
    }

    animation.ref.ptr = animation.animationObject.images[animation.animationObject.i].ptr;
}


var batmanAndJoker = {
    prefix: 'anim/batman-and-joker/batman-and-joker-',
    frames: 8,
    fps: 8
};


var batmanPartyHard = {
    prefix: 'anim/batman-party-hard/batman-party-hard-',
    frames: 42,
    fps: 10
};


var batmanDance = {
    prefix: 'anim/batman-dance/batman-dance-',
    frames: 41,
    fps: 20
};

var soiniThumbs = {
    prefix: 'anim/soini-thumbs/soini-thumbs-',
    frames: 114,
    fps: 20
};


Demo.prototype.sceneEnd = function()
{
    this.loader.addAnimation({
         "start": 60+52, "duration":30
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[2][3]}
              ,{"name":"color2","value":colorSchemes[2][2]}
        ]}
        ,"color":[{"a":255}]
    });

    this.loader.addAnimation({
         "start": 60+52, "duration": 8, "layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"randomFlow.fs"}
        ,"scale":[{"x":0.2}]
        ,"position":[{"x":getScreenWidth()*0.10, "y":getScreenHeight()*0.5}]
         ,"color":[{"a":0},{"duration":0.25,"a":150},{"duration":7.5},{"duration":0.25,"a":0}]
    });

    this.loader.addAnimation ({
         "start": 60+52, "duration": 8, "layer": layer
         ,"image": "anim/batman-and-joker/batman-and-joker-1.png"
         ,"animationObject": batmanAndJoker
         ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
         ,"runFunction":"{playPngAnimation(animation);}"
         ,"scale":[{"uniform2d":2.0}]
         ,"color":[{"a":0},{"duration":0.25,"a":255},{"duration":7.5},{"duration":0.25,"a":0}]
        ,"shader":{"name":"colorcycle.fs", "variable":[
              {"name":"shift","value":[0.0]}
        ]}
    });

    this.loader.addAnimation(
    {
         "start": 60+52, "duration": 8, "layer": layer
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'Batman Group';}"
        }
        ,"scale": [{"uniform2d":2.0}]
        ,"position":[
            {"x":getScreenWidth()*0.56,"y":getScreenHeight()*0.68}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
         ,"color":[{"a":0},{"duration":0.25,"a":255},{"duration":7.5},{"duration":0.25,"a":0}]
    });

    this.loader.addAnimation(
    {
         "start": 60+52, "duration": 8, "layer": layer
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'JML';}"
        }
        ,"scale": [{"uniform2d":4.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.22}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
         ,"color":[{"a":0},{"duration":0.25,"a":255},{"duration":7.5},{"duration":0.25,"a":0}]
    });


    this.loader.addAnimation(
    {
         "start": 119.75, "duration": 10
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'JUMALAUTA';}"
        }
        ,"scale": [{"uniform2d":15.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":0.25,"a":255}]
    });
}

Demo.prototype.sceneMoreBass = function(start, duration)
{
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"spiral.fs","variable":[
            {"name":"background","type":"int","value":[3]}
        ]}
        ,"color":[{"a":255}]
    });

    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["dude_1.png"]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*-0.3}
            ,{"duration":3, "x":getScreenWidth()*0.5,"y":getScreenHeight()*0.3}
        ]
        ,"scale":[{"uniform2d":1.5}]
        ,"color":[{"a":255},{"duration":duration-1},{"duration":1, "a":0}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'LISÄÄ OIKEUDENMUKAISUUTTA';}"
        }
        ,"scale": [{"uniform2d":8.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration": 6},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
    });

    /*this.loader.addAnimation(
    {
         "start": start+9, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'LISÄÄ JUMALAUTAA';}"
        }
        ,"scale": [{"uniform2d":12.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":0.1,"a":255},{"duration":3.8},{"duration":0.1,"a":0}]
    });*/
}

/*

*/
Demo.prototype.sceneGreets = function(start, duration)
{
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[2][3]}
              ,{"name":"color2","value":colorSchemes[2][2]}
        ]}
        ,"color":[{"a":255}]
    });

    /*this.loader.addAnimation({
         "start": start, "duration": duration, "layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"randomFlow.fs"}
        ,"scale":[{"y":0.43, "x":3.0}]
        ,"position":[{"x":getScreenWidth()*0.10, "y":getScreenHeight()*0.5}]
        ,"color":[{"a":0},{"duration":1.0,"a":120},{"duration":duration-2.0},{"duration":1.0,"a":0}]
    });*/

    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png","fft0"]
        ,"shader":{"name":"fft.fs"
            //,"variable": [
            //     {"name":"zoom","value":["{return Sync.getSyncValue('fft:zoom');}"]}
            //    ,{"name":"threshold","value":["{return Sync.getSyncValue('fft:threshold');}"]}
            //]
        }
        ,"color":[{"a":100}]
    });

    /*this.loader.addAnimation({
         "start": start, "duration": duration, "layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"randomFlow.fs"}
        ,"scale":[{"y":0.014, "x":0.095}]
        ,"position":[{"x":getScreenWidth()*0.30, "y":getScreenHeight()*0.08}]
        ,"color":[{"a":0},{"duration":1.0,"a":255},{"duration":duration-2.0},{"duration":1.0,"a":0}]
    });*/

    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer, "image": ["jmlman.png","jml_fist.png"]
        ,"shader":{"name":"logoTransition.fs", "variable": [
            {"name":"shift", "value":"{return [(Math.sin(getSceneTimeFromStart()*6.0)+1.0)/2.0];}"}
        ]}
        ,"color":[{"a":0},{"duration":1.0,"a":255},{"duration":duration-2.0},{"duration":1.0,"a":0}]
    });

    var groups = [
        'Batman group',
        'Jumalauta',
        'iSO',
        'Nalleperhe',
        'Aatekorjaamo',
        'Wamma',
        'Äärikeskusta',
        'Matt Current',
        'U+1F35E',
        'RBBS'
    ];

    for (var i = 0; i < groups.length; i++) {
        this.loader.addAnimation(
        {
             "start": start+i*1.5+2, "duration": 1.5
            ,"layer": layer
            ,"text":{
                 "name":"BebasNeue-Regular.ttf"
                ,"string":groups[i]
            }
            ,"scale": [{"uniform2d":15.0}]
            ,"position":[
                {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
            ]
            ,"shader":{"name":"biasTex.fs", "variable":[
                  {"name":"textureBias","value":[0.0]}
            ]}
            ,"color":[{"a":180}]
        });
    }

    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'THE HERO WE DESERVE';}"
        }
        ,"scale": [{"uniform2d":8.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.85}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":1.0,"a":255},{"duration":duration-2.0},{"duration":1.0,"a":0}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'BUT NOT THE HERO WE NEED';}"
        }
        ,"scale": [{"uniform2d":8.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.15}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":1.0,"a":255},{"duration":duration-2.0},{"duration":1.0,"a":0}]
    });

}


Demo.prototype.sceneSpikeBall = function(start, duration)
{
    Sync.addSync(
    [
        { "name":"ray:rotx", "type":"rocket" },
        { "name":"ray:roty", "type":"rocket" },
        { "name":"ray:rotz", "type":"rocket" },
        { "name":"ray:x", "type":"rocket" },
        { "name":"ray:y", "type":"rocket" },
        { "name":"ray:z", "type":"rocket" },
        { "name":"ray:pixres", "type":"rocket" },
        { "name":"ray:twistSkew", "type":"rocket" },
    ]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[2][1]}
              ,{"name":"color2","value":colorSchemes[2][2]}
        ]}
        ,"color":[{"a":255}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"spiral.fs", "variable":[
            {"name":"background","type":"int","value":[1]}
        ]}
        ,"color":[{"a":30}]
    });

    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"raymarch.fs", "variable":[
            {"name":"scene", "type":"int", "value":[1]}
            ,{"name":"shift","value":[0.0]}
            ,{"name":"color1","value":colorSchemes[2][2]}
            ,{"name":"color2","value":colorSchemes[2][2]}
            ,{"name":"rotateDegrees","value":"{ return [Sync.getSyncValue('ray:rotx'),Sync.getSyncValue('ray:roty'),Sync.getSyncValue('ray:rotz')]}"}
            ,{"name":"movePosition","value":"{ return [Sync.getSyncValue('ray:x'),Sync.getSyncValue('ray:y'),Sync.getSyncValue('ray:z')]}"}
            ,{"name":"pixelateResolution","value":"{ return [Sync.getSyncValue('ray:pixres')]}"}
            ,{"name":"twistSkew","value":"{ return [Sync.getSyncValue('ray:twistSkew')]}"}
            ]}
        ,"color":[{"a":255}]
    });
    this.loader.addAnimation({
         "start": start, "duration": duration
         ,"layer": layer
        ,"image": ["dude_2.png"]
        ,"position":[
            {"x":getScreenWidth()*-0.63,"y":getScreenHeight()*0.4}
            ,{"duration":3,"x":getScreenWidth()*0.13,"y":getScreenHeight()*0.4}
        ]
        ,"color":[{"a":255},{"duration":duration-1},{"duration":1, "a":0}]
    });
}


Demo.prototype.sceneSyncBoxes = function(start, duration)
{
    Sync.addSync(
    [
        { "name":"ray:boxrotx", "type":"rocket" },
        { "name":"ray:boxroty", "type":"rocket" },
        { "name":"ray:boxrotz", "type":"rocket" },
        { "name":"ray:box2rotx", "type":"rocket" },
        { "name":"ray:box2roty", "type":"rocket" },
        { "name":"ray:box2rotz", "type":"rocket" },
        { "name":"ray:boxmovex", "type":"rocket" },
        { "name":"ray:boxmovey", "type":"rocket" },
        { "name":"ray:boxmovez", "type":"rocket" },
    ]);

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[0][1]}
              ,{"name":"color2","value":colorSchemes[0][2]}
        ]}
        ,"color":[{"a":255}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"spiral.fs", "variable":[
            {"name":"background","type":"int","value":[2]}
        ]}
        ,"color":[{"a":10}]
    });

    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"raymarch.fs", "variable":[
            {"name":"scene", "type":"int", "value":[2]}
            ,{"name":"shift","value":[0.0]}
            ,{"name":"color1","value":colorSchemes[0][2]}
            ,{"name":"color2","value":colorSchemes[0][2]}
            ,{"name":"rotateDegrees","value":"{ return [Sync.getSyncValue('ray:rotx'),Sync.getSyncValue('ray:roty'),Sync.getSyncValue('ray:rotz')]}"}
            ,{"name":"movePosition","value":"{ return [Sync.getSyncValue('ray:x'),Sync.getSyncValue('ray:y'),Sync.getSyncValue('ray:z')]}"}
            ,{"name":"pixelateResolution","value":"{ return [Sync.getSyncValue('ray:pixres')]}"}
            ,{"name":"twistSkew","value":"{ return [Sync.getSyncValue('ray:twistSkew')]}"}
            ,{"name":"boxRotateDegrees","value":"{ return [Sync.getSyncValue('ray:boxrotx'),Sync.getSyncValue('ray:boxroty'),Sync.getSyncValue('ray:boxrotz')]}"}
            ,{"name":"box2RotateDegrees","value":"{ return [Sync.getSyncValue('ray:box2rotx'),Sync.getSyncValue('ray:box2roty'),Sync.getSyncValue('ray:box2rotz')]}"}
            ,{"name":"boxMove","value":"{ return [Sync.getSyncValue('ray:boxmovex'),Sync.getSyncValue('ray:boxmovey'),Sync.getSyncValue('ray:boxmovez')]}"}
            ]}
        ,"color":[{"a":255}]
    });
    this.loader.addAnimation({
         "start": start, "duration": duration
         ,"layer": layer
        ,"image": ["dude_3.png"]
        ,"position":[
            {"x":getScreenWidth()*1.33,"y":getScreenHeight()*0.5}
            ,{"duration":3,"x":getScreenWidth()*0.83,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":255},{"duration":duration-1},{"duration":1, "a":0}]
    });
}

Demo.prototype.sceneComicFbo = function(start, duration)
{
    this.loader.addAnimation([
    { 
         "start": start, "duration": duration+1
        ,"layer": layer
        ,"fbo":{"name":"madnessFbo","action":"begin","storeDepth":false}
    }]);

    this.loader.addAnimation({
         "start": start, "duration": duration+1
         ,"layer": layer
        ,"image": ["batman-slap-hand.png"]
        ,"position":[
            {"x":getScreenWidth()*0.21,"y":getScreenHeight()*0.47}
            ,{"duration":9}
            ,{"duration":6, "x":getScreenWidth()*0.19,"y":getScreenHeight()*0.48}
        ]
    });
    this.loader.addAnimation({
         "start": start, "duration": duration+1
         ,"layer": layer
        ,"image": ["batman-slap.png"]
        ,"position":[
            {"x":getScreenWidth()*0.58,"y":getScreenHeight()*0.5}
        ]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration+1
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'NEVER STOP THE MADNESS';}"
        }
        ,"scale": [{"uniform2d":8.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.90}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":duration-1.0},{"duration":0.5,"a":0}]
    });
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration+1
        ,"layer": layer
        ,"fbo":{"name":"madnessFbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame1Fbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["jmlman.png"]
        //,"shader":{"name":"kaleidoscope.fs"}
        ,"shader":{"name":"rotozoom.fs"}
        //,"shader":{"name":"tunnel.fs"}
        ,"scale": [{"uniform2d":4.0}]
        //,"color":[{"a":100}]
    });
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame1Fbo","action":"unbind"}
    });


    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame1Fbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[2][1]}
              ,{"name":"color2","value":colorSchemes[0][2]}
        ]}
        ,"color":[{"a":255}]
    });
    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["jmlman.png"]
        //,"shader":{"name":"kaleidoscope.fs"}
        ,"shader":{"name":"rotozoom.fs"}
        //,"shader":{"name":"tunnel.fs"}
        ,"scale": [{"uniform2d":4.0}]
        //,"color":[{"a":100}]
    });
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame1Fbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame2Fbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[0][3]}
              ,{"name":"color2","value":colorSchemes[0][2]}
        ]}
        ,"color":[{"a":255}]
    });
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["jml_fist.png"]
        //,"shader":{"name":"kaleidoscope.fs"}
        ,"shader":{"name":"rotozoom.fs"}
        //,"shader":{"name":"tunnel.fs"}
        ,"scale": [{"uniform2d":4.0}]
        //,"color":[{"a":100}]
    });
    this.loader.addAnimation ({
         "start": start, "duration":duration, "layer": layer
         ,"image": "anim/batman-party-hard/batman-party-hard-1.png"
         ,"animationObject": batmanPartyHard
         ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
         ,"runFunction":"{playPngAnimation(animation);}"
         ,"scale":[{"y":3.0,"x":3.9}]
         ,"color":[{"a":0},{"duration":6},{"duration":0.25,"a":255},{"duration":7.5},{"duration":0.25,"a":0}]
        ,"shader":{"name":"colorcycle.fs"}
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame2Fbo","action":"unbind"}
    });

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame3Fbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["_embedded/defaultWhite.png"]
        ,"shader":{"name":"backgroundColor.fs", "variable":[
               {"name":"shift","value":[0.0]}
              ,{"name":"color1","value":colorSchemes[0][1]}
              ,{"name":"color2","value":colorSchemes[0][2]}
        ]}
        ,"color":[{"a":255}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"layer": layer, "image": ["jmlman.png"]
        //,"shader":{"name":"kaleidoscope.fs"}
        //,"shader":{"name":"rotozoom.fs"}
        ,"shader":{"name":"tunnel.fs"}
        ,"scale": [{"uniform2d":4.0}]
        //,"color":[{"a":100}]
    });
    this.loader.addAnimation ({
         "start": start, "duration":duration, "layer": layer
         ,"image": "anim/batman-dance/batman-dance-1.png"
         ,"animationObject": batmanDance
         ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
         ,"runFunction":"{playPngAnimation(animation);}"
         ,"scale":[{"y":3.0,"x":3.9}]
         ,"color":[{"a":0},{"duration":8},{"duration":0.25,"a":255},{"duration":7.5},{"duration":0.25,"a":0}]
        ,"shader":{"name":"colorcycle.fs", "variable":[
              {"name":"shift","value":[0.0]}
        ]}
    });
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"frame3Fbo","action":"unbind"}
    });
}

Demo.prototype.sceneComic = function(start, duration)
{
    Sync.addSync(
    [
        { "name":"comic:slide", "type":"rocket" },
    ]);

    this.loader.addAnimation({
         "start": start, "duration": duration
         ,"layer": layer
        ,"image": ["frame1Fbo.color.fbo"]
        ,"shader":{"name":"kaleidoscope.fs"}
        ,"scale":[{"x":0.45, "y":0.4}]
        ,"position":[{"x":getScreenWidth()*0.28, "y":getScreenHeight()*0.75}]
        ,"color":[{"a":0},{"duration":1, "a":255}, {"duration":duration-2}, {"duration":1, "a":0}]
    });

    this.loader.addAnimation({
         "start": start, "duration": duration
         ,"layer": layer
        ,"image": ["frame2Fbo.color.fbo"]
        ,"scale":[{"uniform2d":0.4}]
        ,"position":[{"x":getScreenWidth()*0.75, "y":getScreenHeight()*0.75}]
        ,"color":[{"a":0},{"duration":2},{"duration":1, "a":255}, {"duration":duration-4}, {"duration":1, "a":0}]
    });

    this.loader.addAnimation({
         "start": start, "duration": duration
         ,"layer": layer
        ,"image": ["frame3Fbo.color.fbo"]
        ,"scale":[{"y":0.45, "x":0.9}]
        ,"position":[{"x":getScreenWidth()*0.5, "y":getScreenHeight()*0.27}]
        ,"color":[{"a":0},{"duration":4},{"duration":1, "a":255}, {"duration":duration-6}, {"duration":1, "a":0}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'SEKOILU ON LOPETETTAVA';}"
        }
        ,"scale": [{"uniform2d":8.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":5},{"duration":0.5,"a":255},{"duration":6},{"duration":0.5,"a":0}]
    });

    this.loader.addAnimation({
         "start": start, "duration": duration+1
         ,"layer": layer
        ,"image": ["madnessFbo.color.fbo"]
        ,"shader":{"name":"slideRevealPic.fs", "variable": [
        {"name": "shift", "value":"{return [Sync.getSyncValue('comic:slide')]; /*4.0*/}"}
        ]}
        ,"color":[{"a":255},{"duration":duration},{"duration":1, "a":0}]
    });
}

Demo.prototype.init = function()
{

    /*Sync.addSync(
    [
        { "name":"fadeEnd", "type":"rocket" },
        { "name":"darkness", "type":"rocket" },
        { "name":"digit_a", "type":"rocket" },
        { "name":"face:eyelid_left_x", "type":"rocket" },
        { "name":"face:eyelid_left_y", "type":"rocket" },
    ]);*/

/*
    this.loader.addAnimation({
         "start": start, "duration": end
        ,"image": ["_embedded/defaultWhite.png"]
        ,"color":[{"g":0,"b":0}]
    });*/

    /*
     * TEXT WRITER FBO
     */

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"textFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'JUMALAUTA';}"
        }
        ,"scale": [{"uniform2d":15.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'NOUSEE';}"
        }
        ,"scale": [{"uniform2d":15.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":1+3},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
    });
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"textFbo","action":"unbind"}
    });

    /*
     * FOREGROUND LAYOUT FBO
     */

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"unbind"}
    });


    var comicStart = 80;
    var comicDuration = 16;

    this.sceneComicFbo(comicStart, comicDuration);

    /*
     * VISIBLE DRAW TO SCREEN FROM HERE ON
     */




//loggerInfo("LOLG" + JSON.stringify(colorSchemes[0][1],null,2));

/*
00:00 - city scene
00:16 - city scene
00:32 - more bass
00:48 - spike ball
01:04 - sync boxes
01:20 - cartoon????
01:37 - greetings
01:52 - party hard gif
02:00 - 02:08 - JML logo

*/

    this.sceneIntro(0, 32);

    this.sceneMoreBass(31, 17);

    this.sceneSpikeBall(48, 16);

    this.sceneSyncBoxes(64, 16);

    this.sceneGreets(95, 18);

    this.sceneComic(comicStart, comicDuration);

    this.sceneEnd();


    /*this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["jmlman.png"]
        //,"shader":{"name":"kaleidoscope.fs"}
        //,"shader":{"name":"rotozoom.fs"}
        ,"shader":{"name":"tunnel.fs"}
        //,"color":[{"a":100}]
    });*/
    


/*
    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"spiral.fs"}
        //,"color":[{"a":100}]
    });


    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["textFbo.color.fbo"]
    });

    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["foregroundFbo.color.fbo"]
    });
*/





/*
*/
/*
    */
/*
    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"draw2d.fs"}
    });
*/
    



    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });
}
