let beat;
let scene = 0;

function draw() {
    beat = getBeat();

    scaling = height / 1000;
    left = (-width / 2) / scaling;
    right = (width / 2) / scaling;

    // Resolution independent canvas
    translate(width / 2, height / 2);
    scale(scaling);
    textAlign(CENTER);

    textFont('Londrina');

    let previousScene = scene;
    scene = Math.ceil(beat / 16);

    if (previousScene !== scene) {
        background(hdr_hsl((180+30) / 360, 1, -3));
    }

    fill(hdr_hsl(beat, 2, -2));
    stroke(hdr_hsl(beat, 2, 2));
    strokeWeight(10);

    if (scene === 0) {
        // font glitch
        background(hdr_hsl((180+30) / 360, 1, -3));
        infoScene();
    } else if (beat >= 128 + 4) {
        endDemo();
    } else if (beat < 16) {
        scene01();
    } else if (beat < 32) {
        scene02();
    } else if (beat < 48) {
        scene03();
    } else if (beat < 64) {
        scene04();
    } else if (beat < 80) {
        scene05();
    } else if (beat < 96) {
        scene06();
    } else if (beat < 112) {
        scene07();
    } else {
        if (beat > 128) beat = 128
        scene08();
    }
}


function scene01() {
    textSize(200);
    const x = Math.sin(beat * TAU / 4) * 100;
    const y = Math.cos(beat * TAU / 4) * 100;
    text('Hello Jumalauta', x, y);
}


function scene02() {
    fill(hdr_hsl(beat/2, 3, -2 + 3 * sin(beat * TAU / 4)));
    stroke(hdr_hsl(beat/2, 3, 2 + 3 * sin(beat * TAU / 4)));

    textSize(300);
    const x = triangleWave(beat/8) * 200;
    const y = triangleWave(beat/8 + 0.25) * 200;
    text('We are', x, y-250);
    text('inviting you', x, y);
    text('to Graffathon', x, y+250);
}

function scene03() {
    fill(hdr_hsl(beat/2, 3, -2 + 3 * sin(beat * TAU / 8)));
    stroke(hdr_hsl(beat/2, 3, 2 + 3 * sin(beat * TAU / 8)));

    textSize(300);
    const x = triangleWave(beat/8) * 200;
    const y = triangleWave(beat/8 + 0.25) * 200;
    rotate(sin(beat/8 * TAU) * TAU / 32);
    text('7.6. – 9.6.2024', x, y);
}

function scene04() {
    fill(hdr_hsl(beat/2, 2, -2 + 3 * sin(beat * TAU / 4)));
    stroke(hdr_hsl(beat/2, 2, 2 + 3 * sin(beat * TAU / 4)));

    const x = triangleWave(beat/8) * 200;
    const y = triangleWave(beat/8 + 0.25) * 200;
    rotate(sin(beat/16 * TAU) * TAU / 8);
    textSize(240);
    text('Aalto Design Factory', x, y-150);
    textSize(300);
    text('Espoo, Finland', x, y+150);
}

function scene05() {
    fill(hdr_hsl(beat/2, 2, -2 + 3 * sin(beat * TAU / 8)));
    stroke(hdr_hsl(beat/2, 2, 2 + 3 * sin(beat * TAU / 8)));

    textSize(300);
    const x = triangleWave(beat/8) * 200;
    const y = triangleWave(beat/8 + 0.25) * 200;
    rotate(sin(beat/4 * TAU) * TAU / 16);
    text('Many of you', x, y-150);
    text('have been there', x, y+150);
}

function scene06() {
    fill(hdr_hsl(beat/2, 3, -2 + 3 * sin(beat * TAU / 4)));
    stroke(hdr_hsl(beat/2, 3, 2 + 3 * sin(beat * TAU / 4)));

    textSize(150);
    const x = triangleWave(beat/8) * 200;
    const y = triangleWave(beat/8 + 0.25) * 200;
    scale(exp(triangleWave(beat/4 + 1/4) / 4));
    text('Many of you could experience', x, y-100);
    text('your first Graffathon next year', x, y+100);
}

function scene07() {
    fill(hdr_hsl(beat/2, 3, -2 + 3 * sin(beat * TAU / 8)));
    stroke(hdr_hsl(beat/2, 3, 2 + 3 * sin(beat * TAU / 8)));

    textSize(300);
    const x = triangleWave(beat/8) * 200;
    const y = triangleWave(beat/8 + 0.25) * 200;
    rotate(sin(beat/16 * TAU) * TAU);

    text('Hope to', x, y-150);
    text('see you there!', x, y+150);
}

function scene08() {
    fill(hdr_hsl(beat/8, 4, -2 + 3 * sin(beat * TAU / 4)));
    stroke(hdr_hsl(beat/8, 4, 2 + 3 * sin(beat * TAU / 4)));

    textSize(300);
    // const x = triangleWave(beat/8) * 200;
    // const y = triangleWave(beat/8 + 0.25) * 200;
    const x = 0;
    const y = 0;
    scale(exp(triangleWave(beat/16) / 4));
    text('Music: sape', x, y-150);
    text('Graphics: bad felix', x, y+150);
}


function triangleWave(x) {
    // average 0
    // min -1, max 1
    // period 1
    return abs(4 * (x - floor(x + 0.5))) - 1;
}


function infoScene() {
    push();
    textAlign(CENTER);
    textSize(100);
    textFont('Londrina');
    text('Press F to go fullscreen', 0, -80);
    text('Press SPACE to start', 0, 80);
    noStroke();
}

function repeat(count, callable) {
	for (let i = 0; i < count; i++) {
		callable(i);
	}
}

function wave(min, max, bpm = 10, phase = 0) {
	const t = millis() * 0.001;
	const frequency = bpm / 60;
	return map(sin((t * frequency + phase) * TAU), -1, 1, min, max);
}

// HDR HSL v3
function hdr_hsl(hue, chroma, exposure) {
  const red_cos = cos(hue * TWO_PI);
  const green_cos = cos((hue - 1.0/3) * TWO_PI);
  const blue_cos = cos((hue - 2.0/3) * TWO_PI);
  // sum of cosines of equally spaces angles is always 0

  const low_hdr = pow(2, exposure - chroma);
  const high_hdr = pow(2, exposure + chroma);

  const low = hdr_to_srgb(low_hdr);
  const high = hdr_to_srgb(high_hdr);

  const red = map(red_cos, -1, 1, low, high);
  const green = map(green_cos, -1, 1, low, high);
  const blue = map(blue_cos, -1, 1, low, high);

  return color(red, green, blue);
}

function hdr_to_srgb(hdr) {
  // two steps in case hdr is Float.MAX_VALUE
  const srgb = hdr / (1.0 + hdr);
  return 255.0 * srgb;
}