BPM = 120
MEASURE = 0

let startedAt = -1;
const currentTime = () => +(new Date())
const lastBeats = {
  kick: currentTime(),
  snare: currentTime(),
  bass: currentTime(),
}

const initLastBeats = () =>
  Object.keys(lastBeats)
    .forEach((key) => lastBeats[key] = currentTime())


const millisSince = (instrument) => {
  const last = lastBeats[instrument]
  if (last) {
    return currentTime() - last
  }
  return -1
}

const floatBeats = () => {
  if (startedAt === -1) return 0
  const elapsedMillis = currentTime() - startedAt
  const beatDuration = 60 * 1000 / BPM;
  return elapsedMillis / beatDuration
}

const between = (a, b) => MEASURE > a && MEASURE <= b
const getVariationFor = (instrument) => {
  if (instrument === 'pad') {
    return getVariationFor('bass')[0]
  }
  if (instrument === 'bass') {
    if (between(8, 16) || between(24, 32)) {
      if (MEASURE % 4 === 0) {
        if (MEASURE === 32) {
          return 'A fill'
        }
        return 'B fill'
      }
      return 'B'
    }
    if (MEASURE % 4 === 0) {
      return 'A fill'
    }
  }
  if (instrument === 'cowbell') {
    if (MEASURE % 8 === 0) {
      return 'ON'
    }
    return 'OFF'
  }
  return 'A'
}

const bass = new Tone.Synth().toDestination();
const bass2 = new Tone.FMSynth().toDestination();
const pad = new Tone.PolySynth(Tone.FMSynth)
const lead = new Tone.Synth().toDestination();
bass2.volume.value = -4
pad.volume.value = -33

const padPhaser = new Tone.Phaser({
	frequency: 12,
	octaves: 4,
	baseFrequency: 30
})

const padFilter = new Tone.Filter(1200, 'lowpass')
const padVerb = new Tone.Reverb(10)
padVerb.toDestination();

pad.connect(padPhaser)
padPhaser.connect(padFilter)
padFilter.connect(padVerb)

const startSound = async () => {
  const currentBeat = (time, hits) => Math.floor(time / 60 * BPM * 4) % hits
  await Tone.loaded()
  await Tone.start()

  initLastBeats()

  const kickLoop = new Tone.Loop((time) => {
    const b = currentBeat(time, 16)
    const variation = getVariationFor('kick')
    if (variation === 'A') {
      if ([1, 5, 9, 13].includes(b)) {
        kickPlayer.start()
        lastBeats['kick'] = currentTime()
      }
    }
  }, '16n').start()

  const snareLoop = new Tone.Loop((time) => {
    const b = currentBeat(time, 16)
    const variation = getVariationFor('snare')
    if (variation === 'A') {
      if ([5, 13].includes(b)) {
        snarePlayer.start()
        lastBeats['snare'] = currentTime()
      }
    }
  }, '16n').start()

  const hatLoop = new Tone.Loop((time) => {
    const b = currentBeat(time, 16)
    const variation = getVariationFor('hat')
    if (variation === 'A') {
      if ([1, 2, 3, 5, 7, 8, 10, 11, 13, 15, 16].includes(b)) hatPlayer.start()
    }
  }, '16n').start()

  const cowbellLoop = new Tone.Loop((time) => {
    const b = currentBeat(time, 16)
    const variation = getVariationFor('cowbell')
    if (variation === 'ON') {
      if ([1, 3, 5, 7, 8, 10, 12, 13, 15].includes(b)) cowbellPlayer.start()
    }
  }, '16n').start()

  const bassLoop = new Tone.Loop((time) => {
    const b = currentBeat(time, 16)
    const playBass = (note, duration, secondBass = false) => {
      (secondBass ? bass2 : bass).triggerAttackRelease(note, duration)
      lastBeats['bass'] = currentTime()
    }
    const variation = getVariationFor('bass')
    if (variation === 'A') {
      const noteValues = {
        1:  ['A1',  '4n'],
        8:  ['C2',  '8n'],
        11: ['G1',  '8n'],
        14: ['G#1', '8n'],
      }[b]
      if (noteValues) playBass(...noteValues)
    }
    if (variation === 'A fill') {
      const noteValues = {
        1:  ['A1',  '16n'],
        3:  ['A1',  '16n'],
        5:  ['G#1', '16n'],
        7:  ['G#1', '16n'],
        9:  ['Db2', '16n'],
        11: ['Db2', '16n'],
        13: ['A#1',  '16n'],
        15: ['A#1',  '16n'],
      }[b]
      if (noteValues) {
        playBass(...noteValues)
        bass2.triggerAttackRelease(...noteValues)
      }
    }
    if (variation === 'B') {
      const noteValues = {
        1:  ['D2',  '4n'],
        8:  ['F2',  '8n'],
        11: ['A1',  '8n'],
        14: ['C2', '8n'],
      }[b]
      if (noteValues) playBass(...noteValues, true)
    }
    if (variation === 'B fill') {
      const noteValues = {
        1:  ['D2', '16n'],
        3:  ['D2', '16n'],
        5:  ['F2', '16n'],
        7:  ['F2', '16n'],
        9:  ['A2', '16n'],
        11: ['A2', '16n'],
        13: ['C3', '16n'],
        15: ['C3', '16n'],
      }[b]
      if (noteValues) playBass(...noteValues)
    }
  }, '16n').start()

  const padLoop = new Tone.Loop((time) => {
    const b = currentBeat(time, 16)
    const variation = getVariationFor('pad')
    const noteValues = {
      1:  [(variation === 'A' ? ['A4', 'A3', 'E5', 'E4', 'A5', 'A2'] : ['D4', 'D3', 'A5', 'A4', 'D5', 'D2']).slice(0, MEASURE % 4 * 2),  '2n'],
    }[b]
    if (noteValues) {
      pad.triggerAttackRelease(...noteValues)
    }
  }, '16n').start()

  const measureCounter = new Tone.Loop(_ => {
    MEASURE++
    if (MEASURE > 32) {
      Tone.Transport.stop()
      bass.triggerAttackRelease('A1', '2n')
      bass2.triggerAttackRelease('A0', '4n')
    }
  }, '1n').start()

  startedAt = currentTime()
  Tone.Transport.bpm.value = BPM
  Tone.Transport.start()
}
