#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform vec4 color = vec4(1.0);
uniform float time = 1.0;

void main()
{
    vec2 coord=texCoord;
    coord.s += (sin(coord.t*8.0 + time*1.0)*0.102)*(coord.t-0.5);
    coord.t += (cos(coord.s*50.0 + time*2.3)*0.005)*(coord.t-0.5);
    vec4 color1 = color;

    vec4 animColor = texture2D(texture0, coord);

    fragColor = animColor * color1;
}
