
#version 330 core

#define float2 vec2
#define float3 vec3
#define float4 vec4
in float2 texCoord;
in float4 vertexFragColor;
out float4 fragColor;
uniform sampler2D texture0;

uniform vec2 direction = vec2(1,0);
uniform int samples = 5;
uniform float spread = 1.1;
uniform float intensity = 0.09;
uniform int showOnlyGlow = 0;
uniform float alpha = 1.0;

vec4 glow()
{
	vec4 sum = vec4(0,0,0,0);
	vec2 coord = texCoord.xy;

	for (int i = -samples; i <= samples; i++)
	{
		vec4 texel = texture(texture0, coord + i * direction * spread);
		sum += texel * (1-abs(float(i))/float(samples)) * texel.a;
	}



	sum *= intensity;
	sum.a = alpha;
		if (showOnlyGlow == 0)
	{
		sum = texture(texture0, coord)*.75 + sum;
	}
	return sum;
}

void main()
{   
	vec4 c = glow();
	
	c.rgb = ((c.rgb - 0.5f) * max(1.5, 0.0)) + 0.5f;
   
	  fragColor = c;
}
