#version 330 core

#define float2 vec2
#define float3 vec3
#define float4 vec4
in float2 texCoord;
in float4 vertexFragColor;
out float4 fragColor;
uniform sampler2D texture0;
uniform float time;
uniform float AMT = 0.3; //0 - 1 glitch amount
uniform float OFFSET = .15;
uniform float SPEED = .5; //0 - 1 speed

//2D (returns 0 - 1)
float random2d(vec2 n) {
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

float randomRange (in vec2 seed, in float min, in float max) {
return min + random2d(seed) * (max - min);
}

// return 1 if v inside 1d range
float insideRange(float v, float bottom, float top) {
   return step(bottom, v) - step(top, v);
}

void main()
{
   	vec2 uv = texCoord;
 
    float timeStep = floor(time * SPEED * 15.0);    
	float offsetStep = floor(sin(SPEED*time)*5)*.2;

    //copy orig
    vec4 outCol = texture(texture0, uv);
	//outCol = vec4(0.0,0.0,0.0,0.0);
    //randomly offset slices horizontally
	
    float maxOffset = OFFSET/2.0;

    for (float i = 0.0; i < 10.0 * AMT; i += 1.0) {
        float sliceY = random2d(vec2(AMT , 2345.0 + float(i)));
        float sliceH = random2d(vec2(AMT , 9035.0 + float(i))) * 0.25;
        float hOffset = randomRange(vec2(AMT , 9625.0 + float(i)), -maxOffset, maxOffset);
        vec2 uvOff = uv;
        uvOff.x += hOffset*offsetStep;
        if (insideRange(uv.y, sliceY, fract(sliceY+sliceH)) == 1.0 ){
        outCol = texture(texture0, uvOff);
        }
    }



       
	fragColor = outCol;
}

