const Confusion = function () {
    PartBase.call(this);

    this.random = function(){
        let seed = Math.PI / 4;
        const random = function () {
            const x = Math.sin( seed ++ ) * 1000;
            return x - Math.floor( x );
        }
        return random;
    }();

    this.setEdgeDetection();
    this.setBloom(0.1);
    //POSTPROCESSING
    this.setDoF({
        focus: 100,
        maxblur: 6,
        aperture: 0.025,
    });

    this.scene.fog = new THREE.Fog(0xA01000, 100, 500);
    const light = new THREE.HemisphereLight(0x804000, 0x080800, 1);
    this.scene.add(light);
    const sky = this.createSky();
    this.scene.add(sky);

    [this.ground, this.ceiling] = this.createHeightMap();
    this.scene.add(this.ground);
    this.scene.add(this.ceiling);

    this.kaaret = this.createConfusion();
    this.scene.add(this.kaaret);

    this.blade = this.createBlade();
    this.scene.add(this.blade);
    
};

Confusion.prototype = PartBase.prototype.inheritance();

const rotateObject = (obj, rot) => {
    obj.rotation.x = rot.x;
    obj.rotation.y = rot.y;
    obj.rotation.z = rot.z;
};

const translateObject = (obj, pos) => {
    obj.position.x = pos.x;
    obj.position.y = pos.y;
    obj.position.z = pos.z;
}

Confusion.prototype.animate = function (elapsedTime, delta) {
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    const pos = TDEMO.SYNC.getObjPosition();
    const rot = TDEMO.SYNC.getObjRotation();
    const hb = TDEMO.SYNC.getHeartBeat();
    const camPos = TDEMO.SYNC.getCameraPosition();
    const camRot = TDEMO.SYNC.getCameraRotation();

    this.kaaret.children.forEach((kaari, index) => {
        kaari.rotation.y = (index % 2 === 0) ? elapsedTime : -elapsedTime*0.5;
        //kaari.rotation.x = (index % 2 === 0) ? -elapsedTime*0.5 : elapsedTime*0.25;
    });

    const vertices = this.ground.geometry.attributes.position.array;

    for( let i = 0; i < vertices.length; i +=3 ){
        vertices[i+1] = Math.sin(this.random())*10.0 + Math.sin(this.random())*20.0 + hb;
    }
    this.ground.geometry.setAttribute("position", new THREE.BufferAttribute( vertices, 3 ));

    rotateObject(this.blade, camRot);
    translateObject(this.blade, new THREE.Vector3(camPos.x, pos.y, camPos.z-5));

    const edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};

Confusion.prototype.createSky = function () {
    const material = new THREE.MeshBasicMaterial({ color: 0xFFC006, side: THREE.BackSide });
    const skySphere = new THREE.Mesh(new THREE.SphereGeometry(300, 64, 64), material);
    skySphere.rotation.x = -Math.PI / 2;
    return skySphere;
};

Confusion.prototype.createHeightMap = function(){
    const geometry = new THREE.PlaneGeometry(1200, 1200, 180, 180);
    geometry.rotateX(-Math.PI/2);
    const material = new THREE.MeshToonMaterial({
        color: 0xffffff, emissive: 0xFF0000,
        emissiveIntensity : 0.5,
        side : THREE.DoubleSide
    });

    const vertices = geometry.attributes.position.array;

    for( let i = 0; i < vertices.length; i +=3 ){
        vertices[i+1] = Math.sin(this.random())*10.0 + Math.sin(this.random())*2.0;
    }
    
    const ground = new THREE.Mesh( geometry, material );
    ground.position.y = -40.0;

    const ceiling = ground.clone();
    ceiling.position.y = 40;
    
    return [ground, ceiling];
};

Confusion.prototype.createConfusion = function () {
    const kaaret = new THREE.Object3D();

    let lastZ = -180;
    const colors = [0x000000, 0xFFA000, 0xFF0000];

    for(let i = 0; i < 3; ++i){
        const kaari = this.createParticles(colors[i], Math.abs(lastZ)*2);
        lastZ += 40;

        kaaret.add(kaari);
    }

    kaaret.rotation.x = Math.PI/2;
    return kaaret;
}


Confusion.prototype.createParticles = function(color, radius){
    
    const  material = new THREE.PointsMaterial({ 
        color: color,
        size : 3,
        blending: THREE.AdditiveBlending,
        depthTest: false,
        transparent: true,
        opacity: 0.8
    });
    const geometry = new THREE.SphereGeometry(radius, 80, 80);
    const points = new THREE.Points(geometry, material);
    return points;
};

Confusion.prototype.createBlade = function(){
    const geometry = new THREE.PlaneGeometry(1200, 20, 180, 180);
    const material = new THREE.MeshToonMaterial({
        color: 0x000000, emissive: 0x505050,
        emissiveIntensity : 0.5,
        side : THREE.DoubleSide
    });

    return new THREE.Mesh(geometry, material);
}