//Config is created for Sync. If you need it request it from Sync.
//Do not create new instance, only one sync per one sync device!
var Config = function () {
  //DEMO OR SYNC MODE?
  //var demomode = false;
  var demomode = true;

  //Path to the rocket xml file
  var rocketXML = "guillotine.rocket";

  //audio paht
  var audioPath = "bin/guillotinemarch.mp3";

  //image path
  var imagePath = "bin/kuvat/";

  //Image files and texture parameters:
  //  name : file name
  //  id : the id used to fetch the texture in the demo
  //  mapping : THREE constant default is THREE.UVMapping
  //  wrapS : THREE constant default is THREE.ClampToEdgeWrapping
  //  wrapT : THREE constant default is THREE.ClampToEdgeWrapping
  //  magFilter : THREE constant default is THREE.LinearFilter (note that for pixel stuff THREE.NearestFilter is the best)
  //  minFilter : THREE constant default is THREE.LinearMipMapLinearFilter (note that for pixel stuff THREE.NearestFilter is the best)
  //  format : THREE constant default is THREE.RGBAFormat but for jpg the format is automatically changed to THREE.RGBFormat
  //  flipY : boolean default true
  //  repeat : Array of 2 integers that telss how many times the texture is repeated in X and Y axis
  //  offset : Array of 2 integers that telss how much offset the texture has in X and Y axis
  var imageFiles = [
  ];

  //video path
  var videoPath = "bin/videot/";
  //Video files that are used as resources
  //name is the file name with it's file extension
  //id is the id that will be set to the HTML video element
  var videoFiles = [];

  //MUSIC RELATED VARIABLES FOR SYNC
  //Beats per minute
  var bpm = 80;
  //beats per row
  var bpr = 4;
  //row rate
  var rr = (bpm / 60) * bpr;
  //current row
  var row = 0;

  return {
    getBeatsPerMinute: function () {
      return bpm;
    },

    getBeatsPerRow: function () {
      return bpr;
    },

    getRowRate: function () {
      return rr;
    },

    getRow: function () {
      return row;
    },

    setRow: function (r) {
      row = r;
    },

    isDemoMode: function () {
      return demomode;
    },

    getXML: function () {
      return rocketXML;
    },

    getAudioPath: function () {
      return audioPath;
    },

    getImagePath: function () {
      return imagePath;
    },

    getImageFiles: function () {
      return imageFiles;
    },

    getVideoPath: function () {
      return videoPath;
    },

    getVideoFiles: function () {
      return videoFiles;
    },
  };
};
