var c = document.getElementById("canvas")
var ctx =c.getContext("2d")
canvas.width = window.innerWidth
canvas.height = window.innerHeight



PI4 = 0.785
PI = 3.1416
CANVAS_HEIGHT = c.height
CANVAS_WIDTH = c.width
ASPECT = CANVAS_HEIGHT/CANVAS_WIDTH
MAX_DEPTH = 1
NEAR_PLANE = 1
FAR_PLANE = 20
n = 9
SIZE_MULTIPLIER = 1.35
SCALE = .05
FOCAL_LENGTH = 1


function generateRGB(r,g,b,a=1){
  return `rgba(${r},${g},${b},${a})`
}


function lineOrig(start,end,col="none"){
  let x=start[0]
  let y=start[1]
  let z=start[2]
  let nx=end[0]
  let ny=end[1]
  let nz=end[2]
  ctx.beginPath()
  ctx.moveTo(x,y)
  ctx.lineTo(nx,ny)
  ctx.lineWidth = 2
  ctx.strokeStyle = col 
  ctx.stroke()
}


function dist2d(a,b){
  return Math.sqrt((a[0]-b[0])**2+(a[1]-b[1])**2)
}


// depth is reverse
function line3d(start,end,width=1){
  let x=start[0]
  let y=start[1]
  let z=start[2]
  let nx=end[0]
  let ny=end[1]
  let nz=end[2]
  let d = dist2d(start,end)
  if(z<0){
    return
  }

  let z_offset = 3
  z -= z_offset
  nz -= z_offset
  z *= -25
  nz *= -255

  ctx.beginPath()
  if(d<1000){
    ctx.strokeStyle= generateRGB(z,z,z,z)
    //ctx.strokeStyle= generateRGB(255,255,255,.9)
  }else if(d>1000){
    let gradient = ctx.createLinearGradient(x,y,nx,ny)
    let col_start = generateRGB(z,z,z)
    let col_end = generateRGB(nz,nz,nz)
    gradient.addColorStop(0,col_start)
    gradient.addColorStop(1,col_end)
    ctx.strokeStyle = gradient
  }else{
    let gradient = ctx.createLinearGradient(x,y,nx,ny)
    let col_start = generateRGB(nz,0,0)
    let col_end = generateRGB(0,0,z)
    gradient.addColorStop(0,col_start)
    gradient.addColorStop(1,col_end)
    ctx.strokeStyle = gradient
  }
  ctx.moveTo(x,y)
  ctx.lineTo(nx,ny)
  ctx.lineWidth = width
  ctx.stroke()
}

function vec_sum(a,b,i=1){
  return [
  a[0] + b[0]*i,
  a[1] + b[1]*i,
  a[2] + b[2]*i]
}

function rot_y(p,beta,p2=[0,0,0]){
  p = vec_sum(p,p2,-1)
  let cb = Math.cos(beta)
  let sb = Math.sin(beta)
  let x = cb*p[0]+sb*p[2]
  let y = p[1]
  let z = -sb*p[0]+cb*p[2]
  return [x,y,z]
}


function rot_x(p,alpha,p2=[0,0,0]){
  p = vec_sum(p,p2,-1)
  let sa = Math.sin(alpha)
  let ca = Math.cos(alpha)
  let x = p[0]
  let y = ca*p[1]-sa*p[2]
  let z = sa*p[1]+ca*p[2]
  return [x,y,z]
}


function camera_matrix(pp,t,r){
  let sa = Math.sin(r[0])
  let sb = Math.sin(r[1])
  let sg = Math.sin(r[2])
  let ca = Math.cos(r[0])
  let cb = Math.cos(r[1])
  let cg = Math.cos(r[2])

  let p = [pp[0],pp[1],pp[2]]
  p[0] += t[0]
  p[1] += t[1]
  p[2] += t[2]

  let p_y = rot_y(p,r[1])
  let p_x = rot_x(p_y,r[0])

  let x = p_x[0]
  let y = p_x[1]
  let z = p_x[2]
  z += 16
  z *= 1/16
  
  f= FOCAL_LENGTH
  x = x*f/z
  y = y*f/z

  x = x*CANVAS_WIDTH*ASPECT//-CANVAS_WIDTH/2
  y = y*CANVAS_HEIGHT//-CANVAS_HEIGHT/2
  x = CANVAS_WIDTH-x
  y = CANVAS_HEIGHT-y
  y *= SCALE
  x *= SCALE
  x += CANVAS_WIDTH/2
  y += CANVAS_HEIGHT/2
  return [x,y,z]
}


function draw_origo(camera_position,camera_rotation, len){
  let orig = [0,0,0]
  orig = camera_matrix(orig,camera_position, camera_rotation)
  let x = [len,0,0]
  let ox = camera_matrix(x,camera_position, camera_rotation)
  let y = [0,len,0]
  let oy = camera_matrix(y,camera_position, camera_rotation)
  let z = [0,0,len]
  let oz = camera_matrix(z,camera_position, camera_rotation)
  ctx.fillStyle = "yellow"
  ctx.fillRect(orig[0],orig[1],5,5)
  ctx.fillStyle = "red"

  lineOrig(orig,ox,"red")
  orig = [0,0,0]
  orig = camera_matrix(orig,camera_position, camera_rotation)
  lineOrig(orig,oy,"green")
  orig = [0,0,0]
  orig = camera_matrix(orig,camera_position, camera_rotation)
  lineOrig(orig,oz,"blue")
}


function ltree3d(p,s,alpha,beta,n,n0,alpha0,beta0,T,R){
  i = Math.random()
  let np = [0,0,0]
  let len = -.2+1*SIZE_MULTIPLIER**n*s/SIZE_MULTIPLIER**n0
  let c = rot_x([0,-.5,0],beta0)
  c = rot_y(c,alpha0)
  np1 = rot_x([0,len,0],beta)
  np = rot_y(np1,alpha)
  np[0] = p[0]+np[0]+c[0]
  np[1] = p[1]+np[1]+c[1]
  np[2] = p[2]+np[2]+c[0]
  n = n-1
  if(n>0){
    ltree3d([np[0],np[1],np[2]],s,alpha+2*PI/8,beta+PI/8,n,n0,alpha0,beta0,T,R)
    let start = camera_matrix(p,T,R)
    let end = camera_matrix(np,T,R)
    line3d(start,end,n+1)
    ltree3d([np[0],np[1],np[2]],s,alpha-2*PI/8,beta+PI/32,n,n0,alpha0,beta0,T,R)
  }
}

function dot_grid_sin(time, camera_position, camera_rotation, z_start,z_end,x_limit,increment,amplitude,size){
  for(let z = z_start; z>=z_end; z -= increment){
    for(let x = -x_limit; x<=x_limit; x += increment){
      let p0 = [x,Math.sin(x*2+time)*amplitude/2,z]
      let p1= camera_matrix(p0,camera_position,camera_rotation)
      let depth = p1[2]
      let z_offset = 3
      depth -= z_offset
      depth *= -.5

      if(p1[2]>0){
        //15,94,156
        let col = generateRGB(depth*15,depth*95,depth*156)
        ctx.fillStyle = col
        s = size*depth**2
        ctx.fillRect(p1[0],p1[1],s,s)
      }
    }
  }
}
function dot_grid(time, camera_position, camera_rotation, z_limit,x_limit,increment,y,size){
  for(let z = -z_limit; z<=z_limit; z += increment){
    for(let x = -x_limit; x<=x_limit; x += increment){
      let p0 = [x,y,z]
      let p1= camera_matrix(p0,camera_position,camera_rotation)
      let depth = p1[2]
      let z_offset = 3
      depth -= z_offset
      depth *= -25

      if (p1[2] >0){
        let col = generateRGB(depth,depth,depth)
        ctx.fillStyle = col
        ctx.fillRect(p1[0],p1[1],size/p1[2],size)

      }
    }
  }
}
function cloud(p,T,R,size){
  let asd = size
  for(let j = 0;j<3;j += .5){
    for(let i = j**2+3; i<20-j**2;i += .5){
      let p0 = [i/2,-j,0]
      p0 = vec_sum(p,p0)
      let p1= camera_matrix(p0,T,R)
      let depth = p1[2]
      let z_offset = 3
      depth -= z_offset
      depth *= -25

      if (p1[2] >0){
        
        let col = generateRGB(200*asd,200*asd,200*asd)
        ctx.fillStyle = col
        let size = 100
        ctx.fillRect(p1[0],p1[1],size,size)

      }
    }

  }


}

function farjan(time,T,R){
  let p = [time-30,Math.sin(time)*.3+2.,0]
  //kansi
  for(let j = 3;j>2;j -= .05){


    for(let i = j/2+3; i<10-j;i += .1){
      let p0 = [i/2,j,0]
      p0 = vec_sum(p,p0)
      let p1= camera_matrix(p0,T,R)
      let depth = p1[2]
      let z_offset = 3
      depth -= z_offset
      depth *= -25

      if (p1[2] >0){
        
        let col = generateRGB(100,100,100)
        ctx.fillStyle = col
        let size = 5
        ctx.fillRect(p1[0],p1[1],size,size)

      }
    }

  }
  for(let j = 2;j>0;j -= .05){


    for(let i = j/2; i<15-j;i += .1){
      let p0 = [i/2,j,0]
      p0 = vec_sum(p,p0)
      let p1= camera_matrix(p0,T,R)
      let depth = p1[2]
      let z_offset = 3
      depth -= z_offset
      depth *= -25

      if (p1[2] >0){
        
        let col = generateRGB(255,255,255)
        if((j>1.5&&j<2)||(j>.5&&j<1)){
          col = generateRGB(100,100,100)
        }
        ctx.fillStyle = col
        let size = 5
        ctx.fillRect(p1[0],p1[1],size,size)

      }
    }

  }
  for(let j = 0;j>-2;j -= .05){


    for(let i = j; i<20+j;i += .1){
      let p0 = [i/2,j,0]
      p0 = vec_sum(p,p0)
      let p1= camera_matrix(p0,T,R)
      let depth = p1[2]
      let z_offset = 3
      depth -= z_offset
      depth *= -25

      if (p1[2] >0){
        let col = generateRGB(255,0,0)
        ctx.fillStyle = col
        let size = 5
        ctx.fillRect(p1[0],p1[1],size,size)

      }
    }

  }



}

function dot_sphere(n_balls,radius,alpha,beta,T,R,p0=[0,0,0],col_pulse, size){
  for(let d = 0; d<n_balls; d++){

    //let r = .5*radius*Math.sin(PI*d/n_balls)//5*Math.sin(d/10)
    let y = radius*2*d/n_balls
    let r = Math.sqrt(radius**2-(radius-y)**2)
    y -= radius
    let theta = d
    let x = r*Math.cos(theta)
    let z = r*Math.sin(theta)
    let p = [x,y,z]
    p = rot_x(p,alpha,p0)
    p = rot_y(p,beta,p0)
    p[0] += p0[0]
    p[1] += p0[1]
    p[2] += p0[2]
    p = camera_matrix(p,T,R)//z = -p1[2]
    let depth = p[2]
    let z_offset = 3
    depth -= z_offset
    depth *= -25
    depth *= 0<d%2
    depth -= col_pulse
    let col = generateRGB(depth,depth,depth,.5)
    ctx.fillStyle = col
    ctx.fillRect(p[0],p[1],size,size)
  }
}

const timer = ms => new Promise(res => setTimeout(res, ms))
let clock = new Date()
const start_t = clock.getTime()

async function draw(){
  //time
  let clock = new Date()
  let time = (clock.getTime() - start_t)/1000
  console.log(time)
  time_2PI = -time%(2*PI)
  //draw backround
  
  pulse = 1/2
  white = 10
  let bg = generateRGB(135,206,235)//generateRGB(time%pulse*white,time%pulse*white,time%pulse*white)
  ctx.fillStyle = bg;
  ctx.fillRect(0,0,canvas.width, canvas.height);


  // CAMERA POSITION 
  let camera_position = [Math.cos(time/10),2,Math.sin(time/10)]
  let T = camera_position
  
  // CAMERA ROTATION
  let camera_rotation = [-PI4/(.2+time),time/10,0]//Math.sin(time)*.01]
  let R = camera_rotation;

  // line grid
  /*
  for(let x = -5; x<=5; x += .25){
    let p0 = [x,0,-5]
    let p1 = [x,0,5]
    let start = camera_matrix(p0,camera_position,camera_rotation)
    let end = camera_matrix(p1,camera_position,camera_rotation)

    line3d(start,end)
  }
  for(let z = -5; z<=5; z += .25){
    let p0 = [-5,0,z]
    let p1 = [5,0,z]
    let start = camera_matrix(p0,camera_position,camera_rotation)
    let end = camera_matrix(p1,camera_position,camera_rotation)
    line3d(start,end)
  
  }
  */

  // dot grid
  
  //dot spghere
  let alpha = 0
  let beta = time
  //ltree3d([0,0,0],-1,alpha,time,n,n,alpha,beta,camera_position,camera_rotation)


  //dot_sphere(1000,radius,time,time/2, T,R,[2,0,2])
  //time *= 10
  let start_ts = 13
  let end_t = 40
  if(1==0 && time>start_ts && time<end_t){
    let t = time-start_ts
    for(let id = 0; id< 10; id++){
      //let radius = 2+(Math.sin(time+id))*.5
      //let radius = 2+time%pulse*2
      let radius = id/10+Math.max(1,-(t-10))
      let size = Math.max(Math.min((t-1)*2,20),0)
      dot_sphere(1000,radius,t+id,t/2+id, T,R,[id/5,5,0],Math.max(0,-t/10)*255,size)
    }
  }
  start_ts = 40
  end_t = 80
  if(1==0 && time>start_ts && time<end_t){
    let t = time-start_ts
    // CAMERA POSITION 
    let camera_position = [Math.cos(time/10),2,Math.sin(time/10)]
    let T = camera_position
    
    // CAMERA ROTATION
    let camera_rotation = [-PI4/2,t/10,0]//Math.sin(time)*.01]
    let R = camera_rotation;
    dot_grid(time,T,R,50,50,1,-5,Math.max(Math.min(t*5,50),0))
    let r = 200
    for(let id = 0; id< 100; id++){
      r = id/20+50
      let idinv = 100-id
      let growth = Math.min(7,t/2+Math.sin(id)*.5)
      let x = r*Math.cos(idinv/5)
      let z = r*Math.sin(idinv/4)
      let p = [x,-5,z]
      alpha = idinv
      beta = PI
      let scale = -1
      ltree3d(p,scale,alpha,beta,growth,growth,alpha,beta,camera_position,camera_rotation)
    }
  }
  start_ts = 0
  end_t = 200
  if(1==1 && time>start_ts && time<end_t){
    // CAMERA POSITION 
    let camera_position = [0,1,-2]
    let T = camera_position
    
    // CAMERA ROTATION
    let camera_rotation = [-PI/16,0,0]//Math.sin(time)*.01]
    let R = camera_rotation;
    let t = time-start_ts
    let size = 100
    dot_grid_sin(t, T, R, 10,0,50,1,1,size)
    farjan(t,T,R)
    dot_grid_sin(t, T, R, 0,-10,50,1,1,size)
    for(let iasd = -100;iasd<100;iasd += 5){
    cloud([iasd,10,Math.sin(iasd)*2],T,R,Math.sin(iasd)*.1+1)

    }
  }
  

  //draw_origo(camera_position,camera_rotation,1)


  await timer(1)
  draw()

}
draw()