#version 460

out vec4 fragColor;
uniform vec2 resolution;
uniform float time;
uniform float soundexpresser;

vec2 rotate2D (vec2 uv, float a){
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c) * uv;
}

vec2 hash12 (float t){
    float x = fract(sin(t * 453.329));
    float y = fract(sin((t + x) * 532.732));
    return vec2(x, y);
}

void main() {
    vec2 uv = (gl_FragCoord.xy - 0.5 * resolution.xy) / resolution.y;
    vec3 col = vec3(0.0);


    float r = sin(time*+1)*0.06;

    for (float i = 0.0; i < 120; i++) {

            float factor = (sin(time) * 0.02 + 0.3) + 0.05;
            i += factor;
            float a = i / 3;
            float dx = 2 * r * cos (a) - r * cos (2 * a);
            float dy = 2 * r * sin (a) + 0.5 * r * sin (2 * a);

            col += 0.001 / length(uv);
            col += 0.002 * factor / length (uv - vec2 (dx + 0.1, dy) - 0.02 * hash12(i));


            //uv = rotate2D (uv, 3.14 / 2.0);
            uv = rotate2D (uv, (sin(time*0.07))+1.5*soundexpresser);
            uv += sin(time*0.07 * (sin(time)*(cos(time)))*0.1 *(soundexpresser*0.05));

    }
    col *= sin(vec3(0.3, 0.01, 0.9) * time) * 0.05 + 0.25 * soundexpresser*2;
    fragColor = vec4(col, 1.0);
}