#version 430

out vec4 fragColor;
uniform float soundexpresser;
uniform vec2 resolution;
uniform float time;

vec2 rotate2D (vec2 uv, float a){
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c) * uv;
}

vec2 hash12 (float t){
    float x = fract(sin(t * 3453.329) / 5);
    float y = fract(sin((t + x) * 8532.732) / 5);
    return vec2(x, y);
}

void main() {
    vec2 uv = (gl_FragCoord.xy - 0.5 * resolution.xy) / resolution.y;
    vec3 col = vec3(0.0);

    uv = rotate2D (uv, 3.14 / 2.0);

    float r = 0.17;
    for (float i = 0.0; i < 140.0; i++) {

            float factor = (sin(time) * 0.05 + 0.3) + 0.1;
            i += factor;
            float a = i / 3;
            float dx = 0.3 * r * cos (a) - r * cos (3.14 * a) - 0.1;
            float dy = 2 * r * sin (a) + r * sin (time * a * 0.1);

            col += 0.001 / length(uv);
            col += 0.002 * factor*sin(time*0.1) / length (uv - vec2 (dx + 0.1, dy) + 0.002 * hash12(i));
    }

    col *= sin(vec3(0.2, 0.8, 0.9) * time) * 0.15 + 0.25;
    fragColor = vec4(col, 1.0);
}