#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

varying vec4 vertTexCoord;
uniform sampler2D texture;
uniform sampler2D prevFrame;
uniform float blur;
uniform float blurScale;
void main(void)
{
  vec2 p = vertTexCoord.st;
  vec2 p2 = ((p - vec2(0.5,0.5)) * blurScale) + vec2(0.5,0.5);
  p2.y = 1.0 - p2.y;
  vec2 len = vec2(1.0,1.0);
  vec3 col = texture2D(texture, p).rgb * (1.0 - blur) + texture2D(prevFrame, p2).rgb * blur;
  gl_FragColor = vec4(col, 1.0);
}//

