/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import processing.core.PApplet;
import processing.net.Client;

public class Server
implements Runnable {
    PApplet parent;
    Method serverEventMethod;
    volatile Thread thread;
    ServerSocket server;
    int port;
    protected final Object clientsLock = new Object[0];
    public int clientCount;
    public Client[] clients;
    int lastAvailable = -1;

    public Server(PApplet pApplet, int n) {
        this(pApplet, n, null);
    }

    public Server(PApplet pApplet, int n, String string) {
        this.parent = pApplet;
        this.port = n;
        try {
            this.server = string == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 10, InetAddress.getByName(string));
            this.clients = new Client[10];
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerMethod("dispose", (Object)this);
            try {
                this.serverEventMethod = pApplet.getClass().getMethod("serverEvent", Server.class, Client.class);
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            this.thread = null;
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Client client) {
        client.stop();
        Object object = this.clientsLock;
        synchronized (object) {
            int n = this.clientIndex(client);
            if (n != -1) {
                this.removeIndex(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIndex(int n) {
        Object object = this.clientsLock;
        synchronized (object) {
            --this.clientCount;
            for (int i = n; i < this.clientCount; ++i) {
                this.clients[i] = this.clients[i + 1];
            }
            this.clients[this.clientCount] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectAll() {
        Object object = this.clientsLock;
        synchronized (object) {
            for (int i = 0; i < this.clientCount; ++i) {
                try {
                    this.clients[i].stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.clients[i] = null;
            }
            this.clientCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClient(Client client) {
        Object object = this.clientsLock;
        synchronized (object) {
            if (this.clientCount == this.clients.length) {
                this.clients = (Client[])PApplet.expand((Object)this.clients);
            }
            this.clients[this.clientCount++] = client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int clientIndex(Client client) {
        Object object = this.clientsLock;
        synchronized (object) {
            for (int i = 0; i < this.clientCount; ++i) {
                if (this.clients[i] != client) continue;
                return i;
            }
            return -1;
        }
    }

    public boolean active() {
        return this.thread != null;
    }

    public static String ip() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client available() {
        Object object = this.clientsLock;
        synchronized (object) {
            int n = this.lastAvailable + 1;
            if (n >= this.clientCount) {
                n = 0;
            }
            for (int i = 0; i < this.clientCount; ++i) {
                int n2 = (n + i) % this.clientCount;
                Client client = this.clients[n2];
                if (!client.active()) {
                    this.removeIndex(n2);
                    --i;
                    --n2;
                }
                if (client.available() <= 0) continue;
                this.lastAvailable = n2;
                return client;
            }
        }
        return null;
    }

    public void stop() {
        this.dispose();
    }

    public void dispose() {
        this.thread = null;
        if (this.clients != null) {
            this.disconnectAll();
            this.clientCount = 0;
            this.clients = null;
        }
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (Thread.currentThread() == this.thread) {
            try {
                Socket socket = this.server.accept();
                Client client = new Client(this.parent, socket);
                Object object = this.clientsLock;
                synchronized (object) {
                    this.addClient(client);
                    if (this.serverEventMethod != null) {
                        try {
                            this.serverEventMethod.invoke((Object)this.parent, this, client);
                        }
                        catch (Exception exception) {
                            System.err.println("Disabling serverEvent() for port " + this.port);
                            Throwable throwable = exception;
                            if (exception instanceof InvocationTargetException && exception.getCause() != null) {
                                throwable = exception.getCause();
                            }
                            throwable.printStackTrace();
                            this.serverEventMethod = null;
                        }
                    }
                }
            }
            catch (SocketException socketException) {
                System.err.println("Server SocketException: " + socketException.getMessage());
                this.thread = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        Object object = this.clientsLock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.clientCount) {
                if (this.clients[n2].active()) {
                    this.clients[n2].write(n);
                    ++n2;
                    continue;
                }
                this.removeIndex(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) {
        Object object = this.clientsLock;
        synchronized (object) {
            int n = 0;
            while (n < this.clientCount) {
                if (this.clients[n].active()) {
                    this.clients[n].write(byArray);
                    ++n;
                    continue;
                }
                this.removeIndex(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        Object object = this.clientsLock;
        synchronized (object) {
            int n = 0;
            while (n < this.clientCount) {
                if (this.clients[n].active()) {
                    this.clients[n].write(string);
                    ++n;
                    continue;
                }
                this.removeIndex(n);
            }
        }
    }
}

