StageScript = {}
StageScript.__index = StageScript

function StageScript:new(script, scene)
    local o = {}
    setmetatable(o, StageScript)
    o.script = script
    o.scene = scene
    o.scriptItem = 1
    o.ticksToPass = 0
    o.isScriptAllRead = false
    return o
end

-- If there is a duration or tstamp, then decode it, otherwise return nil
function decodeDuration(si)
    if si.d ~= nil then
        return si.d
    end

    return nil
end

-- return boolean [isFinished (for script)]
function StageScript:update()
    if self.ticksToPass > 0 then
        self.ticksToPass = self.ticksToPass - 1
    else
        -- Read all non-blocking script items...
        repeat
            if self.scriptItem > #self.script then
                self.isScriptAllRead = true
            else
                self.ticksToPass = self:doScriptItem()
                self.scriptItem = self.scriptItem + 1
            end
        until(self.ticksToPass > 0 or self.isScriptAllRead)
    end
    self.scene:update()
    return SKIP_STAGE_SCRIPT or (self.isScriptAllRead and self.ticksToPass == 0)
end

-- return boolean [doTimeTick]
function StageScript:doScriptItem()
    local si = self.script[self.scriptItem]
    if si.p ~= nil and si.p ~= PLATFORM then
        return 0
    end

    local doTimeTicks = 0
    if si.a == 'wait' then
        doTimeTicks = decodeDuration(si)
    elseif si.a == 'omake' then
        self.scene:objMake(si)
    elseif si.a == 'cset' then
        self.scene:camSet(si.x)
    elseif si.a == 'cmove' then
        doTimeTicks = self.scene:camMove(si.x, decodeDuration(si))
    elseif si.a == 'speak' then
        doTimeTicks = self.scene:speak(si.c, si.t, decodeDuration(si))
    elseif si.a == 'aanim' then
        self.scene:anim(si.c, si.m)
    elseif si.a == 'tstamp' then
--        self.scene:timeStamp(si.n)
    elseif si.a == 'chyron' then
        self.scene:doChyron(si.t)
    elseif si.a == 'effect' then
        self.scene:effectSet(si.k,si.e)
    else
        trace("Unknown script action: " .. si.a)
    end

    if doTimeTicks == nil then
        trace("Script item " .. self.scriptItem .. " has no duration or tstamp")
    end

    return doTimeTicks
end

function StageScript:draw()
    self.scene:draw()
end
