SCRW,SCRH,SCRWH,SCRHH=128,128,64,64
PLATFORM='p'
SMULT=1
BG_COL=7

OBJSCREEN_W=40
OBJSCREEN_H=30
HOST_F="Bea Cowaite"
HOST_Fs="Bea"
HOST_M="Peter Tait"
HOST_Ms="Peter"
HOST_S="Demonstreightor"

-- returns the current second of the hour
function getTSync()
    return
    stat(94) * 60
    + stat(95)
end
 
function tblAdd(t, v)
  return add(t, v)
end

function tblShift(t)
  return deli(t, 1)
end

---aaaidan
function tblSort(t, cmp)
  for i=1,#t do
    local j = i
    while j > 1 and cmp(t[j-1],t[j]) do
      t[j],t[j-1] = t[j-1],t[j]
      j = j - 1
    end
  end
end

function dPMake(x,y)
  return {x=x,y=y}
end

function dPAdd(p,dx,dy)
  return {x=p.x+dx,y=p.y+dy}
end

-- NB Does nothing on PICO-8
-- Multiplies on TIC-80
dPMakeS=dPMake
dPAddS=dPAdd

function tfix(t)
    return t
end

function swpal(c)
    local v={0,2,8,9,10,11,3,3,1,1,12,12,7,6,13,5}
    return v[c+1]
end

function flrdiv(a,b)
  return flr(a/b)
end

function dFloor(a)
    return flr(a)
end

function dCls(c)
  cls(swpal(c))
end

function dPixSet(p, c)
  pset(p.x,p.y,swpal(c))
end

function dPixGet(p, c)
  return pget(p.x,p.y)
end

function dElliF(p,d,c)
  ovalfill(p.x-d.x,p.y-d.y,p.x+d.x,p.y+d.y,swpal(c))
end

function dRectF(p,d,c)
  rectfill(p.x,p.y,p.x+d.x,p.y+d.y,swpal(c))
end

function dTriF(p0,p1,p2,c)
  mantra_tri(p0.x,p0.y,p1.x,p1.y,p2.x,p2.y,0,swpal(c))
end

-- Takes a string, returns table
function dSplitTextByChar(s, ch)
  local o={}
  local last=1
  for i=1,#s do
    if sub(s,i,i) == ch then
      o[#o+1] = sub(s,last,i-1)
      last=i+1
    end
  end
  if last < #s then
    o[#o+1] = sub(s,last,#s)
  end
  return o
end

-- Takes a string, returns table
function dSplitTextByNewlines(s)
  return dSplitTextByChar(s, "\n")
end

-- Takes a string, returns table
function dSplitTextBySpaces(s)
  return dSplitTextByChar(s, " ")
end

function dPrintW(line)
  line=tostr(line)
  return print(line,0,-20,0) + #line -- wide font
end

function dPrintH(lines, gutterH)
  local textH, gutterH = 5, gutterH
  return #lines * textH + (#lines - 1) * gutterH
end

function flipString(t)
  t=tostr(t)
  o=""
  for i=1,#t do
    local v=ord(t,i)
    if (v>=65 and v<=90) then
      v+=32
    elseif (v>=97 and v<=122) then
      v-=32
    end
    o=o..chr(v)
  end
  return o
end

function dPrint(t,p,c)
  tr4(flipString(t),p.x,p.y,swpal(c))
end

-- https://www.lexaloffle.com/bbs/?tid=51505
function tr4(t,x0,y,...)
  local x=x0
  for i=1,#t do
    local a=t[i]
    if a=="\n" then
      x,y=x0,y+7
    else
      clip(x,y,2,5)
      print(a,x,y,...)
      clip()
      print(a,x+1,y,...)
      x+=5
    end
  end
end

-- triangle / @mantratronic
function mantra_tritop(x0,y0,x1,y1,x2,c)
  local h=y1-y0
  local dx1,dx2,lx1,lx2=(x1-x0)/h,(x2-x0)/h,x0,x0
  -- get points on (x0,y0) -> (x1,y1) and (x0,y0) -> (x2,y1)
  for y = y0,y1 do
    line(lx1,y,lx2,y,c) -- line between
    lx1+=dx1
    lx2+=dx2
  end
end

function mantra_tribot(x0,y0,x1,x2,y2,c)
  local h=y2-y0
  local dx1,dx2,lx1,lx2=(x2-x0)/h,(x2-x1)/h,x0,x1
  -- get points on (x0,y0) -> (x2,y2) and (x1,y0) -> (x2,y2)
  for y = y0,y2 do
    line(lx1,y,lx2,y,c) -- line between
    lx1+=dx1
    lx2+=dx2
  end
end

-- draw tri
function mantra_tri(x0,y0,x1,y1,x2,y2,f,c)
  fillp(f)

  local lx0,ly0,lx1,ly1,lx2,ly2,nx,ny
  if y0 == 0 then y0 = 0.1 end
  if y1 == 0 then y1 = 0.1 end
  if y2 == 0 then y2 = 0.1 end

  -- sort points
  if y1<y0 then x0,y0,x1,y1 = x1,y1,x0,y0 end
  if y2<y0 then x0,y0,x2,y2 = x2,y2,x0,y0 end
  if y2<y1 then x1,y1,x2,y2 = x2,y2,x1,y1 end
  
  -- check if flat
  if y1==y2 then
    mantra_tritop(x0,y0,x1,y2,x2,c)
  elseif y0==y1 then
    mantra_tribot(x0,y0,x1,x2,y2,c)
  else
    -- get new point
    --ny = ly1
    nx = x0 + (((y1 - y0)/(y2 - y0)) * (x2-x0))
    -- 2 draws
    mantra_tritop(x0,y0,x1,y1,nx,c)
    mantra_tribot(x1,y1,nx,x2,y2,c)
  end
  fillp()
end

function dBtn(i)
  return btn(i)
end

function dBtnP(i)
  return btnp(i)
end

function dModfr(x)
  return x-flr(x)
end

function dTime()
  return time()
end

function random(start,range)
  return start+flr(rnd(range))
end

function dMusic()
  if SOUND_PICO8 then
    music(0)
  end
end

function dSfxChirp(t)
  if SOUND_PICO8 then
    local offset=random(0,3)
    sfx(0,-1,offset,1)
  end
end