MLText = {}
MLText.__index = MLText

-- Take in a string, and break it into lines (first \n, and then to fit maxW)
function MLText:new(t, maxW, gutterH)
    local o = {}
    setmetatable(o, MLText)
    o.w, o.h = 0,0
    o.gutterH = gutterH
    local strings = dSplitTextByNewlines(t)
    o.lines = {}
    for _,s in ipairs(strings) do
        lines, w = breakStringToFit(s, maxW)
        for _,l in ipairs(lines) do
            o.lines[#o.lines+1] = l
        end
        o.w = w > o.w and w or o.w
    end
    o.h = o.h + dPrintH(o.lines, o.gutterH)

    return o
end

function MLText:getW()
    return self.w
end

function MLText:getH()
    return self.h
end

function MLText:getLines()
    return self.lines
end

-- align = -1 (left), 0 (center), 1 (right)
function MLText:print(pText,c,align)
    local x,y=pText.x,pText.y
    for _,l in ipairs(self.lines) do
        if align == 0 then
            x = pText.x - l.w / 2
        elseif align == 1 then
            x = pText.x - l.w
        end
        dPrint(l.l,dPMake(x,y),c)
        y = y + 5 + self.gutterH
    end
end

-- return lines[l,w], maxWidth
function breakStringToFit(s, maxW)
    local w = dPrintW(s)
    if w <= maxW then
        return {{l=s,w=w}},w -- fits one line. Cool beans.
    end

    local w = 0
    local words = dSplitTextBySpaces(s)
    local lines = {}
    local line = ""
    repeat
        local newWord = tblShift(words)
        line = line .. (line=="" and "" or " ") .. newWord
        lineW = dPrintW(line)
        if lineW > maxW then -- break line, but put the word back
            lines[#lines+1] = {l=line,w=lineW}
            w = lineW > w and lineW or w
            line = ""
        end 
    until #words == 0
    if line ~= "" then
        lines[#lines+1] = {l=line,w=lineW}
        w = lineW > w and lineW or w
    end

    return lines, w
end