/*! p5.js v1.7.0 July 10, 2023 */
(function (f) {
  if (typeof exports === 'object' && typeof module !== 'undefined') {
    module.exports = f()
  } else if (typeof define === 'function' && define.amd) {
    define([], f)
  } else {
    var g;
    if (typeof window !== 'undefined') {
      g = window
    } else if (typeof global !== 'undefined') {
      g = global
    } else if (typeof self !== 'undefined') {
      g = self
    } else {
      g = this
    }
    g.p5 = f()
  }
}) (function () {
  var define,
  module,
  exports;
  return (function () {
    function r(e, n, t) {
      function o(i, f) {
        if (!n[i]) {
          if (!e[i]) {
            var c = 'function' == typeof require && require;
            if (!f && c) return c(i, !0);
            if (u) return u(i, !0);
            var a = new Error('Cannot find module \'' + i + '\'');
            throw a.code = 'MODULE_NOT_FOUND',
            a
          }
          var p = n[i] = {
            exports: {
            }
          };
          e[i][0].call(p.exports, function (r) {
            var n = e[i][1][r];
            return o(n || r)
          }, p, p.exports, r, e, n, t)
        }
        return n[i].exports
      }
      for (var u = 'function' == typeof require && require, i = 0; i < t.length; i++) o(t[i]);
      return o
    }
    return r
  }) () ({
    1: [
      function (_dereq_, module, exports) {
        module.exports = {
          'p5': {
            'describe': {
              'name': 'describe',
              'params': [
                {
                  'name': 'text',
                  'description': '<p>description of the canvas</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'display',
                  'description': '<p>either LABEL or FALLBACK</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'describeElement': {
              'name': 'describeElement',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>name of the element</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'text',
                  'description': '<p>description of the element</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'display',
                  'description': '<p>either LABEL or FALLBACK</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'textOutput': {
              'name': 'textOutput',
              'params': [
                {
                  'name': 'display',
                  'description': '<p>either FALLBACK or LABEL</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'gridOutput': {
              'name': 'gridOutput',
              'params': [
                {
                  'name': 'display',
                  'description': '<p>either FALLBACK or LABEL</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'alpha': {
              'name': 'alpha',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'blue': {
              'name': 'blue',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'brightness': {
              'name': 'brightness',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'color': {
              'name': 'color',
              'class': 'p5',
              'module': 'Color',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>number specifying value between white and black.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '<p>alpha value relative to current color range\n                                (default is 0-255).</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to\n                                the current color range.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value\n                                relative to the current color range.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value\n                                relative to the current color range.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>a color string.</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>an array containing the red, green, blue,\n                                and alpha components of the color.</p>\n',
                      'type': 'Number[]'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '',
                      'type': 'p5.Color'
                    }
                  ]
                }
              ]
            },
            'green': {
              'name': 'green',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'hue': {
              'name': 'hue',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'lerpColor': {
              'name': 'lerpColor',
              'params': [
                {
                  'name': 'c1',
                  'description': '<p>interpolate from this color.</p>\n',
                  'type': 'p5.Color'
                },
                {
                  'name': 'c2',
                  'description': '<p>interpolate to this color.</p>\n',
                  'type': 'p5.Color'
                },
                {
                  'name': 'amt',
                  'description': '<p>number between 0 and 1.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'lightness': {
              'name': 'lightness',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'red': {
              'name': 'red',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'saturation': {
              'name': 'saturation',
              'params': [
                {
                  'name': 'color',
                  'description': '<p><a href="#/p5.Color">p5.Color</a> object, array of\n                                        color components, or CSS color string.</p>\n',
                  'type': 'p5.Color|Number[]|String'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'background': {
              'name': 'background',
              'class': 'p5',
              'module': 'Color',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>any value created by the <a href="#/p5/color">color()</a> function</p>\n',
                      'type': 'p5.Color'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'colorstring',
                      'description': '<p>color string, possible formats include: integer\n                        rgb() or rgba(), percentage rgb() or rgba(),\n                        3-digit hex, 6-digit hex.</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'a',
                      'description': '<p>opacity of the background relative to current\n                            color range (default is 0-255).</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>specifies a value between white and black.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'a',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red value if color mode is RGB, or hue value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green value if color mode is RGB, or saturation value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue value if color mode is RGB, or brightness value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'a',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>an array containing the red, green, blue\n                                and alpha components of the color.</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'image',
                      'description': '<p>image created with <a href="#/p5/loadImage">loadImage()</a>\n                            or <a href="#/p5/createImage">createImage()</a>,\n                            to set as background.\n                            (must be same size as the sketch window).</p>\n',
                      'type': 'p5.Image'
                    },
                    {
                      'name': 'a',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'clear': {
              'name': 'clear',
              'params': [
                {
                  'name': 'r',
                  'description': '<p>normalized red value.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'g',
                  'description': '<p>normalized green value.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'b',
                  'description': '<p>normalized blue value.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'a',
                  'description': '<p>normalized alpha value.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'colorMode': {
              'name': 'colorMode',
              'class': 'p5',
              'module': 'Color',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'mode',
                      'description': '<p>either RGB, HSB or HSL, corresponding to\n                         Red/Green/Blue and Hue/Saturation/Brightness\n                         (or Lightness).</p>\n',
                      'type': 'Constant'
                    },
                    {
                      'name': 'max',
                      'description': '<p>range for all values.</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'mode',
                      'description': '',
                      'type': 'Constant'
                    },
                    {
                      'name': 'max1',
                      'description': '<p>range for the red or hue depending on the\n                             current color mode.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'max2',
                      'description': '<p>range for the green or saturation depending\n                             on the current color mode.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'max3',
                      'description': '<p>range for the blue or brightness/lightness\n                             depending on the current color mode.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'maxA',
                      'description': '<p>range for the alpha.</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'fill': {
              'name': 'fill',
              'class': 'p5',
              'module': 'Color',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red value if color mode is RGB or hue value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green value if color mode is RGB or saturation value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue value if color mode is RGB or brightness value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>a color string.</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>a grayscale value.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>an array containing the red, green, blue &\n                                and alpha components of the color.</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>the fill color.</p>\n',
                      'type': 'p5.Color'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'noFill': {
              'name': 'noFill',
              'class': 'p5',
              'module': 'Color'
            },
            'noStroke': {
              'name': 'noStroke',
              'class': 'p5',
              'module': 'Color'
            },
            'stroke': {
              'name': 'stroke',
              'class': 'p5',
              'module': 'Color',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red value if color mode is RGB or hue value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green value if color mode is RGB or saturation value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue value if color mode is RGB or brightness value if color mode is HSB.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>a color string.</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>a grayscale value.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>an array containing the red, green, blue,\n                                and alpha components of the color.</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>the stroke color.</p>\n',
                      'type': 'p5.Color'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'erase': {
              'name': 'erase',
              'params': [
                {
                  'name': 'strengthFill',
                  'description': '<p>a number (0-255) for the strength of erasing under a shape\'s interior.\n                                       Defaults to 255, which is full strength.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'strengthStroke',
                  'description': '<p>a number (0-255) for the strength of erasing under a shape\'s edge.\n                                       Defaults to 255, which is full strength.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Color'
            },
            'noErase': {
              'name': 'noErase',
              'class': 'p5',
              'module': 'Color'
            },
            'arc': {
              'name': 'arc',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the arc\'s ellipse.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the arc\'s ellipse.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'w',
                  'description': '<p>width of the arc\'s ellipse by default.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'h',
                  'description': '<p>height of the arc\'s ellipse by default.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'start',
                  'description': '<p>angle to start the arc, specified in radians.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'stop',
                  'description': '<p>angle to stop the arc, specified in radians.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'mode',
                  'description': '<p>optional parameter to determine the way of drawing\n                        the arc. either CHORD, PIE, or OPEN.</p>\n',
                  'type': 'Constant',
                  'optional': true
                },
                {
                  'name': 'detail',
                  'description': '<p>optional parameter for WebGL mode only. This is to\n                        specify the number of vertices that makes up the\n                        perimeter of the arc. Default value is 25. Won\'t\n                        draw a stroke for a detail of more than 50.</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'ellipse': {
              'name': 'ellipse',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the center of the ellipse.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the center of the ellipse.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '<p>width of the ellipse.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the ellipse.</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'detail',
                      'description': '<p>optional parameter for WebGL mode only. This is to\n                        specify the number of vertices that makes up the\n                        perimeter of the ellipse. Default value is 25. Won\'t\n                        draw a stroke for a detail of more than 50.</p>\n',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'circle': {
              'name': 'circle',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the center of the circle.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the center of the circle.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'd',
                  'description': '<p>diameter of the circle.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'line': {
              'name': 'line',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '<p>the x-coordinate of the first point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '<p>the y-coordinate of the first point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '<p>the x-coordinate of the second point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '<p>the y-coordinate of the second point.</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z1',
                      'description': '<p>the z-coordinate of the first point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z2',
                      'description': '<p>the z-coordinate of the second point.</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'point': {
              'name': 'point',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>the x-coordinate.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>the y-coordinate.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>the z-coordinate (for WebGL mode).</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'coordinateVector',
                      'description': '<p>the coordinate vector.</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'quad': {
              'name': 'quad',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '<p>the x-coordinate of the first point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '<p>the y-coordinate of the first point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '<p>the x-coordinate of the second point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '<p>the y-coordinate of the second point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '<p>the x-coordinate of the third point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '<p>the y-coordinate of the third point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '<p>the x-coordinate of the fourth point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '<p>the y-coordinate of the fourth point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'detailX',
                      'description': '<p>number of segments in the x-direction.</p>\n',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'detailY',
                      'description': '<p>number of segments in the y-direction.</p>\n',
                      'type': 'Integer',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z1',
                      'description': '<p>the z-coordinate of the first point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z2',
                      'description': '<p>the z-coordinate of the second point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z3',
                      'description': '<p>the z-coordinate of the third point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z4',
                      'description': '<p>the z-coordinate of the fourth point.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'detailX',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'detailY',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'rect': {
              'name': 'rect',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the rectangle.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the rectangle.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '<p>width of the rectangle.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the rectangle.</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'tl',
                      'description': '<p>optional radius of top-left corner.</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'tr',
                      'description': '<p>optional radius of top-right corner.</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'br',
                      'description': '<p>optional radius of bottom-right corner.</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'bl',
                      'description': '<p>optional radius of bottom-left corner.</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'detailX',
                      'description': '<p>number of segments in the x-direction (for WebGL mode).</p>\n',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'detailY',
                      'description': '<p>number of segments in the y-direction (for WebGL mode).</p>\n',
                      'type': 'Integer',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'square': {
              'name': 'square',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the square.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the square.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 's',
                  'description': '<p>side size of the square.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'tl',
                  'description': '<p>optional radius of top-left corner.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'tr',
                  'description': '<p>optional radius of top-right corner.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'br',
                  'description': '<p>optional radius of bottom-right corner.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'bl',
                  'description': '<p>optional radius of bottom-left corner.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'triangle': {
              'name': 'triangle',
              'params': [
                {
                  'name': 'x1',
                  'description': '<p>x-coordinate of the first point.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y1',
                  'description': '<p>y-coordinate of the first point.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'x2',
                  'description': '<p>x-coordinate of the second point.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y2',
                  'description': '<p>y-coordinate of the second point.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'x3',
                  'description': '<p>x-coordinate of the third point.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y3',
                  'description': '<p>y-coordinate of the third point.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'ellipseMode': {
              'name': 'ellipseMode',
              'params': [
                {
                  'name': 'mode',
                  'description': '<p>either CENTER, RADIUS, CORNER, or CORNERS</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'noSmooth': {
              'name': 'noSmooth',
              'class': 'p5',
              'module': 'Shape'
            },
            'rectMode': {
              'name': 'rectMode',
              'params': [
                {
                  'name': 'mode',
                  'description': '<p>either CORNER, CORNERS, CENTER, or RADIUS</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'smooth': {
              'name': 'smooth',
              'class': 'p5',
              'module': 'Shape'
            },
            'strokeCap': {
              'name': 'strokeCap',
              'params': [
                {
                  'name': 'cap',
                  'description': '<p>either ROUND, SQUARE, or PROJECT</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'strokeJoin': {
              'name': 'strokeJoin',
              'params': [
                {
                  'name': 'join',
                  'description': '<p>either MITER, BEVEL, or ROUND</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'strokeWeight': {
              'name': 'strokeWeight',
              'params': [
                {
                  'name': 'weight',
                  'description': '<p>the weight of the stroke (in pixels).</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'bezier': {
              'name': 'bezier',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '<p>x-coordinate for the first anchor point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '<p>y-coordinate for the first anchor point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '<p>x-coordinate for the first control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '<p>y-coordinate for the first control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '<p>x-coordinate for the second control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '<p>y-coordinate for the second control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '<p>x-coordinate for the second anchor point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '<p>y-coordinate for the second anchor point</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z1',
                      'description': '<p>z-coordinate for the first anchor point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z2',
                      'description': '<p>z-coordinate for the first control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z3',
                      'description': '<p>z-coordinate for the second control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z4',
                      'description': '<p>z-coordinate for the second anchor point</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'bezierDetail': {
              'name': 'bezierDetail',
              'params': [
                {
                  'name': 'detail',
                  'description': '<p>resolution of the curves</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'bezierPoint': {
              'name': 'bezierPoint',
              'params': [
                {
                  'name': 'a',
                  'description': '<p>coordinate of first point on the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'b',
                  'description': '<p>coordinate of first control point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'c',
                  'description': '<p>coordinate of second control point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'd',
                  'description': '<p>coordinate of second point on the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 't',
                  'description': '<p>value between 0 and 1</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'bezierTangent': {
              'name': 'bezierTangent',
              'params': [
                {
                  'name': 'a',
                  'description': '<p>coordinate of first point on the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'b',
                  'description': '<p>coordinate of first control point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'c',
                  'description': '<p>coordinate of second control point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'd',
                  'description': '<p>coordinate of second point on the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 't',
                  'description': '<p>value between 0 and 1</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'curve': {
              'name': 'curve',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '<p>x-coordinate for the beginning control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '<p>y-coordinate for the beginning control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '<p>x-coordinate for the first point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '<p>y-coordinate for the first point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '<p>x-coordinate for the second point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '<p>y-coordinate for the second point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '<p>x-coordinate for the ending control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '<p>y-coordinate for the ending control point</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z1',
                      'description': '<p>z-coordinate for the beginning control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z2',
                      'description': '<p>z-coordinate for the first point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z3',
                      'description': '<p>z-coordinate for the second point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z4',
                      'description': '<p>z-coordinate for the ending control point</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'curveDetail': {
              'name': 'curveDetail',
              'params': [
                {
                  'name': 'resolution',
                  'description': '<p>resolution of the curves</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'curveTightness': {
              'name': 'curveTightness',
              'params': [
                {
                  'name': 'amount',
                  'description': '<p>amount of deformation from the original vertices</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'curvePoint': {
              'name': 'curvePoint',
              'params': [
                {
                  'name': 'a',
                  'description': '<p>coordinate of first control point of the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'b',
                  'description': '<p>coordinate of first point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'c',
                  'description': '<p>coordinate of second point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'd',
                  'description': '<p>coordinate of second control point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 't',
                  'description': '<p>value between 0 and 1</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'curveTangent': {
              'name': 'curveTangent',
              'params': [
                {
                  'name': 'a',
                  'description': '<p>coordinate of first control point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'b',
                  'description': '<p>coordinate of first point on the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'c',
                  'description': '<p>coordinate of second point on the curve</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'd',
                  'description': '<p>coordinate of second conrol point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 't',
                  'description': '<p>value between 0 and 1</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'beginContour': {
              'name': 'beginContour',
              'class': 'p5',
              'module': 'Shape'
            },
            'beginShape': {
              'name': 'beginShape',
              'params': [
                {
                  'name': 'kind',
                  'description': '<p>either POINTS, LINES, TRIANGLES, TRIANGLE_FAN\n                               TRIANGLE_STRIP, QUADS, QUAD_STRIP or TESS</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'bezierVertex': {
              'name': 'bezierVertex',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x2',
                      'description': '<p>x-coordinate for the first control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '<p>y-coordinate for the first control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '<p>x-coordinate for the second control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '<p>y-coordinate for the second control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '<p>x-coordinate for the anchor point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '<p>y-coordinate for the anchor point</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z2',
                      'description': '<p>z-coordinate for the first control point (for WebGL mode)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z3',
                      'description': '<p>z-coordinate for the second control point (for WebGL mode)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y4',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z4',
                      'description': '<p>z-coordinate for the anchor point (for WebGL mode)</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'curveVertex': {
              'name': 'curveVertex',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the vertex</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the vertex</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>z-coordinate of the vertex (for WebGL mode)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'endContour': {
              'name': 'endContour',
              'class': 'p5',
              'module': 'Shape'
            },
            'endShape': {
              'name': 'endShape',
              'params': [
                {
                  'name': 'mode',
                  'description': '<p>use CLOSE to close the shape</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'quadraticVertex': {
              'name': 'quadraticVertex',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'cx',
                      'description': '<p>x-coordinate for the control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'cy',
                      'description': '<p>y-coordinate for the control point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '<p>x-coordinate for the anchor point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '<p>y-coordinate for the anchor point</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'cx',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'cy',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'cz',
                      'description': '<p>z-coordinate for the control point (for WebGL mode)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z3',
                      'description': '<p>z-coordinate for the anchor point (for WebGL mode)</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'vertex': {
              'name': 'vertex',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the vertex</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the vertex</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>z-coordinate of the vertex.\n                      Defaults to 0 if not specified.</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'u',
                      'description': '<p>the vertex\'s texture u-coordinate</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'v',
                      'description': '<p>the vertex\'s texture v-coordinate</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'normal': {
              'name': 'normal',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'vector',
                      'description': '<p>A p5.Vector representing the vertex normal.</p>\n',
                      'type': 'Vector'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of the vertex normal.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of the vertex normal.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of the vertex normal.</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'VERSION': {
              'name': 'VERSION',
              'class': 'p5',
              'module': 'Constants'
            },
            'P2D': {
              'name': 'P2D',
              'class': 'p5',
              'module': 'Constants'
            },
            'WEBGL': {
              'name': 'WEBGL',
              'class': 'p5',
              'module': 'Constants'
            },
            'WEBGL2': {
              'name': 'WEBGL2',
              'class': 'p5',
              'module': 'Constants'
            },
            'ARROW': {
              'name': 'ARROW',
              'class': 'p5',
              'module': 'Constants'
            },
            'CROSS': {
              'name': 'CROSS',
              'class': 'p5',
              'module': 'Constants'
            },
            'HAND': {
              'name': 'HAND',
              'class': 'p5',
              'module': 'Constants'
            },
            'MOVE': {
              'name': 'MOVE',
              'class': 'p5',
              'module': 'Constants'
            },
            'TEXT': {
              'name': 'TEXT',
              'class': 'p5',
              'module': 'Constants'
            },
            'WAIT': {
              'name': 'WAIT',
              'class': 'p5',
              'module': 'Constants'
            },
            'HALF_PI': {
              'name': 'HALF_PI',
              'class': 'p5',
              'module': 'Constants'
            },
            'PI': {
              'name': 'PI',
              'class': 'p5',
              'module': 'Constants'
            },
            'QUARTER_PI': {
              'name': 'QUARTER_PI',
              'class': 'p5',
              'module': 'Constants'
            },
            'TAU': {
              'name': 'TAU',
              'class': 'p5',
              'module': 'Constants'
            },
            'TWO_PI': {
              'name': 'TWO_PI',
              'class': 'p5',
              'module': 'Constants'
            },
            'DEGREES': {
              'name': 'DEGREES',
              'class': 'p5',
              'module': 'Constants'
            },
            'RADIANS': {
              'name': 'RADIANS',
              'class': 'p5',
              'module': 'Constants'
            },
            'CORNER': {
              'name': 'CORNER',
              'class': 'p5',
              'module': 'Constants'
            },
            'CORNERS': {
              'name': 'CORNERS',
              'class': 'p5',
              'module': 'Constants'
            },
            'RADIUS': {
              'name': 'RADIUS',
              'class': 'p5',
              'module': 'Constants'
            },
            'RIGHT': {
              'name': 'RIGHT',
              'class': 'p5',
              'module': 'Constants'
            },
            'LEFT': {
              'name': 'LEFT',
              'class': 'p5',
              'module': 'Constants'
            },
            'CENTER': {
              'name': 'CENTER',
              'class': 'p5',
              'module': 'Constants'
            },
            'TOP': {
              'name': 'TOP',
              'class': 'p5',
              'module': 'Constants'
            },
            'BOTTOM': {
              'name': 'BOTTOM',
              'class': 'p5',
              'module': 'Constants'
            },
            'BASELINE': {
              'name': 'BASELINE',
              'class': 'p5',
              'module': 'Constants'
            },
            'POINTS': {
              'name': 'POINTS',
              'class': 'p5',
              'module': 'Constants'
            },
            'LINES': {
              'name': 'LINES',
              'class': 'p5',
              'module': 'Constants'
            },
            'LINE_STRIP': {
              'name': 'LINE_STRIP',
              'class': 'p5',
              'module': 'Constants'
            },
            'LINE_LOOP': {
              'name': 'LINE_LOOP',
              'class': 'p5',
              'module': 'Constants'
            },
            'TRIANGLES': {
              'name': 'TRIANGLES',
              'class': 'p5',
              'module': 'Constants'
            },
            'TRIANGLE_FAN': {
              'name': 'TRIANGLE_FAN',
              'class': 'p5',
              'module': 'Constants'
            },
            'TRIANGLE_STRIP': {
              'name': 'TRIANGLE_STRIP',
              'class': 'p5',
              'module': 'Constants'
            },
            'QUADS': {
              'name': 'QUADS',
              'class': 'p5',
              'module': 'Constants'
            },
            'QUAD_STRIP': {
              'name': 'QUAD_STRIP',
              'class': 'p5',
              'module': 'Constants'
            },
            'TESS': {
              'name': 'TESS',
              'class': 'p5',
              'module': 'Constants'
            },
            'CLOSE': {
              'name': 'CLOSE',
              'class': 'p5',
              'module': 'Constants'
            },
            'OPEN': {
              'name': 'OPEN',
              'class': 'p5',
              'module': 'Constants'
            },
            'CHORD': {
              'name': 'CHORD',
              'class': 'p5',
              'module': 'Constants'
            },
            'PIE': {
              'name': 'PIE',
              'class': 'p5',
              'module': 'Constants'
            },
            'PROJECT': {
              'name': 'PROJECT',
              'class': 'p5',
              'module': 'Constants'
            },
            'SQUARE': {
              'name': 'SQUARE',
              'class': 'p5',
              'module': 'Constants'
            },
            'ROUND': {
              'name': 'ROUND',
              'class': 'p5',
              'module': 'Constants'
            },
            'BEVEL': {
              'name': 'BEVEL',
              'class': 'p5',
              'module': 'Constants'
            },
            'MITER': {
              'name': 'MITER',
              'class': 'p5',
              'module': 'Constants'
            },
            'RGB': {
              'name': 'RGB',
              'class': 'p5',
              'module': 'Constants'
            },
            'HSB': {
              'name': 'HSB',
              'class': 'p5',
              'module': 'Constants'
            },
            'HSL': {
              'name': 'HSL',
              'class': 'p5',
              'module': 'Constants'
            },
            'AUTO': {
              'name': 'AUTO',
              'class': 'p5',
              'module': 'Constants'
            },
            'ALT': {
              'name': 'ALT',
              'class': 'p5',
              'module': 'Constants'
            },
            'BACKSPACE': {
              'name': 'BACKSPACE',
              'class': 'p5',
              'module': 'Constants'
            },
            'CONTROL': {
              'name': 'CONTROL',
              'class': 'p5',
              'module': 'Constants'
            },
            'DELETE': {
              'name': 'DELETE',
              'class': 'p5',
              'module': 'Constants'
            },
            'DOWN_ARROW': {
              'name': 'DOWN_ARROW',
              'class': 'p5',
              'module': 'Constants'
            },
            'ENTER': {
              'name': 'ENTER',
              'class': 'p5',
              'module': 'Constants'
            },
            'ESCAPE': {
              'name': 'ESCAPE',
              'class': 'p5',
              'module': 'Constants'
            },
            'LEFT_ARROW': {
              'name': 'LEFT_ARROW',
              'class': 'p5',
              'module': 'Constants'
            },
            'OPTION': {
              'name': 'OPTION',
              'class': 'p5',
              'module': 'Constants'
            },
            'RETURN': {
              'name': 'RETURN',
              'class': 'p5',
              'module': 'Constants'
            },
            'RIGHT_ARROW': {
              'name': 'RIGHT_ARROW',
              'class': 'p5',
              'module': 'Constants'
            },
            'SHIFT': {
              'name': 'SHIFT',
              'class': 'p5',
              'module': 'Constants'
            },
            'TAB': {
              'name': 'TAB',
              'class': 'p5',
              'module': 'Constants'
            },
            'UP_ARROW': {
              'name': 'UP_ARROW',
              'class': 'p5',
              'module': 'Constants'
            },
            'BLEND': {
              'name': 'BLEND',
              'class': 'p5',
              'module': 'Constants'
            },
            'REMOVE': {
              'name': 'REMOVE',
              'class': 'p5',
              'module': 'Constants'
            },
            'ADD': {
              'name': 'ADD',
              'class': 'p5',
              'module': 'Constants'
            },
            'DARKEST': {
              'name': 'DARKEST',
              'class': 'p5',
              'module': 'Constants'
            },
            'LIGHTEST': {
              'name': 'LIGHTEST',
              'class': 'p5',
              'module': 'Constants'
            },
            'DIFFERENCE': {
              'name': 'DIFFERENCE',
              'class': 'p5',
              'module': 'Constants'
            },
            'SUBTRACT': {
              'name': 'SUBTRACT',
              'class': 'p5',
              'module': 'Constants'
            },
            'EXCLUSION': {
              'name': 'EXCLUSION',
              'class': 'p5',
              'module': 'Constants'
            },
            'MULTIPLY': {
              'name': 'MULTIPLY',
              'class': 'p5',
              'module': 'Constants'
            },
            'SCREEN': {
              'name': 'SCREEN',
              'class': 'p5',
              'module': 'Constants'
            },
            'REPLACE': {
              'name': 'REPLACE',
              'class': 'p5',
              'module': 'Constants'
            },
            'OVERLAY': {
              'name': 'OVERLAY',
              'class': 'p5',
              'module': 'Constants'
            },
            'HARD_LIGHT': {
              'name': 'HARD_LIGHT',
              'class': 'p5',
              'module': 'Constants'
            },
            'SOFT_LIGHT': {
              'name': 'SOFT_LIGHT',
              'class': 'p5',
              'module': 'Constants'
            },
            'DODGE': {
              'name': 'DODGE',
              'class': 'p5',
              'module': 'Constants'
            },
            'BURN': {
              'name': 'BURN',
              'class': 'p5',
              'module': 'Constants'
            },
            'THRESHOLD': {
              'name': 'THRESHOLD',
              'class': 'p5',
              'module': 'Constants'
            },
            'GRAY': {
              'name': 'GRAY',
              'class': 'p5',
              'module': 'Constants'
            },
            'OPAQUE': {
              'name': 'OPAQUE',
              'class': 'p5',
              'module': 'Constants'
            },
            'INVERT': {
              'name': 'INVERT',
              'class': 'p5',
              'module': 'Constants'
            },
            'POSTERIZE': {
              'name': 'POSTERIZE',
              'class': 'p5',
              'module': 'Constants'
            },
            'DILATE': {
              'name': 'DILATE',
              'class': 'p5',
              'module': 'Constants'
            },
            'ERODE': {
              'name': 'ERODE',
              'class': 'p5',
              'module': 'Constants'
            },
            'BLUR': {
              'name': 'BLUR',
              'class': 'p5',
              'module': 'Constants'
            },
            'NORMAL': {
              'name': 'NORMAL',
              'class': 'p5',
              'module': 'Constants'
            },
            'ITALIC': {
              'name': 'ITALIC',
              'class': 'p5',
              'module': 'Constants'
            },
            'BOLD': {
              'name': 'BOLD',
              'class': 'p5',
              'module': 'Constants'
            },
            'BOLDITALIC': {
              'name': 'BOLDITALIC',
              'class': 'p5',
              'module': 'Constants'
            },
            'CHAR': {
              'name': 'CHAR',
              'class': 'p5',
              'module': 'Constants'
            },
            'WORD': {
              'name': 'WORD',
              'class': 'p5',
              'module': 'Constants'
            },
            'LINEAR': {
              'name': 'LINEAR',
              'class': 'p5',
              'module': 'Constants'
            },
            'QUADRATIC': {
              'name': 'QUADRATIC',
              'class': 'p5',
              'module': 'Constants'
            },
            'BEZIER': {
              'name': 'BEZIER',
              'class': 'p5',
              'module': 'Constants'
            },
            'CURVE': {
              'name': 'CURVE',
              'class': 'p5',
              'module': 'Constants'
            },
            'STROKE': {
              'name': 'STROKE',
              'class': 'p5',
              'module': 'Constants'
            },
            'FILL': {
              'name': 'FILL',
              'class': 'p5',
              'module': 'Constants'
            },
            'TEXTURE': {
              'name': 'TEXTURE',
              'class': 'p5',
              'module': 'Constants'
            },
            'IMMEDIATE': {
              'name': 'IMMEDIATE',
              'class': 'p5',
              'module': 'Constants'
            },
            'IMAGE': {
              'name': 'IMAGE',
              'class': 'p5',
              'module': 'Constants'
            },
            'NEAREST': {
              'name': 'NEAREST',
              'class': 'p5',
              'module': 'Constants'
            },
            'REPEAT': {
              'name': 'REPEAT',
              'class': 'p5',
              'module': 'Constants'
            },
            'CLAMP': {
              'name': 'CLAMP',
              'class': 'p5',
              'module': 'Constants'
            },
            'MIRROR': {
              'name': 'MIRROR',
              'class': 'p5',
              'module': 'Constants'
            },
            'LANDSCAPE': {
              'name': 'LANDSCAPE',
              'class': 'p5',
              'module': 'Constants'
            },
            'PORTRAIT': {
              'name': 'PORTRAIT',
              'class': 'p5',
              'module': 'Constants'
            },
            'GRID': {
              'name': 'GRID',
              'class': 'p5',
              'module': 'Constants'
            },
            'AXES': {
              'name': 'AXES',
              'class': 'p5',
              'module': 'Constants'
            },
            'LABEL': {
              'name': 'LABEL',
              'class': 'p5',
              'module': 'Constants'
            },
            'FALLBACK': {
              'name': 'FALLBACK',
              'class': 'p5',
              'module': 'Constants'
            },
            'CONTAIN': {
              'name': 'CONTAIN',
              'class': 'p5',
              'module': 'Constants'
            },
            'COVER': {
              'name': 'COVER',
              'class': 'p5',
              'module': 'Constants'
            },
            'UNSIGNED_BYTE': {
              'name': 'UNSIGNED_BYTE',
              'class': 'p5',
              'module': 'Constants'
            },
            'UNSIGNED_INT': {
              'name': 'UNSIGNED_INT',
              'class': 'p5',
              'module': 'Constants'
            },
            'FLOAT': {
              'name': 'FLOAT',
              'class': 'p5',
              'module': 'Constants'
            },
            'RGBA': {
              'name': 'RGBA',
              'class': 'p5',
              'module': 'Constants'
            },
            'print': {
              'name': 'print',
              'params': [
                {
                  'name': 'contents',
                  'description': '<p>any combination of Number, String, Object, Boolean,\n                      Array to print</p>\n',
                  'type': 'Any'
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'frameCount': {
              'name': 'frameCount',
              'class': 'p5',
              'module': 'Environment'
            },
            'deltaTime': {
              'name': 'deltaTime',
              'class': 'p5',
              'module': 'Environment'
            },
            'focused': {
              'name': 'focused',
              'class': 'p5',
              'module': 'Environment'
            },
            'cursor': {
              'name': 'cursor',
              'params': [
                {
                  'name': 'type',
                  'description': '<p>Built-In: either ARROW, CROSS, HAND, MOVE, TEXT and WAIT\n                              Native CSS properties: \'grab\', \'progress\', \'cell\' etc.\n                              External: path for cursor\'s images\n                              (Allowed File extensions: .cur, .gif, .jpg, .jpeg, .png)\n                              For more information on Native CSS cursors and url visit:\n                              <a href="https://developer.mozilla.org/en-US/docs/Web/CSS/cursor">https://developer.mozilla.org/en-US/docs/Web/CSS/cursor</a></p>\n',
                  'type': 'String|Constant'
                },
                {
                  'name': 'x',
                  'description': '<p>the horizontal active spot of the cursor (must be less than 32)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'y',
                  'description': '<p>the vertical active spot of the cursor (must be less than 32)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'frameRate': {
              'name': 'frameRate',
              'class': 'p5',
              'module': 'Environment',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'fps',
                      'description': '<p>number of frames to be displayed every second</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'getTargetFrameRate': {
              'name': 'getTargetFrameRate',
              'class': 'p5',
              'module': 'Environment'
            },
            'noCursor': {
              'name': 'noCursor',
              'class': 'p5',
              'module': 'Environment'
            },
            'webglVersion': {
              'name': 'webglVersion',
              'class': 'p5',
              'module': 'Environment'
            },
            'displayWidth': {
              'name': 'displayWidth',
              'class': 'p5',
              'module': 'Environment'
            },
            'displayHeight': {
              'name': 'displayHeight',
              'class': 'p5',
              'module': 'Environment'
            },
            'windowWidth': {
              'name': 'windowWidth',
              'class': 'p5',
              'module': 'Environment'
            },
            'windowHeight': {
              'name': 'windowHeight',
              'class': 'p5',
              'module': 'Environment'
            },
            'windowResized': {
              'name': 'windowResized',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional Event callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'width': {
              'name': 'width',
              'class': 'p5',
              'module': 'Environment'
            },
            'height': {
              'name': 'height',
              'class': 'p5',
              'module': 'Environment'
            },
            'fullscreen': {
              'name': 'fullscreen',
              'params': [
                {
                  'name': 'val',
                  'description': '<p>whether the sketch should be in fullscreen mode\nor not</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Environment'
            },
            'pixelDensity': {
              'name': 'pixelDensity',
              'class': 'p5',
              'module': 'Environment',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'val',
                      'description': '<p>whether or how much the sketch should scale</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'displayDensity': {
              'name': 'displayDensity',
              'class': 'p5',
              'module': 'Environment'
            },
            'getURL': {
              'name': 'getURL',
              'class': 'p5',
              'module': 'Environment'
            },
            'getURLPath': {
              'name': 'getURLPath',
              'class': 'p5',
              'module': 'Environment'
            },
            'getURLParams': {
              'name': 'getURLParams',
              'class': 'p5',
              'module': 'Environment'
            },
            'preload': {
              'name': 'preload',
              'class': 'p5',
              'module': 'Structure'
            },
            'setup': {
              'name': 'setup',
              'class': 'p5',
              'module': 'Structure'
            },
            'draw': {
              'name': 'draw',
              'class': 'p5',
              'module': 'Structure'
            },
            'remove': {
              'name': 'remove',
              'class': 'p5',
              'module': 'Structure'
            },
            'disableFriendlyErrors': {
              'name': 'disableFriendlyErrors',
              'class': 'p5',
              'module': 'Structure'
            },
            'let': {
              'name': 'let',
              'class': 'p5',
              'module': 'Foundation'
            },
            'const': {
              'name': 'const',
              'class': 'p5',
              'module': 'Foundation'
            },
            '===': {
              'name': '===',
              'class': 'p5',
              'module': 'Foundation'
            },
            '>': {
              'name': '>',
              'class': 'p5',
              'module': 'Foundation'
            },
            '>=': {
              'name': '>=',
              'class': 'p5',
              'module': 'Foundation'
            },
            '<': {
              'name': '<',
              'class': 'p5',
              'module': 'Foundation'
            },
            '<=': {
              'name': '<=',
              'class': 'p5',
              'module': 'Foundation'
            },
            'if-else': {
              'name': 'if-else',
              'class': 'p5',
              'module': 'Foundation'
            },
            'function': {
              'name': 'function',
              'class': 'p5',
              'module': 'Foundation'
            },
            'return': {
              'name': 'return',
              'class': 'p5',
              'module': 'Foundation'
            },
            'boolean': {
              'name': 'boolean',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>value to parse</p>\n',
                  'type': 'String|Boolean|Number|Array'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'string': {
              'name': 'string',
              'class': 'p5',
              'module': 'Foundation'
            },
            'number': {
              'name': 'number',
              'class': 'p5',
              'module': 'Foundation'
            },
            'object': {
              'name': 'object',
              'class': 'p5',
              'module': 'Foundation'
            },
            'class': {
              'name': 'class',
              'class': 'p5',
              'module': 'Foundation'
            },
            'for': {
              'name': 'for',
              'class': 'p5',
              'module': 'Foundation'
            },
            'while': {
              'name': 'while',
              'class': 'p5',
              'module': 'Foundation'
            },
            'createCanvas': {
              'name': 'createCanvas',
              'class': 'p5',
              'module': 'Rendering',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'w',
                      'description': '<p>width of the canvas</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the canvas</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'renderer',
                      'description': '<p>either P2D or WEBGL</p>\n',
                      'type': 'Constant',
                      'optional': true
                    },
                    {
                      'name': 'canvas',
                      'description': '<p>existing html canvas element</p>\n',
                      'type': 'Object',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'w',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'canvas',
                      'description': '',
                      'type': 'Object',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'resizeCanvas': {
              'name': 'resizeCanvas',
              'params': [
                {
                  'name': 'w',
                  'description': '<p>width of the canvas</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'h',
                  'description': '<p>height of the canvas</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'noRedraw',
                  'description': '<p>don\'t redraw the canvas immediately</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Rendering'
            },
            'noCanvas': {
              'name': 'noCanvas',
              'class': 'p5',
              'module': 'Rendering'
            },
            'createGraphics': {
              'name': 'createGraphics',
              'class': 'p5',
              'module': 'Rendering',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'w',
                      'description': '<p>width of the offscreen graphics buffer</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the offscreen graphics buffer</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'renderer',
                      'description': '<p>either P2D or WEBGL\n                              undefined defaults to p2d</p>\n',
                      'type': 'Constant',
                      'optional': true
                    },
                    {
                      'name': 'canvas',
                      'description': '<p>existing html canvas element</p>\n',
                      'type': 'Object',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'w',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'canvas',
                      'description': '',
                      'type': 'Object',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'createFramebuffer': {
              'name': 'createFramebuffer',
              'params': [
                {
                  'name': 'options',
                  'description': '<p>An optional object with configuration</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Rendering'
            },
            'blendMode': {
              'name': 'blendMode',
              'params': [
                {
                  'name': 'mode',
                  'description': '<p>blend mode to set for canvas.\n               either BLEND, DARKEST, LIGHTEST, DIFFERENCE, MULTIPLY,\n               EXCLUSION, SCREEN, REPLACE, OVERLAY, HARD_LIGHT,\n               SOFT_LIGHT, DODGE, BURN, ADD, REMOVE or SUBTRACT</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Rendering'
            },
            'drawingContext': {
              'name': 'drawingContext',
              'class': 'p5',
              'module': 'Rendering'
            },
            'noLoop': {
              'name': 'noLoop',
              'class': 'p5',
              'module': 'Structure'
            },
            'loop': {
              'name': 'loop',
              'class': 'p5',
              'module': 'Structure'
            },
            'isLooping': {
              'name': 'isLooping',
              'class': 'p5',
              'module': 'Structure'
            },
            'push': {
              'name': 'push',
              'class': 'p5',
              'module': 'Structure'
            },
            'pop': {
              'name': 'pop',
              'class': 'p5',
              'module': 'Structure'
            },
            'redraw': {
              'name': 'redraw',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>Redraw for n-times. The default value is 1.</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Structure'
            },
            'p5': {
              'name': 'p5',
              'params': [
                {
                  'name': 'sketch',
                  'description': '<p>a function containing a p5.js sketch</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'node',
                  'description': '<p>ID or pointer to HTML DOM node to contain sketch in</p>\n',
                  'type': 'String|Object'
                }
              ],
              'class': 'p5',
              'module': 'Structure'
            },
            'applyMatrix': {
              'name': 'applyMatrix',
              'class': 'p5',
              'module': 'Transform',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'arr',
                      'description': '<p>an array of numbers - should be 6 or 16 length (2×3 or 4×4 matrix values)</p>\n',
                      'type': 'Array'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'a',
                      'description': '<p>numbers which define the 2×3 or 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'b',
                      'description': '<p>numbers which define the 2×3 or 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'c',
                      'description': '<p>numbers which define the 2×3 or 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'd',
                      'description': '<p>numbers which define the 2×3 or 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'e',
                      'description': '<p>numbers which define the 2×3 or 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'f',
                      'description': '<p>numbers which define the 2×3 or 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'a',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'b',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'c',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'd',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'e',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'f',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'g',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'i',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'j',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'k',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'l',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'm',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'n',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'o',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'p',
                      'description': '<p>numbers which define the 4×4 matrix to be multiplied</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'resetMatrix': {
              'name': 'resetMatrix',
              'class': 'p5',
              'module': 'Transform'
            },
            'rotate': {
              'name': 'rotate',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle of rotation, specified in radians\n                       or degrees, depending on current angleMode</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'axis',
                  'description': '<p>(in 3d) the axis to rotate around</p>\n',
                  'type': 'p5.Vector|Number[]',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Transform'
            },
            'rotateX': {
              'name': 'rotateX',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle of rotation, specified in radians\n                       or degrees, depending on current angleMode</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Transform'
            },
            'rotateY': {
              'name': 'rotateY',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle of rotation, specified in radians\n                       or degrees, depending on current angleMode</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Transform'
            },
            'rotateZ': {
              'name': 'rotateZ',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle of rotation, specified in radians\n                       or degrees, depending on current angleMode</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Transform'
            },
            'scale': {
              'name': 'scale',
              'class': 'p5',
              'module': 'Transform',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 's',
                      'description': '<p>percent to scale the object, or percentage to\n                     scale the object in the x-axis if multiple arguments\n                     are given</p>\n',
                      'type': 'Number|p5.Vector|Number[]'
                    },
                    {
                      'name': 'y',
                      'description': '<p>percent to scale the object in the y-axis</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'z',
                      'description': '<p>percent to scale the object in the z-axis (webgl only)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'scales',
                      'description': '<p>per-axis percents to scale the object</p>\n',
                      'type': 'p5.Vector|Number[]'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'shearX': {
              'name': 'shearX',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>angle of shear specified in radians or degrees,\n                       depending on current angleMode</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Transform'
            },
            'shearY': {
              'name': 'shearY',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>angle of shear specified in radians or degrees,\n                       depending on current angleMode</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Transform'
            },
            'translate': {
              'name': 'translate',
              'class': 'p5',
              'module': 'Transform',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>left/right translation</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>up/down translation</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>forward/backward translation (WEBGL only)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'vector',
                      'description': '<p>the vector to translate by</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'storeItem': {
              'name': 'storeItem',
              'params': [
                {
                  'name': 'key',
                  'description': '',
                  'type': 'String'
                },
                {
                  'name': 'value',
                  'description': '',
                  'type': 'String|Number|Object|Boolean|p5.Color|p5.Vector'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'getItem': {
              'name': 'getItem',
              'params': [
                {
                  'name': 'key',
                  'description': '<p>name that you wish to use to store in local storage</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'clearStorage': {
              'name': 'clearStorage',
              'class': 'p5',
              'module': 'Data'
            },
            'removeItem': {
              'name': 'removeItem',
              'params': [
                {
                  'name': 'key',
                  'description': '',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'createStringDict': {
              'name': 'createStringDict',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'key',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'value',
                      'description': '',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'object',
                      'description': '<p>object</p>\n',
                      'type': 'Object'
                    }
                  ]
                }
              ]
            },
            'createNumberDict': {
              'name': 'createNumberDict',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'key',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'value',
                      'description': '',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'object',
                      'description': '<p>object</p>\n',
                      'type': 'Object'
                    }
                  ]
                }
              ]
            },
            'select': {
              'name': 'select',
              'params': [
                {
                  'name': 'selectors',
                  'description': '<p>CSS selector string of element to search for</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'container',
                  'description': '<p>CSS selector string, <a href="#/p5.Element">p5.Element</a>, or\n                                            HTML element to search within</p>\n',
                  'type': 'String|p5.Element|HTMLElement',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'selectAll': {
              'name': 'selectAll',
              'params': [
                {
                  'name': 'selectors',
                  'description': '<p>CSS selector string of elements to search for</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'container',
                  'description': '<p>CSS selector string, <a href="#/p5.Element">p5.Element</a>\n                                            , or HTML element to search within</p>\n',
                  'type': 'String|p5.Element|HTMLElement',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'removeElements': {
              'name': 'removeElements',
              'class': 'p5',
              'module': 'DOM'
            },
            'changed': {
              'name': 'changed',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when the value of\n                               an element changes.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'input': {
              'name': 'input',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when any user input is\n                               detected within the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createDiv': {
              'name': 'createDiv',
              'params': [
                {
                  'name': 'html',
                  'description': '<p>inner HTML for element created</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createP': {
              'name': 'createP',
              'params': [
                {
                  'name': 'html',
                  'description': '<p>inner HTML for element created</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createSpan': {
              'name': 'createSpan',
              'params': [
                {
                  'name': 'html',
                  'description': '<p>inner HTML for element created</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createImg': {
              'name': 'createImg',
              'class': 'p5',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'src',
                      'description': '<p>src path or url for image</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'alt',
                      'description': '<p><a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Img#Attributes">alternate text</a> to be used if image does not load. You can use also an empty string (<code>""</code>) if that an image is not intended to be viewed.</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'src',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'alt',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'crossOrigin',
                      'description': '<p><a href="https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes">crossOrigin property</a> of the <code>img</code> element; use either \'anonymous\' or \'use-credentials\' to retrieve the image with cross-origin access (for later use with <code>canvas</code>. if an empty string(<code>""</code>) is passed, CORS is not used</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'successCallback',
                      'description': '<p>callback to be called once image data is loaded with the <a href="#/p5.Element">p5.Element</a> as argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'createA': {
              'name': 'createA',
              'params': [
                {
                  'name': 'href',
                  'description': '<p>url of page to link to</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'html',
                  'description': '<p>inner html of link element to display</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'target',
                  'description': '<p>target where new link should open,\n                            could be _blank, _self, _parent, _top.</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createSlider': {
              'name': 'createSlider',
              'params': [
                {
                  'name': 'min',
                  'description': '<p>minimum value of the slider</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'max',
                  'description': '<p>maximum value of the slider</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'value',
                  'description': '<p>default value of the slider</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'step',
                  'description': '<p>step size for each tick of the slider (if step is set to 0, the slider will move continuously from the minimum to the maximum value)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createButton': {
              'name': 'createButton',
              'params': [
                {
                  'name': 'label',
                  'description': '<p>label displayed on the button</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'value',
                  'description': '<p>value of the button</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createCheckbox': {
              'name': 'createCheckbox',
              'params': [
                {
                  'name': 'label',
                  'description': '<p>label displayed after checkbox</p>\n',
                  'type': 'String',
                  'optional': true
                },
                {
                  'name': 'value',
                  'description': '<p>value of the checkbox; checked is true, unchecked is false</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createSelect': {
              'name': 'createSelect',
              'class': 'p5',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'multiple',
                      'description': '<p>true if dropdown should support multiple selections</p>\n',
                      'type': 'Boolean',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'existing',
                      'description': '<p>DOM select element</p>\n',
                      'type': 'Object'
                    }
                  ]
                }
              ]
            },
            'createRadio': {
              'name': 'createRadio',
              'class': 'p5',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'containerElement',
                      'description': '<p>A container HTML Element, either a div\nor span, inside which all existing radio inputs will be considered as options.</p>\n',
                      'type': 'Object'
                    },
                    {
                      'name': 'name',
                      'description': '<p>A name parameter for each Input Element.</p>\n',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'name',
                      'description': '',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'createColorPicker': {
              'name': 'createColorPicker',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>default color of element</p>\n',
                  'type': 'String|p5.Color',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createInput': {
              'name': 'createInput',
              'class': 'p5',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>default value of the input box</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'type',
                      'description': '<p>type of text, ie text, password etc. Defaults to text.\n  Needs a value to be specified first.</p>\n',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'createFileInput': {
              'name': 'createFileInput',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>callback function for when a file is loaded</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'multiple',
                  'description': '<p>optional, to allow multiple files to be selected</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createVideo': {
              'name': 'createVideo',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>path to a video file, or array of paths for\n                            supporting different browsers</p>\n',
                  'type': 'String|String[]'
                },
                {
                  'name': 'callback',
                  'description': '<p>callback function to be called upon\n                            \'canplaythrough\' event fire, that is, when the\n                            browser can play the media, and estimates that\n                            enough data has been loaded to play the media\n                            up to its end without having to stop for\n                            further buffering of content</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createAudio': {
              'name': 'createAudio',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>path to an audio file, or array of paths\n                            for supporting different browsers</p>\n',
                  'type': 'String|String[]',
                  'optional': true
                },
                {
                  'name': 'callback',
                  'description': '<p>callback function to be called upon\n                            \'canplaythrough\' event fire, that is, when the\n                            browser can play the media, and estimates that\n                            enough data has been loaded to play the media\n                            up to its end without having to stop for\n                            further buffering of content</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createCapture': {
              'name': 'createCapture',
              'params': [
                {
                  'name': 'type',
                  'description': '<p>type of capture, either VIDEO or\n                                  AUDIO if none specified, default both,\n                                  or a Constraints object</p>\n',
                  'type': 'String|Constant|Object'
                },
                {
                  'name': 'callback',
                  'description': '<p>function to be called once\n                                  stream has loaded</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'createElement': {
              'name': 'createElement',
              'params': [
                {
                  'name': 'tag',
                  'description': '<p>tag for the new element</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'content',
                  'description': '<p>html content to be inserted into the element</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'DOM'
            },
            'deviceOrientation': {
              'name': 'deviceOrientation',
              'class': 'p5',
              'module': 'Events'
            },
            'accelerationX': {
              'name': 'accelerationX',
              'class': 'p5',
              'module': 'Events'
            },
            'accelerationY': {
              'name': 'accelerationY',
              'class': 'p5',
              'module': 'Events'
            },
            'accelerationZ': {
              'name': 'accelerationZ',
              'class': 'p5',
              'module': 'Events'
            },
            'pAccelerationX': {
              'name': 'pAccelerationX',
              'class': 'p5',
              'module': 'Events'
            },
            'pAccelerationY': {
              'name': 'pAccelerationY',
              'class': 'p5',
              'module': 'Events'
            },
            'pAccelerationZ': {
              'name': 'pAccelerationZ',
              'class': 'p5',
              'module': 'Events'
            },
            'rotationX': {
              'name': 'rotationX',
              'class': 'p5',
              'module': 'Events'
            },
            'rotationY': {
              'name': 'rotationY',
              'class': 'p5',
              'module': 'Events'
            },
            'rotationZ': {
              'name': 'rotationZ',
              'class': 'p5',
              'module': 'Events'
            },
            'pRotationX': {
              'name': 'pRotationX',
              'class': 'p5',
              'module': 'Events'
            },
            'pRotationY': {
              'name': 'pRotationY',
              'class': 'p5',
              'module': 'Events'
            },
            'pRotationZ': {
              'name': 'pRotationZ',
              'class': 'p5',
              'module': 'Events'
            },
            'turnAxis': {
              'name': 'turnAxis',
              'class': 'p5',
              'module': 'Events'
            },
            'setMoveThreshold': {
              'name': 'setMoveThreshold',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>The threshold value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'setShakeThreshold': {
              'name': 'setShakeThreshold',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>The threshold value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'deviceMoved': {
              'name': 'deviceMoved',
              'class': 'p5',
              'module': 'Events'
            },
            'deviceTurned': {
              'name': 'deviceTurned',
              'class': 'p5',
              'module': 'Events'
            },
            'deviceShaken': {
              'name': 'deviceShaken',
              'class': 'p5',
              'module': 'Events'
            },
            'keyIsPressed': {
              'name': 'keyIsPressed',
              'class': 'p5',
              'module': 'Events'
            },
            'key': {
              'name': 'key',
              'class': 'p5',
              'module': 'Events'
            },
            'keyCode': {
              'name': 'keyCode',
              'class': 'p5',
              'module': 'Events'
            },
            'keyPressed': {
              'name': 'keyPressed',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional KeyboardEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'keyReleased': {
              'name': 'keyReleased',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional KeyboardEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'keyTyped': {
              'name': 'keyTyped',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional KeyboardEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'keyIsDown': {
              'name': 'keyIsDown',
              'params': [
                {
                  'name': 'code',
                  'description': '<p>The key to check for.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'movedX': {
              'name': 'movedX',
              'class': 'p5',
              'module': 'Events'
            },
            'movedY': {
              'name': 'movedY',
              'class': 'p5',
              'module': 'Events'
            },
            'mouseX': {
              'name': 'mouseX',
              'class': 'p5',
              'module': 'Events'
            },
            'mouseY': {
              'name': 'mouseY',
              'class': 'p5',
              'module': 'Events'
            },
            'pmouseX': {
              'name': 'pmouseX',
              'class': 'p5',
              'module': 'Events'
            },
            'pmouseY': {
              'name': 'pmouseY',
              'class': 'p5',
              'module': 'Events'
            },
            'winMouseX': {
              'name': 'winMouseX',
              'class': 'p5',
              'module': 'Events'
            },
            'winMouseY': {
              'name': 'winMouseY',
              'class': 'p5',
              'module': 'Events'
            },
            'pwinMouseX': {
              'name': 'pwinMouseX',
              'class': 'p5',
              'module': 'Events'
            },
            'pwinMouseY': {
              'name': 'pwinMouseY',
              'class': 'p5',
              'module': 'Events'
            },
            'mouseButton': {
              'name': 'mouseButton',
              'class': 'p5',
              'module': 'Events'
            },
            'mouseIsPressed': {
              'name': 'mouseIsPressed',
              'class': 'p5',
              'module': 'Events'
            },
            'mouseMoved': {
              'name': 'mouseMoved',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional MouseEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'mouseDragged': {
              'name': 'mouseDragged',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional MouseEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'mousePressed': {
              'name': 'mousePressed',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional MouseEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'mouseReleased': {
              'name': 'mouseReleased',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional MouseEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'mouseClicked': {
              'name': 'mouseClicked',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional MouseEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'doubleClicked': {
              'name': 'doubleClicked',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional MouseEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'mouseWheel': {
              'name': 'mouseWheel',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional WheelEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'requestPointerLock': {
              'name': 'requestPointerLock',
              'class': 'p5',
              'module': 'Events'
            },
            'exitPointerLock': {
              'name': 'exitPointerLock',
              'class': 'p5',
              'module': 'Events'
            },
            'touches': {
              'name': 'touches',
              'class': 'p5',
              'module': 'Events'
            },
            'touchStarted': {
              'name': 'touchStarted',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional TouchEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'touchMoved': {
              'name': 'touchMoved',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional TouchEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'touchEnded': {
              'name': 'touchEnded',
              'params': [
                {
                  'name': 'event',
                  'description': '<p>optional TouchEvent callback argument.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Events'
            },
            'createImage': {
              'name': 'createImage',
              'params': [
                {
                  'name': 'width',
                  'description': '<p>width in pixels</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'height',
                  'description': '<p>height in pixels</p>\n',
                  'type': 'Integer'
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'saveCanvas': {
              'name': 'saveCanvas',
              'class': 'p5',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'selectedCanvas',
                      'description': '<p>a variable\n                                representing a specific html5 canvas (optional)</p>\n',
                      'type': 'p5.Element|HTMLCanvasElement'
                    },
                    {
                      'name': 'filename',
                      'description': '',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'extension',
                      'description': '<p>\'jpg\' or \'png\'</p>\n',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'filename',
                      'description': '',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'extension',
                      'description': '',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'saveFrames': {
              'name': 'saveFrames',
              'params': [
                {
                  'name': 'filename',
                  'description': '',
                  'type': 'String'
                },
                {
                  'name': 'extension',
                  'description': '<p>\'jpg\' or \'png\'</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'duration',
                  'description': '<p>Duration in seconds to save the frames for. This parameter will be constrained to be less or equal to 15.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'framerate',
                  'description': '<p>Framerate to save the frames in. This parameter will be constrained to be less or equal to 22.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'callback',
                  'description': '<p>A callback function that will be executed\n                                to handle the image data. This function\n                                should accept an array as argument. The\n                                array will contain the specified number of\n                                frames of objects. Each object has three\n                                properties: imageData - an\n                                image/octet-stream, filename and extension.</p>\n',
                  'type': 'Function(Array)',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'loadImage': {
              'name': 'loadImage',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>Path of the image to be loaded</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'successCallback',
                  'description': '<p>Function to be called once\n                               the image is loaded. Will be passed the\n                               <a href="#/p5.Image">p5.Image</a>.</p>\n',
                  'type': 'function(p5.Image)',
                  'optional': true
                },
                {
                  'name': 'failureCallback',
                  'description': '<p>called with event error if\n                               the image fails to load.</p>\n',
                  'type': 'Function(Event)',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'saveGif': {
              'name': 'saveGif',
              'params': [
                {
                  'name': 'filename',
                  'description': '<p>File name of your gif</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'duration',
                  'description': '<p>Duration in seconds that you wish to capture from your sketch</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'options',
                  'description': '<p>An optional object that can contain five more arguments:\ndelay, specifying how much time we should wait before recording;\nunits, a string that can be either \'seconds\' or \'frames\'. By default it\'s \'seconds’;\nsilent, a boolean that defines presence of progress notifications. By default it’s false;\nnotificationDuration, a number that defines how long in seconds the final notification\nwill live. 0, the default value, means that the notification will never be removed;\nnotificationID, a string that specifies the notification DOM element id. By default it’s \'progressBar’.</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'image': {
              'name': 'image',
              'class': 'p5',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'img',
                      'description': '<p>the image to display</p>\n',
                      'type': 'p5.Image|p5.Element|p5.Texture|p5.Framebuffer|p5.FramebufferTexture'
                    },
                    {
                      'name': 'x',
                      'description': '<p>the x-coordinate of the top-left corner of the image</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>the y-coordinate of the top-left corner of the image</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'width',
                      'description': '<p>the width to draw the image</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'height',
                      'description': '<p>the height to draw the image</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'img',
                      'description': '',
                      'type': 'p5.Image|p5.Element|p5.Texture|p5.Framebuffer|p5.FramebufferTexture'
                    },
                    {
                      'name': 'dx',
                      'description': '<p>the x-coordinate of the destination\n                          rectangle in which to draw the source image</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'dy',
                      'description': '<p>the y-coordinate of the destination\n                          rectangle in which to draw the source image</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'dWidth',
                      'description': '<p>the width of the destination rectangle</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'dHeight',
                      'description': '<p>the height of the destination rectangle</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'sx',
                      'description': '<p>the x-coordinate of the subsection of the source\nimage to draw into the destination rectangle</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'sy',
                      'description': '<p>the y-coordinate of the subsection of the source\nimage to draw into the destination rectangle</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'sWidth',
                      'description': '<p>the width of the subsection of the\n                          source image to draw into the destination\n                          rectangle</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'sHeight',
                      'description': '<p>the height of the subsection of the\n                           source image to draw into the destination rectangle</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'fit',
                      'description': '<p>either CONTAIN or COVER</p>\n',
                      'type': 'Constant',
                      'optional': true
                    },
                    {
                      'name': 'xAlign',
                      'description': '<p>either LEFT, RIGHT or CENTER default is CENTER</p>\n',
                      'type': 'Constant',
                      'optional': true
                    },
                    {
                      'name': 'yAlign',
                      'description': '<p>either TOP, BOTTOM or CENTER default is CENTER</p>\n',
                      'type': 'Constant',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'tint': {
              'name': 'tint',
              'class': 'p5',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to\n                                the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value\n                                relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value\n                                relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>a color string</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>a gray value</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>an array containing the red,green,blue &\n                                and alpha components of the color</p>\n',
                      'type': 'Number[]'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>the tint color</p>\n',
                      'type': 'p5.Color'
                    }
                  ]
                }
              ]
            },
            'noTint': {
              'name': 'noTint',
              'class': 'p5',
              'module': 'Image'
            },
            'imageMode': {
              'name': 'imageMode',
              'params': [
                {
                  'name': 'mode',
                  'description': '<p>either CORNER, CORNERS, or CENTER</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'pixels': {
              'name': 'pixels',
              'class': 'p5',
              'module': 'Image'
            },
            'blend': {
              'name': 'blend',
              'class': 'p5',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'srcImage',
                      'description': '<p>source image</p>\n',
                      'type': 'p5.Image'
                    },
                    {
                      'name': 'sx',
                      'description': '<p>X coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '<p>Y coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '<p>source image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '<p>source image height</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '<p>X coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '<p>Y coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '<p>destination image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '<p>destination image height</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'blendMode',
                      'description': '<p>the blend mode. either\n    BLEND, DARKEST, LIGHTEST, DIFFERENCE,\n    MULTIPLY, EXCLUSION, SCREEN, REPLACE, OVERLAY, HARD_LIGHT,\n    SOFT_LIGHT, DODGE, BURN, ADD or NORMAL.</p>\n',
                      'type': 'Constant'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'sx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'blendMode',
                      'description': '',
                      'type': 'Constant'
                    }
                  ]
                }
              ]
            },
            'copy': {
              'name': 'copy',
              'class': 'p5',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'srcImage',
                      'description': '<p>source image</p>\n',
                      'type': 'p5.Image|p5.Element'
                    },
                    {
                      'name': 'sx',
                      'description': '<p>X coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '<p>Y coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '<p>source image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '<p>source image height</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '<p>X coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '<p>Y coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '<p>destination image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '<p>destination image height</p>\n',
                      'type': 'Integer'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'sx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '',
                      'type': 'Integer'
                    }
                  ]
                }
              ]
            },
            'filter': {
              'name': 'filter',
              'params': [
                {
                  'name': 'filterType',
                  'description': '<p>either THRESHOLD, GRAY, OPAQUE, INVERT,\n                               POSTERIZE, BLUR, ERODE, DILATE or BLUR.\n                               See Filters.js for docs on\n                               each available filter</p>\n',
                  'type': 'Constant'
                },
                {
                  'name': 'filterParam',
                  'description': '<p>an optional parameter unique\n                               to each filter, see above</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'get': {
              'name': 'get',
              'class': 'p5',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the pixel</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the pixel</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '<p>width of the section to be returned</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the section to be returned</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    }
                  ]
                }
              ]
            },
            'loadPixels': {
              'name': 'loadPixels',
              'class': 'p5',
              'module': 'Image'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the pixel</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the pixel</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'c',
                  'description': '<p>insert a grayscale value | a pixel array |\n                               a <a href="#/p5.Color">p5.Color</a> object | a <a href="#/p5.Image">p5.Image</a> to copy</p>\n',
                  'type': 'Number|Number[]|Object'
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'updatePixels': {
              'name': 'updatePixels',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the upper-left corner of region\n                        to update</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the upper-left corner of region\n                        to update</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'w',
                  'description': '<p>width of region to update</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'h',
                  'description': '<p>height of region to update</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Image'
            },
            'loadJSON': {
              'name': 'loadJSON',
              'class': 'p5',
              'module': 'IO',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '<p>name of the file or url to load</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'jsonpOptions',
                      'description': '<p>options object for jsonp related settings</p>\n',
                      'type': 'Object',
                      'optional': true
                    },
                    {
                      'name': 'datatype',
                      'description': '<p>"json" or "jsonp"</p>\n',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'callback',
                      'description': '<p>function to be executed after\n                                   <a href="#/p5/loadJSON">loadJSON()</a> completes, data is passed\n                                   in as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '<p>function to be executed if\n                                   there is an error, response is passed\n                                   in as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'datatype',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function'
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'loadStrings': {
              'name': 'loadStrings',
              'params': [
                {
                  'name': 'filename',
                  'description': '<p>name of the file or url to load</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function to be executed after <a href="#/p5/loadStrings">loadStrings()</a>\n                              completes, Array is passed in as first\n                              argument</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function to be executed if\n                              there is an error, response is passed\n                              in as first argument</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'loadTable': {
              'name': 'loadTable',
              'params': [
                {
                  'name': 'filename',
                  'description': '<p>name of the file or URL to load</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'extension',
                  'description': '<p>parse the table by comma-separated values "csv", semicolon-separated\n                                     values "ssv", or tab-separated values "tsv"</p>\n',
                  'type': 'String',
                  'optional': true
                },
                {
                  'name': 'header',
                  'description': '<p>"header" to indicate table has header row</p>\n',
                  'type': 'String',
                  'optional': true
                },
                {
                  'name': 'callback',
                  'description': '<p>function to be executed after\n                                     <a href="#/p5/loadTable">loadTable()</a> completes. On success, the\n                                     <a href="#/p5.Table">Table</a> object is passed in as the\n                                     first argument.</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function to be executed if\n                                     there is an error, response is passed\n                                     in as first argument</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'loadXML': {
              'name': 'loadXML',
              'params': [
                {
                  'name': 'filename',
                  'description': '<p>name of the file or URL to load</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function to be executed after <a href="#/p5/loadXML">loadXML()</a>\n                              completes, XML object is passed in as\n                              first argument</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function to be executed if\n                              there is an error, response is passed\n                              in as first argument</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'loadBytes': {
              'name': 'loadBytes',
              'params': [
                {
                  'name': 'file',
                  'description': '<p>name of the file or URL to load</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function to be executed after <a href="#/p5/loadBytes">loadBytes()</a>\n                                   completes</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function to be executed if there\n                                   is an error</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'httpGet': {
              'name': 'httpGet',
              'class': 'p5',
              'module': 'IO',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '<p>name of the file or url to load</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'datatype',
                      'description': '<p>"json", "jsonp", "binary", "arrayBuffer",\n                                   "xml", or "text"</p>\n',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'data',
                      'description': '<p>param data passed sent with request</p>\n',
                      'type': 'Object|Boolean',
                      'optional': true
                    },
                    {
                      'name': 'callback',
                      'description': '<p>function to be executed after\n                                   <a href="#/p5/httpGet">httpGet()</a> completes, data is passed in\n                                   as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '<p>function to be executed if\n                                   there is an error, response is passed\n                                   in as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'data',
                      'description': '',
                      'type': 'Object|Boolean'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function'
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'httpPost': {
              'name': 'httpPost',
              'class': 'p5',
              'module': 'IO',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '<p>name of the file or url to load</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'datatype',
                      'description': '<p>"json", "jsonp", "xml", or "text".\n                                   If omitted, <a href="#/p5/httpPost">httpPost()</a> will guess.</p>\n',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'data',
                      'description': '<p>param data passed sent with request</p>\n',
                      'type': 'Object|Boolean',
                      'optional': true
                    },
                    {
                      'name': 'callback',
                      'description': '<p>function to be executed after\n                                   <a href="#/p5/httpPost">httpPost()</a> completes, data is passed in\n                                   as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '<p>function to be executed if\n                                   there is an error, response is passed\n                                   in as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'data',
                      'description': '',
                      'type': 'Object|Boolean'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function'
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'httpDo': {
              'name': 'httpDo',
              'class': 'p5',
              'module': 'IO',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '<p>name of the file or url to load</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'method',
                      'description': '<p>either "GET", "POST", or "PUT",\n                                   defaults to "GET"</p>\n',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'datatype',
                      'description': '<p>"json", "jsonp", "xml", or "text"</p>\n',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'data',
                      'description': '<p>param data passed sent with request</p>\n',
                      'type': 'Object',
                      'optional': true
                    },
                    {
                      'name': 'callback',
                      'description': '<p>function to be executed after\n                                   <a href="#/p5/httpGet">httpGet()</a> completes, data is passed in\n                                   as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '<p>function to be executed if\n                                   there is an error, response is passed\n                                   in as first argument</p>\n',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'options',
                      'description': '<p>Request object options as documented in the\n                                   "fetch" API\n<a href="https://developer.mozilla.org/en/docs/Web/API/Fetch_API">reference</a></p>\n',
                      'type': 'Object'
                    },
                    {
                      'name': 'callback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    },
                    {
                      'name': 'errorCallback',
                      'description': '',
                      'type': 'Function',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'createWriter': {
              'name': 'createWriter',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>name of the file to be created</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'extension',
                  'description': '',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'save': {
              'name': 'save',
              'params': [
                {
                  'name': 'objectOrFilename',
                  'description': '<p>If filename is provided, will\n                                           save canvas as an image with\n                                           either png or jpg extension\n                                           depending on the filename.\n                                           If object is provided, will\n                                           save depending on the object\n                                           and filename (see examples\n                                           above).</p>\n',
                  'type': 'Object|String',
                  'optional': true
                },
                {
                  'name': 'filename',
                  'description': '<p>If an object is provided as the first\n                             parameter, then the second parameter\n                             indicates the filename,\n                             and should include an appropriate\n                             file extension (see examples above).</p>\n',
                  'type': 'String',
                  'optional': true
                },
                {
                  'name': 'options',
                  'description': '<p>Additional options depend on\n                          filetype. For example, when saving JSON,\n                          <code>true</code> indicates that the\n                          output will be optimized for filesize,\n                          rather than readability.</p>\n',
                  'type': 'Boolean|String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'saveJSON': {
              'name': 'saveJSON',
              'params': [
                {
                  'name': 'json',
                  'description': '',
                  'type': 'Array|Object'
                },
                {
                  'name': 'filename',
                  'description': '',
                  'type': 'String'
                },
                {
                  'name': 'optimize',
                  'description': '<p>If true, removes line breaks\n                               and spaces from the output\n                               file to optimize filesize\n                               (but not readability).</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'saveStrings': {
              'name': 'saveStrings',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>string array to be written</p>\n',
                  'type': 'String[]'
                },
                {
                  'name': 'filename',
                  'description': '<p>filename for output</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'extension',
                  'description': '<p>the filename\'s extension</p>\n',
                  'type': 'String',
                  'optional': true
                },
                {
                  'name': 'isCRLF',
                  'description': '<p>if true, change line-break to CRLF</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'saveTable': {
              'name': 'saveTable',
              'params': [
                {
                  'name': 'Table',
                  'description': '<p>the <a href="#/p5.Table">Table</a> object to save to a file</p>\n',
                  'type': 'p5.Table'
                },
                {
                  'name': 'filename',
                  'description': '<p>the filename to which the Table should be saved</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'options',
                  'description': '<p>can be one of "tsv", "csv", or "html"</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'IO'
            },
            'abs': {
              'name': 'abs',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number to compute</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'ceil': {
              'name': 'ceil',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number to round up</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'constrain': {
              'name': 'constrain',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number to constrain</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'low',
                  'description': '<p>minimum limit</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'high',
                  'description': '<p>maximum limit</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'dist': {
              'name': 'dist',
              'class': 'p5',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '<p>x-coordinate of the first point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '<p>y-coordinate of the first point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '<p>x-coordinate of the second point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '<p>y-coordinate of the second point</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'x1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z1',
                      'description': '<p>z-coordinate of the first point</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z2',
                      'description': '<p>z-coordinate of the second point</p>\n',
                      'type': 'Number'
                    }
                  ]
                }
              ]
            },
            'exp': {
              'name': 'exp',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>exponent to raise</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'floor': {
              'name': 'floor',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number to round down</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'lerp': {
              'name': 'lerp',
              'params': [
                {
                  'name': 'start',
                  'description': '<p>first value</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'stop',
                  'description': '<p>second value</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'amt',
                  'description': '<p>number</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'log': {
              'name': 'log',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number greater than 0</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'mag': {
              'name': 'mag',
              'params': [
                {
                  'name': 'a',
                  'description': '<p>first value</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'b',
                  'description': '<p>second value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'map': {
              'name': 'map',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>the incoming value to be converted</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'start1',
                  'description': '<p>lower bound of the value\'s current range</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'stop1',
                  'description': '<p>upper bound of the value\'s current range</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'start2',
                  'description': '<p>lower bound of the value\'s target range</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'stop2',
                  'description': '<p>upper bound of the value\'s target range</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'withinBounds',
                  'description': '<p>constrain the value to the newly mapped range</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'max': {
              'name': 'max',
              'class': 'p5',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n0',
                      'description': '<p>Number to compare</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'n1',
                      'description': '<p>Number to compare</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'nums',
                      'description': '<p>Numbers to compare</p>\n',
                      'type': 'Number[]'
                    }
                  ]
                }
              ]
            },
            'min': {
              'name': 'min',
              'class': 'p5',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n0',
                      'description': '<p>Number to compare</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'n1',
                      'description': '<p>Number to compare</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'nums',
                      'description': '<p>Numbers to compare</p>\n',
                      'type': 'Number[]'
                    }
                  ]
                }
              ]
            },
            'norm': {
              'name': 'norm',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>incoming value to be normalized</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'start',
                  'description': '<p>lower bound of the value\'s current range</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'stop',
                  'description': '<p>upper bound of the value\'s current range</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'pow': {
              'name': 'pow',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>base of the exponential expression</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'e',
                  'description': '<p>power by which to raise the base</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'round': {
              'name': 'round',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number to round</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'decimals',
                  'description': '<p>number of decimal places to round to, default is 0</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'sq': {
              'name': 'sq',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>number to square</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'sqrt': {
              'name': 'sqrt',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>non-negative number to square root</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'fract': {
              'name': 'fract',
              'params': [
                {
                  'name': 'num',
                  'description': '<p>Number whose fractional part needs to be found out</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'createVector': {
              'name': 'createVector',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x component of the vector</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'y',
                  'description': '<p>y component of the vector</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'z',
                  'description': '<p>z component of the vector</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'noise': {
              'name': 'noise',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate in noise space</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate in noise space</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'z',
                  'description': '<p>z-coordinate in noise space</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'noiseDetail': {
              'name': 'noiseDetail',
              'params': [
                {
                  'name': 'lod',
                  'description': '<p>number of octaves to be used by the noise</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'falloff',
                  'description': '<p>falloff factor for each octave</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'noiseSeed': {
              'name': 'noiseSeed',
              'params': [
                {
                  'name': 'seed',
                  'description': '<p>the seed value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'randomSeed': {
              'name': 'randomSeed',
              'params': [
                {
                  'name': 'seed',
                  'description': '<p>the seed value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'random': {
              'name': 'random',
              'class': 'p5',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'min',
                      'description': '<p>the lower bound (inclusive)</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'max',
                      'description': '<p>the upper bound (exclusive)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'choices',
                      'description': '<p>the array to choose from</p>\n',
                      'type': 'Array'
                    }
                  ]
                }
              ]
            },
            'randomGaussian': {
              'name': 'randomGaussian',
              'params': [
                {
                  'name': 'mean',
                  'description': '<p>the mean</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'sd',
                  'description': '<p>the standard deviation</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'acos': {
              'name': 'acos',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>the value whose arc cosine is to be returned</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'asin': {
              'name': 'asin',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>the value whose arc sine is to be returned</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'atan': {
              'name': 'atan',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>the value whose arc tangent is to be returned</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'atan2': {
              'name': 'atan2',
              'params': [
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the point</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the point</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'cos': {
              'name': 'cos',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'sin': {
              'name': 'sin',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'tan': {
              'name': 'tan',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>the angle</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'degrees': {
              'name': 'degrees',
              'params': [
                {
                  'name': 'radians',
                  'description': '<p>the radians value to convert to degrees</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'radians': {
              'name': 'radians',
              'params': [
                {
                  'name': 'degrees',
                  'description': '<p>the degree value to convert to radians</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'Math'
            },
            'angleMode': {
              'name': 'angleMode',
              'class': 'p5',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'mode',
                      'description': '<p>either RADIANS or DEGREES</p>\n',
                      'type': 'Constant'
                    }
                  ]
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'textAlign': {
              'name': 'textAlign',
              'class': 'p5',
              'module': 'Typography',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'horizAlign',
                      'description': '<p>horizontal alignment, either LEFT,\n                           CENTER, or RIGHT</p>\n',
                      'type': 'Constant'
                    },
                    {
                      'name': 'vertAlign',
                      'description': '<p>vertical alignment, either TOP,\n                           BOTTOM, CENTER, or BASELINE</p>\n',
                      'type': 'Constant',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'textLeading': {
              'name': 'textLeading',
              'class': 'p5',
              'module': 'Typography',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'leading',
                      'description': '<p>the size in pixels for spacing between lines</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'textSize': {
              'name': 'textSize',
              'class': 'p5',
              'module': 'Typography',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'theSize',
                      'description': '<p>the size of the letters in units of pixels</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'textStyle': {
              'name': 'textStyle',
              'class': 'p5',
              'module': 'Typography',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'theStyle',
                      'description': '<p>styling for text, either NORMAL,\n                           ITALIC, BOLD or BOLDITALIC</p>\n',
                      'type': 'Constant'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'textWidth': {
              'name': 'textWidth',
              'params': [
                {
                  'name': 'theText',
                  'description': '<p>the String of characters to measure</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Typography'
            },
            'textAscent': {
              'name': 'textAscent',
              'class': 'p5',
              'module': 'Typography'
            },
            'textDescent': {
              'name': 'textDescent',
              'class': 'p5',
              'module': 'Typography'
            },
            'textWrap': {
              'name': 'textWrap',
              'params': [
                {
                  'name': 'wrapStyle',
                  'description': '<p>text wrapping style, either WORD or CHAR</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': 'Typography'
            },
            'loadFont': {
              'name': 'loadFont',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>name of the file or url to load</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function to be executed after\n                                   <a href="#/p5/loadFont">loadFont()</a> completes</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'onError',
                  'description': '<p>function to be executed if\n                                   an error occurs</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Typography'
            },
            'text': {
              'name': 'text',
              'params': [
                {
                  'name': 'str',
                  'description': '<p>the alphanumeric\n                                            symbols to be displayed</p>\n',
                  'type': 'String|Object|Array|Number|Boolean'
                },
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of text</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of text</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'x2',
                  'description': '<p>by default, the width of the text box,\n                    see <a href="#/p5/rectMode">rectMode()</a> for more info</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'y2',
                  'description': '<p>by default, the height of the text box,\n                    see <a href="#/p5/rectMode">rectMode()</a> for more info</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Typography'
            },
            'textFont': {
              'name': 'textFont',
              'class': 'p5',
              'module': 'Typography',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'font',
                      'description': '<p>a font loaded via <a href="#/p5/loadFont">loadFont()</a>,\nor a String representing a <a href="https://mzl.la/2dOw8WD">web safe font</a>\n(a font that is generally available across all systems)</p>\n',
                      'type': 'Object|String'
                    },
                    {
                      'name': 'size',
                      'description': '<p>the font size to use</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'append': {
              'name': 'append',
              'params': [
                {
                  'name': 'array',
                  'description': '<p>Array to append</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'value',
                  'description': '<p>to be added to the Array</p>\n',
                  'type': 'Any'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'arrayCopy': {
              'name': 'arrayCopy',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'src',
                      'description': '<p>the source Array</p>\n',
                      'type': 'Array'
                    },
                    {
                      'name': 'srcPosition',
                      'description': '<p>starting position in the source Array</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dst',
                      'description': '<p>the destination Array</p>\n',
                      'type': 'Array'
                    },
                    {
                      'name': 'dstPosition',
                      'description': '<p>starting position in the destination Array</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'length',
                      'description': '<p>number of Array elements to be copied</p>\n',
                      'type': 'Integer'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'src',
                      'description': '',
                      'type': 'Array'
                    },
                    {
                      'name': 'dst',
                      'description': '',
                      'type': 'Array'
                    },
                    {
                      'name': 'length',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'concat': {
              'name': 'concat',
              'params': [
                {
                  'name': 'a',
                  'description': '<p>first Array to concatenate</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'b',
                  'description': '<p>second Array to concatenate</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'reverse': {
              'name': 'reverse',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>Array to reverse</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'shorten': {
              'name': 'shorten',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>Array to shorten</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'shuffle': {
              'name': 'shuffle',
              'params': [
                {
                  'name': 'array',
                  'description': '<p>Array to shuffle</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'bool',
                  'description': '<p>modify passed array</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'sort': {
              'name': 'sort',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>Array to sort</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'count',
                  'description': '<p>number of elements to sort, starting from 0</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'splice': {
              'name': 'splice',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>Array to splice into</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'value',
                  'description': '<p>value to be spliced in</p>\n',
                  'type': 'Any'
                },
                {
                  'name': 'position',
                  'description': '<p>in the array from which to insert data</p>\n',
                  'type': 'Integer'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'subset': {
              'name': 'subset',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>Array to extract from</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'start',
                  'description': '<p>position to begin</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'count',
                  'description': '<p>number of values to extract</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'float': {
              'name': 'float',
              'params': [
                {
                  'name': 'str',
                  'description': '<p>float string to parse</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'int': {
              'name': 'int',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>value to parse</p>\n',
                      'type': 'String|Boolean|Number'
                    },
                    {
                      'name': 'radix',
                      'description': '<p>the radix to convert to (default: 10)</p>\n',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'ns',
                      'description': '<p>values to parse</p>\n',
                      'type': 'Array'
                    },
                    {
                      'name': 'radix',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'str': {
              'name': 'str',
              'params': [
                {
                  'name': 'n',
                  'description': '<p>value to parse</p>\n',
                  'type': 'String|Boolean|Number|Array'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'byte': {
              'name': 'byte',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>value to parse</p>\n',
                      'type': 'String|Boolean|Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'ns',
                      'description': '<p>values to parse</p>\n',
                      'type': 'Array'
                    }
                  ]
                }
              ]
            },
            'char': {
              'name': 'char',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>value to parse</p>\n',
                      'type': 'String|Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'ns',
                      'description': '<p>values to parse</p>\n',
                      'type': 'Array'
                    }
                  ]
                }
              ]
            },
            'unchar': {
              'name': 'unchar',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>value to parse</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'ns',
                      'description': '<p>values to parse</p>\n',
                      'type': 'Array'
                    }
                  ]
                }
              ]
            },
            'hex': {
              'name': 'hex',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>value to parse</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'digits',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'ns',
                      'description': '<p>array of values to parse</p>\n',
                      'type': 'Number[]'
                    },
                    {
                      'name': 'digits',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'unhex': {
              'name': 'unhex',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>value to parse</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'ns',
                      'description': '<p>values to parse</p>\n',
                      'type': 'Array'
                    }
                  ]
                }
              ]
            },
            'join': {
              'name': 'join',
              'params': [
                {
                  'name': 'list',
                  'description': '<p>array of Strings to be joined</p>\n',
                  'type': 'Array'
                },
                {
                  'name': 'separator',
                  'description': '<p>String to be placed between each item</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'match': {
              'name': 'match',
              'params': [
                {
                  'name': 'str',
                  'description': '<p>the String to be searched</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'regexp',
                  'description': '<p>the regexp to be used for matching</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'matchAll': {
              'name': 'matchAll',
              'params': [
                {
                  'name': 'str',
                  'description': '<p>the String to be searched</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'regexp',
                  'description': '<p>the regexp to be used for matching</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'nf': {
              'name': 'nf',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'num',
                      'description': '<p>the Number to format</p>\n',
                      'type': 'Number|String'
                    },
                    {
                      'name': 'left',
                      'description': '<p>number of digits to the left of the\n                               decimal point</p>\n',
                      'type': 'Integer|String',
                      'optional': true
                    },
                    {
                      'name': 'right',
                      'description': '<p>number of digits to the right of the\n                               decimal point</p>\n',
                      'type': 'Integer|String',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'nums',
                      'description': '<p>the Numbers to format</p>\n',
                      'type': 'Array'
                    },
                    {
                      'name': 'left',
                      'description': '',
                      'type': 'Integer|String',
                      'optional': true
                    },
                    {
                      'name': 'right',
                      'description': '',
                      'type': 'Integer|String',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'nfc': {
              'name': 'nfc',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'num',
                      'description': '<p>the Number to format</p>\n',
                      'type': 'Number|String'
                    },
                    {
                      'name': 'right',
                      'description': '<p>number of digits to the right of the\n                                 decimal point</p>\n',
                      'type': 'Integer|String',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'nums',
                      'description': '<p>the Numbers to format</p>\n',
                      'type': 'Array'
                    },
                    {
                      'name': 'right',
                      'description': '',
                      'type': 'Integer|String',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'nfp': {
              'name': 'nfp',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'num',
                      'description': '<p>the Number to format</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'left',
                      'description': '<p>number of digits to the left of the decimal\n                               point</p>\n',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'right',
                      'description': '<p>number of digits to the right of the\n                               decimal point</p>\n',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'nums',
                      'description': '<p>the Numbers to format</p>\n',
                      'type': 'Number[]'
                    },
                    {
                      'name': 'left',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'right',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'nfs': {
              'name': 'nfs',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'num',
                      'description': '<p>the Number to format</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'left',
                      'description': '<p>number of digits to the left of the decimal\n                               point</p>\n',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'right',
                      'description': '<p>number of digits to the right of the\n                               decimal point</p>\n',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'nums',
                      'description': '<p>the Numbers to format</p>\n',
                      'type': 'Array'
                    },
                    {
                      'name': 'left',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    },
                    {
                      'name': 'right',
                      'description': '',
                      'type': 'Integer',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'split': {
              'name': 'split',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>the String to be split</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'delim',
                  'description': '<p>the String used to separate the data</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'splitTokens': {
              'name': 'splitTokens',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>the String to be split</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'delim',
                  'description': '<p>list of individual Strings that will be used as\n                         separators</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Data'
            },
            'trim': {
              'name': 'trim',
              'class': 'p5',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'str',
                      'description': '<p>a String to be trimmed</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'strs',
                      'description': '<p>an Array of Strings to be trimmed</p>\n',
                      'type': 'Array'
                    }
                  ]
                }
              ]
            },
            'day': {
              'name': 'day',
              'class': 'p5',
              'module': 'IO'
            },
            'hour': {
              'name': 'hour',
              'class': 'p5',
              'module': 'IO'
            },
            'minute': {
              'name': 'minute',
              'class': 'p5',
              'module': 'IO'
            },
            'millis': {
              'name': 'millis',
              'class': 'p5',
              'module': 'IO'
            },
            'month': {
              'name': 'month',
              'class': 'p5',
              'module': 'IO'
            },
            'second': {
              'name': 'second',
              'class': 'p5',
              'module': 'IO'
            },
            'year': {
              'name': 'year',
              'class': 'p5',
              'module': 'IO'
            },
            'plane': {
              'name': 'plane',
              'params': [
                {
                  'name': 'width',
                  'description': '<p>width of the plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'height',
                  'description': '<p>height of the plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>Optional number of triangle\n                            subdivisions in x-dimension</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>Optional number of triangle\n                            subdivisions in y-dimension</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'box': {
              'name': 'box',
              'params': [
                {
                  'name': 'width',
                  'description': '<p>width of the box</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'height',
                  'description': '<p>height of the box</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'depth',
                  'description': '<p>depth of the box</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>Optional number of triangle\n                           subdivisions in x-dimension</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>Optional number of triangle\n                           subdivisions in y-dimension</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'sphere': {
              'name': 'sphere',
              'params': [
                {
                  'name': 'radius',
                  'description': '<p>radius of circle</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>optional number of subdivisions in x-dimension</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>optional number of subdivisions in y-dimension</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'cylinder': {
              'name': 'cylinder',
              'params': [
                {
                  'name': 'radius',
                  'description': '<p>radius of the surface</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'height',
                  'description': '<p>height of the cylinder</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>number of subdivisions in x-dimension;\n                              default is 24</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>number of subdivisions in y-dimension;\n                              default is 1</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'bottomCap',
                  'description': '<p>whether to draw the bottom of the cylinder</p>\n',
                  'type': 'Boolean',
                  'optional': true
                },
                {
                  'name': 'topCap',
                  'description': '<p>whether to draw the top of the cylinder</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'cone': {
              'name': 'cone',
              'params': [
                {
                  'name': 'radius',
                  'description': '<p>radius of the bottom surface</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'height',
                  'description': '<p>height of the cone</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>number of segments,\n                            the more segments the smoother geometry\n                            default is 24</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>number of segments,\n                            the more segments the smoother geometry\n                            default is 1</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'cap',
                  'description': '<p>whether to draw the base of the cone</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'ellipsoid': {
              'name': 'ellipsoid',
              'params': [
                {
                  'name': 'radiusx',
                  'description': '<p>x-radius of ellipsoid</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'radiusy',
                  'description': '<p>y-radius of ellipsoid</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'radiusz',
                  'description': '<p>z-radius of ellipsoid</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>number of segments,\n                                   the more segments the smoother geometry\n                                   default is 24. Avoid detail number above\n                                   150, it may crash the browser.</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>number of segments,\n                                   the more segments the smoother geometry\n                                   default is 16. Avoid detail number above\n                                   150, it may crash the browser.</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'torus': {
              'name': 'torus',
              'params': [
                {
                  'name': 'radius',
                  'description': '<p>radius of the whole ring</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'tubeRadius',
                  'description': '<p>radius of the tube</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'detailX',
                  'description': '<p>number of segments in x-dimension,\n                               the more segments the smoother geometry\n                               default is 24</p>\n',
                  'type': 'Integer',
                  'optional': true
                },
                {
                  'name': 'detailY',
                  'description': '<p>number of segments in y-dimension,\n                               the more segments the smoother geometry\n                               default is 16</p>\n',
                  'type': 'Integer',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'orbitControl': {
              'name': 'orbitControl',
              'params': [
                {
                  'name': 'sensitivityX',
                  'description': '<p>sensitivity to mouse movement along X axis</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'sensitivityY',
                  'description': '<p>sensitivity to mouse movement along Y axis</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'sensitivityZ',
                  'description': '<p>sensitivity to scroll movement along Z axis</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'options',
                  'description': '<p>An optional object that can contain additional settings,\ndisableTouchActions - Boolean, default value is true.\nSetting this to true makes mobile interactions smoother by preventing\naccidental interactions with the page while orbiting. But if you\'re already\ndoing it via css or want the default touch actions, consider setting it to false.\nfreeRotation - Boolean, default value is false.\nBy default, horizontal movement of the mouse or touch pointer rotates the camera\naround the y-axis, and vertical movement rotates the camera around the x-axis.\nBut if setting this option to true, the camera always rotates in the direction\nthe pointer is moving. For zoom and move, the behavior is the same regardless of\ntrue/false.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'debugMode': {
              'name': 'debugMode',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'mode',
                      'description': '<p>either GRID or AXES</p>\n',
                      'type': 'Constant'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'mode',
                      'description': '',
                      'type': 'Constant'
                    },
                    {
                      'name': 'gridSize',
                      'description': '<p>size of one side of the grid</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'gridDivisions',
                      'description': '<p>number of divisions in the grid</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'xOff',
                      'description': '<p>X axis offset from origin (0,0,0)</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'yOff',
                      'description': '<p>Y axis offset from origin (0,0,0)</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'zOff',
                      'description': '<p>Z axis offset from origin (0,0,0)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'mode',
                      'description': '',
                      'type': 'Constant'
                    },
                    {
                      'name': 'axesSize',
                      'description': '<p>size of axes icon</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'xOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'yOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'zOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'gridSize',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'gridDivisions',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'gridXOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'gridYOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'gridZOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'axesSize',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'axesXOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'axesYOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'axesZOff',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'noDebugMode': {
              'name': 'noDebugMode',
              'class': 'p5',
              'module': '3D'
            },
            'ambientLight': {
              'name': 'ambientLight',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to\n                                  the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value\n                                  relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value\n                                  relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '<p>alpha value relative to current\n                                  color range (default is 0-255)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>number specifying value between\n                                 white and black</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>a color string</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>an array containing the red,green,blue &\n                                 and alpha components of the color</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a></p>\n',
                      'type': 'p5.Color'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'specularColor': {
              'name': 'specularColor',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to\n                                 the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value\n                                 relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value\n                                 relative to the current color range</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>number specifying value between\n                                 white and black</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>color as a CSS string</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'values',
                      'description': '<p>color as an array containing the\n                                 red, green, and blue components</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a></p>\n',
                      'type': 'p5.Color'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'directionalLight': {
              'name': 'directionalLight',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to the current\n                                color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value relative to the\n                                current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value relative to the\n                                current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x',
                      'description': '<p>x component of direction (inclusive range of -1 to 1)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y component of direction (inclusive range of -1 to 1)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>z component of direction (inclusive range of -1 to 1)</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'direction',
                      'description': '<p>direction of light as a\n                                <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a>,\n                                           as an array, or as a CSS string</p>\n',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'direction',
                      'description': '',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'pointLight': {
              'name': 'pointLight',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to the current\n                         color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value relative to the\n                         current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value relative to the\n                         current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x',
                      'description': '<p>x component of position</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y component of position</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>z component of position</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'position',
                      'description': '<p>of light as a <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a>,\n                                           as an array, or as a CSS string</p>\n',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'position',
                      'description': '',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'lights': {
              'name': 'lights',
              'class': 'p5',
              'module': '3D'
            },
            'lightFalloff': {
              'name': 'lightFalloff',
              'params': [
                {
                  'name': 'constant',
                  'description': '<p>CONSTANT value for determining falloff</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'linear',
                  'description': '<p>LINEAR value for determining falloff</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'quadratic',
                  'description': '<p>QUADRATIC value for determining falloff</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'spotLight': {
              'name': 'spotLight',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'x',
                      'description': '<p>x component of position</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y component of position</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>z component of position</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'rx',
                      'description': '<p>x component of light direction (inclusive range of -1 to 1)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'ry',
                      'description': '<p>y component of light direction (inclusive range of -1 to 1)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'rz',
                      'description': '<p>z component of light direction (inclusive range of -1 to 1)</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'angle',
                      'description': '<p>angle of cone. Defaults to PI/3</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '<p>concentration of cone. Defaults to 100</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a>,\n                                                    as an array, or as a CSS string</p>\n',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'position',
                      'description': '<p>position of light as a <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'direction',
                      'description': '<p>direction of light as a <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'position',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'direction',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'direction',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'position',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'rx',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'ry',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'rz',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'direction',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'position',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'rx',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'ry',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'rz',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '',
                      'type': 'p5.Color|Number[]|String'
                    },
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'rx',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'ry',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'rz',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'concentration',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'noLights': {
              'name': 'noLights',
              'class': 'p5',
              'module': '3D'
            },
            'loadModel': {
              'name': 'loadModel',
              'class': 'p5',
              'module': 'Shape',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '<p>Path of the model to be loaded</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'normalize',
                      'description': '<p>If true, scale the model to a\n                                     standardized size when loading</p>\n',
                      'type': 'Boolean'
                    },
                    {
                      'name': 'successCallback',
                      'description': '<p>Function to be called\n                                    once the model is loaded. Will be passed\n                                    the 3D model object.</p>\n',
                      'type': 'function(p5.Geometry)',
                      'optional': true
                    },
                    {
                      'name': 'failureCallback',
                      'description': '<p>called with event error if\n                                        the model fails to load.</p>\n',
                      'type': 'Function(Event)',
                      'optional': true
                    },
                    {
                      'name': 'fileType',
                      'description': '<p>The file extension of the model\n                                     (<code>.stl</code>, <code>.obj</code>).</p>\n',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'path',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'successCallback',
                      'description': '',
                      'type': 'function(p5.Geometry)',
                      'optional': true
                    },
                    {
                      'name': 'failureCallback',
                      'description': '',
                      'type': 'Function(Event)',
                      'optional': true
                    },
                    {
                      'name': 'fileType',
                      'description': '',
                      'type': 'String',
                      'optional': true
                    }
                  ]
                }
              ]
            },
            'model': {
              'name': 'model',
              'params': [
                {
                  'name': 'model',
                  'description': '<p>Loaded 3d model to be rendered</p>\n',
                  'type': 'p5.Geometry'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'loadShader': {
              'name': 'loadShader',
              'params': [
                {
                  'name': 'vertFilename',
                  'description': '<p>path to file containing vertex shader\nsource code</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'fragFilename',
                  'description': '<p>path to file containing fragment shader\nsource code</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>callback to be executed after loadShader\ncompletes. On success, the p5.Shader object is passed as the first argument.</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>callback to be executed when an error\noccurs inside loadShader. On error, the error is passed as the first\nargument.</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'createShader': {
              'name': 'createShader',
              'params': [
                {
                  'name': 'vertSrc',
                  'description': '<p>source code for the vertex shader</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'fragSrc',
                  'description': '<p>source code for the fragment shader</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'shader': {
              'name': 'shader',
              'params': [
                {
                  'name': 's',
                  'description': '<p>the <a href="#/p5.Shader">p5.Shader</a> object\nto use for rendering shapes.</p>\n',
                  'type': 'p5.Shader'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'resetShader': {
              'name': 'resetShader',
              'class': 'p5',
              'module': '3D'
            },
            'texture': {
              'name': 'texture',
              'params': [
                {
                  'name': 'tex',
                  'description': '<p>image to use as texture</p>\n',
                  'type': 'p5.Image|p5.MediaElement|p5.Graphics|p5.Texture|p5.Framebuffer|p5.FramebufferTexture'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'textureMode': {
              'name': 'textureMode',
              'params': [
                {
                  'name': 'mode',
                  'description': '<p>either IMAGE or NORMAL</p>\n',
                  'type': 'Constant'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'textureWrap': {
              'name': 'textureWrap',
              'params': [
                {
                  'name': 'wrapX',
                  'description': '<p>either CLAMP, REPEAT, or MIRROR</p>\n',
                  'type': 'Constant'
                },
                {
                  'name': 'wrapY',
                  'description': '<p>either CLAMP, REPEAT, or MIRROR</p>\n',
                  'type': 'Constant',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'normalMaterial': {
              'name': 'normalMaterial',
              'class': 'p5',
              'module': '3D'
            },
            'ambientMaterial': {
              'name': 'ambientMaterial',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to the current\n                      color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value relative to the\n                      current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value relative to the\n                      current color range</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>number specifying value between\n                        white and black</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a>,\n           as an array, or as a CSS string</p>\n',
                      'type': 'p5.Color|Number[]|String'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'emissiveMaterial': {
              'name': 'emissiveMaterial',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to the current\n                           color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value relative to the\n                           current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value relative to the\n                           current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '<p>alpha value relative to current color\n                           range (default is 0-255)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>number specifying value between\n                        white and black</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a>,\n           as an array, or as a CSS string</p>\n',
                      'type': 'p5.Color|Number[]|String'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'specularMaterial': {
              'name': 'specularMaterial',
              'class': 'p5',
              'module': '3D',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'gray',
                      'description': '<p>number specifying value between white and black.</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '<p>alpha value relative to current color range\n                                (default is 0-255)</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>red or hue value relative to\n                                the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>green or saturation value\n                                relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'v3',
                      'description': '<p>blue or brightness value\n                                relative to the current color range</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'alpha',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'color',
                      'description': '<p>color as a <a href="#/p5.Color">p5.Color</a>,\n           as an array, or as a CSS string</p>\n',
                      'type': 'p5.Color|Number[]|String'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'shininess': {
              'name': 'shininess',
              'params': [
                {
                  'name': 'shine',
                  'description': '<p>degree of shininess</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'camera': {
              'name': 'camera',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>camera position value on x axis</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'y',
                  'description': '<p>camera position value on y axis</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'z',
                  'description': '<p>camera position value on z axis</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'centerX',
                  'description': '<p>x coordinate representing center of the sketch</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'centerY',
                  'description': '<p>y coordinate representing center of the sketch</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'centerZ',
                  'description': '<p>z coordinate representing center of the sketch</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'upX',
                  'description': '<p>x component of direction \'up\' from camera</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'upY',
                  'description': '<p>y component of direction \'up\' from camera</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'upZ',
                  'description': '<p>z component of direction \'up\' from camera</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'perspective': {
              'name': 'perspective',
              'params': [
                {
                  'name': 'fovy',
                  'description': '<p>camera frustum vertical field of view,\n                          from bottom to top of view, in <a href="#/p5/angleMode">angleMode</a> units</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'aspect',
                  'description': '<p>camera frustum aspect ratio</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'near',
                  'description': '<p>frustum near plane length</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'far',
                  'description': '<p>frustum far plane length</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'ortho': {
              'name': 'ortho',
              'params': [
                {
                  'name': 'left',
                  'description': '<p>camera frustum left plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'right',
                  'description': '<p>camera frustum right plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'bottom',
                  'description': '<p>camera frustum bottom plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'top',
                  'description': '<p>camera frustum top plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'near',
                  'description': '<p>camera frustum near plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'far',
                  'description': '<p>camera frustum far plane</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'frustum': {
              'name': 'frustum',
              'params': [
                {
                  'name': 'left',
                  'description': '<p>camera frustum left plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'right',
                  'description': '<p>camera frustum right plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'bottom',
                  'description': '<p>camera frustum bottom plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'top',
                  'description': '<p>camera frustum top plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'near',
                  'description': '<p>camera frustum near plane</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'far',
                  'description': '<p>camera frustum far plane</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'createCamera': {
              'name': 'createCamera',
              'class': 'p5',
              'module': '3D'
            },
            'setCamera': {
              'name': 'setCamera',
              'params': [
                {
                  'name': 'cam',
                  'description': '<p>p5.Camera object</p>\n',
                  'type': 'p5.Camera'
                }
              ],
              'class': 'p5',
              'module': '3D'
            },
            'vertexNormal': {
              'name': 'vertexNormal',
              'params': [
                {
                  'name': 'x',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'z',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'v',
                  'description': '',
                  'type': 'Vector'
                }
              ],
              'class': 'p5',
              'module': 'Shape'
            },
            'setAttributes': {
              'name': 'setAttributes',
              'class': 'p5',
              'module': 'Rendering',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'key',
                      'description': '<p>Name of attribute</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'value',
                      'description': '<p>New value of named attribute</p>\n',
                      'type': 'Boolean'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'obj',
                      'description': '<p>object with key-value pairs</p>\n',
                      'type': 'Object'
                    }
                  ]
                }
              ]
            },
            'getAudioContext': {
              'name': 'getAudioContext',
              'class': 'p5',
              'module': 'p5.sound'
            },
            'userStartAudio': {
              'params': [
                {
                  'name': 'elements',
                  'description': '<p>This argument can be an Element,\n                              Selector String, NodeList, p5.Element,\n                              jQuery Element, or an Array of any of those.</p>\n',
                  'type': 'Element|Array',
                  'optional': true
                },
                {
                  'name': 'callback',
                  'description': '<p>Callback to invoke when the AudioContext\n                              has started</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'name': 'userStartAudio',
              'class': 'p5',
              'module': 'p5.sound'
            },
            'getOutputVolume': {
              'name': 'getOutputVolume',
              'class': 'p5',
              'module': 'p5.sound'
            },
            'outputVolume': {
              'name': 'outputVolume',
              'params': [
                {
                  'name': 'volume',
                  'description': '<p>Volume (amplitude) between 0.0\n                                   and 1.0 or modulating signal/oscillator</p>\n',
                  'type': 'Number|Object'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Fade for t seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>Schedule this event to happen at\n                               t seconds in the future</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'soundOut': {
              'name': 'soundOut',
              'class': 'p5',
              'module': 'p5.sound'
            },
            'sampleRate': {
              'name': 'sampleRate',
              'class': 'p5',
              'module': 'p5.sound'
            },
            'freqToMidi': {
              'name': 'freqToMidi',
              'params': [
                {
                  'name': 'frequency',
                  'description': '<p>A freqeuncy, for example, the "A"\n                           above Middle C is 440Hz</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'midiToFreq': {
              'name': 'midiToFreq',
              'params': [
                {
                  'name': 'midiNote',
                  'description': '<p>The number of a MIDI note</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'soundFormats': {
              'name': 'soundFormats',
              'params': [
                {
                  'name': 'formats',
                  'description': '<p>i.e. \'mp3\', \'wav\', \'ogg\'</p>\n',
                  'type': 'String',
                  'optional': true,
                  'multiple': true
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'saveSound': {
              'name': 'saveSound',
              'params': [
                {
                  'name': 'soundFile',
                  'description': '<p>p5.SoundFile that you wish to save</p>\n',
                  'type': 'p5.SoundFile'
                },
                {
                  'name': 'fileName',
                  'description': '<p>name of the resulting .wav file.</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'loadSound': {
              'name': 'loadSound',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>Path to the sound file, or an array with\n                                  paths to soundfiles in multiple formats\n                                  i.e. [\'sound.ogg\', \'sound.mp3\'].\n                                  Alternately, accepts an object: either\n                                  from the HTML5 File API, or a p5.File.</p>\n',
                  'type': 'String|Array'
                },
                {
                  'name': 'successCallback',
                  'description': '<p>Name of a function to call once file loads</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>Name of a function to call if there is\n                                    an error loading the file.</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'whileLoading',
                  'description': '<p>Name of a function to call while file is loading.\n                               This function will receive the percentage loaded\n                               so far, from 0.0 to 1.0.</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'createConvolver': {
              'name': 'createConvolver',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>path to a sound file</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function to call if loading is successful.\n                              The object will be passed in as the argument\n                              to the callback function.</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function to call if loading is not successful.\n                              A custom error will be passed in as the argument\n                              to the callback function.</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            },
            'setBPM': {
              'name': 'setBPM',
              'params': [
                {
                  'name': 'BPM',
                  'description': '<p>Beats Per Minute</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Seconds from now</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5',
              'module': 'p5.sound'
            }
          },
          'p5.Color': {
            'toString': {
              'name': 'toString',
              'params': [
                {
                  'name': 'format',
                  'description': '<p>how the color string will be formatted.\nLeaving this empty formats the string as rgba(r, g, b, a).\n\'#rgb\' \'#rgba\' \'#rrggbb\' and \'#rrggbbaa\' format as hexadecimal color codes.\n\'rgb\' \'hsb\' and \'hsl\' return the color formatted in the specified color mode.\n\'rgba\' \'hsba\' and \'hsla\' are the same as above but with alpha channels.\n\'rgb%\' \'hsb%\' \'hsl%\' \'rgba%\' \'hsba%\' and \'hsla%\' format as percentages.</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.Color',
              'module': 'Color'
            },
            'setRed': {
              'name': 'setRed',
              'params': [
                {
                  'name': 'red',
                  'description': '<p>the new red value.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Color',
              'module': 'Color'
            },
            'setGreen': {
              'name': 'setGreen',
              'params': [
                {
                  'name': 'green',
                  'description': '<p>the new green value.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Color',
              'module': 'Color'
            },
            'setBlue': {
              'name': 'setBlue',
              'params': [
                {
                  'name': 'blue',
                  'description': '<p>the new blue value.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Color',
              'module': 'Color'
            },
            'setAlpha': {
              'name': 'setAlpha',
              'params': [
                {
                  'name': 'alpha',
                  'description': '<p>the new alpha value.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Color',
              'module': 'Color'
            }
          },
          'p5.Element': {
            'elt': {
              'name': 'elt',
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'width': {
              'name': 'width',
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'height': {
              'name': 'height',
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'parent': {
              'name': 'parent',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'parent',
                      'description': '<p>the ID, DOM node, or <a href="#/p5.Element">p5.Element</a>\n                         of desired parent element</p>\n',
                      'type': 'String|p5.Element|Object'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'id': {
              'name': 'id',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'id',
                      'description': '<p>ID of the element</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'class': {
              'name': 'class',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'class',
                      'description': '<p>class to add</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'mousePressed': {
              'name': 'mousePressed',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when mouse is\n                               pressed over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'doubleClicked': {
              'name': 'doubleClicked',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when mouse is\n                               double clicked over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'mouseWheel': {
              'name': 'mouseWheel',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when mouse is\n                               scrolled over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'mouseReleased': {
              'name': 'mouseReleased',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when mouse is\n                               released over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'mouseClicked': {
              'name': 'mouseClicked',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when mouse is\n                               clicked over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'mouseMoved': {
              'name': 'mouseMoved',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a mouse moves\n                               over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'mouseOver': {
              'name': 'mouseOver',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a mouse moves\n                               onto the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'mouseOut': {
              'name': 'mouseOut',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a mouse\n                               moves off of an element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'touchStarted': {
              'name': 'touchStarted',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a touch\n                               starts over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'touchMoved': {
              'name': 'touchMoved',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a touch moves over\n                               the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'touchEnded': {
              'name': 'touchEnded',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a touch ends\n                               over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'dragOver': {
              'name': 'dragOver',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a file is\n                               dragged over the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'dragLeave': {
              'name': 'dragLeave',
              'params': [
                {
                  'name': 'fxn',
                  'description': '<p>function to be fired when a file is\n                               dragged off the element.\n                               if <code>false</code> is passed instead, the previously\n                               firing function will no longer fire.</p>\n',
                  'type': 'Function|Boolean'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'addClass': {
              'name': 'addClass',
              'params': [
                {
                  'name': 'class',
                  'description': '<p>name of class to add</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'removeClass': {
              'name': 'removeClass',
              'params': [
                {
                  'name': 'class',
                  'description': '<p>name of class to remove</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'hasClass': {
              'name': 'hasClass',
              'params': [
                {
                  'name': 'c',
                  'description': '<p>class name of class to check</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'toggleClass': {
              'name': 'toggleClass',
              'params': [
                {
                  'name': 'c',
                  'description': '<p>class name to toggle</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'child': {
              'name': 'child',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'child',
                      'description': '<p>the ID, DOM node, or <a href="#/p5.Element">p5.Element</a>\n                        to add to the current element</p>\n',
                      'type': 'String|p5.Element',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'center': {
              'name': 'center',
              'params': [
                {
                  'name': 'align',
                  'description': '<p>passing \'vertical\', \'horizontal\' aligns element accordingly</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'html': {
              'name': 'html',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'html',
                      'description': '<p>the HTML to be placed inside the element</p>\n',
                      'type': 'String',
                      'optional': true
                    },
                    {
                      'name': 'append',
                      'description': '<p>whether to append HTML to existing</p>\n',
                      'type': 'Boolean',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'position': {
              'name': 'position',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-position relative to upper left of window (optional)</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-position relative to upper left of window (optional)</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'positionType',
                      'description': '<p>it can be static, fixed, relative, sticky, initial or inherit (optional)</p>\n',
                      'type': 'String',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'style': {
              'name': 'style',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'property',
                      'description': '<p>property to be set</p>\n',
                      'type': 'String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'property',
                      'description': '',
                      'type': 'String'
                    },
                    {
                      'name': 'value',
                      'description': '<p>value to assign to property</p>\n',
                      'type': 'String|p5.Color'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'attribute': {
              'name': 'attribute',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'attr',
                      'description': '<p>attribute to set</p>\n',
                      'type': 'String'
                    },
                    {
                      'name': 'value',
                      'description': '<p>value to assign to attribute</p>\n',
                      'type': 'String'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'removeAttribute': {
              'name': 'removeAttribute',
              'params': [
                {
                  'name': 'attr',
                  'description': '<p>attribute to remove</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'value': {
              'name': 'value',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '',
                      'type': 'String|Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'show': {
              'name': 'show',
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'hide': {
              'name': 'hide',
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'size': {
              'name': 'size',
              'class': 'p5.Element',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'w',
                      'description': '<p>width of the element, either AUTO, or a number</p>\n',
                      'type': 'Number|Constant'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the element, either AUTO, or a number</p>\n',
                      'type': 'Number|Constant',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'remove': {
              'name': 'remove',
              'class': 'p5.Element',
              'module': 'DOM'
            },
            'drop': {
              'name': 'drop',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>callback to receive loaded file, called for each file dropped.</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'fxn',
                  'description': '<p>callback triggered once when files are dropped with the drop event.</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5.Element',
              'module': 'DOM'
            }
          },
          'p5.Graphics': {
            'reset': {
              'name': 'reset',
              'class': 'p5.Graphics',
              'module': 'Rendering'
            },
            'remove': {
              'name': 'remove',
              'class': 'p5.Graphics',
              'module': 'Rendering'
            },
            'createFramebuffer': {
              'name': 'createFramebuffer',
              'class': 'p5.Graphics',
              'module': 'Rendering'
            }
          },
          'JSON': {
            'stringify': {
              'name': 'stringify',
              'params': [
                {
                  'name': 'object',
                  'description': '<p>:Javascript object that you would like to convert to JSON</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'JSON',
              'module': 'Foundation'
            }
          },
          'console': {
            'log': {
              'name': 'log',
              'params': [
                {
                  'name': 'message',
                  'description': '<p>:Message that you would like to print to the console</p>\n',
                  'type': 'String|Expression|Object'
                }
              ],
              'class': 'console',
              'module': 'Foundation'
            }
          },
          'p5.TypedDict': {
            'size': {
              'name': 'size',
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'hasKey': {
              'name': 'hasKey',
              'params': [
                {
                  'name': 'key',
                  'description': '<p>that you want to look up</p>\n',
                  'type': 'Number|String'
                }
              ],
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'get': {
              'name': 'get',
              'params': [
                {
                  'name': 'the',
                  'description': '<p>key you want to access</p>\n',
                  'type': 'Number|String'
                }
              ],
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'key',
                  'description': '',
                  'type': 'Number|String'
                },
                {
                  'name': 'value',
                  'description': '',
                  'type': 'Number|String'
                }
              ],
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'create': {
              'name': 'create',
              'class': 'p5.TypedDict',
              'module': 'Data',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'key',
                      'description': '',
                      'type': 'Number|String'
                    },
                    {
                      'name': 'value',
                      'description': '',
                      'type': 'Number|String'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'obj',
                      'description': '<p>key/value pair</p>\n',
                      'type': 'Object'
                    }
                  ]
                }
              ]
            },
            'clear': {
              'name': 'clear',
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'remove': {
              'name': 'remove',
              'params': [
                {
                  'name': 'key',
                  'description': '<p>for the pair to remove</p>\n',
                  'type': 'Number|String'
                }
              ],
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'print': {
              'name': 'print',
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'saveTable': {
              'name': 'saveTable',
              'class': 'p5.TypedDict',
              'module': 'Data'
            },
            'saveJSON': {
              'name': 'saveJSON',
              'class': 'p5.TypedDict',
              'module': 'Data'
            }
          },
          'p5.NumberDict': {
            'add': {
              'name': 'add',
              'params': [
                {
                  'name': 'Key',
                  'description': '<p>for the value you wish to add to</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'Number',
                  'description': '<p>to add to the value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'sub': {
              'name': 'sub',
              'params': [
                {
                  'name': 'Key',
                  'description': '<p>for the value you wish to subtract from</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'Number',
                  'description': '<p>to subtract from the value</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'mult': {
              'name': 'mult',
              'params': [
                {
                  'name': 'Key',
                  'description': '<p>for value you wish to multiply</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'Amount',
                  'description': '<p>to multiply the value by</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'div': {
              'name': 'div',
              'params': [
                {
                  'name': 'Key',
                  'description': '<p>for value you wish to divide</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'Amount',
                  'description': '<p>to divide the value by</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'minValue': {
              'name': 'minValue',
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'maxValue': {
              'name': 'maxValue',
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'minKey': {
              'name': 'minKey',
              'class': 'p5.NumberDict',
              'module': 'Data'
            },
            'maxKey': {
              'name': 'maxKey',
              'class': 'p5.NumberDict',
              'module': 'Data'
            }
          },
          'p5.MediaElement': {
            'src': {
              'name': 'src',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'play': {
              'name': 'play',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'stop': {
              'name': 'stop',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'pause': {
              'name': 'pause',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'loop': {
              'name': 'loop',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'noLoop': {
              'name': 'noLoop',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'autoplay': {
              'name': 'autoplay',
              'params': [
                {
                  'name': 'shouldAutoplay',
                  'description': '<p>whether the element should autoplay</p>\n',
                  'type': 'Boolean'
                }
              ],
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'volume': {
              'name': 'volume',
              'class': 'p5.MediaElement',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'val',
                      'description': '<p>volume between 0.0 and 1.0</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'speed': {
              'name': 'speed',
              'class': 'p5.MediaElement',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'speed',
                      'description': '<p>speed multiplier for element playback</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'time': {
              'name': 'time',
              'class': 'p5.MediaElement',
              'module': 'DOM',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'time',
                      'description': '<p>time to jump to (in seconds)</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'duration': {
              'name': 'duration',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'onended': {
              'name': 'onended',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>function to call when the\n                            soundfile has ended. The\n                            media element will be passed\n                            in as the argument to the\n                            callback.</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'audioNode',
                  'description': '<p>AudioNode from the Web Audio API,\nor an object from the p5.sound library</p>\n',
                  'type': 'AudioNode|Object'
                }
              ],
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'showControls': {
              'name': 'showControls',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'hideControls': {
              'name': 'hideControls',
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'addCue': {
              'name': 'addCue',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>Time in seconds, relative to this media\n                            element\'s playback. For example, to trigger\n                            an event every time playback reaches two\n                            seconds, pass in the number 2. This will be\n                            passed as the first parameter to\n                            the callback function.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'callback',
                  'description': '<p>Name of a function that will be\n                            called at the given time. The callback will\n                            receive time and (optionally) param as its\n                            two parameters.</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'value',
                  'description': '<p>An object to be passed as the\n                            second parameter to the\n                            callback function.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'removeCue': {
              'name': 'removeCue',
              'params': [
                {
                  'name': 'id',
                  'description': '<p>ID of the cue, as returned by addCue</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.MediaElement',
              'module': 'DOM'
            },
            'clearCues': {
              'name': 'clearCues',
              'params': [
                {
                  'name': 'id',
                  'description': '<p>ID of the cue, as returned by addCue</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.MediaElement',
              'module': 'DOM'
            }
          },
          'p5.File': {
            'file': {
              'name': 'file',
              'class': 'p5.File',
              'module': 'DOM'
            },
            'type': {
              'name': 'type',
              'class': 'p5.File',
              'module': 'DOM'
            },
            'subtype': {
              'name': 'subtype',
              'class': 'p5.File',
              'module': 'DOM'
            },
            'name': {
              'name': 'name',
              'class': 'p5.File',
              'module': 'DOM'
            },
            'size': {
              'name': 'size',
              'class': 'p5.File',
              'module': 'DOM'
            },
            'data': {
              'name': 'data',
              'class': 'p5.File',
              'module': 'DOM'
            }
          },
          'p5.Image': {
            'width': {
              'name': 'width',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'height': {
              'name': 'height',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'pixels': {
              'name': 'pixels',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'loadPixels': {
              'name': 'loadPixels',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'updatePixels': {
              'name': 'updatePixels',
              'class': 'p5.Image',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-offset of the target update area for the\n                             underlying canvas</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-offset of the target update area for the\n                             underlying canvas</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'w',
                      'description': '<p>width of the target update area for the\n                             underlying canvas</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the target update area for the\n                             underlying canvas</p>\n',
                      'type': 'Integer'
                    }
                  ]
                },
                {
                  'params': [
                  ]
                }
              ]
            },
            'get': {
              'name': 'get',
              'class': 'p5.Image',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the pixel</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the pixel</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '<p>width</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    }
                  ]
                }
              ]
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x-coordinate of the pixel</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-coordinate of the pixel</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'a',
                  'description': '<p>grayscale value | pixel array |\n                               a <a href="#/p5.Color">p5.Color</a> | image to copy</p>\n',
                  'type': 'Number|Number[]|Object'
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            },
            'resize': {
              'name': 'resize',
              'params': [
                {
                  'name': 'width',
                  'description': '<p>the resized image width</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'height',
                  'description': '<p>the resized image height</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            },
            'copy': {
              'name': 'copy',
              'class': 'p5.Image',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'srcImage',
                      'description': '<p>source image</p>\n',
                      'type': 'p5.Image|p5.Element'
                    },
                    {
                      'name': 'sx',
                      'description': '<p>X coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '<p>Y coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '<p>source image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '<p>source image height</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '<p>X coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '<p>Y coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '<p>destination image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '<p>destination image height</p>\n',
                      'type': 'Integer'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'sx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '',
                      'type': 'Integer'
                    }
                  ]
                }
              ]
            },
            'mask': {
              'name': 'mask',
              'params': [
                {
                  'name': 'srcImage',
                  'description': '<p>source image</p>\n',
                  'type': 'p5.Image'
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            },
            'filter': {
              'name': 'filter',
              'params': [
                {
                  'name': 'filterType',
                  'description': '<p>either THRESHOLD, GRAY, OPAQUE, INVERT,\n                               POSTERIZE, ERODE, DILATE or BLUR.\n                               See Filters.js for docs on\n                               each available filter</p>\n',
                  'type': 'Constant'
                },
                {
                  'name': 'filterParam',
                  'description': '<p>an optional parameter unique\n                               to each filter, see above</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            },
            'blend': {
              'name': 'blend',
              'class': 'p5.Image',
              'module': 'Image',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'srcImage',
                      'description': '<p>source image</p>\n',
                      'type': 'p5.Image'
                    },
                    {
                      'name': 'sx',
                      'description': '<p>X coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '<p>Y coordinate of the source\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '<p>source image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '<p>source image height</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '<p>X coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '<p>Y coordinate of the destination\'s upper left corner</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '<p>destination image width</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '<p>destination image height</p>\n',
                      'type': 'Integer'
                    },
                    {
                      'name': 'blendMode',
                      'description': '<p>the blend mode. either\n    BLEND, DARKEST, LIGHTEST, DIFFERENCE,\n    MULTIPLY, EXCLUSION, SCREEN, REPLACE, OVERLAY, HARD_LIGHT,\n    SOFT_LIGHT, DODGE, BURN, ADD or NORMAL.</p>\n<p>Available blend modes are: normal | multiply | screen | overlay |\n           darken | lighten | color-dodge | color-burn | hard-light |\n           soft-light | difference | exclusion | hue | saturation |\n           color | luminosity</p>\n<p><a href="http://blogs.adobe.com/webplatform/2013/01/28/blending-features-in-canvas/">http://blogs.adobe.com/webplatform/2013/01/28/blending-features-in-canvas/</a></p>\n',
                      'type': 'Constant'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'sx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'sh',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dx',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dy',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dw',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'dh',
                      'description': '',
                      'type': 'Integer'
                    },
                    {
                      'name': 'blendMode',
                      'description': '',
                      'type': 'Constant'
                    }
                  ]
                }
              ]
            },
            'save': {
              'name': 'save',
              'params': [
                {
                  'name': 'filename',
                  'description': '<p>give your file a name</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'extension',
                  'description': '<p>\'png\' or \'jpg\'</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            },
            'reset': {
              'name': 'reset',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'getCurrentFrame': {
              'name': 'getCurrentFrame',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'setFrame': {
              'name': 'setFrame',
              'params': [
                {
                  'name': 'index',
                  'description': '<p>the index for the frame that should be displayed</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            },
            'numFrames': {
              'name': 'numFrames',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'play': {
              'name': 'play',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'pause': {
              'name': 'pause',
              'class': 'p5.Image',
              'module': 'Image'
            },
            'delay': {
              'name': 'delay',
              'params': [
                {
                  'name': 'd',
                  'description': '<p>the amount in milliseconds to delay between switching frames</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'index',
                  'description': '<p>the index of the frame that should have the new delay value {optional}</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Image',
              'module': 'Image'
            }
          },
          'p5.PrintWriter': {
            'write': {
              'name': 'write',
              'params': [
                {
                  'name': 'data',
                  'description': '<p>all data to be written by the PrintWriter</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5.PrintWriter',
              'module': 'IO'
            },
            'print': {
              'name': 'print',
              'params': [
                {
                  'name': 'data',
                  'description': '<p>all data to be printed by the PrintWriter</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5.PrintWriter',
              'module': 'IO'
            },
            'clear': {
              'name': 'clear',
              'class': 'p5.PrintWriter',
              'module': 'IO'
            },
            'close': {
              'name': 'close',
              'class': 'p5.PrintWriter',
              'module': 'IO'
            }
          },
          'p5.Table': {
            'columns': {
              'name': 'columns',
              'class': 'p5.Table',
              'module': 'IO'
            },
            'rows': {
              'name': 'rows',
              'class': 'p5.Table',
              'module': 'IO'
            },
            'addRow': {
              'name': 'addRow',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row to be added to the table</p>\n',
                  'type': 'p5.TableRow',
                  'optional': true
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'removeRow': {
              'name': 'removeRow',
              'params': [
                {
                  'name': 'id',
                  'description': '<p>ID number of the row to remove</p>\n',
                  'type': 'Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getRow': {
              'name': 'getRow',
              'params': [
                {
                  'name': 'rowID',
                  'description': '<p>ID number of the row to get</p>\n',
                  'type': 'Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getRows': {
              'name': 'getRows',
              'class': 'p5.Table',
              'module': 'IO'
            },
            'findRow': {
              'name': 'findRow',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>The value to match</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'column',
                  'description': '<p>ID number or title of the\n                               column to search</p>\n',
                  'type': 'Integer|String'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'findRows': {
              'name': 'findRows',
              'params': [
                {
                  'name': 'value',
                  'description': '<p>The value to match</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'column',
                  'description': '<p>ID number or title of the\n                               column to search</p>\n',
                  'type': 'Integer|String'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'matchRow': {
              'name': 'matchRow',
              'params': [
                {
                  'name': 'regexp',
                  'description': '<p>The regular expression to match</p>\n',
                  'type': 'String|RegExp'
                },
                {
                  'name': 'column',
                  'description': '<p>The column ID (number) or\n                                 title (string)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'matchRows': {
              'name': 'matchRows',
              'params': [
                {
                  'name': 'regexp',
                  'description': '<p>The regular expression to match</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'column',
                  'description': '<p>The column ID (number) or\n                                 title (string)</p>\n',
                  'type': 'String|Integer',
                  'optional': true
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getColumn': {
              'name': 'getColumn',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>String or Number of the column to return</p>\n',
                  'type': 'String|Number'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'clearRows': {
              'name': 'clearRows',
              'class': 'p5.Table',
              'module': 'IO'
            },
            'addColumn': {
              'name': 'addColumn',
              'params': [
                {
                  'name': 'title',
                  'description': '<p>title of the given column</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getColumnCount': {
              'name': 'getColumnCount',
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getRowCount': {
              'name': 'getRowCount',
              'class': 'p5.Table',
              'module': 'IO'
            },
            'removeTokens': {
              'name': 'removeTokens',
              'params': [
                {
                  'name': 'chars',
                  'description': '<p>String listing characters to be removed</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'column',
                  'description': '<p>Column ID (number)\n                                 or name (string)</p>\n',
                  'type': 'String|Integer',
                  'optional': true
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'trim': {
              'name': 'trim',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>Column ID (number)\n                                 or name (string)</p>\n',
                  'type': 'String|Integer',
                  'optional': true
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'removeColumn': {
              'name': 'removeColumn',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row ID</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'column',
                  'description': '<p>column ID (Number)\n                              or title (String)</p>\n',
                  'type': 'String|Integer'
                },
                {
                  'name': 'value',
                  'description': '<p>value to assign</p>\n',
                  'type': 'String|Number'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'setNum': {
              'name': 'setNum',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row ID</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'column',
                  'description': '<p>column ID (Number)\n                              or title (String)</p>\n',
                  'type': 'String|Integer'
                },
                {
                  'name': 'value',
                  'description': '<p>value to assign</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'setString': {
              'name': 'setString',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row ID</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'column',
                  'description': '<p>column ID (Number)\n                              or title (String)</p>\n',
                  'type': 'String|Integer'
                },
                {
                  'name': 'value',
                  'description': '<p>value to assign</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'get': {
              'name': 'get',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row ID</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or\n                                  ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getNum': {
              'name': 'getNum',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row ID</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or\n                                  ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getString': {
              'name': 'getString',
              'params': [
                {
                  'name': 'row',
                  'description': '<p>row ID</p>\n',
                  'type': 'Integer'
                },
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or\n                                  ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getObject': {
              'name': 'getObject',
              'params': [
                {
                  'name': 'headerColumn',
                  'description': '<p>Name of the column which should be used to\n                             title each row object (optional)</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.Table',
              'module': 'IO'
            },
            'getArray': {
              'name': 'getArray',
              'class': 'p5.Table',
              'module': 'IO'
            }
          },
          'p5.TableRow': {
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>Column ID (Number)\n                              or Title (String)</p>\n',
                  'type': 'String|Integer'
                },
                {
                  'name': 'value',
                  'description': '<p>The value to be stored</p>\n',
                  'type': 'String|Number'
                }
              ],
              'class': 'p5.TableRow',
              'module': 'IO'
            },
            'setNum': {
              'name': 'setNum',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>Column ID (Number)\n                              or Title (String)</p>\n',
                  'type': 'String|Integer'
                },
                {
                  'name': 'value',
                  'description': '<p>The value to be stored\n                              as a Float</p>\n',
                  'type': 'Number|String'
                }
              ],
              'class': 'p5.TableRow',
              'module': 'IO'
            },
            'setString': {
              'name': 'setString',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>Column ID (Number)\n                              or Title (String)</p>\n',
                  'type': 'String|Integer'
                },
                {
                  'name': 'value',
                  'description': '<p>The value to be stored\n                              as a String</p>\n',
                  'type': 'String|Number|Boolean|Object'
                }
              ],
              'class': 'p5.TableRow',
              'module': 'IO'
            },
            'get': {
              'name': 'get',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or\n                                 ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.TableRow',
              'module': 'IO'
            },
            'getNum': {
              'name': 'getNum',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or\n                                 ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.TableRow',
              'module': 'IO'
            },
            'getString': {
              'name': 'getString',
              'params': [
                {
                  'name': 'column',
                  'description': '<p>columnName (string) or\n                                 ID (number)</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.TableRow',
              'module': 'IO'
            }
          },
          'p5.XML': {
            'getParent': {
              'name': 'getParent',
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getName': {
              'name': 'getName',
              'class': 'p5.XML',
              'module': 'IO'
            },
            'setName': {
              'name': 'setName',
              'params': [
                {
                  'name': 'the',
                  'description': '<p>new name of the node</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'hasChildren': {
              'name': 'hasChildren',
              'class': 'p5.XML',
              'module': 'IO'
            },
            'listChildren': {
              'name': 'listChildren',
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getChildren': {
              'name': 'getChildren',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>element name</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getChild': {
              'name': 'getChild',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>element name or index</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'addChild': {
              'name': 'addChild',
              'params': [
                {
                  'name': 'node',
                  'description': '<p>a <a href="#/p5.XML">p5.XML</a> Object which will be the child to be added</p>\n',
                  'type': 'p5.XML'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'removeChild': {
              'name': 'removeChild',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>element name or index</p>\n',
                  'type': 'String|Integer'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getAttributeCount': {
              'name': 'getAttributeCount',
              'class': 'p5.XML',
              'module': 'IO'
            },
            'listAttributes': {
              'name': 'listAttributes',
              'class': 'p5.XML',
              'module': 'IO'
            },
            'hasAttribute': {
              'name': 'hasAttribute',
              'params': [
                {
                  'name': 'the',
                  'description': '<p>attribute to be checked</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getNum': {
              'name': 'getNum',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>the non-null full name of the attribute</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'defaultValue',
                  'description': '<p>the default value of the attribute</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getString': {
              'name': 'getString',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>the non-null full name of the attribute</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'defaultValue',
                  'description': '<p>the default value of the attribute</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'setAttribute': {
              'name': 'setAttribute',
              'params': [
                {
                  'name': 'name',
                  'description': '<p>the full name of the attribute</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'value',
                  'description': '<p>the value of the attribute</p>\n',
                  'type': 'Number|String|Boolean'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'getContent': {
              'name': 'getContent',
              'params': [
                {
                  'name': 'defaultValue',
                  'description': '<p>value returned if no content is found</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'setContent': {
              'name': 'setContent',
              'params': [
                {
                  'name': 'text',
                  'description': '<p>the new content</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.XML',
              'module': 'IO'
            },
            'serialize': {
              'name': 'serialize',
              'class': 'p5.XML',
              'module': 'IO'
            }
          },
          'p5.Vector': {
            'x': {
              'name': 'x',
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'y': {
              'name': 'y',
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'z': {
              'name': 'z',
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'toString': {
              'name': 'toString',
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'set': {
              'name': 'set',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>The vector to set</p>\n',
                      'type': 'p5.Vector|Number[]'
                    }
                  ],
                  'chainable': 1
                }
              ]
            },
            'copy': {
              'name': 'copy',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>the <a href="#/p5.Vector">p5.Vector</a> to create a copy of</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'add': {
              'name': 'add',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of the vector to be added</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of the vector to be added</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of the vector to be added</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>The vector to add</p>\n',
                      'type': 'p5.Vector|Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>A <a href="#/p5.Vector">p5.Vector</a> to add</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>A <a href="#/p5.Vector">p5.Vector</a> to add</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'rem': {
              'name': 'rem',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of divisor vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of divisor vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of divisor vector</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>The divisor vector</p>\n',
                      'type': 'p5.Vector | Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>The dividend <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>The divisor <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'sub': {
              'name': 'sub',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of the vector to subtract</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of the vector to subtract</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of the vector to subtract</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>the vector to subtract</p>\n',
                      'type': 'p5.Vector|Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>A <a href="#/p5.Vector">p5.Vector</a> to subtract from</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>A <a href="#/p5.Vector">p5.Vector</a> to subtract</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'mult': {
              'name': 'mult',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>The number to multiply with the vector</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The number to multiply with the x component of the vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The number to multiply with the y component of the vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>The number to multiply with the z component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'arr',
                      'description': '<p>The array to multiply with the components of the vector</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>The vector to multiply with the components of the original vector</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'n',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>the vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v0',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'target',
                      'description': '',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v0',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'arr',
                      'description': '',
                      'type': 'Number[]'
                    },
                    {
                      'name': 'target',
                      'description': '',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'div': {
              'name': 'div',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'n',
                      'description': '<p>The number to divide the vector by</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The number to divide with the x component of the vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The number to divide with the y component of the vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>The number to divide with the z component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'arr',
                      'description': '<p>The array to divide the components of the vector by</p>\n',
                      'type': 'Number[]'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>The vector to divide the components of the original vector by</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '',
                      'type': 'Number',
                      'optional': true
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'n',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v0',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'target',
                      'description': '',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                },
                {
                  'params': [
                    {
                      'name': 'v0',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'arr',
                      'description': '',
                      'type': 'Number[]'
                    },
                    {
                      'name': 'target',
                      'description': '',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'mag': {
              'name': 'mag',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'vecT',
                      'description': '<p>The vector to return the magnitude of</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'magSq': {
              'name': 'magSq',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'vecT',
                      'description': '<p>the vector to return the squared magnitude of</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'dot': {
              'name': 'dot',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of the vector</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>value component of the vector or a <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>The first <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>The second <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'cross': {
              'name': 'cross',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p><a href="#/p5.Vector">p5.Vector</a> to be crossed</p>\n',
                      'type': 'p5.Vector'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>The first <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>The second <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'dist': {
              'name': 'dist',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>The x, y, and z coordinates of a <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>The first <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>The second <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'normalize': {
              'name': 'normalize',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>The vector to normalize</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'limit': {
              'name': 'limit',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'max',
                      'description': '<p>The maximum magnitude for the vector</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>the vector to limit</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'max',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>the vector to receive the result (Optional)</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'setMag': {
              'name': 'setMag',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'len',
                      'description': '<p>The new length for this vector</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>the vector to set the magnitude of</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'len',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>the vector to receive the result (Optional)</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'heading': {
              'name': 'heading',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>the vector to find the angle of</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'setHeading': {
              'name': 'setHeading',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>The angle of rotation</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'rotate': {
              'name': 'rotate',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'angle',
                      'description': '<p>The angle of rotation</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'angle',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'angleBetween': {
              'name': 'angleBetween',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>The x, y, and z components of a <a href="#/p5.Vector">p5.Vector</a></p>\n',
                      'type': 'p5.Vector'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>the first vector</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>the second vector</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'lerp': {
              'name': 'lerp',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'amt',
                      'description': '<p>The amount of interpolation; some value between 0.0\n                        (old vector) and 1.0 (new vector). 0.9 is very near\n                        the new vector. 0.5 is halfway in between.</p>\n',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>The <a href="#/p5.Vector">p5.Vector</a> to lerp to</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'amt',
                      'description': '',
                      'type': 'Number'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'amt',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'slerp': {
              'name': 'slerp',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>the p5.Vector to slerp to</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'amt',
                      'description': '<p>The amount of interpolation. some value between 0.0\n                    (old vector) and 1.0 (new vector). 0.9 is very near\n                    the new vector. 0.5 is halfway in between.</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>old vector</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>new vectpr</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'amt',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'target',
                      'description': '<p>The vector to receive the result</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'reflect': {
              'name': 'reflect',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'surfaceNormal',
                      'description': '<p>the <a href="#/p5.Vector">p5.Vector</a>\n                                   to reflect about.</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'chainable': 1
                },
                {
                  'params': [
                    {
                      'name': 'incidentVector',
                      'description': '<p>vector to be reflected</p>\n',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'surfaceNormal',
                      'description': '',
                      'type': 'p5.Vector'
                    },
                    {
                      'name': 'target',
                      'description': '<p>the vector to receive the result (Optional)</p>\n',
                      'type': 'p5.Vector',
                      'optional': true
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'array': {
              'name': 'array',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v',
                      'description': '<p>the vector to convert to an array</p>\n',
                      'type': 'p5.Vector'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'equals': {
              'name': 'equals',
              'class': 'p5.Vector',
              'module': 'Math',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>The x component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'y',
                      'description': '<p>The y component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    },
                    {
                      'name': 'z',
                      'description': '<p>The z component of the vector</p>\n',
                      'type': 'Number',
                      'optional': true
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'value',
                      'description': '<p>The vector to compare</p>\n',
                      'type': 'p5.Vector|Array'
                    }
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'v1',
                      'description': '<p>the first vector to compare</p>\n',
                      'type': 'p5.Vector|Array'
                    },
                    {
                      'name': 'v2',
                      'description': '<p>the second vector to compare</p>\n',
                      'type': 'p5.Vector|Array'
                    }
                  ],
                  'static': 1
                }
              ]
            },
            'fromAngle': {
              'name': 'fromAngle',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>The desired angle, in radians (unaffected by <a href="#/p5/angleMode">angleMode</a>)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'length',
                  'description': '<p>The length of the new vector (defaults to 1)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'fromAngles': {
              'name': 'fromAngles',
              'params': [
                {
                  'name': 'theta',
                  'description': '<p>The polar angle, in radians (zero is up)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'phi',
                  'description': '<p>The azimuthal angle, in radians\n                              (zero is out of the screen)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'length',
                  'description': '<p>The length of the new vector (defaults to 1)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'random2D': {
              'name': 'random2D',
              'class': 'p5.Vector',
              'module': 'Math'
            },
            'random3D': {
              'name': 'random3D',
              'class': 'p5.Vector',
              'module': 'Math'
            }
          },
          'p5.Font': {
            'font': {
              'name': 'font',
              'class': 'p5.Font',
              'module': 'Typography'
            },
            'textBounds': {
              'name': 'textBounds',
              'params': [
                {
                  'name': 'line',
                  'description': '<p>a line of text</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'x',
                  'description': '<p>x-position</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-position</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'fontSize',
                  'description': '<p>font size to use (optional) Default is 12.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'options',
                  'description': '<p>opentype options (optional)\n                           opentype fonts contains alignment and baseline options.\n                           Default is \'LEFT\' and \'alphabetic\'</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.Font',
              'module': 'Typography'
            },
            'textToPoints': {
              'name': 'textToPoints',
              'params': [
                {
                  'name': 'txt',
                  'description': '<p>a line of text</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'x',
                  'description': '<p>x-position</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y-position</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'fontSize',
                  'description': '<p>font size to use (optional)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'options',
                  'description': '<p>an (optional) object that can contain:</p>\n<p><br>sampleFactor - the ratio of path-length to number of samples\n(default=.1); higher values yield more points and are therefore\nmore precise</p>\n<p><br>simplifyThreshold - if set to a non-zero value, collinear points will be\nbe removed from the polygon; the value represents the threshold angle to use\nwhen determining whether two edges are collinear</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.Font',
              'module': 'Typography'
            }
          },
          'p5.Camera': {
            'eyeX': {
              'name': 'eyeX',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'eyeY': {
              'name': 'eyeY',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'eyeZ': {
              'name': 'eyeZ',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'centerX': {
              'name': 'centerX',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'centerY': {
              'name': 'centerY',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'centerZ': {
              'name': 'centerZ',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'upX': {
              'name': 'upX',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'upY': {
              'name': 'upY',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'upZ': {
              'name': 'upZ',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'perspective': {
              'name': 'perspective',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'ortho': {
              'name': 'ortho',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'frustum': {
              'name': 'frustum',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'pan': {
              'name': 'pan',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>amount to rotate camera in current\n<a href="#/p5/angleMode">angleMode</a> units.\nGreater than 0 values rotate counterclockwise (to the left).</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            },
            'tilt': {
              'name': 'tilt',
              'params': [
                {
                  'name': 'angle',
                  'description': '<p>amount to rotate camera in current\n<a href="#/p5/angleMode">angleMode</a> units.\nGreater than 0 values rotate counterclockwise (to the left).</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            },
            'lookAt': {
              'name': 'lookAt',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x position of a point in world space</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y position of a point in world space</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'z',
                  'description': '<p>z position of a point in world space</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            },
            'camera': {
              'name': 'camera',
              'class': 'p5.Camera',
              'module': '3D'
            },
            'move': {
              'name': 'move',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>amount to move along camera\'s left-right axis</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>amount to move along camera\'s up-down axis</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'z',
                  'description': '<p>amount to move along camera\'s forward-backward axis</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            },
            'setPosition': {
              'name': 'setPosition',
              'params': [
                {
                  'name': 'x',
                  'description': '<p>x position of a point in world space</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'y',
                  'description': '<p>y position of a point in world space</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'z',
                  'description': '<p>z position of a point in world space</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'cam',
                  'description': '<p>source camera</p>\n',
                  'type': 'p5.Camera'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            },
            'slerp': {
              'name': 'slerp',
              'params': [
                {
                  'name': 'cam0',
                  'description': '<p>first p5.Camera</p>\n',
                  'type': 'p5.Camera'
                },
                {
                  'name': 'cam1',
                  'description': '<p>second p5.Camera</p>\n',
                  'type': 'p5.Camera'
                },
                {
                  'name': 'amt',
                  'description': '<p>amount to use for interpolation during slerp</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Camera',
              'module': '3D'
            }
          },
          'p5.Framebuffer': {
            'pixels': {
              'name': 'pixels',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'resize': {
              'name': 'resize',
              'params': [
                {
                  'name': 'width',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'height',
                  'description': '',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'pixelDensity': {
              'name': 'pixelDensity',
              'params': [
                {
                  'name': 'density',
                  'description': '<p>A scaling factor for the number of pixels per\nside of the framebuffer</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'autoSized': {
              'name': 'autoSized',
              'params': [
                {
                  'name': 'autoSized',
                  'description': '<p>Whether or not the framebuffer should resize\nalong with the canvas it\'s attached to</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'createCamera': {
              'name': 'createCamera',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'remove': {
              'name': 'remove',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'begin': {
              'name': 'begin',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'end': {
              'name': 'end',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'draw': {
              'name': 'draw',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>A function to run that draws to the canvas. The\nfunction will immediately be run, but it will draw to the framebuffer\ninstead of the canvas.</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'get': {
              'name': 'get',
              'class': 'p5.Framebuffer',
              'module': 'Rendering',
              'overloads': [
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '<p>x-coordinate of the pixel</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '<p>y-coordinate of the pixel</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'w',
                      'description': '<p>width of the section to be returned</p>\n',
                      'type': 'Number'
                    },
                    {
                      'name': 'h',
                      'description': '<p>height of the section to be returned</p>\n',
                      'type': 'Number'
                    }
                  ]
                },
                {
                  'params': [
                  ]
                },
                {
                  'params': [
                    {
                      'name': 'x',
                      'description': '',
                      'type': 'Number'
                    },
                    {
                      'name': 'y',
                      'description': '',
                      'type': 'Number'
                    }
                  ]
                }
              ]
            },
            'color': {
              'name': 'color',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            },
            'depth': {
              'name': 'depth',
              'class': 'p5.Framebuffer',
              'module': 'Rendering'
            }
          },
          'p5.Geometry': {
            'computeFaces': {
              'name': 'computeFaces',
              'class': 'p5.Geometry',
              'module': 'Shape'
            },
            'computeNormals': {
              'name': 'computeNormals',
              'class': 'p5.Geometry',
              'module': 'Shape'
            },
            'averageNormals': {
              'name': 'averageNormals',
              'class': 'p5.Geometry',
              'module': 'Shape'
            },
            'averagePoleNormals': {
              'name': 'averagePoleNormals',
              'class': 'p5.Geometry',
              'module': 'Shape'
            },
            'normalize': {
              'name': 'normalize',
              'class': 'p5.Geometry',
              'module': 'Shape'
            }
          },
          'p5.Shader': {
            'setUniform': {
              'name': 'setUniform',
              'params': [
                {
                  'name': 'uniformName',
                  'description': '<p>the name of the uniform.\nMust correspond to the name used in the vertex and fragment shaders</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'data',
                  'description': '<p>the data to associate with the uniform. The type can be\na boolean (true/false), a number, an array of numbers, or\nan image (p5.Image, p5.Graphics, p5.MediaElement, p5.Texture)</p>\n',
                  'type': 'Boolean|Number|Number[]|p5.Image|p5.Graphics|p5.MediaElement|p5.Texture'
                }
              ],
              'class': 'p5.Shader',
              'module': '3D'
            }
          },
          'p5.SoundFile': {
            'isLoaded': {
              'name': 'isLoaded',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'play': {
              'name': 'play',
              'params': [
                {
                  'name': 'startTime',
                  'description': '<p>(optional) schedule playback to start (in seconds from now).</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'rate',
                  'description': '<p>(optional) playback rate</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'amp',
                  'description': '<p>(optional) amplitude (volume)\n                                    of playback</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'cueStart',
                  'description': '<p>(optional) cue start time in seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'duration',
                  'description': '<p>(optional) duration of playback in seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'playMode': {
              'name': 'playMode',
              'params': [
                {
                  'name': 'str',
                  'description': '<p>\'restart\' or \'sustain\' or \'untilDone\'</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'pause': {
              'name': 'pause',
              'params': [
                {
                  'name': 'startTime',
                  'description': '<p>(optional) schedule event to occur\n                             seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'loop': {
              'name': 'loop',
              'params': [
                {
                  'name': 'startTime',
                  'description': '<p>(optional) schedule event to occur\n                            seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'rate',
                  'description': '<p>(optional) playback rate</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'amp',
                  'description': '<p>(optional) playback volume</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'cueLoopStart',
                  'description': '<p>(optional) startTime in seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'duration',
                  'description': '<p>(optional) loop duration in seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'setLoop': {
              'name': 'setLoop',
              'params': [
                {
                  'name': 'Boolean',
                  'description': '<p>set looping to true or false</p>\n',
                  'type': 'Boolean'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'isLooping': {
              'name': 'isLooping',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'isPlaying': {
              'name': 'isPlaying',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'isPaused': {
              'name': 'isPaused',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'params': [
                {
                  'name': 'startTime',
                  'description': '<p>(optional) schedule event to occur\n                            in seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'pan': {
              'name': 'pan',
              'params': [
                {
                  'name': 'panValue',
                  'description': '<p>Set the stereo panner</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                                seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'getPan': {
              'name': 'getPan',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'rate': {
              'name': 'rate',
              'params': [
                {
                  'name': 'playbackRate',
                  'description': '<p>Set the playback rate. 1.0 is normal,\n                                   .5 is half-speed, 2.0 is twice as fast.\n                                   Values less than zero play backwards.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'setVolume': {
              'name': 'setVolume',
              'params': [
                {
                  'name': 'volume',
                  'description': '<p>Volume (amplitude) between 0.0\n                                   and 1.0 or modulating signal/oscillator</p>\n',
                  'type': 'Number|Object'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Fade for t seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>Schedule this event to happen at\n                               t seconds in the future</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'duration': {
              'name': 'duration',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'currentTime': {
              'name': 'currentTime',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'jump': {
              'name': 'jump',
              'params': [
                {
                  'name': 'cueTime',
                  'description': '<p>cueTime of the soundFile in seconds.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'duration',
                  'description': '<p>duration in seconds.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'channels': {
              'name': 'channels',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'sampleRate': {
              'name': 'sampleRate',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'frames': {
              'name': 'frames',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'getPeaks': {
              'name': 'getPeaks',
              'params': [
                {
                  'name': 'length',
                  'description': '<p>length is the size of the returned array.\n                         Larger length results in more precision.\n                         Defaults to 5*width of the browser window.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'reverseBuffer': {
              'name': 'reverseBuffer',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'onended': {
              'name': 'onended',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>function to call when the\n                            soundfile has ended.</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'object',
                  'description': '<p>Audio object that accepts an input</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'setPath': {
              'name': 'setPath',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>path to audio file</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>Callback</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'setBuffer': {
              'name': 'setBuffer',
              'params': [
                {
                  'name': 'buf',
                  'description': '<p>Array of Float32 Array(s). 2 Float32 Arrays\n                   will create a stereo source. 1 will create\n                   a mono source.</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'addCue': {
              'name': 'addCue',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>Time in seconds, relative to this media\n                           element\'s playback. For example, to trigger\n                           an event every time playback reaches two\n                           seconds, pass in the number 2. This will be\n                           passed as the first parameter to\n                           the callback function.</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'callback',
                  'description': '<p>Name of a function that will be\n                           called at the given time. The callback will\n                           receive time and (optionally) param as its\n                           two parameters.</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'value',
                  'description': '<p>An object to be passed as the\n                           second parameter to the\n                           callback function.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'removeCue': {
              'name': 'removeCue',
              'params': [
                {
                  'name': 'id',
                  'description': '<p>ID of the cue, as returned by addCue</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'clearCues': {
              'name': 'clearCues',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'save': {
              'name': 'save',
              'params': [
                {
                  'name': 'fileName',
                  'description': '<p>name of the resulting .wav file.</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            },
            'getBlob': {
              'name': 'getBlob',
              'class': 'p5.SoundFile',
              'module': 'p5.sound'
            }
          },
          'p5.Amplitude': {
            'setInput': {
              'name': 'setInput',
              'params': [
                {
                  'name': 'snd',
                  'description': '<p>set the sound source\n                                     (optional, defaults to\n                                     main output)</p>\n',
                  'type': 'SoundObject|undefined',
                  'optional': true
                },
                {
                  'name': 'smoothing',
                  'description': '<p>a range between 0.0 and 1.0\n                                      to smooth amplitude readings</p>\n',
                  'type': 'Number|undefined',
                  'optional': true
                }
              ],
              'class': 'p5.Amplitude',
              'module': 'p5.sound'
            },
            'getLevel': {
              'name': 'getLevel',
              'params': [
                {
                  'name': 'channel',
                  'description': '<p>Optionally return only channel 0 (left) or 1 (right)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Amplitude',
              'module': 'p5.sound'
            },
            'toggleNormalize': {
              'name': 'toggleNormalize',
              'params': [
                {
                  'name': 'boolean',
                  'description': '<p>set normalize to true (1) or false (0)</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5.Amplitude',
              'module': 'p5.sound'
            },
            'smooth': {
              'name': 'smooth',
              'params': [
                {
                  'name': 'set',
                  'description': '<p>smoothing from 0.0 <= 1</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Amplitude',
              'module': 'p5.sound'
            }
          },
          'p5.FFT': {
            'setInput': {
              'name': 'setInput',
              'params': [
                {
                  'name': 'source',
                  'description': '<p>p5.sound object (or web audio API source node)</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'waveform': {
              'name': 'waveform',
              'params': [
                {
                  'name': 'bins',
                  'description': '<p>Must be a power of two between\n                          16 and 1024. Defaults to 1024.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'precision',
                  'description': '<p>If any value is provided, will return results\n                            in a Float32 Array which is more precise\n                            than a regular array.</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'analyze': {
              'name': 'analyze',
              'params': [
                {
                  'name': 'bins',
                  'description': '<p>Must be a power of two between\n                           16 and 1024. Defaults to 1024.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'scale',
                  'description': '<p>If "dB," returns decibel\n                           float measurements between\n                           -140 and 0 (max).\n                           Otherwise returns integers from 0-255.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'getEnergy': {
              'name': 'getEnergy',
              'params': [
                {
                  'name': 'frequency1',
                  'description': '<p>Will return a value representing\n                              energy at this frequency. Alternately,\n                              the strings "bass", "lowMid" "mid",\n                              "highMid", and "treble" will return\n                              predefined frequency ranges.</p>\n',
                  'type': 'Number|String'
                },
                {
                  'name': 'frequency2',
                  'description': '<p>If a second frequency is given,\n                              will return average amount of\n                              energy that exists between the\n                              two frequencies.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'getCentroid': {
              'name': 'getCentroid',
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'smooth': {
              'name': 'smooth',
              'params': [
                {
                  'name': 'smoothing',
                  'description': '<p>0.0 < smoothing < 1.0.\n                             Defaults to 0.8.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'linAverages': {
              'name': 'linAverages',
              'params': [
                {
                  'name': 'N',
                  'description': '<p>Number of returned frequency groups</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'logAverages': {
              'name': 'logAverages',
              'params': [
                {
                  'name': 'octaveBands',
                  'description': '<p>Array of Octave Bands objects for grouping</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            },
            'getOctaveBands': {
              'name': 'getOctaveBands',
              'params': [
                {
                  'name': 'N',
                  'description': '<p>Specifies the 1/N type of generated octave bands</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'fCtr0',
                  'description': '<p>Minimum central frequency for the lowest band</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.FFT',
              'module': 'p5.sound'
            }
          },
          'p5.Oscillator': {
            'start': {
              'name': 'start',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>startTime in seconds from now.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'frequency',
                  'description': '<p>frequency in Hz.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'params': [
                {
                  'name': 'secondsFromNow',
                  'description': '<p>Time, in seconds from now.</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'vol',
                  'description': '<p>between 0 and 1.0\n                            or a modulating signal/oscillator</p>\n',
                  'type': 'Number|Object'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>create a fade that lasts rampTime</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'getAmp': {
              'name': 'getAmp',
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'freq': {
              'name': 'freq',
              'params': [
                {
                  'name': 'Frequency',
                  'description': '<p>Frequency in Hz\n                                      or modulating signal/oscillator</p>\n',
                  'type': 'Number|Object'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Ramp time (in seconds)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>Schedule this event to happen\n                                 at x seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'getFreq': {
              'name': 'getFreq',
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'setType': {
              'name': 'setType',
              'params': [
                {
                  'name': 'type',
                  'description': '<p>\'sine\', \'triangle\', \'sawtooth\' or \'square\'.</p>\n',
                  'type': 'String'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'getType': {
              'name': 'getType',
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>A p5.sound or Web Audio object</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'pan': {
              'name': 'pan',
              'params': [
                {
                  'name': 'panning',
                  'description': '<p>Number between -1 and 1</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'getPan': {
              'name': 'getPan',
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'phase': {
              'name': 'phase',
              'params': [
                {
                  'name': 'phase',
                  'description': '<p>float between 0.0 and 1.0</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'add': {
              'name': 'add',
              'params': [
                {
                  'name': 'number',
                  'description': '<p>Constant number to add</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'mult': {
              'name': 'mult',
              'params': [
                {
                  'name': 'number',
                  'description': '<p>Constant number to multiply</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            },
            'scale': {
              'name': 'scale',
              'params': [
                {
                  'name': 'inMin',
                  'description': '<p>input range minumum</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'inMax',
                  'description': '<p>input range maximum</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'outMin',
                  'description': '<p>input range minumum</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'outMax',
                  'description': '<p>input range maximum</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Oscillator',
              'module': 'p5.sound'
            }
          },
          'p5.Envelope': {
            'attackTime': {
              'name': 'attackTime',
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'attackLevel': {
              'name': 'attackLevel',
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'decayTime': {
              'name': 'decayTime',
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'decayLevel': {
              'name': 'decayLevel',
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'releaseTime': {
              'name': 'releaseTime',
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'releaseLevel': {
              'name': 'releaseLevel',
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'attackTime',
                  'description': '<p>Time (in seconds) before level\n                               reaches attackLevel</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'attackLevel',
                  'description': '<p>Typically an amplitude between\n                               0.0 and 1.0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'decayTime',
                  'description': '<p>Time</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'decayLevel',
                  'description': '<p>Amplitude (In a standard ADSR envelope,\n                               decayLevel = sustainLevel)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'releaseTime',
                  'description': '<p>Release Time (in seconds)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'releaseLevel',
                  'description': '<p>Amplitude</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'setADSR': {
              'name': 'setADSR',
              'params': [
                {
                  'name': 'attackTime',
                  'description': '<p>Time (in seconds before envelope\n                              reaches Attack Level</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'decayTime',
                  'description': '<p>Time (in seconds) before envelope\n                              reaches Decay/Sustain Level</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'susRatio',
                  'description': '<p>Ratio between attackLevel and releaseLevel, on a scale from 0 to 1,\n                              where 1.0 = attackLevel, 0.0 = releaseLevel.\n                              The susRatio determines the decayLevel and the level at which the\n                              sustain portion of the envelope will sustain.\n                              For example, if attackLevel is 0.4, releaseLevel is 0,\n                              and susAmt is 0.5, the decayLevel would be 0.2. If attackLevel is\n                              increased to 1.0 (using <code>setRange</code>),\n                              then decayLevel would increase proportionally, to become 0.5.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'releaseTime',
                  'description': '<p>Time in seconds from now (defaults to 0)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'setRange': {
              'name': 'setRange',
              'params': [
                {
                  'name': 'aLevel',
                  'description': '<p>attack level (defaults to 1)</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rLevel',
                  'description': '<p>release level (defaults to 0)</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'setInput': {
              'name': 'setInput',
              'params': [
                {
                  'name': 'inputs',
                  'description': '<p>A p5.sound object or\n                              Web Audio Param.</p>\n',
                  'type': 'Object',
                  'optional': true,
                  'multiple': true
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'setExp': {
              'name': 'setExp',
              'params': [
                {
                  'name': 'isExp',
                  'description': '<p>true is exponential, false is linear</p>\n',
                  'type': 'Boolean'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'play': {
              'name': 'play',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>A p5.sound object or\n                              Web Audio Param.</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'startTime',
                  'description': '<p>time from now (in seconds) at which to play</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'sustainTime',
                  'description': '<p>time to sustain before releasing the envelope</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'triggerAttack': {
              'name': 'triggerAttack',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>p5.sound Object or Web Audio Param</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time from now (in seconds)</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'triggerRelease': {
              'name': 'triggerRelease',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>p5.sound Object or Web Audio Param</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time to trigger the release</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'ramp': {
              'name': 'ramp',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>p5.sound Object or Web Audio Param</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>When to trigger the ramp</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'v',
                  'description': '<p>Target value</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'v2',
                  'description': '<p>Second target value</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'add': {
              'name': 'add',
              'params': [
                {
                  'name': 'number',
                  'description': '<p>Constant number to add</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'mult': {
              'name': 'mult',
              'params': [
                {
                  'name': 'number',
                  'description': '<p>Constant number to multiply</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            },
            'scale': {
              'name': 'scale',
              'params': [
                {
                  'name': 'inMin',
                  'description': '<p>input range minumum</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'inMax',
                  'description': '<p>input range maximum</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'outMin',
                  'description': '<p>input range minumum</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'outMax',
                  'description': '<p>input range maximum</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Envelope',
              'module': 'p5.sound'
            }
          },
          'p5.Noise': {
            'setType': {
              'name': 'setType',
              'params': [
                {
                  'name': 'type',
                  'description': '<p>\'white\', \'pink\' or \'brown\'</p>\n',
                  'type': 'String',
                  'optional': true
                }
              ],
              'class': 'p5.Noise',
              'module': 'p5.sound'
            }
          },
          'p5.Pulse': {
            'width': {
              'name': 'width',
              'params': [
                {
                  'name': 'width',
                  'description': '<p>Width between the pulses (0 to 1.0,\n                       defaults to 0)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Pulse',
              'module': 'p5.sound'
            }
          },
          'p5.AudioIn': {
            'input': {
              'name': 'input',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'output': {
              'name': 'output',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'stream': {
              'name': 'stream',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'mediaStream': {
              'name': 'mediaStream',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'currentSource': {
              'name': 'currentSource',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'enabled': {
              'name': 'enabled',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'amplitude': {
              'name': 'amplitude',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'start': {
              'name': 'start',
              'params': [
                {
                  'name': 'successCallback',
                  'description': '<p>Name of a function to call on\n                                  success.</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>Name of a function to call if\n                                  there was an error. For example,\n                                  some browsers do not support\n                                  getUserMedia.</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>An object that accepts audio input,\n                        such as an FFT</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'getLevel': {
              'name': 'getLevel',
              'params': [
                {
                  'name': 'smoothing',
                  'description': '<p>Smoothing is 0.0 by default.\n                             Smooths values based on previous values.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'vol',
                  'description': '<p>between 0 and 1.0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'time',
                  'description': '<p>ramp time (optional)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'getSources': {
              'name': 'getSources',
              'params': [
                {
                  'name': 'successCallback',
                  'description': '<p>This callback function handles the sources when they\n                                     have been enumerated. The callback function\n                                     receives the deviceList array as its only argument</p>\n',
                  'type': 'Function',
                  'optional': true
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>This optional callback receives the error\n                                   message as its argument.</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            },
            'setSource': {
              'name': 'setSource',
              'params': [
                {
                  'name': 'num',
                  'description': '<p>position of input source in the array</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.AudioIn',
              'module': 'p5.sound'
            }
          },
          'p5.Effect': {
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'vol',
                  'description': '<p>amplitude between 0 and 1.0</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'rampTime',
                  'description': '<p>create a fade that lasts until rampTime</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'tFromNow',
                  'description': '<p>schedule this event to happen in tFromNow seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Effect',
              'module': 'p5.sound'
            },
            'chain': {
              'name': 'chain',
              'params': [
                {
                  'name': 'arguments',
                  'description': '<p>Chain together multiple sound objects</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.Effect',
              'module': 'p5.sound'
            },
            'drywet': {
              'name': 'drywet',
              'params': [
                {
                  'name': 'fade',
                  'description': '<p>The desired drywet value (0 - 1.0)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Effect',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Effect',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.Effect',
              'module': 'p5.sound'
            }
          },
          'p5.Filter': {
            'biquadFilter': {
              'name': 'biquadFilter',
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'Signal',
                  'description': '<p>An object that outputs audio</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'freq',
                  'description': '<p>Frequency in Hz, from 10 to 22050</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'res',
                  'description': '<p>Resonance/Width of the filter frequency\n                      from 0.001 to 1000</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'freq',
                  'description': '<p>Frequency in Hz, from 10 to 22050</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'res',
                  'description': '<p>Resonance (Q) from 0.001 to 1000</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'freq': {
              'name': 'freq',
              'params': [
                {
                  'name': 'freq',
                  'description': '<p>Filter Frequency</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'res': {
              'name': 'res',
              'params': [
                {
                  'name': 'res',
                  'description': '<p>Resonance/Width of filter freq\n                     from 0.001 to 1000</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'gain': {
              'name': 'gain',
              'params': [
                {
                  'name': 'gain',
                  'description': '',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'toggle': {
              'name': 'toggle',
              'class': 'p5.Filter',
              'module': 'p5.sound'
            },
            'setType': {
              'name': 'setType',
              'params': [
                {
                  'name': 't',
                  'description': '',
                  'type': 'String'
                }
              ],
              'class': 'p5.Filter',
              'module': 'p5.sound'
            }
          },
          'p5.EQ': {
            'bands': {
              'name': 'bands',
              'class': 'p5.EQ',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>Audio source</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.EQ',
              'module': 'p5.sound'
            }
          },
          'p5.Panner3D': {
            'panner': {
              'name': 'panner',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>Input source</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'xVal',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'yVal',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'zVal',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'time',
                  'description': '',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'positionX': {
              'name': 'positionX',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'positionY': {
              'name': 'positionY',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'positionZ': {
              'name': 'positionZ',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'orient': {
              'name': 'orient',
              'params': [
                {
                  'name': 'xVal',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'yVal',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'zVal',
                  'description': '',
                  'type': 'Number'
                },
                {
                  'name': 'time',
                  'description': '',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'orientX': {
              'name': 'orientX',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'orientY': {
              'name': 'orientY',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'orientZ': {
              'name': 'orientZ',
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'setFalloff': {
              'name': 'setFalloff',
              'params': [
                {
                  'name': 'maxDistance',
                  'description': '',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'rolloffFactor',
                  'description': '',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'maxDist': {
              'name': 'maxDist',
              'params': [
                {
                  'name': 'maxDistance',
                  'description': '',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            },
            'rollof': {
              'name': 'rollof',
              'params': [
                {
                  'name': 'rolloffFactor',
                  'description': '',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Panner3D',
              'module': 'p5.sound'
            }
          },
          'p5.Delay': {
            'leftDelay': {
              'name': 'leftDelay',
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'rightDelay': {
              'name': 'rightDelay',
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'Signal',
                  'description': '<p>An object that outputs audio</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'delayTime',
                  'description': '<p>Time (in seconds) of the delay/echo.\n                             Some browsers limit delayTime to\n                             1 second.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'feedback',
                  'description': '<p>sends the delay back through itself\n                             in a loop that decreases in volume\n                             each time.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'lowPass',
                  'description': '<p>Cutoff frequency. Only frequencies\n                             below the lowPass will be part of the\n                             delay.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'delayTime': {
              'name': 'delayTime',
              'params': [
                {
                  'name': 'delayTime',
                  'description': '<p>Time (in seconds) of the delay</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'feedback': {
              'name': 'feedback',
              'params': [
                {
                  'name': 'feedback',
                  'description': '<p>0.0 to 1.0, or an object such as an\n                                Oscillator that can be used to\n                                modulate this param</p>\n',
                  'type': 'Number|Object'
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'filter': {
              'name': 'filter',
              'params': [
                {
                  'name': 'cutoffFreq',
                  'description': '<p>A lowpass filter will cut off any\n                            frequencies higher than the filter frequency.</p>\n',
                  'type': 'Number|Object'
                },
                {
                  'name': 'res',
                  'description': '<p>Resonance of the filter frequency\n                            cutoff, or an object (i.e. a p5.Oscillator)\n                            that can be used to modulate this parameter.\n                            High numbers (i.e. 15) will produce a resonance,\n                            low numbers (i.e. .2) will produce a slope.</p>\n',
                  'type': 'Number|Object'
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'setType': {
              'name': 'setType',
              'params': [
                {
                  'name': 'type',
                  'description': '<p>\'pingPong\' (1) or \'default\' (0)</p>\n',
                  'type': 'String|Number'
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'volume',
                  'description': '<p>amplitude between 0 and 1.0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>create a fade that lasts rampTime</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Delay',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.Delay',
              'module': 'p5.sound'
            }
          },
          'p5.Reverb': {
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>p5.sound / Web Audio object with a sound\n                         output.</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'seconds',
                  'description': '<p>Duration of the reverb, in seconds.\n                         Min: 0, Max: 10. Defaults to 3.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'decayRate',
                  'description': '<p>Percentage of decay with each echo.\n                          Min: 0, Max: 100. Defaults to 2.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'reverse',
                  'description': '<p>Play the reverb backwards or forwards.</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5.Reverb',
              'module': 'p5.sound'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'seconds',
                  'description': '<p>Duration of the reverb, in seconds.\n                         Min: 0, Max: 10. Defaults to 3.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'decayRate',
                  'description': '<p>Percentage of decay with each echo.\n                          Min: 0, Max: 100. Defaults to 2.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'reverse',
                  'description': '<p>Play the reverb backwards or forwards.</p>\n',
                  'type': 'Boolean',
                  'optional': true
                }
              ],
              'class': 'p5.Reverb',
              'module': 'p5.sound'
            },
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'volume',
                  'description': '<p>amplitude between 0 and 1.0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>create a fade that lasts rampTime</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Reverb',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Reverb',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.Reverb',
              'module': 'p5.sound'
            }
          },
          'p5.Convolver': {
            'convolverNode': {
              'name': 'convolverNode',
              'class': 'p5.Convolver',
              'module': 'p5.sound'
            },
            'impulses': {
              'name': 'impulses',
              'class': 'p5.Convolver',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>p5.sound / Web Audio object with a sound\n                         output.</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Convolver',
              'module': 'p5.sound'
            },
            'addImpulse': {
              'name': 'addImpulse',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>path to a sound file</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function (optional)</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function (optional)</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.Convolver',
              'module': 'p5.sound'
            },
            'resetImpulse': {
              'name': 'resetImpulse',
              'params': [
                {
                  'name': 'path',
                  'description': '<p>path to a sound file</p>\n',
                  'type': 'String'
                },
                {
                  'name': 'callback',
                  'description': '<p>function (optional)</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'errorCallback',
                  'description': '<p>function (optional)</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.Convolver',
              'module': 'p5.sound'
            },
            'toggleImpulse': {
              'name': 'toggleImpulse',
              'params': [
                {
                  'name': 'id',
                  'description': '<p>Identify the impulse by its original filename\n                          (String), or by its position in the\n                          <code>.impulses</code> Array (Number).</p>\n',
                  'type': 'String|Number'
                }
              ],
              'class': 'p5.Convolver',
              'module': 'p5.sound'
            }
          },
          'p5.Phrase': {
            'sequence': {
              'name': 'sequence',
              'class': 'p5.Phrase',
              'module': 'p5.sound'
            }
          },
          'p5.Part': {
            'setBPM': {
              'name': 'setBPM',
              'params': [
                {
                  'name': 'BPM',
                  'description': '<p>Beats Per Minute</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'getBPM': {
              'name': 'getBPM',
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'start': {
              'name': 'start',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'loop': {
              'name': 'loop',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'noLoop': {
              'name': 'noLoop',
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'pause': {
              'name': 'pause',
              'params': [
                {
                  'name': 'time',
                  'description': '<p>seconds from now</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'addPhrase': {
              'name': 'addPhrase',
              'params': [
                {
                  'name': 'phrase',
                  'description': '<p>reference to a p5.Phrase</p>\n',
                  'type': 'p5.Phrase'
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'removePhrase': {
              'name': 'removePhrase',
              'params': [
                {
                  'name': 'phraseName',
                  'description': '',
                  'type': 'String'
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'getPhrase': {
              'name': 'getPhrase',
              'params': [
                {
                  'name': 'phraseName',
                  'description': '',
                  'type': 'String'
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'replaceSequence': {
              'name': 'replaceSequence',
              'params': [
                {
                  'name': 'phraseName',
                  'description': '',
                  'type': 'String'
                },
                {
                  'name': 'sequence',
                  'description': '<p>Array of values to pass into the callback\n                          at each step of the phrase.</p>\n',
                  'type': 'Array'
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            },
            'onStep': {
              'name': 'onStep',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>The name of the callback\n                            you want to fire\n                            on every beat/tatum.</p>\n',
                  'type': 'Function'
                }
              ],
              'class': 'p5.Part',
              'module': 'p5.sound'
            }
          },
          'p5.Score': {
            'start': {
              'name': 'start',
              'class': 'p5.Score',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'class': 'p5.Score',
              'module': 'p5.sound'
            },
            'pause': {
              'name': 'pause',
              'class': 'p5.Score',
              'module': 'p5.sound'
            },
            'loop': {
              'name': 'loop',
              'class': 'p5.Score',
              'module': 'p5.sound'
            },
            'noLoop': {
              'name': 'noLoop',
              'class': 'p5.Score',
              'module': 'p5.sound'
            },
            'setBPM': {
              'name': 'setBPM',
              'params': [
                {
                  'name': 'BPM',
                  'description': '<p>Beats Per Minute</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Seconds from now</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Score',
              'module': 'p5.sound'
            }
          },
          'p5.SoundLoop': {
            'bpm': {
              'name': 'bpm',
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'timeSignature': {
              'name': 'timeSignature',
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'interval': {
              'name': 'interval',
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'iterations': {
              'name': 'iterations',
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'musicalTimeMode': {
              'name': 'musicalTimeMode',
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'maxIterations': {
              'name': 'maxIterations',
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'start': {
              'name': 'start',
              'params': [
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule a starting time</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'params': [
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule a stopping time</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'pause': {
              'name': 'pause',
              'params': [
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule a pausing time</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            },
            'syncedStart': {
              'name': 'syncedStart',
              'params': [
                {
                  'name': 'otherLoop',
                  'description': '<p>a p5.SoundLoop to sync with</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>Start the loops in sync after timeFromNow seconds</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.SoundLoop',
              'module': 'p5.sound'
            }
          },
          'p5.Compressor': {
            'compressor': {
              'name': 'compressor',
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>Sound source to be connected</p>\n',
                  'type': 'Object'
                },
                {
                  'name': 'attack',
                  'description': '<p>The amount of time (in seconds) to reduce the gain by 10dB,\n                           default = .003, range 0 - 1</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'knee',
                  'description': '<p>A decibel value representing the range above the\n                           threshold where the curve smoothly transitions to the "ratio" portion.\n                           default = 30, range 0 - 40</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'ratio',
                  'description': '<p>The amount of dB change in input for a 1 dB change in output\n                           default = 12, range 1 - 20</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'threshold',
                  'description': '<p>The decibel value above which the compression will start taking effect\n                           default = -24, range -100 - 0</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'release',
                  'description': '<p>The amount of time (in seconds) to increase the gain by 10dB\n                           default = .25, range 0 - 1</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'attack',
                  'description': '<p>The amount of time (in seconds) to reduce the gain by 10dB,\n                           default = .003, range 0 - 1</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'knee',
                  'description': '<p>A decibel value representing the range above the\n                           threshold where the curve smoothly transitions to the "ratio" portion.\n                           default = 30, range 0 - 40</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'ratio',
                  'description': '<p>The amount of dB change in input for a 1 dB change in output\n                           default = 12, range 1 - 20</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'threshold',
                  'description': '<p>The decibel value above which the compression will start taking effect\n                           default = -24, range -100 - 0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'release',
                  'description': '<p>The amount of time (in seconds) to increase the gain by 10dB\n                           default = .25, range 0 - 1</p>\n',
                  'type': 'Number'
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'attack': {
              'name': 'attack',
              'params': [
                {
                  'name': 'attack',
                  'description': '<p>Attack is the amount of time (in seconds) to reduce the gain by 10dB,\n                         default = .003, range 0 - 1</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'time',
                  'description': '<p>Assign time value to schedule the change in value</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'knee': {
              'name': 'knee',
              'params': [
                {
                  'name': 'knee',
                  'description': '<p>A decibel value representing the range above the\n                       threshold where the curve smoothly transitions to the "ratio" portion.\n                       default = 30, range 0 - 40</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'time',
                  'description': '<p>Assign time value to schedule the change in value</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'ratio': {
              'name': 'ratio',
              'params': [
                {
                  'name': 'ratio',
                  'description': '<p>The amount of dB change in input for a 1 dB change in output\n                           default = 12, range 1 - 20</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'time',
                  'description': '<p>Assign time value to schedule the change in value</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'threshold': {
              'name': 'threshold',
              'params': [
                {
                  'name': 'threshold',
                  'description': '<p>The decibel value above which the compression will start taking effect\n                           default = -24, range -100 - 0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'time',
                  'description': '<p>Assign time value to schedule the change in value</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'release': {
              'name': 'release',
              'params': [
                {
                  'name': 'release',
                  'description': '<p>The amount of time (in seconds) to increase the gain by 10dB\n                           default = .25, range 0 - 1</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'time',
                  'description': '<p>Assign time value to schedule the change in value</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            },
            'reduction': {
              'name': 'reduction',
              'class': 'p5.Compressor',
              'module': 'p5.sound'
            }
          },
          'p5.PeakDetect': {
            'isDetected': {
              'name': 'isDetected',
              'class': 'p5.PeakDetect',
              'module': 'p5.sound'
            },
            'update': {
              'name': 'update',
              'params': [
                {
                  'name': 'fftObject',
                  'description': '<p>A p5.FFT object</p>\n',
                  'type': 'p5.FFT'
                }
              ],
              'class': 'p5.PeakDetect',
              'module': 'p5.sound'
            },
            'onPeak': {
              'name': 'onPeak',
              'params': [
                {
                  'name': 'callback',
                  'description': '<p>Name of a function that will\n                            be called when a peak is\n                            detected.</p>\n',
                  'type': 'Function'
                },
                {
                  'name': 'val',
                  'description': '<p>Optional value to pass\n                            into the function when\n                            a peak is detected.</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.PeakDetect',
              'module': 'p5.sound'
            }
          },
          'p5.SoundRecorder': {
            'setInput': {
              'name': 'setInput',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>p5.sound object or a web audio unit\n                       that outputs sound</p>\n',
                  'type': 'Object',
                  'optional': true
                }
              ],
              'class': 'p5.SoundRecorder',
              'module': 'p5.sound'
            },
            'record': {
              'name': 'record',
              'params': [
                {
                  'name': 'soundFile',
                  'description': '<p>p5.SoundFile</p>\n',
                  'type': 'p5.SoundFile'
                },
                {
                  'name': 'duration',
                  'description': '<p>Time (in seconds)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'callback',
                  'description': '<p>The name of a function that will be\n                              called once the recording completes</p>\n',
                  'type': 'Function',
                  'optional': true
                }
              ],
              'class': 'p5.SoundRecorder',
              'module': 'p5.sound'
            },
            'stop': {
              'name': 'stop',
              'class': 'p5.SoundRecorder',
              'module': 'p5.sound'
            }
          },
          'p5.Distortion': {
            'WaveShaperNode': {
              'name': 'WaveShaperNode',
              'class': 'p5.Distortion',
              'module': 'p5.sound'
            },
            'process': {
              'name': 'process',
              'params': [
                {
                  'name': 'amount',
                  'description': '<p>Unbounded distortion amount.\n                               Normal values range from 0-1.</p>\n',
                  'type': 'Number',
                  'optional': true,
                  'optdefault': '0.25'
                },
                {
                  'name': 'oversample',
                  'description': '<p>\'none\', \'2x\', or \'4x\'.</p>\n',
                  'type': 'String',
                  'optional': true,
                  'optdefault': '\'none\''
                }
              ],
              'class': 'p5.Distortion',
              'module': 'p5.sound'
            },
            'set': {
              'name': 'set',
              'params': [
                {
                  'name': 'amount',
                  'description': '<p>Unbounded distortion amount.\n                               Normal values range from 0-1.</p>\n',
                  'type': 'Number',
                  'optional': true,
                  'optdefault': '0.25'
                },
                {
                  'name': 'oversample',
                  'description': '<p>\'none\', \'2x\', or \'4x\'.</p>\n',
                  'type': 'String',
                  'optional': true,
                  'optdefault': '\'none\''
                }
              ],
              'class': 'p5.Distortion',
              'module': 'p5.sound'
            },
            'getAmount': {
              'name': 'getAmount',
              'class': 'p5.Distortion',
              'module': 'p5.sound'
            },
            'getOversample': {
              'name': 'getOversample',
              'class': 'p5.Distortion',
              'module': 'p5.sound'
            }
          },
          'p5.Gain': {
            'setInput': {
              'name': 'setInput',
              'params': [
                {
                  'name': 'src',
                  'description': '<p>p5.sound / Web Audio object with a sound\n                         output.</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Gain',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '',
                  'type': 'Object'
                }
              ],
              'class': 'p5.Gain',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.Gain',
              'module': 'p5.sound'
            },
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'volume',
                  'description': '<p>amplitude between 0 and 1.0</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>create a fade that lasts rampTime</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'timeFromNow',
                  'description': '<p>schedule this event to happen\n                              seconds from now</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.Gain',
              'module': 'p5.sound'
            }
          },
          'p5.AudioVoice': {
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '',
                  'type': 'Object'
                }
              ],
              'class': 'p5.AudioVoice',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.AudioVoice',
              'module': 'p5.sound'
            }
          },
          'p5.MonoSynth': {
            'attack': {
              'name': 'attack',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'decay': {
              'name': 'decay',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'sustain': {
              'name': 'sustain',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'release': {
              'name': 'release',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'play': {
              'name': 'play',
              'params': [
                {
                  'name': 'note',
                  'description': '<p>the note you want to play, specified as a\n                               frequency in Hertz (Number) or as a midi\n                               value in Note/Octave format ("C4", "Eb3"...etc")\n                               See <a href = "https://github.com/Tonejs/Tone.js/wiki/Instruments">\n                               Tone</a>. Defaults to 440 hz.</p>\n',
                  'type': 'String | Number'
                },
                {
                  'name': 'velocity',
                  'description': '<p>velocity of the note to play (ranging from 0 to 1)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time from now (in seconds) at which to play</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'sustainTime',
                  'description': '<p>time to sustain before releasing the envelope. Defaults to 0.15 seconds.</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'triggerAttack': {
              'params': [
                {
                  'name': 'note',
                  'description': '<p>the note you want to play, specified as a\n                               frequency in Hertz (Number) or as a midi\n                               value in Note/Octave format ("C4", "Eb3"...etc")\n                               See <a href = "https://github.com/Tonejs/Tone.js/wiki/Instruments">\n                               Tone</a>. Defaults to 440 hz</p>\n',
                  'type': 'String | Number'
                },
                {
                  'name': 'velocity',
                  'description': '<p>velocity of the note to play (ranging from 0 to 1)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time from now (in seconds) at which to play</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'name': 'triggerAttack',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'triggerRelease': {
              'params': [
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time to trigger the release</p>\n',
                  'type': 'Number'
                }
              ],
              'name': 'triggerRelease',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'setADSR': {
              'name': 'setADSR',
              'params': [
                {
                  'name': 'attackTime',
                  'description': '<p>Time (in seconds before envelope\n                              reaches Attack Level</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'decayTime',
                  'description': '<p>Time (in seconds) before envelope\n                              reaches Decay/Sustain Level</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'susRatio',
                  'description': '<p>Ratio between attackLevel and releaseLevel, on a scale from 0 to 1,\n                              where 1.0 = attackLevel, 0.0 = releaseLevel.\n                              The susRatio determines the decayLevel and the level at which the\n                              sustain portion of the envelope will sustain.\n                              For example, if attackLevel is 0.4, releaseLevel is 0,\n                              and susAmt is 0.5, the decayLevel would be 0.2. If attackLevel is\n                              increased to 1.0 (using <code>setRange</code>),\n                              then decayLevel would increase proportionally, to become 0.5.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'releaseTime',
                  'description': '<p>Time in seconds from now (defaults to 0)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'amp': {
              'name': 'amp',
              'params': [
                {
                  'name': 'vol',
                  'description': '<p>desired volume</p>\n',
                  'type': 'Number'
                },
                {
                  'name': 'rampTime',
                  'description': '<p>Time to reach new volume</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>A p5.sound or Web Audio object</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            },
            'dispose': {
              'name': 'dispose',
              'class': 'p5.MonoSynth',
              'module': 'p5.sound'
            }
          },
          'p5.PolySynth': {
            'notes': {
              'name': 'notes',
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'polyvalue': {
              'name': 'polyvalue',
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'AudioVoice': {
              'name': 'AudioVoice',
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'play': {
              'name': 'play',
              'params': [
                {
                  'name': 'note',
                  'description': '<p>midi note to play (ranging from 0 to 127 - 60 being a middle C)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'velocity',
                  'description': '<p>velocity of the note to play (ranging from 0 to 1)</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time from now (in seconds) at which to play</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'sustainTime',
                  'description': '<p>time to sustain before releasing the envelope</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'noteADSR': {
              'name': 'noteADSR',
              'params': [
                {
                  'name': 'note',
                  'description': '<p>Midi note on which ADSR should be set.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'attackTime',
                  'description': '<p>Time (in seconds before envelope\n                              reaches Attack Level</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'decayTime',
                  'description': '<p>Time (in seconds) before envelope\n                              reaches Decay/Sustain Level</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'susRatio',
                  'description': '<p>Ratio between attackLevel and releaseLevel, on a scale from 0 to 1,\n                              where 1.0 = attackLevel, 0.0 = releaseLevel.\n                              The susRatio determines the decayLevel and the level at which the\n                              sustain portion of the envelope will sustain.\n                              For example, if attackLevel is 0.4, releaseLevel is 0,\n                              and susAmt is 0.5, the decayLevel would be 0.2. If attackLevel is\n                              increased to 1.0 (using <code>setRange</code>),\n                              then decayLevel would increase proportionally, to become 0.5.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'releaseTime',
                  'description': '<p>Time in seconds from now (defaults to 0)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'setADSR': {
              'name': 'setADSR',
              'params': [
                {
                  'name': 'attackTime',
                  'description': '<p>Time (in seconds before envelope\n                               reaches Attack Level</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'decayTime',
                  'description': '<p>Time (in seconds) before envelope\n                               reaches Decay/Sustain Level</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'susRatio',
                  'description': '<p>Ratio between attackLevel and releaseLevel, on a scale from 0 to 1,\n                               where 1.0 = attackLevel, 0.0 = releaseLevel.\n                               The susRatio determines the decayLevel and the level at which the\n                               sustain portion of the envelope will sustain.\n                               For example, if attackLevel is 0.4, releaseLevel is 0,\n                               and susAmt is 0.5, the decayLevel would be 0.2. If attackLevel is\n                               increased to 1.0 (using <code>setRange</code>),\n                               then decayLevel would increase proportionally, to become 0.5.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'releaseTime',
                  'description': '<p>Time in seconds from now (defaults to 0)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'noteAttack': {
              'name': 'noteAttack',
              'params': [
                {
                  'name': 'note',
                  'description': '<p>midi note on which attack should be triggered.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'velocity',
                  'description': '<p>velocity of the note to play (ranging from 0 to 1)/</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time from now (in seconds)</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'noteRelease': {
              'name': 'noteRelease',
              'params': [
                {
                  'name': 'note',
                  'description': '<p>midi note on which attack should be triggered.\n                                  If no value is provided, all notes will be released.</p>\n',
                  'type': 'Number',
                  'optional': true
                },
                {
                  'name': 'secondsFromNow',
                  'description': '<p>time to trigger the release</p>\n',
                  'type': 'Number',
                  'optional': true
                }
              ],
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'connect': {
              'name': 'connect',
              'params': [
                {
                  'name': 'unit',
                  'description': '<p>A p5.sound or Web Audio object</p>\n',
                  'type': 'Object'
                }
              ],
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'disconnect': {
              'name': 'disconnect',
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            },
            'dispose': {
              'name': 'dispose',
              'class': 'p5.PolySynth',
              'module': 'p5.sound'
            }
          }
        }
      },
      {
      }
    ],
    2: [
      function (_dereq_, module, exports) {
        function _arrayWithHoles(arr) {
          if (Array.isArray(arr)) return arr;
        }
        module.exports = _arrayWithHoles;
      },
      {
      }
    ],
    3: [
      function (_dereq_, module, exports) {
        function _arrayWithoutHoles(arr) {
          if (Array.isArray(arr)) {
            for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
              arr2[i] = arr[i];
            }
            return arr2;
          }
        }
        module.exports = _arrayWithoutHoles;
      },
      {
      }
    ],
    4: [
      function (_dereq_, module, exports) {
        function _assertThisInitialized(self) {
          if (self === void 0) {
            throw new ReferenceError('this hasn\'t been initialised - super() hasn\'t been called');
          }
          return self;
        }
        module.exports = _assertThisInitialized;
      },
      {
      }
    ],
    5: [
      function (_dereq_, module, exports) {
        function _classCallCheck(instance, Constructor) {
          if (!(instance instanceof Constructor)) {
            throw new TypeError('Cannot call a class as a function');
          }
        }
        module.exports = _classCallCheck;
      },
      {
      }
    ],
    6: [
      function (_dereq_, module, exports) {
        function _defineProperties(target, props) {
          for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ('value' in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
          }
        }
        function _createClass(Constructor, protoProps, staticProps) {
          if (protoProps) _defineProperties(Constructor.prototype, protoProps);
          if (staticProps) _defineProperties(Constructor, staticProps);
          return Constructor;
        }
        module.exports = _createClass;
      },
      {
      }
    ],
    7: [
      function (_dereq_, module, exports) {
        function _defineProperty(obj, key, value) {
          if (key in obj) {
            Object.defineProperty(obj, key, {
              value: value,
              enumerable: true,
              configurable: true,
              writable: true
            });
          } else {
            obj[key] = value;
          }
          return obj;
        }
        module.exports = _defineProperty;
      },
      {
      }
    ],
    8: [
      function (_dereq_, module, exports) {
        function _getPrototypeOf(o) {
          module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
            return o.__proto__ || Object.getPrototypeOf(o);
          };
          return _getPrototypeOf(o);
        }
        module.exports = _getPrototypeOf;
      },
      {
      }
    ],
    9: [
      function (_dereq_, module, exports) {
        var setPrototypeOf = _dereq_('./setPrototypeOf');
        function _inherits(subClass, superClass) {
          if (typeof superClass !== 'function' && superClass !== null) {
            throw new TypeError('Super expression must either be null or a function');
          }
          subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
              value: subClass,
              writable: true,
              configurable: true
            }
          });
          if (superClass) setPrototypeOf(subClass, superClass);
        }
        module.exports = _inherits;
      },
      {
        './setPrototypeOf': 16
      }
    ],
    10: [
      function (_dereq_, module, exports) {
        function _iterableToArray(iter) {
          if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === '[object Arguments]') return Array.from(iter);
        }
        module.exports = _iterableToArray;
      },
      {
      }
    ],
    11: [
      function (_dereq_, module, exports) {
        function _iterableToArrayLimit(arr, i) {
          var _arr = [
          ];
          var _n = true;
          var _d = false;
          var _e = undefined;
          try {
            for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
              _arr.push(_s.value);
              if (i && _arr.length === i) break;
            }
          } catch (err) {
            _d = true;
            _e = err;
          } finally {
            try {
              if (!_n && _i['return'] != null) _i['return']();
            } finally {
              if (_d) throw _e;
            }
          }
          return _arr;
        }
        module.exports = _iterableToArrayLimit;
      },
      {
      }
    ],
    12: [
      function (_dereq_, module, exports) {
        function _nonIterableRest() {
          throw new TypeError('Invalid attempt to destructure non-iterable instance');
        }
        module.exports = _nonIterableRest;
      },
      {
      }
    ],
    13: [
      function (_dereq_, module, exports) {
        function _nonIterableSpread() {
          throw new TypeError('Invalid attempt to spread non-iterable instance');
        }
        module.exports = _nonIterableSpread;
      },
      {
      }
    ],
    14: [
      function (_dereq_, module, exports) {
        var defineProperty = _dereq_('./defineProperty');
        function _objectSpread(target) {
          for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i] != null ? arguments[i] : {
            };
            var ownKeys = Object.keys(source);
            if (typeof Object.getOwnPropertySymbols === 'function') {
              ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
                return Object.getOwnPropertyDescriptor(source, sym).enumerable;
              }));
            }
            ownKeys.forEach(function (key) {
              defineProperty(target, key, source[key]);
            });
          }
          return target;
        }
        module.exports = _objectSpread;
      },
      {
        './defineProperty': 7
      }
    ],
    15: [
      function (_dereq_, module, exports) {
        var _typeof = _dereq_('../helpers/typeof');
        var assertThisInitialized = _dereq_('./assertThisInitialized');
        function _possibleConstructorReturn(self, call) {
          if (call && (_typeof(call) === 'object' || typeof call === 'function')) {
            return call;
          }
          return assertThisInitialized(self);
        }
        module.exports = _possibleConstructorReturn;
      },
      {
        '../helpers/typeof': 19,
        './assertThisInitialized': 4
      }
    ],
    16: [
      function (_dereq_, module, exports) {
        function _setPrototypeOf(o, p) {
          module.exports = _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
            o.__proto__ = p;
            return o;
          };
          return _setPrototypeOf(o, p);
        }
        module.exports = _setPrototypeOf;
      },
      {
      }
    ],
    17: [
      function (_dereq_, module, exports) {
        var arrayWithHoles = _dereq_('./arrayWithHoles');
        var iterableToArrayLimit = _dereq_('./iterableToArrayLimit');
        var nonIterableRest = _dereq_('./nonIterableRest');
        function _slicedToArray(arr, i) {
          return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || nonIterableRest();
        }
        module.exports = _slicedToArray;
      },
      {
        './arrayWithHoles': 2,
        './iterableToArrayLimit': 11,
        './nonIterableRest': 12
      }
    ],
    18: [
      function (_dereq_, module, exports) {
        var arrayWithoutHoles = _dereq_('./arrayWithoutHoles');
        var iterableToArray = _dereq_('./iterableToArray');
        var nonIterableSpread = _dereq_('./nonIterableSpread');
        function _toConsumableArray(arr) {
          return arrayWithoutHoles(arr) || iterableToArray(arr) || nonIterableSpread();
        }
        module.exports = _toConsumableArray;
      },
      {
        './arrayWithoutHoles': 3,
        './iterableToArray': 10,
        './nonIterableSpread': 13
      }
    ],
    19: [
      function (_dereq_, module, exports) {
        function _typeof2(obj) {
          if (typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol') {
            _typeof2 = function _typeof2(obj) {
              return typeof obj;
            };
          } else {
            _typeof2 = function _typeof2(obj) {
              return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype ? 'symbol' : typeof obj;
            };
          }
          return _typeof2(obj);
        }
        function _typeof(obj) {
          if (typeof Symbol === 'function' && _typeof2(Symbol.iterator) === 'symbol') {
            module.exports = _typeof = function _typeof(obj) {
              return _typeof2(obj);
            };
          } else {
            module.exports = _typeof = function _typeof(obj) {
              return obj && typeof Symbol === 'function' && obj.constructor === Symbol && obj !== Symbol.prototype ? 'symbol' : _typeof2(obj);
            };
          }
          return _typeof(obj);
        }
        module.exports = _typeof;
      },
      {
      }
    ],
    20: [
      function (_dereq_, module, exports) {
        'use strict';
        exports.byteLength = byteLength;
        exports.toByteArray = toByteArray;
        exports.fromByteArray = fromByteArray;
        var lookup = [
        ];
        var revLookup = [
        ];
        var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
        var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
        for (var i = 0, len = code.length; i < len; ++i) {
          lookup[i] = code[i];
          revLookup[code.charCodeAt(i)] = i;
        } // Support decoding URL-safe base64 strings, as Node.js does.
        // See: https://en.wikipedia.org/wiki/Base64#URL_applications

        revLookup['-'.charCodeAt(0)] = 62;
        revLookup['_'.charCodeAt(0)] = 63;
        function getLens(b64) {
          var len = b64.length;
          if (len % 4 > 0) {
            throw new Error('Invalid string. Length must be a multiple of 4');
          } // Trim off extra bytes after placeholder bytes are found
          // See: https://github.com/beatgammit/base64-js/issues/42

          var validLen = b64.indexOf('=');
          if (validLen === - 1) validLen = len;
          var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
          return [validLen,
          placeHoldersLen];
        } // base64 is 4/3 + up to two characters of the original data

        function byteLength(b64) {
          var lens = getLens(b64);
          var validLen = lens[0];
          var placeHoldersLen = lens[1];
          return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
        }
        function _byteLength(b64, validLen, placeHoldersLen) {
          return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
        }
        function toByteArray(b64) {
          var tmp;
          var lens = getLens(b64);
          var validLen = lens[0];
          var placeHoldersLen = lens[1];
          var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
          var curByte = 0; // if there are placeholders, only get up to the last complete 4 chars
          var len = placeHoldersLen > 0 ? validLen - 4 : validLen;
          var i;
          for (i = 0; i < len; i += 4) {
            tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
            arr[curByte++] = tmp >> 16 & 255;
            arr[curByte++] = tmp >> 8 & 255;
            arr[curByte++] = tmp & 255;
          }
          if (placeHoldersLen === 2) {
            tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
            arr[curByte++] = tmp & 255;
          }
          if (placeHoldersLen === 1) {
            tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
            arr[curByte++] = tmp >> 8 & 255;
            arr[curByte++] = tmp & 255;
          }
          return arr;
        }
        function tripletToBase64(num) {
          return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
        }
        function encodeChunk(uint8, start, end) {
          var tmp;
          var output = [
          ];
          for (var i = start; i < end; i += 3) {
            tmp = (uint8[i] << 16 & 16711680) + (uint8[i + 1] << 8 & 65280) + (uint8[i + 2] & 255);
            output.push(tripletToBase64(tmp));
          }
          return output.join('');
        }
        function fromByteArray(uint8) {
          var tmp;
          var len = uint8.length;
          var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
          var parts = [
          ];
          var maxChunkLength = 16383; // must be multiple of 3
          // go through the array every three bytes, we'll deal with trailing stuff later
          for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
            parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
          } // pad the end with zeros, but make sure to not forget the extra bytes

          if (extraBytes === 1) {
            tmp = uint8[len - 1];
            parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 63] + '==');
          } else if (extraBytes === 2) {
            tmp = (uint8[len - 2] << 8) + uint8[len - 1];
            parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + '=');
          }
          return parts.join('');
        }
      },
      {
      }
    ],
    21: [
      function (_dereq_, module, exports) {
      },
      {
      }
    ],
    22: [
      function (_dereq_, module, exports) {
        (function (Buffer) {
          /*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
          /* eslint-disable no-proto */
          'use strict';
          var base64 = _dereq_('base64-js');
          var ieee754 = _dereq_('ieee754');
          var customInspectSymbol = typeof Symbol === 'function' && typeof Symbol.for === 'function' ? Symbol.for('nodejs.util.inspect.custom') : null;
          exports.Buffer = Buffer;
          exports.SlowBuffer = SlowBuffer;
          exports.INSPECT_MAX_BYTES = 50;
          var K_MAX_LENGTH = 2147483647;
          exports.kMaxLength = K_MAX_LENGTH;
          /**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
          Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();
          if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' && typeof console.error === 'function') {
            console.error('This browser lacks typed array (Uint8Array) support which is required by ' + '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.');
          }
          function typedArraySupport() {
            // Can typed array instances can be augmented?
            try {
              var arr = new Uint8Array(1);
              var proto = {
                foo: function () {
                  return 42;
                }
              };
              Object.setPrototypeOf(proto, Uint8Array.prototype);
              Object.setPrototypeOf(arr, proto);
              return arr.foo() === 42;
            } catch (e) {
              return false;
            }
          }
          Object.defineProperty(Buffer.prototype, 'parent', {
            enumerable: true,
            get: function () {
              if (!Buffer.isBuffer(this)) return undefined;
              return this.buffer;
            }
          });
          Object.defineProperty(Buffer.prototype, 'offset', {
            enumerable: true,
            get: function () {
              if (!Buffer.isBuffer(this)) return undefined;
              return this.byteOffset;
            }
          });
          function createBuffer(length) {
            if (length > K_MAX_LENGTH) {
              throw new RangeError('The value "' + length + '" is invalid for option "size"');
            } // Return an augmented `Uint8Array` instance

            var buf = new Uint8Array(length);
            Object.setPrototypeOf(buf, Buffer.prototype);
            return buf;
          }          /**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

          function Buffer(arg, encodingOrOffset, length) {
            // Common case.
            if (typeof arg === 'number') {
              if (typeof encodingOrOffset === 'string') {
                throw new TypeError('The "string" argument must be of type string. Received type number');
              }
              return allocUnsafe(arg);
            }
            return from(arg, encodingOrOffset, length);
          } // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97

          if (typeof Symbol !== 'undefined' && Symbol.species != null && Buffer[Symbol.species] === Buffer) {
            Object.defineProperty(Buffer, Symbol.species, {
              value: null,
              configurable: true,
              enumerable: false,
              writable: false
            });
          }
          Buffer.poolSize = 8192; // not used by this implementation
          function from(value, encodingOrOffset, length) {
            if (typeof value === 'string') {
              return fromString(value, encodingOrOffset);
            }
            if (ArrayBuffer.isView(value)) {
              return fromArrayLike(value);
            }
            if (value == null) {
              throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + typeof value);
            }
            if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) {
              return fromArrayBuffer(value, encodingOrOffset, length);
            }
            if (typeof value === 'number') {
              throw new TypeError('The "value" argument must not be of type number. Received type number');
            }
            var valueOf = value.valueOf && value.valueOf();
            if (valueOf != null && valueOf !== value) {
              return Buffer.from(valueOf, encodingOrOffset, length);
            }
            var b = fromObject(value);
            if (b) return b;
            if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === 'function') {
              return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length);
            }
            throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + typeof value);
          }          /**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/

          Buffer.from = function (value, encodingOrOffset, length) {
            return from(value, encodingOrOffset, length);
          }; // Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
          // https://github.com/feross/buffer/pull/148
          Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype);
          Object.setPrototypeOf(Buffer, Uint8Array);
          function assertSize(size) {
            if (typeof size !== 'number') {
              throw new TypeError('"size" argument must be of type number');
            } else if (size < 0) {
              throw new RangeError('The value "' + size + '" is invalid for option "size"');
            }
          }
          function alloc(size, fill, encoding) {
            assertSize(size);
            if (size <= 0) {
              return createBuffer(size);
            }
            if (fill !== undefined) {
              // Only pay attention to encoding if it's a string. This
              // prevents accidentally sending in a number that would
              // be interpretted as a start offset.
              return typeof encoding === 'string' ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
            }
            return createBuffer(size);
          }          /**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/

          Buffer.alloc = function (size, fill, encoding) {
            return alloc(size, fill, encoding);
          };
          function allocUnsafe(size) {
            assertSize(size);
            return createBuffer(size < 0 ? 0 : checked(size) | 0);
          }          /**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */

          Buffer.allocUnsafe = function (size) {
            return allocUnsafe(size);
          };
          /**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
          Buffer.allocUnsafeSlow = function (size) {
            return allocUnsafe(size);
          };
          function fromString(string, encoding) {
            if (typeof encoding !== 'string' || encoding === '') {
              encoding = 'utf8';
            }
            if (!Buffer.isEncoding(encoding)) {
              throw new TypeError('Unknown encoding: ' + encoding);
            }
            var length = byteLength(string, encoding) | 0;
            var buf = createBuffer(length);
            var actual = buf.write(string, encoding);
            if (actual !== length) {
              // Writing a hex string, for example, that contains invalid characters will
              // cause everything after the first invalid character to be ignored. (e.g.
              // 'abxxcd' will be treated as 'ab')
              buf = buf.slice(0, actual);
            }
            return buf;
          }
          function fromArrayLike(array) {
            var length = array.length < 0 ? 0 : checked(array.length) | 0;
            var buf = createBuffer(length);
            for (var i = 0; i < length; i += 1) {
              buf[i] = array[i] & 255;
            }
            return buf;
          }
          function fromArrayBuffer(array, byteOffset, length) {
            if (byteOffset < 0 || array.byteLength < byteOffset) {
              throw new RangeError('"offset" is outside of buffer bounds');
            }
            if (array.byteLength < byteOffset + (length || 0)) {
              throw new RangeError('"length" is outside of buffer bounds');
            }
            var buf;
            if (byteOffset === undefined && length === undefined) {
              buf = new Uint8Array(array);
            } else if (length === undefined) {
              buf = new Uint8Array(array, byteOffset);
            } else {
              buf = new Uint8Array(array, byteOffset, length);
            } // Return an augmented `Uint8Array` instance

            Object.setPrototypeOf(buf, Buffer.prototype);
            return buf;
          }
          function fromObject(obj) {
            if (Buffer.isBuffer(obj)) {
              var len = checked(obj.length) | 0;
              var buf = createBuffer(len);
              if (buf.length === 0) {
                return buf;
              }
              obj.copy(buf, 0, 0, len);
              return buf;
            }
            if (obj.length !== undefined) {
              if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
                return createBuffer(0);
              }
              return fromArrayLike(obj);
            }
            if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
              return fromArrayLike(obj.data);
            }
          }
          function checked(length) {
            // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
            // length is NaN (which is otherwise coerced to zero.)
            if (length >= K_MAX_LENGTH) {
              throw new RangeError('Attempt to allocate Buffer larger than maximum ' + 'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes');
            }
            return length | 0;
          }
          function SlowBuffer(length) {
            if ( + length != length) {
              // eslint-disable-line eqeqeq
              length = 0;
            }
            return Buffer.alloc( + length);
          }
          Buffer.isBuffer = function isBuffer(b) {
            return b != null && b._isBuffer === true && b !== Buffer.prototype; // so Buffer.isBuffer(Buffer.prototype) will be false
          };
          Buffer.compare = function compare(a, b) {
            if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength);
            if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength);
            if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
              throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');
            }
            if (a === b) return 0;
            var x = a.length;
            var y = b.length;
            for (var i = 0, len = Math.min(x, y); i < len; ++i) {
              if (a[i] !== b[i]) {
                x = a[i];
                y = b[i];
                break;
              }
            }
            if (x < y) return - 1;
            if (y < x) return 1;
            return 0;
          };
          Buffer.isEncoding = function isEncoding(encoding) {
            switch (String(encoding).toLowerCase()) {
              case 'hex':
              case 'utf8':
              case 'utf-8':
              case 'ascii':
              case 'latin1':
              case 'binary':
              case 'base64':
              case 'ucs2':
              case 'ucs-2':
              case 'utf16le':
              case 'utf-16le':
                return true;
              default:
                return false;
            }
          };
          Buffer.concat = function concat(list, length) {
            if (!Array.isArray(list)) {
              throw new TypeError('"list" argument must be an Array of Buffers');
            }
            if (list.length === 0) {
              return Buffer.alloc(0);
            }
            var i;
            if (length === undefined) {
              length = 0;
              for (i = 0; i < list.length; ++i) {
                length += list[i].length;
              }
            }
            var buffer = Buffer.allocUnsafe(length);
            var pos = 0;
            for (i = 0; i < list.length; ++i) {
              var buf = list[i];
              if (isInstance(buf, Uint8Array)) {
                buf = Buffer.from(buf);
              }
              if (!Buffer.isBuffer(buf)) {
                throw new TypeError('"list" argument must be an Array of Buffers');
              }
              buf.copy(buffer, pos);
              pos += buf.length;
            }
            return buffer;
          };
          function byteLength(string, encoding) {
            if (Buffer.isBuffer(string)) {
              return string.length;
            }
            if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
              return string.byteLength;
            }
            if (typeof string !== 'string') {
              throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' + 'Received type ' + typeof string);
            }
            var len = string.length;
            var mustMatch = arguments.length > 2 && arguments[2] === true;
            if (!mustMatch && len === 0) return 0; // Use a for loop to avoid recursion
            var loweredCase = false;
            for (; ; ) {
              switch (encoding) {
                case 'ascii':
                case 'latin1':
                case 'binary':
                  return len;
                case 'utf8':
                case 'utf-8':
                  return utf8ToBytes(string).length;
                case 'ucs2':
                case 'ucs-2':
                case 'utf16le':
                case 'utf-16le':
                  return len * 2;
                case 'hex':
                  return len >>> 1;
                case 'base64':
                  return base64ToBytes(string).length;
                default:
                  if (loweredCase) {
                    return mustMatch ? - 1 : utf8ToBytes(string).length; // assume utf8
                  }
                  encoding = ('' + encoding).toLowerCase();
                  loweredCase = true;
              }
            }
          }
          Buffer.byteLength = byteLength;
          function slowToString(encoding, start, end) {
            var loweredCase = false; // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
            // property of a typed array.
            // This behaves neither like String nor Uint8Array in that we set start/end
            // to their upper/lower bounds if the value passed is out of range.
            // undefined is handled specially as per ECMA-262 6th Edition,
            // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
            if (start === undefined || start < 0) {
              start = 0;
            } // Return early if start > this.length. Done here to prevent potential uint32
            // coercion fail below.

            if (start > this.length) {
              return '';
            }
            if (end === undefined || end > this.length) {
              end = this.length;
            }
            if (end <= 0) {
              return '';
            } // Force coersion to uint32. This will also coerce falsey/NaN values to 0.

            end >>>= 0;
            start >>>= 0;
            if (end <= start) {
              return '';
            }
            if (!encoding) encoding = 'utf8';
            while (true) {
              switch (encoding) {
                case 'hex':
                  return hexSlice(this, start, end);
                case 'utf8':
                case 'utf-8':
                  return utf8Slice(this, start, end);
                case 'ascii':
                  return asciiSlice(this, start, end);
                case 'latin1':
                case 'binary':
                  return latin1Slice(this, start, end);
                case 'base64':
                  return base64Slice(this, start, end);
                case 'ucs2':
                case 'ucs-2':
                case 'utf16le':
                case 'utf-16le':
                  return utf16leSlice(this, start, end);
                default:
                  if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
                  encoding = (encoding + '').toLowerCase();
                  loweredCase = true;
              }
            }
          } // This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
          // to detect a Buffer instance. It's not possible to use `instanceof Buffer`
          // reliably in a browserify context because there could be multiple different
          // copies of the 'buffer' package in use. This method works even for Buffer
          // instances that were created from another copy of the `buffer` package.
          // See: https://github.com/feross/buffer/issues/154

          Buffer.prototype._isBuffer = true;
          function swap(b, n, m) {
            var i = b[n];
            b[n] = b[m];
            b[m] = i;
          }
          Buffer.prototype.swap16 = function swap16() {
            var len = this.length;
            if (len % 2 !== 0) {
              throw new RangeError('Buffer size must be a multiple of 16-bits');
            }
            for (var i = 0; i < len; i += 2) {
              swap(this, i, i + 1);
            }
            return this;
          };
          Buffer.prototype.swap32 = function swap32() {
            var len = this.length;
            if (len % 4 !== 0) {
              throw new RangeError('Buffer size must be a multiple of 32-bits');
            }
            for (var i = 0; i < len; i += 4) {
              swap(this, i, i + 3);
              swap(this, i + 1, i + 2);
            }
            return this;
          };
          Buffer.prototype.swap64 = function swap64() {
            var len = this.length;
            if (len % 8 !== 0) {
              throw new RangeError('Buffer size must be a multiple of 64-bits');
            }
            for (var i = 0; i < len; i += 8) {
              swap(this, i, i + 7);
              swap(this, i + 1, i + 6);
              swap(this, i + 2, i + 5);
              swap(this, i + 3, i + 4);
            }
            return this;
          };
          Buffer.prototype.toString = function toString() {
            var length = this.length;
            if (length === 0) return '';
            if (arguments.length === 0) return utf8Slice(this, 0, length);
            return slowToString.apply(this, arguments);
          };
          Buffer.prototype.toLocaleString = Buffer.prototype.toString;
          Buffer.prototype.equals = function equals(b) {
            if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer');
            if (this === b) return true;
            return Buffer.compare(this, b) === 0;
          };
          Buffer.prototype.inspect = function inspect() {
            var str = '';
            var max = exports.INSPECT_MAX_BYTES;
            str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim();
            if (this.length > max) str += ' ... ';
            return '<Buffer ' + str + '>';
          };
          if (customInspectSymbol) {
            Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect;
          }
          Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
            if (isInstance(target, Uint8Array)) {
              target = Buffer.from(target, target.offset, target.byteLength);
            }
            if (!Buffer.isBuffer(target)) {
              throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. ' + 'Received type ' + typeof target);
            }
            if (start === undefined) {
              start = 0;
            }
            if (end === undefined) {
              end = target ? target.length : 0;
            }
            if (thisStart === undefined) {
              thisStart = 0;
            }
            if (thisEnd === undefined) {
              thisEnd = this.length;
            }
            if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
              throw new RangeError('out of range index');
            }
            if (thisStart >= thisEnd && start >= end) {
              return 0;
            }
            if (thisStart >= thisEnd) {
              return - 1;
            }
            if (start >= end) {
              return 1;
            }
            start >>>= 0;
            end >>>= 0;
            thisStart >>>= 0;
            thisEnd >>>= 0;
            if (this === target) return 0;
            var x = thisEnd - thisStart;
            var y = end - start;
            var len = Math.min(x, y);
            var thisCopy = this.slice(thisStart, thisEnd);
            var targetCopy = target.slice(start, end);
            for (var i = 0; i < len; ++i) {
              if (thisCopy[i] !== targetCopy[i]) {
                x = thisCopy[i];
                y = targetCopy[i];
                break;
              }
            }
            if (x < y) return - 1;
            if (y < x) return 1;
            return 0;
          }; // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
          // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
          //
          // Arguments:
          // - buffer - a Buffer to search
          // - val - a string, Buffer, or number
          // - byteOffset - an index into `buffer`; will be clamped to an int32
          // - encoding - an optional encoding, relevant is val is a string
          // - dir - true for indexOf, false for lastIndexOf
          function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
            // Empty buffer means no match
            if (buffer.length === 0) return - 1; // Normalize byteOffset
            if (typeof byteOffset === 'string') {
              encoding = byteOffset;
              byteOffset = 0;
            } else if (byteOffset > 2147483647) {
              byteOffset = 2147483647;
            } else if (byteOffset < - 2147483648) {
              byteOffset = - 2147483648;
            }
            byteOffset = + byteOffset; // Coerce to Number.
            if (numberIsNaN(byteOffset)) {
              // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
              byteOffset = dir ? 0 : buffer.length - 1;
            } // Normalize byteOffset: negative offsets start from the end of the buffer

            if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
            if (byteOffset >= buffer.length) {
              if (dir) return - 1;
               else byteOffset = buffer.length - 1;
            } else if (byteOffset < 0) {
              if (dir) byteOffset = 0;
               else return - 1;
            } // Normalize val

            if (typeof val === 'string') {
              val = Buffer.from(val, encoding);
            } // Finally, search either indexOf (if dir is true) or lastIndexOf

            if (Buffer.isBuffer(val)) {
              // Special case: looking for empty string/buffer always fails
              if (val.length === 0) {
                return - 1;
              }
              return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
            } else if (typeof val === 'number') {
              val = val & 255; // Search for a byte value [0-255]
              if (typeof Uint8Array.prototype.indexOf === 'function') {
                if (dir) {
                  return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
                } else {
                  return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
                }
              }
              return arrayIndexOf(buffer, [
                val
              ], byteOffset, encoding, dir);
            }
            throw new TypeError('val must be string, number or Buffer');
          }
          function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
            var indexSize = 1;
            var arrLength = arr.length;
            var valLength = val.length;
            if (encoding !== undefined) {
              encoding = String(encoding).toLowerCase();
              if (encoding === 'ucs2' || encoding === 'ucs-2' || encoding === 'utf16le' || encoding === 'utf-16le') {
                if (arr.length < 2 || val.length < 2) {
                  return - 1;
                }
                indexSize = 2;
                arrLength /= 2;
                valLength /= 2;
                byteOffset /= 2;
              }
            }
            function read(buf, i) {
              if (indexSize === 1) {
                return buf[i];
              } else {
                return buf.readUInt16BE(i * indexSize);
              }
            }
            var i;
            if (dir) {
              var foundIndex = - 1;
              for (i = byteOffset; i < arrLength; i++) {
                if (read(arr, i) === read(val, foundIndex === - 1 ? 0 : i - foundIndex)) {
                  if (foundIndex === - 1) foundIndex = i;
                  if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
                } else {
                  if (foundIndex !== - 1) i -= i - foundIndex;
                  foundIndex = - 1;
                }
              }
            } else {
              if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
              for (i = byteOffset; i >= 0; i--) {
                var found = true;
                for (var j = 0; j < valLength; j++) {
                  if (read(arr, i + j) !== read(val, j)) {
                    found = false;
                    break;
                  }
                }
                if (found) return i;
              }
            }
            return - 1;
          }
          Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
            return this.indexOf(val, byteOffset, encoding) !== - 1;
          };
          Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
            return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
          };
          Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
            return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
          };
          function hexWrite(buf, string, offset, length) {
            offset = Number(offset) || 0;
            var remaining = buf.length - offset;
            if (!length) {
              length = remaining;
            } else {
              length = Number(length);
              if (length > remaining) {
                length = remaining;
              }
            }
            var strLen = string.length;
            if (length > strLen / 2) {
              length = strLen / 2;
            }
            for (var i = 0; i < length; ++i) {
              var parsed = parseInt(string.substr(i * 2, 2), 16);
              if (numberIsNaN(parsed)) return i;
              buf[offset + i] = parsed;
            }
            return i;
          }
          function utf8Write(buf, string, offset, length) {
            return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
          }
          function asciiWrite(buf, string, offset, length) {
            return blitBuffer(asciiToBytes(string), buf, offset, length);
          }
          function latin1Write(buf, string, offset, length) {
            return asciiWrite(buf, string, offset, length);
          }
          function base64Write(buf, string, offset, length) {
            return blitBuffer(base64ToBytes(string), buf, offset, length);
          }
          function ucs2Write(buf, string, offset, length) {
            return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
          }
          Buffer.prototype.write = function write(string, offset, length, encoding) {
            // Buffer#write(string)
            if (offset === undefined) {
              encoding = 'utf8';
              length = this.length;
              offset = 0; // Buffer#write(string, encoding)
            } else if (length === undefined && typeof offset === 'string') {
              encoding = offset;
              length = this.length;
              offset = 0; // Buffer#write(string, offset[, length][, encoding])
            } else if (isFinite(offset)) {
              offset = offset >>> 0;
              if (isFinite(length)) {
                length = length >>> 0;
                if (encoding === undefined) encoding = 'utf8';
              } else {
                encoding = length;
                length = undefined;
              }
            } else {
              throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');
            }
            var remaining = this.length - offset;
            if (length === undefined || length > remaining) length = remaining;
            if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
              throw new RangeError('Attempt to write outside buffer bounds');
            }
            if (!encoding) encoding = 'utf8';
            var loweredCase = false;
            for (; ; ) {
              switch (encoding) {
                case 'hex':
                  return hexWrite(this, string, offset, length);
                case 'utf8':
                case 'utf-8':
                  return utf8Write(this, string, offset, length);
                case 'ascii':
                  return asciiWrite(this, string, offset, length);
                case 'latin1':
                case 'binary':
                  return latin1Write(this, string, offset, length);
                case 'base64':
                  // Warning: maxLength not taken into account in base64Write
                  return base64Write(this, string, offset, length);
                case 'ucs2':
                case 'ucs-2':
                case 'utf16le':
                case 'utf-16le':
                  return ucs2Write(this, string, offset, length);
                default:
                  if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
                  encoding = ('' + encoding).toLowerCase();
                  loweredCase = true;
              }
            }
          };
          Buffer.prototype.toJSON = function toJSON() {
            return {
              type: 'Buffer',
              data: Array.prototype.slice.call(this._arr || this, 0)
            };
          };
          function base64Slice(buf, start, end) {
            if (start === 0 && end === buf.length) {
              return base64.fromByteArray(buf);
            } else {
              return base64.fromByteArray(buf.slice(start, end));
            }
          }
          function utf8Slice(buf, start, end) {
            end = Math.min(buf.length, end);
            var res = [
            ];
            var i = start;
            while (i < end) {
              var firstByte = buf[i];
              var codePoint = null;
              var bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
              if (i + bytesPerSequence <= end) {
                var secondByte,
                thirdByte,
                fourthByte,
                tempCodePoint;
                switch (bytesPerSequence) {
                  case 1:
                    if (firstByte < 128) {
                      codePoint = firstByte;
                    }
                    break;
                  case 2:
                    secondByte = buf[i + 1];
                    if ((secondByte & 192) === 128) {
                      tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
                      if (tempCodePoint > 127) {
                        codePoint = tempCodePoint;
                      }
                    }
                    break;
                  case 3:
                    secondByte = buf[i + 1];
                    thirdByte = buf[i + 2];
                    if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
                      tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
                      if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                        codePoint = tempCodePoint;
                      }
                    }
                    break;
                  case 4:
                    secondByte = buf[i + 1];
                    thirdByte = buf[i + 2];
                    fourthByte = buf[i + 3];
                    if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
                      tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
                      if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                        codePoint = tempCodePoint;
                      }
                    }
                }
              }
              if (codePoint === null) {
                // we did not generate a valid codePoint so insert a
                // replacement char (U+FFFD) and advance only 1 byte
                codePoint = 65533;
                bytesPerSequence = 1;
              } else if (codePoint > 65535) {
                // encode to utf16 (surrogate pair dance)
                codePoint -= 65536;
                res.push(codePoint >>> 10 & 1023 | 55296);
                codePoint = 56320 | codePoint & 1023;
              }
              res.push(codePoint);
              i += bytesPerSequence;
            }
            return decodeCodePointsArray(res);
          } // Based on http://stackoverflow.com/a/22747272/680742, the browser with
          // the lowest limit is Chrome, with 0x10000 args.
          // We go 1 magnitude less, for safety

          var MAX_ARGUMENTS_LENGTH = 4096;
          function decodeCodePointsArray(codePoints) {
            var len = codePoints.length;
            if (len <= MAX_ARGUMENTS_LENGTH) {
              return String.fromCharCode.apply(String, codePoints); // avoid extra slice()
            } // Decode in chunks to avoid "call stack size exceeded".

            var res = '';
            var i = 0;
            while (i < len) {
              res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
            }
            return res;
          }
          function asciiSlice(buf, start, end) {
            var ret = '';
            end = Math.min(buf.length, end);
            for (var i = start; i < end; ++i) {
              ret += String.fromCharCode(buf[i] & 127);
            }
            return ret;
          }
          function latin1Slice(buf, start, end) {
            var ret = '';
            end = Math.min(buf.length, end);
            for (var i = start; i < end; ++i) {
              ret += String.fromCharCode(buf[i]);
            }
            return ret;
          }
          function hexSlice(buf, start, end) {
            var len = buf.length;
            if (!start || start < 0) start = 0;
            if (!end || end < 0 || end > len) end = len;
            var out = '';
            for (var i = start; i < end; ++i) {
              out += hexSliceLookupTable[buf[i]];
            }
            return out;
          }
          function utf16leSlice(buf, start, end) {
            var bytes = buf.slice(start, end);
            var res = '';
            for (var i = 0; i < bytes.length; i += 2) {
              res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
            }
            return res;
          }
          Buffer.prototype.slice = function slice(start, end) {
            var len = this.length;
            start = ~~start;
            end = end === undefined ? len : ~~end;
            if (start < 0) {
              start += len;
              if (start < 0) start = 0;
            } else if (start > len) {
              start = len;
            }
            if (end < 0) {
              end += len;
              if (end < 0) end = 0;
            } else if (end > len) {
              end = len;
            }
            if (end < start) end = start;
            var newBuf = this.subarray(start, end); // Return an augmented `Uint8Array` instance
            Object.setPrototypeOf(newBuf, Buffer.prototype);
            return newBuf;
          };
          /*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
          function checkOffset(offset, ext, length) {
            if (offset % 1 !== 0 || offset < 0) throw new RangeError('offset is not uint');
            if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length');
          }
          Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) checkOffset(offset, byteLength, this.length);
            var val = this[offset];
            var mul = 1;
            var i = 0;
            while (++i < byteLength && (mul *= 256)) {
              val += this[offset + i] * mul;
            }
            return val;
          };
          Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) {
              checkOffset(offset, byteLength, this.length);
            }
            var val = this[offset + --byteLength];
            var mul = 1;
            while (byteLength > 0 && (mul *= 256)) {
              val += this[offset + --byteLength] * mul;
            }
            return val;
          };
          Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 1, this.length);
            return this[offset];
          };
          Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            return this[offset] | this[offset + 1] << 8;
          };
          Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            return this[offset] << 8 | this[offset + 1];
          };
          Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
          };
          Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
          };
          Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) checkOffset(offset, byteLength, this.length);
            var val = this[offset];
            var mul = 1;
            var i = 0;
            while (++i < byteLength && (mul *= 256)) {
              val += this[offset + i] * mul;
            }
            mul *= 128;
            if (val >= mul) val -= Math.pow(2, 8 * byteLength);
            return val;
          };
          Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) checkOffset(offset, byteLength, this.length);
            var i = byteLength;
            var mul = 1;
            var val = this[offset + --i];
            while (i > 0 && (mul *= 256)) {
              val += this[offset + --i] * mul;
            }
            mul *= 128;
            if (val >= mul) val -= Math.pow(2, 8 * byteLength);
            return val;
          };
          Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 1, this.length);
            if (!(this[offset] & 128)) return this[offset];
            return (255 - this[offset] + 1) * - 1;
          };
          Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            var val = this[offset] | this[offset + 1] << 8;
            return val & 32768 ? val | 4294901760 : val;
          };
          Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 2, this.length);
            var val = this[offset + 1] | this[offset] << 8;
            return val & 32768 ? val | 4294901760 : val;
          };
          Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
          };
          Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
          };
          Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return ieee754.read(this, offset, true, 23, 4);
          };
          Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 4, this.length);
            return ieee754.read(this, offset, false, 23, 4);
          };
          Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 8, this.length);
            return ieee754.read(this, offset, true, 52, 8);
          };
          Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
            offset = offset >>> 0;
            if (!noAssert) checkOffset(offset, 8, this.length);
            return ieee754.read(this, offset, false, 52, 8);
          };
          function checkInt(buf, value, offset, ext, max, min) {
            if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
            if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
            if (offset + ext > buf.length) throw new RangeError('Index out of range');
          }
          Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
            value = + value;
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) {
              var maxBytes = Math.pow(2, 8 * byteLength) - 1;
              checkInt(this, value, offset, byteLength, maxBytes, 0);
            }
            var mul = 1;
            var i = 0;
            this[offset] = value & 255;
            while (++i < byteLength && (mul *= 256)) {
              this[offset + i] = value / mul & 255;
            }
            return offset + byteLength;
          };
          Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
            value = + value;
            offset = offset >>> 0;
            byteLength = byteLength >>> 0;
            if (!noAssert) {
              var maxBytes = Math.pow(2, 8 * byteLength) - 1;
              checkInt(this, value, offset, byteLength, maxBytes, 0);
            }
            var i = byteLength - 1;
            var mul = 1;
            this[offset + i] = value & 255;
            while (--i >= 0 && (mul *= 256)) {
              this[offset + i] = value / mul & 255;
            }
            return offset + byteLength;
          };
          Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 1, 255, 0);
            this[offset] = value & 255;
            return offset + 1;
          };
          Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
            this[offset] = value & 255;
            this[offset + 1] = value >>> 8;
            return offset + 2;
          };
          Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 65535, 0);
            this[offset] = value >>> 8;
            this[offset + 1] = value & 255;
            return offset + 2;
          };
          Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
            this[offset + 3] = value >>> 24;
            this[offset + 2] = value >>> 16;
            this[offset + 1] = value >>> 8;
            this[offset] = value & 255;
            return offset + 4;
          };
          Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 4294967295, 0);
            this[offset] = value >>> 24;
            this[offset + 1] = value >>> 16;
            this[offset + 2] = value >>> 8;
            this[offset + 3] = value & 255;
            return offset + 4;
          };
          Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) {
              var limit = Math.pow(2, 8 * byteLength - 1);
              checkInt(this, value, offset, byteLength, limit - 1, - limit);
            }
            var i = 0;
            var mul = 1;
            var sub = 0;
            this[offset] = value & 255;
            while (++i < byteLength && (mul *= 256)) {
              if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
                sub = 1;
              }
              this[offset + i] = (value / mul >> 0) - sub & 255;
            }
            return offset + byteLength;
          };
          Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) {
              var limit = Math.pow(2, 8 * byteLength - 1);
              checkInt(this, value, offset, byteLength, limit - 1, - limit);
            }
            var i = byteLength - 1;
            var mul = 1;
            var sub = 0;
            this[offset + i] = value & 255;
            while (--i >= 0 && (mul *= 256)) {
              if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
                sub = 1;
              }
              this[offset + i] = (value / mul >> 0) - sub & 255;
            }
            return offset + byteLength;
          };
          Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 1, 127, - 128);
            if (value < 0) value = 255 + value + 1;
            this[offset] = value & 255;
            return offset + 1;
          };
          Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 32767, - 32768);
            this[offset] = value & 255;
            this[offset + 1] = value >>> 8;
            return offset + 2;
          };
          Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 2, 32767, - 32768);
            this[offset] = value >>> 8;
            this[offset + 1] = value & 255;
            return offset + 2;
          };
          Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 2147483647, - 2147483648);
            this[offset] = value & 255;
            this[offset + 1] = value >>> 8;
            this[offset + 2] = value >>> 16;
            this[offset + 3] = value >>> 24;
            return offset + 4;
          };
          Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) checkInt(this, value, offset, 4, 2147483647, - 2147483648);
            if (value < 0) value = 4294967295 + value + 1;
            this[offset] = value >>> 24;
            this[offset + 1] = value >>> 16;
            this[offset + 2] = value >>> 8;
            this[offset + 3] = value & 255;
            return offset + 4;
          };
          function checkIEEE754(buf, value, offset, ext, max, min) {
            if (offset + ext > buf.length) throw new RangeError('Index out of range');
            if (offset < 0) throw new RangeError('Index out of range');
          }
          function writeFloat(buf, value, offset, littleEndian, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) {
              checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, - 3.4028234663852886e+38);
            }
            ieee754.write(buf, value, offset, littleEndian, 23, 4);
            return offset + 4;
          }
          Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
            return writeFloat(this, value, offset, true, noAssert);
          };
          Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
            return writeFloat(this, value, offset, false, noAssert);
          };
          function writeDouble(buf, value, offset, littleEndian, noAssert) {
            value = + value;
            offset = offset >>> 0;
            if (!noAssert) {
              checkIEEE754(buf, value, offset, 8, 1.7976931348623157e+308, - 1.7976931348623157e+308);
            }
            ieee754.write(buf, value, offset, littleEndian, 52, 8);
            return offset + 8;
          }
          Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
            return writeDouble(this, value, offset, true, noAssert);
          };
          Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
            return writeDouble(this, value, offset, false, noAssert);
          }; // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
          Buffer.prototype.copy = function copy(target, targetStart, start, end) {
            if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer');
            if (!start) start = 0;
            if (!end && end !== 0) end = this.length;
            if (targetStart >= target.length) targetStart = target.length;
            if (!targetStart) targetStart = 0;
            if (end > 0 && end < start) end = start; // Copy 0 bytes; we're done
            if (end === start) return 0;
            if (target.length === 0 || this.length === 0) return 0; // Fatal error conditions
            if (targetStart < 0) {
              throw new RangeError('targetStart out of bounds');
            }
            if (start < 0 || start >= this.length) throw new RangeError('Index out of range');
            if (end < 0) throw new RangeError('sourceEnd out of bounds'); // Are we oob?
            if (end > this.length) end = this.length;
            if (target.length - targetStart < end - start) {
              end = target.length - targetStart + start;
            }
            var len = end - start;
            if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
              // Use built-in when available, missing from IE11
              this.copyWithin(targetStart, start, end);
            } else if (this === target && start < targetStart && targetStart < end) {
              // descending copy from end
              for (var i = len - 1; i >= 0; --i) {
                target[i + targetStart] = this[i + start];
              }
            } else {
              Uint8Array.prototype.set.call(target, this.subarray(start, end), targetStart);
            }
            return len;
          }; // Usage:
          //    buffer.fill(number[, offset[, end]])
          //    buffer.fill(buffer[, offset[, end]])
          //    buffer.fill(string[, offset[, end]][, encoding])
          Buffer.prototype.fill = function fill(val, start, end, encoding) {
            // Handle string cases:
            if (typeof val === 'string') {
              if (typeof start === 'string') {
                encoding = start;
                start = 0;
                end = this.length;
              } else if (typeof end === 'string') {
                encoding = end;
                end = this.length;
              }
              if (encoding !== undefined && typeof encoding !== 'string') {
                throw new TypeError('encoding must be a string');
              }
              if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
                throw new TypeError('Unknown encoding: ' + encoding);
              }
              if (val.length === 1) {
                var code = val.charCodeAt(0);
                if (encoding === 'utf8' && code < 128 || encoding === 'latin1') {
                  // Fast path: If `val` fits into a single byte, use that numeric value.
                  val = code;
                }
              }
            } else if (typeof val === 'number') {
              val = val & 255;
            } else if (typeof val === 'boolean') {
              val = Number(val);
            } // Invalid ranges are not set to a default, so can range check early.

            if (start < 0 || this.length < start || this.length < end) {
              throw new RangeError('Out of range index');
            }
            if (end <= start) {
              return this;
            }
            start = start >>> 0;
            end = end === undefined ? this.length : end >>> 0;
            if (!val) val = 0;
            var i;
            if (typeof val === 'number') {
              for (i = start; i < end; ++i) {
                this[i] = val;
              }
            } else {
              var bytes = Buffer.isBuffer(val) ? val : Buffer.from(val, encoding);
              var len = bytes.length;
              if (len === 0) {
                throw new TypeError('The value "' + val + '" is invalid for argument "value"');
              }
              for (i = 0; i < end - start; ++i) {
                this[i + start] = bytes[i % len];
              }
            }
            return this;
          }; // HELPER FUNCTIONS
          // ================
          var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
          function base64clean(str) {
            // Node takes equal signs as end of the Base64 encoding
            str = str.split('=') [0]; // Node strips out invalid characters like \n and \t from the string, base64-js does not
            str = str.trim().replace(INVALID_BASE64_RE, ''); // Node converts strings with length < 2 to ''
            if (str.length < 2) return ''; // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
            while (str.length % 4 !== 0) {
              str = str + '=';
            }
            return str;
          }
          function utf8ToBytes(string, units) {
            units = units || Infinity;
            var codePoint;
            var length = string.length;
            var leadSurrogate = null;
            var bytes = [
            ];
            for (var i = 0; i < length; ++i) {
              codePoint = string.charCodeAt(i); // is surrogate component
              if (codePoint > 55295 && codePoint < 57344) {
                // last char was a lead
                if (!leadSurrogate) {
                  // no lead yet
                  if (codePoint > 56319) {
                    // unexpected trail
                    if ((units -= 3) > - 1) bytes.push(239, 191, 189);
                    continue;
                  } else if (i + 1 === length) {
                    // unpaired lead
                    if ((units -= 3) > - 1) bytes.push(239, 191, 189);
                    continue;
                  } // valid lead

                  leadSurrogate = codePoint;
                  continue;
                } // 2 leads in a row

                if (codePoint < 56320) {
                  if ((units -= 3) > - 1) bytes.push(239, 191, 189);
                  leadSurrogate = codePoint;
                  continue;
                } // valid surrogate pair

                codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
              } else if (leadSurrogate) {
                // valid bmp char, but last char was a lead
                if ((units -= 3) > - 1) bytes.push(239, 191, 189);
              }
              leadSurrogate = null; // encode utf8
              if (codePoint < 128) {
                if ((units -= 1) < 0) break;
                bytes.push(codePoint);
              } else if (codePoint < 2048) {
                if ((units -= 2) < 0) break;
                bytes.push(codePoint >> 6 | 192, codePoint & 63 | 128);
              } else if (codePoint < 65536) {
                if ((units -= 3) < 0) break;
                bytes.push(codePoint >> 12 | 224, codePoint >> 6 & 63 | 128, codePoint & 63 | 128);
              } else if (codePoint < 1114112) {
                if ((units -= 4) < 0) break;
                bytes.push(codePoint >> 18 | 240, codePoint >> 12 & 63 | 128, codePoint >> 6 & 63 | 128, codePoint & 63 | 128);
              } else {
                throw new Error('Invalid code point');
              }
            }
            return bytes;
          }
          function asciiToBytes(str) {
            var byteArray = [
            ];
            for (var i = 0; i < str.length; ++i) {
              // Node's code seems to be doing this and not & 0x7F..
              byteArray.push(str.charCodeAt(i) & 255);
            }
            return byteArray;
          }
          function utf16leToBytes(str, units) {
            var c,
            hi,
            lo;
            var byteArray = [
            ];
            for (var i = 0; i < str.length; ++i) {
              if ((units -= 2) < 0) break;
              c = str.charCodeAt(i);
              hi = c >> 8;
              lo = c % 256;
              byteArray.push(lo);
              byteArray.push(hi);
            }
            return byteArray;
          }
          function base64ToBytes(str) {
            return base64.toByteArray(base64clean(str));
          }
          function blitBuffer(src, dst, offset, length) {
            for (var i = 0; i < length; ++i) {
              if (i + offset >= dst.length || i >= src.length) break;
              dst[i + offset] = src[i];
            }
            return i;
          } // ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
          // the `instanceof` check but they should be treated as of that type.
          // See: https://github.com/feross/buffer/issues/166

          function isInstance(obj, type) {
            return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
          }
          function numberIsNaN(obj) {
            // For IE11 support
            return obj !== obj; // eslint-disable-line no-self-compare
          } // Create lookup table for `toString('hex')`
          // See: https://github.com/feross/buffer/issues/219

          var hexSliceLookupTable = function () {
            var alphabet = '0123456789abcdef';
            var table = new Array(256);
            for (var i = 0; i < 16; ++i) {
              var i16 = i * 16;
              for (var j = 0; j < 16; ++j) {
                table[i16 + j] = alphabet[i] + alphabet[j];
              }
            }
            return table;
          }();
        }).call(this, _dereq_('buffer').Buffer)
      },
      {
        'base64-js': 20,
        'buffer': 22,
        'ieee754': 266
      }
    ],
    23: [
      function (_dereq_, module, exports) {
        module.exports = function (it) {
          if (typeof it != 'function') {
            throw TypeError(String(it) + ' is not a function');
          }
          return it;
        };
      },
      {
      }
    ],
    24: [
      function (_dereq_, module, exports) {
        var isObject = _dereq_('../internals/is-object');
        module.exports = function (it) {
          if (!isObject(it) && it !== null) {
            throw TypeError('Can\'t set ' + String(it) + ' as a prototype');
          }
          return it;
        };
      },
      {
        '../internals/is-object': 92
      }
    ],
    25: [
      function (_dereq_, module, exports) {
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var create = _dereq_('../internals/object-create');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var UNSCOPABLES = wellKnownSymbol('unscopables');
        var ArrayPrototype = Array.prototype; // Array.prototype[@@unscopables]
        // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables
        if (ArrayPrototype[UNSCOPABLES] == undefined) {
          definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
            configurable: true,
            value: create(null)
          });
        } // add a key to Array.prototype[@@unscopables]

        module.exports = function (key) {
          ArrayPrototype[UNSCOPABLES][key] = true;
        };
      },
      {
        '../internals/object-create': 108,
        '../internals/object-define-property': 110,
        '../internals/well-known-symbol': 166
      }
    ],
    26: [
      function (_dereq_, module, exports) {
        'use strict';
        var charAt = _dereq_('../internals/string-multibyte').charAt; // `AdvanceStringIndex` abstract operation
        // https://tc39.github.io/ecma262/#sec-advancestringindex
        module.exports = function (S, index, unicode) {
          return index + (unicode ? charAt(S, index).length : 1);
        };
      },
      {
        '../internals/string-multibyte': 141
      }
    ],
    27: [
      function (_dereq_, module, exports) {
        module.exports = function (it, Constructor, name) {
          if (!(it instanceof Constructor)) {
            throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
          }
          return it;
        };
      },
      {
      }
    ],
    28: [
      function (_dereq_, module, exports) {
        var isObject = _dereq_('../internals/is-object');
        module.exports = function (it) {
          if (!isObject(it)) {
            throw TypeError(String(it) + ' is not an object');
          }
          return it;
        };
      },
      {
        '../internals/is-object': 92
      }
    ],
    29: [
      function (_dereq_, module, exports) {
        module.exports = typeof ArrayBuffer !== 'undefined' && typeof DataView !== 'undefined';
      },
      {
      }
    ],
    30: [
      function (_dereq_, module, exports) {
        'use strict';
        var NATIVE_ARRAY_BUFFER = _dereq_('../internals/array-buffer-native');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var global = _dereq_('../internals/global');
        var isObject = _dereq_('../internals/is-object');
        var has = _dereq_('../internals/has');
        var classof = _dereq_('../internals/classof');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var redefine = _dereq_('../internals/redefine');
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var getPrototypeOf = _dereq_('../internals/object-get-prototype-of');
        var setPrototypeOf = _dereq_('../internals/object-set-prototype-of');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var uid = _dereq_('../internals/uid');
        var Int8Array = global.Int8Array;
        var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
        var Uint8ClampedArray = global.Uint8ClampedArray;
        var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
        var TypedArray = Int8Array && getPrototypeOf(Int8Array);
        var TypedArrayPrototype = Int8ArrayPrototype && getPrototypeOf(Int8ArrayPrototype);
        var ObjectPrototype = Object.prototype;
        var isPrototypeOf = ObjectPrototype.isPrototypeOf;
        var TO_STRING_TAG = wellKnownSymbol('toStringTag');
        var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG'); // Fixing native typed arrays in Opera Presto crashes the browser, see #595
        var NATIVE_ARRAY_BUFFER_VIEWS = NATIVE_ARRAY_BUFFER && !!setPrototypeOf && classof(global.opera) !== 'Opera';
        var TYPED_ARRAY_TAG_REQIRED = false;
        var NAME;
        var TypedArrayConstructorsList = {
          Int8Array: 1,
          Uint8Array: 1,
          Uint8ClampedArray: 1,
          Int16Array: 2,
          Uint16Array: 2,
          Int32Array: 4,
          Uint32Array: 4,
          Float32Array: 4,
          Float64Array: 8
        };
        var isView = function isView(it) {
          var klass = classof(it);
          return klass === 'DataView' || has(TypedArrayConstructorsList, klass);
        };
        var isTypedArray = function (it) {
          return isObject(it) && has(TypedArrayConstructorsList, classof(it));
        };
        var aTypedArray = function (it) {
          if (isTypedArray(it)) return it;
          throw TypeError('Target is not a typed array');
        };
        var aTypedArrayConstructor = function (C) {
          if (setPrototypeOf) {
            if (isPrototypeOf.call(TypedArray, C)) return C;
          } else for (var ARRAY in TypedArrayConstructorsList) if (has(TypedArrayConstructorsList, NAME)) {
            var TypedArrayConstructor = global[ARRAY];
            if (TypedArrayConstructor && (C === TypedArrayConstructor || isPrototypeOf.call(TypedArrayConstructor, C))) {
              return C;
            }
          }
          throw TypeError('Target is not a typed array constructor');
        };
        var exportTypedArrayMethod = function (KEY, property, forced) {
          if (!DESCRIPTORS) return;
          if (forced) for (var ARRAY in TypedArrayConstructorsList) {
            var TypedArrayConstructor = global[ARRAY];
            if (TypedArrayConstructor && has(TypedArrayConstructor.prototype, KEY)) {
              delete TypedArrayConstructor.prototype[KEY];
            }
          }
          if (!TypedArrayPrototype[KEY] || forced) {
            redefine(TypedArrayPrototype, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property);
          }
        };
        var exportTypedArrayStaticMethod = function (KEY, property, forced) {
          var ARRAY,
          TypedArrayConstructor;
          if (!DESCRIPTORS) return;
          if (setPrototypeOf) {
            if (forced) for (ARRAY in TypedArrayConstructorsList) {
              TypedArrayConstructor = global[ARRAY];
              if (TypedArrayConstructor && has(TypedArrayConstructor, KEY)) {
                delete TypedArrayConstructor[KEY];
              }
            }
            if (!TypedArray[KEY] || forced) {
              // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
              try {
                return redefine(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8Array[KEY] || property);
              } catch (error) {
                /* empty */
              }
            } else return;
          }
          for (ARRAY in TypedArrayConstructorsList) {
            TypedArrayConstructor = global[ARRAY];
            if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
              redefine(TypedArrayConstructor, KEY, property);
            }
          }
        };
        for (NAME in TypedArrayConstructorsList) {
          if (!global[NAME]) NATIVE_ARRAY_BUFFER_VIEWS = false;
        } // WebKit bug - typed arrays constructors prototype is Object.prototype

        if (!NATIVE_ARRAY_BUFFER_VIEWS || typeof TypedArray != 'function' || TypedArray === Function.prototype) {
          // eslint-disable-next-line no-shadow
          TypedArray = function TypedArray() {
            throw TypeError('Incorrect invocation');
          };
          if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
            if (global[NAME]) setPrototypeOf(global[NAME], TypedArray);
          }
        }
        if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
          TypedArrayPrototype = TypedArray.prototype;
          if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
            if (global[NAME]) setPrototypeOf(global[NAME].prototype, TypedArrayPrototype);
          }
        } // WebKit bug - one more object in Uint8ClampedArray prototype chain

        if (NATIVE_ARRAY_BUFFER_VIEWS && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
          setPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
        }
        if (DESCRIPTORS && !has(TypedArrayPrototype, TO_STRING_TAG)) {
          TYPED_ARRAY_TAG_REQIRED = true;
          defineProperty(TypedArrayPrototype, TO_STRING_TAG, {
            get: function () {
              return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
            }
          });
          for (NAME in TypedArrayConstructorsList) if (global[NAME]) {
            createNonEnumerableProperty(global[NAME], TYPED_ARRAY_TAG, NAME);
          }
        }
        module.exports = {
          NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
          TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQIRED && TYPED_ARRAY_TAG,
          aTypedArray: aTypedArray,
          aTypedArrayConstructor: aTypedArrayConstructor,
          exportTypedArrayMethod: exportTypedArrayMethod,
          exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
          isView: isView,
          isTypedArray: isTypedArray,
          TypedArray: TypedArray,
          TypedArrayPrototype: TypedArrayPrototype
        };
      },
      {
        '../internals/array-buffer-native': 29,
        '../internals/classof': 47,
        '../internals/create-non-enumerable-property': 56,
        '../internals/descriptors': 61,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/is-object': 92,
        '../internals/object-define-property': 110,
        '../internals/object-get-prototype-of': 115,
        '../internals/object-set-prototype-of': 119,
        '../internals/redefine': 126,
        '../internals/uid': 163,
        '../internals/well-known-symbol': 166
      }
    ],
    31: [
      function (_dereq_, module, exports) {
        'use strict';
        var global = _dereq_('../internals/global');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var NATIVE_ARRAY_BUFFER = _dereq_('../internals/array-buffer-native');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var redefineAll = _dereq_('../internals/redefine-all');
        var fails = _dereq_('../internals/fails');
        var anInstance = _dereq_('../internals/an-instance');
        var toInteger = _dereq_('../internals/to-integer');
        var toLength = _dereq_('../internals/to-length');
        var toIndex = _dereq_('../internals/to-index');
        var IEEE754 = _dereq_('../internals/ieee754');
        var getPrototypeOf = _dereq_('../internals/object-get-prototype-of');
        var setPrototypeOf = _dereq_('../internals/object-set-prototype-of');
        var getOwnPropertyNames = _dereq_('../internals/object-get-own-property-names').f;
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var arrayFill = _dereq_('../internals/array-fill');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var getInternalState = InternalStateModule.get;
        var setInternalState = InternalStateModule.set;
        var ARRAY_BUFFER = 'ArrayBuffer';
        var DATA_VIEW = 'DataView';
        var PROTOTYPE = 'prototype';
        var WRONG_LENGTH = 'Wrong length';
        var WRONG_INDEX = 'Wrong index';
        var NativeArrayBuffer = global[ARRAY_BUFFER];
        var $ArrayBuffer = NativeArrayBuffer;
        var $DataView = global[DATA_VIEW];
        var $DataViewPrototype = $DataView && $DataView[PROTOTYPE];
        var ObjectPrototype = Object.prototype;
        var RangeError = global.RangeError;
        var packIEEE754 = IEEE754.pack;
        var unpackIEEE754 = IEEE754.unpack;
        var packInt8 = function (number) {
          return [number & 255];
        };
        var packInt16 = function (number) {
          return [number & 255,
          number >> 8 & 255];
        };
        var packInt32 = function (number) {
          return [number & 255,
          number >> 8 & 255,
          number >> 16 & 255,
          number >> 24 & 255];
        };
        var unpackInt32 = function (buffer) {
          return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
        };
        var packFloat32 = function (number) {
          return packIEEE754(number, 23, 4);
        };
        var packFloat64 = function (number) {
          return packIEEE754(number, 52, 8);
        };
        var addGetter = function (Constructor, key) {
          defineProperty(Constructor[PROTOTYPE], key, {
            get: function () {
              return getInternalState(this) [key];
            }
          });
        };
        var get = function (view, count, index, isLittleEndian) {
          var intIndex = toIndex(index);
          var store = getInternalState(view);
          if (intIndex + count > store.byteLength) throw RangeError(WRONG_INDEX);
          var bytes = getInternalState(store.buffer).bytes;
          var start = intIndex + store.byteOffset;
          var pack = bytes.slice(start, start + count);
          return isLittleEndian ? pack : pack.reverse();
        };
        var set = function (view, count, index, conversion, value, isLittleEndian) {
          var intIndex = toIndex(index);
          var store = getInternalState(view);
          if (intIndex + count > store.byteLength) throw RangeError(WRONG_INDEX);
          var bytes = getInternalState(store.buffer).bytes;
          var start = intIndex + store.byteOffset;
          var pack = conversion( + value);
          for (var i = 0; i < count; i++) bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
        };
        if (!NATIVE_ARRAY_BUFFER) {
          $ArrayBuffer = function ArrayBuffer(length) {
            anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
            var byteLength = toIndex(length);
            setInternalState(this, {
              bytes: arrayFill.call(new Array(byteLength), 0),
              byteLength: byteLength
            });
            if (!DESCRIPTORS) this.byteLength = byteLength;
          };
          $DataView = function DataView(buffer, byteOffset, byteLength) {
            anInstance(this, $DataView, DATA_VIEW);
            anInstance(buffer, $ArrayBuffer, DATA_VIEW);
            var bufferLength = getInternalState(buffer).byteLength;
            var offset = toInteger(byteOffset);
            if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset');
            byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
            if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);
            setInternalState(this, {
              buffer: buffer,
              byteLength: byteLength,
              byteOffset: offset
            });
            if (!DESCRIPTORS) {
              this.buffer = buffer;
              this.byteLength = byteLength;
              this.byteOffset = offset;
            }
          };
          if (DESCRIPTORS) {
            addGetter($ArrayBuffer, 'byteLength');
            addGetter($DataView, 'buffer');
            addGetter($DataView, 'byteLength');
            addGetter($DataView, 'byteOffset');
          }
          redefineAll($DataView[PROTOTYPE], {
            getInt8: function getInt8(byteOffset) {
              return get(this, 1, byteOffset) [0] << 24 >> 24;
            },
            getUint8: function getUint8(byteOffset) {
              return get(this, 1, byteOffset) [0];
            },
            getInt16: function getInt16(byteOffset            /* , littleEndian */
            ) {
              var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
              return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
            },
            getUint16: function getUint16(byteOffset            /* , littleEndian */
            ) {
              var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
              return bytes[1] << 8 | bytes[0];
            },
            getInt32: function getInt32(byteOffset            /* , littleEndian */
            ) {
              return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
            },
            getUint32: function getUint32(byteOffset            /* , littleEndian */
            ) {
              return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
            },
            getFloat32: function getFloat32(byteOffset            /* , littleEndian */
            ) {
              return unpackIEEE754(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
            },
            getFloat64: function getFloat64(byteOffset            /* , littleEndian */
            ) {
              return unpackIEEE754(get(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
            },
            setInt8: function setInt8(byteOffset, value) {
              set(this, 1, byteOffset, packInt8, value);
            },
            setUint8: function setUint8(byteOffset, value) {
              set(this, 1, byteOffset, packInt8, value);
            },
            setInt16: function setInt16(byteOffset, value            /* , littleEndian */
            ) {
              set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
            },
            setUint16: function setUint16(byteOffset, value            /* , littleEndian */
            ) {
              set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
            },
            setInt32: function setInt32(byteOffset, value            /* , littleEndian */
            ) {
              set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
            },
            setUint32: function setUint32(byteOffset, value            /* , littleEndian */
            ) {
              set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
            },
            setFloat32: function setFloat32(byteOffset, value            /* , littleEndian */
            ) {
              set(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
            },
            setFloat64: function setFloat64(byteOffset, value            /* , littleEndian */
            ) {
              set(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
            }
          });
        } else {
          if (!fails(function () {
            NativeArrayBuffer(1);
          }) || !fails(function () {
            new NativeArrayBuffer( - 1); // eslint-disable-line no-new
          }) || fails(function () {
            new NativeArrayBuffer(); // eslint-disable-line no-new
            new NativeArrayBuffer(1.5); // eslint-disable-line no-new
            new NativeArrayBuffer(NaN); // eslint-disable-line no-new
            return NativeArrayBuffer.name != ARRAY_BUFFER;
          })) {
            $ArrayBuffer = function ArrayBuffer(length) {
              anInstance(this, $ArrayBuffer);
              return new NativeArrayBuffer(toIndex(length));
            };
            var ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE] = NativeArrayBuffer[PROTOTYPE];
            for (var keys = getOwnPropertyNames(NativeArrayBuffer), j = 0, key; keys.length > j; ) {
              if (!((key = keys[j++]) in $ArrayBuffer)) {
                createNonEnumerableProperty($ArrayBuffer, key, NativeArrayBuffer[key]);
              }
            }
            ArrayBufferPrototype.constructor = $ArrayBuffer;
          } // WebKit bug - the same parent prototype for typed arrays and data view

          if (setPrototypeOf && getPrototypeOf($DataViewPrototype) !== ObjectPrototype) {
            setPrototypeOf($DataViewPrototype, ObjectPrototype);
          } // iOS Safari 7.x bug

          var testView = new $DataView(new $ArrayBuffer(2));
          var nativeSetInt8 = $DataViewPrototype.setInt8;
          testView.setInt8(0, 2147483648);
          testView.setInt8(1, 2147483649);
          if (testView.getInt8(0) || !testView.getInt8(1)) redefineAll($DataViewPrototype, {
            setInt8: function setInt8(byteOffset, value) {
              nativeSetInt8.call(this, byteOffset, value << 24 >> 24);
            },
            setUint8: function setUint8(byteOffset, value) {
              nativeSetInt8.call(this, byteOffset, value << 24 >> 24);
            }
          }, {
            unsafe: true
          });
        }
        setToStringTag($ArrayBuffer, ARRAY_BUFFER);
        setToStringTag($DataView, DATA_VIEW);
        module.exports = {
          ArrayBuffer: $ArrayBuffer,
          DataView: $DataView
        };
      },
      {
        '../internals/an-instance': 27,
        '../internals/array-buffer-native': 29,
        '../internals/array-fill': 33,
        '../internals/create-non-enumerable-property': 56,
        '../internals/descriptors': 61,
        '../internals/fails': 69,
        '../internals/global': 77,
        '../internals/ieee754': 83,
        '../internals/internal-state': 88,
        '../internals/object-define-property': 110,
        '../internals/object-get-own-property-names': 113,
        '../internals/object-get-prototype-of': 115,
        '../internals/object-set-prototype-of': 119,
        '../internals/redefine-all': 125,
        '../internals/set-to-string-tag': 135,
        '../internals/to-index': 151,
        '../internals/to-integer': 153,
        '../internals/to-length': 154
      }
    ],
    32: [
      function (_dereq_, module, exports) {
        'use strict';
        var toObject = _dereq_('../internals/to-object');
        var toAbsoluteIndex = _dereq_('../internals/to-absolute-index');
        var toLength = _dereq_('../internals/to-length');
        var min = Math.min; // `Array.prototype.copyWithin` method implementation
        // https://tc39.github.io/ecma262/#sec-array.prototype.copywithin
        module.exports = [
        ].copyWithin || function copyWithin(target        /* = 0 */
        , start        /* = 0, end = @length */
        ) {
          var O = toObject(this);
          var len = toLength(O.length);
          var to = toAbsoluteIndex(target, len);
          var from = toAbsoluteIndex(start, len);
          var end = arguments.length > 2 ? arguments[2] : undefined;
          var count = min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
          var inc = 1;
          if (from < to && to < from + count) {
            inc = - 1;
            from += count - 1;
            to += count - 1;
          }
          while (count-- > 0) {
            if (from in O) O[to] = O[from];
             else delete O[to];
            to += inc;
            from += inc;
          }
          return O;
        };
      },
      {
        '../internals/to-absolute-index': 150,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    33: [
      function (_dereq_, module, exports) {
        'use strict';
        var toObject = _dereq_('../internals/to-object');
        var toAbsoluteIndex = _dereq_('../internals/to-absolute-index');
        var toLength = _dereq_('../internals/to-length'); // `Array.prototype.fill` method implementation
        // https://tc39.github.io/ecma262/#sec-array.prototype.fill
        module.exports = function fill(value        /* , start = 0, end = @length */
        ) {
          var O = toObject(this);
          var length = toLength(O.length);
          var argumentsLength = arguments.length;
          var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
          var end = argumentsLength > 2 ? arguments[2] : undefined;
          var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
          while (endPos > index) O[index++] = value;
          return O;
        };
      },
      {
        '../internals/to-absolute-index': 150,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    34: [
      function (_dereq_, module, exports) {
        'use strict';
        var $forEach = _dereq_('../internals/array-iteration').forEach;
        var arrayMethodIsStrict = _dereq_('../internals/array-method-is-strict');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var STRICT_METHOD = arrayMethodIsStrict('forEach');
        var USES_TO_LENGTH = arrayMethodUsesToLength('forEach'); // `Array.prototype.forEach` method implementation
        // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
        module.exports = !STRICT_METHOD || !USES_TO_LENGTH ? function forEach(callbackfn        /* , thisArg */
        ) {
          return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
        }
         : [
        ].forEach;
      },
      {
        '../internals/array-iteration': 37,
        '../internals/array-method-is-strict': 40,
        '../internals/array-method-uses-to-length': 41
      }
    ],
    35: [
      function (_dereq_, module, exports) {
        'use strict';
        var bind = _dereq_('../internals/function-bind-context');
        var toObject = _dereq_('../internals/to-object');
        var callWithSafeIterationClosing = _dereq_('../internals/call-with-safe-iteration-closing');
        var isArrayIteratorMethod = _dereq_('../internals/is-array-iterator-method');
        var toLength = _dereq_('../internals/to-length');
        var createProperty = _dereq_('../internals/create-property');
        var getIteratorMethod = _dereq_('../internals/get-iterator-method'); // `Array.from` method implementation
        // https://tc39.github.io/ecma262/#sec-array.from
        module.exports = function from(arrayLike        /* , mapfn = undefined, thisArg = undefined */
        ) {
          var O = toObject(arrayLike);
          var C = typeof this == 'function' ? this : Array;
          var argumentsLength = arguments.length;
          var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
          var mapping = mapfn !== undefined;
          var iteratorMethod = getIteratorMethod(O);
          var index = 0;
          var length,
          result,
          step,
          iterator,
          next,
          value;
          if (mapping) mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2); // if the target is not iterable or it's an array with the default iterator - use a simple case
          if (iteratorMethod != undefined && !(C == Array && isArrayIteratorMethod(iteratorMethod))) {
            iterator = iteratorMethod.call(O);
            next = iterator.next;
            result = new C();
            for (; !(step = next.call(iterator)).done; index++) {
              value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [
                step.value,
                index
              ], true) : step.value;
              createProperty(result, index, value);
            }
          } else {
            length = toLength(O.length);
            result = new C(length);
            for (; length > index; index++) {
              value = mapping ? mapfn(O[index], index) : O[index];
              createProperty(result, index, value);
            }
          }
          result.length = index;
          return result;
        };
      },
      {
        '../internals/call-with-safe-iteration-closing': 44,
        '../internals/create-property': 58,
        '../internals/function-bind-context': 72,
        '../internals/get-iterator-method': 75,
        '../internals/is-array-iterator-method': 89,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    36: [
      function (_dereq_, module, exports) {
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var toLength = _dereq_('../internals/to-length');
        var toAbsoluteIndex = _dereq_('../internals/to-absolute-index'); // `Array.prototype.{ indexOf, includes }` methods implementation
        var createMethod = function (IS_INCLUDES) {
          return function ($this, el, fromIndex) {
            var O = toIndexedObject($this);
            var length = toLength(O.length);
            var index = toAbsoluteIndex(fromIndex, length);
            var value; // Array#includes uses SameValueZero equality algorithm
            // eslint-disable-next-line no-self-compare
            if (IS_INCLUDES && el != el) while (length > index) {
              value = O[index++]; // eslint-disable-next-line no-self-compare
              if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
            } else for (; length > index; index++) {
              if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
            }
            return !IS_INCLUDES && - 1;
          };
        };
        module.exports = {
          // `Array.prototype.includes` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.includes
          includes: createMethod(true),
          // `Array.prototype.indexOf` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
          indexOf: createMethod(false)
        };
      },
      {
        '../internals/to-absolute-index': 150,
        '../internals/to-indexed-object': 152,
        '../internals/to-length': 154
      }
    ],
    37: [
      function (_dereq_, module, exports) {
        var bind = _dereq_('../internals/function-bind-context');
        var IndexedObject = _dereq_('../internals/indexed-object');
        var toObject = _dereq_('../internals/to-object');
        var toLength = _dereq_('../internals/to-length');
        var arraySpeciesCreate = _dereq_('../internals/array-species-create');
        var push = [
        ].push; // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex }` methods implementation
        var createMethod = function (TYPE) {
          var IS_MAP = TYPE == 1;
          var IS_FILTER = TYPE == 2;
          var IS_SOME = TYPE == 3;
          var IS_EVERY = TYPE == 4;
          var IS_FIND_INDEX = TYPE == 6;
          var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
          return function ($this, callbackfn, that, specificCreate) {
            var O = toObject($this);
            var self = IndexedObject(O);
            var boundFunction = bind(callbackfn, that, 3);
            var length = toLength(self.length);
            var index = 0;
            var create = specificCreate || arraySpeciesCreate;
            var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
            var value,
            result;
            for (; length > index; index++) if (NO_HOLES || index in self) {
              value = self[index];
              result = boundFunction(value, index, O);
              if (TYPE) {
                if (IS_MAP) target[index] = result; // map
                 else if (result) switch (TYPE) {
                  case 3:
                    return true;
                    // some
                  case 5:
                    return value;
                    // find
                  case 6:
                    return index;
                    // findIndex
                  case 2:
                    push.call(target, value);
                    // filter
                } else if (IS_EVERY) return false; // every
              }
            }
            return IS_FIND_INDEX ? - 1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
          };
        };
        module.exports = {
          // `Array.prototype.forEach` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
          forEach: createMethod(0),
          // `Array.prototype.map` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.map
          map: createMethod(1),
          // `Array.prototype.filter` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.filter
          filter: createMethod(2),
          // `Array.prototype.some` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.some
          some: createMethod(3),
          // `Array.prototype.every` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.every
          every: createMethod(4),
          // `Array.prototype.find` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.find
          find: createMethod(5),
          // `Array.prototype.findIndex` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
          findIndex: createMethod(6)
        };
      },
      {
        '../internals/array-species-create': 43,
        '../internals/function-bind-context': 72,
        '../internals/indexed-object': 84,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    38: [
      function (_dereq_, module, exports) {
        'use strict';
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var toInteger = _dereq_('../internals/to-integer');
        var toLength = _dereq_('../internals/to-length');
        var arrayMethodIsStrict = _dereq_('../internals/array-method-is-strict');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var min = Math.min;
        var nativeLastIndexOf = [
        ].lastIndexOf;
        var NEGATIVE_ZERO = !!nativeLastIndexOf && 1 / [
          1
        ].lastIndexOf(1, - 0) < 0;
        var STRICT_METHOD = arrayMethodIsStrict('lastIndexOf'); // For preventing possible almost infinite loop in non-standard implementations, test the forward version of the method
        var USES_TO_LENGTH = arrayMethodUsesToLength('indexOf', {
          ACCESSORS: true,
          1: 0
        });
        var FORCED = NEGATIVE_ZERO || !STRICT_METHOD || !USES_TO_LENGTH; // `Array.prototype.lastIndexOf` method implementation
        // https://tc39.github.io/ecma262/#sec-array.prototype.lastindexof
        module.exports = FORCED ? function lastIndexOf(searchElement        /* , fromIndex = @[*-1] */
        ) {
          // convert -0 to +0
          if (NEGATIVE_ZERO) return nativeLastIndexOf.apply(this, arguments) || 0;
          var O = toIndexedObject(this);
          var length = toLength(O.length);
          var index = length - 1;
          if (arguments.length > 1) index = min(index, toInteger(arguments[1]));
          if (index < 0) index = length + index;
          for (; index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;
          return - 1;
        }
         : nativeLastIndexOf;
      },
      {
        '../internals/array-method-is-strict': 40,
        '../internals/array-method-uses-to-length': 41,
        '../internals/to-indexed-object': 152,
        '../internals/to-integer': 153,
        '../internals/to-length': 154
      }
    ],
    39: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var V8_VERSION = _dereq_('../internals/engine-v8-version');
        var SPECIES = wellKnownSymbol('species');
        module.exports = function (METHOD_NAME) {
          // We can't use this feature detection in V8 since it causes
          // deoptimization and serious performance degradation
          // https://github.com/zloirock/core-js/issues/677
          return V8_VERSION >= 51 || !fails(function () {
            var array = [
            ];
            var constructor = array.constructor = {
            };
            constructor[SPECIES] = function () {
              return {
                foo: 1
              };
            };
            return array[METHOD_NAME](Boolean).foo !== 1;
          });
        };
      },
      {
        '../internals/engine-v8-version': 66,
        '../internals/fails': 69,
        '../internals/well-known-symbol': 166
      }
    ],
    40: [
      function (_dereq_, module, exports) {
        'use strict';
        var fails = _dereq_('../internals/fails');
        module.exports = function (METHOD_NAME, argument) {
          var method = [
          ][METHOD_NAME];
          return !!method && fails(function () {
            // eslint-disable-next-line no-useless-call,no-throw-literal
            method.call(null, argument || function () {
              throw 1;
            }, 1);
          });
        };
      },
      {
        '../internals/fails': 69
      }
    ],
    41: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var fails = _dereq_('../internals/fails');
        var has = _dereq_('../internals/has');
        var defineProperty = Object.defineProperty;
        var cache = {
        };
        var thrower = function (it) {
          throw it;
        };
        module.exports = function (METHOD_NAME, options) {
          if (has(cache, METHOD_NAME)) return cache[METHOD_NAME];
          if (!options) options = {
          };
          var method = [
          ][METHOD_NAME];
          var ACCESSORS = has(options, 'ACCESSORS') ? options.ACCESSORS : false;
          var argument0 = has(options, 0) ? options[0] : thrower;
          var argument1 = has(options, 1) ? options[1] : undefined;
          return cache[METHOD_NAME] = !!method && !fails(function () {
            if (ACCESSORS && !DESCRIPTORS) return true;
            var O = {
              length: - 1
            };
            if (ACCESSORS) defineProperty(O, 1, {
              enumerable: true,
              get: thrower
            });
             else O[1] = 1;
            method.call(O, argument0, argument1);
          });
        };
      },
      {
        '../internals/descriptors': 61,
        '../internals/fails': 69,
        '../internals/has': 78
      }
    ],
    42: [
      function (_dereq_, module, exports) {
        var aFunction = _dereq_('../internals/a-function');
        var toObject = _dereq_('../internals/to-object');
        var IndexedObject = _dereq_('../internals/indexed-object');
        var toLength = _dereq_('../internals/to-length'); // `Array.prototype.{ reduce, reduceRight }` methods implementation
        var createMethod = function (IS_RIGHT) {
          return function (that, callbackfn, argumentsLength, memo) {
            aFunction(callbackfn);
            var O = toObject(that);
            var self = IndexedObject(O);
            var length = toLength(O.length);
            var index = IS_RIGHT ? length - 1 : 0;
            var i = IS_RIGHT ? - 1 : 1;
            if (argumentsLength < 2) while (true) {
              if (index in self) {
                memo = self[index];
                index += i;
                break;
              }
              index += i;
              if (IS_RIGHT ? index < 0 : length <= index) {
                throw TypeError('Reduce of empty array with no initial value');
              }
            }
            for (; IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
              memo = callbackfn(memo, self[index], index, O);
            }
            return memo;
          };
        };
        module.exports = {
          // `Array.prototype.reduce` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.reduce
          left: createMethod(false),
          // `Array.prototype.reduceRight` method
          // https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
          right: createMethod(true)
        };
      },
      {
        '../internals/a-function': 23,
        '../internals/indexed-object': 84,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    43: [
      function (_dereq_, module, exports) {
        var isObject = _dereq_('../internals/is-object');
        var isArray = _dereq_('../internals/is-array');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var SPECIES = wellKnownSymbol('species'); // `ArraySpeciesCreate` abstract operation
        // https://tc39.github.io/ecma262/#sec-arrayspeciescreate
        module.exports = function (originalArray, length) {
          var C;
          if (isArray(originalArray)) {
            C = originalArray.constructor; // cross-realm fallback
            if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
             else if (isObject(C)) {
              C = C[SPECIES];
              if (C === null) C = undefined;
            }
          }
          return new (C === undefined ? Array : C) (length === 0 ? 0 : length);
        };
      },
      {
        '../internals/is-array': 90,
        '../internals/is-object': 92,
        '../internals/well-known-symbol': 166
      }
    ],
    44: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object'); // call something on iterator step with safe closing on error
        module.exports = function (iterator, fn, value, ENTRIES) {
          try {
            return ENTRIES ? fn(anObject(value) [0], value[1]) : fn(value); // 7.4.6 IteratorClose(iterator, completion)
          } catch (error) {
            var returnMethod = iterator['return'];
            if (returnMethod !== undefined) anObject(returnMethod.call(iterator));
            throw error;
          }
        };
      },
      {
        '../internals/an-object': 28
      }
    ],
    45: [
      function (_dereq_, module, exports) {
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var ITERATOR = wellKnownSymbol('iterator');
        var SAFE_CLOSING = false;
        try {
          var called = 0;
          var iteratorWithReturn = {
            next: function () {
              return {
                done: !!called++
              };
            },
            'return': function () {
              SAFE_CLOSING = true;
            }
          };
          iteratorWithReturn[ITERATOR] = function () {
            return this;
          }; // eslint-disable-next-line no-throw-literal
          Array.from(iteratorWithReturn, function () {
            throw 2;
          });
        } catch (error) {
          /* empty */
        }
        module.exports = function (exec, SKIP_CLOSING) {
          if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
          var ITERATION_SUPPORT = false;
          try {
            var object = {
            };
            object[ITERATOR] = function () {
              return {
                next: function () {
                  return {
                    done: ITERATION_SUPPORT = true
                  };
                }
              };
            };
            exec(object);
          } catch (error) {
            /* empty */
          }
          return ITERATION_SUPPORT;
        };
      },
      {
        '../internals/well-known-symbol': 166
      }
    ],
    46: [
      function (_dereq_, module, exports) {
        var toString = {
        }.toString;
        module.exports = function (it) {
          return toString.call(it).slice(8, - 1);
        };
      },
      {
      }
    ],
    47: [
      function (_dereq_, module, exports) {
        var TO_STRING_TAG_SUPPORT = _dereq_('../internals/to-string-tag-support');
        var classofRaw = _dereq_('../internals/classof-raw');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var TO_STRING_TAG = wellKnownSymbol('toStringTag'); // ES3 wrong here
        var CORRECT_ARGUMENTS = classofRaw(function () {
          return arguments;
        }()) == 'Arguments'; // fallback for IE11 Script Access Denied error
        var tryGet = function (it, key) {
          try {
            return it[key];
          } catch (error) {
            /* empty */
          }
        }; // getting tag from ES6+ `Object.prototype.toString`
        module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
          var O,
          tag,
          result;
          return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
           : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag // builtinTag case
           : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
           : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
        };
      },
      {
        '../internals/classof-raw': 46,
        '../internals/to-string-tag-support': 159,
        '../internals/well-known-symbol': 166
      }
    ],
    48: [
      function (_dereq_, module, exports) {
        'use strict';
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var create = _dereq_('../internals/object-create');
        var redefineAll = _dereq_('../internals/redefine-all');
        var bind = _dereq_('../internals/function-bind-context');
        var anInstance = _dereq_('../internals/an-instance');
        var iterate = _dereq_('../internals/iterate');
        var defineIterator = _dereq_('../internals/define-iterator');
        var setSpecies = _dereq_('../internals/set-species');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var fastKey = _dereq_('../internals/internal-metadata').fastKey;
        var InternalStateModule = _dereq_('../internals/internal-state');
        var setInternalState = InternalStateModule.set;
        var internalStateGetterFor = InternalStateModule.getterFor;
        module.exports = {
          getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
            var C = wrapper(function (that, iterable) {
              anInstance(that, C, CONSTRUCTOR_NAME);
              setInternalState(that, {
                type: CONSTRUCTOR_NAME,
                index: create(null),
                first: undefined,
                last: undefined,
                size: 0
              });
              if (!DESCRIPTORS) that.size = 0;
              if (iterable != undefined) iterate(iterable, that[ADDER], that, IS_MAP);
            });
            var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
            var define = function (that, key, value) {
              var state = getInternalState(that);
              var entry = getEntry(that, key);
              var previous,
              index; // change existing entry
              if (entry) {
                entry.value = value; // create new entry
              } else {
                state.last = entry = {
                  index: index = fastKey(key, true),
                  key: key,
                  value: value,
                  previous: previous = state.last,
                  next: undefined,
                  removed: false
                };
                if (!state.first) state.first = entry;
                if (previous) previous.next = entry;
                if (DESCRIPTORS) state.size++;
                 else that.size++; // add to index
                if (index !== 'F') state.index[index] = entry;
              }
              return that;
            };
            var getEntry = function (that, key) {
              var state = getInternalState(that); // fast case
              var index = fastKey(key);
              var entry;
              if (index !== 'F') return state.index[index]; // frozen object case
              for (entry = state.first; entry; entry = entry.next) {
                if (entry.key == key) return entry;
              }
            };
            redefineAll(C.prototype, {
              // 23.1.3.1 Map.prototype.clear()
              // 23.2.3.2 Set.prototype.clear()
              clear: function clear() {
                var that = this;
                var state = getInternalState(that);
                var data = state.index;
                var entry = state.first;
                while (entry) {
                  entry.removed = true;
                  if (entry.previous) entry.previous = entry.previous.next = undefined;
                  delete data[entry.index];
                  entry = entry.next;
                }
                state.first = state.last = undefined;
                if (DESCRIPTORS) state.size = 0;
                 else that.size = 0;
              },
              // 23.1.3.3 Map.prototype.delete(key)
              // 23.2.3.4 Set.prototype.delete(value)
              'delete': function (key) {
                var that = this;
                var state = getInternalState(that);
                var entry = getEntry(that, key);
                if (entry) {
                  var next = entry.next;
                  var prev = entry.previous;
                  delete state.index[entry.index];
                  entry.removed = true;
                  if (prev) prev.next = next;
                  if (next) next.previous = prev;
                  if (state.first == entry) state.first = next;
                  if (state.last == entry) state.last = prev;
                  if (DESCRIPTORS) state.size--;
                   else that.size--;
                }
                return !!entry;
              },
              // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
              // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
              forEach: function forEach(callbackfn              /* , that = undefined */
              ) {
                var state = getInternalState(this);
                var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
                var entry;
                while (entry = entry ? entry.next : state.first) {
                  boundFunction(entry.value, entry.key, this); // revert to the last existing entry
                  while (entry && entry.removed) entry = entry.previous;
                }
              },
              // 23.1.3.7 Map.prototype.has(key)
              // 23.2.3.7 Set.prototype.has(value)
              has: function has(key) {
                return !!getEntry(this, key);
              }
            });
            redefineAll(C.prototype, IS_MAP ? {
              // 23.1.3.6 Map.prototype.get(key)
              get: function get(key) {
                var entry = getEntry(this, key);
                return entry && entry.value;
              },
              // 23.1.3.9 Map.prototype.set(key, value)
              set: function set(key, value) {
                return define(this, key === 0 ? 0 : key, value);
              }
            }
             : {
              // 23.2.3.1 Set.prototype.add(value)
              add: function add(value) {
                return define(this, value = value === 0 ? 0 : value, value);
              }
            });
            if (DESCRIPTORS) defineProperty(C.prototype, 'size', {
              get: function () {
                return getInternalState(this).size;
              }
            });
            return C;
          },
          setStrong: function (C, CONSTRUCTOR_NAME, IS_MAP) {
            var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
            var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
            var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME); // add .keys, .values, .entries, [@@iterator]
            // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
            defineIterator(C, CONSTRUCTOR_NAME, function (iterated, kind) {
              setInternalState(this, {
                type: ITERATOR_NAME,
                target: iterated,
                state: getInternalCollectionState(iterated),
                kind: kind,
                last: undefined
              });
            }, function () {
              var state = getInternalIteratorState(this);
              var kind = state.kind;
              var entry = state.last; // revert to the last existing entry
              while (entry && entry.removed) entry = entry.previous; // get next entry
              if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
                // or finish the iteration
                state.target = undefined;
                return {
                  value: undefined,
                  done: true
                };
              } // return step by kind

              if (kind == 'keys') return {
                value: entry.key,
                done: false
              };
              if (kind == 'values') return {
                value: entry.value,
                done: false
              };
              return {
                value: [
                  entry.key,
                  entry.value
                ],
                done: false
              };
            }, IS_MAP ? 'entries' : 'values', !IS_MAP, true); // add [@@species], 23.1.2.2, 23.2.2.2
            setSpecies(CONSTRUCTOR_NAME);
          }
        };
      },
      {
        '../internals/an-instance': 27,
        '../internals/define-iterator': 59,
        '../internals/descriptors': 61,
        '../internals/function-bind-context': 72,
        '../internals/internal-metadata': 87,
        '../internals/internal-state': 88,
        '../internals/iterate': 95,
        '../internals/object-create': 108,
        '../internals/object-define-property': 110,
        '../internals/redefine-all': 125,
        '../internals/set-species': 134
      }
    ],
    49: [
      function (_dereq_, module, exports) {
        'use strict';
        var redefineAll = _dereq_('../internals/redefine-all');
        var getWeakData = _dereq_('../internals/internal-metadata').getWeakData;
        var anObject = _dereq_('../internals/an-object');
        var isObject = _dereq_('../internals/is-object');
        var anInstance = _dereq_('../internals/an-instance');
        var iterate = _dereq_('../internals/iterate');
        var ArrayIterationModule = _dereq_('../internals/array-iteration');
        var $has = _dereq_('../internals/has');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var setInternalState = InternalStateModule.set;
        var internalStateGetterFor = InternalStateModule.getterFor;
        var find = ArrayIterationModule.find;
        var findIndex = ArrayIterationModule.findIndex;
        var id = 0; // fallback for uncaught frozen keys
        var uncaughtFrozenStore = function (store) {
          return store.frozen || (store.frozen = new UncaughtFrozenStore());
        };
        var UncaughtFrozenStore = function () {
          this.entries = [
          ];
        };
        var findUncaughtFrozen = function (store, key) {
          return find(store.entries, function (it) {
            return it[0] === key;
          });
        };
        UncaughtFrozenStore.prototype = {
          get: function (key) {
            var entry = findUncaughtFrozen(this, key);
            if (entry) return entry[1];
          },
          has: function (key) {
            return !!findUncaughtFrozen(this, key);
          },
          set: function (key, value) {
            var entry = findUncaughtFrozen(this, key);
            if (entry) entry[1] = value;
             else this.entries.push([key,
            value]);
          },
          'delete': function (key) {
            var index = findIndex(this.entries, function (it) {
              return it[0] === key;
            });
            if (~index) this.entries.splice(index, 1);
            return !!~index;
          }
        };
        module.exports = {
          getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
            var C = wrapper(function (that, iterable) {
              anInstance(that, C, CONSTRUCTOR_NAME);
              setInternalState(that, {
                type: CONSTRUCTOR_NAME,
                id: id++,
                frozen: undefined
              });
              if (iterable != undefined) iterate(iterable, that[ADDER], that, IS_MAP);
            });
            var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
            var define = function (that, key, value) {
              var state = getInternalState(that);
              var data = getWeakData(anObject(key), true);
              if (data === true) uncaughtFrozenStore(state).set(key, value);
               else data[state.id] = value;
              return that;
            };
            redefineAll(C.prototype, {
              // 23.3.3.2 WeakMap.prototype.delete(key)
              // 23.4.3.3 WeakSet.prototype.delete(value)
              'delete': function (key) {
                var state = getInternalState(this);
                if (!isObject(key)) return false;
                var data = getWeakData(key);
                if (data === true) return uncaughtFrozenStore(state) ['delete'](key);
                return data && $has(data, state.id) && delete data[state.id];
              },
              // 23.3.3.4 WeakMap.prototype.has(key)
              // 23.4.3.4 WeakSet.prototype.has(value)
              has: function has(key) {
                var state = getInternalState(this);
                if (!isObject(key)) return false;
                var data = getWeakData(key);
                if (data === true) return uncaughtFrozenStore(state).has(key);
                return data && $has(data, state.id);
              }
            });
            redefineAll(C.prototype, IS_MAP ? {
              // 23.3.3.3 WeakMap.prototype.get(key)
              get: function get(key) {
                var state = getInternalState(this);
                if (isObject(key)) {
                  var data = getWeakData(key);
                  if (data === true) return uncaughtFrozenStore(state).get(key);
                  return data ? data[state.id] : undefined;
                }
              },
              // 23.3.3.5 WeakMap.prototype.set(key, value)
              set: function set(key, value) {
                return define(this, key, value);
              }
            }
             : {
              // 23.4.3.1 WeakSet.prototype.add(value)
              add: function add(value) {
                return define(this, value, true);
              }
            });
            return C;
          }
        };
      },
      {
        '../internals/an-instance': 27,
        '../internals/an-object': 28,
        '../internals/array-iteration': 37,
        '../internals/has': 78,
        '../internals/internal-metadata': 87,
        '../internals/internal-state': 88,
        '../internals/is-object': 92,
        '../internals/iterate': 95,
        '../internals/redefine-all': 125
      }
    ],
    50: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var global = _dereq_('../internals/global');
        var isForced = _dereq_('../internals/is-forced');
        var redefine = _dereq_('../internals/redefine');
        var InternalMetadataModule = _dereq_('../internals/internal-metadata');
        var iterate = _dereq_('../internals/iterate');
        var anInstance = _dereq_('../internals/an-instance');
        var isObject = _dereq_('../internals/is-object');
        var fails = _dereq_('../internals/fails');
        var checkCorrectnessOfIteration = _dereq_('../internals/check-correctness-of-iteration');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var inheritIfRequired = _dereq_('../internals/inherit-if-required');
        module.exports = function (CONSTRUCTOR_NAME, wrapper, common) {
          var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== - 1;
          var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== - 1;
          var ADDER = IS_MAP ? 'set' : 'add';
          var NativeConstructor = global[CONSTRUCTOR_NAME];
          var NativePrototype = NativeConstructor && NativeConstructor.prototype;
          var Constructor = NativeConstructor;
          var exported = {
          };
          var fixMethod = function (KEY) {
            var nativeMethod = NativePrototype[KEY];
            redefine(NativePrototype, KEY, KEY == 'add' ? function add(value) {
              nativeMethod.call(this, value === 0 ? 0 : value);
              return this;
            }
             : KEY == 'delete' ? function (key) {
              return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
            }
             : KEY == 'get' ? function get(key) {
              return IS_WEAK && !isObject(key) ? undefined : nativeMethod.call(this, key === 0 ? 0 : key);
            }
             : KEY == 'has' ? function has(key) {
              return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
            }
             : function set(key, value) {
              nativeMethod.call(this, key === 0 ? 0 : key, value);
              return this;
            });
          }; // eslint-disable-next-line max-len
          if (isForced(CONSTRUCTOR_NAME, typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
            new NativeConstructor().entries().next();
          })))) {
            // create collection constructor
            Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
            InternalMetadataModule.REQUIRED = true;
          } else if (isForced(CONSTRUCTOR_NAME, true)) {
            var instance = new Constructor(); // early implementations not supports chaining
            var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {
            }
             : - 0, 1) != instance; // V8 ~ Chromium 40- weak-collections throws on primitives, but should return false
            var THROWS_ON_PRIMITIVES = fails(function () {
              instance.has(1);
            }); // most early implementations doesn't supports iterables, most modern - not close it correctly
            // eslint-disable-next-line no-new
            var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function (iterable) {
              new NativeConstructor(iterable);
            }); // for early implementations -0 and +0 not the same
            var BUGGY_ZERO = !IS_WEAK && fails(function () {
              // V8 ~ Chromium 42- fails only with 5+ elements
              var $instance = new NativeConstructor();
              var index = 5;
              while (index--) $instance[ADDER](index, index);
              return !$instance.has( - 0);
            });
            if (!ACCEPT_ITERABLES) {
              Constructor = wrapper(function (dummy, iterable) {
                anInstance(dummy, Constructor, CONSTRUCTOR_NAME);
                var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
                if (iterable != undefined) iterate(iterable, that[ADDER], that, IS_MAP);
                return that;
              });
              Constructor.prototype = NativePrototype;
              NativePrototype.constructor = Constructor;
            }
            if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
              fixMethod('delete');
              fixMethod('has');
              IS_MAP && fixMethod('get');
            }
            if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER); // weak collections should not contains .clear method
            if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
          }
          exported[CONSTRUCTOR_NAME] = Constructor;
          $({
            global: true,
            forced: Constructor != NativeConstructor
          }, exported);
          setToStringTag(Constructor, CONSTRUCTOR_NAME);
          if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
          return Constructor;
        };
      },
      {
        '../internals/an-instance': 27,
        '../internals/check-correctness-of-iteration': 45,
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/global': 77,
        '../internals/inherit-if-required': 85,
        '../internals/internal-metadata': 87,
        '../internals/is-forced': 91,
        '../internals/is-object': 92,
        '../internals/iterate': 95,
        '../internals/redefine': 126,
        '../internals/set-to-string-tag': 135
      }
    ],
    51: [
      function (_dereq_, module, exports) {
        var has = _dereq_('../internals/has');
        var ownKeys = _dereq_('../internals/own-keys');
        var getOwnPropertyDescriptorModule = _dereq_('../internals/object-get-own-property-descriptor');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        module.exports = function (target, source) {
          var keys = ownKeys(source);
          var defineProperty = definePropertyModule.f;
          var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
          for (var i = 0; i < keys.length; i++) {
            var key = keys[i];
            if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
          }
        };
      },
      {
        '../internals/has': 78,
        '../internals/object-define-property': 110,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/own-keys': 121
      }
    ],
    52: [
      function (_dereq_, module, exports) {
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var MATCH = wellKnownSymbol('match');
        module.exports = function (METHOD_NAME) {
          var regexp = /./;
          try {
            '/./'[METHOD_NAME](regexp);
          } catch (e) {
            try {
              regexp[MATCH] = false;
              return '/./'[METHOD_NAME](regexp);
            } catch (f) {
              /* empty */
            }
          }
          return false;
        };
      },
      {
        '../internals/well-known-symbol': 166
      }
    ],
    53: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        module.exports = !fails(function () {
          function F() {
            /* empty */
          }
          F.prototype.constructor = null;
          return Object.getPrototypeOf(new F()) !== F.prototype;
        });
      },
      {
        '../internals/fails': 69
      }
    ],
    54: [
      function (_dereq_, module, exports) {
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var quot = /"/g; // B.2.3.2.1 CreateHTML(string, tag, attribute, value)
        // https://tc39.github.io/ecma262/#sec-createhtml
        module.exports = function (string, tag, attribute, value) {
          var S = String(requireObjectCoercible(string));
          var p1 = '<' + tag;
          if (attribute !== '') p1 += ' ' + attribute + '="' + String(value).replace(quot, '&quot;') + '"';
          return p1 + '>' + S + '</' + tag + '>';
        };
      },
      {
        '../internals/require-object-coercible': 131
      }
    ],
    55: [
      function (_dereq_, module, exports) {
        'use strict';
        var IteratorPrototype = _dereq_('../internals/iterators-core').IteratorPrototype;
        var create = _dereq_('../internals/object-create');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var Iterators = _dereq_('../internals/iterators');
        var returnThis = function () {
          return this;
        };
        module.exports = function (IteratorConstructor, NAME, next) {
          var TO_STRING_TAG = NAME + ' Iterator';
          IteratorConstructor.prototype = create(IteratorPrototype, {
            next: createPropertyDescriptor(1, next)
          });
          setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
          Iterators[TO_STRING_TAG] = returnThis;
          return IteratorConstructor;
        };
      },
      {
        '../internals/create-property-descriptor': 57,
        '../internals/iterators': 97,
        '../internals/iterators-core': 96,
        '../internals/object-create': 108,
        '../internals/set-to-string-tag': 135
      }
    ],
    56: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        module.exports = DESCRIPTORS ? function (object, key, value) {
          return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
        }
         : function (object, key, value) {
          object[key] = value;
          return object;
        };
      },
      {
        '../internals/create-property-descriptor': 57,
        '../internals/descriptors': 61,
        '../internals/object-define-property': 110
      }
    ],
    57: [
      function (_dereq_, module, exports) {
        module.exports = function (bitmap, value) {
          return {
            enumerable: !(bitmap & 1),
            configurable: !(bitmap & 2),
            writable: !(bitmap & 4),
            value: value
          };
        };
      },
      {
      }
    ],
    58: [
      function (_dereq_, module, exports) {
        'use strict';
        var toPrimitive = _dereq_('../internals/to-primitive');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        module.exports = function (object, key, value) {
          var propertyKey = toPrimitive(key);
          if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
           else object[propertyKey] = value;
        };
      },
      {
        '../internals/create-property-descriptor': 57,
        '../internals/object-define-property': 110,
        '../internals/to-primitive': 158
      }
    ],
    59: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var createIteratorConstructor = _dereq_('../internals/create-iterator-constructor');
        var getPrototypeOf = _dereq_('../internals/object-get-prototype-of');
        var setPrototypeOf = _dereq_('../internals/object-set-prototype-of');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var redefine = _dereq_('../internals/redefine');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var IS_PURE = _dereq_('../internals/is-pure');
        var Iterators = _dereq_('../internals/iterators');
        var IteratorsCore = _dereq_('../internals/iterators-core');
        var IteratorPrototype = IteratorsCore.IteratorPrototype;
        var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
        var ITERATOR = wellKnownSymbol('iterator');
        var KEYS = 'keys';
        var VALUES = 'values';
        var ENTRIES = 'entries';
        var returnThis = function () {
          return this;
        };
        module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
          createIteratorConstructor(IteratorConstructor, NAME, next);
          var getIterationMethod = function (KIND) {
            if (KIND === DEFAULT && defaultIterator) return defaultIterator;
            if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
            switch (KIND) {
              case KEYS:
                return function keys() {
                  return new IteratorConstructor(this, KIND);
                };
              case VALUES:
                return function values() {
                  return new IteratorConstructor(this, KIND);
                };
              case ENTRIES:
                return function entries() {
                  return new IteratorConstructor(this, KIND);
                };
            }
            return function () {
              return new IteratorConstructor(this);
            };
          };
          var TO_STRING_TAG = NAME + ' Iterator';
          var INCORRECT_VALUES_NAME = false;
          var IterablePrototype = Iterable.prototype;
          var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
          var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
          var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
          var CurrentIteratorPrototype,
          methods,
          KEY; // fix native
          if (anyNativeIterator) {
            CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
            if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
              if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
                if (setPrototypeOf) {
                  setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
                } else if (typeof CurrentIteratorPrototype[ITERATOR] != 'function') {
                  createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR, returnThis);
                }
              } // Set @@toStringTag to native iterators

              setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
              if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
            }
          } // fix Array#{values, @@iterator}.name in V8 / FF

          if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
            INCORRECT_VALUES_NAME = true;
            defaultIterator = function values() {
              return nativeIterator.call(this);
            };
          } // define iterator

          if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
            createNonEnumerableProperty(IterablePrototype, ITERATOR, defaultIterator);
          }
          Iterators[NAME] = defaultIterator; // export additional methods
          if (DEFAULT) {
            methods = {
              values: getIterationMethod(VALUES),
              keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
              entries: getIterationMethod(ENTRIES)
            };
            if (FORCED) for (KEY in methods) {
              if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
                redefine(IterablePrototype, KEY, methods[KEY]);
              }
            } else $({
              target: NAME,
              proto: true,
              forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
            }, methods);
          }
          return methods;
        };
      },
      {
        '../internals/create-iterator-constructor': 55,
        '../internals/create-non-enumerable-property': 56,
        '../internals/export': 68,
        '../internals/is-pure': 93,
        '../internals/iterators': 97,
        '../internals/iterators-core': 96,
        '../internals/object-get-prototype-of': 115,
        '../internals/object-set-prototype-of': 119,
        '../internals/redefine': 126,
        '../internals/set-to-string-tag': 135,
        '../internals/well-known-symbol': 166
      }
    ],
    60: [
      function (_dereq_, module, exports) {
        var path = _dereq_('../internals/path');
        var has = _dereq_('../internals/has');
        var wrappedWellKnownSymbolModule = _dereq_('../internals/well-known-symbol-wrapped');
        var defineProperty = _dereq_('../internals/object-define-property').f;
        module.exports = function (NAME) {
          var Symbol = path.Symbol || (path.Symbol = {
          });
          if (!has(Symbol, NAME)) defineProperty(Symbol, NAME, {
            value: wrappedWellKnownSymbolModule.f(NAME)
          });
        };
      },
      {
        '../internals/has': 78,
        '../internals/object-define-property': 110,
        '../internals/path': 122,
        '../internals/well-known-symbol-wrapped': 165
      }
    ],
    61: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails'); // Thank's IE8 for his funny defineProperty
        module.exports = !fails(function () {
          return Object.defineProperty({
          }, 1, {
            get: function () {
              return 7;
            }
          }) [1] != 7;
        });
      },
      {
        '../internals/fails': 69
      }
    ],
    62: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var isObject = _dereq_('../internals/is-object');
        var document = global.document; // typeof document.createElement is 'object' in old IE
        var EXISTS = isObject(document) && isObject(document.createElement);
        module.exports = function (it) {
          return EXISTS ? document.createElement(it) : {
          };
        };
      },
      {
        '../internals/global': 77,
        '../internals/is-object': 92
      }
    ],
    63: [
      function (_dereq_, module, exports) {
        // iterable DOM collections
        // flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
        module.exports = {
          CSSRuleList: 0,
          CSSStyleDeclaration: 0,
          CSSValueList: 0,
          ClientRectList: 0,
          DOMRectList: 0,
          DOMStringList: 0,
          DOMTokenList: 1,
          DataTransferItemList: 0,
          FileList: 0,
          HTMLAllCollection: 0,
          HTMLCollection: 0,
          HTMLFormElement: 0,
          HTMLSelectElement: 0,
          MediaList: 0,
          MimeTypeArray: 0,
          NamedNodeMap: 0,
          NodeList: 1,
          PaintRequestList: 0,
          Plugin: 0,
          PluginArray: 0,
          SVGLengthList: 0,
          SVGNumberList: 0,
          SVGPathSegList: 0,
          SVGPointList: 0,
          SVGStringList: 0,
          SVGTransformList: 0,
          SourceBufferList: 0,
          StyleSheetList: 0,
          TextTrackCueList: 0,
          TextTrackList: 0,
          TouchList: 0
        };
      },
      {
      }
    ],
    64: [
      function (_dereq_, module, exports) {
        var userAgent = _dereq_('../internals/engine-user-agent');
        module.exports = /(iphone|ipod|ipad).*applewebkit/i.test(userAgent);
      },
      {
        '../internals/engine-user-agent': 65
      }
    ],
    65: [
      function (_dereq_, module, exports) {
        var getBuiltIn = _dereq_('../internals/get-built-in');
        module.exports = getBuiltIn('navigator', 'userAgent') || '';
      },
      {
        '../internals/get-built-in': 74
      }
    ],
    66: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var userAgent = _dereq_('../internals/engine-user-agent');
        var process = global.process;
        var versions = process && process.versions;
        var v8 = versions && versions.v8;
        var match,
        version;
        if (v8) {
          match = v8.split('.');
          version = match[0] + match[1];
        } else if (userAgent) {
          match = userAgent.match(/Edge\/(\d+)/);
          if (!match || match[1] >= 74) {
            match = userAgent.match(/Chrome\/(\d+)/);
            if (match) version = match[1];
          }
        }
        module.exports = version && + version;
      },
      {
        '../internals/engine-user-agent': 65,
        '../internals/global': 77
      }
    ],
    67: [
      function (_dereq_, module, exports) {
        // IE8- don't enum bug keys
        module.exports = [
          'constructor',
          'hasOwnProperty',
          'isPrototypeOf',
          'propertyIsEnumerable',
          'toLocaleString',
          'toString',
          'valueOf'
        ];
      },
      {
      }
    ],
    68: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var getOwnPropertyDescriptor = _dereq_('../internals/object-get-own-property-descriptor').f;
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var redefine = _dereq_('../internals/redefine');
        var setGlobal = _dereq_('../internals/set-global');
        var copyConstructorProperties = _dereq_('../internals/copy-constructor-properties');
        var isForced = _dereq_('../internals/is-forced');
        /*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
*/
        module.exports = function (options, source) {
          var TARGET = options.target;
          var GLOBAL = options.global;
          var STATIC = options.stat;
          var FORCED,
          target,
          key,
          targetProperty,
          sourceProperty,
          descriptor;
          if (GLOBAL) {
            target = global;
          } else if (STATIC) {
            target = global[TARGET] || setGlobal(TARGET, {
            });
          } else {
            target = (global[TARGET] || {
            }).prototype;
          }
          if (target) for (key in source) {
            sourceProperty = source[key];
            if (options.noTargetGet) {
              descriptor = getOwnPropertyDescriptor(target, key);
              targetProperty = descriptor && descriptor.value;
            } else targetProperty = target[key];
            FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contained in target
            if (!FORCED && targetProperty !== undefined) {
              if (typeof sourceProperty === typeof targetProperty) continue;
              copyConstructorProperties(sourceProperty, targetProperty);
            } // add a flag to not completely full polyfills

            if (options.sham || targetProperty && targetProperty.sham) {
              createNonEnumerableProperty(sourceProperty, 'sham', true);
            } // extend global

            redefine(target, key, sourceProperty, options);
          }
        };
      },
      {
        '../internals/copy-constructor-properties': 51,
        '../internals/create-non-enumerable-property': 56,
        '../internals/global': 77,
        '../internals/is-forced': 91,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/redefine': 126,
        '../internals/set-global': 133
      }
    ],
    69: [
      function (_dereq_, module, exports) {
        module.exports = function (exec) {
          try {
            return !!exec();
          } catch (error) {
            return true;
          }
        };
      },
      {
      }
    ],
    70: [
      function (_dereq_, module, exports) {
        'use strict'; // TODO: Remove from `core-js@4` since it's moved to entry points
        _dereq_('../modules/es.regexp.exec');
        var redefine = _dereq_('../internals/redefine');
        var fails = _dereq_('../internals/fails');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var regexpExec = _dereq_('../internals/regexp-exec');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var SPECIES = wellKnownSymbol('species');
        var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
          // #replace needs built-in support for named groups.
          // #match works fine because it just return the exec results, even if it has
          // a "grops" property.
          var re = /./;
          re.exec = function () {
            var result = [
            ];
            result.groups = {
              a: '7'
            };
            return result;
          };
          return ''.replace(re, '$<a>') !== '7';
        }); // IE <= 11 replaces $0 with the whole match, as if it was $&
        // https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0
        var REPLACE_KEEPS_$0 = function () {
          return 'a'.replace(/./, '$0') === '$0';
        }();
        var REPLACE = wellKnownSymbol('replace'); // Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string
        var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = function () {
          if (/./[REPLACE]) {
            return /./[REPLACE]('a', '$0') === '';
          }
          return false;
        }(); // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
        // Weex JS has frozen built-in prototypes, so use try / catch wrapper
        var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
          var re = /(?:)/;
          var originalExec = re.exec;
          re.exec = function () {
            return originalExec.apply(this, arguments);
          };
          var result = 'ab'.split(re);
          return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
        });
        module.exports = function (KEY, length, exec, sham) {
          var SYMBOL = wellKnownSymbol(KEY);
          var DELEGATES_TO_SYMBOL = !fails(function () {
            // String methods call symbol-named RegEp methods
            var O = {
            };
            O[SYMBOL] = function () {
              return 7;
            };
            return ''[KEY](O) != 7;
          });
          var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails(function () {
            // Symbol-named RegExp methods call .exec
            var execCalled = false;
            var re = /a/;
            if (KEY === 'split') {
              // We can't use real regex here since it causes deoptimization
              // and serious performance degradation in V8
              // https://github.com/zloirock/core-js/issues/306
              re = {
              }; // RegExp[@@split] doesn't call the regex's exec method, but first creates
              // a new one. We need to return the patched regex when creating the new one.
              re.constructor = {
              };
              re.constructor[SPECIES] = function () {
                return re;
              };
              re.flags = '';
              re[SYMBOL] = /./[SYMBOL];
            }
            re.exec = function () {
              execCalled = true;
              return null;
            };
            re[SYMBOL]('');
            return !execCalled;
          });
          if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || KEY === 'replace' && !(REPLACE_SUPPORTS_NAMED_GROUPS && REPLACE_KEEPS_$0 && !REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE) || KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC) {
            var nativeRegExpMethod = /./[SYMBOL];
            var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
              if (regexp.exec === regexpExec) {
                if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
                  // The native String method already delegates to @@method (this
                  // polyfilled function), leasing to infinite recursion.
                  // We avoid it by directly calling the native @@method method.
                  return {
                    done: true,
                    value: nativeRegExpMethod.call(regexp, str, arg2)
                  };
                }
                return {
                  done: true,
                  value: nativeMethod.call(str, regexp, arg2)
                };
              }
              return {
                done: false
              };
            }, {
              REPLACE_KEEPS_$0: REPLACE_KEEPS_$0,
              REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE: REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
            });
            var stringMethod = methods[0];
            var regexMethod = methods[1];
            redefine(String.prototype, KEY, stringMethod);
            redefine(RegExp.prototype, SYMBOL, length == 2 // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
            // 21.2.5.11 RegExp.prototype[@@split](string, limit)
            ? function (string, arg) {
              return regexMethod.call(string, this, arg);
            } // 21.2.5.6 RegExp.prototype[@@match](string)
            // 21.2.5.9 RegExp.prototype[@@search](string)

             : function (string) {
              return regexMethod.call(string, this);
            });
          }
          if (sham) createNonEnumerableProperty(RegExp.prototype[SYMBOL], 'sham', true);
        };
      },
      {
        '../internals/create-non-enumerable-property': 56,
        '../internals/fails': 69,
        '../internals/redefine': 126,
        '../internals/regexp-exec': 128,
        '../internals/well-known-symbol': 166,
        '../modules/es.regexp.exec': 203
      }
    ],
    71: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        module.exports = !fails(function () {
          return Object.isExtensible(Object.preventExtensions({
          }));
        });
      },
      {
        '../internals/fails': 69
      }
    ],
    72: [
      function (_dereq_, module, exports) {
        var aFunction = _dereq_('../internals/a-function'); // optional / simple context binding
        module.exports = function (fn, that, length) {
          aFunction(fn);
          if (that === undefined) return fn;
          switch (length) {
            case 0:
              return function () {
                return fn.call(that);
              };
            case 1:
              return function (a) {
                return fn.call(that, a);
              };
            case 2:
              return function (a, b) {
                return fn.call(that, a, b);
              };
            case 3:
              return function (a, b, c) {
                return fn.call(that, a, b, c);
              };
          }
          return function ()          /* ...args */
          {
            return fn.apply(that, arguments);
          };
        };
      },
      {
        '../internals/a-function': 23
      }
    ],
    73: [
      function (_dereq_, module, exports) {
        'use strict';
        var aFunction = _dereq_('../internals/a-function');
        var isObject = _dereq_('../internals/is-object');
        var slice = [
        ].slice;
        var factories = {
        };
        var construct = function (C, argsLength, args) {
          if (!(argsLength in factories)) {
            for (var list = [
            ], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']'; // eslint-disable-next-line no-new-func
            factories[argsLength] = Function('C,a', 'return new C(' + list.join(',') + ')');
          }
          return factories[argsLength](C, args);
        }; // `Function.prototype.bind` method implementation
        // https://tc39.github.io/ecma262/#sec-function.prototype.bind
        module.exports = Function.bind || function bind(that        /* , ...args */
        ) {
          var fn = aFunction(this);
          var partArgs = slice.call(arguments, 1);
          var boundFunction = function bound()          /* args... */
          {
            var args = partArgs.concat(slice.call(arguments));
            return this instanceof boundFunction ? construct(fn, args.length, args) : fn.apply(that, args);
          };
          if (isObject(fn.prototype)) boundFunction.prototype = fn.prototype;
          return boundFunction;
        };
      },
      {
        '../internals/a-function': 23,
        '../internals/is-object': 92
      }
    ],
    74: [
      function (_dereq_, module, exports) {
        var path = _dereq_('../internals/path');
        var global = _dereq_('../internals/global');
        var aFunction = function (variable) {
          return typeof variable == 'function' ? variable : undefined;
        };
        module.exports = function (namespace, method) {
          return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace]) : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
        };
      },
      {
        '../internals/global': 77,
        '../internals/path': 122
      }
    ],
    75: [
      function (_dereq_, module, exports) {
        var classof = _dereq_('../internals/classof');
        var Iterators = _dereq_('../internals/iterators');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var ITERATOR = wellKnownSymbol('iterator');
        module.exports = function (it) {
          if (it != undefined) return it[ITERATOR] || it['@@iterator'] || Iterators[classof(it)];
        };
      },
      {
        '../internals/classof': 47,
        '../internals/iterators': 97,
        '../internals/well-known-symbol': 166
      }
    ],
    76: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object');
        var getIteratorMethod = _dereq_('../internals/get-iterator-method');
        module.exports = function (it) {
          var iteratorMethod = getIteratorMethod(it);
          if (typeof iteratorMethod != 'function') {
            throw TypeError(String(it) + ' is not iterable');
          }
          return anObject(iteratorMethod.call(it));
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/get-iterator-method': 75
      }
    ],
    77: [
      function (_dereq_, module, exports) {
        (function (global) {
          var check = function (it) {
            return it && it.Math == Math && it;
          }; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
          module.exports = // eslint-disable-next-line no-undef
          check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof global == 'object' && global) || // eslint-disable-next-line no-new-func
          Function('return this') ();
        }).call(this, typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : typeof window !== 'undefined' ? window : {
        })
      },
      {
      }
    ],
    78: [
      function (_dereq_, module, exports) {
        var hasOwnProperty = {
        }.hasOwnProperty;
        module.exports = function (it, key) {
          return hasOwnProperty.call(it, key);
        };
      },
      {
      }
    ],
    79: [
      function (_dereq_, module, exports) {
        module.exports = {
        };
      },
      {
      }
    ],
    80: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        module.exports = function (a, b) {
          var console = global.console;
          if (console && console.error) {
            arguments.length === 1 ? console.error(a) : console.error(a, b);
          }
        };
      },
      {
        '../internals/global': 77
      }
    ],
    81: [
      function (_dereq_, module, exports) {
        var getBuiltIn = _dereq_('../internals/get-built-in');
        module.exports = getBuiltIn('document', 'documentElement');
      },
      {
        '../internals/get-built-in': 74
      }
    ],
    82: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var fails = _dereq_('../internals/fails');
        var createElement = _dereq_('../internals/document-create-element'); // Thank's IE8 for his funny defineProperty
        module.exports = !DESCRIPTORS && !fails(function () {
          return Object.defineProperty(createElement('div'), 'a', {
            get: function () {
              return 7;
            }
          }).a != 7;
        });
      },
      {
        '../internals/descriptors': 61,
        '../internals/document-create-element': 62,
        '../internals/fails': 69
      }
    ],
    83: [
      function (_dereq_, module, exports) {
        // IEEE754 conversions based on https://github.com/feross/ieee754
        // eslint-disable-next-line no-shadow-restricted-names
        var Infinity = 1 / 0;
        var abs = Math.abs;
        var pow = Math.pow;
        var floor = Math.floor;
        var log = Math.log;
        var LN2 = Math.LN2;
        var pack = function (number, mantissaLength, bytes) {
          var buffer = new Array(bytes);
          var exponentLength = bytes * 8 - mantissaLength - 1;
          var eMax = (1 << exponentLength) - 1;
          var eBias = eMax >> 1;
          var rt = mantissaLength === 23 ? pow(2, - 24) - pow(2, - 77) : 0;
          var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
          var index = 0;
          var exponent,
          mantissa,
          c;
          number = abs(number); // eslint-disable-next-line no-self-compare
          if (number != number || number === Infinity) {
            // eslint-disable-next-line no-self-compare
            mantissa = number != number ? 1 : 0;
            exponent = eMax;
          } else {
            exponent = floor(log(number) / LN2);
            if (number * (c = pow(2, - exponent)) < 1) {
              exponent--;
              c *= 2;
            }
            if (exponent + eBias >= 1) {
              number += rt / c;
            } else {
              number += rt * pow(2, 1 - eBias);
            }
            if (number * c >= 2) {
              exponent++;
              c /= 2;
            }
            if (exponent + eBias >= eMax) {
              mantissa = 0;
              exponent = eMax;
            } else if (exponent + eBias >= 1) {
              mantissa = (number * c - 1) * pow(2, mantissaLength);
              exponent = exponent + eBias;
            } else {
              mantissa = number * pow(2, eBias - 1) * pow(2, mantissaLength);
              exponent = 0;
            }
          }
          for (; mantissaLength >= 8; buffer[index++] = mantissa & 255, mantissa /= 256, mantissaLength -= 8);
          exponent = exponent << mantissaLength | mantissa;
          exponentLength += mantissaLength;
          for (; exponentLength > 0; buffer[index++] = exponent & 255, exponent /= 256, exponentLength -= 8);
          buffer[--index] |= sign * 128;
          return buffer;
        };
        var unpack = function (buffer, mantissaLength) {
          var bytes = buffer.length;
          var exponentLength = bytes * 8 - mantissaLength - 1;
          var eMax = (1 << exponentLength) - 1;
          var eBias = eMax >> 1;
          var nBits = exponentLength - 7;
          var index = bytes - 1;
          var sign = buffer[index--];
          var exponent = sign & 127;
          var mantissa;
          sign >>= 7;
          for (; nBits > 0; exponent = exponent * 256 + buffer[index], index--, nBits -= 8);
          mantissa = exponent & (1 << - nBits) - 1;
          exponent >>= - nBits;
          nBits += mantissaLength;
          for (; nBits > 0; mantissa = mantissa * 256 + buffer[index], index--, nBits -= 8);
          if (exponent === 0) {
            exponent = 1 - eBias;
          } else if (exponent === eMax) {
            return mantissa ? NaN : sign ? - Infinity : Infinity;
          } else {
            mantissa = mantissa + pow(2, mantissaLength);
            exponent = exponent - eBias;
          }
          return (sign ? - 1 : 1) * mantissa * pow(2, exponent - mantissaLength);
        };
        module.exports = {
          pack: pack,
          unpack: unpack
        };
      },
      {
      }
    ],
    84: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        var classof = _dereq_('../internals/classof-raw');
        var split = ''.split; // fallback for non-array-like ES3 and non-enumerable old V8 strings
        module.exports = fails(function () {
          // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
          // eslint-disable-next-line no-prototype-builtins
          return !Object('z').propertyIsEnumerable(0);
        }) ? function (it) {
          return classof(it) == 'String' ? split.call(it, '') : Object(it);
        }
         : Object;
      },
      {
        '../internals/classof-raw': 46,
        '../internals/fails': 69
      }
    ],
    85: [
      function (_dereq_, module, exports) {
        var isObject = _dereq_('../internals/is-object');
        var setPrototypeOf = _dereq_('../internals/object-set-prototype-of'); // makes subclassing work correct for wrapped built-ins
        module.exports = function ($this, dummy, Wrapper) {
          var NewTarget,
          NewTargetPrototype;
          if ( // it can work only with native `setPrototypeOf`
          setPrototypeOf && // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
          typeof (NewTarget = dummy.constructor) == 'function' && NewTarget !== Wrapper && isObject(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype) setPrototypeOf($this, NewTargetPrototype);
          return $this;
        };
      },
      {
        '../internals/is-object': 92,
        '../internals/object-set-prototype-of': 119
      }
    ],
    86: [
      function (_dereq_, module, exports) {
        var store = _dereq_('../internals/shared-store');
        var functionToString = Function.toString; // this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper
        if (typeof store.inspectSource != 'function') {
          store.inspectSource = function (it) {
            return functionToString.call(it);
          };
        }
        module.exports = store.inspectSource;
      },
      {
        '../internals/shared-store': 137
      }
    ],
    87: [
      function (_dereq_, module, exports) {
        var hiddenKeys = _dereq_('../internals/hidden-keys');
        var isObject = _dereq_('../internals/is-object');
        var has = _dereq_('../internals/has');
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var uid = _dereq_('../internals/uid');
        var FREEZING = _dereq_('../internals/freezing');
        var METADATA = uid('meta');
        var id = 0;
        var isExtensible = Object.isExtensible || function () {
          return true;
        };
        var setMetadata = function (it) {
          defineProperty(it, METADATA, {
            value: {
              objectID: 'O' + ++id,
              // object ID
              weakData: {
              } // weak collections IDs

            }
          });
        };
        var fastKey = function (it, create) {
          // return a primitive with prefix
          if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
          if (!has(it, METADATA)) {
            // can't set metadata to uncaught frozen object
            if (!isExtensible(it)) return 'F'; // not necessary to add metadata
            if (!create) return 'E'; // add missing metadata
            setMetadata(it); // return object ID
          }
          return it[METADATA].objectID;
        };
        var getWeakData = function (it, create) {
          if (!has(it, METADATA)) {
            // can't set metadata to uncaught frozen object
            if (!isExtensible(it)) return true; // not necessary to add metadata
            if (!create) return false; // add missing metadata
            setMetadata(it); // return the store of weak collections IDs
          }
          return it[METADATA].weakData;
        }; // add metadata on freeze-family methods calling
        var onFreeze = function (it) {
          if (FREEZING && meta.REQUIRED && isExtensible(it) && !has(it, METADATA)) setMetadata(it);
          return it;
        };
        var meta = module.exports = {
          REQUIRED: false,
          fastKey: fastKey,
          getWeakData: getWeakData,
          onFreeze: onFreeze
        };
        hiddenKeys[METADATA] = true;
      },
      {
        '../internals/freezing': 71,
        '../internals/has': 78,
        '../internals/hidden-keys': 79,
        '../internals/is-object': 92,
        '../internals/object-define-property': 110,
        '../internals/uid': 163
      }
    ],
    88: [
      function (_dereq_, module, exports) {
        var NATIVE_WEAK_MAP = _dereq_('../internals/native-weak-map');
        var global = _dereq_('../internals/global');
        var isObject = _dereq_('../internals/is-object');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var objectHas = _dereq_('../internals/has');
        var sharedKey = _dereq_('../internals/shared-key');
        var hiddenKeys = _dereq_('../internals/hidden-keys');
        var WeakMap = global.WeakMap;
        var set,
        get,
        has;
        var enforce = function (it) {
          return has(it) ? get(it) : set(it, {
          });
        };
        var getterFor = function (TYPE) {
          return function (it) {
            var state;
            if (!isObject(it) || (state = get(it)).type !== TYPE) {
              throw TypeError('Incompatible receiver, ' + TYPE + ' required');
            }
            return state;
          };
        };
        if (NATIVE_WEAK_MAP) {
          var store = new WeakMap();
          var wmget = store.get;
          var wmhas = store.has;
          var wmset = store.set;
          set = function (it, metadata) {
            wmset.call(store, it, metadata);
            return metadata;
          };
          get = function (it) {
            return wmget.call(store, it) || {
            };
          };
          has = function (it) {
            return wmhas.call(store, it);
          };
        } else {
          var STATE = sharedKey('state');
          hiddenKeys[STATE] = true;
          set = function (it, metadata) {
            createNonEnumerableProperty(it, STATE, metadata);
            return metadata;
          };
          get = function (it) {
            return objectHas(it, STATE) ? it[STATE] : {
            };
          };
          has = function (it) {
            return objectHas(it, STATE);
          };
        }
        module.exports = {
          set: set,
          get: get,
          has: has,
          enforce: enforce,
          getterFor: getterFor
        };
      },
      {
        '../internals/create-non-enumerable-property': 56,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/hidden-keys': 79,
        '../internals/is-object': 92,
        '../internals/native-weak-map': 103,
        '../internals/shared-key': 136
      }
    ],
    89: [
      function (_dereq_, module, exports) {
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var Iterators = _dereq_('../internals/iterators');
        var ITERATOR = wellKnownSymbol('iterator');
        var ArrayPrototype = Array.prototype; // check on default Array iterator
        module.exports = function (it) {
          return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
        };
      },
      {
        '../internals/iterators': 97,
        '../internals/well-known-symbol': 166
      }
    ],
    90: [
      function (_dereq_, module, exports) {
        var classof = _dereq_('../internals/classof-raw'); // `IsArray` abstract operation
        // https://tc39.github.io/ecma262/#sec-isarray
        module.exports = Array.isArray || function isArray(arg) {
          return classof(arg) == 'Array';
        };
      },
      {
        '../internals/classof-raw': 46
      }
    ],
    91: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        var replacement = /#|\.prototype\./;
        var isForced = function (feature, detection) {
          var value = data[normalize(feature)];
          return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
        };
        var normalize = isForced.normalize = function (string) {
          return String(string).replace(replacement, '.').toLowerCase();
        };
        var data = isForced.data = {
        };
        var NATIVE = isForced.NATIVE = 'N';
        var POLYFILL = isForced.POLYFILL = 'P';
        module.exports = isForced;
      },
      {
        '../internals/fails': 69
      }
    ],
    92: [
      function (_dereq_, module, exports) {
        module.exports = function (it) {
          return typeof it === 'object' ? it !== null : typeof it === 'function';
        };
      },
      {
      }
    ],
    93: [
      function (_dereq_, module, exports) {
        module.exports = false;
      },
      {
      }
    ],
    94: [
      function (_dereq_, module, exports) {
        var isObject = _dereq_('../internals/is-object');
        var classof = _dereq_('../internals/classof-raw');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var MATCH = wellKnownSymbol('match'); // `IsRegExp` abstract operation
        // https://tc39.github.io/ecma262/#sec-isregexp
        module.exports = function (it) {
          var isRegExp;
          return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classof(it) == 'RegExp');
        };
      },
      {
        '../internals/classof-raw': 46,
        '../internals/is-object': 92,
        '../internals/well-known-symbol': 166
      }
    ],
    95: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object');
        var isArrayIteratorMethod = _dereq_('../internals/is-array-iterator-method');
        var toLength = _dereq_('../internals/to-length');
        var bind = _dereq_('../internals/function-bind-context');
        var getIteratorMethod = _dereq_('../internals/get-iterator-method');
        var callWithSafeIterationClosing = _dereq_('../internals/call-with-safe-iteration-closing');
        var Result = function (stopped, result) {
          this.stopped = stopped;
          this.result = result;
        };
        var iterate = module.exports = function (iterable, fn, that, AS_ENTRIES, IS_ITERATOR) {
          var boundFunction = bind(fn, that, AS_ENTRIES ? 2 : 1);
          var iterator,
          iterFn,
          index,
          length,
          result,
          next,
          step;
          if (IS_ITERATOR) {
            iterator = iterable;
          } else {
            iterFn = getIteratorMethod(iterable);
            if (typeof iterFn != 'function') throw TypeError('Target is not iterable'); // optimisation for array iterators
            if (isArrayIteratorMethod(iterFn)) {
              for (index = 0, length = toLength(iterable.length); length > index; index++) {
                result = AS_ENTRIES ? boundFunction(anObject(step = iterable[index]) [0], step[1]) : boundFunction(iterable[index]);
                if (result && result instanceof Result) return result;
              }
              return new Result(false);
            }
            iterator = iterFn.call(iterable);
          }
          next = iterator.next;
          while (!(step = next.call(iterator)).done) {
            result = callWithSafeIterationClosing(iterator, boundFunction, step.value, AS_ENTRIES);
            if (typeof result == 'object' && result && result instanceof Result) return result;
          }
          return new Result(false);
        };
        iterate.stop = function (result) {
          return new Result(true, result);
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/call-with-safe-iteration-closing': 44,
        '../internals/function-bind-context': 72,
        '../internals/get-iterator-method': 75,
        '../internals/is-array-iterator-method': 89,
        '../internals/to-length': 154
      }
    ],
    96: [
      function (_dereq_, module, exports) {
        'use strict';
        var getPrototypeOf = _dereq_('../internals/object-get-prototype-of');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var has = _dereq_('../internals/has');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var IS_PURE = _dereq_('../internals/is-pure');
        var ITERATOR = wellKnownSymbol('iterator');
        var BUGGY_SAFARI_ITERATORS = false;
        var returnThis = function () {
          return this;
        }; // `%IteratorPrototype%` object
        // https://tc39.github.io/ecma262/#sec-%iteratorprototype%-object
        var IteratorPrototype,
        PrototypeOfArrayIteratorPrototype,
        arrayIterator;
        if ([].keys) {
          arrayIterator = [
          ].keys(); // Safari 8 has buggy iterators w/o `next`
          if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
           else {
            PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
            if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
          }
        }
        if (IteratorPrototype == undefined) IteratorPrototype = {
        }; // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
        if (!IS_PURE && !has(IteratorPrototype, ITERATOR)) {
          createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
        }
        module.exports = {
          IteratorPrototype: IteratorPrototype,
          BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
        };
      },
      {
        '../internals/create-non-enumerable-property': 56,
        '../internals/has': 78,
        '../internals/is-pure': 93,
        '../internals/object-get-prototype-of': 115,
        '../internals/well-known-symbol': 166
      }
    ],
    97: [
      function (_dereq_, module, exports) {
        module.exports = {
        };
      },
      {
      }
    ],
    98: [
      function (_dereq_, module, exports) {
        // `Math.sign` method implementation
        // https://tc39.github.io/ecma262/#sec-math.sign
        module.exports = Math.sign || function sign(x) {
          // eslint-disable-next-line no-self-compare
          return (x = + x) == 0 || x != x ? x : x < 0 ? - 1 : 1;
        };
      },
      {
      }
    ],
    99: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var getOwnPropertyDescriptor = _dereq_('../internals/object-get-own-property-descriptor').f;
        var classof = _dereq_('../internals/classof-raw');
        var macrotask = _dereq_('../internals/task').set;
        var IS_IOS = _dereq_('../internals/engine-is-ios');
        var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
        var process = global.process;
        var Promise = global.Promise;
        var IS_NODE = classof(process) == 'process'; // Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
        var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
        var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
        var flush,
        head,
        last,
        notify,
        toggle,
        node,
        promise,
        then; // modern engines have queueMicrotask method
        if (!queueMicrotask) {
          flush = function () {
            var parent,
            fn;
            if (IS_NODE && (parent = process.domain)) parent.exit();
            while (head) {
              fn = head.fn;
              head = head.next;
              try {
                fn();
              } catch (error) {
                if (head) notify();
                 else last = undefined;
                throw error;
              }
            }
            last = undefined;
            if (parent) parent.enter();
          }; // Node.js
          if (IS_NODE) {
            notify = function () {
              process.nextTick(flush);
            }; // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
          } else if (MutationObserver && !IS_IOS) {
            toggle = true;
            node = document.createTextNode('');
            new MutationObserver(flush).observe(node, {
              characterData: true
            });
            notify = function () {
              node.data = toggle = !toggle;
            }; // environments with maybe non-completely correct, but existent Promise
          } else if (Promise && Promise.resolve) {
            // Promise.resolve without an argument throws an error in LG WebOS 2
            promise = Promise.resolve(undefined);
            then = promise.then;
            notify = function () {
              then.call(promise, flush);
            }; // for other environments - macrotask based on:
            // - setImmediate
            // - MessageChannel
            // - window.postMessag
            // - onreadystatechange
            // - setTimeout
          } else {
            notify = function () {
              // strange IE + webpack dev server bug - use .call(global)
              macrotask.call(global, flush);
            };
          }
        }
        module.exports = queueMicrotask || function (fn) {
          var task = {
            fn: fn,
            next: undefined
          };
          if (last) last.next = task;
          if (!head) {
            head = task;
            notify();
          }
          last = task;
        };
      },
      {
        '../internals/classof-raw': 46,
        '../internals/engine-is-ios': 64,
        '../internals/global': 77,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/task': 148
      }
    ],
    100: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        module.exports = global.Promise;
      },
      {
        '../internals/global': 77
      }
    ],
    101: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
          // Chrome 38 Symbol has incorrect toString conversion
          // eslint-disable-next-line no-undef
          return !String(Symbol());
        });
      },
      {
        '../internals/fails': 69
      }
    ],
    102: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var IS_PURE = _dereq_('../internals/is-pure');
        var ITERATOR = wellKnownSymbol('iterator');
        module.exports = !fails(function () {
          var url = new URL('b?a=1&b=2&c=3', 'http://a');
          var searchParams = url.searchParams;
          var result = '';
          url.pathname = 'c%20d';
          searchParams.forEach(function (value, key) {
            searchParams['delete']('b');
            result += key + value;
          });
          return IS_PURE && !url.toJSON || !searchParams.sort || url.href !== 'http://a/c%20d?a=1&c=3' || searchParams.get('c') !== '3' || String(new URLSearchParams('?a=1')) !== 'a=1' || !searchParams[ITERATOR] // throws in Edge
          || new URL('https://a@b').username !== 'a' || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b' // not punycoded in Edge
          || new URL('http://тест').host !== 'xn--e1aybc' // not escaped in Chrome 62-
          || new URL('http://a#б').hash !== '#%D0%B1' // fails in Chrome 66-
          || result !== 'a1c3' // throws in Safari
          || new URL('http://x', undefined).host !== 'x';
        });
      },
      {
        '../internals/fails': 69,
        '../internals/is-pure': 93,
        '../internals/well-known-symbol': 166
      }
    ],
    103: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var inspectSource = _dereq_('../internals/inspect-source');
        var WeakMap = global.WeakMap;
        module.exports = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));
      },
      {
        '../internals/global': 77,
        '../internals/inspect-source': 86
      }
    ],
    104: [
      function (_dereq_, module, exports) {
        'use strict';
        var aFunction = _dereq_('../internals/a-function');
        var PromiseCapability = function (C) {
          var resolve,
          reject;
          this.promise = new C(function ($$resolve, $$reject) {
            if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
            resolve = $$resolve;
            reject = $$reject;
          });
          this.resolve = aFunction(resolve);
          this.reject = aFunction(reject);
        }; // 25.4.1.5 NewPromiseCapability(C)
        module.exports.f = function (C) {
          return new PromiseCapability(C);
        };
      },
      {
        '../internals/a-function': 23
      }
    ],
    105: [
      function (_dereq_, module, exports) {
        var isRegExp = _dereq_('../internals/is-regexp');
        module.exports = function (it) {
          if (isRegExp(it)) {
            throw TypeError('The method doesn\'t accept regular expressions');
          }
          return it;
        };
      },
      {
        '../internals/is-regexp': 94
      }
    ],
    106: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var globalIsFinite = global.isFinite; // `Number.isFinite` method
        // https://tc39.github.io/ecma262/#sec-number.isfinite
        module.exports = Number.isFinite || function isFinite(it) {
          return typeof it == 'number' && globalIsFinite(it);
        };
      },
      {
        '../internals/global': 77
      }
    ],
    107: [
      function (_dereq_, module, exports) {
        'use strict';
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var fails = _dereq_('../internals/fails');
        var objectKeys = _dereq_('../internals/object-keys');
        var getOwnPropertySymbolsModule = _dereq_('../internals/object-get-own-property-symbols');
        var propertyIsEnumerableModule = _dereq_('../internals/object-property-is-enumerable');
        var toObject = _dereq_('../internals/to-object');
        var IndexedObject = _dereq_('../internals/indexed-object');
        var nativeAssign = Object.assign;
        var defineProperty = Object.defineProperty; // `Object.assign` method
        // https://tc39.github.io/ecma262/#sec-object.assign
        module.exports = !nativeAssign || fails(function () {
          // should have correct order of operations (Edge bug)
          if (DESCRIPTORS && nativeAssign({
            b: 1
          }, nativeAssign(defineProperty({
          }, 'a', {
            enumerable: true,
            get: function () {
              defineProperty(this, 'b', {
                value: 3,
                enumerable: false
              });
            }
          }), {
            b: 2
          })).b !== 1) return true; // should work with symbols and should have deterministic property order (V8 bug)
          var A = {
          };
          var B = {
          }; // eslint-disable-next-line no-undef
          var symbol = Symbol();
          var alphabet = 'abcdefghijklmnopqrst';
          A[symbol] = 7;
          alphabet.split('').forEach(function (chr) {
            B[chr] = chr;
          });
          return nativeAssign({
          }, A) [symbol] != 7 || objectKeys(nativeAssign({
          }, B)).join('') != alphabet;
        }) ? function assign(target, source) {
          // eslint-disable-line no-unused-vars
          var T = toObject(target);
          var argumentsLength = arguments.length;
          var index = 1;
          var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
          var propertyIsEnumerable = propertyIsEnumerableModule.f;
          while (argumentsLength > index) {
            var S = IndexedObject(arguments[index++]);
            var keys = getOwnPropertySymbols ? objectKeys(S).concat(getOwnPropertySymbols(S)) : objectKeys(S);
            var length = keys.length;
            var j = 0;
            var key;
            while (length > j) {
              key = keys[j++];
              if (!DESCRIPTORS || propertyIsEnumerable.call(S, key)) T[key] = S[key];
            }
          }
          return T;
        }
         : nativeAssign;
      },
      {
        '../internals/descriptors': 61,
        '../internals/fails': 69,
        '../internals/indexed-object': 84,
        '../internals/object-get-own-property-symbols': 114,
        '../internals/object-keys': 117,
        '../internals/object-property-is-enumerable': 118,
        '../internals/to-object': 155
      }
    ],
    108: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object');
        var defineProperties = _dereq_('../internals/object-define-properties');
        var enumBugKeys = _dereq_('../internals/enum-bug-keys');
        var hiddenKeys = _dereq_('../internals/hidden-keys');
        var html = _dereq_('../internals/html');
        var documentCreateElement = _dereq_('../internals/document-create-element');
        var sharedKey = _dereq_('../internals/shared-key');
        var GT = '>';
        var LT = '<';
        var PROTOTYPE = 'prototype';
        var SCRIPT = 'script';
        var IE_PROTO = sharedKey('IE_PROTO');
        var EmptyConstructor = function () {
          /* empty */
        };
        var scriptTag = function (content) {
          return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
        }; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype
        var NullProtoObjectViaActiveX = function (activeXDocument) {
          activeXDocument.write(scriptTag(''));
          activeXDocument.close();
          var temp = activeXDocument.parentWindow.Object;
          activeXDocument = null; // avoid memory leak
          return temp;
        }; // Create object with fake `null` prototype: use iframe Object with cleared prototype
        var NullProtoObjectViaIFrame = function () {
          // Thrash, waste and sodomy: IE GC bug
          var iframe = documentCreateElement('iframe');
          var JS = 'java' + SCRIPT + ':';
          var iframeDocument;
          iframe.style.display = 'none';
          html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475
          iframe.src = String(JS);
          iframeDocument = iframe.contentWindow.document;
          iframeDocument.open();
          iframeDocument.write(scriptTag('document.F=Object'));
          iframeDocument.close();
          return iframeDocument.F;
        }; // Check for document.domain and active x support
        // No need to use active x approach when document.domain is not set
        // see https://github.com/es-shims/es5-shim/issues/150
        // variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
        // avoid IE GC bug
        var activeXDocument;
        var NullProtoObject = function () {
          try {
            /* global ActiveXObject */
            activeXDocument = document.domain && new ActiveXObject('htmlfile');
          } catch (error) {
            /* ignore */
          }
          NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
          var length = enumBugKeys.length;
          while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
          return NullProtoObject();
        };
        hiddenKeys[IE_PROTO] = true; // `Object.create` method
        // https://tc39.github.io/ecma262/#sec-object.create
        module.exports = Object.create || function create(O, Properties) {
          var result;
          if (O !== null) {
            EmptyConstructor[PROTOTYPE] = anObject(O);
            result = new EmptyConstructor();
            EmptyConstructor[PROTOTYPE] = null; // add "__proto__" for Object.getPrototypeOf polyfill
            result[IE_PROTO] = O;
          } else result = NullProtoObject();
          return Properties === undefined ? result : defineProperties(result, Properties);
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/document-create-element': 62,
        '../internals/enum-bug-keys': 67,
        '../internals/hidden-keys': 79,
        '../internals/html': 81,
        '../internals/object-define-properties': 109,
        '../internals/shared-key': 136
      }
    ],
    109: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var anObject = _dereq_('../internals/an-object');
        var objectKeys = _dereq_('../internals/object-keys'); // `Object.defineProperties` method
        // https://tc39.github.io/ecma262/#sec-object.defineproperties
        module.exports = DESCRIPTORS ? Object.defineProperties : function defineProperties(O, Properties) {
          anObject(O);
          var keys = objectKeys(Properties);
          var length = keys.length;
          var index = 0;
          var key;
          while (length > index) definePropertyModule.f(O, key = keys[index++], Properties[key]);
          return O;
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/descriptors': 61,
        '../internals/object-define-property': 110,
        '../internals/object-keys': 117
      }
    ],
    110: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var IE8_DOM_DEFINE = _dereq_('../internals/ie8-dom-define');
        var anObject = _dereq_('../internals/an-object');
        var toPrimitive = _dereq_('../internals/to-primitive');
        var nativeDefineProperty = Object.defineProperty; // `Object.defineProperty` method
        // https://tc39.github.io/ecma262/#sec-object.defineproperty
        exports.f = DESCRIPTORS ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
          anObject(O);
          P = toPrimitive(P, true);
          anObject(Attributes);
          if (IE8_DOM_DEFINE) try {
            return nativeDefineProperty(O, P, Attributes);
          } catch (error) {
            /* empty */
          }
          if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
          if ('value' in Attributes) O[P] = Attributes.value;
          return O;
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/descriptors': 61,
        '../internals/ie8-dom-define': 82,
        '../internals/to-primitive': 158
      }
    ],
    111: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var propertyIsEnumerableModule = _dereq_('../internals/object-property-is-enumerable');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var toPrimitive = _dereq_('../internals/to-primitive');
        var has = _dereq_('../internals/has');
        var IE8_DOM_DEFINE = _dereq_('../internals/ie8-dom-define');
        var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
        // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor
        exports.f = DESCRIPTORS ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
          O = toIndexedObject(O);
          P = toPrimitive(P, true);
          if (IE8_DOM_DEFINE) try {
            return nativeGetOwnPropertyDescriptor(O, P);
          } catch (error) {
            /* empty */
          }
          if (has(O, P)) return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
        };
      },
      {
        '../internals/create-property-descriptor': 57,
        '../internals/descriptors': 61,
        '../internals/has': 78,
        '../internals/ie8-dom-define': 82,
        '../internals/object-property-is-enumerable': 118,
        '../internals/to-indexed-object': 152,
        '../internals/to-primitive': 158
      }
    ],
    112: [
      function (_dereq_, module, exports) {
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var nativeGetOwnPropertyNames = _dereq_('../internals/object-get-own-property-names').f;
        var toString = {
        }.toString;
        var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [
        ];
        var getWindowNames = function (it) {
          try {
            return nativeGetOwnPropertyNames(it);
          } catch (error) {
            return windowNames.slice();
          }
        }; // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
        module.exports.f = function getOwnPropertyNames(it) {
          return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : nativeGetOwnPropertyNames(toIndexedObject(it));
        };
      },
      {
        '../internals/object-get-own-property-names': 113,
        '../internals/to-indexed-object': 152
      }
    ],
    113: [
      function (_dereq_, module, exports) {
        var internalObjectKeys = _dereq_('../internals/object-keys-internal');
        var enumBugKeys = _dereq_('../internals/enum-bug-keys');
        var hiddenKeys = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
        // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
        exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
          return internalObjectKeys(O, hiddenKeys);
        };
      },
      {
        '../internals/enum-bug-keys': 67,
        '../internals/object-keys-internal': 116
      }
    ],
    114: [
      function (_dereq_, module, exports) {
        exports.f = Object.getOwnPropertySymbols;
      },
      {
      }
    ],
    115: [
      function (_dereq_, module, exports) {
        var has = _dereq_('../internals/has');
        var toObject = _dereq_('../internals/to-object');
        var sharedKey = _dereq_('../internals/shared-key');
        var CORRECT_PROTOTYPE_GETTER = _dereq_('../internals/correct-prototype-getter');
        var IE_PROTO = sharedKey('IE_PROTO');
        var ObjectPrototype = Object.prototype; // `Object.getPrototypeOf` method
        // https://tc39.github.io/ecma262/#sec-object.getprototypeof
        module.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function (O) {
          O = toObject(O);
          if (has(O, IE_PROTO)) return O[IE_PROTO];
          if (typeof O.constructor == 'function' && O instanceof O.constructor) {
            return O.constructor.prototype;
          }
          return O instanceof Object ? ObjectPrototype : null;
        };
      },
      {
        '../internals/correct-prototype-getter': 53,
        '../internals/has': 78,
        '../internals/shared-key': 136,
        '../internals/to-object': 155
      }
    ],
    116: [
      function (_dereq_, module, exports) {
        var has = _dereq_('../internals/has');
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var indexOf = _dereq_('../internals/array-includes').indexOf;
        var hiddenKeys = _dereq_('../internals/hidden-keys');
        module.exports = function (object, names) {
          var O = toIndexedObject(object);
          var i = 0;
          var result = [
          ];
          var key;
          for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key); // Don't enum bug & hidden keys
          while (names.length > i) if (has(O, key = names[i++])) {
            ~indexOf(result, key) || result.push(key);
          }
          return result;
        };
      },
      {
        '../internals/array-includes': 36,
        '../internals/has': 78,
        '../internals/hidden-keys': 79,
        '../internals/to-indexed-object': 152
      }
    ],
    117: [
      function (_dereq_, module, exports) {
        var internalObjectKeys = _dereq_('../internals/object-keys-internal');
        var enumBugKeys = _dereq_('../internals/enum-bug-keys'); // `Object.keys` method
        // https://tc39.github.io/ecma262/#sec-object.keys
        module.exports = Object.keys || function keys(O) {
          return internalObjectKeys(O, enumBugKeys);
        };
      },
      {
        '../internals/enum-bug-keys': 67,
        '../internals/object-keys-internal': 116
      }
    ],
    118: [
      function (_dereq_, module, exports) {
        'use strict';
        var nativePropertyIsEnumerable = {
        }.propertyIsEnumerable;
        var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug
        var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({
          1: 2
        }, 1); // `Object.prototype.propertyIsEnumerable` method implementation
        // https://tc39.github.io/ecma262/#sec-object.prototype.propertyisenumerable
        exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
          var descriptor = getOwnPropertyDescriptor(this, V);
          return !!descriptor && descriptor.enumerable;
        }
         : nativePropertyIsEnumerable;
      },
      {
      }
    ],
    119: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object');
        var aPossiblePrototype = _dereq_('../internals/a-possible-prototype'); // `Object.setPrototypeOf` method
        // https://tc39.github.io/ecma262/#sec-object.setprototypeof
        // Works with __proto__ only. Old v8 can't work with null proto objects.
        /* eslint-disable no-proto */
        module.exports = Object.setPrototypeOf || ('__proto__' in {
        }
        ? function () {
          var CORRECT_SETTER = false;
          var test = {
          };
          var setter;
          try {
            setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
            setter.call(test, [
            ]);
            CORRECT_SETTER = test instanceof Array;
          } catch (error) {
            /* empty */
          }
          return function setPrototypeOf(O, proto) {
            anObject(O);
            aPossiblePrototype(proto);
            if (CORRECT_SETTER) setter.call(O, proto);
             else O.__proto__ = proto;
            return O;
          };
        }() : undefined);
      },
      {
        '../internals/a-possible-prototype': 24,
        '../internals/an-object': 28
      }
    ],
    120: [
      function (_dereq_, module, exports) {
        'use strict';
        var TO_STRING_TAG_SUPPORT = _dereq_('../internals/to-string-tag-support');
        var classof = _dereq_('../internals/classof'); // `Object.prototype.toString` method implementation
        // https://tc39.github.io/ecma262/#sec-object.prototype.tostring
        module.exports = TO_STRING_TAG_SUPPORT ? {
        }.toString : function toString() {
          return '[object ' + classof(this) + ']';
        };
      },
      {
        '../internals/classof': 47,
        '../internals/to-string-tag-support': 159
      }
    ],
    121: [
      function (_dereq_, module, exports) {
        var getBuiltIn = _dereq_('../internals/get-built-in');
        var getOwnPropertyNamesModule = _dereq_('../internals/object-get-own-property-names');
        var getOwnPropertySymbolsModule = _dereq_('../internals/object-get-own-property-symbols');
        var anObject = _dereq_('../internals/an-object'); // all object keys, includes non-enumerable and symbols
        module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
          var keys = getOwnPropertyNamesModule.f(anObject(it));
          var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
          return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/get-built-in': 74,
        '../internals/object-get-own-property-names': 113,
        '../internals/object-get-own-property-symbols': 114
      }
    ],
    122: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        module.exports = global;
      },
      {
        '../internals/global': 77
      }
    ],
    123: [
      function (_dereq_, module, exports) {
        module.exports = function (exec) {
          try {
            return {
              error: false,
              value: exec()
            };
          } catch (error) {
            return {
              error: true,
              value: error
            };
          }
        };
      },
      {
      }
    ],
    124: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object');
        var isObject = _dereq_('../internals/is-object');
        var newPromiseCapability = _dereq_('../internals/new-promise-capability');
        module.exports = function (C, x) {
          anObject(C);
          if (isObject(x) && x.constructor === C) return x;
          var promiseCapability = newPromiseCapability.f(C);
          var resolve = promiseCapability.resolve;
          resolve(x);
          return promiseCapability.promise;
        };
      },
      {
        '../internals/an-object': 28,
        '../internals/is-object': 92,
        '../internals/new-promise-capability': 104
      }
    ],
    125: [
      function (_dereq_, module, exports) {
        var redefine = _dereq_('../internals/redefine');
        module.exports = function (target, src, options) {
          for (var key in src) redefine(target, key, src[key], options);
          return target;
        };
      },
      {
        '../internals/redefine': 126
      }
    ],
    126: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var has = _dereq_('../internals/has');
        var setGlobal = _dereq_('../internals/set-global');
        var inspectSource = _dereq_('../internals/inspect-source');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var getInternalState = InternalStateModule.get;
        var enforceInternalState = InternalStateModule.enforce;
        var TEMPLATE = String(String).split('String');
        (module.exports = function (O, key, value, options) {
          var unsafe = options ? !!options.unsafe : false;
          var simple = options ? !!options.enumerable : false;
          var noTargetGet = options ? !!options.noTargetGet : false;
          if (typeof value == 'function') {
            if (typeof key == 'string' && !has(value, 'name')) createNonEnumerableProperty(value, 'name', key);
            enforceInternalState(value).source = TEMPLATE.join(typeof key == 'string' ? key : '');
          }
          if (O === global) {
            if (simple) O[key] = value;
             else setGlobal(key, value);
            return;
          } else if (!unsafe) {
            delete O[key];
          } else if (!noTargetGet && O[key]) {
            simple = true;
          }
          if (simple) O[key] = value;
           else createNonEnumerableProperty(O, key, value); // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
        }) (Function.prototype, 'toString', function toString() {
          return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
        });
      },
      {
        '../internals/create-non-enumerable-property': 56,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/inspect-source': 86,
        '../internals/internal-state': 88,
        '../internals/set-global': 133
      }
    ],
    127: [
      function (_dereq_, module, exports) {
        var classof = _dereq_('./classof-raw');
        var regexpExec = _dereq_('./regexp-exec'); // `RegExpExec` abstract operation
        // https://tc39.github.io/ecma262/#sec-regexpexec
        module.exports = function (R, S) {
          var exec = R.exec;
          if (typeof exec === 'function') {
            var result = exec.call(R, S);
            if (typeof result !== 'object') {
              throw TypeError('RegExp exec method returned something other than an Object or null');
            }
            return result;
          }
          if (classof(R) !== 'RegExp') {
            throw TypeError('RegExp#exec called on incompatible receiver');
          }
          return regexpExec.call(R, S);
        };
      },
      {
        './classof-raw': 46,
        './regexp-exec': 128
      }
    ],
    128: [
      function (_dereq_, module, exports) {
        'use strict';
        var regexpFlags = _dereq_('./regexp-flags');
        var stickyHelpers = _dereq_('./regexp-sticky-helpers');
        var nativeExec = RegExp.prototype.exec; // This always refers to the native implementation, because the
        // String#replace polyfill uses ./fix-regexp-well-known-symbol-logic.js,
        // which loads this file before patching the method.
        var nativeReplace = String.prototype.replace;
        var patchedExec = nativeExec;
        var UPDATES_LAST_INDEX_WRONG = function () {
          var re1 = /a/;
          var re2 = /b*/g;
          nativeExec.call(re1, 'a');
          nativeExec.call(re2, 'a');
          return re1.lastIndex !== 0 || re2.lastIndex !== 0;
        }();
        var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y || stickyHelpers.BROKEN_CARET; // nonparticipating capturing group, copied from es5-shim's String#split patch.
        var NPCG_INCLUDED = /()??/.exec('') [1] !== undefined;
        var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y;
        if (PATCH) {
          patchedExec = function exec(str) {
            var re = this;
            var lastIndex,
            reCopy,
            match,
            i;
            var sticky = UNSUPPORTED_Y && re.sticky;
            var flags = regexpFlags.call(re);
            var source = re.source;
            var charsAdded = 0;
            var strCopy = str;
            if (sticky) {
              flags = flags.replace('y', '');
              if (flags.indexOf('g') === - 1) {
                flags += 'g';
              }
              strCopy = String(str).slice(re.lastIndex); // Support anchored sticky behavior.
              if (re.lastIndex > 0 && (!re.multiline || re.multiline && str[re.lastIndex - 1] !== '\n')) {
                source = '(?: ' + source + ')';
                strCopy = ' ' + strCopy;
                charsAdded++;
              } // ^(? + rx + ) is needed, in combination with some str slicing, to
              // simulate the 'y' flag.

              reCopy = new RegExp('^(?:' + source + ')', flags);
            }
            if (NPCG_INCLUDED) {
              reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
            }
            if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
            match = nativeExec.call(sticky ? reCopy : re, strCopy);
            if (sticky) {
              if (match) {
                match.input = match.input.slice(charsAdded);
                match[0] = match[0].slice(charsAdded);
                match.index = re.lastIndex;
                re.lastIndex += match[0].length;
              } else re.lastIndex = 0;
            } else if (UPDATES_LAST_INDEX_WRONG && match) {
              re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
            }
            if (NPCG_INCLUDED && match && match.length > 1) {
              // Fix browsers whose `exec` methods don't consistently return `undefined`
              // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
              nativeReplace.call(match[0], reCopy, function () {
                for (i = 1; i < arguments.length - 2; i++) {
                  if (arguments[i] === undefined) match[i] = undefined;
                }
              });
            }
            return match;
          };
        }
        module.exports = patchedExec;
      },
      {
        './regexp-flags': 129,
        './regexp-sticky-helpers': 130
      }
    ],
    129: [
      function (_dereq_, module, exports) {
        'use strict';
        var anObject = _dereq_('../internals/an-object'); // `RegExp.prototype.flags` getter implementation
        // https://tc39.github.io/ecma262/#sec-get-regexp.prototype.flags
        module.exports = function () {
          var that = anObject(this);
          var result = '';
          if (that.global) result += 'g';
          if (that.ignoreCase) result += 'i';
          if (that.multiline) result += 'm';
          if (that.dotAll) result += 's';
          if (that.unicode) result += 'u';
          if (that.sticky) result += 'y';
          return result;
        };
      },
      {
        '../internals/an-object': 28
      }
    ],
    130: [
      function (_dereq_, module, exports) {
        'use strict';
        var fails = _dereq_('./fails'); // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError,
        // so we use an intermediate function.
        function RE(s, f) {
          return RegExp(s, f);
        }
        exports.UNSUPPORTED_Y = fails(function () {
          // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
          var re = RE('a', 'y');
          re.lastIndex = 2;
          return re.exec('abcd') != null;
        });
        exports.BROKEN_CARET = fails(function () {
          // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
          var re = RE('^r', 'gy');
          re.lastIndex = 2;
          return re.exec('str') != null;
        });
      },
      {
        './fails': 69
      }
    ],
    131: [
      function (_dereq_, module, exports) {
        // `RequireObjectCoercible` abstract operation
        // https://tc39.github.io/ecma262/#sec-requireobjectcoercible
        module.exports = function (it) {
          if (it == undefined) throw TypeError('Can\'t call method on ' + it);
          return it;
        };
      },
      {
      }
    ],
    132: [
      function (_dereq_, module, exports) {
        // `SameValue` abstract operation
        // https://tc39.github.io/ecma262/#sec-samevalue
        module.exports = Object.is || function is(x, y) {
          // eslint-disable-next-line no-self-compare
          return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
        };
      },
      {
      }
    ],
    133: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        module.exports = function (key, value) {
          try {
            createNonEnumerableProperty(global, key, value);
          } catch (error) {
            global[key] = value;
          }
          return value;
        };
      },
      {
        '../internals/create-non-enumerable-property': 56,
        '../internals/global': 77
      }
    ],
    134: [
      function (_dereq_, module, exports) {
        'use strict';
        var getBuiltIn = _dereq_('../internals/get-built-in');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var SPECIES = wellKnownSymbol('species');
        module.exports = function (CONSTRUCTOR_NAME) {
          var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
          var defineProperty = definePropertyModule.f;
          if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
            defineProperty(Constructor, SPECIES, {
              configurable: true,
              get: function () {
                return this;
              }
            });
          }
        };
      },
      {
        '../internals/descriptors': 61,
        '../internals/get-built-in': 74,
        '../internals/object-define-property': 110,
        '../internals/well-known-symbol': 166
      }
    ],
    135: [
      function (_dereq_, module, exports) {
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var has = _dereq_('../internals/has');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var TO_STRING_TAG = wellKnownSymbol('toStringTag');
        module.exports = function (it, TAG, STATIC) {
          if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
            defineProperty(it, TO_STRING_TAG, {
              configurable: true,
              value: TAG
            });
          }
        };
      },
      {
        '../internals/has': 78,
        '../internals/object-define-property': 110,
        '../internals/well-known-symbol': 166
      }
    ],
    136: [
      function (_dereq_, module, exports) {
        var shared = _dereq_('../internals/shared');
        var uid = _dereq_('../internals/uid');
        var keys = shared('keys');
        module.exports = function (key) {
          return keys[key] || (keys[key] = uid(key));
        };
      },
      {
        '../internals/shared': 138,
        '../internals/uid': 163
      }
    ],
    137: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var setGlobal = _dereq_('../internals/set-global');
        var SHARED = '__core-js_shared__';
        var store = global[SHARED] || setGlobal(SHARED, {
        });
        module.exports = store;
      },
      {
        '../internals/global': 77,
        '../internals/set-global': 133
      }
    ],
    138: [
      function (_dereq_, module, exports) {
        var IS_PURE = _dereq_('../internals/is-pure');
        var store = _dereq_('../internals/shared-store');
        (module.exports = function (key, value) {
          return store[key] || (store[key] = value !== undefined ? value : {
          });
        }) ('versions', [
        ]).push({
          version: '3.6.5',
          mode: IS_PURE ? 'pure' : 'global',
          copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
        });
      },
      {
        '../internals/is-pure': 93,
        '../internals/shared-store': 137
      }
    ],
    139: [
      function (_dereq_, module, exports) {
        var anObject = _dereq_('../internals/an-object');
        var aFunction = _dereq_('../internals/a-function');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var SPECIES = wellKnownSymbol('species'); // `SpeciesConstructor` abstract operation
        // https://tc39.github.io/ecma262/#sec-speciesconstructor
        module.exports = function (O, defaultConstructor) {
          var C = anObject(O).constructor;
          var S;
          return C === undefined || (S = anObject(C) [SPECIES]) == undefined ? defaultConstructor : aFunction(S);
        };
      },
      {
        '../internals/a-function': 23,
        '../internals/an-object': 28,
        '../internals/well-known-symbol': 166
      }
    ],
    140: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails'); // check the existence of a method, lowercase
        // of a tag and escaping quotes in arguments
        module.exports = function (METHOD_NAME) {
          return fails(function () {
            var test = ''[METHOD_NAME]('"');
            return test !== test.toLowerCase() || test.split('"').length > 3;
          });
        };
      },
      {
        '../internals/fails': 69
      }
    ],
    141: [
      function (_dereq_, module, exports) {
        var toInteger = _dereq_('../internals/to-integer');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible'); // `String.prototype.{ codePointAt, at }` methods implementation
        var createMethod = function (CONVERT_TO_STRING) {
          return function ($this, pos) {
            var S = String(requireObjectCoercible($this));
            var position = toInteger(pos);
            var size = S.length;
            var first,
            second;
            if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
            first = S.charCodeAt(position);
            return first < 55296 || first > 56319 || position + 1 === size || (second = S.charCodeAt(position + 1)) < 56320 || second > 57343 ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 55296 << 10) + (second - 56320) + 65536;
          };
        };
        module.exports = {
          // `String.prototype.codePointAt` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.codepointat
          codeAt: createMethod(false),
          // `String.prototype.at` method
          // https://github.com/mathiasbynens/String.prototype.at
          charAt: createMethod(true)
        };
      },
      {
        '../internals/require-object-coercible': 131,
        '../internals/to-integer': 153
      }
    ],
    142: [
      function (_dereq_, module, exports) {
        // https://github.com/zloirock/core-js/issues/280
        var userAgent = _dereq_('../internals/engine-user-agent'); // eslint-disable-next-line unicorn/no-unsafe-regex
        module.exports = /Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(userAgent);
      },
      {
        '../internals/engine-user-agent': 65
      }
    ],
    143: [
      function (_dereq_, module, exports) {
        // https://github.com/tc39/proposal-string-pad-start-end
        var toLength = _dereq_('../internals/to-length');
        var repeat = _dereq_('../internals/string-repeat');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var ceil = Math.ceil; // `String.prototype.{ padStart, padEnd }` methods implementation
        var createMethod = function (IS_END) {
          return function ($this, maxLength, fillString) {
            var S = String(requireObjectCoercible($this));
            var stringLength = S.length;
            var fillStr = fillString === undefined ? ' ' : String(fillString);
            var intMaxLength = toLength(maxLength);
            var fillLen,
            stringFiller;
            if (intMaxLength <= stringLength || fillStr == '') return S;
            fillLen = intMaxLength - stringLength;
            stringFiller = repeat.call(fillStr, ceil(fillLen / fillStr.length));
            if (stringFiller.length > fillLen) stringFiller = stringFiller.slice(0, fillLen);
            return IS_END ? S + stringFiller : stringFiller + S;
          };
        };
        module.exports = {
          // `String.prototype.padStart` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.padstart
          start: createMethod(false),
          // `String.prototype.padEnd` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.padend
          end: createMethod(true)
        };
      },
      {
        '../internals/require-object-coercible': 131,
        '../internals/string-repeat': 145,
        '../internals/to-length': 154
      }
    ],
    144: [
      function (_dereq_, module, exports) {
        'use strict'; // based on https://github.com/bestiejs/punycode.js/blob/master/punycode.js
        var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1
        var base = 36;
        var tMin = 1;
        var tMax = 26;
        var skew = 38;
        var damp = 700;
        var initialBias = 72;
        var initialN = 128; // 0x80
        var delimiter = '-'; // '\x2D'
        var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars
        var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators
        var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
        var baseMinusTMin = base - tMin;
        var floor = Math.floor;
        var stringFromCharCode = String.fromCharCode;
        /**
 * Creates an array containing the numeric code points of each Unicode
 * character in the string. While JavaScript uses UCS-2 internally,
 * this function will convert a pair of surrogate halves (each of which
 * UCS-2 exposes as separate characters) into a single code point,
 * matching UTF-16.
 */
        var ucs2decode = function (string) {
          var output = [
          ];
          var counter = 0;
          var length = string.length;
          while (counter < length) {
            var value = string.charCodeAt(counter++);
            if (value >= 55296 && value <= 56319 && counter < length) {
              // It's a high surrogate, and there is a next character.
              var extra = string.charCodeAt(counter++);
              if ((extra & 64512) == 56320) {
                // Low surrogate.
                output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
              } else {
                // It's an unmatched surrogate; only append this code unit, in case the
                // next code unit is the high surrogate of a surrogate pair.
                output.push(value);
                counter--;
              }
            } else {
              output.push(value);
            }
          }
          return output;
        };
        /**
 * Converts a digit/integer into a basic code point.
 */
        var digitToBasic = function (digit) {
          //  0..25 map to ASCII a..z or A..Z
          // 26..35 map to ASCII 0..9
          return digit + 22 + 75 * (digit < 26);
        };
        /**
 * Bias adaptation function as per section 3.4 of RFC 3492.
 * https://tools.ietf.org/html/rfc3492#section-3.4
 */
        var adapt = function (delta, numPoints, firstTime) {
          var k = 0;
          delta = firstTime ? floor(delta / damp) : delta >> 1;
          delta += floor(delta / numPoints);
          for (; delta > baseMinusTMin * tMax >> 1; k += base) {
            delta = floor(delta / baseMinusTMin);
          }
          return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
        };
        /**
 * Converts a string of Unicode symbols (e.g. a domain name label) to a
 * Punycode string of ASCII-only symbols.
 */
        // eslint-disable-next-line  max-statements
        var encode = function (input) {
          var output = [
          ]; // Convert the input in UCS-2 to an array of Unicode code points.
          input = ucs2decode(input); // Cache the length.
          var inputLength = input.length; // Initialize the state.
          var n = initialN;
          var delta = 0;
          var bias = initialBias;
          var i,
          currentValue; // Handle the basic code points.
          for (i = 0; i < input.length; i++) {
            currentValue = input[i];
            if (currentValue < 128) {
              output.push(stringFromCharCode(currentValue));
            }
          }
          var basicLength = output.length; // number of basic code points.
          var handledCPCount = basicLength; // number of code points that have been handled;
          // Finish the basic string with a delimiter unless it's empty.
          if (basicLength) {
            output.push(delimiter);
          } // Main encoding loop:

          while (handledCPCount < inputLength) {
            // All non-basic code points < n have been handled already. Find the next larger one:
            var m = maxInt;
            for (i = 0; i < input.length; i++) {
              currentValue = input[i];
              if (currentValue >= n && currentValue < m) {
                m = currentValue;
              }
            } // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.

            var handledCPCountPlusOne = handledCPCount + 1;
            if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
              throw RangeError(OVERFLOW_ERROR);
            }
            delta += (m - n) * handledCPCountPlusOne;
            n = m;
            for (i = 0; i < input.length; i++) {
              currentValue = input[i];
              if (currentValue < n && ++delta > maxInt) {
                throw RangeError(OVERFLOW_ERROR);
              }
              if (currentValue == n) {
                // Represent delta as a generalized variable-length integer.
                var q = delta;
                for (var k = base; ;                /* no condition */
                k += base) {
                  var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                  if (q < t) break;
                  var qMinusT = q - t;
                  var baseMinusT = base - t;
                  output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
                  q = floor(qMinusT / baseMinusT);
                }
                output.push(stringFromCharCode(digitToBasic(q)));
                bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                delta = 0;
                ++handledCPCount;
              }
            }
            ++delta;
            ++n;
          }
          return output.join('');
        };
        module.exports = function (input) {
          var encoded = [
          ];
          var labels = input.toLowerCase().replace(regexSeparators, '.').split('.');
          var i,
          label;
          for (i = 0; i < labels.length; i++) {
            label = labels[i];
            encoded.push(regexNonASCII.test(label) ? 'xn--' + encode(label) : label);
          }
          return encoded.join('.');
        };
      },
      {
      }
    ],
    145: [
      function (_dereq_, module, exports) {
        'use strict';
        var toInteger = _dereq_('../internals/to-integer');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible'); // `String.prototype.repeat` method implementation
        // https://tc39.github.io/ecma262/#sec-string.prototype.repeat
        module.exports = ''.repeat || function repeat(count) {
          var str = String(requireObjectCoercible(this));
          var result = '';
          var n = toInteger(count);
          if (n < 0 || n == Infinity) throw RangeError('Wrong number of repetitions');
          for (; n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
          return result;
        };
      },
      {
        '../internals/require-object-coercible': 131,
        '../internals/to-integer': 153
      }
    ],
    146: [
      function (_dereq_, module, exports) {
        var fails = _dereq_('../internals/fails');
        var whitespaces = _dereq_('../internals/whitespaces');
        var non = '​᠎'; // check that a method works with the correct list
        // of whitespaces and has a correct name
        module.exports = function (METHOD_NAME) {
          return fails(function () {
            return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces[METHOD_NAME].name !== METHOD_NAME;
          });
        };
      },
      {
        '../internals/fails': 69,
        '../internals/whitespaces': 167
      }
    ],
    147: [
      function (_dereq_, module, exports) {
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var whitespaces = _dereq_('../internals/whitespaces');
        var whitespace = '[' + whitespaces + ']';
        var ltrim = RegExp('^' + whitespace + whitespace + '*');
        var rtrim = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
        var createMethod = function (TYPE) {
          return function ($this) {
            var string = String(requireObjectCoercible($this));
            if (TYPE & 1) string = string.replace(ltrim, '');
            if (TYPE & 2) string = string.replace(rtrim, '');
            return string;
          };
        };
        module.exports = {
          // `String.prototype.{ trimLeft, trimStart }` methods
          // https://tc39.github.io/ecma262/#sec-string.prototype.trimstart
          start: createMethod(1),
          // `String.prototype.{ trimRight, trimEnd }` methods
          // https://tc39.github.io/ecma262/#sec-string.prototype.trimend
          end: createMethod(2),
          // `String.prototype.trim` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.trim
          trim: createMethod(3)
        };
      },
      {
        '../internals/require-object-coercible': 131,
        '../internals/whitespaces': 167
      }
    ],
    148: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var fails = _dereq_('../internals/fails');
        var classof = _dereq_('../internals/classof-raw');
        var bind = _dereq_('../internals/function-bind-context');
        var html = _dereq_('../internals/html');
        var createElement = _dereq_('../internals/document-create-element');
        var IS_IOS = _dereq_('../internals/engine-is-ios');
        var location = global.location;
        var set = global.setImmediate;
        var clear = global.clearImmediate;
        var process = global.process;
        var MessageChannel = global.MessageChannel;
        var Dispatch = global.Dispatch;
        var counter = 0;
        var queue = {
        };
        var ONREADYSTATECHANGE = 'onreadystatechange';
        var defer,
        channel,
        port;
        var run = function (id) {
          // eslint-disable-next-line no-prototype-builtins
          if (queue.hasOwnProperty(id)) {
            var fn = queue[id];
            delete queue[id];
            fn();
          }
        };
        var runner = function (id) {
          return function () {
            run(id);
          };
        };
        var listener = function (event) {
          run(event.data);
        };
        var post = function (id) {
          // old engines have not location.origin
          global.postMessage(id + '', location.protocol + '//' + location.host);
        }; // Node.js 0.9+ & IE10+ has setImmediate, otherwise:
        if (!set || !clear) {
          set = function setImmediate(fn) {
            var args = [
            ];
            var i = 1;
            while (arguments.length > i) args.push(arguments[i++]);
            queue[++counter] = function () {
              // eslint-disable-next-line no-new-func
              (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
            };
            defer(counter);
            return counter;
          };
          clear = function clearImmediate(id) {
            delete queue[id];
          }; // Node.js 0.8-
          if (classof(process) == 'process') {
            defer = function (id) {
              process.nextTick(runner(id));
            }; // Sphere (JS game engine) Dispatch API
          } else if (Dispatch && Dispatch.now) {
            defer = function (id) {
              Dispatch.now(runner(id));
            }; // Browsers with MessageChannel, includes WebWorkers
            // except iOS - https://github.com/zloirock/core-js/issues/624
          } else if (MessageChannel && !IS_IOS) {
            channel = new MessageChannel();
            port = channel.port2;
            channel.port1.onmessage = listener;
            defer = bind(port.postMessage, port, 1); // Browsers with postMessage, skip WebWorkers
            // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
          } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts && !fails(post) && location.protocol !== 'file:') {
            defer = post;
            global.addEventListener('message', listener, false); // IE8-
          } else if (ONREADYSTATECHANGE in createElement('script')) {
            defer = function (id) {
              html.appendChild(createElement('script')) [ONREADYSTATECHANGE] = function () {
                html.removeChild(this);
                run(id);
              };
            }; // Rest old browsers
          } else {
            defer = function (id) {
              setTimeout(runner(id), 0);
            };
          }
        }
        module.exports = {
          set: set,
          clear: clear
        };
      },
      {
        '../internals/classof-raw': 46,
        '../internals/document-create-element': 62,
        '../internals/engine-is-ios': 64,
        '../internals/fails': 69,
        '../internals/function-bind-context': 72,
        '../internals/global': 77,
        '../internals/html': 81
      }
    ],
    149: [
      function (_dereq_, module, exports) {
        var classof = _dereq_('../internals/classof-raw'); // `thisNumberValue` abstract operation
        // https://tc39.github.io/ecma262/#sec-thisnumbervalue
        module.exports = function (value) {
          if (typeof value != 'number' && classof(value) != 'Number') {
            throw TypeError('Incorrect invocation');
          }
          return + value;
        };
      },
      {
        '../internals/classof-raw': 46
      }
    ],
    150: [
      function (_dereq_, module, exports) {
        var toInteger = _dereq_('../internals/to-integer');
        var max = Math.max;
        var min = Math.min; // Helper for a popular repeating case of the spec:
        // Let integer be ? ToInteger(index).
        // If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
        module.exports = function (index, length) {
          var integer = toInteger(index);
          return integer < 0 ? max(integer + length, 0) : min(integer, length);
        };
      },
      {
        '../internals/to-integer': 153
      }
    ],
    151: [
      function (_dereq_, module, exports) {
        var toInteger = _dereq_('../internals/to-integer');
        var toLength = _dereq_('../internals/to-length'); // `ToIndex` abstract operation
        // https://tc39.github.io/ecma262/#sec-toindex
        module.exports = function (it) {
          if (it === undefined) return 0;
          var number = toInteger(it);
          var length = toLength(number);
          if (number !== length) throw RangeError('Wrong length or index');
          return length;
        };
      },
      {
        '../internals/to-integer': 153,
        '../internals/to-length': 154
      }
    ],
    152: [
      function (_dereq_, module, exports) {
        // toObject with fallback for non-array-like ES3 strings
        var IndexedObject = _dereq_('../internals/indexed-object');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        module.exports = function (it) {
          return IndexedObject(requireObjectCoercible(it));
        };
      },
      {
        '../internals/indexed-object': 84,
        '../internals/require-object-coercible': 131
      }
    ],
    153: [
      function (_dereq_, module, exports) {
        var ceil = Math.ceil;
        var floor = Math.floor; // `ToInteger` abstract operation
        // https://tc39.github.io/ecma262/#sec-tointeger
        module.exports = function (argument) {
          return isNaN(argument = + argument) ? 0 : (argument > 0 ? floor : ceil) (argument);
        };
      },
      {
      }
    ],
    154: [
      function (_dereq_, module, exports) {
        var toInteger = _dereq_('../internals/to-integer');
        var min = Math.min; // `ToLength` abstract operation
        // https://tc39.github.io/ecma262/#sec-tolength
        module.exports = function (argument) {
          return argument > 0 ? min(toInteger(argument), 9007199254740991) : 0; // 2 ** 53 - 1 == 9007199254740991
        };
      },
      {
        '../internals/to-integer': 153
      }
    ],
    155: [
      function (_dereq_, module, exports) {
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible'); // `ToObject` abstract operation
        // https://tc39.github.io/ecma262/#sec-toobject
        module.exports = function (argument) {
          return Object(requireObjectCoercible(argument));
        };
      },
      {
        '../internals/require-object-coercible': 131
      }
    ],
    156: [
      function (_dereq_, module, exports) {
        var toPositiveInteger = _dereq_('../internals/to-positive-integer');
        module.exports = function (it, BYTES) {
          var offset = toPositiveInteger(it);
          if (offset % BYTES) throw RangeError('Wrong offset');
          return offset;
        };
      },
      {
        '../internals/to-positive-integer': 157
      }
    ],
    157: [
      function (_dereq_, module, exports) {
        var toInteger = _dereq_('../internals/to-integer');
        module.exports = function (it) {
          var result = toInteger(it);
          if (result < 0) throw RangeError('The argument can\'t be less than 0');
          return result;
        };
      },
      {
        '../internals/to-integer': 153
      }
    ],
    158: [
      function (_dereq_, module, exports) {
        var isObject = _dereq_('../internals/is-object'); // `ToPrimitive` abstract operation
        // https://tc39.github.io/ecma262/#sec-toprimitive
        // instead of the ES6 spec version, we didn't implement @@toPrimitive case
        // and the second argument - flag - preferred type is a string
        module.exports = function (input, PREFERRED_STRING) {
          if (!isObject(input)) return input;
          var fn,
          val;
          if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
          if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
          if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
          throw TypeError('Can\'t convert object to primitive value');
        };
      },
      {
        '../internals/is-object': 92
      }
    ],
    159: [
      function (_dereq_, module, exports) {
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var TO_STRING_TAG = wellKnownSymbol('toStringTag');
        var test = {
        };
        test[TO_STRING_TAG] = 'z';
        module.exports = String(test) === '[object z]';
      },
      {
        '../internals/well-known-symbol': 166
      }
    ],
    160: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var global = _dereq_('../internals/global');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS = _dereq_('../internals/typed-array-constructors-require-wrappers');
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var ArrayBufferModule = _dereq_('../internals/array-buffer');
        var anInstance = _dereq_('../internals/an-instance');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var toLength = _dereq_('../internals/to-length');
        var toIndex = _dereq_('../internals/to-index');
        var toOffset = _dereq_('../internals/to-offset');
        var toPrimitive = _dereq_('../internals/to-primitive');
        var has = _dereq_('../internals/has');
        var classof = _dereq_('../internals/classof');
        var isObject = _dereq_('../internals/is-object');
        var create = _dereq_('../internals/object-create');
        var setPrototypeOf = _dereq_('../internals/object-set-prototype-of');
        var getOwnPropertyNames = _dereq_('../internals/object-get-own-property-names').f;
        var typedArrayFrom = _dereq_('../internals/typed-array-from');
        var forEach = _dereq_('../internals/array-iteration').forEach;
        var setSpecies = _dereq_('../internals/set-species');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var getOwnPropertyDescriptorModule = _dereq_('../internals/object-get-own-property-descriptor');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var inheritIfRequired = _dereq_('../internals/inherit-if-required');
        var getInternalState = InternalStateModule.get;
        var setInternalState = InternalStateModule.set;
        var nativeDefineProperty = definePropertyModule.f;
        var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
        var round = Math.round;
        var RangeError = global.RangeError;
        var ArrayBuffer = ArrayBufferModule.ArrayBuffer;
        var DataView = ArrayBufferModule.DataView;
        var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
        var TYPED_ARRAY_TAG = ArrayBufferViewCore.TYPED_ARRAY_TAG;
        var TypedArray = ArrayBufferViewCore.TypedArray;
        var TypedArrayPrototype = ArrayBufferViewCore.TypedArrayPrototype;
        var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
        var isTypedArray = ArrayBufferViewCore.isTypedArray;
        var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
        var WRONG_LENGTH = 'Wrong length';
        var fromList = function (C, list) {
          var index = 0;
          var length = list.length;
          var result = new (aTypedArrayConstructor(C)) (length);
          while (length > index) result[index] = list[index++];
          return result;
        };
        var addGetter = function (it, key) {
          nativeDefineProperty(it, key, {
            get: function () {
              return getInternalState(this) [key];
            }
          });
        };
        var isArrayBuffer = function (it) {
          var klass;
          return it instanceof ArrayBuffer || (klass = classof(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
        };
        var isTypedArrayIndex = function (target, key) {
          return isTypedArray(target) && typeof key != 'symbol' && key in target && String( + key) == String(key);
        };
        var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
          return isTypedArrayIndex(target, key = toPrimitive(key, true)) ? createPropertyDescriptor(2, target[key]) : nativeGetOwnPropertyDescriptor(target, key);
        };
        var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
          if (isTypedArrayIndex(target, key = toPrimitive(key, true)) && isObject(descriptor) && has(descriptor, 'value') && !has(descriptor, 'get') && !has(descriptor, 'set') // TODO: add validation descriptor w/o calling accessors
          && !descriptor.configurable && (!has(descriptor, 'writable') || descriptor.writable) && (!has(descriptor, 'enumerable') || descriptor.enumerable)) {
            target[key] = descriptor.value;
            return target;
          }
          return nativeDefineProperty(target, key, descriptor);
        };
        if (DESCRIPTORS) {
          if (!NATIVE_ARRAY_BUFFER_VIEWS) {
            getOwnPropertyDescriptorModule.f = wrappedGetOwnPropertyDescriptor;
            definePropertyModule.f = wrappedDefineProperty;
            addGetter(TypedArrayPrototype, 'buffer');
            addGetter(TypedArrayPrototype, 'byteOffset');
            addGetter(TypedArrayPrototype, 'byteLength');
            addGetter(TypedArrayPrototype, 'length');
          }
          $({
            target: 'Object',
            stat: true,
            forced: !NATIVE_ARRAY_BUFFER_VIEWS
          }, {
            getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
            defineProperty: wrappedDefineProperty
          });
          module.exports = function (TYPE, wrapper, CLAMPED) {
            var BYTES = TYPE.match(/\d+$/) [0] / 8;
            var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
            var GETTER = 'get' + TYPE;
            var SETTER = 'set' + TYPE;
            var NativeTypedArrayConstructor = global[CONSTRUCTOR_NAME];
            var TypedArrayConstructor = NativeTypedArrayConstructor;
            var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
            var exported = {
            };
            var getter = function (that, index) {
              var data = getInternalState(that);
              return data.view[GETTER](index * BYTES + data.byteOffset, true);
            };
            var setter = function (that, index, value) {
              var data = getInternalState(that);
              if (CLAMPED) value = (value = round(value)) < 0 ? 0 : value > 255 ? 255 : value & 255;
              data.view[SETTER](index * BYTES + data.byteOffset, value, true);
            };
            var addElement = function (that, index) {
              nativeDefineProperty(that, index, {
                get: function () {
                  return getter(this, index);
                },
                set: function (value) {
                  return setter(this, index, value);
                },
                enumerable: true
              });
            };
            if (!NATIVE_ARRAY_BUFFER_VIEWS) {
              TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
                anInstance(that, TypedArrayConstructor, CONSTRUCTOR_NAME);
                var index = 0;
                var byteOffset = 0;
                var buffer,
                byteLength,
                length;
                if (!isObject(data)) {
                  length = toIndex(data);
                  byteLength = length * BYTES;
                  buffer = new ArrayBuffer(byteLength);
                } else if (isArrayBuffer(data)) {
                  buffer = data;
                  byteOffset = toOffset(offset, BYTES);
                  var $len = data.byteLength;
                  if ($length === undefined) {
                    if ($len % BYTES) throw RangeError(WRONG_LENGTH);
                    byteLength = $len - byteOffset;
                    if (byteLength < 0) throw RangeError(WRONG_LENGTH);
                  } else {
                    byteLength = toLength($length) * BYTES;
                    if (byteLength + byteOffset > $len) throw RangeError(WRONG_LENGTH);
                  }
                  length = byteLength / BYTES;
                } else if (isTypedArray(data)) {
                  return fromList(TypedArrayConstructor, data);
                } else {
                  return typedArrayFrom.call(TypedArrayConstructor, data);
                }
                setInternalState(that, {
                  buffer: buffer,
                  byteOffset: byteOffset,
                  byteLength: byteLength,
                  length: length,
                  view: new DataView(buffer)
                });
                while (index < length) addElement(that, index++);
              });
              if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
              TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = create(TypedArrayPrototype);
            } else if (TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS) {
              TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
                anInstance(dummy, TypedArrayConstructor, CONSTRUCTOR_NAME);
                return inheritIfRequired(function () {
                  if (!isObject(data)) return new NativeTypedArrayConstructor(toIndex(data));
                  if (isArrayBuffer(data)) return $length !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES), $length) : typedArrayOffset !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES)) : new NativeTypedArrayConstructor(data);
                  if (isTypedArray(data)) return fromList(TypedArrayConstructor, data);
                  return typedArrayFrom.call(TypedArrayConstructor, data);
                }(), dummy, TypedArrayConstructor);
              });
              if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
              forEach(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
                if (!(key in TypedArrayConstructor)) {
                  createNonEnumerableProperty(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
                }
              });
              TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
            }
            if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
              createNonEnumerableProperty(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
            }
            if (TYPED_ARRAY_TAG) {
              createNonEnumerableProperty(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
            }
            exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;
            $({
              global: true,
              forced: TypedArrayConstructor != NativeTypedArrayConstructor,
              sham: !NATIVE_ARRAY_BUFFER_VIEWS
            }, exported);
            if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
              createNonEnumerableProperty(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
            }
            if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
              createNonEnumerableProperty(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
            }
            setSpecies(CONSTRUCTOR_NAME);
          };
        } else module.exports = function () {
          /* empty */
        };
      },
      {
        '../internals/an-instance': 27,
        '../internals/array-buffer': 31,
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37,
        '../internals/classof': 47,
        '../internals/create-non-enumerable-property': 56,
        '../internals/create-property-descriptor': 57,
        '../internals/descriptors': 61,
        '../internals/export': 68,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/inherit-if-required': 85,
        '../internals/internal-state': 88,
        '../internals/is-object': 92,
        '../internals/object-create': 108,
        '../internals/object-define-property': 110,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/object-get-own-property-names': 113,
        '../internals/object-set-prototype-of': 119,
        '../internals/set-species': 134,
        '../internals/to-index': 151,
        '../internals/to-length': 154,
        '../internals/to-offset': 156,
        '../internals/to-primitive': 158,
        '../internals/typed-array-constructors-require-wrappers': 161,
        '../internals/typed-array-from': 162
      }
    ],
    161: [
      function (_dereq_, module, exports) {
        /* eslint-disable no-new */
        var global = _dereq_('../internals/global');
        var fails = _dereq_('../internals/fails');
        var checkCorrectnessOfIteration = _dereq_('../internals/check-correctness-of-iteration');
        var NATIVE_ARRAY_BUFFER_VIEWS = _dereq_('../internals/array-buffer-view-core').NATIVE_ARRAY_BUFFER_VIEWS;
        var ArrayBuffer = global.ArrayBuffer;
        var Int8Array = global.Int8Array;
        module.exports = !NATIVE_ARRAY_BUFFER_VIEWS || !fails(function () {
          Int8Array(1);
        }) || !fails(function () {
          new Int8Array( - 1);
        }) || !checkCorrectnessOfIteration(function (iterable) {
          new Int8Array();
          new Int8Array(null);
          new Int8Array(1.5);
          new Int8Array(iterable);
        }, true) || fails(function () {
          // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
          return new Int8Array(new ArrayBuffer(2), 1, undefined).length !== 1;
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/check-correctness-of-iteration': 45,
        '../internals/fails': 69,
        '../internals/global': 77
      }
    ],
    162: [
      function (_dereq_, module, exports) {
        var toObject = _dereq_('../internals/to-object');
        var toLength = _dereq_('../internals/to-length');
        var getIteratorMethod = _dereq_('../internals/get-iterator-method');
        var isArrayIteratorMethod = _dereq_('../internals/is-array-iterator-method');
        var bind = _dereq_('../internals/function-bind-context');
        var aTypedArrayConstructor = _dereq_('../internals/array-buffer-view-core').aTypedArrayConstructor;
        module.exports = function from(source        /* , mapfn, thisArg */
        ) {
          var O = toObject(source);
          var argumentsLength = arguments.length;
          var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
          var mapping = mapfn !== undefined;
          var iteratorMethod = getIteratorMethod(O);
          var i,
          length,
          result,
          step,
          iterator,
          next;
          if (iteratorMethod != undefined && !isArrayIteratorMethod(iteratorMethod)) {
            iterator = iteratorMethod.call(O);
            next = iterator.next;
            O = [
            ];
            while (!(step = next.call(iterator)).done) {
              O.push(step.value);
            }
          }
          if (mapping && argumentsLength > 2) {
            mapfn = bind(mapfn, arguments[2], 2);
          }
          length = toLength(O.length);
          result = new (aTypedArrayConstructor(this)) (length);
          for (i = 0; length > i; i++) {
            result[i] = mapping ? mapfn(O[i], i) : O[i];
          }
          return result;
        };
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/function-bind-context': 72,
        '../internals/get-iterator-method': 75,
        '../internals/is-array-iterator-method': 89,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    163: [
      function (_dereq_, module, exports) {
        var id = 0;
        var postfix = Math.random();
        module.exports = function (key) {
          return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
        };
      },
      {
      }
    ],
    164: [
      function (_dereq_, module, exports) {
        var NATIVE_SYMBOL = _dereq_('../internals/native-symbol');
        module.exports = NATIVE_SYMBOL // eslint-disable-next-line no-undef
        && !Symbol.sham // eslint-disable-next-line no-undef
        && typeof Symbol.iterator == 'symbol';
      },
      {
        '../internals/native-symbol': 101
      }
    ],
    165: [
      function (_dereq_, module, exports) {
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        exports.f = wellKnownSymbol;
      },
      {
        '../internals/well-known-symbol': 166
      }
    ],
    166: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var shared = _dereq_('../internals/shared');
        var has = _dereq_('../internals/has');
        var uid = _dereq_('../internals/uid');
        var NATIVE_SYMBOL = _dereq_('../internals/native-symbol');
        var USE_SYMBOL_AS_UID = _dereq_('../internals/use-symbol-as-uid');
        var WellKnownSymbolsStore = shared('wks');
        var Symbol = global.Symbol;
        var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : Symbol && Symbol.withoutSetter || uid;
        module.exports = function (name) {
          if (!has(WellKnownSymbolsStore, name)) {
            if (NATIVE_SYMBOL && has(Symbol, name)) WellKnownSymbolsStore[name] = Symbol[name];
             else WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
          }
          return WellKnownSymbolsStore[name];
        };
      },
      {
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/native-symbol': 101,
        '../internals/shared': 138,
        '../internals/uid': 163,
        '../internals/use-symbol-as-uid': 164
      }
    ],
    167: [
      function (_dereq_, module, exports) {
        // a string of all valid unicode whitespaces
        // eslint-disable-next-line max-len
        module.exports = '\t\n\v\f\r                　\u2028\u2029﻿';
      },
      {
      }
    ],
    168: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var global = _dereq_('../internals/global');
        var arrayBufferModule = _dereq_('../internals/array-buffer');
        var setSpecies = _dereq_('../internals/set-species');
        var ARRAY_BUFFER = 'ArrayBuffer';
        var ArrayBuffer = arrayBufferModule[ARRAY_BUFFER];
        var NativeArrayBuffer = global[ARRAY_BUFFER]; // `ArrayBuffer` constructor
        // https://tc39.github.io/ecma262/#sec-arraybuffer-constructor
        $({
          global: true,
          forced: NativeArrayBuffer !== ArrayBuffer
        }, {
          ArrayBuffer: ArrayBuffer
        });
        setSpecies(ARRAY_BUFFER);
      },
      {
        '../internals/array-buffer': 31,
        '../internals/export': 68,
        '../internals/global': 77,
        '../internals/set-species': 134
      }
    ],
    169: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var fails = _dereq_('../internals/fails');
        var isArray = _dereq_('../internals/is-array');
        var isObject = _dereq_('../internals/is-object');
        var toObject = _dereq_('../internals/to-object');
        var toLength = _dereq_('../internals/to-length');
        var createProperty = _dereq_('../internals/create-property');
        var arraySpeciesCreate = _dereq_('../internals/array-species-create');
        var arrayMethodHasSpeciesSupport = _dereq_('../internals/array-method-has-species-support');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var V8_VERSION = _dereq_('../internals/engine-v8-version');
        var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
        var MAX_SAFE_INTEGER = 9007199254740991;
        var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded'; // We can't use this feature detection in V8 since it causes
        // deoptimization and serious performance degradation
        // https://github.com/zloirock/core-js/issues/679
        var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function () {
          var array = [
          ];
          array[IS_CONCAT_SPREADABLE] = false;
          return array.concat() [0] !== array;
        });
        var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');
        var isConcatSpreadable = function (O) {
          if (!isObject(O)) return false;
          var spreadable = O[IS_CONCAT_SPREADABLE];
          return spreadable !== undefined ? !!spreadable : isArray(O);
        };
        var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.concat
        // with adding support of @@isConcatSpreadable and @@species
        $({
          target: 'Array',
          proto: true,
          forced: FORCED
        }, {
          concat: function concat(arg) {
            // eslint-disable-line no-unused-vars
            var O = toObject(this);
            var A = arraySpeciesCreate(O, 0);
            var n = 0;
            var i,
            k,
            length,
            len,
            E;
            for (i = - 1, length = arguments.length; i < length; i++) {
              E = i === - 1 ? O : arguments[i];
              if (isConcatSpreadable(E)) {
                len = toLength(E.length);
                if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
                for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
              } else {
                if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
                createProperty(A, n++, E);
              }
            }
            A.length = n;
            return A;
          }
        });
      },
      {
        '../internals/array-method-has-species-support': 39,
        '../internals/array-species-create': 43,
        '../internals/create-property': 58,
        '../internals/engine-v8-version': 66,
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/is-array': 90,
        '../internals/is-object': 92,
        '../internals/to-length': 154,
        '../internals/to-object': 155,
        '../internals/well-known-symbol': 166
      }
    ],
    170: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var copyWithin = _dereq_('../internals/array-copy-within');
        var addToUnscopables = _dereq_('../internals/add-to-unscopables'); // `Array.prototype.copyWithin` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.copywithin
        $({
          target: 'Array',
          proto: true
        }, {
          copyWithin: copyWithin
        }); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables
        addToUnscopables('copyWithin');
      },
      {
        '../internals/add-to-unscopables': 25,
        '../internals/array-copy-within': 32,
        '../internals/export': 68
      }
    ],
    171: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $every = _dereq_('../internals/array-iteration').every;
        var arrayMethodIsStrict = _dereq_('../internals/array-method-is-strict');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var STRICT_METHOD = arrayMethodIsStrict('every');
        var USES_TO_LENGTH = arrayMethodUsesToLength('every'); // `Array.prototype.every` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.every
        $({
          target: 'Array',
          proto: true,
          forced: !STRICT_METHOD || !USES_TO_LENGTH
        }, {
          every: function every(callbackfn          /* , thisArg */
          ) {
            return $every(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/array-iteration': 37,
        '../internals/array-method-is-strict': 40,
        '../internals/array-method-uses-to-length': 41,
        '../internals/export': 68
      }
    ],
    172: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var fill = _dereq_('../internals/array-fill');
        var addToUnscopables = _dereq_('../internals/add-to-unscopables'); // `Array.prototype.fill` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.fill
        $({
          target: 'Array',
          proto: true
        }, {
          fill: fill
        }); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables
        addToUnscopables('fill');
      },
      {
        '../internals/add-to-unscopables': 25,
        '../internals/array-fill': 33,
        '../internals/export': 68
      }
    ],
    173: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $filter = _dereq_('../internals/array-iteration').filter;
        var arrayMethodHasSpeciesSupport = _dereq_('../internals/array-method-has-species-support');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter'); // Edge 14- issue
        var USES_TO_LENGTH = arrayMethodUsesToLength('filter'); // `Array.prototype.filter` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.filter
        // with adding support of @@species
        $({
          target: 'Array',
          proto: true,
          forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH
        }, {
          filter: function filter(callbackfn          /* , thisArg */
          ) {
            return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/array-iteration': 37,
        '../internals/array-method-has-species-support': 39,
        '../internals/array-method-uses-to-length': 41,
        '../internals/export': 68
      }
    ],
    174: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var forEach = _dereq_('../internals/array-for-each'); // `Array.prototype.forEach` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
        $({
          target: 'Array',
          proto: true,
          forced: [
          ].forEach != forEach
        }, {
          forEach: forEach
        });
      },
      {
        '../internals/array-for-each': 34,
        '../internals/export': 68
      }
    ],
    175: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var from = _dereq_('../internals/array-from');
        var checkCorrectnessOfIteration = _dereq_('../internals/check-correctness-of-iteration');
        var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
          Array.from(iterable);
        }); // `Array.from` method
        // https://tc39.github.io/ecma262/#sec-array.from
        $({
          target: 'Array',
          stat: true,
          forced: INCORRECT_ITERATION
        }, {
          from: from
        });
      },
      {
        '../internals/array-from': 35,
        '../internals/check-correctness-of-iteration': 45,
        '../internals/export': 68
      }
    ],
    176: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $includes = _dereq_('../internals/array-includes').includes;
        var addToUnscopables = _dereq_('../internals/add-to-unscopables');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var USES_TO_LENGTH = arrayMethodUsesToLength('indexOf', {
          ACCESSORS: true,
          1: 0
        }); // `Array.prototype.includes` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.includes
        $({
          target: 'Array',
          proto: true,
          forced: !USES_TO_LENGTH
        }, {
          includes: function includes(el          /* , fromIndex = 0 */
          ) {
            return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
          }
        }); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables
        addToUnscopables('includes');
      },
      {
        '../internals/add-to-unscopables': 25,
        '../internals/array-includes': 36,
        '../internals/array-method-uses-to-length': 41,
        '../internals/export': 68
      }
    ],
    177: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $indexOf = _dereq_('../internals/array-includes').indexOf;
        var arrayMethodIsStrict = _dereq_('../internals/array-method-is-strict');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var nativeIndexOf = [
        ].indexOf;
        var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [
          1
        ].indexOf(1, - 0) < 0;
        var STRICT_METHOD = arrayMethodIsStrict('indexOf');
        var USES_TO_LENGTH = arrayMethodUsesToLength('indexOf', {
          ACCESSORS: true,
          1: 0
        }); // `Array.prototype.indexOf` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
        $({
          target: 'Array',
          proto: true,
          forced: NEGATIVE_ZERO || !STRICT_METHOD || !USES_TO_LENGTH
        }, {
          indexOf: function indexOf(searchElement          /* , fromIndex = 0 */
          ) {
            return NEGATIVE_ZERO // convert -0 to +0
            ? nativeIndexOf.apply(this, arguments) || 0 : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/array-includes': 36,
        '../internals/array-method-is-strict': 40,
        '../internals/array-method-uses-to-length': 41,
        '../internals/export': 68
      }
    ],
    178: [
      function (_dereq_, module, exports) {
        'use strict';
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var addToUnscopables = _dereq_('../internals/add-to-unscopables');
        var Iterators = _dereq_('../internals/iterators');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var defineIterator = _dereq_('../internals/define-iterator');
        var ARRAY_ITERATOR = 'Array Iterator';
        var setInternalState = InternalStateModule.set;
        var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR); // `Array.prototype.entries` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.entries
        // `Array.prototype.keys` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.keys
        // `Array.prototype.values` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.values
        // `Array.prototype[@@iterator]` method
        // https://tc39.github.io/ecma262/#sec-array.prototype-@@iterator
        // `CreateArrayIterator` internal method
        // https://tc39.github.io/ecma262/#sec-createarrayiterator
        module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
          setInternalState(this, {
            type: ARRAY_ITERATOR,
            target: toIndexedObject(iterated),
            // target
            index: 0,
            // next index
            kind: kind // kind
          }); // `%ArrayIteratorPrototype%.next` method
          // https://tc39.github.io/ecma262/#sec-%arrayiteratorprototype%.next
        }, function () {
          var state = getInternalState(this);
          var target = state.target;
          var kind = state.kind;
          var index = state.index++;
          if (!target || index >= target.length) {
            state.target = undefined;
            return {
              value: undefined,
              done: true
            };
          }
          if (kind == 'keys') return {
            value: index,
            done: false
          };
          if (kind == 'values') return {
            value: target[index],
            done: false
          };
          return {
            value: [
              index,
              target[index]
            ],
            done: false
          };
        }, 'values'); // argumentsList[@@iterator] is %ArrayProto_values%
        // https://tc39.github.io/ecma262/#sec-createunmappedargumentsobject
        // https://tc39.github.io/ecma262/#sec-createmappedargumentsobject
        Iterators.Arguments = Iterators.Array; // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables
        addToUnscopables('keys');
        addToUnscopables('values');
        addToUnscopables('entries');
      },
      {
        '../internals/add-to-unscopables': 25,
        '../internals/define-iterator': 59,
        '../internals/internal-state': 88,
        '../internals/iterators': 97,
        '../internals/to-indexed-object': 152
      }
    ],
    179: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var IndexedObject = _dereq_('../internals/indexed-object');
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var arrayMethodIsStrict = _dereq_('../internals/array-method-is-strict');
        var nativeJoin = [
        ].join;
        var ES3_STRINGS = IndexedObject != Object;
        var STRICT_METHOD = arrayMethodIsStrict('join', ','); // `Array.prototype.join` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.join
        $({
          target: 'Array',
          proto: true,
          forced: ES3_STRINGS || !STRICT_METHOD
        }, {
          join: function join(separator) {
            return nativeJoin.call(toIndexedObject(this), separator === undefined ? ',' : separator);
          }
        });
      },
      {
        '../internals/array-method-is-strict': 40,
        '../internals/export': 68,
        '../internals/indexed-object': 84,
        '../internals/to-indexed-object': 152
      }
    ],
    180: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var lastIndexOf = _dereq_('../internals/array-last-index-of'); // `Array.prototype.lastIndexOf` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.lastindexof
        $({
          target: 'Array',
          proto: true,
          forced: lastIndexOf !== [].lastIndexOf
        }, {
          lastIndexOf: lastIndexOf
        });
      },
      {
        '../internals/array-last-index-of': 38,
        '../internals/export': 68
      }
    ],
    181: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $map = _dereq_('../internals/array-iteration').map;
        var arrayMethodHasSpeciesSupport = _dereq_('../internals/array-method-has-species-support');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map'); // FF49- issue
        var USES_TO_LENGTH = arrayMethodUsesToLength('map'); // `Array.prototype.map` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.map
        // with adding support of @@species
        $({
          target: 'Array',
          proto: true,
          forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH
        }, {
          map: function map(callbackfn          /* , thisArg */
          ) {
            return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/array-iteration': 37,
        '../internals/array-method-has-species-support': 39,
        '../internals/array-method-uses-to-length': 41,
        '../internals/export': 68
      }
    ],
    182: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var isObject = _dereq_('../internals/is-object');
        var isArray = _dereq_('../internals/is-array');
        var toAbsoluteIndex = _dereq_('../internals/to-absolute-index');
        var toLength = _dereq_('../internals/to-length');
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var createProperty = _dereq_('../internals/create-property');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var arrayMethodHasSpeciesSupport = _dereq_('../internals/array-method-has-species-support');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('slice');
        var USES_TO_LENGTH = arrayMethodUsesToLength('slice', {
          ACCESSORS: true,
          0: 0,
          1: 2
        });
        var SPECIES = wellKnownSymbol('species');
        var nativeSlice = [
        ].slice;
        var max = Math.max; // `Array.prototype.slice` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.slice
        // fallback for not array-like ES3 strings and DOM objects
        $({
          target: 'Array',
          proto: true,
          forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH
        }, {
          slice: function slice(start, end) {
            var O = toIndexedObject(this);
            var length = toLength(O.length);
            var k = toAbsoluteIndex(start, length);
            var fin = toAbsoluteIndex(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
            var Constructor,
            result,
            n;
            if (isArray(O)) {
              Constructor = O.constructor; // cross-realm fallback
              if (typeof Constructor == 'function' && (Constructor === Array || isArray(Constructor.prototype))) {
                Constructor = undefined;
              } else if (isObject(Constructor)) {
                Constructor = Constructor[SPECIES];
                if (Constructor === null) Constructor = undefined;
              }
              if (Constructor === Array || Constructor === undefined) {
                return nativeSlice.call(O, k, fin);
              }
            }
            result = new (Constructor === undefined ? Array : Constructor) (max(fin - k, 0));
            for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);
            result.length = n;
            return result;
          }
        });
      },
      {
        '../internals/array-method-has-species-support': 39,
        '../internals/array-method-uses-to-length': 41,
        '../internals/create-property': 58,
        '../internals/export': 68,
        '../internals/is-array': 90,
        '../internals/is-object': 92,
        '../internals/to-absolute-index': 150,
        '../internals/to-indexed-object': 152,
        '../internals/to-length': 154,
        '../internals/well-known-symbol': 166
      }
    ],
    183: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $some = _dereq_('../internals/array-iteration').some;
        var arrayMethodIsStrict = _dereq_('../internals/array-method-is-strict');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var STRICT_METHOD = arrayMethodIsStrict('some');
        var USES_TO_LENGTH = arrayMethodUsesToLength('some'); // `Array.prototype.some` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.some
        $({
          target: 'Array',
          proto: true,
          forced: !STRICT_METHOD || !USES_TO_LENGTH
        }, {
          some: function some(callbackfn          /* , thisArg */
          ) {
            return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/array-iteration': 37,
        '../internals/array-method-is-strict': 40,
        '../internals/array-method-uses-to-length': 41,
        '../internals/export': 68
      }
    ],
    184: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var toAbsoluteIndex = _dereq_('../internals/to-absolute-index');
        var toInteger = _dereq_('../internals/to-integer');
        var toLength = _dereq_('../internals/to-length');
        var toObject = _dereq_('../internals/to-object');
        var arraySpeciesCreate = _dereq_('../internals/array-species-create');
        var createProperty = _dereq_('../internals/create-property');
        var arrayMethodHasSpeciesSupport = _dereq_('../internals/array-method-has-species-support');
        var arrayMethodUsesToLength = _dereq_('../internals/array-method-uses-to-length');
        var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');
        var USES_TO_LENGTH = arrayMethodUsesToLength('splice', {
          ACCESSORS: true,
          0: 0,
          1: 2
        });
        var max = Math.max;
        var min = Math.min;
        var MAX_SAFE_INTEGER = 9007199254740991;
        var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded'; // `Array.prototype.splice` method
        // https://tc39.github.io/ecma262/#sec-array.prototype.splice
        // with adding support of @@species
        $({
          target: 'Array',
          proto: true,
          forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH
        }, {
          splice: function splice(start, deleteCount          /* , ...items */
          ) {
            var O = toObject(this);
            var len = toLength(O.length);
            var actualStart = toAbsoluteIndex(start, len);
            var argumentsLength = arguments.length;
            var insertCount,
            actualDeleteCount,
            A,
            k,
            from,
            to;
            if (argumentsLength === 0) {
              insertCount = actualDeleteCount = 0;
            } else if (argumentsLength === 1) {
              insertCount = 0;
              actualDeleteCount = len - actualStart;
            } else {
              insertCount = argumentsLength - 2;
              actualDeleteCount = min(max(toInteger(deleteCount), 0), len - actualStart);
            }
            if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER) {
              throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
            }
            A = arraySpeciesCreate(O, actualDeleteCount);
            for (k = 0; k < actualDeleteCount; k++) {
              from = actualStart + k;
              if (from in O) createProperty(A, k, O[from]);
            }
            A.length = actualDeleteCount;
            if (insertCount < actualDeleteCount) {
              for (k = actualStart; k < len - actualDeleteCount; k++) {
                from = k + actualDeleteCount;
                to = k + insertCount;
                if (from in O) O[to] = O[from];
                 else delete O[to];
              }
              for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
            } else if (insertCount > actualDeleteCount) {
              for (k = len - actualDeleteCount; k > actualStart; k--) {
                from = k + actualDeleteCount - 1;
                to = k + insertCount - 1;
                if (from in O) O[to] = O[from];
                 else delete O[to];
              }
            }
            for (k = 0; k < insertCount; k++) {
              O[k + actualStart] = arguments[k + 2];
            }
            O.length = len - actualDeleteCount + insertCount;
            return A;
          }
        });
      },
      {
        '../internals/array-method-has-species-support': 39,
        '../internals/array-method-uses-to-length': 41,
        '../internals/array-species-create': 43,
        '../internals/create-property': 58,
        '../internals/export': 68,
        '../internals/to-absolute-index': 150,
        '../internals/to-integer': 153,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    185: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var FunctionPrototype = Function.prototype;
        var FunctionPrototypeToString = FunctionPrototype.toString;
        var nameRE = /^\s*function ([^ (]*)/;
        var NAME = 'name'; // Function instances `.name` property
        // https://tc39.github.io/ecma262/#sec-function-instances-name
        if (DESCRIPTORS && !(NAME in FunctionPrototype)) {
          defineProperty(FunctionPrototype, NAME, {
            configurable: true,
            get: function () {
              try {
                return FunctionPrototypeToString.call(this).match(nameRE) [1];
              } catch (error) {
                return '';
              }
            }
          });
        }
      },
      {
        '../internals/descriptors': 61,
        '../internals/object-define-property': 110
      }
    ],
    186: [
      function (_dereq_, module, exports) {
        'use strict';
        var collection = _dereq_('../internals/collection');
        var collectionStrong = _dereq_('../internals/collection-strong'); // `Map` constructor
        // https://tc39.github.io/ecma262/#sec-map-objects
        module.exports = collection('Map', function (init) {
          return function Map() {
            return init(this, arguments.length ? arguments[0] : undefined);
          };
        }, collectionStrong);
      },
      {
        '../internals/collection': 50,
        '../internals/collection-strong': 48
      }
    ],
    187: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var $hypot = Math.hypot;
        var abs = Math.abs;
        var sqrt = Math.sqrt; // Chrome 77 bug
        // https://bugs.chromium.org/p/v8/issues/detail?id=9546
        var BUGGY = !!$hypot && $hypot(Infinity, NaN) !== Infinity; // `Math.hypot` method
        // https://tc39.github.io/ecma262/#sec-math.hypot
        $({
          target: 'Math',
          stat: true,
          forced: BUGGY
        }, {
          hypot: function hypot(value1, value2) {
            // eslint-disable-line no-unused-vars
            var sum = 0;
            var i = 0;
            var aLen = arguments.length;
            var larg = 0;
            var arg,
            div;
            while (i < aLen) {
              arg = abs(arguments[i++]);
              if (larg < arg) {
                div = larg / arg;
                sum = sum * div * div + 1;
                larg = arg;
              } else if (arg > 0) {
                div = arg / larg;
                sum += div * div;
              } else sum += arg;
            }
            return larg === Infinity ? Infinity : larg * sqrt(sum);
          }
        });
      },
      {
        '../internals/export': 68
      }
    ],
    188: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var sign = _dereq_('../internals/math-sign'); // `Math.sign` method
        // https://tc39.github.io/ecma262/#sec-math.sign
        $({
          target: 'Math',
          stat: true
        }, {
          sign: sign
        });
      },
      {
        '../internals/export': 68,
        '../internals/math-sign': 98
      }
    ],
    189: [
      function (_dereq_, module, exports) {
        'use strict';
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var global = _dereq_('../internals/global');
        var isForced = _dereq_('../internals/is-forced');
        var redefine = _dereq_('../internals/redefine');
        var has = _dereq_('../internals/has');
        var classof = _dereq_('../internals/classof-raw');
        var inheritIfRequired = _dereq_('../internals/inherit-if-required');
        var toPrimitive = _dereq_('../internals/to-primitive');
        var fails = _dereq_('../internals/fails');
        var create = _dereq_('../internals/object-create');
        var getOwnPropertyNames = _dereq_('../internals/object-get-own-property-names').f;
        var getOwnPropertyDescriptor = _dereq_('../internals/object-get-own-property-descriptor').f;
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var trim = _dereq_('../internals/string-trim').trim;
        var NUMBER = 'Number';
        var NativeNumber = global[NUMBER];
        var NumberPrototype = NativeNumber.prototype; // Opera ~12 has broken Object#toString
        var BROKEN_CLASSOF = classof(create(NumberPrototype)) == NUMBER; // `ToNumber` abstract operation
        // https://tc39.github.io/ecma262/#sec-tonumber
        var toNumber = function (argument) {
          var it = toPrimitive(argument, false);
          var first,
          third,
          radix,
          maxCode,
          digits,
          length,
          index,
          code;
          if (typeof it == 'string' && it.length > 2) {
            it = trim(it);
            first = it.charCodeAt(0);
            if (first === 43 || first === 45) {
              third = it.charCodeAt(2);
              if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
            } else if (first === 48) {
              switch (it.charCodeAt(1)) {
                case 66:
                case 98:
                  radix = 2;
                  maxCode = 49;
                  break;
                  // fast equal of /^0b[01]+$/i
                case 79:
                case 111:
                  radix = 8;
                  maxCode = 55;
                  break;
                  // fast equal of /^0o[0-7]+$/i
                default:
                  return + it;
              }
              digits = it.slice(2);
              length = digits.length;
              for (index = 0; index < length; index++) {
                code = digits.charCodeAt(index); // parseInt parses a string to a first unavailable symbol
                // but ToNumber should return NaN if a string contains unavailable symbols
                if (code < 48 || code > maxCode) return NaN;
              }
              return parseInt(digits, radix);
            }
          }
          return + it;
        }; // `Number` constructor
        // https://tc39.github.io/ecma262/#sec-number-constructor
        if (isForced(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
          var NumberWrapper = function Number(value) {
            var it = arguments.length < 1 ? 0 : value;
            var dummy = this;
            return dummy instanceof NumberWrapper // check on 1..constructor(foo) case
            && (BROKEN_CLASSOF ? fails(function () {
              NumberPrototype.valueOf.call(dummy);
            }) : classof(dummy) != NUMBER) ? inheritIfRequired(new NativeNumber(toNumber(it)), dummy, NumberWrapper) : toNumber(it);
          };
          for (var keys = DESCRIPTORS ? getOwnPropertyNames(NativeNumber) : ( // ES3:
          'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' + // ES2015 (in case, if modules with ES2015 Number statics required before):
          'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' + 'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger').split(','), j = 0, key; keys.length > j; j++) {
            if (has(NativeNumber, key = keys[j]) && !has(NumberWrapper, key)) {
              defineProperty(NumberWrapper, key, getOwnPropertyDescriptor(NativeNumber, key));
            }
          }
          NumberWrapper.prototype = NumberPrototype;
          NumberPrototype.constructor = NumberWrapper;
          redefine(global, NUMBER, NumberWrapper);
        }
      },
      {
        '../internals/classof-raw': 46,
        '../internals/descriptors': 61,
        '../internals/fails': 69,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/inherit-if-required': 85,
        '../internals/is-forced': 91,
        '../internals/object-create': 108,
        '../internals/object-define-property': 110,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/object-get-own-property-names': 113,
        '../internals/redefine': 126,
        '../internals/string-trim': 147,
        '../internals/to-primitive': 158
      }
    ],
    190: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var numberIsFinite = _dereq_('../internals/number-is-finite'); // `Number.isFinite` method
        // https://tc39.github.io/ecma262/#sec-number.isfinite
        $({
          target: 'Number',
          stat: true
        }, {
          isFinite: numberIsFinite
        });
      },
      {
        '../internals/export': 68,
        '../internals/number-is-finite': 106
      }
    ],
    191: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var toInteger = _dereq_('../internals/to-integer');
        var thisNumberValue = _dereq_('../internals/this-number-value');
        var repeat = _dereq_('../internals/string-repeat');
        var fails = _dereq_('../internals/fails');
        var nativeToFixed = 1 .toFixed;
        var floor = Math.floor;
        var pow = function (x, n, acc) {
          return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
        };
        var log = function (x) {
          var n = 0;
          var x2 = x;
          while (x2 >= 4096) {
            n += 12;
            x2 /= 4096;
          }
          while (x2 >= 2) {
            n += 1;
            x2 /= 2;
          }
          return n;
        };
        var FORCED = nativeToFixed && (0.00008 .toFixed(3) !== '0.000' || 0.9 .toFixed(0) !== '1' || 1.255 .toFixed(2) !== '1.25' || 1000000000000000100 .toFixed(0) !== '1000000000000000128') || !fails(function () {
          // V8 ~ Android 4.3-
          nativeToFixed.call({
          });
        }); // `Number.prototype.toFixed` method
        // https://tc39.github.io/ecma262/#sec-number.prototype.tofixed
        $({
          target: 'Number',
          proto: true,
          forced: FORCED
        }, {
          // eslint-disable-next-line max-statements
          toFixed: function toFixed(fractionDigits) {
            var number = thisNumberValue(this);
            var fractDigits = toInteger(fractionDigits);
            var data = [
              0,
              0,
              0,
              0,
              0,
              0
            ];
            var sign = '';
            var result = '0';
            var e,
            z,
            j,
            k;
            var multiply = function (n, c) {
              var index = - 1;
              var c2 = c;
              while (++index < 6) {
                c2 += n * data[index];
                data[index] = c2 % 10000000;
                c2 = floor(c2 / 10000000);
              }
            };
            var divide = function (n) {
              var index = 6;
              var c = 0;
              while (--index >= 0) {
                c += data[index];
                data[index] = floor(c / n);
                c = c % n * 10000000;
              }
            };
            var dataToString = function () {
              var index = 6;
              var s = '';
              while (--index >= 0) {
                if (s !== '' || index === 0 || data[index] !== 0) {
                  var t = String(data[index]);
                  s = s === '' ? t : s + repeat.call('0', 7 - t.length) + t;
                }
              }
              return s;
            };
            if (fractDigits < 0 || fractDigits > 20) throw RangeError('Incorrect fraction digits'); // eslint-disable-next-line no-self-compare
            if (number != number) return 'NaN';
            if (number <= - 1e+21 || number >= 1e+21) return String(number);
            if (number < 0) {
              sign = '-';
              number = - number;
            }
            if (number > 1e-21) {
              e = log(number * pow(2, 69, 1)) - 69;
              z = e < 0 ? number * pow(2, - e, 1) : number / pow(2, e, 1);
              z *= 4503599627370496;
              e = 52 - e;
              if (e > 0) {
                multiply(0, z);
                j = fractDigits;
                while (j >= 7) {
                  multiply(10000000, 0);
                  j -= 7;
                }
                multiply(pow(10, j, 1), 0);
                j = e - 1;
                while (j >= 23) {
                  divide(1 << 23);
                  j -= 23;
                }
                divide(1 << j);
                multiply(1, 1);
                divide(2);
                result = dataToString();
              } else {
                multiply(0, z);
                multiply(1 << - e, 0);
                result = dataToString() + repeat.call('0', fractDigits);
              }
            }
            if (fractDigits > 0) {
              k = result.length;
              result = sign + (k <= fractDigits ? '0.' + repeat.call('0', fractDigits - k) + result : result.slice(0, k - fractDigits) + '.' + result.slice(k - fractDigits));
            } else {
              result = sign + result;
            }
            return result;
          }
        });
      },
      {
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/string-repeat': 145,
        '../internals/this-number-value': 149,
        '../internals/to-integer': 153
      }
    ],
    192: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var assign = _dereq_('../internals/object-assign'); // `Object.assign` method
        // https://tc39.github.io/ecma262/#sec-object.assign
        $({
          target: 'Object',
          stat: true,
          forced: Object.assign !== assign
        }, {
          assign: assign
        });
      },
      {
        '../internals/export': 68,
        '../internals/object-assign': 107
      }
    ],
    193: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var iterate = _dereq_('../internals/iterate');
        var createProperty = _dereq_('../internals/create-property'); // `Object.fromEntries` method
        // https://github.com/tc39/proposal-object-from-entries
        $({
          target: 'Object',
          stat: true
        }, {
          fromEntries: function fromEntries(iterable) {
            var obj = {
            };
            iterate(iterable, function (k, v) {
              createProperty(obj, k, v);
            }, undefined, true);
            return obj;
          }
        });
      },
      {
        '../internals/create-property': 58,
        '../internals/export': 68,
        '../internals/iterate': 95
      }
    ],
    194: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var fails = _dereq_('../internals/fails');
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var nativeGetOwnPropertyDescriptor = _dereq_('../internals/object-get-own-property-descriptor').f;
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var FAILS_ON_PRIMITIVES = fails(function () {
          nativeGetOwnPropertyDescriptor(1);
        });
        var FORCED = !DESCRIPTORS || FAILS_ON_PRIMITIVES; // `Object.getOwnPropertyDescriptor` method
        // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor
        $({
          target: 'Object',
          stat: true,
          forced: FORCED,
          sham: !DESCRIPTORS
        }, {
          getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
            return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
          }
        });
      },
      {
        '../internals/descriptors': 61,
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/to-indexed-object': 152
      }
    ],
    195: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var fails = _dereq_('../internals/fails');
        var nativeGetOwnPropertyNames = _dereq_('../internals/object-get-own-property-names-external').f;
        var FAILS_ON_PRIMITIVES = fails(function () {
          return !Object.getOwnPropertyNames(1);
        }); // `Object.getOwnPropertyNames` method
        // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
        $({
          target: 'Object',
          stat: true,
          forced: FAILS_ON_PRIMITIVES
        }, {
          getOwnPropertyNames: nativeGetOwnPropertyNames
        });
      },
      {
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/object-get-own-property-names-external': 112
      }
    ],
    196: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var fails = _dereq_('../internals/fails');
        var toObject = _dereq_('../internals/to-object');
        var nativeGetPrototypeOf = _dereq_('../internals/object-get-prototype-of');
        var CORRECT_PROTOTYPE_GETTER = _dereq_('../internals/correct-prototype-getter');
        var FAILS_ON_PRIMITIVES = fails(function () {
          nativeGetPrototypeOf(1);
        }); // `Object.getPrototypeOf` method
        // https://tc39.github.io/ecma262/#sec-object.getprototypeof
        $({
          target: 'Object',
          stat: true,
          forced: FAILS_ON_PRIMITIVES,
          sham: !CORRECT_PROTOTYPE_GETTER
        }, {
          getPrototypeOf: function getPrototypeOf(it) {
            return nativeGetPrototypeOf(toObject(it));
          }
        });
      },
      {
        '../internals/correct-prototype-getter': 53,
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/object-get-prototype-of': 115,
        '../internals/to-object': 155
      }
    ],
    197: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var toObject = _dereq_('../internals/to-object');
        var nativeKeys = _dereq_('../internals/object-keys');
        var fails = _dereq_('../internals/fails');
        var FAILS_ON_PRIMITIVES = fails(function () {
          nativeKeys(1);
        }); // `Object.keys` method
        // https://tc39.github.io/ecma262/#sec-object.keys
        $({
          target: 'Object',
          stat: true,
          forced: FAILS_ON_PRIMITIVES
        }, {
          keys: function keys(it) {
            return nativeKeys(toObject(it));
          }
        });
      },
      {
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/object-keys': 117,
        '../internals/to-object': 155
      }
    ],
    198: [
      function (_dereq_, module, exports) {
        var TO_STRING_TAG_SUPPORT = _dereq_('../internals/to-string-tag-support');
        var redefine = _dereq_('../internals/redefine');
        var toString = _dereq_('../internals/object-to-string'); // `Object.prototype.toString` method
        // https://tc39.github.io/ecma262/#sec-object.prototype.tostring
        if (!TO_STRING_TAG_SUPPORT) {
          redefine(Object.prototype, 'toString', toString, {
            unsafe: true
          });
        }
      },
      {
        '../internals/object-to-string': 120,
        '../internals/redefine': 126,
        '../internals/to-string-tag-support': 159
      }
    ],
    199: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var IS_PURE = _dereq_('../internals/is-pure');
        var global = _dereq_('../internals/global');
        var getBuiltIn = _dereq_('../internals/get-built-in');
        var NativePromise = _dereq_('../internals/native-promise-constructor');
        var redefine = _dereq_('../internals/redefine');
        var redefineAll = _dereq_('../internals/redefine-all');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var setSpecies = _dereq_('../internals/set-species');
        var isObject = _dereq_('../internals/is-object');
        var aFunction = _dereq_('../internals/a-function');
        var anInstance = _dereq_('../internals/an-instance');
        var classof = _dereq_('../internals/classof-raw');
        var inspectSource = _dereq_('../internals/inspect-source');
        var iterate = _dereq_('../internals/iterate');
        var checkCorrectnessOfIteration = _dereq_('../internals/check-correctness-of-iteration');
        var speciesConstructor = _dereq_('../internals/species-constructor');
        var task = _dereq_('../internals/task').set;
        var microtask = _dereq_('../internals/microtask');
        var promiseResolve = _dereq_('../internals/promise-resolve');
        var hostReportErrors = _dereq_('../internals/host-report-errors');
        var newPromiseCapabilityModule = _dereq_('../internals/new-promise-capability');
        var perform = _dereq_('../internals/perform');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var isForced = _dereq_('../internals/is-forced');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var V8_VERSION = _dereq_('../internals/engine-v8-version');
        var SPECIES = wellKnownSymbol('species');
        var PROMISE = 'Promise';
        var getInternalState = InternalStateModule.get;
        var setInternalState = InternalStateModule.set;
        var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
        var PromiseConstructor = NativePromise;
        var TypeError = global.TypeError;
        var document = global.document;
        var process = global.process;
        var $fetch = getBuiltIn('fetch');
        var newPromiseCapability = newPromiseCapabilityModule.f;
        var newGenericPromiseCapability = newPromiseCapability;
        var IS_NODE = classof(process) == 'process';
        var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
        var UNHANDLED_REJECTION = 'unhandledrejection';
        var REJECTION_HANDLED = 'rejectionhandled';
        var PENDING = 0;
        var FULFILLED = 1;
        var REJECTED = 2;
        var HANDLED = 1;
        var UNHANDLED = 2;
        var Internal,
        OwnPromiseCapability,
        PromiseWrapper,
        nativeThen;
        var FORCED = isForced(PROMISE, function () {
          var GLOBAL_CORE_JS_PROMISE = inspectSource(PromiseConstructor) !== String(PromiseConstructor);
          if (!GLOBAL_CORE_JS_PROMISE) {
            // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
            // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
            // We can't detect it synchronously, so just check versions
            if (V8_VERSION === 66) return true; // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
            if (!IS_NODE && typeof PromiseRejectionEvent != 'function') return true;
          } // We need Promise#finally in the pure version for preventing prototype pollution

          if (IS_PURE && !PromiseConstructor.prototype['finally']) return true; // We can't use @@species feature detection in V8 since it causes
          // deoptimization and performance degradation
          // https://github.com/zloirock/core-js/issues/679
          if (V8_VERSION >= 51 && /native code/.test(PromiseConstructor)) return false; // Detect correctness of subclassing with @@species support
          var promise = PromiseConstructor.resolve(1);
          var FakePromise = function (exec) {
            exec(function () {
              /* empty */
            }, function () {
              /* empty */
            });
          };
          var constructor = promise.constructor = {
          };
          constructor[SPECIES] = FakePromise;
          return !(promise.then(function () {
            /* empty */
          }) instanceof FakePromise);
        });
        var INCORRECT_ITERATION = FORCED || !checkCorrectnessOfIteration(function (iterable) {
          PromiseConstructor.all(iterable) ['catch'](function () {
            /* empty */
          });
        }); // helpers
        var isThenable = function (it) {
          var then;
          return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
        };
        var notify = function (promise, state, isReject) {
          if (state.notified) return;
          state.notified = true;
          var chain = state.reactions;
          microtask(function () {
            var value = state.value;
            var ok = state.state == FULFILLED;
            var index = 0; // variable length - can't use forEach
            while (chain.length > index) {
              var reaction = chain[index++];
              var handler = ok ? reaction.ok : reaction.fail;
              var resolve = reaction.resolve;
              var reject = reaction.reject;
              var domain = reaction.domain;
              var result,
              then,
              exited;
              try {
                if (handler) {
                  if (!ok) {
                    if (state.rejection === UNHANDLED) onHandleUnhandled(promise, state);
                    state.rejection = HANDLED;
                  }
                  if (handler === true) result = value;
                   else {
                    if (domain) domain.enter();
                    result = handler(value); // can throw
                    if (domain) {
                      domain.exit();
                      exited = true;
                    }
                  }
                  if (result === reaction.promise) {
                    reject(TypeError('Promise-chain cycle'));
                  } else if (then = isThenable(result)) {
                    then.call(result, resolve, reject);
                  } else resolve(result);
                } else reject(value);
              } catch (error) {
                if (domain && !exited) domain.exit();
                reject(error);
              }
            }
            state.reactions = [
            ];
            state.notified = false;
            if (isReject && !state.rejection) onUnhandled(promise, state);
          });
        };
        var dispatchEvent = function (name, promise, reason) {
          var event,
          handler;
          if (DISPATCH_EVENT) {
            event = document.createEvent('Event');
            event.promise = promise;
            event.reason = reason;
            event.initEvent(name, false, true);
            global.dispatchEvent(event);
          } else event = {
            promise: promise,
            reason: reason
          };
          if (handler = global['on' + name]) handler(event);
           else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
        };
        var onUnhandled = function (promise, state) {
          task.call(global, function () {
            var value = state.value;
            var IS_UNHANDLED = isUnhandled(state);
            var result;
            if (IS_UNHANDLED) {
              result = perform(function () {
                if (IS_NODE) {
                  process.emit('unhandledRejection', value, promise);
                } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
              }); // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
              state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
              if (result.error) throw result.value;
            }
          });
        };
        var isUnhandled = function (state) {
          return state.rejection !== HANDLED && !state.parent;
        };
        var onHandleUnhandled = function (promise, state) {
          task.call(global, function () {
            if (IS_NODE) {
              process.emit('rejectionHandled', promise);
            } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
          });
        };
        var bind = function (fn, promise, state, unwrap) {
          return function (value) {
            fn(promise, state, value, unwrap);
          };
        };
        var internalReject = function (promise, state, value, unwrap) {
          if (state.done) return;
          state.done = true;
          if (unwrap) state = unwrap;
          state.value = value;
          state.state = REJECTED;
          notify(promise, state, true);
        };
        var internalResolve = function (promise, state, value, unwrap) {
          if (state.done) return;
          state.done = true;
          if (unwrap) state = unwrap;
          try {
            if (promise === value) throw TypeError('Promise can\'t be resolved itself');
            var then = isThenable(value);
            if (then) {
              microtask(function () {
                var wrapper = {
                  done: false
                };
                try {
                  then.call(value, bind(internalResolve, promise, wrapper, state), bind(internalReject, promise, wrapper, state));
                } catch (error) {
                  internalReject(promise, wrapper, error, state);
                }
              });
            } else {
              state.value = value;
              state.state = FULFILLED;
              notify(promise, state, false);
            }
          } catch (error) {
            internalReject(promise, {
              done: false
            }, error, state);
          }
        }; // constructor polyfill
        if (FORCED) {
          // 25.4.3.1 Promise(executor)
          PromiseConstructor = function Promise(executor) {
            anInstance(this, PromiseConstructor, PROMISE);
            aFunction(executor);
            Internal.call(this);
            var state = getInternalState(this);
            try {
              executor(bind(internalResolve, this, state), bind(internalReject, this, state));
            } catch (error) {
              internalReject(this, state, error);
            }
          }; // eslint-disable-next-line no-unused-vars
          Internal = function Promise(executor) {
            setInternalState(this, {
              type: PROMISE,
              done: false,
              notified: false,
              parent: false,
              reactions: [
              ],
              rejection: false,
              state: PENDING,
              value: undefined
            });
          };
          Internal.prototype = redefineAll(PromiseConstructor.prototype, {
            // `Promise.prototype.then` method
            // https://tc39.github.io/ecma262/#sec-promise.prototype.then
            then: function then(onFulfilled, onRejected) {
              var state = getInternalPromiseState(this);
              var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
              reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
              reaction.fail = typeof onRejected == 'function' && onRejected;
              reaction.domain = IS_NODE ? process.domain : undefined;
              state.parent = true;
              state.reactions.push(reaction);
              if (state.state != PENDING) notify(this, state, false);
              return reaction.promise;
            },
            // `Promise.prototype.catch` method
            // https://tc39.github.io/ecma262/#sec-promise.prototype.catch
            'catch': function (onRejected) {
              return this.then(undefined, onRejected);
            }
          });
          OwnPromiseCapability = function () {
            var promise = new Internal();
            var state = getInternalState(promise);
            this.promise = promise;
            this.resolve = bind(internalResolve, promise, state);
            this.reject = bind(internalReject, promise, state);
          };
          newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
            return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
          };
          if (!IS_PURE && typeof NativePromise == 'function') {
            nativeThen = NativePromise.prototype.then; // wrap native Promise#then for native async functions
            redefine(NativePromise.prototype, 'then', function then(onFulfilled, onRejected) {
              var that = this;
              return new PromiseConstructor(function (resolve, reject) {
                nativeThen.call(that, resolve, reject);
              }).then(onFulfilled, onRejected); // https://github.com/zloirock/core-js/issues/640
            }, {
              unsafe: true
            }); // wrap fetch result
            if (typeof $fetch == 'function') $({
              global: true,
              enumerable: true,
              forced: true
            }, {
              // eslint-disable-next-line no-unused-vars
              fetch: function fetch(input              /* , init */
              ) {
                return promiseResolve(PromiseConstructor, $fetch.apply(global, arguments));
              }
            });
          }
        }
        $({
          global: true,
          wrap: true,
          forced: FORCED
        }, {
          Promise: PromiseConstructor
        });
        setToStringTag(PromiseConstructor, PROMISE, false, true);
        setSpecies(PROMISE);
        PromiseWrapper = getBuiltIn(PROMISE); // statics
        $({
          target: PROMISE,
          stat: true,
          forced: FORCED
        }, {
          // `Promise.reject` method
          // https://tc39.github.io/ecma262/#sec-promise.reject
          reject: function reject(r) {
            var capability = newPromiseCapability(this);
            capability.reject.call(undefined, r);
            return capability.promise;
          }
        });
        $({
          target: PROMISE,
          stat: true,
          forced: IS_PURE || FORCED
        }, {
          // `Promise.resolve` method
          // https://tc39.github.io/ecma262/#sec-promise.resolve
          resolve: function resolve(x) {
            return promiseResolve(IS_PURE && this === PromiseWrapper ? PromiseConstructor : this, x);
          }
        });
        $({
          target: PROMISE,
          stat: true,
          forced: INCORRECT_ITERATION
        }, {
          // `Promise.all` method
          // https://tc39.github.io/ecma262/#sec-promise.all
          all: function all(iterable) {
            var C = this;
            var capability = newPromiseCapability(C);
            var resolve = capability.resolve;
            var reject = capability.reject;
            var result = perform(function () {
              var $promiseResolve = aFunction(C.resolve);
              var values = [
              ];
              var counter = 0;
              var remaining = 1;
              iterate(iterable, function (promise) {
                var index = counter++;
                var alreadyCalled = false;
                values.push(undefined);
                remaining++;
                $promiseResolve.call(C, promise).then(function (value) {
                  if (alreadyCalled) return;
                  alreadyCalled = true;
                  values[index] = value;
                  --remaining || resolve(values);
                }, reject);
              });
              --remaining || resolve(values);
            });
            if (result.error) reject(result.value);
            return capability.promise;
          },
          // `Promise.race` method
          // https://tc39.github.io/ecma262/#sec-promise.race
          race: function race(iterable) {
            var C = this;
            var capability = newPromiseCapability(C);
            var reject = capability.reject;
            var result = perform(function () {
              var $promiseResolve = aFunction(C.resolve);
              iterate(iterable, function (promise) {
                $promiseResolve.call(C, promise).then(capability.resolve, reject);
              });
            });
            if (result.error) reject(result.value);
            return capability.promise;
          }
        });
      },
      {
        '../internals/a-function': 23,
        '../internals/an-instance': 27,
        '../internals/check-correctness-of-iteration': 45,
        '../internals/classof-raw': 46,
        '../internals/engine-v8-version': 66,
        '../internals/export': 68,
        '../internals/get-built-in': 74,
        '../internals/global': 77,
        '../internals/host-report-errors': 80,
        '../internals/inspect-source': 86,
        '../internals/internal-state': 88,
        '../internals/is-forced': 91,
        '../internals/is-object': 92,
        '../internals/is-pure': 93,
        '../internals/iterate': 95,
        '../internals/microtask': 99,
        '../internals/native-promise-constructor': 100,
        '../internals/new-promise-capability': 104,
        '../internals/perform': 123,
        '../internals/promise-resolve': 124,
        '../internals/redefine': 126,
        '../internals/redefine-all': 125,
        '../internals/set-species': 134,
        '../internals/set-to-string-tag': 135,
        '../internals/species-constructor': 139,
        '../internals/task': 148,
        '../internals/well-known-symbol': 166
      }
    ],
    200: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var getBuiltIn = _dereq_('../internals/get-built-in');
        var aFunction = _dereq_('../internals/a-function');
        var anObject = _dereq_('../internals/an-object');
        var isObject = _dereq_('../internals/is-object');
        var create = _dereq_('../internals/object-create');
        var bind = _dereq_('../internals/function-bind');
        var fails = _dereq_('../internals/fails');
        var nativeConstruct = getBuiltIn('Reflect', 'construct'); // `Reflect.construct` method
        // https://tc39.github.io/ecma262/#sec-reflect.construct
        // MS Edge supports only 2 arguments and argumentsList argument is optional
        // FF Nightly sets third argument as `new.target`, but does not create `this` from it
        var NEW_TARGET_BUG = fails(function () {
          function F() {
            /* empty */
          }
          return !(nativeConstruct(function () {
            /* empty */
          }, [
          ], F) instanceof F);
        });
        var ARGS_BUG = !fails(function () {
          nativeConstruct(function () {
            /* empty */
          });
        });
        var FORCED = NEW_TARGET_BUG || ARGS_BUG;
        $({
          target: 'Reflect',
          stat: true,
          forced: FORCED,
          sham: FORCED
        }, {
          construct: function construct(Target, args          /* , newTarget */
          ) {
            aFunction(Target);
            anObject(args);
            var newTarget = arguments.length < 3 ? Target : aFunction(arguments[2]);
            if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);
            if (Target == newTarget) {
              // w/o altered newTarget, optimization for 0-4 arguments
              switch (args.length) {
                case 0:
                  return new Target();
                case 1:
                  return new Target(args[0]);
                case 2:
                  return new Target(args[0], args[1]);
                case 3:
                  return new Target(args[0], args[1], args[2]);
                case 4:
                  return new Target(args[0], args[1], args[2], args[3]);
              } // w/o altered newTarget, lot of arguments case

              var $args = [
                null
              ];
              $args.push.apply($args, args);
              return new (bind.apply(Target, $args)) ();
            } // with altered newTarget, not support built-in constructors

            var proto = newTarget.prototype;
            var instance = create(isObject(proto) ? proto : Object.prototype);
            var result = Function.apply.call(Target, instance, args);
            return isObject(result) ? result : instance;
          }
        });
      },
      {
        '../internals/a-function': 23,
        '../internals/an-object': 28,
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/function-bind': 73,
        '../internals/get-built-in': 74,
        '../internals/is-object': 92,
        '../internals/object-create': 108
      }
    ],
    201: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var isObject = _dereq_('../internals/is-object');
        var anObject = _dereq_('../internals/an-object');
        var has = _dereq_('../internals/has');
        var getOwnPropertyDescriptorModule = _dereq_('../internals/object-get-own-property-descriptor');
        var getPrototypeOf = _dereq_('../internals/object-get-prototype-of'); // `Reflect.get` method
        // https://tc39.github.io/ecma262/#sec-reflect.get
        function get(target, propertyKey        /* , receiver */
        ) {
          var receiver = arguments.length < 3 ? target : arguments[2];
          var descriptor,
          prototype;
          if (anObject(target) === receiver) return target[propertyKey];
          if (descriptor = getOwnPropertyDescriptorModule.f(target, propertyKey)) return has(descriptor, 'value') ? descriptor.value : descriptor.get === undefined ? undefined : descriptor.get.call(receiver);
          if (isObject(prototype = getPrototypeOf(target))) return get(prototype, propertyKey, receiver);
        }
        $({
          target: 'Reflect',
          stat: true
        }, {
          get: get
        });
      },
      {
        '../internals/an-object': 28,
        '../internals/export': 68,
        '../internals/has': 78,
        '../internals/is-object': 92,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/object-get-prototype-of': 115
      }
    ],
    202: [
      function (_dereq_, module, exports) {
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var global = _dereq_('../internals/global');
        var isForced = _dereq_('../internals/is-forced');
        var inheritIfRequired = _dereq_('../internals/inherit-if-required');
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var getOwnPropertyNames = _dereq_('../internals/object-get-own-property-names').f;
        var isRegExp = _dereq_('../internals/is-regexp');
        var getFlags = _dereq_('../internals/regexp-flags');
        var stickyHelpers = _dereq_('../internals/regexp-sticky-helpers');
        var redefine = _dereq_('../internals/redefine');
        var fails = _dereq_('../internals/fails');
        var setInternalState = _dereq_('../internals/internal-state').set;
        var setSpecies = _dereq_('../internals/set-species');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var MATCH = wellKnownSymbol('match');
        var NativeRegExp = global.RegExp;
        var RegExpPrototype = NativeRegExp.prototype;
        var re1 = /a/g;
        var re2 = /a/g; // "new" should create a new object, old webkit bug
        var CORRECT_NEW = new NativeRegExp(re1) !== re1;
        var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
        var FORCED = DESCRIPTORS && isForced('RegExp', !CORRECT_NEW || UNSUPPORTED_Y || fails(function () {
          re2[MATCH] = false; // RegExp constructor can alter flags and IsRegExp works correct with @@match
          return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
        })); // `RegExp` constructor
        // https://tc39.github.io/ecma262/#sec-regexp-constructor
        if (FORCED) {
          var RegExpWrapper = function RegExp(pattern, flags) {
            var thisIsRegExp = this instanceof RegExpWrapper;
            var patternIsRegExp = isRegExp(pattern);
            var flagsAreUndefined = flags === undefined;
            var sticky;
            if (!thisIsRegExp && patternIsRegExp && pattern.constructor === RegExpWrapper && flagsAreUndefined) {
              return pattern;
            }
            if (CORRECT_NEW) {
              if (patternIsRegExp && !flagsAreUndefined) pattern = pattern.source;
            } else if (pattern instanceof RegExpWrapper) {
              if (flagsAreUndefined) flags = getFlags.call(pattern);
              pattern = pattern.source;
            }
            if (UNSUPPORTED_Y) {
              sticky = !!flags && flags.indexOf('y') > - 1;
              if (sticky) flags = flags.replace(/y/g, '');
            }
            var result = inheritIfRequired(CORRECT_NEW ? new NativeRegExp(pattern, flags) : NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype, RegExpWrapper);
            if (UNSUPPORTED_Y && sticky) setInternalState(result, {
              sticky: sticky
            });
            return result;
          };
          var proxy = function (key) {
            key in RegExpWrapper || defineProperty(RegExpWrapper, key, {
              configurable: true,
              get: function () {
                return NativeRegExp[key];
              },
              set: function (it) {
                NativeRegExp[key] = it;
              }
            });
          };
          var keys = getOwnPropertyNames(NativeRegExp);
          var index = 0;
          while (keys.length > index) proxy(keys[index++]);
          RegExpPrototype.constructor = RegExpWrapper;
          RegExpWrapper.prototype = RegExpPrototype;
          redefine(global, 'RegExp', RegExpWrapper);
        } // https://tc39.github.io/ecma262/#sec-get-regexp-@@species

        setSpecies('RegExp');
      },
      {
        '../internals/descriptors': 61,
        '../internals/fails': 69,
        '../internals/global': 77,
        '../internals/inherit-if-required': 85,
        '../internals/internal-state': 88,
        '../internals/is-forced': 91,
        '../internals/is-regexp': 94,
        '../internals/object-define-property': 110,
        '../internals/object-get-own-property-names': 113,
        '../internals/redefine': 126,
        '../internals/regexp-flags': 129,
        '../internals/regexp-sticky-helpers': 130,
        '../internals/set-species': 134,
        '../internals/well-known-symbol': 166
      }
    ],
    203: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var exec = _dereq_('../internals/regexp-exec');
        $({
          target: 'RegExp',
          proto: true,
          forced: /./.exec !== exec
        }, {
          exec: exec
        });
      },
      {
        '../internals/export': 68,
        '../internals/regexp-exec': 128
      }
    ],
    204: [
      function (_dereq_, module, exports) {
        'use strict';
        var redefine = _dereq_('../internals/redefine');
        var anObject = _dereq_('../internals/an-object');
        var fails = _dereq_('../internals/fails');
        var flags = _dereq_('../internals/regexp-flags');
        var TO_STRING = 'toString';
        var RegExpPrototype = RegExp.prototype;
        var nativeToString = RegExpPrototype[TO_STRING];
        var NOT_GENERIC = fails(function () {
          return nativeToString.call({
            source: 'a',
            flags: 'b'
          }) != '/a/b';
        }); // FF44- RegExp#toString has a wrong name
        var INCORRECT_NAME = nativeToString.name != TO_STRING; // `RegExp.prototype.toString` method
        // https://tc39.github.io/ecma262/#sec-regexp.prototype.tostring
        if (NOT_GENERIC || INCORRECT_NAME) {
          redefine(RegExp.prototype, TO_STRING, function toString() {
            var R = anObject(this);
            var p = String(R.source);
            var rf = R.flags;
            var f = String(rf === undefined && R instanceof RegExp && !('flags' in RegExpPrototype) ? flags.call(R) : rf);
            return '/' + p + '/' + f;
          }, {
            unsafe: true
          });
        }
      },
      {
        '../internals/an-object': 28,
        '../internals/fails': 69,
        '../internals/redefine': 126,
        '../internals/regexp-flags': 129
      }
    ],
    205: [
      function (_dereq_, module, exports) {
        'use strict';
        var collection = _dereq_('../internals/collection');
        var collectionStrong = _dereq_('../internals/collection-strong'); // `Set` constructor
        // https://tc39.github.io/ecma262/#sec-set-objects
        module.exports = collection('Set', function (init) {
          return function Set() {
            return init(this, arguments.length ? arguments[0] : undefined);
          };
        }, collectionStrong);
      },
      {
        '../internals/collection': 50,
        '../internals/collection-strong': 48
      }
    ],
    206: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var getOwnPropertyDescriptor = _dereq_('../internals/object-get-own-property-descriptor').f;
        var toLength = _dereq_('../internals/to-length');
        var notARegExp = _dereq_('../internals/not-a-regexp');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var correctIsRegExpLogic = _dereq_('../internals/correct-is-regexp-logic');
        var IS_PURE = _dereq_('../internals/is-pure');
        var nativeEndsWith = ''.endsWith;
        var min = Math.min;
        var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic('endsWith'); // https://github.com/zloirock/core-js/pull/702
        var MDN_POLYFILL_BUG = !IS_PURE && !CORRECT_IS_REGEXP_LOGIC && !!function () {
          var descriptor = getOwnPropertyDescriptor(String.prototype, 'endsWith');
          return descriptor && !descriptor.writable;
        }(); // `String.prototype.endsWith` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.endswith
        $({
          target: 'String',
          proto: true,
          forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC
        }, {
          endsWith: function endsWith(searchString          /* , endPosition = @length */
          ) {
            var that = String(requireObjectCoercible(this));
            notARegExp(searchString);
            var endPosition = arguments.length > 1 ? arguments[1] : undefined;
            var len = toLength(that.length);
            var end = endPosition === undefined ? len : min(toLength(endPosition), len);
            var search = String(searchString);
            return nativeEndsWith ? nativeEndsWith.call(that, search, end) : that.slice(end - search.length, end) === search;
          }
        });
      },
      {
        '../internals/correct-is-regexp-logic': 52,
        '../internals/export': 68,
        '../internals/is-pure': 93,
        '../internals/not-a-regexp': 105,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/require-object-coercible': 131,
        '../internals/to-length': 154
      }
    ],
    207: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var notARegExp = _dereq_('../internals/not-a-regexp');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var correctIsRegExpLogic = _dereq_('../internals/correct-is-regexp-logic'); // `String.prototype.includes` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.includes
        $({
          target: 'String',
          proto: true,
          forced: !correctIsRegExpLogic('includes')
        }, {
          includes: function includes(searchString          /* , position = 0 */
          ) {
            return !!~String(requireObjectCoercible(this)).indexOf(notARegExp(searchString), arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/correct-is-regexp-logic': 52,
        '../internals/export': 68,
        '../internals/not-a-regexp': 105,
        '../internals/require-object-coercible': 131
      }
    ],
    208: [
      function (_dereq_, module, exports) {
        'use strict';
        var charAt = _dereq_('../internals/string-multibyte').charAt;
        var InternalStateModule = _dereq_('../internals/internal-state');
        var defineIterator = _dereq_('../internals/define-iterator');
        var STRING_ITERATOR = 'String Iterator';
        var setInternalState = InternalStateModule.set;
        var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR); // `String.prototype[@@iterator]` method
        // https://tc39.github.io/ecma262/#sec-string.prototype-@@iterator
        defineIterator(String, 'String', function (iterated) {
          setInternalState(this, {
            type: STRING_ITERATOR,
            string: String(iterated),
            index: 0
          }); // `%StringIteratorPrototype%.next` method
          // https://tc39.github.io/ecma262/#sec-%stringiteratorprototype%.next
        }, function next() {
          var state = getInternalState(this);
          var string = state.string;
          var index = state.index;
          var point;
          if (index >= string.length) return {
            value: undefined,
            done: true
          };
          point = charAt(string, index);
          state.index += point.length;
          return {
            value: point,
            done: false
          };
        });
      },
      {
        '../internals/define-iterator': 59,
        '../internals/internal-state': 88,
        '../internals/string-multibyte': 141
      }
    ],
    209: [
      function (_dereq_, module, exports) {
        'use strict';
        var fixRegExpWellKnownSymbolLogic = _dereq_('../internals/fix-regexp-well-known-symbol-logic');
        var anObject = _dereq_('../internals/an-object');
        var toLength = _dereq_('../internals/to-length');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var advanceStringIndex = _dereq_('../internals/advance-string-index');
        var regExpExec = _dereq_('../internals/regexp-exec-abstract'); // @@match logic
        fixRegExpWellKnownSymbolLogic('match', 1, function (MATCH, nativeMatch, maybeCallNative) {
          return [ // `String.prototype.match` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.match
          function match(regexp) {
            var O = requireObjectCoercible(this);
            var matcher = regexp == undefined ? undefined : regexp[MATCH];
            return matcher !== undefined ? matcher.call(regexp, O) : new RegExp(regexp) [MATCH](String(O));
          }, // `RegExp.prototype[@@match]` method
          // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@match
          function (regexp) {
            var res = maybeCallNative(nativeMatch, regexp, this);
            if (res.done) return res.value;
            var rx = anObject(regexp);
            var S = String(this);
            if (!rx.global) return regExpExec(rx, S);
            var fullUnicode = rx.unicode;
            rx.lastIndex = 0;
            var A = [
            ];
            var n = 0;
            var result;
            while ((result = regExpExec(rx, S)) !== null) {
              var matchStr = String(result[0]);
              A[n] = matchStr;
              if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
              n++;
            }
            return n === 0 ? null : A;
          }
          ];
        });
      },
      {
        '../internals/advance-string-index': 26,
        '../internals/an-object': 28,
        '../internals/fix-regexp-well-known-symbol-logic': 70,
        '../internals/regexp-exec-abstract': 127,
        '../internals/require-object-coercible': 131,
        '../internals/to-length': 154
      }
    ],
    210: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $padStart = _dereq_('../internals/string-pad').start;
        var WEBKIT_BUG = _dereq_('../internals/string-pad-webkit-bug'); // `String.prototype.padStart` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.padstart
        $({
          target: 'String',
          proto: true,
          forced: WEBKIT_BUG
        }, {
          padStart: function padStart(maxLength          /* , fillString = ' ' */
          ) {
            return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
          }
        });
      },
      {
        '../internals/export': 68,
        '../internals/string-pad': 143,
        '../internals/string-pad-webkit-bug': 142
      }
    ],
    211: [
      function (_dereq_, module, exports) {
        var $ = _dereq_('../internals/export');
        var repeat = _dereq_('../internals/string-repeat'); // `String.prototype.repeat` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.repeat
        $({
          target: 'String',
          proto: true
        }, {
          repeat: repeat
        });
      },
      {
        '../internals/export': 68,
        '../internals/string-repeat': 145
      }
    ],
    212: [
      function (_dereq_, module, exports) {
        'use strict';
        var fixRegExpWellKnownSymbolLogic = _dereq_('../internals/fix-regexp-well-known-symbol-logic');
        var anObject = _dereq_('../internals/an-object');
        var toObject = _dereq_('../internals/to-object');
        var toLength = _dereq_('../internals/to-length');
        var toInteger = _dereq_('../internals/to-integer');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var advanceStringIndex = _dereq_('../internals/advance-string-index');
        var regExpExec = _dereq_('../internals/regexp-exec-abstract');
        var max = Math.max;
        var min = Math.min;
        var floor = Math.floor;
        var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d\d?|<[^>]*>)/g;
        var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d\d?)/g;
        var maybeToString = function (it) {
          return it === undefined ? it : String(it);
        }; // @@replace logic
        fixRegExpWellKnownSymbolLogic('replace', 2, function (REPLACE, nativeReplace, maybeCallNative, reason) {
          var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = reason.REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE;
          var REPLACE_KEEPS_$0 = reason.REPLACE_KEEPS_$0;
          var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';
          return [ // `String.prototype.replace` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.replace
          function replace(searchValue, replaceValue) {
            var O = requireObjectCoercible(this);
            var replacer = searchValue == undefined ? undefined : searchValue[REPLACE];
            return replacer !== undefined ? replacer.call(searchValue, O, replaceValue) : nativeReplace.call(String(O), searchValue, replaceValue);
          }, // `RegExp.prototype[@@replace]` method
          // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace
          function (regexp, replaceValue) {
            if (!REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE && REPLACE_KEEPS_$0 || typeof replaceValue === 'string' && replaceValue.indexOf(UNSAFE_SUBSTITUTE) === - 1) {
              var res = maybeCallNative(nativeReplace, regexp, this, replaceValue);
              if (res.done) return res.value;
            }
            var rx = anObject(regexp);
            var S = String(this);
            var functionalReplace = typeof replaceValue === 'function';
            if (!functionalReplace) replaceValue = String(replaceValue);
            var global = rx.global;
            if (global) {
              var fullUnicode = rx.unicode;
              rx.lastIndex = 0;
            }
            var results = [
            ];
            while (true) {
              var result = regExpExec(rx, S);
              if (result === null) break;
              results.push(result);
              if (!global) break;
              var matchStr = String(result[0]);
              if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
            }
            var accumulatedResult = '';
            var nextSourcePosition = 0;
            for (var i = 0; i < results.length; i++) {
              result = results[i];
              var matched = String(result[0]);
              var position = max(min(toInteger(result.index), S.length), 0);
              var captures = [
              ]; // NOTE: This is equivalent to
              //   captures = result.slice(1).map(maybeToString)
              // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
              // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
              // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
              for (var j = 1; j < result.length; j++) captures.push(maybeToString(result[j]));
              var namedCaptures = result.groups;
              if (functionalReplace) {
                var replacerArgs = [
                  matched
                ].concat(captures, position, S);
                if (namedCaptures !== undefined) replacerArgs.push(namedCaptures);
                var replacement = String(replaceValue.apply(undefined, replacerArgs));
              } else {
                replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
              }
              if (position >= nextSourcePosition) {
                accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
                nextSourcePosition = position + matched.length;
              }
            }
            return accumulatedResult + S.slice(nextSourcePosition);
          }
          ]; // https://tc39.github.io/ecma262/#sec-getsubstitution
          function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
            var tailPos = position + matched.length;
            var m = captures.length;
            var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
            if (namedCaptures !== undefined) {
              namedCaptures = toObject(namedCaptures);
              symbols = SUBSTITUTION_SYMBOLS;
            }
            return nativeReplace.call(replacement, symbols, function (match, ch) {
              var capture;
              switch (ch.charAt(0)) {
                case '$':
                  return '$';
                case '&':
                  return matched;
                case '`':
                  return str.slice(0, position);
                case '\'':
                  return str.slice(tailPos);
                case '<':
                  capture = namedCaptures[ch.slice(1, - 1)];
                  break;
                default:
                  // \d\d?
                  var n = + ch;
                  if (n === 0) return match;
                  if (n > m) {
                    var f = floor(n / 10);
                    if (f === 0) return match;
                    if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
                    return match;
                  }
                  capture = captures[n - 1];
              }
              return capture === undefined ? '' : capture;
            });
          }
        });
      },
      {
        '../internals/advance-string-index': 26,
        '../internals/an-object': 28,
        '../internals/fix-regexp-well-known-symbol-logic': 70,
        '../internals/regexp-exec-abstract': 127,
        '../internals/require-object-coercible': 131,
        '../internals/to-integer': 153,
        '../internals/to-length': 154,
        '../internals/to-object': 155
      }
    ],
    213: [
      function (_dereq_, module, exports) {
        'use strict';
        var fixRegExpWellKnownSymbolLogic = _dereq_('../internals/fix-regexp-well-known-symbol-logic');
        var anObject = _dereq_('../internals/an-object');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var sameValue = _dereq_('../internals/same-value');
        var regExpExec = _dereq_('../internals/regexp-exec-abstract'); // @@search logic
        fixRegExpWellKnownSymbolLogic('search', 1, function (SEARCH, nativeSearch, maybeCallNative) {
          return [ // `String.prototype.search` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.search
          function search(regexp) {
            var O = requireObjectCoercible(this);
            var searcher = regexp == undefined ? undefined : regexp[SEARCH];
            return searcher !== undefined ? searcher.call(regexp, O) : new RegExp(regexp) [SEARCH](String(O));
          }, // `RegExp.prototype[@@search]` method
          // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@search
          function (regexp) {
            var res = maybeCallNative(nativeSearch, regexp, this);
            if (res.done) return res.value;
            var rx = anObject(regexp);
            var S = String(this);
            var previousLastIndex = rx.lastIndex;
            if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
            var result = regExpExec(rx, S);
            if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
            return result === null ? - 1 : result.index;
          }
          ];
        });
      },
      {
        '../internals/an-object': 28,
        '../internals/fix-regexp-well-known-symbol-logic': 70,
        '../internals/regexp-exec-abstract': 127,
        '../internals/require-object-coercible': 131,
        '../internals/same-value': 132
      }
    ],
    214: [
      function (_dereq_, module, exports) {
        'use strict';
        var fixRegExpWellKnownSymbolLogic = _dereq_('../internals/fix-regexp-well-known-symbol-logic');
        var isRegExp = _dereq_('../internals/is-regexp');
        var anObject = _dereq_('../internals/an-object');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var speciesConstructor = _dereq_('../internals/species-constructor');
        var advanceStringIndex = _dereq_('../internals/advance-string-index');
        var toLength = _dereq_('../internals/to-length');
        var callRegExpExec = _dereq_('../internals/regexp-exec-abstract');
        var regexpExec = _dereq_('../internals/regexp-exec');
        var fails = _dereq_('../internals/fails');
        var arrayPush = [
        ].push;
        var min = Math.min;
        var MAX_UINT32 = 4294967295; // babel-minify transpiles RegExp('x', 'y') -> /x/y and it causes SyntaxError
        var SUPPORTS_Y = !fails(function () {
          return !RegExp(MAX_UINT32, 'y');
        }); // @@split logic
        fixRegExpWellKnownSymbolLogic('split', 2, function (SPLIT, nativeSplit, maybeCallNative) {
          var internalSplit;
          if ('abbc'.split(/(b)*/) [1] == 'c' || 'test'.split(/(?:)/, - 1).length != 4 || 'ab'.split(/(?:ab)*/).length != 2 || '.'.split(/(.?)(.?)/).length != 4 || '.'.split(/()()/).length > 1 || ''.split(/.?/).length) {
            // based on es5-shim implementation, need to rework it
            internalSplit = function (separator, limit) {
              var string = String(requireObjectCoercible(this));
              var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
              if (lim === 0) return [];
              if (separator === undefined) return [string]; // If `separator` is not a regex, use native split
              if (!isRegExp(separator)) {
                return nativeSplit.call(string, separator, lim);
              }
              var output = [
              ];
              var flags = (separator.ignoreCase ? 'i' : '') + (separator.multiline ? 'm' : '') + (separator.unicode ? 'u' : '') + (separator.sticky ? 'y' : '');
              var lastLastIndex = 0; // Make `global` and avoid `lastIndex` issues by working with a copy
              var separatorCopy = new RegExp(separator.source, flags + 'g');
              var match,
              lastIndex,
              lastLength;
              while (match = regexpExec.call(separatorCopy, string)) {
                lastIndex = separatorCopy.lastIndex;
                if (lastIndex > lastLastIndex) {
                  output.push(string.slice(lastLastIndex, match.index));
                  if (match.length > 1 && match.index < string.length) arrayPush.apply(output, match.slice(1));
                  lastLength = match[0].length;
                  lastLastIndex = lastIndex;
                  if (output.length >= lim) break;
                }
                if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
              }
              if (lastLastIndex === string.length) {
                if (lastLength || !separatorCopy.test('')) output.push('');
              } else output.push(string.slice(lastLastIndex));
              return output.length > lim ? output.slice(0, lim) : output;
            }; // Chakra, V8
          } else if ('0'.split(undefined, 0).length) {
            internalSplit = function (separator, limit) {
              return separator === undefined && limit === 0 ? [
              ] : nativeSplit.call(this, separator, limit);
            };
          } else internalSplit = nativeSplit;
          return [ // `String.prototype.split` method
          // https://tc39.github.io/ecma262/#sec-string.prototype.split
          function split(separator, limit) {
            var O = requireObjectCoercible(this);
            var splitter = separator == undefined ? undefined : separator[SPLIT];
            return splitter !== undefined ? splitter.call(separator, O, limit) : internalSplit.call(String(O), separator, limit);
          }, // `RegExp.prototype[@@split]` method
          // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@split
          //
          // NOTE: This cannot be properly polyfilled in engines that don't support
          // the 'y' flag.
          function (regexp, limit) {
            var res = maybeCallNative(internalSplit, regexp, this, limit, internalSplit !== nativeSplit);
            if (res.done) return res.value;
            var rx = anObject(regexp);
            var S = String(this);
            var C = speciesConstructor(rx, RegExp);
            var unicodeMatching = rx.unicode;
            var flags = (rx.ignoreCase ? 'i' : '') + (rx.multiline ? 'm' : '') + (rx.unicode ? 'u' : '') + (SUPPORTS_Y ? 'y' : 'g'); // ^(? + rx + ) is needed, in combination with some S slicing, to
            // simulate the 'y' flag.
            var splitter = new C(SUPPORTS_Y ? rx : '^(?:' + rx.source + ')', flags);
            var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
            if (lim === 0) return [];
            if (S.length === 0) return callRegExpExec(splitter, S) === null ? [
              S
            ] : [
            ];
            var p = 0;
            var q = 0;
            var A = [
            ];
            while (q < S.length) {
              splitter.lastIndex = SUPPORTS_Y ? q : 0;
              var z = callRegExpExec(splitter, SUPPORTS_Y ? S : S.slice(q));
              var e;
              if (z === null || (e = min(toLength(splitter.lastIndex + (SUPPORTS_Y ? 0 : q)), S.length)) === p) {
                q = advanceStringIndex(S, q, unicodeMatching);
              } else {
                A.push(S.slice(p, q));
                if (A.length === lim) return A;
                for (var i = 1; i <= z.length - 1; i++) {
                  A.push(z[i]);
                  if (A.length === lim) return A;
                }
                q = p = e;
              }
            }
            A.push(S.slice(p));
            return A;
          }
          ];
        }, !SUPPORTS_Y);
      },
      {
        '../internals/advance-string-index': 26,
        '../internals/an-object': 28,
        '../internals/fails': 69,
        '../internals/fix-regexp-well-known-symbol-logic': 70,
        '../internals/is-regexp': 94,
        '../internals/regexp-exec': 128,
        '../internals/regexp-exec-abstract': 127,
        '../internals/require-object-coercible': 131,
        '../internals/species-constructor': 139,
        '../internals/to-length': 154
      }
    ],
    215: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var getOwnPropertyDescriptor = _dereq_('../internals/object-get-own-property-descriptor').f;
        var toLength = _dereq_('../internals/to-length');
        var notARegExp = _dereq_('../internals/not-a-regexp');
        var requireObjectCoercible = _dereq_('../internals/require-object-coercible');
        var correctIsRegExpLogic = _dereq_('../internals/correct-is-regexp-logic');
        var IS_PURE = _dereq_('../internals/is-pure');
        var nativeStartsWith = ''.startsWith;
        var min = Math.min;
        var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic('startsWith'); // https://github.com/zloirock/core-js/pull/702
        var MDN_POLYFILL_BUG = !IS_PURE && !CORRECT_IS_REGEXP_LOGIC && !!function () {
          var descriptor = getOwnPropertyDescriptor(String.prototype, 'startsWith');
          return descriptor && !descriptor.writable;
        }(); // `String.prototype.startsWith` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.startswith
        $({
          target: 'String',
          proto: true,
          forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC
        }, {
          startsWith: function startsWith(searchString          /* , position = 0 */
          ) {
            var that = String(requireObjectCoercible(this));
            notARegExp(searchString);
            var index = toLength(min(arguments.length > 1 ? arguments[1] : undefined, that.length));
            var search = String(searchString);
            return nativeStartsWith ? nativeStartsWith.call(that, search, index) : that.slice(index, index + search.length) === search;
          }
        });
      },
      {
        '../internals/correct-is-regexp-logic': 52,
        '../internals/export': 68,
        '../internals/is-pure': 93,
        '../internals/not-a-regexp': 105,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/require-object-coercible': 131,
        '../internals/to-length': 154
      }
    ],
    216: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var createHTML = _dereq_('../internals/create-html');
        var forcedStringHTMLMethod = _dereq_('../internals/string-html-forced'); // `String.prototype.sub` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.sub
        $({
          target: 'String',
          proto: true,
          forced: forcedStringHTMLMethod('sub')
        }, {
          sub: function sub() {
            return createHTML(this, 'sub', '', '');
          }
        });
      },
      {
        '../internals/create-html': 54,
        '../internals/export': 68,
        '../internals/string-html-forced': 140
      }
    ],
    217: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var $trim = _dereq_('../internals/string-trim').trim;
        var forcedStringTrimMethod = _dereq_('../internals/string-trim-forced'); // `String.prototype.trim` method
        // https://tc39.github.io/ecma262/#sec-string.prototype.trim
        $({
          target: 'String',
          proto: true,
          forced: forcedStringTrimMethod('trim')
        }, {
          trim: function trim() {
            return $trim(this);
          }
        });
      },
      {
        '../internals/export': 68,
        '../internals/string-trim': 147,
        '../internals/string-trim-forced': 146
      }
    ],
    218: [
      function (_dereq_, module, exports) {
        // `Symbol.prototype.description` getter
        // https://tc39.github.io/ecma262/#sec-symbol.prototype.description
        'use strict';
        var $ = _dereq_('../internals/export');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var global = _dereq_('../internals/global');
        var has = _dereq_('../internals/has');
        var isObject = _dereq_('../internals/is-object');
        var defineProperty = _dereq_('../internals/object-define-property').f;
        var copyConstructorProperties = _dereq_('../internals/copy-constructor-properties');
        var NativeSymbol = global.Symbol;
        if (DESCRIPTORS && typeof NativeSymbol == 'function' && (!('description' in NativeSymbol.prototype) || // Safari 12 bug
        NativeSymbol().description !== undefined)) {
          var EmptyStringDescriptionStore = {
          }; // wrap Symbol constructor for correct work with undefined description
          var SymbolWrapper = function Symbol() {
            var description = arguments.length < 1 || arguments[0] === undefined ? undefined : String(arguments[0]);
            var result = this instanceof SymbolWrapper ? new NativeSymbol(description) // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
             : description === undefined ? NativeSymbol() : NativeSymbol(description);
            if (description === '') EmptyStringDescriptionStore[result] = true;
            return result;
          };
          copyConstructorProperties(SymbolWrapper, NativeSymbol);
          var symbolPrototype = SymbolWrapper.prototype = NativeSymbol.prototype;
          symbolPrototype.constructor = SymbolWrapper;
          var symbolToString = symbolPrototype.toString;
          var native = String(NativeSymbol('test')) == 'Symbol(test)';
          var regexp = /^Symbol\((.*)\)[^)]+$/;
          defineProperty(symbolPrototype, 'description', {
            configurable: true,
            get: function description() {
              var symbol = isObject(this) ? this.valueOf() : this;
              var string = symbolToString.call(symbol);
              if (has(EmptyStringDescriptionStore, symbol)) return '';
              var desc = native ? string.slice(7, - 1) : string.replace(regexp, '$1');
              return desc === '' ? undefined : desc;
            }
          });
          $({
            global: true,
            forced: true
          }, {
            Symbol: SymbolWrapper
          });
        }
      },
      {
        '../internals/copy-constructor-properties': 51,
        '../internals/descriptors': 61,
        '../internals/export': 68,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/is-object': 92,
        '../internals/object-define-property': 110
      }
    ],
    219: [
      function (_dereq_, module, exports) {
        var defineWellKnownSymbol = _dereq_('../internals/define-well-known-symbol'); // `Symbol.iterator` well-known symbol
        // https://tc39.github.io/ecma262/#sec-symbol.iterator
        defineWellKnownSymbol('iterator');
      },
      {
        '../internals/define-well-known-symbol': 60
      }
    ],
    220: [
      function (_dereq_, module, exports) {
        'use strict';
        var $ = _dereq_('../internals/export');
        var global = _dereq_('../internals/global');
        var getBuiltIn = _dereq_('../internals/get-built-in');
        var IS_PURE = _dereq_('../internals/is-pure');
        var DESCRIPTORS = _dereq_('../internals/descriptors');
        var NATIVE_SYMBOL = _dereq_('../internals/native-symbol');
        var USE_SYMBOL_AS_UID = _dereq_('../internals/use-symbol-as-uid');
        var fails = _dereq_('../internals/fails');
        var has = _dereq_('../internals/has');
        var isArray = _dereq_('../internals/is-array');
        var isObject = _dereq_('../internals/is-object');
        var anObject = _dereq_('../internals/an-object');
        var toObject = _dereq_('../internals/to-object');
        var toIndexedObject = _dereq_('../internals/to-indexed-object');
        var toPrimitive = _dereq_('../internals/to-primitive');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        var nativeObjectCreate = _dereq_('../internals/object-create');
        var objectKeys = _dereq_('../internals/object-keys');
        var getOwnPropertyNamesModule = _dereq_('../internals/object-get-own-property-names');
        var getOwnPropertyNamesExternal = _dereq_('../internals/object-get-own-property-names-external');
        var getOwnPropertySymbolsModule = _dereq_('../internals/object-get-own-property-symbols');
        var getOwnPropertyDescriptorModule = _dereq_('../internals/object-get-own-property-descriptor');
        var definePropertyModule = _dereq_('../internals/object-define-property');
        var propertyIsEnumerableModule = _dereq_('../internals/object-property-is-enumerable');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var redefine = _dereq_('../internals/redefine');
        var shared = _dereq_('../internals/shared');
        var sharedKey = _dereq_('../internals/shared-key');
        var hiddenKeys = _dereq_('../internals/hidden-keys');
        var uid = _dereq_('../internals/uid');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var wrappedWellKnownSymbolModule = _dereq_('../internals/well-known-symbol-wrapped');
        var defineWellKnownSymbol = _dereq_('../internals/define-well-known-symbol');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var $forEach = _dereq_('../internals/array-iteration').forEach;
        var HIDDEN = sharedKey('hidden');
        var SYMBOL = 'Symbol';
        var PROTOTYPE = 'prototype';
        var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
        var setInternalState = InternalStateModule.set;
        var getInternalState = InternalStateModule.getterFor(SYMBOL);
        var ObjectPrototype = Object[PROTOTYPE];
        var $Symbol = global.Symbol;
        var $stringify = getBuiltIn('JSON', 'stringify');
        var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
        var nativeDefineProperty = definePropertyModule.f;
        var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
        var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
        var AllSymbols = shared('symbols');
        var ObjectPrototypeSymbols = shared('op-symbols');
        var StringToSymbolRegistry = shared('string-to-symbol-registry');
        var SymbolToStringRegistry = shared('symbol-to-string-registry');
        var WellKnownSymbolsStore = shared('wks');
        var QObject = global.QObject; // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
        var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild; // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
        var setSymbolDescriptor = DESCRIPTORS && fails(function () {
          return nativeObjectCreate(nativeDefineProperty({
          }, 'a', {
            get: function () {
              return nativeDefineProperty(this, 'a', {
                value: 7
              }).a;
            }
          })).a != 7;
        }) ? function (O, P, Attributes) {
          var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor(ObjectPrototype, P);
          if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
          nativeDefineProperty(O, P, Attributes);
          if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
            nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
          }
        }
         : nativeDefineProperty;
        var wrap = function (tag, description) {
          var symbol = AllSymbols[tag] = nativeObjectCreate($Symbol[PROTOTYPE]);
          setInternalState(symbol, {
            type: SYMBOL,
            tag: tag,
            description: description
          });
          if (!DESCRIPTORS) symbol.description = description;
          return symbol;
        };
        var isSymbol = USE_SYMBOL_AS_UID ? function (it) {
          return typeof it == 'symbol';
        }
         : function (it) {
          return Object(it) instanceof $Symbol;
        };
        var $defineProperty = function defineProperty(O, P, Attributes) {
          if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
          anObject(O);
          var key = toPrimitive(P, true);
          anObject(Attributes);
          if (has(AllSymbols, key)) {
            if (!Attributes.enumerable) {
              if (!has(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, {
              }));
              O[HIDDEN][key] = true;
            } else {
              if (has(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
              Attributes = nativeObjectCreate(Attributes, {
                enumerable: createPropertyDescriptor(0, false)
              });
            }
            return setSymbolDescriptor(O, key, Attributes);
          }
          return nativeDefineProperty(O, key, Attributes);
        };
        var $defineProperties = function defineProperties(O, Properties) {
          anObject(O);
          var properties = toIndexedObject(Properties);
          var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
          $forEach(keys, function (key) {
            if (!DESCRIPTORS || $propertyIsEnumerable.call(properties, key)) $defineProperty(O, key, properties[key]);
          });
          return O;
        };
        var $create = function create(O, Properties) {
          return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
        };
        var $propertyIsEnumerable = function propertyIsEnumerable(V) {
          var P = toPrimitive(V, true);
          var enumerable = nativePropertyIsEnumerable.call(this, P);
          if (this === ObjectPrototype && has(AllSymbols, P) && !has(ObjectPrototypeSymbols, P)) return false;
          return enumerable || !has(this, P) || !has(AllSymbols, P) || has(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
        };
        var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
          var it = toIndexedObject(O);
          var key = toPrimitive(P, true);
          if (it === ObjectPrototype && has(AllSymbols, key) && !has(ObjectPrototypeSymbols, key)) return;
          var descriptor = nativeGetOwnPropertyDescriptor(it, key);
          if (descriptor && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) {
            descriptor.enumerable = true;
          }
          return descriptor;
        };
        var $getOwnPropertyNames = function getOwnPropertyNames(O) {
          var names = nativeGetOwnPropertyNames(toIndexedObject(O));
          var result = [
          ];
          $forEach(names, function (key) {
            if (!has(AllSymbols, key) && !has(hiddenKeys, key)) result.push(key);
          });
          return result;
        };
        var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
          var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
          var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
          var result = [
          ];
          $forEach(names, function (key) {
            if (has(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || has(ObjectPrototype, key))) {
              result.push(AllSymbols[key]);
            }
          });
          return result;
        }; // `Symbol` constructor
        // https://tc39.github.io/ecma262/#sec-symbol-constructor
        if (!NATIVE_SYMBOL) {
          $Symbol = function Symbol() {
            if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor');
            var description = !arguments.length || arguments[0] === undefined ? undefined : String(arguments[0]);
            var tag = uid(description);
            var setter = function (value) {
              if (this === ObjectPrototype) setter.call(ObjectPrototypeSymbols, value);
              if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
              setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
            };
            if (DESCRIPTORS && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, {
              configurable: true,
              set: setter
            });
            return wrap(tag, description);
          };
          redefine($Symbol[PROTOTYPE], 'toString', function toString() {
            return getInternalState(this).tag;
          });
          redefine($Symbol, 'withoutSetter', function (description) {
            return wrap(uid(description), description);
          });
          propertyIsEnumerableModule.f = $propertyIsEnumerable;
          definePropertyModule.f = $defineProperty;
          getOwnPropertyDescriptorModule.f = $getOwnPropertyDescriptor;
          getOwnPropertyNamesModule.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
          getOwnPropertySymbolsModule.f = $getOwnPropertySymbols;
          wrappedWellKnownSymbolModule.f = function (name) {
            return wrap(wellKnownSymbol(name), name);
          };
          if (DESCRIPTORS) {
            // https://github.com/tc39/proposal-Symbol-description
            nativeDefineProperty($Symbol[PROTOTYPE], 'description', {
              configurable: true,
              get: function description() {
                return getInternalState(this).description;
              }
            });
            if (!IS_PURE) {
              redefine(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, {
                unsafe: true
              });
            }
          }
        }
        $({
          global: true,
          wrap: true,
          forced: !NATIVE_SYMBOL,
          sham: !NATIVE_SYMBOL
        }, {
          Symbol: $Symbol
        });
        $forEach(objectKeys(WellKnownSymbolsStore), function (name) {
          defineWellKnownSymbol(name);
        });
        $({
          target: SYMBOL,
          stat: true,
          forced: !NATIVE_SYMBOL
        }, {
          // `Symbol.for` method
          // https://tc39.github.io/ecma262/#sec-symbol.for
          'for': function (key) {
            var string = String(key);
            if (has(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
            var symbol = $Symbol(string);
            StringToSymbolRegistry[string] = symbol;
            SymbolToStringRegistry[symbol] = string;
            return symbol;
          },
          // `Symbol.keyFor` method
          // https://tc39.github.io/ecma262/#sec-symbol.keyfor
          keyFor: function keyFor(sym) {
            if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol');
            if (has(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
          },
          useSetter: function () {
            USE_SETTER = true;
          },
          useSimple: function () {
            USE_SETTER = false;
          }
        });
        $({
          target: 'Object',
          stat: true,
          forced: !NATIVE_SYMBOL,
          sham: !DESCRIPTORS
        }, {
          // `Object.create` method
          // https://tc39.github.io/ecma262/#sec-object.create
          create: $create,
          // `Object.defineProperty` method
          // https://tc39.github.io/ecma262/#sec-object.defineproperty
          defineProperty: $defineProperty,
          // `Object.defineProperties` method
          // https://tc39.github.io/ecma262/#sec-object.defineproperties
          defineProperties: $defineProperties,
          // `Object.getOwnPropertyDescriptor` method
          // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors
          getOwnPropertyDescriptor: $getOwnPropertyDescriptor
        });
        $({
          target: 'Object',
          stat: true,
          forced: !NATIVE_SYMBOL
        }, {
          // `Object.getOwnPropertyNames` method
          // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
          getOwnPropertyNames: $getOwnPropertyNames,
          // `Object.getOwnPropertySymbols` method
          // https://tc39.github.io/ecma262/#sec-object.getownpropertysymbols
          getOwnPropertySymbols: $getOwnPropertySymbols
        }); // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
        // https://bugs.chromium.org/p/v8/issues/detail?id=3443
        $({
          target: 'Object',
          stat: true,
          forced: fails(function () {
            getOwnPropertySymbolsModule.f(1);
          })
        }, {
          getOwnPropertySymbols: function getOwnPropertySymbols(it) {
            return getOwnPropertySymbolsModule.f(toObject(it));
          }
        }); // `JSON.stringify` method behavior with symbols
        // https://tc39.github.io/ecma262/#sec-json.stringify
        if ($stringify) {
          var FORCED_JSON_STRINGIFY = !NATIVE_SYMBOL || fails(function () {
            var symbol = $Symbol(); // MS Edge converts symbol values to JSON as {}
            return $stringify([symbol]) != '[null]' // WebKit converts symbol values to JSON as null
            || $stringify({
              a: symbol
            }) != '{}' // V8 throws on boxed symbols
            || $stringify(Object(symbol)) != '{}';
          });
          $({
            target: 'JSON',
            stat: true,
            forced: FORCED_JSON_STRINGIFY
          }, {
            // eslint-disable-next-line no-unused-vars
            stringify: function stringify(it, replacer, space) {
              var args = [
                it
              ];
              var index = 1;
              var $replacer;
              while (arguments.length > index) args.push(arguments[index++]);
              $replacer = replacer;
              if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
              if (!isArray(replacer)) replacer = function (key, value) {
                if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
                if (!isSymbol(value)) return value;
              };
              args[1] = replacer;
              return $stringify.apply(null, args);
            }
          });
        } // `Symbol.prototype[@@toPrimitive]` method
        // https://tc39.github.io/ecma262/#sec-symbol.prototype-@@toprimitive

        if (!$Symbol[PROTOTYPE][TO_PRIMITIVE]) {
          createNonEnumerableProperty($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
        } // `Symbol.prototype[@@toStringTag]` property
        // https://tc39.github.io/ecma262/#sec-symbol.prototype-@@tostringtag

        setToStringTag($Symbol, SYMBOL);
        hiddenKeys[HIDDEN] = true;
      },
      {
        '../internals/an-object': 28,
        '../internals/array-iteration': 37,
        '../internals/create-non-enumerable-property': 56,
        '../internals/create-property-descriptor': 57,
        '../internals/define-well-known-symbol': 60,
        '../internals/descriptors': 61,
        '../internals/export': 68,
        '../internals/fails': 69,
        '../internals/get-built-in': 74,
        '../internals/global': 77,
        '../internals/has': 78,
        '../internals/hidden-keys': 79,
        '../internals/internal-state': 88,
        '../internals/is-array': 90,
        '../internals/is-object': 92,
        '../internals/is-pure': 93,
        '../internals/native-symbol': 101,
        '../internals/object-create': 108,
        '../internals/object-define-property': 110,
        '../internals/object-get-own-property-descriptor': 111,
        '../internals/object-get-own-property-names': 113,
        '../internals/object-get-own-property-names-external': 112,
        '../internals/object-get-own-property-symbols': 114,
        '../internals/object-keys': 117,
        '../internals/object-property-is-enumerable': 118,
        '../internals/redefine': 126,
        '../internals/set-to-string-tag': 135,
        '../internals/shared': 138,
        '../internals/shared-key': 136,
        '../internals/to-indexed-object': 152,
        '../internals/to-object': 155,
        '../internals/to-primitive': 158,
        '../internals/uid': 163,
        '../internals/use-symbol-as-uid': 164,
        '../internals/well-known-symbol': 166,
        '../internals/well-known-symbol-wrapped': 165
      }
    ],
    221: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $copyWithin = _dereq_('../internals/array-copy-within');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.copyWithin` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.copywithin
        exportTypedArrayMethod('copyWithin', function copyWithin(target, start        /* , end */
        ) {
          return $copyWithin.call(aTypedArray(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-copy-within': 32
      }
    ],
    222: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $every = _dereq_('../internals/array-iteration').every;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.every` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.every
        exportTypedArrayMethod('every', function every(callbackfn        /* , thisArg */
        ) {
          return $every(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37
      }
    ],
    223: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $fill = _dereq_('../internals/array-fill');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.fill` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.fill
        // eslint-disable-next-line no-unused-vars
        exportTypedArrayMethod('fill', function fill(value        /* , start, end */
        ) {
          return $fill.apply(aTypedArray(this), arguments);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-fill': 33
      }
    ],
    224: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $filter = _dereq_('../internals/array-iteration').filter;
        var speciesConstructor = _dereq_('../internals/species-constructor');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.filter` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.filter
        exportTypedArrayMethod('filter', function filter(callbackfn        /* , thisArg */
        ) {
          var list = $filter(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
          var C = speciesConstructor(this, this.constructor);
          var index = 0;
          var length = list.length;
          var result = new (aTypedArrayConstructor(C)) (length);
          while (length > index) result[index] = list[index++];
          return result;
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37,
        '../internals/species-constructor': 139
      }
    ],
    225: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $findIndex = _dereq_('../internals/array-iteration').findIndex;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.findIndex` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.findindex
        exportTypedArrayMethod('findIndex', function findIndex(predicate        /* , thisArg */
        ) {
          return $findIndex(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37
      }
    ],
    226: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $find = _dereq_('../internals/array-iteration').find;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.find` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.find
        exportTypedArrayMethod('find', function find(predicate        /* , thisArg */
        ) {
          return $find(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37
      }
    ],
    227: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Float32Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Float32', function (init) {
          return function Float32Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    228: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Float64Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Float64', function (init) {
          return function Float64Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    229: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $forEach = _dereq_('../internals/array-iteration').forEach;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.forEach` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.foreach
        exportTypedArrayMethod('forEach', function forEach(callbackfn        /* , thisArg */
        ) {
          $forEach(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37
      }
    ],
    230: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $includes = _dereq_('../internals/array-includes').includes;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.includes` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.includes
        exportTypedArrayMethod('includes', function includes(searchElement        /* , fromIndex */
        ) {
          return $includes(aTypedArray(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-includes': 36
      }
    ],
    231: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $indexOf = _dereq_('../internals/array-includes').indexOf;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.indexOf` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.indexof
        exportTypedArrayMethod('indexOf', function indexOf(searchElement        /* , fromIndex */
        ) {
          return $indexOf(aTypedArray(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-includes': 36
      }
    ],
    232: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Int16Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Int16', function (init) {
          return function Int16Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    233: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Int32Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Int32', function (init) {
          return function Int32Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    234: [
      function (_dereq_, module, exports) {
        'use strict';
        var global = _dereq_('../internals/global');
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var ArrayIterators = _dereq_('../modules/es.array.iterator');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var ITERATOR = wellKnownSymbol('iterator');
        var Uint8Array = global.Uint8Array;
        var arrayValues = ArrayIterators.values;
        var arrayKeys = ArrayIterators.keys;
        var arrayEntries = ArrayIterators.entries;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var nativeTypedArrayIterator = Uint8Array && Uint8Array.prototype[ITERATOR];
        var CORRECT_ITER_NAME = !!nativeTypedArrayIterator && (nativeTypedArrayIterator.name == 'values' || nativeTypedArrayIterator.name == undefined);
        var typedArrayValues = function values() {
          return arrayValues.call(aTypedArray(this));
        }; // `%TypedArray%.prototype.entries` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.entries
        exportTypedArrayMethod('entries', function entries() {
          return arrayEntries.call(aTypedArray(this));
        }); // `%TypedArray%.prototype.keys` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.keys
        exportTypedArrayMethod('keys', function keys() {
          return arrayKeys.call(aTypedArray(this));
        }); // `%TypedArray%.prototype.values` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.values
        exportTypedArrayMethod('values', typedArrayValues, !CORRECT_ITER_NAME); // `%TypedArray%.prototype[@@iterator]` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype-@@iterator
        exportTypedArrayMethod(ITERATOR, typedArrayValues, !CORRECT_ITER_NAME);
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/global': 77,
        '../internals/well-known-symbol': 166,
        '../modules/es.array.iterator': 178
      }
    ],
    235: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var $join = [
        ].join; // `%TypedArray%.prototype.join` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.join
        // eslint-disable-next-line no-unused-vars
        exportTypedArrayMethod('join', function join(separator) {
          return $join.apply(aTypedArray(this), arguments);
        });
      },
      {
        '../internals/array-buffer-view-core': 30
      }
    ],
    236: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $lastIndexOf = _dereq_('../internals/array-last-index-of');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.lastIndexOf` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.lastindexof
        // eslint-disable-next-line no-unused-vars
        exportTypedArrayMethod('lastIndexOf', function lastIndexOf(searchElement        /* , fromIndex */
        ) {
          return $lastIndexOf.apply(aTypedArray(this), arguments);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-last-index-of': 38
      }
    ],
    237: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $map = _dereq_('../internals/array-iteration').map;
        var speciesConstructor = _dereq_('../internals/species-constructor');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.map` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.map
        exportTypedArrayMethod('map', function map(mapfn        /* , thisArg */
        ) {
          return $map(aTypedArray(this), mapfn, arguments.length > 1 ? arguments[1] : undefined, function (O, length) {
            return new (aTypedArrayConstructor(speciesConstructor(O, O.constructor))) (length);
          });
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37,
        '../internals/species-constructor': 139
      }
    ],
    238: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $reduceRight = _dereq_('../internals/array-reduce').right;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.reduceRicht` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reduceright
        exportTypedArrayMethod('reduceRight', function reduceRight(callbackfn        /* , initialValue */
        ) {
          return $reduceRight(aTypedArray(this), callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-reduce': 42
      }
    ],
    239: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $reduce = _dereq_('../internals/array-reduce').left;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.reduce` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reduce
        exportTypedArrayMethod('reduce', function reduce(callbackfn        /* , initialValue */
        ) {
          return $reduce(aTypedArray(this), callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-reduce': 42
      }
    ],
    240: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var floor = Math.floor; // `%TypedArray%.prototype.reverse` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reverse
        exportTypedArrayMethod('reverse', function reverse() {
          var that = this;
          var length = aTypedArray(that).length;
          var middle = floor(length / 2);
          var index = 0;
          var value;
          while (index < middle) {
            value = that[index];
            that[index++] = that[--length];
            that[length] = value;
          }
          return that;
        });
      },
      {
        '../internals/array-buffer-view-core': 30
      }
    ],
    241: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var toLength = _dereq_('../internals/to-length');
        var toOffset = _dereq_('../internals/to-offset');
        var toObject = _dereq_('../internals/to-object');
        var fails = _dereq_('../internals/fails');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var FORCED = fails(function () {
          // eslint-disable-next-line no-undef
          new Int8Array(1).set({
          });
        }); // `%TypedArray%.prototype.set` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.set
        exportTypedArrayMethod('set', function set(arrayLike        /* , offset */
        ) {
          aTypedArray(this);
          var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
          var length = this.length;
          var src = toObject(arrayLike);
          var len = toLength(src.length);
          var index = 0;
          if (len + offset > length) throw RangeError('Wrong length');
          while (index < len) this[offset + index] = src[index++];
        }, FORCED);
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/fails': 69,
        '../internals/to-length': 154,
        '../internals/to-object': 155,
        '../internals/to-offset': 156
      }
    ],
    242: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var speciesConstructor = _dereq_('../internals/species-constructor');
        var fails = _dereq_('../internals/fails');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var $slice = [
        ].slice;
        var FORCED = fails(function () {
          // eslint-disable-next-line no-undef
          new Int8Array(1).slice();
        }); // `%TypedArray%.prototype.slice` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.slice
        exportTypedArrayMethod('slice', function slice(start, end) {
          var list = $slice.call(aTypedArray(this), start, end);
          var C = speciesConstructor(this, this.constructor);
          var index = 0;
          var length = list.length;
          var result = new (aTypedArrayConstructor(C)) (length);
          while (length > index) result[index] = list[index++];
          return result;
        }, FORCED);
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/fails': 69,
        '../internals/species-constructor': 139
      }
    ],
    243: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var $some = _dereq_('../internals/array-iteration').some;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.some` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.some
        exportTypedArrayMethod('some', function some(callbackfn        /* , thisArg */
        ) {
          return $some(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/array-iteration': 37
      }
    ],
    244: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var $sort = [
        ].sort; // `%TypedArray%.prototype.sort` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.sort
        exportTypedArrayMethod('sort', function sort(comparefn) {
          return $sort.call(aTypedArray(this), comparefn);
        });
      },
      {
        '../internals/array-buffer-view-core': 30
      }
    ],
    245: [
      function (_dereq_, module, exports) {
        'use strict';
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var toLength = _dereq_('../internals/to-length');
        var toAbsoluteIndex = _dereq_('../internals/to-absolute-index');
        var speciesConstructor = _dereq_('../internals/species-constructor');
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.subarray` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.subarray
        exportTypedArrayMethod('subarray', function subarray(begin, end) {
          var O = aTypedArray(this);
          var length = O.length;
          var beginIndex = toAbsoluteIndex(begin, length);
          return new (speciesConstructor(O, O.constructor)) (O.buffer, O.byteOffset + beginIndex * O.BYTES_PER_ELEMENT, toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - beginIndex));
        });
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/species-constructor': 139,
        '../internals/to-absolute-index': 150,
        '../internals/to-length': 154
      }
    ],
    246: [
      function (_dereq_, module, exports) {
        'use strict';
        var global = _dereq_('../internals/global');
        var ArrayBufferViewCore = _dereq_('../internals/array-buffer-view-core');
        var fails = _dereq_('../internals/fails');
        var Int8Array = global.Int8Array;
        var aTypedArray = ArrayBufferViewCore.aTypedArray;
        var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
        var $toLocaleString = [
        ].toLocaleString;
        var $slice = [
        ].slice; // iOS Safari 6.x fails here
        var TO_LOCALE_STRING_BUG = !!Int8Array && fails(function () {
          $toLocaleString.call(new Int8Array(1));
        });
        var FORCED = fails(function () {
          return [1,
          2].toLocaleString() != new Int8Array([1,
          2]).toLocaleString();
        }) || !fails(function () {
          Int8Array.prototype.toLocaleString.call([1,
          2]);
        }); // `%TypedArray%.prototype.toLocaleString` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.tolocalestring
        exportTypedArrayMethod('toLocaleString', function toLocaleString() {
          return $toLocaleString.apply(TO_LOCALE_STRING_BUG ? $slice.call(aTypedArray(this)) : aTypedArray(this), arguments);
        }, FORCED);
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/fails': 69,
        '../internals/global': 77
      }
    ],
    247: [
      function (_dereq_, module, exports) {
        'use strict';
        var exportTypedArrayMethod = _dereq_('../internals/array-buffer-view-core').exportTypedArrayMethod;
        var fails = _dereq_('../internals/fails');
        var global = _dereq_('../internals/global');
        var Uint8Array = global.Uint8Array;
        var Uint8ArrayPrototype = Uint8Array && Uint8Array.prototype || {
        };
        var arrayToString = [
        ].toString;
        var arrayJoin = [
        ].join;
        if (fails(function () {
          arrayToString.call({
          });
        })) {
          arrayToString = function toString() {
            return arrayJoin.call(this);
          };
        }
        var IS_NOT_ARRAY_METHOD = Uint8ArrayPrototype.toString != arrayToString; // `%TypedArray%.prototype.toString` method
        // https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.tostring
        exportTypedArrayMethod('toString', arrayToString, IS_NOT_ARRAY_METHOD);
      },
      {
        '../internals/array-buffer-view-core': 30,
        '../internals/fails': 69,
        '../internals/global': 77
      }
    ],
    248: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Uint16Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Uint16', function (init) {
          return function Uint16Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    249: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Uint32Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Uint32', function (init) {
          return function Uint32Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    250: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Uint8Array` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Uint8', function (init) {
          return function Uint8Array(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        });
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    251: [
      function (_dereq_, module, exports) {
        var createTypedArrayConstructor = _dereq_('../internals/typed-array-constructor'); // `Uint8ClampedArray` constructor
        // https://tc39.github.io/ecma262/#sec-typedarray-objects
        createTypedArrayConstructor('Uint8', function (init) {
          return function Uint8ClampedArray(data, byteOffset, length) {
            return init(this, data, byteOffset, length);
          };
        }, true);
      },
      {
        '../internals/typed-array-constructor': 160
      }
    ],
    252: [
      function (_dereq_, module, exports) {
        'use strict';
        var global = _dereq_('../internals/global');
        var redefineAll = _dereq_('../internals/redefine-all');
        var InternalMetadataModule = _dereq_('../internals/internal-metadata');
        var collection = _dereq_('../internals/collection');
        var collectionWeak = _dereq_('../internals/collection-weak');
        var isObject = _dereq_('../internals/is-object');
        var enforceIternalState = _dereq_('../internals/internal-state').enforce;
        var NATIVE_WEAK_MAP = _dereq_('../internals/native-weak-map');
        var IS_IE11 = !global.ActiveXObject && 'ActiveXObject' in global;
        var isExtensible = Object.isExtensible;
        var InternalWeakMap;
        var wrapper = function (init) {
          return function WeakMap() {
            return init(this, arguments.length ? arguments[0] : undefined);
          };
        }; // `WeakMap` constructor
        // https://tc39.github.io/ecma262/#sec-weakmap-constructor
        var $WeakMap = module.exports = collection('WeakMap', wrapper, collectionWeak); // IE11 WeakMap frozen keys fix
        // We can't use feature detection because it crash some old IE builds
        // https://github.com/zloirock/core-js/issues/485
        if (NATIVE_WEAK_MAP && IS_IE11) {
          InternalWeakMap = collectionWeak.getConstructor(wrapper, 'WeakMap', true);
          InternalMetadataModule.REQUIRED = true;
          var WeakMapPrototype = $WeakMap.prototype;
          var nativeDelete = WeakMapPrototype['delete'];
          var nativeHas = WeakMapPrototype.has;
          var nativeGet = WeakMapPrototype.get;
          var nativeSet = WeakMapPrototype.set;
          redefineAll(WeakMapPrototype, {
            'delete': function (key) {
              if (isObject(key) && !isExtensible(key)) {
                var state = enforceIternalState(this);
                if (!state.frozen) state.frozen = new InternalWeakMap();
                return nativeDelete.call(this, key) || state.frozen['delete'](key);
              }
              return nativeDelete.call(this, key);
            },
            has: function has(key) {
              if (isObject(key) && !isExtensible(key)) {
                var state = enforceIternalState(this);
                if (!state.frozen) state.frozen = new InternalWeakMap();
                return nativeHas.call(this, key) || state.frozen.has(key);
              }
              return nativeHas.call(this, key);
            },
            get: function get(key) {
              if (isObject(key) && !isExtensible(key)) {
                var state = enforceIternalState(this);
                if (!state.frozen) state.frozen = new InternalWeakMap();
                return nativeHas.call(this, key) ? nativeGet.call(this, key) : state.frozen.get(key);
              }
              return nativeGet.call(this, key);
            },
            set: function set(key, value) {
              if (isObject(key) && !isExtensible(key)) {
                var state = enforceIternalState(this);
                if (!state.frozen) state.frozen = new InternalWeakMap();
                nativeHas.call(this, key) ? nativeSet.call(this, key, value) : state.frozen.set(key, value);
              } else nativeSet.call(this, key, value);
              return this;
            }
          });
        }
      },
      {
        '../internals/collection': 50,
        '../internals/collection-weak': 49,
        '../internals/global': 77,
        '../internals/internal-metadata': 87,
        '../internals/internal-state': 88,
        '../internals/is-object': 92,
        '../internals/native-weak-map': 103,
        '../internals/redefine-all': 125
      }
    ],
    253: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var DOMIterables = _dereq_('../internals/dom-iterables');
        var forEach = _dereq_('../internals/array-for-each');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        for (var COLLECTION_NAME in DOMIterables) {
          var Collection = global[COLLECTION_NAME];
          var CollectionPrototype = Collection && Collection.prototype; // some Chrome versions have non-configurable methods on DOMTokenList
          if (CollectionPrototype && CollectionPrototype.forEach !== forEach) try {
            createNonEnumerableProperty(CollectionPrototype, 'forEach', forEach);
          } catch (error) {
            CollectionPrototype.forEach = forEach;
          }
        }
      },
      {
        '../internals/array-for-each': 34,
        '../internals/create-non-enumerable-property': 56,
        '../internals/dom-iterables': 63,
        '../internals/global': 77
      }
    ],
    254: [
      function (_dereq_, module, exports) {
        var global = _dereq_('../internals/global');
        var DOMIterables = _dereq_('../internals/dom-iterables');
        var ArrayIteratorMethods = _dereq_('../modules/es.array.iterator');
        var createNonEnumerableProperty = _dereq_('../internals/create-non-enumerable-property');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var ITERATOR = wellKnownSymbol('iterator');
        var TO_STRING_TAG = wellKnownSymbol('toStringTag');
        var ArrayValues = ArrayIteratorMethods.values;
        for (var COLLECTION_NAME in DOMIterables) {
          var Collection = global[COLLECTION_NAME];
          var CollectionPrototype = Collection && Collection.prototype;
          if (CollectionPrototype) {
            // some Chrome versions have non-configurable methods on DOMTokenList
            if (CollectionPrototype[ITERATOR] !== ArrayValues) try {
              createNonEnumerableProperty(CollectionPrototype, ITERATOR, ArrayValues);
            } catch (error) {
              CollectionPrototype[ITERATOR] = ArrayValues;
            }
            if (!CollectionPrototype[TO_STRING_TAG]) {
              createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
            }
            if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
              // some Chrome versions have non-configurable methods on DOMTokenList
              if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
                createNonEnumerableProperty(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
              } catch (error) {
                CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
              }
            }
          }
        }
      },
      {
        '../internals/create-non-enumerable-property': 56,
        '../internals/dom-iterables': 63,
        '../internals/global': 77,
        '../internals/well-known-symbol': 166,
        '../modules/es.array.iterator': 178
      }
    ],
    255: [
      function (_dereq_, module, exports) {
        'use strict'; // TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`
        _dereq_('../modules/es.array.iterator');
        var $ = _dereq_('../internals/export');
        var getBuiltIn = _dereq_('../internals/get-built-in');
        var USE_NATIVE_URL = _dereq_('../internals/native-url');
        var redefine = _dereq_('../internals/redefine');
        var redefineAll = _dereq_('../internals/redefine-all');
        var setToStringTag = _dereq_('../internals/set-to-string-tag');
        var createIteratorConstructor = _dereq_('../internals/create-iterator-constructor');
        var InternalStateModule = _dereq_('../internals/internal-state');
        var anInstance = _dereq_('../internals/an-instance');
        var hasOwn = _dereq_('../internals/has');
        var bind = _dereq_('../internals/function-bind-context');
        var classof = _dereq_('../internals/classof');
        var anObject = _dereq_('../internals/an-object');
        var isObject = _dereq_('../internals/is-object');
        var create = _dereq_('../internals/object-create');
        var createPropertyDescriptor = _dereq_('../internals/create-property-descriptor');
        var getIterator = _dereq_('../internals/get-iterator');
        var getIteratorMethod = _dereq_('../internals/get-iterator-method');
        var wellKnownSymbol = _dereq_('../internals/well-known-symbol');
        var $fetch = getBuiltIn('fetch');
        var Headers = getBuiltIn('Headers');
        var ITERATOR = wellKnownSymbol('iterator');
        var URL_SEARCH_PARAMS = 'URLSearchParams';
        var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
        var setInternalState = InternalStateModule.set;
        var getInternalParamsState = InternalStateModule.getterFor(URL_SEARCH_PARAMS);
        var getInternalIteratorState = InternalStateModule.getterFor(URL_SEARCH_PARAMS_ITERATOR);
        var plus = /\+/g;
        var sequences = Array(4);
        var percentSequence = function (bytes) {
          return sequences[bytes - 1] || (sequences[bytes - 1] = RegExp('((?:%[\\da-f]{2}){' + bytes + '})', 'gi'));
        };
        var percentDecode = function (sequence) {
          try {
            return decodeURIComponent(sequence);
          } catch (error) {
            return sequence;
          }
        };
        var deserialize = function (it) {
          var result = it.replace(plus, ' ');
          var bytes = 4;
          try {
            return decodeURIComponent(result);
          } catch (error) {
            while (bytes) {
              result = result.replace(percentSequence(bytes--), percentDecode);
            }
            return result;
          }
        };
        var find = /[!'()~]|%20/g;
        var replace = {
          '!': '%21',
          '\'': '%27',
          '(': '%28',
          ')': '%29',
          '~': '%7E',
          '%20': '+'
        };
        var replacer = function (match) {
          return replace[match];
        };
        var serialize = function (it) {
          return encodeURIComponent(it).replace(find, replacer);
        };
        var parseSearchParams = function (result, query) {
          if (query) {
            var attributes = query.split('&');
            var index = 0;
            var attribute,
            entry;
            while (index < attributes.length) {
              attribute = attributes[index++];
              if (attribute.length) {
                entry = attribute.split('=');
                result.push({
                  key: deserialize(entry.shift()),
                  value: deserialize(entry.join('='))
                });
              }
            }
          }
        };
        var updateSearchParams = function (query) {
          this.entries.length = 0;
          parseSearchParams(this.entries, query);
        };
        var validateArgumentsLength = function (passed, required) {
          if (passed < required) throw TypeError('Not enough arguments');
        };
        var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
          setInternalState(this, {
            type: URL_SEARCH_PARAMS_ITERATOR,
            iterator: getIterator(getInternalParamsState(params).entries),
            kind: kind
          });
        }, 'Iterator', function next() {
          var state = getInternalIteratorState(this);
          var kind = state.kind;
          var step = state.iterator.next();
          var entry = step.value;
          if (!step.done) {
            step.value = kind === 'keys' ? entry.key : kind === 'values' ? entry.value : [
              entry.key,
              entry.value
            ];
          }
          return step;
        }); // `URLSearchParams` constructor
        // https://url.spec.whatwg.org/#interface-urlsearchparams
        var URLSearchParamsConstructor = function URLSearchParams()        /* init */
        {
          anInstance(this, URLSearchParamsConstructor, URL_SEARCH_PARAMS);
          var init = arguments.length > 0 ? arguments[0] : undefined;
          var that = this;
          var entries = [
          ];
          var iteratorMethod,
          iterator,
          next,
          step,
          entryIterator,
          entryNext,
          first,
          second,
          key;
          setInternalState(that, {
            type: URL_SEARCH_PARAMS,
            entries: entries,
            updateURL: function () {
              /* empty */
            },
            updateSearchParams: updateSearchParams
          });
          if (init !== undefined) {
            if (isObject(init)) {
              iteratorMethod = getIteratorMethod(init);
              if (typeof iteratorMethod === 'function') {
                iterator = iteratorMethod.call(init);
                next = iterator.next;
                while (!(step = next.call(iterator)).done) {
                  entryIterator = getIterator(anObject(step.value));
                  entryNext = entryIterator.next;
                  if ((first = entryNext.call(entryIterator)).done || (second = entryNext.call(entryIterator)).done || !entryNext.call(entryIterator).done) throw TypeError('Expected sequence with length 2');
                  entries.push({
                    key: first.value + '',
                    value: second.value + ''
                  });
                }
              } else for (key in init) if (hasOwn(init, key)) entries.push({
                key: key,
                value: init[key] + ''
              });
            } else {
              parseSearchParams(entries, typeof init === 'string' ? init.charAt(0) === '?' ? init.slice(1) : init : init + '');
            }
          }
        };
        var URLSearchParamsPrototype = URLSearchParamsConstructor.prototype;
        redefineAll(URLSearchParamsPrototype, {
          // `URLSearchParams.prototype.appent` method
          // https://url.spec.whatwg.org/#dom-urlsearchparams-append
          append: function append(name, value) {
            validateArgumentsLength(arguments.length, 2);
            var state = getInternalParamsState(this);
            state.entries.push({
              key: name + '',
              value: value + ''
            });
            state.updateURL();
          },
          // `URLSearchParams.prototype.delete` method
          // https://url.spec.whatwg.org/#dom-urlsearchparams-delete
          'delete': function (name) {
            validateArgumentsLength(arguments.length, 1);
            var state = getInternalParamsState(this);
            var entries = state.entries;
            var key = name + '';
            var index = 0;
            while (index < entries.length) {
              if (entries[index].key === key) entries.splice(index, 1);
               else index++;
            }
            state.updateURL();
          },
          // `URLSearchParams.prototype.get` method
          // https://url.spec.whatwg.org/#dom-urlsearchparams-get
          get: function get(name) {
            validateArgumentsLength(arguments.length, 1);
            var entries = getInternalParamsState(this).entries;
            var key = name + '';
            var index = 0;
            for (; index < entries.length; index++) {
              if (entries[index].key === key) return entries[index].value;
            }
            return null;
          },
          // `URLSearchParams.prototype.getAll` method
          // https://url.spec.whatwg.org/#dom-urlsearchparams-getall
          getAll: function getAll(name) {
            validateArgumentsLength(arguments.length, 1);
            var entries = getInternalParamsState(this).entries;
            var key = name + '';
            var result = [
            ];
            var index = 0;
            for (; index < entries.length; index++) {
              if (entries[index].key === key) result.push(entries[index].value);
            }
            return result;
          },
          // `URLSearchParams.prototype.has` method
          // https://url.spec.whatwg.org/#dom-urlsearchparams-has
          has: function has(name) {
            validateArgumentsLength(arguments.length, 1);
            var entries = getInternalParamsState(this).entries;
            var key = name + '';
            var index = 0;
            while (index < entries.length) {
              if (entries[index++].key === key) return true;
            }
       