layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;
layout (location = 2) out vec3 v_model_pos;
layout (location = 3) out vec3 v_tangent;
layout (location = 4) out vec3 v_light_dir;
layout (location = 5) out vec3 v_world_normal;
layout (location = 6) out vec3 v_world_pos;
layout (location = 7) out vec3 v_world_eye;
layout (location = 8) out vec3 v_world_tangent;
layout (location = 9) out vec3 v_camera_pos;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    float g_app_time;
    float extrude;
    vec3 g_light_dir;
    float scene_time;

    float g_instance_count;

    vec3 mov_adjust;
    vec3 rot_foo;
    vec3 rot_time_foo;

    vec3 mov_foo;
    vec3 mov_freq;
    vec3 add_rot;
};

void main() {
    float id = gl_InstanceIndex;

    vec3 move = vec3(sin(mov_freq * (id+1)) * mov_foo);
    vec3 rot = rot_foo * id + rot_time_foo * scene_time;
    mat4 tr_mat = translate(move*3);
    mat4 rot_mat = rotate(rot + add_rot);

    vec3 pos = a_position - mov_adjust;
    mat4 transform = tr_mat * rot_mat;
//    vec4 new_pos = transform * vec4(pos, 1.0);
    vec4 new_pos = vec4(pos, 1.0);

    vec3 new_normal = mat3(transform) * a_normal;
    vec3 new_tangent = mat3(transform) * a_tangent;

    gl_Position = g_projection_from_model * new_pos;
    v_uv = a_uv;

    v_normal = mat3(g_camera_from_model) * new_normal;
    v_tangent = mat3(g_camera_from_model) * new_tangent;
    v_model_pos = new_pos.xyz;

    v_light_dir = mat3(g_camera_from_world) * g_light_dir;

    mat3 inverse_camera_from_model = mat3(g_camera_from_world);
    v_world_eye = inverse_camera_from_model * -g_camera_from_world[3].xyz;
    v_world_pos = (g_world_from_model * new_pos).xyz;
    v_world_normal = mat3(g_world_from_model) * new_normal;
    v_world_tangent = mat3(g_world_from_model) * new_tangent;
    v_camera_pos = (g_camera_from_model * new_pos).xyz;
}