pico-8 cartridge // http://www.pico-8.com
version 41
__lua__
-- robbo by bocianu
-- atari to pico-8 demake 

-- TODO
-- ? -> spaceship active



-- sprite flags
-- 0 pickable
-- 1 pushable
-- 2 bullet destroys
-- 3 explosion destroys
-- 4 kils robbo on contact
-- 5 is mob
-- 6 is living (gets killed by bonus)

-- mob types
-- 1 robbo bullet
-- 2 gun
-- 3 gun bullet
-- 4 laser
-- 5 laser beam
-- 6 rotating gun
-- 7 blaster
-- 8 blast
-- 9 creature L
-- 10 creature R
-- 11 bat
-- 12 bat pif
-- 13 eyes
-- 14 moving gun
-- 15 loose crate
-- 16 bareer

-- sfx
-- 0 step
-- 1 landing
-- 2 ammo pick
-- 3 push
-- 4 pistol
-- 5 screw 
-- 6 explosion
-- 7 puff
-- 8 key pick
-- 9 door open
-- 10 teleport
-- 11 exit
-- 12 last screw
-- 13 extrafife

version = "1.0.0"

-- #######################################################################################
-- ARRAYS
-- #######################################################################################

-- backtile, backcolor, wallcolordark, wallcolorlight, wallhiglight, cratecolor
levelProperties = {
	{96,3,140,142,12,129}, -- 1
	{96,140,5,12,6,129}, -- 2
	{96,133,131,139,11,129},
	{96,131,140,3,139,1},
	{101,5,136,0,142,130}, -- 5
	{101,1,5,129,12,0},
	{101,5,136,0,142,130},
	{101,5,3,0,139,128},
	{114,0,3,139,11,131},
	{114,133,131,128,3,0}, -- 10
	{114,131,2,128,142,0},
	{114,0,5,3,11,131},
	{115,5,2,3,15,0},
	{115,1,133,136,12,0},
	{115,0,132,140,12,133}, -- 15
	{115,3,136,139,11,0},
	{97,128,131,132,12,0},
	{97,128,131,132,12,0},
	{97,128,2,1,12,0},
	{97,3,2,1,12,0}, -- 20
-- backtile, backcolor, wallcolordark, wallcolorlight, wallhiglight, cratecolor
	{115,0,136,140,8,131},
	{115,1,3,140,12,140},
	{115,0,1,140,12,5},
	{115,128,5,140,12,131},
	{102,5,2,140,6,0}, -- 25
	{102,1,5,140,6,0},
	{102,5,133,140,12,0},
	{102,129,5,140,13,131},
	{99,3,132,15,12,0},
	{99,1,132,12,15,0}, -- 30
 	{99,5,3,11,135,0},
	{99,131,5,6,12,0},
	{98,5,132,140,12,128},
	{98,140,5,6,12,129},
	{98,5,131,140,12,0}, -- 35
	{98,3,5,140,12,0},
	{100,0,132,140,6,131},
	{100,1,5,140,6,0},
	{100,0,140,12,6,133},
	{100,0,132,140,6,131}, -- 40
-- backtile, backcolor, wallcolordark, wallcolorlight, wallhiglight, cratecolor
	{104,3,132,12,6,0},
	{104,1,5,142,6,0},
	{104,133,3,142,12,0},
	{104,131,133,142,12,0},
	{103,3,132,12,6,0}, -- 45
	{103,1,5,140,6,0},
	{103,5,132,140,12,0},
	{103,3,5,140,12,0},
	{112,3,132,12,6,0}, -- 49
	{112,1,5,140,6,0}, -- 50
	{112,140,131,140,6,0}, -- 51
	{112,133,3,142,12,0},
	{113,3,132,140,12,0},
	{113,1,5,12,6,0},
	{113,132,3,12,6,0}, -- 55
	{113,3,133,12,6,0}  -- 56

} 
robboSprites = {
	{{52,false},{53,false},{52,false},{54,false}},
	{{52,true},{53,true},{52,true},{54,true}},
	{{50,false},{51,false},{50,false},{51,true}},
	{{48,false},{49,false},{48,false},{49,true}},
}
qitems = {
	0,0,12,12,8,8,8,8,
	3,3,3,1,1,1,1,1,
	32,32,2,11,11,11,11,11,
	13,5,5,16,16,16,16,6,7
}
titlepals={
	{3,3,11,11,3,3,4,4},
	{2,2,13,13,14,14,13,13},
	{8,8,9,9,10,10,9,9},
	{1,1,5,5,6,6,5,5},
	{1,1,2,2,13,13,2,2},
	{131,131,138,138,139,139,138,138}
}
blink = {0,5,0,6,0,7}
-- l r u d
revdir ={2,1,4,3}
lpath = {4,3,1,2}
rpath = {3,4,2,1}

blasttiles = {59,58,57,56,57,58,59,0}

-- input tiles
guns = {0x1E,0x1F,0x1C,0x1D}
blasters = {0x04,0x01,0x18,0x17}
lasers = {0x3C,0x3E,0x5E,0x27}

congrats = {
" robbo has made his way through",
"   an enemy planetary system.",
"",
"    the plans he has in mind ",
"  are very valuable to earth!",
"",
"  you have completed the game",
"",
"\f9        congratulations!",
}

guide = {
"",
"",
"",
"",
"",
"",
"",
"",
"",
"instructions:",
"",
"robbo must travel a difficult",
"path through 56 planets, to",
"escape from the hostile",
"planetary system, on which he",
"has been victiously imprisoned.",
"",
"on each planet, a small capsule",
"awaits him, which he can fly",
"to the next planet.",
"",
"unfortunately most of the",
"capsules are incomplete,",
"so robbo has to collect the",
"right number of parts from",
"all over the planet.",
"",
"he will be hindered in this",
"by the evil creatures,",
"the inhabitants of the system.",
"",
"on his journey robbo will find",
"various objects. discover their",
"purpose. try to push them,",
"collect them or shoot them.",
"",
"if robbo finds himself in",
"an impossible situation",
"press and hold the 🅾️ and ❎",
"buttons simultaneously.",
"",
"enjoy the game - author",
"",
"enjoy the party - bocianu",
"",
"\f8forever 2023 demo party",
"\fawild compo entry",
"",
"code, gfx, sfx, music:",
"\fcBOCIANU",
"",
"testing:",
"\f8JINO,\faZBYTI,\fcrETROfILON",
"",
"",
"",
"",
"",
"",
"",
}

-- #######################################################################################
-- GENERAL UTILS
-- #######################################################################################

function find(a,v)
	for i=1,#a do
		if (a[i]==v) return i
	end
	return nil
end

function unapl(source,destination)
    local writeIdx = 0
    local readIdx = 0
    local tag = 0
    local bitcount = 0

    function writedest(b)
        poke(destination+writeIdx,b)
		--printh(destination+writeIdx..' '..b,'log.log')
        writeIdx += 1
    end

    function getbyte()
        b = peek(source+readIdx)
		readIdx += 1
        return b
    end
        
    function getbit()
        bitcount -= 1
        if (bitcount < 0) then
            tag = getbyte()
            bitcount = 7
        end
        return (tag >> bitcount) &  1
    end

    function getgamma()
        local result = 1
        repeat
            result = (result << 1) + getbit()
        until getbit()==0
        return result
    end

    local r0 = -1
    local lwm = 0
    local done = false
    local offs, length
    writedest(getbyte())
    while not done do
        if getbit()==1 then
            if getbit()==1 then
                if getbit()==1 then
                    offs = 0
                    for _=1,4 do
                        offs = (offs << 1) + getbit()
                    end
                    if offs != 0 then
                        writedest(peek(destination+writeIdx-offs))
                    else
                        writedest(0)
                    end
                    lwm = 0
                else
                    offs = getbyte()
                    length = 2 + (offs & 1)
                    offs = (offs >> 1) & 0xff
                    
                    if offs != 0 then
                        for _=1,length do
                            writedest(peek(destination+writeIdx-offs))
                        end
                    else
                        done = true
                    end
                    r0 = offs
                    lwm = 1
                end
            else
                offs = getgamma()
                if ((lwm == 0) and (offs == 2)) then
                    offs = r0
                    length = getgamma()
                    for _=1,length do 
                        writedest(peek(destination+writeIdx-offs))
                    end
                else
                    if (lwm == 0) then
                        offs -= 3
                    else
                        offs -= 2
                    end

                    offs = (offs << 8)
                    offs += getbyte()
                    length = getgamma()

                    if ((offs >= 32000) or (offs<0)) length += 1
                    if (offs >= 1280) length += 1
                    if (offs < 128) length += 2
                    for _=1,length do 
                        writedest(peek(destination+writeIdx-offs))
                    end
                    r0 = offs
                end
                lwm = 1
            end
        else
            writedest(getbyte())
            lwm = 0
        end
    end
    return writeIdx
end

function movetile(x1,y1,x2,y2)
	lastmove = {x1,y1,x2,y2}
	mset(x2,y2,mget(x1,y1))
	mset(x1,y1,0)
end

function pad(string,length)
	if (#string>=length) return string
	return "0"..pad(string, length-1)
end

function swapspr(n1,n2)
    for i=0,7 do
        local p1=i*64+n1*4+448*flr(n1/16)
        local p2=i*64+n2*4+448*flr(n2/16)
        local b1,b2=peek4(p1),peek4(p2)
        poke4(p2,b1)
        poke4(p1,b2)
    end
end

-- #######################################################################################
-- GAME SUBROUTINES
-- #######################################################################################

function getTeleportNum(x,y)
	for t in all(teleports) do 
		if (t[2]==x and t[3]==y) return t[1]
	end
end

function findTeleportPairs(x,y)
	num = getTeleportNum(x,y)
	tpairs = {}
	for t in all(teleports) do 
		if (t[1] == num and (t[2]!=x or t[3]!=y)) add(tpairs,{t[2],t[3]})
	end
	
	if #tpairs>1 then
		spairs = {}
		for pair in all(tpairs) do 
			if pair[2] > y then 
				add(spairs,pair)
				del(tpairs,pair)
			end
		end
		for pair in all(tpairs) do 
				add(spairs,pair)
				del(tpairs,pair)
		end
		return spairs
	end
	
	return tpairs
end

function findTeleportTarget(tx,ty,rdir)
	local tpairs = findTeleportPairs(tx,ty)
	if #tpairs>0 then 

		for pair in all(tpairs) do   -- check for strike-trough pair
			x,y = xyOnDir(pair[1],pair[2],rdir)
			if (mget(x,y)==0 and onBoard(x,y)) return {x,y}
		end

		dirtabs = {revdir,lpath,rpath}  -- check for any non strike-trough exit
		for pair in all(tpairs) do   -- check for strike-trough pair
			for dirtab in all(dirtabs) do
				x,y = xyOnDir(pair[1],pair[2],dirtab[rdir]) -- 1 > 4   3 > 2
				if (mget(x,y)==0 and onBoard(x,y)) return {x,y}
			end
		end

	else	-- no pair found, check for self exit
		dirs = {rdir,revdir[rdir],rpath[rdir],lpath[rdir]}
		for dir in all(dirs) do
			x,y = xyOnDir(tx,ty,dir)
			if (mget(x,y)==0 and onBoard(x,y)) return {x,y}
		end
	end
	return nil
end 

function addTeleport(x,y,t)
	num = t - 0x2f
	add(teleports,{num,x,y})
end


function getMobParams(type,dir)
	ismoving = true
	speed = 2
	delay = speed
	tile = 32
	if type == 1 then  -- robbo bullet
		tile = 38 + flr((dir-1)/2) * 2
		delay = 0
	end
	if type == 2 then  -- gun
		tile = 15 + dir
		speed = 64
		ismoving = false
		delay = rnd(speed)
	end
	if type == 3 then  -- gun bullet
		tile = 38 + flr((dir-1)/2) * 2
		delay = 0
	end
	if type == 4 then  -- laser
		tile = 19 + dir
		speed = 64
		ismoving = false
		delay = rnd(speed)
	end
	if type == 5 then  -- laser beam
		ismoving = false
		tile = 42 + flr((dir-1)/2) * 2
		speed = 3
		delay = 0
	end
	if type == 6 then  -- rotating gun
		tile = 15 + dir
		speed = 64
		ismoving = false
		delay = rnd(speed)
	end
	if type == 7 then  -- blaster
		tile = 23 + dir
		speed = 64
		ismoving = false
		delay = rnd(speed)
	end
	if type == 8 then  -- blast
		ismoving = false
		tile = 42 + flr((dir-1)/2) * 2
		speed = 4
		delay = 0
	end
	if type == 9 then  -- creature L
		tile = 30
		speed = 4
	end
	if type == 10 then  -- creature R
		tile = 36
		speed = 4
	end
	if type == 11 then  -- bat
		tile = 34
		speed = 4
	end
	if type == 12 then  -- bat pif
		tile = 60
		speed = 4
	end
	if type == 13  then  -- eyes
		tile = 32
		speed = 7
	end	
	if type == 14 then  -- moving gun
		tile = 28
		speed = 8
		delay = speed
	end
	if type == 15  then  -- loose crate
		tile = 7
		speed = 4
		delay = speed
	end	
	if type == 16  then  -- bareer
		tile = 119
		speed = 4
		delay = speed
		ismoving = false
	end	
	return tile, speed, ismoving, delay
end

function addMob(x,y,type,dir) 
	tile,speed,ismoving,delay = getMobParams(type,dir)
	mob = { x = x, y = y, type = type, tile = tile, ismoving = ismoving, dir = dir, speed = speed, delay = delay}
	add(mobs,mob)
	return mob
end

function fire(bx,by,dir)
	if rammo > 0 then
		sfx(4)
		mob = addMob(bx,by,1,dir)
		rammo -= 1
		rfired = true
	end
end

function explodeLater(x,y)
	add(expQueue,{x,y,4})
end

function explodeNow(ex,ey)
	tiles = { {ex,ey-1}, {ex+1,ey-1}, {ex+1,ey}, {ex+1,ey+1}, {ex, ey+1}, {ex-1,ey+1}, {ex-1, ey},{ex-1, ey-1} }
	sfx(6)
	for tile in all(tiles) do
		etile = mget(tile[1],tile[2])
		if (fget(etile,2) or fget(etile,3) or etile == 0) then 
			mset(tile[1],tile[2],0)
			addExplosion(tile[1],tile[2],0,delay)
			if (etile == 2) explodeLater(tile[1],tile[2])
		end
		if isMob(etile) then -- enemy
			killMob(tile[1],tile[2])
		end
		if etile == 62 then -- robbo :(
			killRobbo()
		end
	end
end

function addExplosion(ex,ey,prev)
	add(explosions,{ex,ey,flr(rnd(6)),prev})
end

function killMob(x,y)
	for mob in all(mobs) do
		if mob.x==x and mob.y==y then
			del(mobs,mob)
			mset(x,y,0)
			return true
		end
	end
end

function moveMob(x,y,xx,yy)
	for mob in all(mobs) do
		if mob.x==x and mob.y==y then
			mob.x=xx
			mob.y=yy
			return true
		end
	end
end

function isMob(tile)
	return fget(tile,5)
end

function bulletHit(x,y,tile)
	sfx(7)
	if (tile == 2) explodeNow(x,y) -- bomb
	newitem = 0
	if tile == 12 then -- ??? surprise ???
		newitem = qitems[flr(rnd(32))+1] 
		if (newitem == 16) then
			m = addMob(x,y,6,flr(rnd(4))+1)   -- rotating gun
			newitem = m.tile
		end	
		if (newitem == 32) addMob(x,y,13,0)  -- eyes
		if (newitem == 13) then -- kill all mobs
			for mob in all(mobs) do 
				if (fget(mob.tile,6)) killMob(mob.x,mob.y) 
			end
			newitem = 11
		end	
	end
	if isMob(tile) then -- enemy
		killMob(x,y)
	end
	if tile == 62 then -- robbo :(
		killRobbo()
	end
	add(explosions,{x,y,6,newitem})
end

function blastHit(x,y,tile)
	sfx(7)
	if (tile == 2) explodeNow(x,y) -- bomb
	if isMob(tile) then -- enemy
		killMob(x,y)
	end
	if tile == 62 then -- robbo :(
		killRobbo()
	end
end


function mobCollided(mob,cx,cy)
	ctile = mget(cx,cy)
	if mob.type == 1 or mob.type == 3 then  -- bullet
		if fget(ctile,2) then -- bullet destructible
			bulletHit(cx,cy,ctile)
			
		end 
		if (mob.tile == mget(mob.x,mob.y)) add(explosions,{mob.x,mob.y,9,0})
		if (mob.type == 1) rfired = false -- robbo bullet
		del(mobs,mob)
	end
	if mob.type == 5 then  -- laser beam
		if mob.fwd then
			if fget(ctile,2) then -- bullet destructible
				bulletHit(cx,cy,ctile)
			end
			mob.dir = revdir[mob.dir]
			mob.fwd = false
		else 
			sfx(7)
			if (mob.parent) then 
				if (mob.x!=mob.parent.x or mob.y!=mob.parent.y) add(explosions,{mob.x,mob.y,9})
				mob.parent.delay = rnd(mob.parent.speed) 
				mob.parent.fired = false
			end
			del(mobs,mob)
		end
	end
	if mob.type == 8 then  -- blast
		if fget(ctile,2) then -- bullet destructible
			blastHit(cx,cy,ctile)
		else
			mob.offset = 2
		end
	end
	if mob.type == 9 then -- creature R
		mob.dir = rpath[mob.dir]
	end
	if mob.type == 10 then -- creature L
		mob.dir = lpath[mob.dir]
	end
	if mob.type == 11 or mob.type == 12 then -- bat
		mob.dir = revdir[mob.dir]
	end
	if mob.type == 14 then -- moving gun
		mob.dir = revdir[mob.dir]
	end
	if mob.type == 15 then  -- loose crate
		if fget(ctile,2) then -- bullet destructible
			bulletHit(cx,cy,ctile)
		end 
		del(mobs,mob)
	end
end

function onBoard(x,y)
	if(x<0)return false
	if(y<0)return false
	if(x>15)return false
	if(y>30)return false
	return true	
end

function xyOnDir(x,y,dir)
	if (dir == 1) x -= 1
	if (dir == 2) x += 1
	if (dir == 3) y -= 1
	if (dir == 4) y += 1
	return x,y
end

function tileOnDir(x,y,dir)
	if (not onBoard(x,y)) return nil
	return mget(xyOnDir(x,y,dir))
end

function updateMobs()
	for mob in all(mobs) do 
		if mob.delay > 0 then 
			mob.delay -= 1
		else
			nx,ny = xyOnDir(mob.x,mob.y,mob.dir)
			ntile = mget(nx,ny)

			if mob.ismoving then
				mob.delay = mob.speed
				if ntile == 0 and onBoard(nx,ny) then
					if mget(mob.x,mob.y) == mob.tile then 
						movetile(mob.x,mob.y,nx,ny)		
					else 
						mset(nx,ny,mob.tile)		
					end
					mob.x = nx 
					mob.y = ny 
				else
					mobCollided(mob,nx,ny)
				end
			end

			if mob.type == 16 then -- bareer
				mob.delay = mob.speed
				bar = bars[ny]
				if (nx == bar.left) nx = bar.right-1
				mob.x = nx
				ctile = mget(nx,ny)
				if (isMob(ctile) and ctile!=119) killMob(cx,cy)
				if (nx==rx and ny==ry and robboAlive) killRobbo()
			end

			if mob.type == 9 then -- creature L
				if tileOnDir(mob.x,mob.y,lpath[mob.dir])==0 then 
					mob.dir = lpath[mob.dir]
				end
			end

			if mob.type == 10 then -- creature R
				if tileOnDir(mob.x,mob.y,rpath[mob.dir])==0 then 
					mob.dir = rpath[mob.dir]
				end
			end

			if mob.type == 13 then -- eyes
				dirs = {}
				if (ry<mob.y) add(dirs,3) -- up
				if (ry>mob.y) add(dirs,4) -- down
				if (rx<mob.x) add(dirs,1) -- left
				if (rx>mob.x) add(dirs,2) -- right
				cdir = dirs[flr(rnd(#dirs))+1]
				if (rnd(8)==0) cdir = rnd(4)+1
				if tileOnDir(mob.x,mob.y,cdir)==0 then 
					mob.dir = cdir
				end
			end

			if mob.type == 2 then -- gun
				mob.delay = 4 + rnd(mob.speed)
				sfx(7)
				addMob(mob.x,mob.y,3,mob.dir) -- fire
			end

			if mob.type == 12 then -- bat pif
				if (rnd(10)<2) then
					sfx(7)
					fdir = 4
					addMob(mob.x,mob.y,3,fdir) -- fire
				end
			end

			if mob.type == 14 then -- moving gun
				if (rnd(10)<3) then
					sfx(7)
					fdir = 4
					addMob(mob.x,mob.y,3,3) -- fire
				end
			end

			if mob.type == 4 and not mob.fired then -- laser
				mob.fired = true
				beam = addMob(mob.x,mob.y,5,mob.dir) -- fire
				beam.fwd = true
				beam.parent = mob
			end

			if mob.type == 5 then -- laser beam
				mob.delay = mob.speed
				expected = 0
				if (not mob.fwd) expected = mob.tile
				if ntile == expected then
					if (not mob.fwd) mset(mob.x,mob.y,0) 
					mob.x = nx 
					mob.y = ny 
					mset(mob.x,mob.y,mob.tile)
				else
					mobCollided(mob,nx,ny)
				end
			end

			if mob.type == 7 and not mob.fired then -- blaster
				mob.fired = true
				blast = addMob(mob.x,mob.y,8,mob.dir) -- fire
				blast.distance = 0
				blast.offset = 1
				blast.parent = mob
			end

			if mob.type == 8 then -- blast
				mob.delay = mob.speed
				if mob.offset == 1 then
					if ntile == 0 or fget(ntile,2) then
						mob.distance += 1
						mob.x = nx 
						mob.y = ny 
					end
					if ntile != 0 then
						mobCollided(mob,nx,ny)
					end
				else
					mob.offset += 1
				end

				bx,by = mob.x,mob.y
				bf = mob.offset
				
				for i=1,mob.distance do
					mset(bx,by,blasttiles[bf])
					bx,by = xyOnDir(bx,by,revdir[mob.dir])
					bf+=1
					if (bf>8) break
				end

				if mob.offset > 7 then
					if (mob.parent) then 
						mob.parent.delay = rnd(mob.parent.speed) 
						mob.parent.fired = false
					end
					del(mobs,mob)
				end

			end


			if mob.type == 6 then -- rotating gun
				mob.delay = 4 + rnd(mob.speed)
				rotate = flr(rnd(5))
				if rotate == 0 then 
					mob.dir = rpath[mob.dir] -- rot right
				elseif rotate == 1 then 
					mob.dir = lpath[mob.dir] -- rotate left
				else
					addMob(mob.x,mob.y,3,mob.dir) -- fire
				end
				ntile = getMobParams(6,mob.dir)
				if mob.tile != ntile then
					mob.tile = ntile
					mset(mob.x,mob.y,mob.tile)
				end
			end

		end
	end
end

function loadMap(n)
	src = 0x8000 + n * 512
	y = 0
	while y<31 do 
		for x=0,15 do
			local tile = @(src + x)
			if tile == 0x2A then -- player
				tile = 15
				rx = x 
				ry = y
			elseif tile == 0xa0 then -- wall
				tile = levelProperties[level][1]
			elseif tile == 0x5c then -- wall inv
				tile = levelProperties[level][1] + 16
			elseif tile == 0x13 then -- void
				tile = 63
			elseif tile == 0x20 then -- floor
				tile = 0
			elseif tile == 0x23 then -- crate
				tile = 6
			elseif tile == 0x25 then -- grass
				tile = 5
			elseif tile == 0x24 then -- treasure
				tile = 1
			elseif tile == 0x3D then -- key
				tile = 3
			elseif tile == 0x40 then -- bomb
				tile = 2
			elseif tile == 0x2B then -- extra life
				tile = 11
			elseif tile == 0x21 then -- bullets
				tile = 8
			elseif tile == 0x14 then -- exit
				tile = 14
			elseif tile == 0x7c or tile == 0x12 then -- doors
				tile = 4
			elseif tile == 0x06 then -- loose crate
				tile = 7
			elseif tile == 0x28 then -- magnet 2 left
				tile = 9
			elseif tile == 0x29 then -- magnet 2 right
				tile = 10
			elseif tile > 0x2F and tile < 0x3A then -- teleport
				addTeleport(x,y,tile)
				tile = 46
			elseif tile > 0x40 and tile < 0x45 then -- creature L (lt,rt,up,dw)
				m = addMob(x,y,9,tile - 0x40)
				tile = m.tile
			elseif tile > 0x44 and tile < 0x49 then -- creature R (lt,rt,up,dw)
				m = addMob(x,y,10,tile - 0x44)
				tile = m.tile
			elseif tile > 0x48 and tile < 0x4D then -- bat (lt,rt,up,dw)
				m = addMob(x,y,11,tile - 0x48)
				tile = m.tile
			elseif tile > 0x4C and tile < 0x4F then -- bat pif (lt,rt)
				m = addMob(x,y,12,tile - 0x4C)
				tile = m.tile
			elseif tile == 0x26 then -- eyes
				m = addMob(x,y,13,0)
				tile = m.tile
			elseif find(guns,tile) then -- gun (lt,rt,up,dw)
				m = addMob(x,y,2,find(guns,tile))
				tile = m.tile
			elseif tile == 0x0e or tile == 0x0d then -- moving gun (lt,rt)
				mdir = 2
				if (tile==0x0d) mdir = 1
				m = addMob(x,y,14,mdir)
				tile = m.tile
			elseif tile > 0x2B and tile < 0x30 then -- rotating gun (lt,rt,up,dw)
				m = addMob(x,y,6,tile - 0x2B)
				tile = m.tile
			elseif count(lasers,tile) == 1 then -- laser (lt,rt,up,dw)
				m = addMob(x,y,4,find(lasers,tile))
				tile = m.tile
			elseif count(blasters,tile) == 1 then -- blasters (lt,rt,up,dw)
				m = addMob(x,y,7,find(blasters,tile))
				tile = m.tile
			elseif tile == 0x3f then -- ?
				tile = 12
			elseif tile == 0x11 then -- bareer left
				bars[y] = {left = x, right=nil}
				tile = levelProperties[level][1]
			elseif tile == 0x0F then -- bareer 
				m = addMob(x,y,16,1)
				tile = 0
			elseif tile == 0x05 then -- bareer right
				bars[y].right = x
				tile = levelProperties[level][1]
			else 				
				tile = 60
			end
		
			mset(x,y,tile)
		end
		src += 16
		y += 1
	end
	caveparam = {}
	for x=0,15 do 
		add(caveparam,@(src + x))
		mset(x,y,63) -- clear last row on map
	end
	return caveparam
end

function initGame()
	music(-1)
	rf = 1
	rfh = false
	rlives = 8
	score = 0
	level = 1
	mapYpos = 0
	mapYtarget = 0
	escape = 0
	levelStart = false
	poke(0x5f2d,1)
	menuitem(1, "kill robbo", killRobbo)
	menuitem(2, "exit to title", showTitle)
	menuitem(4)
end

function addScore(scr)
	if not cheatMode then
		score += scr
	end
end

function closeCurtain()
	curtain += 2
end

function bcd2dec(b)
	n1=(b & 0xf0)>>4
	n0=b & 0xf
	return n1*10+n0
end

function pickScrew()
	if (rscrews==1) then
		blinkBack = 6
		sfx(12)
	end
	rscrews = max(0,rscrews - 1)
end


function loadLevel()
	reload(0,0,0x1000)
	rammo = 0
	rkeys = 0
	rscrews = 0
	rdir = 4
	rd = 0
	rstep = 0
	mobs = {}
	teleports = {}
	explosions = {}
	bars = {}
	expQueue = {}
	anim = {}
	curtain = 16
	if level == 57 then
		startEnding()
		return true
	end
	caveparam = loadMap(level-1)
	rscrews = bcd2dec(caveparam[2])
	robboAlive = true
	levelStart = true
	animation = 30
	anim[1] = function() levelStart = false end
	anim[14] = function() sfx(1) end
	anim[12] = function() add(explosions,{rx,ry,9,0}) end
end

function checkUserInput()
	if rd>0 then 
		rd -= 1
		if (btn()==0) rd=0
	else 

		if (btn(❎) and btn(🅾️)) then 	-- robbo gives up
			escape += 1
			if (escape == 50) killRobbo()
		else
			escape = 0
		end
		px = rx
		py = ry
		dx = 0
		dy = 0
		if (btn(⬅️)) then 
		rdir=1
			dx=-1
		elseif (btn(➡️)) then
		rdir=2   
			dx=1 
		elseif (btn(⬆️)) then 
		rdir=3
		dy=-1
		elseif (btn(⬇️)) then
			rdir=4
			dy=1
		end 

		if (dx!=0 or dy!=0) then 
			move = false
			ftile = mget(rx+dx,ry+dy)

			if (btn(❎) or btn(🅾️)) then 	-- robbo fires
				if not rfired then 
					fire(rx,ry,rdir)
					rd = 3
				end
			else							 -- robbo tries to move
				if onBoard(rx+dx,ry+dy) then
					if ftile == 0 or wallwalk == 1 then -- free field (or cheatmode)
						move = true
					else 			   -- obstacle

						if (ftile==14 or ftile==15) and rscrews==0 then -- spaceship (exit)
							robboAlive = false
							addScore(1000)
							anim = {}
							animation = 36
							anim[animation] = function() add(explosions,{rx,ry,6,0}) end
							for i=2,16 do anim[i] = closeCurtain end
							anim[1] = function() 
								level +=1
								loadLevel()
							end
							sfx(11)
						elseif fget(ftile,1) then -- pushable
							ffx,ffy = rx+(dx*2),ry+(dy*2)
							fftile = mget(ffx,ffy)
							if (fftile == 0) then
								sfx(3)
								movetile(rx+dx,ry+dy,ffx,ffy)
								if ftile==28 then
									moveMob(rx+dx,ry+dy,ffx,ffy)  -- moving gun
								end
								if ftile==7 then -- loose crate
									addMob(ffx,ffy,15,rdir) 
								end
								move = true
							end
						elseif fget(ftile,0) then -- pickable
							mset(rx+dx,ry+dy,0)
							move = true
							if (ftile == 8) then
								rammo += 9
								addScore(50)
								sfx(2)
							end
							if (ftile == 1)	then
								if rscrews == 0 then 
									addScore(250)
								else
									addScore(100)
								end
								pickScrew()
								sfx(5)
							end
							if (ftile == 3) then
								rkeys += 1
								addScore(75)
								sfx(8)
							end
							if (ftile == 11) then
								rlives += 1
								addScore(200)
								sfx(13)
							end
						elseif ftile==4 then -- doors
							if rkeys>0 then
								rkeys-=1
								mset(rx+dx,ry+dy,0)
								move = true
								addScore(100)
								sfx(9)
							end
						elseif ftile==46 or ftile==47 then -- teleport
							target = findTeleportTarget(rx+dx,ry+dy,rdir)
							if target!= nil then
								rx = target[1]
								ry = target[2]
								movetile(px,py,rx,ry)
								sfx(10)
							end
							animation = 16
							anim[animation] = function() add(explosions,{px,py,9,0}) end
							anim[12] = function() add(explosions,{rx,ry,9,62}) end
						end
					end
				end
			end
			
			if move then  -- move robbo
				sfx(0)
				rstep += 1
				mset(px,py,0)
				mset(rx+dx,ry+dy,62)
				rx = rx+dx
				ry = ry+dy
				rd = 3
			else
				rstep = 0	
			end

		else
			rstep = 0	
		end
	end

	-- set robbo frame	
	rf = robboSprites[rdir][rstep%4+1][1]
	rfh = robboSprites[rdir][rstep%4+1][2]
end

function killRobbo()
	robboAlive = false
	anim = {}
	animation = 36
	rlives -= 1
	sfx(6)
	anim[animation] = function() add(explosions,{rx,ry,0,0}) end
	for i=2,16 do anim[i] = closeCurtain end
	anim[1] = function() 
		if rlives == -1 then 
			showTitle()
		else
			loadLevel()
		end
	end
end

function checkForCollissions()
	for dir=1,4 do 
		t = tileOnDir(rx,ry,dir)
		if fget(t,4) then
			killRobbo()
			return true
		end
	end
	-- check for magnets
	if tileOnDir(rx,ry,1)==9 or tileOnDir(rx,ry,2)==10 then
		killRobbo()
		return true
	end
	cx,cy=rx,ry 		
	repeat
		ctile = tileOnDir(cx,cy,1) -- left
		if ctile == 9 then 
			rd=10
			if (rx>cx) rx-=0.5
		end
		cx -= 1
	until ctile != 0
	cx=rx
	repeat
		ctile = tileOnDir(cx,cy,2) -- right
		if ctile == 10 then 
			rd = 10
			if (rx<cx) rx+=0.5
		end
		cx += 1
	until ctile != 0

	return false
end

-- #####################################################################################################
-- GUI
-- #####################################################################################################

function showTitle()
	titlepal = 1
	paloff = 1
	paldir = 1
	palinterval = 120
	palcounter = 0
	
	boardtop = 20
	mapYoff = 0
	mapYpos = 0
	mapYtarget = 0
	relY = 0
	
	frame = 0
	curtain = 0
	animation = 0
	blinkBack = 0
	poke(0x5f2d,0)
	guideY = 0
	gamestate = 0
	menuitem(1)
	menuitem(2)
	if cheatMode then 
		menuitem(4, "disable cheats", function() cheatMode = false showTitle() sfx(13) end)
	else
		menuitem(4, "cheat mode", function() cheatMode = true showTitle() sfx(13) end)
	end
	music(0)
end

function rspr(n,x,y,fh)
	spr(n,flr(x)*8, boardtop + (y*8) - (8*mapYpos) + mapYoff,1,1,fh)
end

function bspr(x,y)
	spr(119,flr(x)*8, boardtop + (y*8) - (8*mapYpos) + mapYoff)
end

function moveMap() 
	if not (mapYpos==mapYtarget and mapYoff==0) then 
		if mapYoff != 0 then 
			mapYoff += 2*sgn(mapYoff)
			if abs(mapYoff)==8 then 
				mapYpos -= sgn(mapYoff)
				mapYoff=0
			end
		else
			if (mapYpos < mapYtarget) mapYoff -= 2
			if (mapYpos > mapYtarget) mapYoff += 2
		end
		if (animation>0 and levelStart) animation+=1

	else
		relY = ry - mapYpos
		if (relY < 2 and mapYpos>0) mapYtarget -= min(3,mapYpos)
		if (relY > 7 and mapYpos<21) mapYtarget += min(3,21-mapYpos)
	end
end

function updateExplosions()
	for q in all(expQueue) do
		if q[3] > 0 then 
			q[3] -= 1
		else
			explodeNow(q[1],q[2])
			del(expQueue,q)
		end
	end
	for e in all(explosions) do
		if e[5] != nil and e[5]>0 then
			e[5]-=1
		else
			if e[3]==15 then 
				mset(e[1],e[2],e[4])
				del(explosions,e)
			else
				mset(e[1],e[2],55+flr(e[3]/3))
				e[3]+=1
			end
		end
	end
end

function flipsprites()
	local s = 30
	repeat
		swapspr(s, s+1)
		s += 2
	until s>46
	swapspr(60,61)
	swapspr(119,120)	
	if (rscrews==0) swapspr(14,15) -- blink spaceship
end

function updateBareers()
	for y,b in pairs(bars) do 
		for x=b.left+1,b.right-1 do 
			if (mget(x,y)==119) mset(x,y,0)
		end
	end
	for mob in all(mobs) do
		if mob.type == 16 then mset(mob.x,mob.y,119) end
	end
end

function showstatus()
	sy = 105;
	print(pad(""..score,6),0,sy,6)
	
	spr(1,27,sy-2)
	print(pad(""..rscrews,2),35,sy,6)
	
	spr(11,47,sy-1)
	print(pad(""..max(0,rlives),2),55,sy,6)

	spr(3,67,sy-2)
	print(pad(""..rkeys,2),75,sy,6)
	
	spr(29,88,sy-2)
	print(pad(""..rammo,2),98,sy,6)
    
	spr(13,111,sy-2)
	print(pad(""..level,2),120,sy,6)
	
	-- print(frame,0,sy+8,6)
end

-- #####################################################################################################
-- MAIN
-- #####################################################################################################

function _init()
	cls()
	reload(0x1000, 0x1000, 0x2000)
	unapl(0x1000,0x8000)
	--cheatMode = true
	showTitle()
	menuitem(5,"VERSION "..version)
end

------------------------------- DRAW


function drawgame()
	palt(0,false)
	palt(1,true)
	local col = levelProperties[level]

	if blinkBack > 0 then 
		pal(1,blink[blinkBack],1) 
		blinkBack -= 1
	else
		pal(1,col[2],1) 
	end
	pal(2,col[3],1)
	pal(14,col[4],1)
	pal(15,col[5],1)
	pal(4,col[6],1)
	cls(1)
	map(0,mapYpos-1,0,boardtop+mapYoff-8,16,12)
	
	if animation > 0 then
		event = anim[animation]
		if event != nil then
			event()
			anim[animation]=nil
		end
		animation -= 1	
	else
		rspr(rf,rx,ry,rfh)
	end

	rectfill(0,0,127,boardtop-1,0)
	rectfill(0,boardtop+81,127,127,0)
	if curtain>0 then 
		rectfill(0,boardtop,curtain*8,boardtop+80,0)
	end
	showstatus()
end

function drawtitle()
	palt(1,false)
	palt(0,true)
	cls(0)
	local cpal = titlepals[titlepal]
	for c=0,7 do 
		pal(8+c,cpal[((flr(paloff/4)+c)%8)+1])
	end
	
	spr(64,12,10,2,2)
	spr(66,12+22,10,2,2)
	spr(68,12+44,10,2,2)
	spr(68,12+66,10,2,2)
	spr(66,12+88,10,2,2)

	print('(C) 1989 BY aVALON',28,30,7)
	print('jANUSZ pELC',44,38,7)
	print('aTARI DEMAKE BY bOCIANU',20,50,5)
	pal(2,136,1)
	line(0,58,128,58,8)
	line(0,118,128,118,8)
	
	if cheatMode then
		print('\f8c\f9h\fae\fba\fct\fde\fer\ff!',50,122)
	else
		print('\f8f\f9o\far\fbe\fcv\fde\fer\ff \f82\f90\fa2\fb3\fc \fd-\fe \ffw\f8I\f9L\faD\fb \fce\fdN\feT\ffR\f8Y',16,122)
	end

	clip(0,61,128,54)
	guideOff = flr(guideY / 8)+1
	for line = guideOff,guideOff+7 do 
		print(guide[line],2,54-guideY+line*8,6)
	end
	guideY += 0.30
	if (guideY > 420) guideY=0
	clip()
end


function startEnding()
	gamestate = 2
	rx = 138
	rf = 76
	uy = 75
	frame = 0
	curtain = 16
	pal()
	pal(2,133,1)
	pal(15,140,1)
	stars = {{10,2},{79,3},{120,20},{33,23},{3,29},{60,41},{93,44},{33,56},{13,66},{113,61}}
	ca,cb=9,10
end

function drawending()
	keyframe = (frame & 3 == 0)
	cls(0)
	-- draw stars
	for star in all(stars) do 
		pset(star[1],star[2],5+flr(rnd(3)))
	end
	-- draw land
	for i=0,15 do 
		spr(105,i*8,90,1,2)
	end
	-- draw robbo
	if frame<68 then
		spr(rf,rx,75,2,2)
		if keyframe then
			rx -=4
			if rf == 76 then rf = 78 else rf = 76 end
			sfx(0)
		end
	elseif frame<100 then 
		spr(74,rx,75,2,2)
		rf = 106
	elseif frame<140 then 
		spr(rf,rx,75,2,2)
		if keyframe then
			if rf == 106 then rf = 108 else rf = 106 end
			sfx(7)
		end
	elseif frame<150 then 
		spr(74,rx,75,2,2)
		rf = 76
	elseif frame<180 then
		spr(rf,rx,75,2,2)
		if keyframe then
			rx -=4
			if rf == 76 then rf = 78 else rf = 76 end
			sfx(0)
		end
	end
	--- draw ufo 
	spr(70,36,uy,4,2)
	if (frame==180) sfx(13)
	if (frame==190) sfx(1)
	if frame<180 then
		spr(126,44,75,2,1)
	elseif frame<190 then
		dy = 1
	elseif frame<220 then
		uy-= dy
		dy+= 0.2
	end
	-- blink ufo light
	if keyframe then
		c = ca
		ca = cb
		cb = c
		pal(9,ca,1)
		pal(10,cb,1)
	end
	-- show congrats
	if frame>240 then 
		ty = 6
		for line in all(congrats) do 
			print(line,0,ty,6)
			ty+=7
		end
	end
	-- remove curtain
	if curtain>0 then 
		rectfill(0,0,curtain*8,127,0)
	end
end

function _draw()
	if (gamestate == 0) drawtitle()
	if (gamestate == 1) drawgame()
	if (gamestate == 2) drawending()
end

------------------------------- UPDATE

function updatetitle()
	if palcounter>0 then 
		palcounter -= 1
	else
		paldir = flr(rnd(2))
		if (paldir==0) paldir=-1
		titlepal = flr(rnd(#titlepals))+1
		palcounter = palinterval
	end
	paloff += paldir
	if btnp(❎) or btnp(🅾️) then
		initGame()
		loadLevel()
		gamestate = 1
	end
	pal()
end

function updateending()
	if (curtain>0) curtain -= 1
	if btnp(❎) or btnp(🅾️) then
		showTitle()
	end
	if (stat(30)) stat(31)
end

function updategame()

	if (animation==0 and robboAlive) checkUserInput()
	moveMap() 
	updateMobs()
	updateExplosions()
	if ((frame & 7)==0) flipsprites()
	if (curtain>0) curtain -= 1
	if (robboAlive) checkForCollissions()
	updateBareers()

	if cheatMode then
		if stat(30) then
			key = stat(31)
			if key == '.' then 
				level = min(level + 1,57)
				loadLevel()
			end
			if key == ',' then 
				level = max(1,level - 1)
				loadLevel()
			end
			if key == 'a' then 
				rammo += 10
			end
			if key == 's' then 
				pickScrew()
			end
			if key == 'k' then 
				rkeys += 1
			end
			if key == 'l' then 
				rlives += 1
			end
			if key =='0' then 
				if wallwalk == 1 then 
					wallwalk = 0
				else
					wallwalk = 1
				end
			end
		end
	end

end

function _update()
	if (gamestate == 0) updatetitle()
	if (gamestate == 1) updategame()
	if (gamestate == 2) updateending()
	frame+=1
end


__gfx__
0000000011111111111111111111111114242441414144411441144114411441111111111dd1111111111dd11111111111111111111111111131131111b11b11
0000000011cddd511111651111a994112424242414441414422442244ee44ee4111111115dd8888668888dd511b11b11117aa91111d6cd11111cd111111cd111
0070070011cddd51114444111a40094124242424414441444444444444444444111111115588888668888855110cc01117900a911d7ccbd11ccdddd11ccdddd1
00077000110550011445444110a994012664242414141441144114411441144111666a11088800055000888011cccc11100179011ccb3351cddddd55addddd5a
00077000111cd51114565441110a40112d24242444411414144114411441144111ddd9111ccc11111111ccc111dddd11111790111cb333510d55555009a99a90
007007001115501114454441119a41112424242444144144422442244ee44ee4110000115dccccc66cccccd511cddc11111001111d53355110cd550110cd5501
00000000111cd51114444441119a411124242424141441444444444444444444111111115ddcccc66ccccdd5110000111117911111d555111c0000d11c0000d1
00000000111050111144441111000111444444444141441414411441144114411111111105500005500005501111111111100111111111111011110110111101
1111111111111111111aa1111111111111111111111111111117a11111111111111111111111111111a11a111111111111177111111111111144144114414411
116dd611116dd61111676611116dd611116996111169961111699611116996111163361111633611119bb9111163361111666611111111511444444114444441
16d55d6116d55d6116d76d6116dddd6116977961169779611697796116977961a99933611633999a1697a9611633336116d77d6116ddd6661446464114646441
a7775dd11dd5777a1d5765d11d5555d1797aaa91197aaa97197aaa91197aaa910b7a733113377ab0139aa9311337b3311d6776d11dddd5551144541111454411
a6665dd11dd5766a1d5555d11d5775d1a97aaa91197aaa9a197aaa91197aaa911baab331133baab11337b3311397a9311d6776d1dd0550004445d541145d5444
05d55d5115d55d5015dddd5115d76d51059aa951159aa950159aa951159aa951a99933511533999a15333351159aa95115d66d51dd5001111145d544445d5411
105dd501105dd501105dd5011057650110599501105995011059950110599501005335011053350010533501109bb901105dd501dd0111111144541111454411
110000111100001111000011110aa0111100001111000011110000111107a01111000011110000111100001111a00a1111000011001111111441144114411441
111111111111111111111111111111111141141111411411111111111111111111111111111111111111111111111111111a11111111a111111cc111111cc111
1151151111511511111111111111111114444441144444411111111111111111111161111116111111111111111111111111111111111111d1c00d1dd1c88d1d
1575575115755751117117114111111444464644446464441111111111111111111611111111611111111111111111111111a111111a11110c0d50d00c8a98d0
1707707117777771144114414471174414444441144444411161616116161611111161111116111111a111a1a111a11111111111111111111c0550d11c8998d1
17777771170770714444444414444441444454411445444416161611116161611116111111116111a111a11111a111a1111a11111111a1111c0550d11c8998d1
15755751157557514114411411144111115dd514415dd51111111111111111111111611111161111111111111111111111111111111111111c0550d11c8998d1
1050050110500501111111111111111114444411114444411111111111111111111611111111611111111111111111111111a111111a1111d0d00d0dd0d88d0d
1111111111111111111111111111111114111441144111411111111111111111111111111111111111111111111111111111111111111111010dd010010dd010
1b1111b11b1111b11b1111b11b1111b11b1111b1b1111b111b1111b1188841111551111111151111111511111111111111111111111111111111111144444444
11cccc111ccccc1111cccc1111cccc111ccccc111ccccc111ccccc11889988411d855111116d55d5115111611511111111811811411111141111111144444444
1c3cc3c11c3cc3c11cccccc11cccccc113c3cc1113c3cc1113c3cc1189aa984158985d155155d561156515111111151114411441448118441111111144444444
1cccccc11cccccc11c5dd5c11c5dd5c11ccccc111ccccc111ccccc1189999984155d555d15d6d5d1115111151111111144444444144444411111111144444444
dd5dd5d5dd5dd5dcd5dddd5dc5dddd5d15d55511c5d5551115d55511489999981d5588511d555551511115111111111141144114111441111111111144444444
c5dddd5c15dddd5dd5d55d5dd5d55d5d15dd5c1115ddd5c115ddc5111489aa98515559811655d655115156511151111111111111111111111111111144444444
15d55d511cc55d5115d55d511555dd5115ddd51115cc55111cc5551111899988111d55d511155511161115111111151111111111111111111111111144444444
1cc11cc111111cc115d11d5111115d511cc1cc111cc511111111cc11111888811511151111511151115111111111111111111111111111111111111144444444
8899aabbccdd00000000000000000000eeff8800000000000000000000000cccccc0000000000000000000000000000000000000000000000000000000000000
8899aabbccdd00000000000000000000eeff88000000000000000000000cbcdfffcbc00000000000000000000000000000000000000000000000000000000000
99aabb0000eeff000000eeff88990000ff8899aabbcc00000000000000cccdfffffccc00000000000000b0000b00000000000b000b00000000000b000b000000
99aabb0000eeff000000eeff88990000ff8899aabbcc0000000000000cccdf3ff3ffccc000000000000006ccc00000000000006cc00000000000006cc0000000
aabbcc000000889900eeff8800aabb008899aa0000ddee000000000061ccff1ff1ffcc150000000000006ccccc000000000006cccc000000000006cccc000000
aabbcc000000889900eeff8800aabb008899aa0000ddee000000aa66dd11dffffffd11dd55aa00000006c3cc3cc00000000063c3ccc00000000063c3ccc00000
bbccdd00000099aaeeff88000000ccdd99aabb000000ff88004d666dddddd111111dddddd5555400000cc1cc1cc000000000c1c1ccc000000000c1c1ccc00000
bbccdd00000099aaeeff88000000ccdd99aabb000000ff880a6666dddddd6dddddd5dddddd555590000cccccccc000000000ccccccc000000000ccccccc00000
ccddee000099aa00ff8899000000ddeeaabbcc0000008899009a6ddddddd6ddaadd5ddddddd59a0000dd5dddd555000000005ddd5dd000000000ddddd5d00000
ccddee000099aa00ff8899000000ddeeaabbcc000000889900dd9a9adddd6ddaadd5dddd9a9a55000dd566dddd55500000006dddd5dd000000006ddd5dd50000
ddeeff8899aa00008899aa000000eeffbbccdd00000099aa000d5d559a9a6dddddd59a9a555150000dd5dddddd555000000cdddddd5dc0000000ddddcdd50000
ddeeff8899aa00008899aa000000eeffbbccdd00000099aa00000ddd55559a9a9a9a5555555000000cc65dddd55cc00000ccddddd55cc00000005ddccd550000
eeff880000bbcc0099aabb000000ff88ccddee000000aabb0000000555551555555155555000000000c6dd55dd5c00000000d555555000000000dd5555d50000
eeff880000bbcc0099aabb000000ff88ccddee000000aabb0000000d500551555515500d5000000000065500d550000000000dcd55000000000cd55005cc0000
ff8899000000ddee00bbccddeeff8800ddeeff8899aabb00000000dd500000000000000d55000000000ccc00ccc00000000000dcc00000000000cc000cc00000
ff8899000000ddee00bbccddeeff8800ddeeff8899aabb00000000d50000000000000000d5000000000000000000000000000000000000000000000000000000
feeeeeed2eee2eee0e2222222222222122222221e222e22211e22221102222012200222222222222000000000000000000000000000000000000000000000000
e2222222e222e22200000000222222202ee22221eeeeeeee1e222222022222200022222222222222000000000000000000000000000000000000000000000000
e2222222ee2eee2e22220e22222222202e22222122e222e2112222212220022222222200222222220000b0000b0000000000b0000b0000000000000000000000
e222222222e222e2000000001000000022222221eeeeeeee2212221e220110222222002232223222000006ccc0000000000006ccc00000000000000000000000
e22222222eee2eee0e2222222221222222222221e222e222222111e222011022220022223333333300006ccccc00000000006ccccc0000000000000000000000
e2222222e222e222000000002220222222222221eeeeeeee22221e22222002220022222233333333c006c3cc3cc0000000c6c3cc3cc000000000000000000000
e2222222ee2eee2e22220e22222022222222222122e222e222211122022222202222220033b333b3cc0cc1cc1cc000000cccc1cc1cc000000000000000000000
d222222222e222e2000000000000100011111111eeeeeeee221e221210222201222200223bbb3bbb0ddcccccccc000000ddcccccccc000000000000000000000
22022220eee2222022ee2222eee22220fffffff12eee2eee11effff10011001100110011bbbbbbbb0ddd5dddd55500000ddd5dddd555000000000cccccc00000
22220222e2222240ee222222e2220200feeffff1222222221effffffcc00cc0022002200bbbbbbbb00dd66dddd55500000dd66dddd555000000cc77cccccc000
02222202222244402222222222202040fefffff1ee2eee2e11fffff100cc00cc00220022bbbbbbbb000ddddddd555000000ddddddd55500000cc77cccccccc00
22022222000000002222222200000000fffffff122222222ff1fff1e22002200cc00cc0044b444b400055dddd55cc00000055dddd55cc0000ccc7cccccccccc0
022220222220eee2222222ee2220eee2fffffff12eee2eeefff111ef0022002200cc00cc444444440006dd55dd5c00000006dd55dd5c000061cccccccccccc15
222022222240e2222222ee222200e222fffffff122222222ffff1effcc00cc00220022004444444400065500d550000000065500d5500000dd11cccccccc11dd
202222022440222222ee22ee20402222fffffff1ee2eee2efff111ff00cc00cc0022002244444444000ccc00ccc00000000ccc00ccc00000ddddd111111ddddd
2222022200000000ee22ee22000000001111111122222222ff1eff1f11001100110011004040404000000000000000000000000000000000dddd6dddddd5dddd
0afa100102444042ba702212a2861331708e028b5f58513250342127cac10d79018812e6931352e051423201ac0402836c7404343434059242d85472a5069823
f5b3039230c7014b3a630974e8020dd9a809037fa56164322648d8bd56711441505bb7907700d9f160f1739801d375125242475447105122041d5ce8d3e621a4
e3c05942613402a9ba93a9f39a3ff28cc35642433247ae96029a51565e411526090d025b46a397101c900c81a00727074be81900bfe9ff780a323b4ab0846d8a
9ccd41be1c49e1035924ad11e1056421b232ee4a03aef02ac2685b6896dd043ac95257eb969551b25358565d76d4a17586cbbf5418e1b4109403ac14e0ac388c
beb7d893c26c82969256acf727a3044302cd160d413242e31cd440a0f94342b746e04707ec268697e8b5645f0235a509025f15b162c633bc12a8b308d6dffff0
9505d5d44102b800e80130aafa402829d31226ba0b09a292c7513a06535e4259fd0586320286051d04e11738cad7595913527508345829b2f4b231101a02b37c
d631987ca2f0f3253801c8439df7f00117681d9f73022345d302323eb11473e006251d640819f932d3f41f840888b4ba08b4bb2342b114034c4173828c20ca02
a79e2894901a1c023a06ea083717187859126294062b23760076601067c92b1c40b1ac32089cab07885510bea305b3e0c857014930a9525101464293eefa0201
7a81d611413545811f1d36a2149248e7f82851e3d088233a02ae302f1304b2190572b213818c04fe114e2301c3d21749d1c7032ba2c946e8e3e80568e51b0a46
d358a9ccc91469588e031d42b40195a11d050d066b15055403415ed11a350c4cf361e3003070076bc047282cf1ba064ea2417f7ba50d1d14d56d41404713b301
34ee75061dd034014a05d6061d082a54a20e45b9d78ca38cd6c491414a44f8c8c28aeebd02c996d140722ed8e5bf2d3545cb3d6674e27401395908ddfee10f97
4909c5490c676ed14e72ad40d0d10fea088e66a7ec3465420369b3008331808bc723454483731bc68a4169d337a512d400133d938a822302dee1460c23844309
630d32ca63892fdc7852e749115334db09a853193809564e51d155bc33b67857c7748329b80788f376c78237d291c3a1d5fefa92064e3282418c32948e0245f8
101131ff8cc545a433960b31f152c82232b12810b700ad521003ad5ba630649ea3066994bb0d59c7921d531d049ad121b006255c6e3378018ef29ef9d8ea278e
c49d542e91d366f15fd84366fc7d050f1112a4dac90e6b2e9e9e5d72d1768454852fb24c53397452490f6d12dcb4c6301d027ba204373414017454b6d23158a2
0b0411de859f521f7cd96e73a2e10c97417f4904d306b603710000500e88c0230cd8726b6548b9780161d367c4046442246cb4922b6ca904a9019353d1bc2768
580aa258e13ac28684860119427f8a46132212b978dbe273747574211d45394ca02757546b7765320532d2c10419131d012983f0338c9f04bd17123ee12775d4
3354053a762af45b10ad14712bda82f101444366b08cb323ee4748b242a13a9772bbf79683f0eef02a9b595269b2c12cc15070a3e02b40606f002fb4233f009b
2d11a56656926822abb2c9004eb4e532d43291058b765ca10296dcf40bdb3c32528cd4bca30db5018e01c732c494ecc3166774b4ac4209e5e92a84e346629b6b
4b31b0fc70c5727a812b652111d350acf3248009044f57644302d2256c2bb37900f2c10268e98ee36b00e7624ca9008b643ba2f418a20ab6f0c956ab62690156
9221d07b786505ad732104e28f177405e5268dd32ba431d2321882d26322a8049f20860ea5a3d7a20571ae38ada2223174c7829695af4cf3718006421aacba5d
3209d6baa539e4c6038279c116cbb13544726482b9f384c59e17a7bc49ec35420619084f35abdc88b08765a70d241dde8c9286028cf74e41ca00cb4108a82cf8
86ac4a75a73ffd52236d950456d2570a66a0f05df60c1d5d4f8d94214afa69dfa7371396413294e3f33af3d9840232a71d1abb17ca043f650212495b9e41f8de
75028f96bd2d9b6d0184125b3a1f6432a5671751e86ab835327c4284a59edeef2a01dab43a8b6a19dc68c3047eb1150396232aab46f60e7ac60ee8c4c8adeab0
b99984f68e76a24a397039542f000f68c1230e4ad846a28ff84a6e0b35e1397fbe34c086318725e9eecd5396040912393ad2640454076ec11df5253ddc05b347
dedd0a5114f8659252f7b4ce0cea2d289267c2a54106eb29969f5cec3d9221d7084fdf0b8352ad72d4a180d4121a91418492250310230278f9131e95136705b8
236100e8a7dae4837d0f7514d204f4050a6345620c043e6090f2b252b90b3df33913d680a0209b143c36d31454a4a4e20020504ca8e08053ea00a74e629a0742
bcd50d7b59071d9c24e08500bdc35424a06102b19ba7fbc5944e35025ff0b6430677c563130c545295022206ad7ac109c44105ad9a9086bc007ee505f9326bd3
1dd443054ecc40b21909fe052b32470e2fb287c296bc143b09a1f133e2011788b4b47c00ba098651a2223e454b57021b18bcb2d7c402e314dc42f0d6b5308281
6b160d540288422af46a84a804f90a5132b85d29bca25a74127104b8c8b4e800889011c0e4b8002bd3feb8e20a4e414432a2de0c34023dbd068894bca332e949
bb8332701a014621d3e103d539f49c7dd092c51e14ca026877c801e802f8041a06e6034f4710b9d3d5b95a7df5a2dca7b73a2ab57943049bf9b61501dc14a347
092fab1d60750c82f3426b01fad645925db68a7e06091353127ede0a2dd3cd8600de0c63fa072064496e69b9c56a069ed2bd502700221428d166e83df4930f0a
9430bd12538676b4015c4215e072640327a8213156091203ea0cca4faf05948ed398f37230557ff277fdb4bf080a8f3e718652e3c5190d25a3072b089205a99e
3542ca04ec03863202d4d1f3930d76c49812ae16a3e8ba38e3c6ca0cabc2a5b2e5331adad6ec9a0fd49750308e031d966a8f7454a5800ef32d9102e195156308
fc41d233d18139c12d40b80001214b3263a723684a766248306faf7574f7a847d18c7aa54f73afed7fa7d04039bad0d51a0ed679ac214195a8013b084d2558b2
9202fbb39341671903d6f59a140dfc1ded9298feb9ce461cd313494ac5f75f1a5723d3f2a4d47401294c4dd60220b462e901cb0c1762a6f66ed223ecc3e532c9
0f03a94d37b2998cbb55876b11e140a90d94b402fda2e239524921023738e576a801b778f2432bbb0c4cc3bab2008361406ca0230de6346a14e73951129d0590
5096007d5f1c2d21370b53734229d90ffa33ec297f50adee54a041b501e3a609cf9dae04d12a1405cb577a2b01eef2b999f26c6835410717cb9e9ee903e8b5a8
a033b0e426260a048894572aa28c1ed3e3fde807c76dd0a83295985a363d04a84290455b35a4127e0754559101e401f415aa05865f0dd6129552aedc04da2365
adbd641377786b1a59c942f221e2bb566502c5650b740bb223b512ac4a006504996383f84c32201772620c7738c975e8b6940688e32fe3028c1242a7925dc300
4bc91a0384014c42c3523ea2fc02e6d34f5719026d80cda242004d86d3f65827d10a3abb4b94e202f2e5d868b07cc8529691669ebc72610f5413a4018c423774
9151740729d7006d6324230d052fc7e90d2542c365029823e108c4e500cb5158255404b20425bfd849940d9be00ebcb44b0058034c42d3f404750a7d3f072dde
5c4e840cc444b4d2ac51fe157b8c652db4f300a24152c4a4004f4755870e42f84a00ed74b45a9708720629bcc8940d8823aff40009084068c1430ce7c45a1d50
4612b2254d24155002d613126cc11d7307540291b351a07c83848ea03a028e04bfc973aa578cb0deb1d0026b7591b2c806d850835db4d106d1b591066dc88302
427853794cee93087a1280378e96d1000932cdb71f58ea4d635859ea040d77509d12a2e0b423021295b85b26a9008c32fe111db3371903dc1cb4008674010932
29960041029a001f02100c69a6184ca18ca295c7820d7a81b4cc06a4126f00176b07ad0ffaeb52c5c5d3052fd29341412271c29b0423c423425a0b8c107519f3
34f00d40743219f09ef116c99ea8c7781c7633b67c005123ff5d005df15d021d5f2fd35406a6084e5456c70a33e953ba0c9c3d002e588020c022537a42057215
fc6a5bcbb44e145d02ac0209012b3223d41d91109952851042da01e37ca914c304e8066432d50b1da1b5d20991f11914e3394d51470247b0460147813a064ab4
67829779daee84dbc308fef0b24201a4219594412703424b0ce82ef96b005fac915257cd9a72bb963fdd8ad217b22704f9a16677b92246f112f1daecdcc7f16b
14a336aa254202412f000b7049aa80fa2c01094ff4f382fd41cb5ba5a302acf9f4feda5c1efa56098ec13a903202be37138604af43d125f3047fa5408e08e7e5
82ace027fa04e6039b414243b22301f3b1f4f0a30db43fe379570d8f0baa67275258da74fb1a02b5321a04f60ddbc2f26db30007404069c0290ce6f471d5dc47
a50ce5b8cec4b84bb49154d4bdba039ac0b4bd699e3f0e52a3d321b5d4d1b20a8ec222331bd0ae09de723740748574045485f7466ad606f4f935073d7f0d1d02
c93e5ab24bab9ac104e873190e4c1276b5453fc5f9e142bb55ba02a9b29be1021d51eb59004f470ebed6043789d404da72100c08012a89a60740583a7c192339
6b327927d11311a22133a3ac1674d65afbea5a1ff9b317e86821c850d8b022105803527906beab46bf09ca4c9ea6b641027442b23203b6a7bc390c54d341c2bc
29ac04640298b2151096fc0bc204bfc512040903d840d17604b210f85b16e9045402e2d34d7647a415b8792402793a6e1d8c0d0d2b33c9e0b542ac00ec7080a8
11408b426d30932dc202df357d32291415b1a46ed470d10235ecf37a8252e90a5441f10264041d064fe20853c430b8266612b4307a342a04fa5baadcea017594
0d49084f9f015ff909731371845123024ee305b43b1e7402ac9406bdd8c605427811434b15d2017f81e73ec1a25b5e004c502229532a6e924203c6a1c7505451
02f89b0dfc0db47a7685b36ddcae395653e87424819677680653999b188c8aec036adde9f66afd6714e5c607bad51c2b418a46099b55e1b511f505abc63d3b53
d4a21d9096d3749c2b12a26af2d3724583569328956ebec4bf54d2f46795b70994ac830815e1515f8be753f59b384b25a0dc3b3a3e12fa74322ad05ac3eaf7d2
ccb0e80c4b235b71d24919f393a5595b6e55690200600e8912a02cac64a74b285853b228860119237d15a6024fd704d18182114fa102f035e1320252b3128316
b43c8672043d341406190134f91dc5d51a5d9b54c5e1f97410983365ec151336035a3f1e5b9631b7d6a6c7687d5743472a6e201d4164a0bc71763812439ea4d2
b1013943a9b263584792332b4f41e124c73da900072410020c1b00afc4d599d12a045974ef716053057edad6903163f76d2d0ef1332cd342139351036a00742c
7d9dda39132347dfd2add185820e2eb2417882b497708e01675bbe977718c8fbb349120854dc12e088f599df3a93015e21d703f10574071d0a2f42c17ff50d17
e8f97433231241a1bb29321242525a6b329703e2e200831124724cbd0097322060e1a885173bd6f1f7e41260490d7f81443293ea180d2fb235cc04d5040f0901
__label__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000007000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000050000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000050000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000070000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000600000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000005000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000cccccc0000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000cc77cccccc00000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000cc77cccccccc00000000000000000000b0000b00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000ccc7cccccccccc000000000000000000006ccc000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000061cccccccccccc150000000000000000006ccccc00000000000000000000000000000000000000000000
0000000000000000000000000000000000000000aa66dd11cccccccc11dd55aa0000000000c006c3cc3cc0000000000000000000000000000000000000000000
000000000000000000000000000000000000004d666dddddd111111dddddd5555400000000cc0cc1cc1cc0000000000000000000000000000000000000000000
0000000000000000000000000000000000000a6666dddddd6dddddd5dddddd5555900000000ddcccccccc0000000000000000000000000000000000000000000
000000000000000000000000000000000000009a6ddddddd6ddaadd5ddddddd59a000000000ddd5dddd555000000000000000000000000000000000000000000
00000000000000000000000000000000000000dd9a9adddd6ddaadd5dddd9a9a550000000000dd66dddd55500000000000000000000000000000000000000000
000000000000000000000000000000000000000d5d559a9a6dddddd59a9a55515000000000000ddddddd55500000000000000000000000000000000000000000
00000000000000000000000000000000000000000ddd55559a9a9a9a55555550000000000000055dddd55cc00000000000000000000000000000000000000000
000000000000000000000000000000000000000000055555155555515555500000000000000006dd55dd5c000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000d500551555515500d5000000000000000065500d550000000000000000000000000000000000000000000
000000000000000000000000000000000000000000dd500000000000000d55000000000000000ccc00ccc0000000000000000000000000000000000000000000
lllllllllllllllllllllllllllllllllllllllllld5lllllllllllllllld5llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll
llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll
llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll
3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll3lll
33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
33b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b333b3
3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb3bbb
bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
44b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b444b4
44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444
44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444
44444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444
40404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040404040
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
00090609080c0a0a090000090e0002022828282828282828282828282a007c7c7c7c7c7c7c7c000000000000000000000000000000000000000000007c7c0c00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002c2c00000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
e4503420b718da2d54e0de32be20d04d30e562b645052165b0e31e97f63d8d17055d792365968b3047101c2306a0463d450367529a29d1907127c78c343930912124a2141e8a3a3620be74d2523cb4ab6a5ee97370cd75790023411106bc099e000834107cb74900201c3d872dba541e20474b25234e6c8e10e5d3f321a47681
f7073e30e224321e30ca097c307a1e20b269eb090b106d49951770aef1688910ef7520d060b7cc41128fad7310b541ee2d300daccd2416e39a608e50d777ce1d4610563c9a59dd1e109dc7216e50a9623e6bc07480d274032fd1f0ed21c6ad92277e5660368b17b1753adf50000d93a8407d85ba41b20b4e317d95008e701504
960c6f5f8e964860b4134df9a0e5d8f82485a5e780953181430d471d4710964a57325052342d8f101235b76d8b24ce7e8da6a105c96a2b8506333415742b2f104301d1a9f42f1059e3d775706dcd1f104b9b3356139a119e469d9d4092372c6a41852f14ec91306b1c3ee52f2b008e12115ee600e23119341534a37c014db5c7
80c9d4b0ed110810248eda11291e20d03940f6398642c8a134c540514260d120c923efb0a7336f9ce71055117dd1d430c229232831064d207392d14691204a53a272aa3179a0cd232bcfd04fb7f5a4321024543daf7aea85203c42d6691c172028fafecf5a1b10a4791f20474164c13364640934c02c09854f0656006f002f4d
6cdbb5e540712a1b29233051230e7bb5140044241c8568016830a59e3be31a49e0ddeb20eb67b16820d9232aa7209020b509ef4028b22044243d1f404660e434061741ecb0bd7bcfa067414918f34423302485b4453df014226950a38960903d5a3d4939008814911ce210010f06903bda00cb14e5d6114bb4f3209c6910c42a
5a571a10fb3deb373027db804915701040e31246035493f9e297087d26ab5ab8d110ca33d4696d0cd020966dea7fcab0c842a202bfc7b098324033418c462453e0a224a923d64f5e95cf202ff0c993ba253e605f1d2d80c5320f252516f99f4aeafb0069ea012b6046a58d2090215e78007080940c10b2b006a5fa784f32bdc6
aa8506b945160855e9124224244f41b0d120e469407acfa84210e92f79ce6a6df06690e22a67f0253cff5a3ee7bf7489290d5aa64782dc6b10e84ce54974f17a322ba062cb3affce15b71cc6bcb0ebcd022460526ec28c109f3630b104c532b64ed1efd103c42b24f200b2043fa360a74e4c532ab596955038897cb4307ace85
ba408ee387f03599bb2dfd4b0445645ab05ab354c8142f5b60279cde8a10f91d48106524741d642074bb3d40a30b20a21e8e1799c8e97190eb9aab1c208a3bd3354a98e815e82449d3f34ad5d2db33b565db005282e4aa9bc05bdd144d803f1a6915ae34d0b7ac3321d12042d1204210d040d2b800c114c4860a1e8b145430fa
4d5125a8031073ea0439241dfd015a2068611eeedb80ec6a714724e2239e10e9c78c6d1270233bc2243b47276044104086eb591ffeba20321271b0347d745339c0b4e72169c01c1024ef191f9047102121294ea3204be2a533a0c4347920a32910d35cef10bc2abe009123f2181cb72400106a4250e22374d0ebcf601006ddad
15f0952431d0a0e90e312f3f51adceb2ea2f885dadb4dbb02b23284b69f61d4b2059aac52849f890f621bbcbae6648307b4e259ed058b4e598151c8e863dbf3970257d4ab4554880b4722041d3e02fd170f1432bf256e59daf2e56017660e7da1f232820ace820b8f48c413f2fa3244b83005e8c78100be2980c94be0087762d
6d70b435b1eea03b094545bb2f2e419fcc302bad201046474092cec6534bd66d617336d1379010b4e5826a6debfed2418e9f8c2086a856235c852941293812c8232868fa3a583a04d49f7a31803d1dd231450748fa32081e184842284338da4114588f682f4f7a2307a140931dfd80f72e50b2142812642abc00e7987e2007a4
94002c0075943110e23296245f3d8fb8244d74523e409d3adc2b0746e782032907559fa045246720987cc8e124ed15bca1c7c83f5b69374353b07b468590b4673c7ab05c46244c49f4ff744bdda62ea7902c40416ff3a9a0d13492eb3d003e684932aa2032145d6f3eafe5ee35392db11b2043405b8a00a12a063b3a402f2451
50d91e4d1b1c071fad20233e2460d4573c5c75d01140ed0e60233e6524b880bc23bcaba6dffa327b3a40f642d23a071c2046245921b4fdf791bcd92031143d4719107b8fc841493a6d2be61cd5e309d020e90a494310ac318c4714689b07e280117b00d2ffb1f024081de5df94081fee3d232ff97c497be0baf18da9b6cd6516
20214b4dade0d04096bc10dde33bc293398067d545801910e6df9c20d9ae40241d1910324d5ab760d180d17068630aa170cb3b204dada5dba342a1c0d3d664c1b190712a1231d71a07ef30b78118f352d79f917091108e3d314720ce235190ead2f30043408a2450534617608831471c1852cf562dcc0070124798b22a57c41f
91fd6c0d4be5ca32fe8d5a2b12f400c802cfd50d430c5ece304212d3ea3410621e3fc5bcc810f2779d90954102d160ca4202bc4fa2e0ad2fe2c1b4a187756037b74220b71bbe269fcf00a45dc440b2809da920915e93bf7c10319dfba0c9399d1491212b93f950f57d140a40883da752b08ac63e60973e0073058ba47a5770d0
cf91059aa11c0ea770450ef7ab4a761f47a738a7e5ea9b3d21a4395d1f1d20a5b3b4c0f312142b156a2f397b0e4bc04d574acada4ada4e5b6d7067104c77b4fde08b28e698b3e2a310a0524c2a03b49eb45690d6b4fb31dae111a89820fa28e5047a3e208abd253c32c9650e40dde37a283c806e304ae200e31080980a328f67
314df914ffaa3cc03d864333dae15420e9de505c9208bed3c830f9216bd8a514b52b5b92d008040769d5b56052f4d056d7ec6dc06990f93b3960f294104223ca240252c5d0ce30b965391b20977474ae69a07703443033823c20bf37009206f500c21dc9747fd2ffb2801a013a1056526810504b24ca034c20738a4a2840fa3e
60af00a1105d2effea607265352b802753beeeb191709772724129f335c9f140da7e08cb56105a368cae96564514438ad29bf4453a2b7d1a3ea3b0b27ceee1313231eb1421ce1427332afb001e0ee143700482863da055553f013fcb505d92cb2b46808eff9bb02ab78c10d517c0af4b3da2676039407285a7ef29bad22a9af3
baae7a93ae808a19b2c91e708452b73458bf1c109b70e81dc820ea90d231404059705ba046d6d10646c690a0f6159320484dd25515a0150e2b4790d5a0ca1410c43faf770068dce1c1961ed3fd30d7f8e0bd2e75602d627edf70212458110fa7019705fc30ec24a6055a14f753e59220013d1104233da34ae44051205fce245b
8aa72f319a5a71adc810cb7ec1e89a5eb9707afc08157c0f973f904acf3f4740c845697c0072fe6de95390eb6a911780a112134bc901d27795009010af47555f48902a68b0d2b233fbf0e9c4b0959ea1451c7b7d6fc615a56dd1a5b6c6ff1f2124e96dd09232bd00bd77e3262390c80d492c980b05ae11d131107143119ce0b1
d0e4402f4e72b0313c9cb975ad958064324e2451d3a7a0d133e5a960ca0d054fb3da00b2415b70c641a28402bfc6ca8f20a7960e96b057111efc42b16071454f70642114323f168d9059240ed1172f4253407a7190d94d022315edbf1e605c20fd1f803412486d20d234aaebf269dcbff50ea200ac705a09f400c04284927982
23bc534ed325828d0295c921104320c83965236d306bb3999110d1508d4b24170f2c613186e51da10b10bc4024a41686208b3095107030dc62d10d4099a02409c632b42e82203ed0b62eedc9194071fd1920c6a9102b561ac81ac25e0ec9dba623504d411dea908124a6418750972ba9ee9120a4bf99ae36434b74fb6d40a421
9beaa0cef1f4481001113d2014427c4780d5e0f180073bc400ba9b00cb2459d05adbf0bcc666152607dc2063952a224a29b07d51d1204740d7d2fc4393025fc16af090b0bc49903fbb90e810e820dc4723f7143f6b4df0e92c50b923f2680730c80eb20d2151e02322b411273028b8c65ee3f0e2141e9642503c32bf1780273e
004707f5fb6d23580e30a2085d64a6b61fd347213547101c2127a31112941cf57d30914032b967434f6740d87128f1291de6a9985532904a827970529670b3422340b521dea05d60e6c09ec0de5c327c93a70896b7a19dbc43748a32187c4adacc5aaabb1ef0d121c0a6a5936bc9ba1a3aa03a10451023209e3f913da4de5a5b
8200043fa5e9e0411b72869d3e00472164613165ba8b70d238d0256b240464505934019f6a02b130a10f4e57948639117940b3055aa1697f6ae780749f921f4a103c2093dd5a7e80794d5810148ce30a2327a303a12045406d103b399c6610a4723027a80140ebd302a310fb471930a33420c133555e01a7321d001014200ced
2c00bb2732490f4b1d3fe69a92742439d6355a3e8fc0473071865a496578abde80232b3277295545d0c12325241233261d05d2eb111720b728350cb7e4779dc2e2cd40b9d7102b248cb24101e54ca772189f15705295409031a1494a021428e35140195d4575f06de0da6bb90334295dd008b22abad07647b4497c2033c88121
d97c6bdb00c8079c0215c4109800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
00010000106500060019600186000c600036000160018600006000060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00040000057200662005520066300d7300e6300c5300e6401a7401b6401b6401a5401b6402a7402a640285402a630357303663035520346100000000000000000000000000000000000000000000000000000000
000200003f2703f2503f2303f2103f0003f0003f2603f2403f2303f2103f0003f0003f2403f2303f2203f2103f0003f0003f2303f2203f2203f2103f0003f0003f2203f2103f0003f0003f0003f0003f2103f000
000300000402007030076400664005630046200361000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000600002a640266301a6201a620156100b6101a60027600316003160000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000300002a3502b7302a3202b7202a3102b7102b3002c300233002030019300123000d30007300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00030000266502f660326702d6702c660296502664024630226301e6301c6401d650166501865018640056301662005630146400c64013640046301062010610066200f6300e630036200a61003610096100b600
00090000186102b610186100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000200000dd0009d1007d2006d2005d3006d3007d4009d400bd400ed4012d4018d3021d2029d2032d1039d0000d0000d0039d0039d0039d0000d0000d0000d0039d0039d0039d0000d0000d0000d0000d0000d00
00020000092100522003230032300224002240022400124001250012500025000250002500025000250002500025000250012500125001250022500225003250042500524005240062400723008230092200b220
000a00002d5202f520315302e54030540325402f54031540335303152033520355100050000500005000050000500005000050000500005000050000500005000050000500005000050000500005000050000500
000400002854028530285202851028500285002853028520285102850028500285002852028520285102850028500285002851028510285002850028500285002871028500285002850028500285002801028500
000200003866034640316202f6102d6502a630276202561023640216301f6201d6101c6301a620196101660015620146201261011600116101061000000000000000000000000000000000000000000000000000
000600001855018530185101855018530185101855018530185102455024540245302453024520245102155021530215102455024530245202451024510245102451024510005000050000500005000050000500
5d0c00000013000130001300013008130081300713007130001000010000100001000c1300c100001000010000130001300013000130081300813007130071300110000100001000010006130001000a10009100
5d0c00000013000130001300013008130081300713007130001000010000100001000c1300c1000010000100001300013000130001300813008130071300713001100001000c1300c130271310c1300000000000
91060010207121f712207121f712207121f7120070200702007020070200702007020070200702007020070200702007020070200702007020070200702007020070200702007020070200702007020070200702
460c00100263700620006003f6003f6203c610006000060000600006003f600216003f620006003f6200060000600006000060000600006000060000600006000060000600006000060000600006000060000000
470c0010026530062002663006203f6203c613026503b6003c6530260002663026003f620006003f6200060000600006000060000600006000060000600006000060000600006000060000600006000000000000
890c00000050000500005000050024520005000050000500205200050000500005001f52000500005000050020520005000050000500235202352024521245200050000500235222352223522235250050000500
890c00100050000500005000050024520005000050000500205200050000500005001f52000500005000050020520005000050000500235202352024521245200050000500235222352223522235250050000500
610c00201f0001f0001f0001f0001f0301f0301e0311e0001f0301f0301f0301f0001f0001f0001f0301f0301f0321f0001f0001f0001d0301e0311e0311b0311b0301f0001a0341a03000000180311803000000
550c00001f5001f5001f5001f5001f5401f5301e5101e5001f5401f5301f5101f5001f5001f5001f5401f5301f5201f5001f5001f5001d5301e5401e5401b5401b530005001a5441a52000500185511854000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
470c0000026530062002663006203f6203c613026503b6003c6530260002663026003f620006003f6200060002633006100260000600026000060002600006000262300610006000060000600006000060000000
5d0c000000100001000010000100081000810007100071000010000100001000010000100001000010000100001300010000100071000c130000000000000000001300010000100071000c130000000000000000
__music__
00 4e501255
01 4f501819
01 0e101153
00 4f101254
00 0f101153
00 14101219
00 0e521213
00 0e101253
00 0e521213
00 0f101853
00 0e501115
00 0e501116
00 0e501115
00 0e501116
00 0e151216
00 0e501214
00 0e161215
02 0e501814

