layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;
layout (location = 2) out vec3 v_model_pos;
layout (location = 3) out vec3 v_tangent;
layout (location = 4) out vec3 v_light_dir;
layout (location = 5) out vec3 v_world_normal;
layout (location = 6) out vec3 v_world_pos;
layout (location = 7) out vec3 v_world_eye;
layout (location = 8) out vec3 v_world_tangent;
layout (location = 9) out vec3 v_camera_pos;

layout (location = 10) out vec3 v_color;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    float g_app_time;
    vec3 g_light_dir;
    float scale;

    float displacement;
};

vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}


void main() {
    float id = gl_InstanceIndex + g_app_time * 0.1;
    vec3 move = vec3(sin(id * 0.1342) * 0.5, sin(id*0.453423423)*0.08, cos(id * 0.12112) * 0.5);
//    move *= 0;
    vec3 rot = vec3(id*0.2, id*0.1 + g_app_time * 0.5, id*0.4);
//    rot *= 0.0;
    mat4 tr_mat = translate(move);
    mat4 rot_mat = rotate(rot);

    vec3 pos = a_position * scale;
    vec4 new_pos = tr_mat * rot_mat * vec4(pos, 1.0);
    vec3 new_normal = mat3(tr_mat) * mat3(rot_mat) * a_normal;
    vec3 new_tangent = mat3(tr_mat) * mat3(rot_mat) * a_tangent;

    gl_Position = g_projection_from_model * new_pos;
    v_uv = a_uv;

    v_normal = mat3(g_camera_from_model) * new_normal;
    v_tangent = mat3(g_camera_from_model) * new_tangent;
    v_model_pos = new_pos.xyz;

    v_light_dir = mat3(g_camera_from_world) * g_light_dir;

    mat3 inverse_camera_from_model = mat3(g_camera_from_world);
    v_world_eye = inverse_camera_from_model * -g_camera_from_world[3].xyz;
    v_world_pos = (g_world_from_model * new_pos).xyz;
    v_world_normal = mat3(g_world_from_model) * new_normal;
    v_world_tangent = mat3(g_world_from_model) * new_tangent;
    v_camera_pos = (g_camera_from_model * new_pos).xyz;

    v_color = pal(gl_InstanceIndex * 0.1, vec3(0.5,0.5,0.5),vec3(0.5,0.5,0.5),vec3(1.0,1.0,1.0),vec3(0.0,0.10,0.20) );
}