layout (location = 0) in vec2 v_depth_map_uv;
layout (location = 1) in vec3 v_ray_eye;
layout (location = 2) in vec3 v_ray_direction;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D depth_buffer;
layout (set = 1, binding = 2) uniform sampler2D noise_texture;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_camera;
    mat4 g_camera_from_world;
    float g_z_near;
    float g_app_time;

    vec3 circle_plane_normal;
    vec3 circle_center;
    vec4 circle_args;
    vec4 circle_color;
};



void main() {
    float depth_sample = texture(depth_buffer, v_depth_map_uv).r;
    float buffer_z = depth_sample_to_z(g_z_near, depth_sample);
    vec3 eye = v_ray_eye;
    vec3 dir = normalize(v_ray_direction);
    float buffer_depth = buffer_z * length(v_ray_direction);

    float dist;
    f_color = traced_color(eye, dir, circle_plane_normal, circle_center, circle_args, circle_color, buffer_depth, dist);
}
