#version 450

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 2) uniform sampler2D shadow;
float sample_shadow(vec2 uv) {
    return texture(shadow, uv).r;
}

#include "raytrace.glsl"

float z_to_frag_depth(float z) {
    return (z - g_z_near) / z;
}

void main() {
    vec4 result = render();
    gl_FragDepth = z_to_frag_depth(result.a);
    f_color = vec4(result.rgb, 1);
}