#version 450

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec3 v_normal;
layout (location = 1) out vec3 v_tangent;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    vec4 scale;
};

void main() {
    gl_Position = g_projection_from_model * vec4(a_position * scale.w * 5, 1.0);
    v_normal = mat3(g_camera_from_model) * a_normal;
    v_tangent = mat3(g_camera_from_model) * a_tangent;
}