layout (location = 0) in vec2 v_depth_map_uv;
layout (location = 1) in vec3 v_ray_eye;
layout (location = 2) in vec3 v_ray_direction;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_light_projection_from_world;
    mat4 g_projection_from_camera;
    mat4 g_camera_from_world;
    vec3 g_light_dir;
    float g_z_near;
    float g_app_time;

    vec3 sphere_pos_1;
    vec3 sphere_pos_2;
    vec4 sdf_foo_1;
    float shadow_bias;
    float ambient;
    vec3 diffuse_color;
    vec3 specular_color;
    vec4 specular_params;
};


#include "sdf_function.glsl"
#include "sdf_utils.glsl"

float calculate_light(vec3 world_pos) {
    vec3 lightspace_pos = (g_light_projection_from_world * vec4(world_pos, 1.0)).xyz;
    lightspace_pos.xy = lightspace_pos.xy * 0.5 + 0.5;
    float shadow_z = sample_shadow(lightspace_pos.xy);
    return (shadow_z + shadow_bias*0.001 > lightspace_pos.z) ? 1.0 : 0.0;
}

vec3 minimal_color(vec3 pos_ws, vec3 normal_ws) {
    float light = calculate_light(pos_ws);
    vec3 light_dir = normalize(g_light_dir);
    float diffuse_ratio = clamp(dot(normal_ws, light_dir), 0, 1);

    float specular_ratio = dot(reflect(-light_dir, normal_ws), -normalize(pos_ws - v_ray_eye));
    specular_ratio = clamp(pow(specular_ratio * specular_params.y, specular_params.x * 100) * specular_params.w, 0, specular_params.z);

    float diffuse_r2 = mix(ambient, 1.0, diffuse_ratio*light);
    return diffuse_color * diffuse_r2 + specular_color * specular_ratio * light;
}

/// rgb: color, a: z-value
vec4 render() {
    vec3 dir = normalize(v_ray_direction);
    vec3 eye = v_ray_eye;
    float dist = trace_sdf(eye, dir);

    if (dist < 0) {
        discard;
    }

    float z = dist * length(v_ray_direction);

    vec3 intersection_point = eye + dir * dist;
    vec3 intersection_normal = calculate_sdf_normal(intersection_point);
    vec3 color = minimal_color(intersection_point, intersection_normal);

    return vec4(color, z);
}
