#version 450

layout (location = 0) out vec4 FragColor;

uniform float time;

in vec2 texcoord;

void main(){

   vec4 white = vec4(1.0, 0.0, 0.0, 1.0);
   vec4 black = vec4(0.0, 0.0, 0.0, 1.0);

   float d = abs((texcoord.x - 0.5) * 2.0 * sin(time) - (texcoord.y - 0.5) * 2.0 * cos(time)) / 1.5;
   vec4 effect1 = mix(white, black, d);


   vec4 effect2 = vec4( sin( (texcoord.x - 0.5) * sin(time) * 100.0), cos(texcoord.y * 100.0) / 10.0, 0.8, 1.0) + 0.6;

   FragColor = mix(effect1, effect2, (sin(time) + 1.0) / 2.0);
}
