#! /usr/bin/env python

import os
os.environ['PYGAME_HIDE_SUPPORT_PROMPT'] = "hide"
os.putenv('SDL_VIDEODRIVER', 'fbcon')

import pygame
import time
from datetime import datetime
import math
import random
import numpy as np
import sounddevice as sd

disp_no = os.getenv("DISPLAY")
if disp_no:
	print(disp_no)

# Check which frame buffer drivers are available
# Start with fbcon since directfb hangs with composite output
drivers = ['fbcon', 'directfb', 'svgalib']
found = False
for driver in drivers:
	# Make sure that SDL_VIDEODRIVER is set
	if not os.getenv('SDL_VIDEODRIVER'):
		os.putenv('SDL_VIDEODRIVER', driver)
	try:
		pygame.display.init()
	except pygame.error:
		print("FAIL:")
		print(driver)
		continue
	found = True
	break

if not found:
	raise Exception('No suitable video driver found!')

scrW = 1080
scrH = 2160
screen = pygame.display.set_mode((scrW, scrH), pygame.NOFRAME)
pygame.mouse.set_visible(0)
pygame.display.set_caption("Pong")
sfc = pygame.Surface((scrW, scrH), pygame.SRCALPHA, 32)

green = (96, 255, 32)
dark = (48, 128, 16)
paddleHeight = scrW / 5.0
ballHeight = scrW / 50.0
ballWidth = scrH / 100.0
paddleSfc = pygame.Surface((round(paddleHeight), round(scrH / 100.0)), pygame.SRCALPHA, 32)
paddleSfc.fill(green)
ballSfc = pygame.Surface((round(ballWidth), round(ballHeight)), pygame.SRCALPHA, 32)
ballSfc.fill(green)
backgroundSfc = pygame.Surface((round(scrW), round(scrH / 100.0)), pygame.SRCALPHA, 32)
for i in range(0, 100, 4):
	pygame.draw.rect(backgroundSfc, dark, (round(scrW / 100.0 * i), 0, round(scrW / 50.0), round(scrH / 100.0)))

pressSpace = ["#","#","#","#"," "," ","#","#","#","#"," "," ","#","#","#","#","#"," "," ","#","#","#","#"," "," ","#","#","#","#"," "," "," "," ","#","#","#","#"," ","#","#","#","#"," "," "," ","#","#","#"," "," "," ","#","#","#"," "," ","#","#","#","#","#","#"," "," "," ","#"," ","#"," "," "," ","#"," ","#"," "," "," "," "," ","#"," "," "," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," "," "," ","#"," "," "," ","#"," ","#"," "," "," ","#"," ","#"," "," "," ","#"," ","#"," "," "," "," ","#","#","#","#"," "," ","#","#","#","#"," "," ","#","#","#"," "," "," "," ","#","#","#"," "," "," ","#","#","#"," "," "," "," "," ","#","#","#"," "," ","#","#","#","#"," "," ","#","#","#","#","#"," ","#"," "," "," "," "," ","#","#","#"," "," ","#"," "," "," "," "," ","#"," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," ","#"," "," "," "," "," ","#"," "," "," "," "," "," "," ","#"," ","#"," "," "," "," "," ","#"," "," "," ","#"," ","#"," "," "," ","#"," ","#"," "," "," "," ","#"," "," "," "," "," ","#"," "," ","#","#"," ","#","#","#","#","#"," ","#","#","#","#"," "," ","#","#","#","#"," "," "," "," ","#","#","#","#"," "," ","#"," "," "," "," "," ","#"," "," "," ","#"," "," ","#","#","#"," "," ","#","#","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#","#","#","#","#"," "," ","#","#","#"," "," "," "," "," "," "," "," "," "," "," ","#","#","#","#"," ","#","#","#","#","#"," "," ","#","#","#"," "," ","#","#","#","#"," "," ","#","#","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," "," ","#","#","#"," "," "," "," ","#"," "," "," ","#","#","#","#","#"," ","#","#","#","#"," "," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," ","#"," ","#"," ","#"," "," "," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," "," ","#","#","#"," "," "," "," "," "," "," "," "," "," ","#","#","#","#"," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," ","#"," "," ","#","#"," "," "," ","#"," "," "," "," "," "," "," "," "]
pressSpaceSfc = pygame.Surface((round(11 * (scrW / 50.0)), round(61 * (scrH / 100.0))), pygame.SRCALPHA, 32)
for y in range(0, 11):
	for x in range(0, 61):
		if pressSpace[x + y * 61] == "#":
			pygame.draw.rect(pressSpaceSfc, green, (round((10 - y) * (scrW / 50.0)), round(x * scrH / 100.0), round(scrH / 100.0), round(scrW / 50.0)))

leftRight = ["#"," "," "," "," "," ","#","#","#","#","#"," ","#","#","#","#","#"," ","#","#","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#","#","#"," "," "," "," "," "," "," "," "," ","#","#","#"," ","#"," "," "," "," "," ","#"," "," "," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," ","#","#"," "," "," "," "," ","#","#","#"," "," "," ","#","#","#"," "," "," "," "," ","#"," "," "," ","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," ","#"," ","#"," "," "," "," "," "," "," ","#","#","#","#","#","#"," "," "," "," "," ","#"," "," "," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," ","#","#"," "," ","#","#"," "," "," ","#"," "," "," ","#","#","#","#","#","#"," ","#","#","#","#","#"," ","#"," "," "," "," "," "," "," ","#"," "," "," ","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#","#","#","#"," ","#"," "," "," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#","#","#","#"," "," ","#","#","#","#","#"," "," ","#","#","#","#"," ","#"," "," "," ","#"," ","#","#","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#","#","#"," "," "," "," "," "," "," "," ","#"," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," "," ","#","#","#","#"," "," "," "," ","#"," "," "," ","#"," ","#","#","#"," ","#","#","#","#","#"," "," "," ","#"," "," "," ","#","#","#"," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," ","#"," "," "," "," ","#"," ","#"," "," "," "," "," ","#"," "," "," ","#"," "," "," ","#"," ","#"," "," "," ","#"," "," "," ","#"," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," "," ","#"," "," "," ","#"," "," ","#","#"," "," "," ","#"," "," "," "," ","#"," "," ","#","#"," ","#","#","#","#","#"," "," ","#","#","#","#"," ","#"," "," "," ","#"," "," "," ","#"," "," "," ","#","#","#"," "," "," "," "," "," "," "," "," "," "," "," ","#","#","#"," "," ","#"," "," "," "," "," ","#","#","#","#","#"]
leftRightSfc = pygame.Surface((round(11 * (scrW / 50.0)), round(61 * (scrH / 100.0))), pygame.SRCALPHA, 32)
for y in range(0, 11):
	for x in range(0, 61):
		if leftRight[x + y * 61] == "#":
			pygame.draw.rect(leftRightSfc, green, (round((10 - y) * (scrW / 50.0)), round(x * (scrH / 100.0)), round(scrH / 100.0), round(scrW / 50.0)))

number0 = [" ","#","#","#"," ","#"," "," "," ","#","#"," ","#"," ","#","#"," "," "," ","#"," ","#","#","#"," "]
number1 = [" "," ","#"," "," "," ","#","#"," "," ","#"," ","#"," "," "," "," ","#"," "," ","#","#","#","#","#"]
number2 = [" ","#","#","#"," ","#"," "," "," ","#"," "," ","#","#"," "," ","#"," "," "," ","#","#","#","#","#"]
number3 = ["#","#","#","#"," "," "," "," "," ","#"," "," ","#","#"," "," "," "," "," ","#","#","#","#","#"," "]
number4 = [" "," ","#","#"," "," ","#"," ","#"," ","#"," "," ","#"," ","#","#","#","#","#"," "," "," ","#"," "]
number5 = ["#","#","#","#","#","#"," "," "," "," ","#","#","#","#"," "," "," "," "," ","#","#","#","#","#"," "]
number6 = [" ","#","#","#"," ","#"," "," "," "," ","#","#","#","#"," ","#"," "," "," ","#"," ","#","#","#"," "]
number7 = ["#","#","#","#","#"," "," "," "," ","#"," "," ","#","#"," "," ","#"," "," "," "," ","#"," "," "," "]

number0Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number1Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number2Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number3Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number4Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number5Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number6Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)
number7Sfc = pygame.Surface((round(5 * (scrW / 50.0)), round(5 * (scrH / 100.0))), pygame.SRCALPHA, 32)

def numberSfc(obj, sfc):
	for y in range(0, 5):
	  for x in range(0, 5):
	    if obj[x + y * 5] == "#":
	      pygame.draw.rect(sfc, dark, (round((4 - y) * (scrW / 50.0)), round(x * (scrH / 100.0)), round(scrW / 50.0), round(scrH / 100.0)))

numberSfc(number0, number0Sfc)
numberSfc(number1, number1Sfc)
numberSfc(number2, number2Sfc)
numberSfc(number3, number3Sfc)
numberSfc(number4, number4Sfc)
numberSfc(number5, number5Sfc)
numberSfc(number6, number6Sfc)
numberSfc(number7, number7Sfc)

scoreSfcs = [number0Sfc, number1Sfc, number2Sfc, number3Sfc, number4Sfc, number5Sfc, number6Sfc, number7Sfc]

#fs = 44100
#soundLen = int(44100 * 0.3)
#hitPaddle = np.linspace(0, 1000, soundLen)
#hitPaddle = np.array([np.sin(x) * ((soundLen - (x * 13.23)) / soundLen) for x in hitPaddle])
#hitWall = np.linspace(0, 2000, soundLen)
#hitWall = np.array([np.sin(x) * ((soundLen - (x * 6.125)) / soundLen) for x in hitWall])
#point = np.linspace(0, 1500, soundLen)
#point = np.array([np.sin(x) * (1 - ((x % 500) / 500)) for x in point])

def main():
	running = True

	startDate = time.time()
	curTime = startDate
	drawFrame = True
	fps = 30
	frame = 0
	playing = False

	paddle1 = Paddle(1, scrW / 2.0, 0)
	paddle2 = Paddle(2, scrW / 2.0, 0)
	ball = Ball(scrW / 2.0 - (scrW / 100.0) / 2.0, scrH / 2.0 - (scrH / 100.0) / 2.0, -80, 0.15)
	toWin = 7

	while running:
		# for event in pygame.event.get():
		keys = pygame.key.get_pressed()
		event = pygame.event.poll()
		if event.type == pygame.QUIT or keys[pygame.K_ESCAPE]:
			running = False
		if keys[pygame.K_a]:
			paddle1.x -= scrW / (scrW * 5.0)
			if paddle1.x <= paddleHeight / 2.0:
				paddle1.x = paddleHeight / 2.0
		if keys[pygame.K_q]:
			paddle1.x += scrW / (scrW * 5.0)
			if paddle1.x + (paddleHeight / 2.0) >= scrW:
				paddle1.x = scrW - (paddleHeight / 2.0)
		if keys[pygame.K_l]:
			paddle2.x -= scrW / (scrW * 5.0)
			if paddle2.x <= paddleHeight / 2.0:
				paddle2.x = paddleHeight / 2.0
		if keys[pygame.K_o]:
			paddle2.x += scrW / (scrW * 5.0)
			if paddle2.x + (paddleHeight / 2.0) >= scrW:
				paddle2.x = scrW - (paddleHeight / 2.0)
		if keys[pygame.K_SPACE] and playing == False:
			paddle1.score = 0
			paddle2.score = 0
			playing = True

		if playing == True:
			ball.x += math.cos(math.radians(ball.angle)) * ball.speed
			ball.y += math.sin(math.radians(ball.angle)) * ball.speed
		if ball.x <= 0:
			#sd.play(hitWall, fs)
			ball.x = 0
			if ball.angle <= 0:
				ball.angle = (180 + ball.angle) * (-1)
			else:
				ball.angle = 180 - ball.angle
		if ball.x >= scrW - ballWidth:
			#sd.play(hitWall, fs)
			ball.x = scrW - ballWidth
			if ball.angle >= 0:
				ball.angle = 90 + (90 - ball.angle)
			else:
				ball.angle = (180 + ball.angle) * (-1)
		
		#Check if ball is beyond paddles
		if ball.y >= scrH: # Player 1 scores
			#sd.play(point, fs)
			ball = Ball(scrW / 2.0 - (scrW / 100.0) / 2.0, scrH / 2.0 - (scrH / 100.0) / 2.0, (-90) + random.randint(-45, 45), 0.15)
			paddle1.score += 1
			if paddle1.score == toWin:
				playing = False
			print("Left: " + str(paddle1.score) + " - Right: " + str(paddle2.score))

		if ball.y <= (ballWidth * -1.0): # Player 2 scores
			#sd.play(point, fs)
			ball = Ball(scrW / 2.0 - (scrW / 100.0) / 2.0, scrH / 2.0 - (scrH / 100.0) / 2.0, 90 + random.randint(-45, 45), 0.15)
			paddle2.score += 1
			if paddle2.score == toWin:
				playing = False
			print("Left: " + str(paddle1.score) + " - Right: " + str(paddle2.score))

		#Check if ball has hit a paddle
		if ball.y <= (scrH / 100.0) * 2.0: # Left (top) paddle
			ballX = ball.x + (ballWidth / 2.0)
			if paddle1.x - (paddleHeight / 2.0) <= ballX and ballX <= paddle1.x + (paddleHeight / 2.0) and (ball.angle <= 0 and ball.angle >= -180):
				#sd.play(hitPaddle, fs)
				ball.angle = 90 + ((paddle1.x - ball.x) / (paddleHeight / 2.0) * 70.0)
				ball.speed += 6.0 / (fps * 20.0)

		if ball.y >= (scrH - ((scrH / 100.0) * 2.0) - ballWidth): # Right (bottom) paddle
			ballX = ball.x + (ballWidth / 2.0)
			if paddle2.x - (paddleHeight / 2.0) <= ballX and ballX <= paddle2.x + (paddleHeight / 2.0) and (ball.angle >= 0 and ball.angle <= 180):
				#sd.play(hitPaddle, fs)
				ball.angle = (-90) + ((ball.x - paddle2.x) / (paddleHeight / 2.0) * 70.0)
				ball.speed += 6.0 / (fps * 20.0)

		if drawFrame:
			screen.fill((0, 0, 0))

			screen.blit(backgroundSfc, (0, round(scrH / 2.0 - scrH / 200.0)))

			if playing == False:
				screen.blit(pressSpaceSfc, (round(70.0 * (scrW / 100.0)), round(scrH / 2.0 - 30.5 * (scrH / 100.0))))
				screen.blit(leftRightSfc, (round(scrW / 2.0 - 30.5 * (scrW / 100.0)), round(scrH / 2.0 - 30.5 * (scrH / 100.0))))

			screen.blit(scoreSfcs[paddle1.score], (round(85.0 * (scrW / 100.0)), round(5.0 * (scrH / 100.0))))
			screen.blit(scoreSfcs[paddle2.score], (round(85.0 * (scrW / 100.0)), round(90.0 * (scrH / 100.0))))
			screen.blit(paddleSfc, (round(paddle1.x - (paddleHeight / 2.0)), round(scrH / 100.0 * 1.0)))
			screen.blit(paddleSfc, (round(paddle2.x - (paddleHeight / 2.0)), round(scrH / 100.0 * 98.0)))
			screen.blit(ballSfc, (round(ball.x), round(ball.y)))
			pygame.display.update()
			drawFrame = False

		newTime = time.time()
		curFrame = math.floor((newTime - startDate) * fps)
		if curFrame > frame:
			curTime = newTime
			frame = curFrame
			drawFrame = True

class Paddle:
	def __init__(self, player, x, score):
		self.player = player
		self.x = x
		self.score = score

class Ball:
	def __init__(self, x, y, angle, speed):
		self.x = x
		self.y = y
		self.angle = angle
		self.speed = speed

if __name__ == "__main__":
	main()