;Check HumanShader project by iq - humanshader.com
;256byte DOS version by TomCat/Abaddon
;greetings to Jin X and bitl

dither EQU 1
rrrola EQU 2

ORG 256
 MOV AL,13H		; set video mode to 320x200 pixels and 256 colors
 INT 10H

 SALC
 MOV DX,3C8H
 OUT DX,AL
 INC DX
if rrrola=2		; color palette from Symetrie by Rrrola
 PUSHA
.1:
 or ax,1100001111000011b
 push ax
 out dx,al
 add  al,ah
 shr  al,1
 out dx,al
 add  al,ah
 shr  al,2
 out dx,al
 pop  ax
 inc  ax
 jnz .1
 POPA
end if
if rrrola=1		; color palette from Atractor by Rrrola
 PUSHA
.1:
 or ax,0fc3h
 push ax
 shr ax,10
 out dx,al
 mul al
 shr  al,6
 out dx,al
 pop ax
 out dx,al
 inc  ax
 jnz .1
 POPA
end if
if rrrola=0
.1:
 PUSHA
 AAM 16
 SHL AX,2
 MOV [SI],AX
 OUT DX,AL
 MOV AL,82
 MUL AH
 XCHG [SI],AH
 MOV AL,191
 MUL AH
 ADD [SI],AH
 OUTSB
 OUTSB
 POPA
 INC AX
 JNZ .1
end if

 PUSH WORD 0A000H
 POP ES
 XCHG DI,AX
 MOV CX,205*200 			; CH:y*4
nextline:
 MOV BP,114*320
nextpixel:
 PUSH BP
 SUB BP,114*320-36*4*128-128*3
 SAR BP,7
 MOV AL,18*4-160+2
 ADD AL,CH
 CBW
 MOV SI,AX				; SI:v=y*4-160+18*4
 IMUL AX				; AX:v2
 SUB DX,BP				; DX:u
 IMUL BP,BP
 ADD BP,AX				; BP:h=u2+v2
 SHR BP,3
 CMP BP,200*2
 JB sphere
 DEC SI
 JS ground
sky:
 MOV AX,73*256+133
 SAR DX,2
 SUB DL,CH
putpixelc:
 CALL clamp

putpixel:
if dither=1
 PUSH DI
 XOR DI,CX
 SHR DI,1
 POP DI
 JNC .1
 MOV DL,8
 CALL clamp
.1:
end if

 SHR AH,4
 AND AL,0F0H
 OR AL,AH
 STOSB

 POP BP
 SUB BP,114
 JNZ nextpixel
 SUB CX,205
 JNZ nextline

 CBW
 INT 16H

scale:
 MOV DL,AH
 MUL DH
 XCHG DX,AX
 MUL AH
 MOV AL,DH
RETN				; return to DOS prompt

sphere:
 MOV AX,42*256+52
 ADD BP,100
 IMUL SI,BP			; SI:q=v*t
 IMUL BP,DX			; BP:p=u*t

 LEA BX,[BP+SI]
 NEG BP

 MOV DX,BP
 SAR DX,1
 ADD DX,SI
 SAR DX,8
 ADD DX,-63
 IMUL DX,DX
 SHR DX,7
 CALL clamp2

 MOV DH,-111
 ADD DX,SI

 CALL scale

 MOV DL,BH
 CMP SI,BP
 JG putpixelc

putpixel0:
 JMP putpixel

ground:
 IMUL BX,SI,-120
 SUB BX,AX
 SUB BX,BP

 MOV AX,SI
 SAR AX,1
 AAM 1
 ADD AX,150*256+50

 IMUL SI,DX
 SAR SI,3
 ADD SI,BX

 CMP BX,1200*2
 JNG shadow

 SHR BX,4
 IMUL BX,BX
 IMUL DX,BX,-3

 CALL scale

shadow:
 MOV DX,3200
 SUB DX,SI
 SHR BP,1
 SUB DX,BP
 JS .4
 TEST DH,DH
 JZ .3
 MOV DL,255
.3:
 CALL clamp2
.4:

JMP putpixel0

clamp:
 ADD AL,DL
 JNC .1
 SALC
.1:
clamp2:
 ADD AH,DL
 JNC .2
 MOV AH,255
.2:
RETN
