
var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

var images = {};
var warPos=[200,-50,-40,-110,-100,-50,200];
var bpm=170;
var beat = bpm/60;
var tick= beat/8;
var currentIndexNumber = 2;
var pattern = 8*beat;
var postCreditsTime=47.5*pattern;
var kuuset = 4;
var particleMesh = void null;
var fftImage = new Image();
	

function additive(animation) {
	glPushMatrix();     
    gl.enable(gl.BLEND);
	gl.blendFunc(gl.ONE, gl.ONE);
	glPopMatrix();
}

function normal(animation) {
	glPushMatrix();     
	gl.enable(gl.BLEND);
	//gl.blendFunc(gl.ONE, gl.ONE);
	glPopMatrix();
}
	
function blendAdd(animation) {
	gl.enable(gl.DEPTH_TEST);
	gl.depthMask(0);
	gl.enable(gl.BLEND);
	//gl.blendFunc(gl.ONE, gl.ONE);
	gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
}

function blendNormal(animation) {
	gl.enable(gl.BLEND);
	gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
}


Demo.prototype.init = function()
{
	
    var start = 0;
    var duration = 60*20;

	fftImage.load("fft0");
	
	//fbot
	this.createFBO(0,20000,"fbo20k");
	this.createFBO(20003,30000,"fbo30k");
	this.createFBO(30003,40000,"fbo40k");
	//debugPrint(666);
	
	
	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
		,"image": ["fbo20k.color.fbo", "fft0"]
		,"layer": 40107

	}]);

   	this.loader.addAnimation ([
	{
	"start": 15.5*pattern, "duration": 8888
	,"image": ["fbo30k.color.fbo", "fft0"]
	,"scale":[{"uniform3d":4.1}
		,{"duration":4*pattern,"uniform3d":1.1}
		,{"duration":4.75*pattern,"uniform3d":1.1}
		,{"duration":.25*pattern,"uniform3d":3.6}
		,{"duration":.25*pattern,"uniform3d":3.6}]
	,"layer": 51208
	,"position":[{"x":1080,"y":3400}
		,{"duration":2*pattern,"x":640,"y":370}]

	}]);	 
	
	this.loader.addAnimation ([
	{
	 "start": 0, "duration": 8888
	,"image": ["fbo40k.color.fbo"]
	,"layer": 50105
	,"position":[{"x":640,"y":360}
		]
	,"scale":[{"uniform3d":1.0}]
	,"angle": [{"degreesZ":"{return Math.sin(getSceneTimeFromStart())}"}]
	,"runFunction": "{normal(animation);}"

	}]);
	
	this.createFBO(40005,52000,"fbolut");
	
	this.loader.addAnimation ([
	{
	 "start": 0, "duration": 8888
	,"image": ["fbolut.color.fbo","2dlut.png"]
	,"layer": 60105
	}]);

	this.loader.addAnimation([
    {
         "start": 0, "duration":3
        ,"layer": 99998, "image": ["data/white.png"]
		,"scale":[{"x":15.0,"y":15.0}]
		,"position":[{"x":960,"y":540}]
		,"color":[{"r":0,"g":0,"b":0,"a":255}
		,{"duration": .5,"a":255}
		,{"duration": 3.5,"a":0}]
		}
	]);
	
	this.loader.addAnimation([
    {
         "start": 107, "duration":30
        ,"layer": 99998, "image": ["data/white.png"]
		,"scale":[{"x":15.0,"y":15.0}]
		,"position":[{"x":960,"y":540}]
		,"color":[{"r":0,"g":0,"b":0,"a":0}		
		,{"duration": 3,"a":255}]
		}
	]);

	this.loader.addAnimation([
    {
         "start": 111, "duration":30
        ,"layer": 99999, "image": ["data/end.png"]
		,"scale":[{"x":1.0,"y":1.0}]
		,"position":[{"x":960,"y":540}]
		}
	]);
	
	this.bar(0,120,255,0,0);
	this.bar(0,970,255,0,0);
	this.bar(0,545,0,255,0);

	this.generateTrees(0,120,8);
	this.generateStars(0,120,12);
	this.generateSnow(0,120,120*4);

	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
		,"layer": 5900, "image": ["data/fist.png"]
		,"scale":[{"x":"{return 10+1*Math.sin(-2*getSceneTimeFromStart())}","y":"{return .7+0.21*Math.sin(2*getSceneTimeFromStart())}"}]
		,"position":[{"x":960,"y":550}]
		,"shader":{"name":["mirrorscroll.fs"],
			"variable":[
				 {"name":"value1","value":["{return Math.sin(getSceneTimeFromStart());}"]}
			]
		}
	}]);

	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
		,"layer": 4000, "image": ["data/stripes2.png"]
		,"scale":[{"x":38.00,"y":"{return 1.2+0.1*Math.sin(5*getSceneTimeFromStart());}"}]
		,"position":[{"x":960,"y":333}]
		,"shader":{"name":["scroll2.fs"],
			"variable":[
				 {"name":"value1","value":["{return -getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
	
	this.loader.addAnimation ([
	{
		 "start": 0, "duration": 8888
		,"layer": 4000, "image": ["data/stripes2.png"]
		,"scale":[{"x":"{return 38+2*Math.sin(5*getSceneTimeFromStart());}","y":1.2}]
		,"position":[{"x":960,"y":755}]
		,"shader":{"name":["scroll2.fs"],
			"variable":[
				 {"name":"value1","value":["{return getSceneTimeFromStart();}"]}
			]
		}
	}]);
	
this.pukkiPuhuu(7.113,8.100);
this.subtitle(7.113,8.1,"KNOCK KNOCK KNOCK");

this.pukki(8.10,12.04);
this.pukkiPuhuu(12.04,13.45);
this.subtitle(12.04,13.45,"Hoh-hoh-hoo!");
this.pukki(13.45,14.26);
this.pukkiPuhuu(14.26,17.1);
this.subtitle(14.26,17.1,"Are there any nice kids here?");
this.pukki(17.1,21.76);
this.pukkiPuhuu(21.76,23.7);
this.pukki(23.7,31.1);
this.pukkiPuhuu(31.1,38.8);
this.pukki(38.8,43.1);
this.pukkiPuhuu(43.1,47.32);
this.pukki(47.32, 54.3);
this.pukkiPuhuu(54.3, 70.11);
this.pukki(70.11, 75.1);
this.pukkiPuhuu(75.1,78.23);
this.pukki(78.23,82.95);
this.pukkiPuhuu(82.95,99.1);
this.pukki(99.1, 104.35);
this.pukkiPuhuu(104.35,105.18);
this.pukki(105.18,107);


this.subtitle(21.76,24.2,"Well, what have you done?");
this.subtitle(31.1,34.0,"Well, that's a really nice thing.");
this.subtitle(34.0,36,"The task of a limited company is");
this.subtitle(36.0,39.5,"to generate profit for the shareholders");
this.subtitle(43.1,45.5,"Well, what have you wished for");
this.subtitle(45.5,48.32,"from Santa Claus this year?");
this.subtitle(54.3, 56,"Well, listen");
this.subtitle(56.0, 58,"it just so happened that");
this.subtitle(58.0, 60.75,"those elves at the goat's workshop");
this.subtitle(60.75, 65,"couldn't finish the flag in time");
this.subtitle(65.0, 67.5,"That event is now sold out");
this.subtitle(67.5, 71.11,"The buck got to buy the last ticket");
this.subtitle(75.1,79.23,"Well, what else did you wish for?");
this.subtitle(82.95,84.6,"Oh listen");
this.subtitle(84.6,87.1,"it just so happened that");
this.subtitle(87.1,89.5,"those elves in the goat's workshop");
this.subtitle(89.5,95.1,"don't yet master six nm manufacturing process");
this.subtitle(95.1,100.2,"They can't do anything better than the Amiga SOO.");
this.subtitle(104.35,105.78,"Well, nope.");

this.penskaPuhuu(9.0,10.88);
this.subtitle(9.0,10.88,"Hey, it's Santa Claus");
this.penska(10.88,18.359);
this.penskaPuhuu(18.359,20.0)
this.penska(20.0,25.285);
this.penskaPuhuu(25.285,29.0);
this.penska(29.0,40.0);
this.penskaPuhuu(40.0,41.0);
this.penska(41.0,49.05);
this.penskaPuhuu(49.05,52.8);
this.penska(52.8,71.5);
this.penskaPuhuu(71.5,73.7)
this.penska(73.7,79.7);
this.penskaPuhuu(79.7,80.9);
this.penska(80.9,100.45);
this.penskaPuhuu(100.45,102.4);
this.penska(102.4,200);

this.subtitle(18.359,21.0,"Yeah! I've been really kind!");
this.subtitle(25.285,30.0,"I have generated a lot of profit for the shareholders");
this.subtitle(40.0,41.5,"Whee");
this.subtitle(49.05,53.5,"I want a ticket to Jujuudauda's Little Christmas");
this.subtitle(71.5,74,"Sniff sniff sniff")
this.subtitle(79.7,81.3,"Playstation five");
this.subtitle(100.45,102.8,"Can I get an Amiga then?");
}

Demo.prototype.penska = function (startTime, endTime)
{
	this.loader.addAnimation([
		{
			 "start": startTime+.15, "end":endTime
			,"layer": 6000, "image": ["data/penska.png"]
			,"scale":[{"x":0.70,"y":0.70}]
			,"position":[{"x":420,"y":520}]
			,"angle": [{"degreesZ":"{return 8*Math.sin(3.5*getSceneTimeFromStart())}"}]
		}]);
}

Demo.prototype.penskaPuhuu = function (startTime, endTime)
{
	this.loader.addAnimation([
		{
			 "start": startTime, "end":endTime+.15
			,"layer": 6000, "image": ["data/penska.png"]
			,"scale":[{"x":"{return .9+0.2*Math.sin(7*getSceneTimeFromStart())}","y":"{return .9+0.2*Math.sin(-7*getSceneTimeFromStart())}"}]
			,"position":[{"x":420,"y":520}]
			,"angle": [{"degreesZ":"{return 4*Math.sin(-3*getSceneTimeFromStart())}"}]
		}]);
}

Demo.prototype.pukki = function (startTime, endTime)
{
	this.loader.addAnimation([
		{
			 "start": startTime+.15, "end":endTime
			,"layer": 6000, "image": ["data/pukki.png"]
			,"scale":[{"x":0.85,"y":0.85}]
			,"position":[{"x":1420,"y":600}]
			,"angle": [{"degreesZ":"{return 8*Math.sin(3.5*getSceneTimeFromStart())}"}]
		}]);
}

Demo.prototype.pukkiPuhuu = function (startTime, endTime)
{
	this.loader.addAnimation([
		{
			 "start": startTime, "end":endTime+.15
			,"layer": 6000, "image": ["data/pukki.png"]
			,"scale":[{"x":"{return 1.25+0.2*Math.sin(7*getSceneTimeFromStart())}","y":"{return 1.25+0.2*Math.sin(-7*getSceneTimeFromStart())}"}]
			,"position":[{"x":1420,"y":600}]
			,"angle": [{"degreesZ":"{return 4*Math.sin(-3*getSceneTimeFromStart())}"}]
		}]);
}

Demo.prototype.kuusi = function (startTime)
{

	for(i=0;i<kuuset;i++);
	{
		this.loader.addAnimation([
		{
			 "start": 0+i, "duration":99999
			,"layer": 5+i, "image": ["data/kuusi.png"]
			,"scale":[{"x":0.5,"y":0.5}]
			,"position":[{"x":320+Math.random()*30,"y":230}]
			,"angle": [{"degreesZ":"{return 16*Math.sin(3*getSceneTimeFromStart())}"}]
		}]);
	}
}


Demo.prototype.bar = function (startTime,yPos,r,g,b)
{
	this.loader.addAnimation([
    {
         "start": 0, "duration":99999
        ,"layer": 0, "image": ["data/white.png"]
		,"scale":[{"x":25.0,"y":4.0}]
		,"position":[{"x":720,"y":yPos}]
		,"color":[{"r":r,"g":g,"b":b,"a":255}]
		}
	]);
}



Demo.prototype.createFBO = function (startLayer, endLayer, name)
{
   	this.loader.addAnimation ([
	{
		"start": 0, "duration": 99999
		,"layer": startLayer
		,"fbo":{"name":name,"action":"begin","storeDepth":true}
	}
	]);
	
	this.loader.addAnimation ([
	{
		"start": 0, "duration": 99999
		,"layer": endLayer,"fbo":{"name":name,"action":"unbind"}
	}
	]);
	
}

Demo.prototype.generateTrees = function (startTime, duration, amount)
{
	
	for(i=0;i<amount;i++)
	{
		
		this.loader.addAnimation([{
			 "start": startTime, "duration": duration,"layer": 5000
			,"image": ["data/kuusi.png"]
			,"scale":[{"uniform3d":0.4+Math.random()*.2}]
			,"color":[{"r":255,"g":255,"b":255,"a":255}]
			,"angle": [{"degreesZ":"{return 16*Math.sin(3*getSceneTimeFromStart())}"}]
			,"position":[{"y":180,"x":i*275}]
	   }]);
	}

}
Demo.prototype.generateStars = function (startTime, duration, amount)
{
	
	for(i=0;i<amount;i++)
	{
		
		this.loader.addAnimation([{
			 "start": startTime, "duration": duration,"layer": 5000
			,"image": ["data/star.png"]
			,"scale":[{"uniform3d":"{return .65+.15*Math.sin(3*getSceneTimeFromStart())}"}]
			,"color":[{"r":255,"g":255,"b":255,"a":255}]
			,"angle": [{"degreesZ":"{return 100*getSceneTimeFromStart()}"}]
			,"position":[{"y":960,"x":i*175}]
	   }]);
	}
}

Demo.prototype.generateSnow = function (startTime, duration, amount)
{
	
	for(i=0;i<amount;i++)
	{
		
		this.loader.addAnimation([{
			 "start": startTime+.25*i, "duration": 4,"layer": 6000
			,"image": ["data/snow.png"]
			,"scale":[{"uniform3d":0.2+Math.random()*.4}]
			,"color":[{"r":255,"g":255,"b":255,"a":255}]
			,"angle": [{"degreesZ":Math.random()*360}]
			,"position":[{"y":1280,"x":Math.random()*1920}
			,{"duration": 4,"y":-15}]
	   }]);
	}
}

Demo.prototype.subtitle = function (startTime, duration, stringi)
{
	this.loader.addAnimation([{
		"start": startTime, "end": duration ,"layer": 7000,			
		"text":
		{
			"string":stringi	
			,"name":"font.ttf"
		}
		,"color":[{"r":0,"g":0,"b":0,"a":255}]
		,"scale":[{"uniform3d":2.25}]
		,"position":[{"x":960,"y":115}]
	}]);
	
	this.loader.addAnimation([{
	"start": startTime, "end": duration ,"layer": 6999,			
	"text":
	{
		"string":stringi	
		,"name":"font.ttf"
	}
	,"color":[{"r":255,"g":255,"b":255,"a":255}]
	,"scale":[{"uniform3d":2.25}]
	,"position":[{"x":965,"y":115}]
	}]);
}

