'use strict'

function hslToRgb (h, s, l) {
    var r, g, b;

    if(s == 0){
        r = g = b = l; // achromatic
    }else{
        var hue2rgb = function hue2rgb(p, q, t){
            if(t < 0) t += 1;
            if(t > 1) t -= 1;
            if(t < 1/6) return p + (q - p) * 6 * t;
            if(t < 1/2) return q;
            if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;
            return p;
        }

        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        var p = 2 * l - q;
        r = hue2rgb(p, q, h + 1/3);
        g = hue2rgb(p, q, h);
        b = hue2rgb(p, q, h - 1/3);
    }

    return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
}


function randomNormal (rng) {
    while (true) {
        const v = [(rng() - 0.5) * 2, (rng() - 0.5) * 2, (rng() - 0.5) * 2]
        var length = Math.sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2])
        if (length <= 1) {
            return m4.normalize(v)
        }
    }
}


function lerp (a, b, alpha) {
    return a + (b - a) * alpha
}


function clamp (a, min, max) {
    return Math.min(max, Math.max(min, a))
}

function degToRad (degrees) {
    return degrees * (Math.PI/180)
}

function radToDeg (rad) {
    return rad / (Math.PI/180)
}

function catmullRomSpline2(t, p0, p1, p2, p3) {
    const q0 = (-1 * t ** 3) + (2 * t ** 2) + (-1 * t)
    const q1 = (3 * t ** 3) + (-5 * t ** 2) + 2
    const q2 = (-3 * t ** 3) + (4 * t ** 2) + t
    const q3 = t ** 3 - t ** 2

    return [
        0.5 * ((p0[0] * q0) + (p1[0] * q1) + (p2[0] * q2) + (p3[0] * q3)),
        0.5 * ((p0[1] * q0) + (p1[1] * q1) + (p2[1] * q2) + (p3[1] * q3)),
    ]
}

function catmullRomSpline3(t, p0, p1, p2, p3) {
    const q0 = (-1 * t ** 3) + (2 * t ** 2) + (-1 * t)
    const q1 = (3 * t ** 3) + (-5 * t ** 2) + 2
    const q2 = (-3 * t ** 3) + (4 * t ** 2) + t
    const q3 = t ** 3 - t ** 2

    return [
        0.5 * ((p0[0] * q0) + (p1[0] * q1) + (p2[0] * q2) + (p3[0] * q3)),
        0.5 * ((p0[1] * q0) + (p1[1] * q1) + (p2[1] * q2) + (p3[1] * q3)),
        0.5 * ((p0[2] * q0) + (p1[2] * q1) + (p2[2] * q2) + (p3[2] * q3)),
    ]
}