'use strict'

entityRegistry['module']['sphere'] = {
    init: (staticConfig) => {
        const {
            distanceBase,
            distanceStep,
        } = { ...staticConfig }

        const makeTexTable = (distance) => {
            const texTable = []
            let i = 0
            for (let y = 0; y < 480; ++y) {
                const dy = y - 240
                for (let x = 0; x < 640; ++x)
                {
                    const dx = x - 320
                    const d=Math.sqrt(dx*dx+dy*dy)
                    const v = m4.normalize([dx/100, dy/100, distance])
                    // const v = m4.normalize([dx/300, dy/300, distance-d/80])
                    texTable[i++] = [v[0]*100, v[1]*100, v[2]*50]
                }
            }
            return texTable
        }
        return {
            texTable1: makeTexTable(distanceBase + distanceStep * 0),
            texTable2: makeTexTable(distanceBase + distanceStep * 1),
            texTable3: makeTexTable(distanceBase + distanceStep * 2),
        }
    },
    staticConfig: [
        { paramName: 'distanceBase', displayName: 'Distance Base', type: 'float', defaultValue: 5, triggerInit: true },
        { paramName: 'distanceStep', displayName: 'Distance Step', type: 'float', defaultValue: .2, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle', defaultValue: 0},
        { paramName: 'position', displayName: 'Position', type: 'float2', defaultValue: [0, 0]},
        { paramName: 'texture', displayName: 'Texture', type: 'colorTexture', defaultValue: ''},
        { paramName: 'scale', displayName: 'Scale', type: 'float', defaultValue: 10},
        { paramName: 'color1', displayName: 'Color 1', type: 'color', defaultValue: [1, 1, 1]},
        { paramName: 'color2', displayName: 'Color 2', type: 'color', defaultValue: [1, 1, 1]},
        { paramName: 'color3', displayName: 'Color 3', type: 'color', defaultValue: [1, 1, 1]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                rotation,
                position,
                texture,
                scale,
                color1,
                color2,
                color3,
            } = { ...config }

        const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const colorId1 = renderer.getPaletteId(color1, [0, 0, 0])
            const colorId2 = renderer.getPaletteId(color2, [0, 0, 0])
            const colorId3 = renderer.getPaletteId(color3, [0, 0, 0])

            const textureData = texture.data
            const textureWidth = texture.width
            const textureHeight = texture.height
            const txOff = textureWidth * 100
            const tyOff = textureHeight * 100

            const fx = Math.cos(rotation) * scale
            const fy = -Math.sin(rotation) * scale
            const rx = fy
            const ry = -fx
            const px = position[0] * fx + position[1] * fy
            const py = position[0] * rx + position[1] * ry

            let index = 0
            for (let xy = 0; xy < colorBuffer.width * colorBuffer.height/2; ++xy) {
                let [tx, ty, z] = self.texTable1[index]
                tx += px
                ty += py
                const ftx = Math.floor(tx*rx + ty*ry) + txOff
                const fty = Math.floor(tx*fx + ty*fy) + tyOff
                if (textureData[(ftx % textureWidth + (fty % textureHeight) * textureWidth) * 4]) {
                    colorBuffer.data[index] = colorId1
                    depthBuffer.data[index] = z
                    colorBuffer.data[index+1] = colorId1
                    depthBuffer.data[index+1] = z
                } else {
                    [tx, ty, z] = self.texTable2[index]
                    tx += px
                    ty += py
                    const ftx = Math.floor(tx*rx + ty*ry) + txOff
                    const fty = Math.floor(tx*fx + ty*fy) + tyOff
                    if (textureData[(ftx % textureWidth + (fty % textureHeight) * textureWidth) * 4]) {
                        colorBuffer.data[index] = colorId2
                        depthBuffer.data[index] = z
                        colorBuffer.data[index+1] = colorId2
                        depthBuffer.data[index+1] = z
                        } else {
                        [tx, ty, z] = self.texTable3[index]
                        tx += px
                        ty += py
                        const ftx = Math.floor(tx*rx + ty*ry) + txOff
                        const fty = Math.floor(tx*fx + ty*fy) + tyOff
                        if (textureData[(ftx % textureWidth + (fty % textureHeight) * textureWidth) * 4]) {
                            colorBuffer.data[index] = colorId3
                            depthBuffer.data[index] = z
                            colorBuffer.data[index+1] = colorId3
                            depthBuffer.data[index+1] = z
                        }
                    }
                }

                index++
                index++
            }
        }
    }
}
