'use strict'

entityRegistry['module']['repeatedModel'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'numRepeats', displayName: 'Repeats', type: 'int', defaultValue: 2, uiOptions: { min: 1 }},
        { paramName: 'numFaces', displayName: 'Faces', type: 'int', defaultValue: 3, uiOptions: { min: 2 }},
        { paramName: 'innerRotation', displayName: 'Inner Rotation', type: 'angle', defaultValue: 0},
        { paramName: 'numSegments', displayName: 'Segments', type: 'int', defaultValue: 3, uiOptions: { min: 3 }},
        { paramName: 'thickness', displayName: 'Thickness', type: 'float', defaultValue: .4, uiOptions: { min: 0 }},
        { paramName: 'thicknessStep', displayName: 'Thickness Step', type: 'float', defaultValue: 0},
        { paramName: 'startDistance', displayName: 'Start Distance', type: 'float', defaultValue: 3, uiOptions: { min: 0 }},
        { paramName: 'distanceStep', displayName: 'Distance Step', type: 'float', defaultValue: 1, uiOptions: { min: 0 }},
        { paramName: 'startRotation', displayName: 'Start Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'endRotation', displayName: 'End Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'diffuse1', displayName: 'Diffuse Color 1', type: 'color', defaultValue: [1, .8, 0]},
        { paramName: 'emissive1', displayName: 'Emissive Color 1', type: 'color', defaultValue: [0, .1, 0]},
        { paramName: 'diffuse2', displayName: 'Diffuse Color 2', type: 'color', defaultValue: [.8, 0, 1]},
        { paramName: 'emissive2', displayName: 'Emissive Color 2', type: 'color', defaultValue: [.1, 0, 0]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                numRepeats,
                numFaces,
                innerRotation,
                numSegments,
                thickness,
                thicknessStep,
                startDistance,
                distanceStep,
                startRotation,
                endRotation,
                rotation,
                diffuse1,
                emissive1,
                diffuse2,
                emissive2,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            for (let i = numRepeats-1; i >= 0; i-=1) {
                const model = {
                    verts: [],
                    objects: [
                        {
                            name: 'bob',
                            subObjects: [
                                {
                                    diffuse: [0, 0, 0],
                                    ambient: [0, .0, 0],
                                    emissive: [0, 0, 0],
                                    lines: [],
                                    tris: [],
                                    quads: [],
                                }
                            ]
                        }
                    ]
                }

                const faces = numFaces
                const segments = numSegments

                const sinCos = []
                const thisThickness = thickness + i * thicknessStep
                for (let i = 0; i < faces; ++i) {
                    const ringAngle = (i/faces) * Math.PI*2 + innerRotation
                    sinCos.push([Math.sin(ringAngle)*thisThickness/2, Math.cos(ringAngle)*-thisThickness/2])
                }

                const fwd = [0, 0, 1]
                const verts = model.verts
                for (let ang = 0; ang < segments+1; ang+=1) { // too many vert rings..
                    const angle = ang/segments * Math.PI*2
                    const distance = startDistance + i*distanceStep
                    const ringMiddle = [Math.sin(angle)*distance, Math.cos(angle)*distance, 0]
                    const up = m4.normalize(ringMiddle)
                    for (let i = 0; i < faces; i+=1) {
                        verts.push(m4.addVectors(ringMiddle, m4.addVectors(m4.multiplyVector(up, sinCos[i][0]), m4.multiplyVector(fwd, sinCos[i][1]))))
                    }
                }

                let ind = 0
                const quads = model.objects[0].subObjects[0].quads
                for (let ang = 0; ang < segments; ang+=1) {
                    for (let face = 0; face < faces-1; face+=1) {
                        quads.push([ind+face, ind+face+1, ind+faces+face+1, ind+faces+face])
                    }
                    quads.push([ind+faces-1, ind, ind+faces, ind+faces+faces-1])
                    ind += faces
                }
                renderer.decorateModel(model)
    
                const alpha = i / (numRepeats)
                const allRotation = m4.lerpVectors(startRotation, endRotation, alpha)
                allRotation[0] += rotation[0]
                allRotation[1] += rotation[1]
                allRotation[2] += rotation[2]

                const xRotationMat = m4.xRotation(allRotation[0])
                const yRotationMat = m4.yRotation(allRotation[1])
                const zRotationMat = m4.zRotation(allRotation[2])
                const translationMat = m4.translation(position[0], position[1], position[2])
                const worldMat = m4.multiply(translationMat, m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat))
          
                model.objects[0].subObjects[0].diffuse = (i & 1) ? diffuse1 : diffuse2
                model.objects[0].subObjects[0].emissive = (i & 1) ? emissive1 : emissive2

                renderer.drawModel(model, worldMat, colorBuffer, depthBuffer, brightnessBuffer, undefined)
            }
        }
    }
}
