'use strict'

entityRegistry['module']['present'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'mode', displayName: 'Mode', type: 'string', defaultValue: 'set', uiOptions: { options: [{text:'Set', value:'set'}, {text:'Blend', value:'blend'}] }},
        { paramName: 'blend', displayName: 'Blend', type: 'float', defaultValue: 0.5, uiOptions: { min: 0, max: 1, scrollScales: [0.01, 0.1, 1] }},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                mode,
                blend,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const pixels = renderer.canvasBuffer.data
            // const u32Pixels = new Uint32Array(pixels.buffer)
            let writeIndex = 0

            if (mode === 'set') {
                for (let readIndex = 0; readIndex < colorBuffer.pixelCount; ++readIndex) {
                    const colorId = colorBuffer.data[readIndex]
                    if (colorId && colorId < renderer.palette.length) {
                        const brightness = brightnessBuffer.data[readIndex]
                        if (brightness >= 0) {
                            const paletteData = renderer.palette[colorId]
                            pixels[writeIndex++] = paletteData[0][0] + paletteData[1][0] * brightness// * brightness
                            pixels[writeIndex++] = paletteData[0][1] + paletteData[1][1] * brightness// * brightness
                            pixels[writeIndex++] = paletteData[0][2] + paletteData[1][2] * brightness// * brightness
                            writeIndex++
                            // u32Pixels[writeIndex++] = 
                            //     (((paletteData[0][0] + paletteData[1][0]*brightness) & 0xff)) + 
                            //     (((paletteData[0][1] + paletteData[1][1]*brightness) & 0xff) << 8) + 
                            //     (((paletteData[0][2] + paletteData[1][2]*brightness) & 0xff) << 16) +
                            //     0xff000000
                        } else {
                            // pixels[writeIndex++] = 0
                            // pixels[writeIndex++] = 0
                            // pixels[writeIndex++] = 0
                            // writeIndex++
                            u32Pixels[writeIndex++] = 0xff000000
                        }
                    } else {
                        writeIndex += 4
                        // writeIndex++
                    }
                }
            } else if (mode === 'blend') {
                for (let readIndex = 0; readIndex < colorBuffer.pixelCount; ++readIndex) {
                    const colorId = colorBuffer.data[readIndex]
                    if (colorId && colorId < renderer.palette.length) {
                        const brightness = brightnessBuffer.data[readIndex]
                        const paletteData = renderer.palette[colorId]
                        const r = lerp(paletteData[0][0], paletteData[1][0], brightness)
                        const g = lerp(paletteData[0][1], paletteData[1][1], brightness)
                        const b = lerp(paletteData[0][2], paletteData[1][2], brightness)
                        pixels[writeIndex] = lerp(pixels[writeIndex], r, blend)
                        writeIndex++
                        pixels[writeIndex] = lerp(pixels[writeIndex], g, blend)
                        writeIndex++
                        pixels[writeIndex] = lerp(pixels[writeIndex], b, blend)
                        writeIndex++
                        writeIndex++
                    } else {
                        writeIndex += 4
                    }
                }
            }
        }
    }
}
