'use strict'

entityRegistry['module']['blur'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'passes', displayName: 'Passes', type: 'int', defaultValue: 0},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                passes,
            } = { ...config }

            if (passes > 0) {
                let srcId = renderer.getCurrentBufferId('brightness')
                let dstId = renderer.lockBuffer('brightness')
                for (let pass = 0; pass < passes; ++pass) {
                    const src = renderer.getBufferFromId('brightness', srcId)
                    const dst = renderer.getBufferFromId('brightness', dstId)
                    for (let y = 1; y < src.height-1; ++y) {
                        let i = src.width * y + 1
                        for (let x = 1; x < src.width-1; ++x) {
                            const v = (src.data[i] + src.data[i-1] + src.data[i+1] + src.data[i-src.width] + src.data[i+src.width]) / 5
                            dst.data[i++] = v
                        }
                    }
                    const swap = srcId
                    srcId = dstId
                    dstId = swap
                }
                renderer.unlockBuffer('brightness', dstId)
                renderer.setCurrentBufferId('brightness', srcId)
            }
        }
    }
}
