'use strict'

entityRegistry['module']['bling'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'blingColor', displayName: 'Bling Color', type: 'int', defaultValue: 1},
        { paramName: 'blurPasses', displayName: 'Blur Passes', type: 'int', defaultValue: 1, uiOptions: { min: 1 }},
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 2},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                blingColor,
                blurPasses,
                strength,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const colorBufferData = colorBuffer.data
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const brightnessBufferData = brightnessBuffer.data

            // DOF
            let dst2Id = renderer.lockBuffer('brightness')
            let dst1Id = renderer.lockBuffer('brightness')
            let dst1 = renderer.getBufferFromId('brightness', dst1Id).data
            let dst2 = renderer.getBufferFromId('brightness', dst2Id).data
            let writeIndex = 0
            for (let y = 0; y < 480; y+=2) {
                for (let x = 0; x < 640; x+=2) {
                    const index = (y+1)*640 + x+1
                    if (colorBufferData[index] === blingColor) {
                        dst1[writeIndex++] = strength
                    } else {
                        dst1[writeIndex++] = 0
                    }
                }
            }

            for (let i = 0; i < blurPasses; ++i) {
                {
                    let index = 0
                    for (let x = 0; x < 320; ++x) dst2[index] = dst1[index++]
                    for (let y = 1; y < 240-1; ++y) {
                        dst2[index] = dst1[index++]
                        for (let x = 1; x < 320-1; ++x) {
                            const v = (dst1[index-319] +
                                       dst1[index-321] +
                                       dst1[index] +
                                       dst1[index+319] +
                                       dst1[index+321]) / 5
                            dst2[index++] = v
                        }
                        dst2[index] = dst1[index++]
                    }
                    for (let x = 0; x < 320; ++x) dst2[index] = dst1[index++]
                }
                //[dst1, dst2] = [dst2, dst1]
                const swap=dst1; dst1=dst2; dst2=swap
                const swapId=dst1Id; dst1Id=dst2Id; dst2Id=swapId
            }

            const src = dst1
            const dst = brightnessBufferData
            let index = 0
            for (let y = 0; y < 480; ++y) {
                for (let x = 0; x < 640; ++x) {
                    const v = src[(y>>1)*320+(x>>1)]
                    if (v) {
                        dst[index] += v
                    }
                    index++
                }
            }

            renderer.unlockBuffer('brightness', dst2Id)
            renderer.unlockBuffer('brightness', dst1Id)
        }
    }
}
