#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _88;

layout(set = 1, binding = 2) uniform sampler2D s_NoiseRGBA;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

float _noise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return mix(rg.x, rg.y, f.z);
}

void main()
{
    float y = vTexcoord0.y;
    float x = vTexcoord0.x + (_88.params.param2 * 0.00999999977648258209228515625);
    vec3 param = vec3(x, y, 0.231000006198883056640625) * _88.params.param1;
    float v1 = 0.5 * _noise(param);
    vec3 param_1 = (vec3(x, y, 0.231000006198883056640625) * _88.params.param1) * 2.0099999904632568359375;
    float v2 = 0.25 * _noise(param_1);
    vec3 param_2 = (vec3(x, y, 0.231000006198883056640625) * _88.params.param1) * 4.21000003814697265625;
    float v3 = 0.125 * _noise(param_2);
    vec3 param_3 = (vec3(x, y, 0.231000006198883056640625) * _88.params.param1) * 8.0123996734619140625;
    float v4 = 0.07500000298023223876953125 * _noise(param_3);
    float v = ((v1 + v2) + v3) + v4;
    v = smoothstep(0.300000011920928955078125, 0.699999988079071044921875, v);
    outColor.x = v;
    vec3 param_4 = vec3(x, y, 1.4309999942779541015625) * _88.params.param1;
    v1 = 0.5 * _noise(param_4);
    vec3 param_5 = (vec3(x, y, 1.33099997043609619140625) * _88.params.param1) * 2.0099999904632568359375;
    v2 = 0.25 * _noise(param_5);
    vec3 param_6 = (vec3(x, y, 1.631000041961669921875) * _88.params.param1) * 4.21000003814697265625;
    v3 = 0.125 * _noise(param_6);
    vec3 param_7 = (vec3(x, y, 1.131000041961669921875) * _88.params.param1) * 8.0123996734619140625;
    v4 = 0.07500000298023223876953125 * _noise(param_7);
    v = ((v1 + v2) + v3) + v4;
    v = smoothstep(0.300000011920928955078125, 0.699999988079071044921875, v);
    outColor.y = v;
    vec3 param_8 = vec3(x, y, 2.131000041961669921875) * _88.params.param1;
    v1 = 0.5 * _noise(param_8);
    vec3 param_9 = (vec3(x, y, 2.23099994659423828125) * _88.params.param1) * 2.0099999904632568359375;
    v2 = 0.25 * _noise(param_9);
    vec3 param_10 = (vec3(x, y, 2.3310000896453857421875) * _88.params.param1) * 4.21000003814697265625;
    v3 = 0.125 * _noise(param_10);
    vec3 param_11 = (vec3(x, y, 2.4309999942779541015625) * _88.params.param1) * 8.0123996734619140625;
    v4 = 0.07500000298023223876953125 * _noise(param_11);
    v = ((v1 + v2) + v3) + v4;
    v = smoothstep(0.300000011920928955078125, 0.699999988079071044921875, v);
    outColor.z = v;
    outColor.w = 1.0;
}

 