#version 450

struct VertexInput
{
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _358
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 7, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _179;

layout(set = 0, binding = 8, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _226;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _237;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _320;

layout(set = 0, binding = 9, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _369;

layout(location = 0) out uint instanceID;
layout(location = 1) out _358 vtx_output;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

void main()
{
    uint param = uint(gl_VertexIndex);
    VertexInput vtx_input;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_179.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_179.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = uint(gl_VertexIndex);
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_179.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    if (_226.instance_params.stride > 0)
    {
        vec4 inst_m0 = _237.instance_transform[(gl_InstanceIndex * _226.instance_params.stride) + 0];
        vec4 inst_m1 = _237.instance_transform[(gl_InstanceIndex * _226.instance_params.stride) + 1];
        vec4 inst_m2 = _237.instance_transform[(gl_InstanceIndex * _226.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_4 = vtx_input.norm;
        mat4 param_5 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_4, param_5));
        vec2 _327 = unpackHalf2x16(_320.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _327.x;
        inst_c.y = _327.y;
        vec2 _337 = unpackHalf2x16(_320.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _337.x;
        inst_c.w = _337.y;
        vec4 _343 = vtx_input.color;
        vec3 _347 = _343.xyz * inst_c.xyz;
        vtx_input.color.x = _347.x;
        vtx_input.color.y = _347.y;
        vtx_input.color.z = _347.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vtx_output.vLocalPos = vtx_input.pos;
    vec3 param_6 = vtx_input.pos;
    mat4 param_7 = _369.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_6, param_7);
    vec3 param_8 = vtx_input.norm;
    mat4 param_9 = _369.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vec3(vector_transform_by_mat33(param_8, param_9));
    vec3 param_10 = vPosModel;
    mat4 param_11 = _369.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_10, param_11);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vWorldPos = vPosModel;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_369.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_369.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_369.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vec3(normalize(vtx_output.vNorm));
    vtx_output.vNorm = vec3(vtx_input.norm);
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    gl_Position = _369.transform_params.mProjection * vec4(vtx_output.vCoords, 1.0);
}

 