#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _21;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    float p = ((_21.params.param2 - 50.0) * 2.0) + 50.0;
    float x = ((1.0 - vTexcoord0.x) - 1.0) + (min(p, 50.0) / 20.0);
    if (_21.params.param2 >= 50.0)
    {
        x = (2.0 - (1.0 - vTexcoord0.x)) - ((p - 50.0) / 20.0);
    }
    if (vTexcoord0.y > (_21.params.param1 / 100.0))
    {
        x += 0.699999988079071044921875;
    }
    x = clamp(x, 0.0, 1.0);
    base_color = vec4(x);
    outColor = base_color;
}

 