#version 450
#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
#extension GL_EXT_shader_16bit_storage : require
#extension GL_KHR_shader_subgroup_ballot : require
layout(early_fragment_tests) in;

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
};

struct ray_state
{
    vec3 color;
    vec3 normal;
    vec3 dir;
    vec3 origin;
    float transparency;
    bool running;
    int16_t bounces;
    int16_t material;
    int16_t tests;
    bool hit;
    bool left;
    uint active_threads_factor;
    uint active_threads_samples;
};

struct dda
{
    bool is_high;
    vec3 res;
    vec3 res_rcp;
    vec3 ro;
    vec3 ird;
    vec3 delta;
    vec3 t_max;
    float prev_next_t;
    vec3 prev_t_max;
    float next_t;
    vec3 pf;
    float tmin;
    float tmax;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct RTSetup
{
    mat4 mat_projection;
    mat4 mat_model;
    vec3 camera_position;
    int screen_sampling_scale;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float trace_range;
    float roughness_clamp;
    int lights_num;
};

struct link_list_node
{
    uint value;
    uint next;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct _2930
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

layout(set = 1, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _555;

layout(set = 1, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _627;

layout(set = 1, binding = 7, std140) uniform RTSetupBuffer
{
    layout(row_major) RTSetup rt_setup;
} _976;

layout(set = 1, binding = 3, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _1003;

layout(set = 1, binding = 4, std430) readonly buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _1374;

layout(set = 1, binding = 5, std430) readonly buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    link_list_node node_buffer[];
} in_faces_list_data;

layout(set = 1, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 9, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 6, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 10, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _2927;

layout(set = 1, binding = 15) uniform samplerCube s_reflection;
layout(set = 1, binding = 16) uniform sampler2D material_textures[64];
layout(set = 1, binding = 80) uniform usampler3D s_grid_marker;
layout(set = 1, binding = 12, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 81) uniform sampler2D sTextureDepth;
layout(set = 1, binding = 13, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 1, binding = 14, rgba16f) uniform readonly image2D imAlbedo;

layout(location = 1) in _2930 vtx_input;
layout(location = 0) out vec4 outFresnelReflection;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

float linearizeDepth(float d)
{
    return _976.rt_setup.near_far_plane.z / ((_976.rt_setup.near_far_plane.y + _976.rt_setup.near_far_plane.x) - (d * _976.rt_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

void build_dda(inout dda dda_1, vec3 ro, vec3 rd, float tmin, float tmax, bool restart)
{
    if (!restart)
    {
        dda_1.res = vec3(in_bbox_data.grid_size_raytrace.xyz);
        dda_1.res_rcp = vec3(1.0) / dda_1.res;
        dda_1.is_high = false;
    }
    dda_1.ro = ro - in_bbox_data.bbox_raytrace_min.xyz;
    dda_1.ird = vec3(1.0) / rd;
    vec3 s = step(vec3(0.0), rd);
    dda_1.delta = (((s * 2.0) - vec3(1.0)) * dda_1.res) * dda_1.ird;
    dda_1.t_max = (((floor(dda_1.ro * dda_1.res_rcp) + s) * dda_1.res) - dda_1.ro) * dda_1.ird;
    dda_1.prev_next_t = 0.0;
    dda_1.prev_t_max = dda_1.t_max;
    if (!restart)
    {
        dda_1.pf = dda_1.ro;
    }
    dda_1.tmin = tmin;
    dda_1.tmax = tmax;
}

float get_current_intersection_dda(inout dda dda_1, ray_state state)
{
    dda_1.next_t = min(dda_1.t_max.x, min(dda_1.t_max.y, dda_1.t_max.z));
    dda_1.pf = dda_1.ro + ((state.dir * (dda_1.prev_next_t + dda_1.next_t)) * 0.5);
    return dda_1.next_t;
}

i16vec3 grd_icell_dda(dda dda_1)
{
    i16vec3 p = i16vec3(floor(dda_1.pf / vec3(in_bbox_data.grid_size_raytrace.xyz)));
    return p;
}

bool is_pos_inside_grid(i16vec3 icell)
{
    int16_t icell_mask = (icell.x | icell.y) | icell.z;
    if ((int(icell_mask) & (-256)) == 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

bool is_inside_grid_dda(inout dda dda_1)
{
    dda param = dda_1;
    dda_1 = param;
    i16vec3 p = grd_icell_dda(param);
    i16vec3 param_1 = p;
    return is_pos_inside_grid(param_1);
}

void rt_pack_grid_marker_to_uint(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

uint rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return uint(int((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u));
}

bool is_high_level_empty_dda(inout dda dda_1)
{
    dda param = dda_1;
    dda_1 = param;
    ivec3 p = ivec3(grd_icell_dda(param));
    ivec3 param_1 = p;
    return (rt_read_grid_marker_high_res(s_grid_marker, param_1) == 0u) ? true : false;
}

uint ballot_count(bool v)
{
    uvec4 ballot = subgroupBallot(v);
    uint cnt = uint(bitCount(ballot.x));
    cnt += uint(bitCount(ballot.y));
    return cnt;
}

float dda_scale_grid_res(inout dda dda_1, ray_state state, float scale)
{
    dda_1.res *= scale;
    dda_1.res_rcp *= (1.0 / scale);
    dda_1.delta *= scale;
    float prev_t_min = min(dda_1.prev_t_max.x, min(dda_1.prev_t_max.y, dda_1.prev_t_max.z));
    float blend_x = float(prev_t_min == dda_1.prev_t_max.x);
    float blend_y = float(prev_t_min == dda_1.prev_t_max.y);
    float blend_z = float(prev_t_min == dda_1.prev_t_max.z);
    vec3 next_ro = dda_1.ro + (state.dir * prev_t_min);
    float dt_x_1 = dda_1.delta.x;
    float dt_y_1 = dda_1.delta.y;
    float dt_z_1 = dda_1.delta.z;
    vec3 s = step(vec3(0.0), state.dir);
    float dt_x_2 = (((floor(next_ro.x * dda_1.res_rcp.x) + s.x) * dda_1.res.x) - next_ro.x) * dda_1.ird.x;
    float dt_y_2 = (((floor(next_ro.y * dda_1.res_rcp.y) + s.y) * dda_1.res.y) - next_ro.y) * dda_1.ird.y;
    float dt_z_2 = (((floor(next_ro.z * dda_1.res_rcp.z) + s.z) * dda_1.res.z) - next_ro.z) * dda_1.ird.z;
    dda_1.t_max.x = mix(dt_x_2, dt_x_1, blend_x);
    dda_1.t_max.y = mix(dt_y_2, dt_y_1, blend_y);
    dda_1.t_max.z = mix(dt_z_2, dt_z_1, blend_z);
    dda_1.t_max += vec3(prev_t_min);
    dda_1.next_t = min(dda_1.t_max.x, min(dda_1.t_max.y, dda_1.t_max.z));
    if (scale < 1.0)
    {
        dda_1.pf = dda_1.ro + ((state.dir * (dda_1.prev_next_t + dda_1.next_t)) * 0.5);
    }
    return dda_1.next_t;
}

uint rt_read_grid_marker_low_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return uint(int((texelFetch(markers, pos_packed, 2).x & uint(1 << int(bit))) != 0u));
}

int fetch_grid_marker_for_cell(ivec3 icell, int mip)
{
    if (mip == 0)
    {
        ivec3 param = icell;
        return int(rt_read_grid_marker_high_res(s_grid_marker, param));
    }
    else
    {
        ivec3 param_1 = icell >> ivec3(2);
        return int(rt_read_grid_marker_low_res(s_grid_marker, param_1));
    }
}

void step_dda(inout dda dda_1)
{
    dda_1.prev_next_t = dda_1.next_t;
    vec3 cmp = step(dda_1.t_max, dda_1.t_max.yxy) * step(dda_1.t_max, dda_1.t_max.zzx);
    dda_1.prev_t_max = dda_1.t_max;
    dda_1.t_max += (cmp * dda_1.delta);
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_555.in_vtx_data[coord_offset + 0u], _555.in_vtx_data[coord_offset + 1u], _555.in_vtx_data[coord_offset + 2u]);
    return p;
}

void build_triangle(uint idx, out vec3 p0, out vec3 p1, out vec3 p2)
{
    uint i0 = _1003.transformed_data_indices[(idx * 3u) + 0u];
    uint i1 = _1003.transformed_data_indices[(idx * 3u) + 1u];
    uint i2 = _1003.transformed_data_indices[(idx * 3u) + 2u];
    uint param = i0;
    p0 = rt_get_vertex(param);
    uint param_1 = i1;
    p1 = rt_get_vertex(param_1);
    uint param_2 = i2;
    p2 = rt_get_vertex(param_2);
}

intersection intersectTriangle3(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        return it;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        return it;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _1298 = v < 0.0;
    bool _1306;
    if (!_1298)
    {
        _1306 = (u + v) > 1.0;
    }
    else
    {
        _1306 = _1298;
    }
    if (_1306)
    {
        return it;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = vec3(normalize(cross(e2, e1)));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        t = dot(p0l0, vec3(it.normal)) / denom;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

void findClosestBucket2(uint list_index, int bucket_size, vec3 origin, vec3 dir, int skip_fi, float max_t, out int closest_fi, inout float closest_it, inout vec3 closest_norm, inout vec2 closest_bc)
{
    closest_fi = -1;
    closest_it = max_t;
    uint idx = _1374.in_faces_list_tails_data[list_index];
    vec3 param_1;
    vec3 param_2;
    vec3 param_3;
    while (idx != 4294967295u)
    {
        int fi = int(in_faces_list_data.node_buffer[idx].value);
        idx = in_faces_list_data.node_buffer[idx].next;
        if (fi == skip_fi)
        {
            continue;
        }
        uint param = uint(fi);
        build_triangle(param, param_1, param_2, param_3);
        vec3 p0 = param_1;
        vec3 p1 = param_2;
        vec3 p2 = param_3;
        vec3 param_4 = origin;
        vec3 param_5 = dir;
        vec3 param_6 = p2;
        vec3 param_7 = p1;
        vec3 param_8 = p0;
        intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
        bool _1432 = it1.t >= 0.0;
        bool _1439;
        if (_1432)
        {
            _1439 = it1.t <= closest_it;
        }
        else
        {
            _1439 = _1432;
        }
        if (_1439)
        {
            closest_fi = fi;
            closest_it = it1.t;
            closest_norm = it1.normal;
            closest_bc = it1.bc;
        }
    }
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_627.transformed_data_faces[idx].material_idx);
    return p;
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint i0 = _1003.transformed_data_indices[(idx * 3) + 0];
    uint i1 = _1003.transformed_data_indices[(idx * 3) + 1];
    uint i2 = _1003.transformed_data_indices[(idx * 3) + 2];
    uint param = i0;
    vec3 a = rt_get_vertex(param);
    uint param_1 = i1;
    vec3 b = rt_get_vertex(param_1);
    uint param_2 = i2;
    vec3 c = rt_get_vertex(param_2);
    vec3 param_3 = p;
    vec3 param_4 = a;
    vec3 param_5 = b;
    vec3 param_6 = c;
    return vec2(rt_barycentric_yz(param_3, param_4, param_5, param_6));
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _555.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _555.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint i0 = _1003.transformed_data_indices[(fi * 3) + 0];
    uint i1 = _1003.transformed_data_indices[(fi * 3) + 1];
    uint i2 = _1003.transformed_data_indices[(fi * 3) + 2];
    uint param = i0;
    vec3 n0 = vec3(rt_get_vertex_normal(param));
    uint param_1 = i1;
    vec3 n1 = vec3(rt_get_vertex_normal(param_1));
    uint param_2 = i2;
    vec3 n2 = vec3(rt_get_vertex_normal(param_2));
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return vec3(normalize(smooth_normal * ((dot(smooth_normal, ref_normal) < 0.0) ? (-1.0) : 1.0)));
}

vec2 rt_get_vertex_uv0(uint idx)
{
    uint uv0_offset = (idx * 2u) + 50000000u;
    vec2 p = vec2(_555.in_vtx_data[uv0_offset + 0u], _555.in_vtx_data[uv0_offset + 1u]);
    return p;
}

vec2 interpolate_uv_from_bc_yz(int fi, vec2 bc_yz)
{
    uint i0 = _1003.transformed_data_indices[(fi * 3) + 0];
    uint i1 = _1003.transformed_data_indices[(fi * 3) + 1];
    uint i2 = _1003.transformed_data_indices[(fi * 3) + 2];
    uint param = i0;
    vec2 uv0 = vec2(rt_get_vertex_uv0(param));
    uint param_1 = i1;
    vec2 uv1 = vec2(rt_get_vertex_uv0(param_1));
    uint param_2 = i2;
    vec2 uv2 = vec2(rt_get_vertex_uv0(param_2));
    vec2 uv = ((uv0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (uv1 * bc_yz.x)) + (uv2 * bc_yz.y);
    return uv;
}

vec4 evaluate_albedo(int16_t materialIndex, int fi, vec2 bc)
{
    vec4 c = vec4(1.0);
    if (materials.material_properties[materialIndex].albedo_sampler >= 0)
    {
        int param = fi;
        vec2 param_1 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param, param_1);
        c = vec4(texture(material_textures[materials.material_properties[materialIndex].albedo_sampler], uv));
    }
    return c;
}

vec3 evaluate_emissive(int16_t materialIndex, int fi, vec2 bc)
{
    vec3 c = vec3(1.0);
    if (materials.material_properties[materialIndex].emissive_sampler >= 0)
    {
        int param = fi;
        vec2 param_1 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param, param_1);
        c = vec3(texture(material_textures[materials.material_properties[materialIndex].emissive_sampler], uv).xyz);
    }
    return c;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _729 = falloff > cutoff;
    bool _736;
    if (_729)
    {
        _736 = light_distance < light.range;
    }
    else
    {
        _736 = _729;
    }
    if (_736)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

AngularInfo getAngularInfo(vec3 pointToLight, vec3 normal, vec3 view)
{
    vec3 n = normalize(normal);
    vec3 v = normalize(view);
    vec3 l = normalize(pointToLight);
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 pointToLight, MaterialInfo materialInfo, vec3 normal, vec3 view)
{
    vec3 param = pointToLight;
    vec3 param_1 = normal;
    vec3 param_2 = view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _920 = angularInfo.NdotL > 0.0;
    bool _927;
    if (!_920)
    {
        _927 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _927 = _920;
    }
    if (_927)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

vec3 evaluate_lighting(vec3 p, vec3 o, vec3 n, int material, vec3 albedo, vec3 emissive)
{
    vec3 c = vec3(0.0);
    vec3 world = p;
    vec3 view = normalize(o - p);
    vec3 f0 = vec3(0.039999999105930328369140625);
    float metallic = materials.material_properties[material].metalness;
    vec3 baseColor = vec3(clamp(materials.material_properties[material].diffuse * albedo, vec3(0.0), vec3(1.0)));
    vec3 diffuseColor = (baseColor * (vec3(1.0) - f0)) * (1.0 - metallic);
    vec3 specularColor = vec3(mix(f0, baseColor, vec3(metallic)));
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    float roughness = materials.material_properties[material].roughness;
    float alphaRoughness = roughness * roughness;
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    for (int light_idx = 0; light_idx < _976.rt_setup.lights_num; light_idx++)
    {
        LightProperties _1581;
        _1581.diffuse = lights.light_properties[light_idx].diffuse;
        _1581.direction = lights.light_properties[light_idx].direction;
        _1581.position = lights.light_properties[light_idx].position;
        _1581.up = lights.light_properties[light_idx].up;
        _1581.right = lights.light_properties[light_idx].right;
        _1581.dimensions = lights.light_properties[light_idx].dimensions;
        _1581._pad1 = lights.light_properties[light_idx]._pad1;
        _1581.intensity = lights.light_properties[light_idx].intensity;
        _1581.range = lights.light_properties[light_idx].range;
        _1581.cutoff = lights.light_properties[light_idx].cutoff;
        _1581.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _1581.is_area = lights.light_properties[light_idx].is_area;
        _1581.type = lights.light_properties[light_idx].type;
        _1581.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _1581.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _1581.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _1581.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _1581.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _1581.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _1581.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _1581.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _1581.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _1581.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _1581.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _1581.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _1581.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _1581.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _1581.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _1581.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _1581.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _1581.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _1581.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _1581;
        if ((light.type & 3) != 0)
        {
            vec3 pointToLight = light.position.xyz - world;
            if ((light.type & 1) != 0)
            {
                pointToLight = -light.direction.xyz;
            }
            float NdotL = dot(vec3(n), normalize(pointToLight));
            vec3 lighting = vec3(0.0);
            if (NdotL > 0.0)
            {
                float attenuation = 1.0;
                if ((light.type & 2) != 0)
                {
                    LightProperties param = light;
                    vec3 param_1 = world;
                    attenuation = light_calculate_spot_attenuation(param, param_1);
                }
                if (attenuation > 0.0)
                {
                    vec3 param_2 = pointToLight;
                    MaterialInfo param_3 = materialInfo;
                    vec3 param_4 = n;
                    vec3 param_5 = view;
                    lighting = (getPointShade(param_2, param_3, param_4, param_5) * (light.intensity * attenuation)) * light.diffuse.xyz;
                    c += lighting;
                }
            }
        }
    }
    c += (emissive * materials.material_properties[material].emissive_factor);
    return vec3(c);
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(vec3(v), n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

vec3 yCgCo2rgb(vec3 ycc)
{
    float R = (ycc.x - ycc.y) + ycc.z;
    float G = ycc.x + ycc.y;
    float B = (ycc.x - ycc.y) - ycc.z;
    return vec3(R, G, B);
}

vec3 spectrum_offset_ycgco(float t)
{
    vec3 ygo = vec3(1.0, 0.0, (-1.25) * t);
    vec3 param = ygo;
    return yCgCo2rgb(param);
}

void evaluate_material(inout ray_state state, vec3 prev_state_origin, int16_t hit_material, int hit_face, vec2 bc)
{
    int16_t param = hit_material;
    int param_1 = hit_face;
    vec2 param_2 = bc;
    vec4 hit_albedo = evaluate_albedo(param, param_1, param_2);
    int16_t param_3 = hit_material;
    int param_4 = hit_face;
    vec2 param_5 = bc;
    vec3 hit_emissive = evaluate_emissive(param_3, param_4, param_5) * vec3(materials.material_properties[hit_material].emissive);
    vec3 param_6 = state.origin;
    vec3 param_7 = prev_state_origin;
    vec3 param_8 = state.normal;
    int param_9 = int(hit_material);
    vec3 param_10 = hit_albedo.xyz;
    vec3 param_11 = hit_emissive;
    vec3 hit_color = evaluate_lighting(param_6, param_7, param_8, param_9, param_10, param_11);
    bool hit_material_reflective = materials.material_properties[hit_material].roughness < 1.0;
    if ((materials.material_properties[state.material].flags & 32u) == 0u)
    {
        hit_color = vec3(mix(state.color * hit_color, state.color, vec3(materials.material_properties[state.material].roughness)));
        state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
    }
    else
    {
        bool _1866 = hit_material_reflective == false;
        bool _1874;
        if (_1866)
        {
            _1874 = (materials.material_properties[hit_material].flags & 32u) == 0u;
        }
        else
        {
            _1874 = _1866;
        }
        if (_1874)
        {
            state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            state.running = false;
            state.hit = true;
        }
        else
        {
            bool _1894 = hit_material_reflective == true;
            bool _1902;
            if (_1894)
            {
                _1902 = (materials.material_properties[hit_material].flags & 32u) == 0u;
            }
            else
            {
                _1902 = _1894;
            }
            if (_1902)
            {
                state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            }
            else
            {
                float hit_transparency = 1.0 - ((1.0 - materials.material_properties[hit_material].transparency) * hit_albedo.w);
                state.transparency *= hit_transparency;
                state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            }
        }
    }
    if ((materials.material_properties[hit_material].flags & 32u) == 0u)
    {
        state.dir = reflect(state.dir, vec3(state.normal));
    }
    else
    {
        vec3 param_12 = state.dir;
        vec3 param_13 = state.normal;
        vec3 refracted_dir = glass_refract(param_12, param_13);
        float angle = dot(refracted_dir, state.dir);
        float threshold = 0.0;
        angle = 1.0 - abs(angle);
        float factor = clamp(angle * 5.0, 0.0, 1.0);
        angle *= 10.5;
        float param_14 = angle;
        state.color = mix(state.color, spectrum_offset_ycgco(param_14), vec3(factor));
        state.dir = refracted_dir;
    }
    bool _2001 = (materials.material_properties[hit_material].flags & 1u) == 0u;
    bool _2009;
    if (_2001)
    {
        _2009 = (materials.material_properties[hit_material].flags & 32u) == 0u;
    }
    else
    {
        _2009 = _2001;
    }
    if (_2009)
    {
        state.running = false;
        state.hit = true;
    }
    state.material = hit_material;
}

bool dda_is_abort(dda dda_1)
{
    return dda_1.next_t >= dda_1.tmax;
}

int findClosestDDAMultibounce(inout ray_state state, inout int skip_fi, inout int closest_fi, inout float closest_it, int max_bounces)
{
    dda dda_1;
    dda param = dda_1;
    vec3 param_1 = state.origin;
    vec3 param_2 = state.dir;
    float param_3 = 0.0;
    float param_4 = _976.rt_setup.trace_range;
    bool param_5 = false;
    build_dda(param, param_1, param_2, param_3, param_4, param_5);
    dda_1 = param;
    closest_fi = -1;
    closest_it = 1000000.0;
    bool inside = false;
    bool prev_inside = inside;
    int max_iter = 1024;
    int param_43;
    float param_44;
    vec3 param_45;
    vec2 param_46;
    while (max_iter >= 0)
    {
        bool hit = false;
        max_iter--;
        state.tests += 1s;
        if (state.running == false)
        {
            break;
        }
        dda param_6 = dda_1;
        ray_state param_7 = state;
        float _2470 = get_current_intersection_dda(param_6, param_7);
        dda_1 = param_6;
        float rt = _2470;
        prev_inside = prev_inside || inside;
        dda param_8 = dda_1;
        bool _2477 = is_inside_grid_dda(param_8);
        dda_1 = param_8;
        inside = _2477;
        if (false && (max_bounces > 1))
        {
            bool _2486 = inside == false;
            bool _2505;
            if (!_2486)
            {
                bool _2491 = inside == true;
                bool _2497;
                if (_2491)
                {
                    _2497 = dda_1.is_high == false;
                }
                else
                {
                    _2497 = _2491;
                }
                bool _2504;
                if (_2497)
                {
                    dda param_9 = dda_1;
                    bool _2502 = is_high_level_empty_dda(param_9);
                    dda_1 = param_9;
                    _2504 = _2502;
                }
                else
                {
                    _2504 = _2497;
                }
                _2505 = _2504;
            }
            else
            {
                _2505 = _2486;
            }
            bool change_to_high = _2505;
            bool _2508 = inside == true;
            bool _2522;
            if (_2508)
            {
                bool _2512 = dda_1.is_high;
                bool _2513 = _2512 == true;
                bool _2521;
                if (_2513)
                {
                    dda param_10 = dda_1;
                    bool _2518 = is_high_level_empty_dda(param_10);
                    dda_1 = param_10;
                    _2521 = _2518 == false;
                }
                else
                {
                    _2521 = _2513;
                }
                _2522 = _2521;
            }
            else
            {
                _2522 = _2508;
            }
            bool change_to_low = _2522;
            bool param_11 = change_to_high;
            uint change_to_high_ballot_cnt = ballot_count(param_11);
            if (change_to_high_ballot_cnt < 16u)
            {
                change_to_high = false;
            }
            if (change_to_high)
            {
                bool param_12 = true;
                state.active_threads_factor += ballot_count(param_12);
                state.active_threads_samples++;
                dda_1.is_high = true;
                float change = 4.0;
                dda param_13 = dda_1;
                ray_state param_14 = state;
                float param_15 = 4.0;
                float _2552 = dda_scale_grid_res(param_13, param_14, param_15);
                dda_1 = param_13;
                rt = _2552;
            }
            else
            {
                if (change_to_low)
                {
                    bool param_16 = true;
                    state.active_threads_factor += ballot_count(param_16);
                    state.active_threads_samples++;
                    dda_1.is_high = false;
                    float change_1 = 0.25;
                    dda param_17 = dda_1;
                    ray_state param_18 = state;
                    float param_19 = 0.25;
                    float _2576 = dda_scale_grid_res(param_17, param_18, param_19);
                    dda_1 = param_17;
                    rt = _2576;
                }
            }
        }
        bool search_bucket = false;
        ivec3 icell = ivec3(0);
        uint icell_idx = 0u;
        int bucket_size = 0;
        if (inside)
        {
            if (dda_1.is_high == false)
            {
                dda param_20 = dda_1;
                dda_1 = param_20;
                icell = ivec3(grd_icell_dda(param_20));
                icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
                ivec3 param_21 = icell;
                int param_22 = 2;
                int bucket_size_4 = fetch_grid_marker_for_cell(param_21, param_22);
                bucket_size = 0;
                if (bucket_size_4 > 0)
                {
                    ivec3 param_23 = icell;
                    int param_24 = 0;
                    bucket_size = fetch_grid_marker_for_cell(param_23, param_24);
                }
                if (bucket_size > 0)
                {
                    search_bucket = true;
                }
            }
        }
        if (true)
        {
            bool _2630 = search_bucket == true;
            bool _2639;
            if (!_2630)
            {
                _2639 = (prev_inside == true) && (inside == false);
            }
            else
            {
                _2639 = _2630;
            }
            bool done_criteria = _2639;
            bool param_25 = done_criteria;
            uint hit_threads = ballot_count(param_25);
            int ii = 0;
            while ((hit_threads < 32u) && (ii < 4))
            {
                if (search_bucket == false)
                {
                    max_iter--;
                    dda param_26 = dda_1;
                    step_dda(param_26);
                    dda_1 = param_26;
                    dda param_27 = dda_1;
                    ray_state param_28 = state;
                    float _2669 = get_current_intersection_dda(param_27, param_28);
                    dda_1 = param_27;
                    rt = _2669;
                    dda param_29 = dda_1;
                    bool _2673 = is_inside_grid_dda(param_29);
                    dda_1 = param_29;
                    inside = _2673;
                    prev_inside = prev_inside || inside;
                    if (inside)
                    {
                        dda param_30 = dda_1;
                        dda_1 = param_30;
                        icell = ivec3(grd_icell_dda(param_30));
                        icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
                        ivec3 param_31 = icell;
                        int param_32 = 2;
                        int bucket_size_4_1 = fetch_grid_marker_for_cell(param_31, param_32);
                        bucket_size = 0;
                        if (bucket_size_4_1 > 0)
                        {
                            ivec3 param_33 = icell;
                            int param_34 = 0;
                            bucket_size = fetch_grid_marker_for_cell(param_33, param_34);
                        }
                        if (bucket_size > 0)
                        {
                            search_bucket = true;
                        }
                    }
                }
                ii++;
                bool _2718 = search_bucket == true;
                bool _2727;
                if (!_2718)
                {
                    _2727 = (prev_inside == true) && (inside == false);
                }
                else
                {
                    _2727 = _2718;
                }
                done_criteria = _2727;
                bool param_35 = done_criteria;
                hit_threads = ballot_count(param_35);
            }
        }
        if (search_bucket)
        {
            bool param_36 = true;
            state.active_threads_factor += ballot_count(param_36);
            state.active_threads_samples++;
            uint param_37 = icell_idx;
            int param_38 = bucket_size;
            vec3 param_39 = state.origin;
            vec3 param_40 = state.dir;
            int param_41 = skip_fi;
            float param_42 = rt;
            findClosestBucket2(param_37, param_38, param_39, param_40, param_41, param_42, param_43, param_44, param_45, param_46);
            closest_fi = param_43;
            closest_it = param_44;
            vec3 closest_normal = param_45;
            vec2 closest_bc = param_46;
            if (closest_fi != (-1))
            {
                state.bounces += 1s;
                state.normal = closest_normal;
                hit = true;
                skip_fi = closest_fi;
                uint param_47 = uint(closest_fi);
                int hit_material = rt_get_triangle_material(param_47);
                bool _2789 = int(state.bounces) >= max_bounces;
                bool _2799;
                if (!_2789)
                {
                    _2799 = (materials.material_properties[hit_material].flags & 2048u) != 0u;
                }
                else
                {
                    _2799 = _2789;
                }
                if (_2799)
                {
                    state.running = false;
                }
                int param_48 = closest_fi;
                vec3 param_49 = state.origin + (state.dir * closest_it);
                vec2 bc = barycentric_for_face_yz(param_48, param_49);
                if ((materials.material_properties[hit_material].flags & 128u) == 0u)
                {
                    int param_50 = closest_fi;
                    vec2 param_51 = bc;
                    vec3 param_52 = state.normal;
                    state.normal = interpolate_normal_from_bc_yz(param_50, param_51, param_52);
                }
                vec3 prev_state_origin = state.origin;
                state.origin += (state.dir * closest_it);
                uint param_53 = uint(closest_fi);
                ray_state param_54 = state;
                vec3 param_55 = prev_state_origin;
                int16_t param_56 = int16_t(rt_get_triangle_material(param_53));
                int param_57 = closest_fi;
                vec2 param_58 = bc;
                evaluate_material(param_54, param_55, param_56, param_57, param_58);
                state = param_54;
                if ((max_bounces > 1) && state.running)
                {
                    dda param_59 = dda_1;
                    vec3 param_60 = state.origin;
                    vec3 param_61 = state.dir;
                    float param_62 = 0.0;
                    float param_63 = _976.rt_setup.trace_range;
                    bool param_64 = true;
                    build_dda(param_59, param_60, param_61, param_62, param_63, param_64);
                    dda_1 = param_59;
                }
            }
        }
        if ((inside == false) && (prev_inside == true))
        {
            state.running = false;
            state.left = true;
        }
        if (!hit)
        {
            dda param_65 = dda_1;
            step_dda(param_65);
            dda_1 = param_65;
            dda param_66 = dda_1;
            if (dda_is_abort(param_66))
            {
                state.running = false;
            }
        }
    }
    return 0;
}

vec4 sample_env_map(vec3 r, float roughness)
{
    vec4 v = textureLod(s_reflection, r, 0.5 + (roughness * 15.0));
    return vec4(max(vec4(0.0), v));
}

void main()
{
    ivec2 scaled_sample_pos = ivec2(gl_FragCoord.xy) * ivec2(_976.rt_setup.screen_sampling_scale);
    ivec2 native_sample_pos = ivec2(gl_FragCoord.xy);
    vec4 color = vec4(1.0);
    vec3 dir = -normalize(_2927.transform_params.vCameraPosition - vtx_input.vWorldPos);
    vec3 origin = _2927.transform_params.vCameraPosition;
    int closest_fi = -1;
    bool have_initial_face_index = false;
    int16_t material = 0s;
    uvec2 param = imageLoad(imMetalnessRoughnessMaterialTags, scaled_sample_pos).xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    float metalness = param_1;
    float roughness = param_2;
    uint materialIndex = param_3;
    if (materialIndex == 1u)
    {
    }
    material = int16_t(uint16_t(materialIndex));
    vec3 view_direction;
    view_direction.x = ((-_976.rt_setup.camera_projection_params.x) * 0.5) + ((_976.rt_setup.camera_projection_params.x * float(scaled_sample_pos.x)) / 1920.0);
    view_direction.y = ((-_976.rt_setup.camera_projection_params.y) * 0.5) + ((_976.rt_setup.camera_projection_params.y * float(scaled_sample_pos.y)) / 1080.0);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float param_4 = texelFetch(sTextureDepth, native_sample_pos, 0).x;
    float depth = linearizeDepth(param_4);
    vec3 param_5 = view_direction;
    float param_6 = depth;
    vec3 view_coords = positionFromDepth(param_5, param_6);
    view_coords = (_976.rt_setup.mat_model * vec4(view_coords, 1.0)).xyz;
    dir = -normalize(_2927.transform_params.vCameraPosition - view_coords);
    float closest_it = length(origin - view_coords);
    uint encoded_normal_material = imageLoad(imNormalMaterial, scaled_sample_pos).x;
    uint param_7 = encoded_normal_material;
    vec3 normal = vec3(normalize(decode_normal(param_7)));
    vec3 worldNorm = normal;
    outFresnelReflection = vec4(0.0);
    origin += (dir * closest_it);
    vec4 albedo_value = imageLoad(imAlbedo, scaled_sample_pos);
    ray_state state;
    state.color = vec3(albedo_value.xyz);
    float _3087;
    if (materials.material_properties[material].transparency == 0.0)
    {
        _3087 = 1.0;
    }
    else
    {
        _3087 = materials.material_properties[material].transparency;
    }
    state.transparency = _3087;
    state.transparency = 1.0 - ((1.0 - state.transparency) * albedo_value.w);
    state.normal = normal;
    state.material = material;
    state.running = true;
    state.dir = dir;
    state.origin = origin;
    state.bounces = 1s;
    state.hit = false;
    state.left = false;
    state.tests = 0s;
    state.active_threads_factor = 0u;
    state.active_threads_samples = 0u;
    bool _3122 = materials.material_properties[material].roughness == 1.0;
    bool _3130;
    if (_3122)
    {
        _3130 = (materials.material_properties[material].flags & 32u) == 0u;
    }
    else
    {
        _3130 = _3122;
    }
    if (_3130)
    {
        dir = reflect(dir, vec3(normal));
        state.hit = true;
    }
    else
    {
        if ((materials.material_properties[material].flags & 32u) != 0u)
        {
            float fresnel = pow(1.0 - max(0.0, dot(vec3(worldNorm), normalize(_2927.transform_params.vCameraPosition - view_coords))), 4.0);
            vec3 glass_reflection = vec3(0.0);
            if (fresnel > 0.0)
            {
                vec3 ref_dir = reflect(dir, vec3(normal));
                state.dir = ref_dir;
                if (!have_initial_face_index)
                {
                    state.origin += (state.dir * 7.5);
                }
                ray_state param_8 = state;
                int param_9 = closest_fi;
                int param_12 = 1;
                int param_10;
                float param_11;
                int _3200 = findClosestDDAMultibounce(param_8, param_9, param_10, param_11, param_12);
                state = param_8;
                int ref_closest_fi = param_10;
                float ref_closest_it = param_11;
                if (ref_closest_fi != (-1))
                {
                    glass_reflection = state.color;
                }
                else
                {
                    vec3 param_13 = normal;
                    float param_14 = materials.material_properties[state.material].roughness;
                    glass_reflection = sample_env_map(param_13, param_14).xyz;
                }
                fresnel = (fresnel - 0.0) / 1.0;
            }
            outFresnelReflection = vec4(glass_reflection, fresnel);
            return;
        }
        return;
    }
    color.x = state.color.x;
    color.y = state.color.y;
    color.z = state.color.z;
}

 