#version 450

struct PostDepthOfFieldParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float focus_point;
    float focus_scale;
    float far_plane;
    int debug_blur_size;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform PostDepthOfFieldParamsBuffer
{
    PostDepthOfFieldParams dof_params;
} _25;

layout(set = 1, binding = 2) uniform sampler2D sDepth;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

float linearizeDepth(float d)
{
    return _25.dof_params.near_far_plane.z / ((_25.dof_params.near_far_plane.y + _25.dof_params.near_far_plane.x) - (d * _25.dof_params.near_far_plane.w));
}

float getBlurSize(float depth, float focusPoint, float focusScale)
{
    float coc = clamp(((1.0 / focusPoint) - (1.0 / depth)) * focusScale, -1.0, 1.0);
    return abs(coc) * 20.0;
}

void main()
{
    float param = texture(sDepth, vTexcoord0).x;
    float depth = linearizeDepth(param);
    float param_1 = depth;
    float param_2 = _25.dof_params.focus_point;
    float param_3 = _25.dof_params.focus_scale;
    float coc = getBlurSize(param_1, param_2, param_3);
    outColor = vec4(coc, depth / _25.dof_params.far_plane, 0.0, 1.0);
}

 