#version 450

struct PostprocessParams
{
    vec2 resolution;
    vec2 inv_resolution;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
    int txt1_flip_y;
    int txt2_flip_y;
    int txt3_flip_y;
    int _pad2;
};

layout(set = 1, binding = 1, std140) uniform PostprocessParamsBuffer
{
    PostprocessParams params;
} _32;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;
layout(set = 1, binding = 3) uniform sampler2D sImage2;
layout(set = 1, binding = 4) uniform sampler2D sImage3;
layout(set = 1, binding = 5) uniform sampler2D sImage1;

layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;

void main()
{
    outColor = texture(s_texture0, vTexcoord0);
    vec2 vTexcoord1 = vTexcoord0;
    vec2 vTexcoord2 = vTexcoord0;
    vec2 vTexcoord3 = vTexcoord0;
    if (_32.params.txt1_flip_y != 0)
    {
        vTexcoord1.y = 1.0 - vTexcoord1.y;
    }
    if (_32.params.txt2_flip_y != 0)
    {
        vTexcoord2.y = 1.0 - vTexcoord2.y;
    }
    if (_32.params.txt3_flip_y != 0)
    {
        vTexcoord3.y = 1.0 - vTexcoord3.y;
    }
    float mask = texture(sImage2, vTexcoord2).x;
    float normal = (texture(sImage3, vTexcoord3).y * 2.0) - 1.0;
    normal = clamp(-normal, 0.0, 1.0);
    normal = pow(normal, 2.0);
    normal = max(0.0, normal - 0.20000000298023223876953125);
    normal = (normal * mask) * _32.params.param1;
    if (mask > 0.0)
    {
        outColor *= _32.params.param2;
    }
    vec4 _123 = outColor;
    vec3 _125 = _123.xyz * ((texture(sImage1, vTexcoord1).xxx * normal) + vec3(1.0));
    outColor.x = _125.x;
    outColor.y = _125.y;
    outColor.z = _125.z;
    vec4 _134 = outColor;
    vec3 _137 = max(_134.xyz, vec3(0.0));
    outColor.x = _137.x;
    outColor.y = _137.y;
    outColor.z = _137.z;
}

 