#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct CompositeParams
{
    vec4 global_ambient_color;
    vec4 global_fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float ssr_scaling_factor;
    float ssr_strength;
    float sso_strength;
    float occlusion_strength;
    float global_illumination_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float taa_blend;
    float taa_gamma;
    int composite_output_mode;
    float raytrace_scaling_factor;
    int transparency_blend_mode;
    float _pad1;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _69;

layout(set = 0, binding = 2, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_setup;
} _189;

layout(set = 0, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 4, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1312;

layout(set = 0, binding = 6) uniform sampler2D sSSR;
layout(set = 0, binding = 7) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 8) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 9) uniform sampler2D sAlbedo;
layout(set = 0, binding = 10) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 11) uniform sampler2D sShadow;
layout(set = 0, binding = 12) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 13) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 14) uniform sampler2D sParticles;
layout(set = 0, binding = 15) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 16) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 17) uniform sampler2D sRaytrace;
layout(set = 0, binding = 18) uniform sampler2D sWireframeColor;
layout(set = 0, binding = 19) uniform sampler2D sWireframeDepth;
layout(set = 0, binding = 5, rgba16f) uniform writeonly image2D imTarget;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _69.dispatch_setup.near_far_plane.z / ((_69.dispatch_setup.near_far_plane.y + _69.dispatch_setup.near_far_plane.x) - (d * _69.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_69.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uvec2 ct, out uint component_tags)
{
    component_tags = ct.x | (ct.y << uint(16));
}

vec4 sample_ssr(inout vec2 p, float depth)
{
    p *= _189.composite_setup.ssr_scaling_factor;
    float s = 0.0;
    vec4 v = vec4(0.0);
    float r = 10.5 * clamp(1.0 / depth, 0.5, 2.0);
    v = textureLod(sSSR, p, 0.0);
    s = v.w;
    vec4 _217 = v;
    vec3 _219 = _217.xyz * s;
    v.x = _219.x;
    v.y = _219.y;
    v.z = _219.z;
    for (int y = -2; y <= 2; y++)
    {
        for (int x = -2; x <= 2; x++)
        {
            if ((x == 0) && (y == 0))
            {
                continue;
            }
            if (s < 1.0)
            {
                ivec2 smpl_pos = ivec2(p * _69.dispatch_setup.resolution) + ivec2(x, y);
                vec3 blue_noise = texelFetch(s_BlueNoise, ivec3(smpl_pos % ivec2(128), 0), 0).xyz;
                vec4 pxl = textureLod(sSSR, vec2(smpl_pos) * _69.dispatch_setup.inv_resolution, 0.0);
                if (pxl.w > s)
                {
                    vec3 _306 = pxl.xyz * pxl.w;
                    v.x = _306.x;
                    v.y = _306.y;
                    v.z = _306.z;
                    s = pxl.w;
                }
            }
        }
    }
    return vec4(v.xyz, s);
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _189.composite_setup.global_fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _189.composite_setup.global_fill_color.xyz) + specular, 1.0);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_69.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_69.dispatch_setup.camera_projection_params.z) + ((_69.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _69.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_69.dispatch_setup.camera_projection_params.w) + ((_69.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _69.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 normal = decode_normal(param);
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _69.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _69.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _69.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        vec4 color_1 = vec4(0.0);
        vec3 _531 = abs(local_normal);
        color_1.x = _531.x;
        color_1.y = _531.y;
        color_1.z = _531.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_189.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _189.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec2 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0).xy;
    float param_6;
    float param_7;
    uint param_8;
    decode_metalness_roughness_material(param_5, param_6, param_7, param_8);
    float metalness = param_6;
    float roughness = param_7;
    uint materialIndex = param_8;
    uvec2 param_9 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0).zw;
    uint param_10;
    decode_component_tags(param_9, param_10);
    uint component_tags = param_10;
    if (is_background == false)
    {
        MaterialPropertiesGPU _618;
        _618.diffuse = materials.material_properties[materialIndex].diffuse;
        _618.transparency = materials.material_properties[materialIndex].transparency;
        _618.emissive = materials.material_properties[materialIndex].emissive;
        _618.roughness = materials.material_properties[materialIndex].roughness;
        _618.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _618.refraction = materials.material_properties[materialIndex].refraction;
        _618.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _618.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _618.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _618.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _618.metalness = materials.material_properties[materialIndex].metalness;
        _618.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _618.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _618.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _618.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _618.flags = materials.material_properties[materialIndex].flags;
        _618._pad0 = materials.material_properties[materialIndex]._pad0;
        _618._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _618;
    }
    vec4 _628 = shadow;
    vec3 _630 = _628.xyz + ((albedo.xyz * voxel_light.xyz) * _189.composite_setup.global_illumination_strength);
    shadow.x = _630.x;
    shadow.y = _630.y;
    shadow.z = _630.z;
    vec4 _643 = shadow;
    vec3 _645 = _643.xyz * (1.0 - (voxel_light.w * _189.composite_setup.occlusion_strength));
    shadow.x = _645.x;
    shadow.y = _645.y;
    shadow.z = _645.z;
    if ((material.flags & 8u) != 0u)
    {
        vec2 param_11 = vec2(pixel_pos) * _69.dispatch_setup.inv_resolution;
        float param_12 = depth;
        vec4 _666 = sample_ssr(param_11, param_12);
        ssr = _666;
        ssr_factor = 1.0;
    }
    vec3 param_13 = world;
    vec3 param_14 = local_normal;
    vec3 param_15 = vec3(0.0);
    vec3 param_16 = vec3(0.0);
    float param_17 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_13, param_14, param_15, param_16, param_17);
    vec4 _683 = shadow;
    vec3 _685 = _683.xyz + fill_color.xyz;
    shadow.x = _685.x;
    shadow.y = _685.y;
    shadow.z = _685.z;
    vec4 _692 = shadow;
    vec3 _695 = _692.xyz * hbao;
    shadow.x = _695.x;
    shadow.y = _695.y;
    shadow.z = _695.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _718 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _189.composite_setup.global_ambient_color.xyz;
        color.x = _718.x;
        color.y = _718.y;
        color.z = _718.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _737 = color;
    vec3 _739 = _737.xyz + (ssr.xyz * 4.0);
    color.x = _739.x;
    color.y = _739.y;
    color.z = _739.z;
    vec4 _748 = color;
    vec3 _751 = _748.xyz + vec3(shadow.w);
    color.x = _751.x;
    color.y = _751.y;
    color.z = _751.z;
    if (_189.composite_setup.composite_output_mode == 0)
    {
        vec4 _772 = color;
        vec3 _774 = _772.xyz * (1.0 - ((voxel_light.w * _189.composite_setup.occlusion_strength) * 0.550000011920928955078125));
        color.x = _774.x;
        color.y = _774.y;
        color.z = _774.z;
        float fog_density = linear_depth;
        if (_189.composite_setup.fog_range > 0.0)
        {
            fog_density /= _189.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _189.composite_setup.fog_height, 0.0, 1.0)) * _189.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _189.composite_setup.fog_color.xyz;
        vec4 _824 = color;
        vec3 _829 = mix(_824.xyz, fog_color, vec3(fog_density));
        color.x = _829.x;
        color.y = _829.y;
        color.z = _829.z;
        vec4 volumetric_fog_color = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
        if (_189.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _849 = volumetric_fog_color;
            vec3 _854 = pow(_849.xyz, vec3(_189.composite_setup.volumetric_fog_intensity));
            volumetric_fog_color.x = _854.x;
            volumetric_fog_color.y = _854.y;
            volumetric_fog_color.z = _854.z;
        }
        float volumetric_fog_blend = volumetric_fog_color.w;
        if (_189.composite_setup.volumetric_fog_strength > 0.0)
        {
            volumetric_fog_blend = exp((-volumetric_fog_color.w) / _189.composite_setup.volumetric_fog_strength);
        }
        else
        {
            volumetric_fog_blend = 0.0;
        }
        vec4 _878 = color;
        vec3 _884 = mix(_878.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _884.x;
        color.y = _884.y;
        color.z = _884.z;
        if (uint(_189.composite_setup.transparency_blend_mode) == 0u)
        {
            vec4 _903 = color;
            vec3 _905 = _903.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _905.x;
            color.y = _905.y;
            color.z = _905.z;
        }
        if (uint(_189.composite_setup.transparency_blend_mode) == 1u)
        {
            vec4 _918 = color;
            vec3 _926 = mix(_918.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _926.x;
            color.y = _926.y;
            color.z = _926.z;
        }
    }
    else
    {
        if (_189.composite_setup.composite_output_mode == 1)
        {
            color.x = albedo.xyz.x;
            color.y = albedo.xyz.y;
            color.z = albedo.xyz.z;
        }
        else
        {
            if (_189.composite_setup.composite_output_mode == 2)
            {
                vec3 _956 = (normal * 0.5) + vec3(0.5);
                color.x = _956.x;
                color.y = _956.y;
                color.z = _956.z;
            }
            else
            {
                if (_189.composite_setup.composite_output_mode == 3)
                {
                    vec3 _970 = vec3(roughness);
                    color.x = _970.x;
                    color.y = _970.y;
                    color.z = _970.z;
                }
                else
                {
                    if (_189.composite_setup.composite_output_mode == 4)
                    {
                        vec3 _988 = texelFetch(sShadow, ivec2(pixel_pos), 0).xyz;
                        color.x = _988.x;
                        color.y = _988.y;
                        color.z = _988.z;
                    }
                    else
                    {
                        if (_189.composite_setup.composite_output_mode == 6)
                        {
                            vec3 _1015 = max(texelFetch(sShadow, ivec2(pixel_pos), 0).xyz, (albedo.xyz * voxel_light.xyz) * _189.composite_setup.global_illumination_strength);
                            color.x = _1015.x;
                            color.y = _1015.y;
                            color.z = _1015.z;
                        }
                        else
                        {
                            if (_189.composite_setup.composite_output_mode == 5)
                            {
                                vec3 _1032 = voxel_light.xyz * _189.composite_setup.global_illumination_strength;
                                color.x = _1032.x;
                                color.y = _1032.y;
                                color.z = _1032.z;
                            }
                            else
                            {
                                if (_189.composite_setup.composite_output_mode == 7)
                                {
                                    vec3 _1052 = vec3(1.0 - clamp(voxel_light.w * _189.composite_setup.occlusion_strength, 0.0, 1.0));
                                    color.x = _1052.x;
                                    color.y = _1052.y;
                                    color.z = _1052.z;
                                }
                                else
                                {
                                    if (_189.composite_setup.composite_output_mode == 8)
                                    {
                                        vec3 _1067 = vec3(float(materialIndex));
                                        color.x = _1067.x;
                                        color.y = _1067.y;
                                        color.z = _1067.z;
                                    }
                                    else
                                    {
                                        if (_189.composite_setup.composite_output_mode == 9)
                                        {
                                            if ((material.flags & 3u) != 0u)
                                            {
                                                color.x = 1.0;
                                                color.y = 0.0;
                                                color.z = 0.0;
                                            }
                                        }
                                        else
                                        {
                                            if (_189.composite_setup.composite_output_mode == 10)
                                            {
                                                vec3 _1109 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _189.composite_setup.raytrace_scaling_factor), 0).xyz;
                                                color.x = _1109.x;
                                                color.y = _1109.y;
                                                color.z = _1109.z;
                                            }
                                            else
                                            {
                                                if (_189.composite_setup.composite_output_mode == 11)
                                                {
                                                    vec3 _1131 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _189.composite_setup.raytrace_scaling_factor), 0).www;
                                                    color.x = _1131.x;
                                                    color.y = _1131.y;
                                                    color.z = _1131.z;
                                                }
                                                else
                                                {
                                                    if (_189.composite_setup.composite_output_mode == 12)
                                                    {
                                                        vec4 f = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
                                                        float blend = exp((-f.w) / _189.composite_setup.volumetric_fog_strength);
                                                        color.x = f.xyz.x;
                                                        color.y = f.xyz.y;
                                                        color.z = f.xyz.z;
                                                    }
                                                    else
                                                    {
                                                        if (_189.composite_setup.composite_output_mode == 13)
                                                        {
                                                            vec3 _1175 = abs(particles.xyz);
                                                            color.x = _1175.x;
                                                            color.y = _1175.y;
                                                            color.z = _1175.z;
                                                        }
                                                        else
                                                        {
                                                            if (_189.composite_setup.composite_output_mode == 14)
                                                            {
                                                                vec3 _1194 = vec3(fract(float(component_tags) / 16.0));
                                                                color.x = _1194.x;
                                                                color.y = _1194.y;
                                                                color.z = _1194.z;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (true)
    {
        int search_dist = 1;
        vec3 wc = texelFetch(sWireframeColor, ivec2(pixel_pos), 0).xyz;
        float wd = texelFetch(sWireframeDepth, ivec2(pixel_pos), 0).x;
        int _1222 = -search_dist;
        for (int iy = _1222; iy <= search_dist; iy++)
        {
            int _1233 = -search_dist;
            for (int ix = _1233; ix <= search_dist; ix++)
            {
                if ((ix == 0) && (iy == 0))
                {
                    continue;
                }
                wd = min(wd, texelFetch(sWireframeDepth, ivec2(pixel_pos) + ivec2(ix, iy), 0).x);
                wc = max(wc, texelFetch(sWireframeColor, ivec2(pixel_pos) + ivec2(ix, iy), 0).xyz);
            }
        }
        if (wd < 1.0)
        {
            bool _1284 = wd < depth;
            bool _1293;
            if (!_1284)
            {
                _1293 = (wd >= depth) && is_background;
            }
            else
            {
                _1293 = _1284;
            }
            if (_1293)
            {
                color.x = wc.x;
                color.y = wc.y;
                color.z = wc.z;
            }
            else
            {
                if (wd < 1.0)
                {
                    float pattern = step(0.5, fract((((_1312.globals.global_time * float(pixel_pos.x)) * _69.dispatch_setup.inv_resolution.x) + ((_1312.globals.global_time * float(pixel_pos.y)) * _69.dispatch_setup.inv_resolution.y)) * 0.300000011920928955078125));
                    vec4 _1341 = color;
                    vec3 _1344 = mix((wc * pattern) * 0.1500000059604644775390625, _1341.xyz, vec3(0.5));
                    color.x = _1344.x;
                    color.y = _1344.y;
                    color.z = _1344.z;
                }
            }
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 