#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    float _pad0;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _98;

layout(set = 0, binding = 2, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _135;

layout(set = 0, binding = 8, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _170;

layout(set = 0, binding = 3, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _193;

layout(set = 0, binding = 4, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _239;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _359;

layout(set = 0, binding = 6, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _403;

layout(set = 0, binding = 7, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _414;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _135.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _135.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _83 = hash(param);
    uint param_1 = _83;
    float _85 = floatConstruct(param_1);
    return _85;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_98.in_vtx_data[coord_offset + 0u], _98.in_vtx_data[coord_offset + 1u], _98.in_vtx_data[coord_offset + 2u]);
    return p;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _175;
    _175.seed = _170.instancing_generator_params.seed;
    _175.transformed_data_location_idx = _170.instancing_generator_params.transformed_data_location_idx;
    _175.transformed_data_location_num = _170.instancing_generator_params.transformed_data_location_num;
    _175.surface_distance = _170.instancing_generator_params.surface_distance;
    _175.instance_scale = _170.instancing_generator_params.instance_scale;
    _175._pad0 = _170.instancing_generator_params._pad0;
    InstancingGeneratorParams param = _175;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _181;
    _181.seed = _170.instancing_generator_params.seed;
    _181.transformed_data_location_idx = _170.instancing_generator_params.transformed_data_location_idx;
    _181.transformed_data_location_num = _170.instancing_generator_params.transformed_data_location_num;
    _181.surface_distance = _170.instancing_generator_params.surface_distance;
    _181.instance_scale = _170.instancing_generator_params.instance_scale;
    _181._pad0 = _170.instancing_generator_params._pad0;
    InstancingGeneratorParams param_1 = _181;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    int _197 = atomicAdd(_193.instance_params.instance_count, 1);
    uint instance_id = uint(_197);
    if (instance_id >= uint(_193.instance_params.buffer_capacity))
    {
        return;
    }
    float fid = float(id);
    float fid_seed = ((fid * 0.0131700001657009124755859375) + float(_170.instancing_generator_params.seed)) * 0.00113200000487267971038818359375;
    float param_2 = fid_seed;
    uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_2));
    face_idx += first_face_idx;
    uint p0_idx = _239.transformed_data_indices[(face_idx * 3u) + 0u];
    uint p1_idx = _239.transformed_data_indices[(face_idx * 3u) + 1u];
    uint p2_idx = _239.transformed_data_indices[(face_idx * 3u) + 2u];
    uint param_3 = p0_idx;
    vec3 p0 = rt_get_vertex(param_3);
    uint param_4 = p1_idx;
    vec3 p1 = rt_get_vertex(param_4);
    uint param_5 = p2_idx;
    vec3 p2 = rt_get_vertex(param_5);
    float param_6 = fid_seed * 0.34130001068115234375;
    vec3 bc;
    bc.x = random(param_6);
    float param_7 = fid_seed * 0.1412999927997589111328125;
    bc.y = random(param_7);
    if ((bc.x + bc.y) >= 1.0)
    {
        bc.x = 1.0 - bc.x;
        bc.y = 1.0 - bc.y;
    }
    vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
    vec3 nx = normalize(p0 - p2);
    vec3 ny = normalize(p0 - p1);
    vec3 nz = normalize(cross(nx, ny));
    ny = cross(nz, nx);
    pos -= (nz * _170.instancing_generator_params.surface_distance);
    nx *= _170.instancing_generator_params.instance_scale.x;
    ny *= _170.instancing_generator_params.instance_scale.y;
    nz *= _170.instancing_generator_params.instance_scale.z;
    _359.instance_transform[(instance_id * 3u) + 0u] = vec4(nx.x, ny.x, nz.x, pos.x);
    _359.instance_transform[(instance_id * 3u) + 1u] = vec4(nx.y, ny.y, nz.y, pos.y);
    _359.instance_transform[(instance_id * 3u) + 2u] = vec4(nx.z, ny.z, nz.z, pos.z);
    _403.instance_hash[instance_id] = floatBitsToUint(fid_seed);
    vec4 c = vec4(1.0);
    _414.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(c.xy);
    _414.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(c.zw);
}

 