#version 450

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _46
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _77;

layout(set = 1, binding = 3) uniform sampler2D material_textures[64];

layout(location = 1) in _46 vtx_input;

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    if (material.albedo_sampler != (-1))
    {
        vec4 v = texture(material_textures[material.albedo_sampler], vtx_input.vUV0);
        if (v.w > 0.5)
        {
            return true;
        }
    }
    return false;
}

void main()
{
    MaterialPropertiesGPU _85;
    _85.diffuse = materials.material_properties[_77.materialIndex].diffuse;
    _85.transparency = materials.material_properties[_77.materialIndex].transparency;
    _85.emissive = materials.material_properties[_77.materialIndex].emissive;
    _85.roughness = materials.material_properties[_77.materialIndex].roughness;
    _85.triplanar_factor = materials.material_properties[_77.materialIndex].triplanar_factor;
    _85.refraction = materials.material_properties[_77.materialIndex].refraction;
    _85.normal_factor = materials.material_properties[_77.materialIndex].normal_factor;
    _85.emissive_factor = materials.material_properties[_77.materialIndex].emissive_factor;
    _85.temporal_accumulation_factor = materials.material_properties[_77.materialIndex].temporal_accumulation_factor;
    _85.shadowmap_bias = materials.material_properties[_77.materialIndex].shadowmap_bias;
    _85.metalness = materials.material_properties[_77.materialIndex].metalness;
    _85.albedo_sampler = materials.material_properties[_77.materialIndex].albedo_sampler;
    _85.emissive_sampler = materials.material_properties[_77.materialIndex].emissive_sampler;
    _85.normal_sampler = materials.material_properties[_77.materialIndex].normal_sampler;
    _85.metalic_roughness_sampler = materials.material_properties[_77.materialIndex].metalic_roughness_sampler;
    _85.flags = materials.material_properties[_77.materialIndex].flags;
    _85._pad0 = materials.material_properties[_77.materialIndex]._pad0;
    _85._pad1 = materials.material_properties[_77.materialIndex]._pad1;
    MaterialPropertiesGPU material = _85;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = vtx_input.vWorldPos;
    vec3 param_2 = vtx_input.vLocalPos;
    vec3 param_3 = vtx_input.vNorm;
    vec3 param_4 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param, param_1, param_2, param_3, param_4);
    if (to_discard)
    {
        discard;
    }
}

 