#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) buffer GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _15;

layout(set = 0, binding = 6, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _25;

layout(set = 0, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _50;

layout(set = 0, binding = 2, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _85;

layout(set = 0, binding = 3, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _203;

layout(set = 0, binding = 4, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _211;

layout(set = 0, binding = 5, std430) buffer IndexBuffer
{
    uint vtx_indices[];
} _219;

void main()
{
    uint faces_per_instance = _15.geometry_information.faces_num_per_surface[_25.transform_geometry_params.surface_idx];
    uint points_per_instance = _15.geometry_information.vtx_num;
    uint instance_id = gl_GlobalInvocationID.x / faces_per_instance;
    if (instance_id >= uint(_50.instance_params.instance_count))
    {
        return;
    }
    uint in_face_idx = gl_GlobalInvocationID.x - (instance_id * faces_per_instance);
    uint prim_idx = _25.transform_geometry_params.instance_idx;
    uint out_face_idx = gl_GlobalInvocationID.x;
    uint base_vtx_idx = 0u;
    if (out_face_idx == 0u)
    {
        _85.transformed_data_location[prim_idx].surface_idx = _25.transform_geometry_params.surface_idx;
        _85.transformed_data_location[prim_idx].material_idx = _25.transform_geometry_params.material_idx;
        _85.transformed_data_location[prim_idx].raytrace = _25.transform_geometry_params.raytrace;
        _85.transformed_data_location[prim_idx].voxelize = _25.transform_geometry_params.voxelize;
        if (_25.transform_geometry_params.initialize_bbox != 0u)
        {
            _85.transformed_data_location[prim_idx].bbox_min = ivec4(1073741824, 1073741824, 1073741824, 0);
            _85.transformed_data_location[prim_idx].bbox_max = ivec4(-1073741824, -1073741824, -1073741824, 0);
        }
        if (_25.transform_geometry_params.surface_idx > 0u)
        {
            _85.transformed_data_location[prim_idx].last_vtx_idx = _85.transformed_data_location[prim_idx - 1u].last_vtx_idx;
        }
    }
    if (prim_idx == 0u)
    {
        if (out_face_idx == 0u)
        {
            _85.transformed_data_location[prim_idx].last_face_idx = (uint(_50.instance_params.instance_count) * faces_per_instance) - 1u;
        }
        out_face_idx = out_face_idx;
    }
    else
    {
        if (out_face_idx == 0u)
        {
            _85.transformed_data_location[prim_idx].last_face_idx = (_85.transformed_data_location[prim_idx - 1u].last_face_idx + (uint(_50.instance_params.instance_count) * faces_per_instance)) - 1u;
        }
        out_face_idx = (_85.transformed_data_location[prim_idx - 1u].last_face_idx + out_face_idx) + 1u;
        if (((int(prim_idx) - 1) - int(_25.transform_geometry_params.surface_idx)) >= 0)
        {
            base_vtx_idx = _85.transformed_data_location[(prim_idx - 1u) - _25.transform_geometry_params.surface_idx].last_vtx_idx + 1u;
        }
    }
    uint instance_base_vtx = instance_id * points_per_instance;
    base_vtx_idx += instance_base_vtx;
    _203.transformed_data_faces[out_face_idx].material_idx = _25.transform_geometry_params.material_idx;
    _211.transformed_data_indices[(out_face_idx * 3u) + 0u] = _219.vtx_indices[(in_face_idx * 3u) + 0u] + base_vtx_idx;
    _211.transformed_data_indices[(out_face_idx * 3u) + 1u] = _219.vtx_indices[(in_face_idx * 3u) + 1u] + base_vtx_idx;
    _211.transformed_data_indices[(out_face_idx * 3u) + 2u] = _219.vtx_indices[(in_face_idx * 3u) + 2u] + base_vtx_idx;
}

 