#version 450

struct PostDepthOfFieldParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float focus_point;
    float focus_scale;
    float far_plane;
    int debug_blur_size;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform PostDepthOfFieldParamsBuffer
{
    PostDepthOfFieldParams dof_params;
} _37;

layout(set = 1, binding = 2) uniform sampler2D sCoCDepth;
layout(set = 1, binding = 3) uniform sampler2D sColor;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

vec3 depthOfField(vec2 texCoord, float focusPoint, float focusScale)
{
    vec2 coc_depth = texture(sCoCDepth, texCoord).xy;
    float centerDepth = coc_depth.y * _37.dof_params.far_plane;
    float centerSize = coc_depth.x;
    vec3 color = texture(sColor, texCoord).xyz;
    if (_37.dof_params.debug_blur_size != 0)
    {
        return vec3(centerSize * 0.00999999977648258209228515625);
    }
    if (focusPoint == 0.0)
    {
        return color;
    }
    float tot = 1.0;
    float radius = 0.449999988079071044921875;
    for (float ang = 0.0; radius < 8.0; ang += 2.3999631404876708984375)
    {
        vec2 tc = texCoord + ((vec2(cos(ang), sin(ang)) * _37.dof_params.inv_resolution) * radius);
        vec3 sampleColor = texture(sColor, tc).xyz;
        coc_depth = texture(sCoCDepth, tc).xy;
        float sampleDepth = coc_depth.y * _37.dof_params.far_plane;
        float sampleSize = coc_depth.x;
        if (sampleDepth > centerDepth)
        {
            sampleSize = clamp(sampleSize, 0.0, centerSize * 2.0);
        }
        float m = smoothstep(radius - 0.5, radius + 0.5, sampleSize);
        color += mix(color / vec3(tot), sampleColor, vec3(m));
        tot += 1.0;
        radius += (0.449999988079071044921875 / radius);
    }
    vec3 _159 = color;
    vec3 _161 = _159 / vec3(tot);
    color = _161;
    return _161;
}

void main()
{
    vec2 param = vTexcoord0;
    float param_1 = _37.dof_params.focus_point;
    float param_2 = _37.dof_params.focus_scale;
    vec3 c = depthOfField(param, param_1, param_2);
    outColor = vec4(c, 1.0);
}

 