#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _28;

layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    float f = (1.0 - (gl_FragCoord.x * _28.params.resolutionInv.x)) + (_28.params.param1 / 50.0);
    float range_min = 0.0 + (_28.params.param2 / 100.0);
    float range_max = 1.0 - (_28.params.param2 / 100.0);
    outColor = vec4(smoothstep(range_min, range_max, f - range_max));
}

 