#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

const float _57[5] = float[](0.0625, 0.25, 0.375, 0.25, 0.0625);
const int _76[5] = int[](-2, -1, 0, 1, 2);

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
};

layout(set = 0, binding = 2) uniform sampler2D sSource;
layout(set = 0, binding = 1, r32f) uniform writeonly image2D imDest;

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    float c = 0.0;
    float c_w = 0.0;
    for (int iy = 0; iy < 5; iy++)
    {
        for (int ix = 0; ix < 5; ix++)
        {
            float w = _57[ix] * _57[iy];
            ivec2 c_p = ivec2(_76[ix], _76[iy]);
            c_w += w;
            c += (texelFetch(sSource, ivec2(pixel_pos) + c_p, 0).x * w);
        }
    }
    imageStore(imDest, ivec2(pixel_pos), vec4(c / c_w));
}

 