#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 8) in;

struct link_list_node
{
    uint value;
    uint next;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

layout(set = 0, binding = 1, std430) buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _16;

layout(set = 0, binding = 2, std430) buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    link_list_node node_buffer[];
} in_faces_list_data;

void link_list_init(uint list_index)
{
    _16.in_faces_list_tails_data[list_index] = 4294967295u;
}

void main()
{
    uint workgroup_index = (gl_WorkGroupID.x + (gl_WorkGroupID.y * gl_NumWorkGroups.x)) + ((gl_WorkGroupID.z * gl_NumWorkGroups.x) * gl_NumWorkGroups.y);
    int grid_x = int(gl_WorkGroupID.x) * 8;
    int grid_y = int(gl_WorkGroupID.y) * 8;
    int grid_z = int(gl_WorkGroupID.z) * 8;
    uint cell_id_base = uint(((65536 * grid_z) + (256 * grid_y)) + grid_x);
    uint cell_id_local = ((65536u * gl_LocalInvocationID.z) + (256u * gl_LocalInvocationID.y)) + gl_LocalInvocationID.x;
    uint param = uint(int(cell_id_base + cell_id_local));
    link_list_init(param);
    in_faces_list_data.buffer_counter = 0u;
    memoryBarrierShared();
    barrier();
    memoryBarrier();
}

 